/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAI;
import com.atlan.model.assets.IAIApplication;
import com.atlan.model.assets.IAIModel;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AIModelStatus;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.EthicalAIAccountabilityConfig;
import com.atlan.model.enums.EthicalAIBiasMitigationConfig;
import com.atlan.model.enums.EthicalAIEnvironmentalConsciousnessConfig;
import com.atlan.model.enums.EthicalAIFairnessConfig;
import com.atlan.model.enums.EthicalAIPrivacyConfig;
import com.atlan.model.enums.EthicalAIReliabilityAndSafetyConfig;
import com.atlan.model.enums.EthicalAITransparencyConfig;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIModel
extends Asset
implements IAIModel,
IAI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AIModel.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AIModel";
    String typeName;
    @Attribute
    String aiModelDatasetsDSL;
    @Attribute
    AIModelStatus aiModelStatus;
    @Attribute
    String aiModelVersion;
    @Attribute
    SortedSet<IAIApplication> applications;
    @Attribute
    EthicalAIAccountabilityConfig ethicalAIAccountabilityConfig;
    @Attribute
    EthicalAIBiasMitigationConfig ethicalAIBiasMitigationConfig;
    @Attribute
    EthicalAIEnvironmentalConsciousnessConfig ethicalAIEnvironmentalConsciousnessConfig;
    @Attribute
    EthicalAIFairnessConfig ethicalAIFairnessConfig;
    @Attribute
    EthicalAIPrivacyConfig ethicalAIPrivacyConfig;
    @Attribute
    EthicalAIReliabilityAndSafetyConfig ethicalAIReliabilityAndSafetyConfig;
    @Attribute
    EthicalAITransparencyConfig ethicalAITransparencyConfig;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AIModel trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AIModel.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AIModel.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AIModel.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AIModel.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AIModel refByGuid(String guid) {
        return AIModel.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AIModel refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AIModelBuilder)((AIModelBuilder)AIModel._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AIModel refByQualifiedName(String qualifiedName) {
        return AIModel.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AIModel refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AIModelBuilder)((AIModelBuilder)AIModel._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AIModel get(AtlanClient client, String id) throws AtlanException {
        return AIModel.get(client, id, false);
    }

    @JsonIgnore
    public static AIModel get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AIModel) {
                return (AIModel)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AIModel) {
            return (AIModel)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AIModel get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AIModel.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AIModel get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AIModel.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AIModel) {
                return (AIModel)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AIModel.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AIModel) {
            return (AIModel)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AIModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AIModelBuilder)((AIModelBuilder)((AIModelBuilder)AIModel._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AIModelBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AIModel.validateRequired(TYPE_NAME, map);
        return AIModel.updater(this.getQualifiedName(), this.getName());
    }

    public static AIModel removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AIModel)Asset.removeDescription(client, AIModel.updater(qualifiedName, name));
    }

    public static AIModel removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AIModel)Asset.removeUserDescription(client, AIModel.updater(qualifiedName, name));
    }

    public static AIModel removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AIModel)Asset.removeOwners(client, AIModel.updater(qualifiedName, name));
    }

    public static AIModel updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AIModel)Asset.updateCertificate(client, AIModel._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AIModel removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AIModel)Asset.removeCertificate(client, AIModel.updater(qualifiedName, name));
    }

    public static AIModel updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AIModel)Asset.updateAnnouncement(client, AIModel._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AIModel removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AIModel)Asset.removeAnnouncement(client, AIModel.updater(qualifiedName, name));
    }

    public static AIModel replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AIModel)Asset.replaceTerms(client, AIModel.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AIModel appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AIModel)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AIModel removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AIModel)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AIModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AIModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AIModel appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AIModel)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AIModel(AIModelBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AIModel.$default$typeName();
        this.aiModelDatasetsDSL = b.aiModelDatasetsDSL;
        this.aiModelStatus = b.aiModelStatus;
        this.aiModelVersion = b.aiModelVersion;
        SortedSet<IAIApplication> applications = new TreeSet<IAIApplication>();
        if (b.applications != null) {
            applications.addAll(b.applications);
        }
        applications = Collections.unmodifiableSortedSet(applications);
        this.applications = applications;
        this.ethicalAIAccountabilityConfig = b.ethicalAIAccountabilityConfig;
        this.ethicalAIBiasMitigationConfig = b.ethicalAIBiasMitigationConfig;
        this.ethicalAIEnvironmentalConsciousnessConfig = b.ethicalAIEnvironmentalConsciousnessConfig;
        this.ethicalAIFairnessConfig = b.ethicalAIFairnessConfig;
        this.ethicalAIPrivacyConfig = b.ethicalAIPrivacyConfig;
        this.ethicalAIReliabilityAndSafetyConfig = b.ethicalAIReliabilityAndSafetyConfig;
        this.ethicalAITransparencyConfig = b.ethicalAITransparencyConfig;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AIModelBuilder<?, ?> _internal() {
        return new AIModelBuilderImpl();
    }

    @Generated
    public AIModelBuilder<?, ?> toBuilder() {
        return new AIModelBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAiModelDatasetsDSL() {
        return this.aiModelDatasetsDSL;
    }

    @Override
    @Generated
    public AIModelStatus getAiModelStatus() {
        return this.aiModelStatus;
    }

    @Override
    @Generated
    public String getAiModelVersion() {
        return this.aiModelVersion;
    }

    @Override
    @Generated
    public SortedSet<IAIApplication> getApplications() {
        return this.applications;
    }

    @Override
    @Generated
    public EthicalAIAccountabilityConfig getEthicalAIAccountabilityConfig() {
        return this.ethicalAIAccountabilityConfig;
    }

    @Override
    @Generated
    public EthicalAIBiasMitigationConfig getEthicalAIBiasMitigationConfig() {
        return this.ethicalAIBiasMitigationConfig;
    }

    @Override
    @Generated
    public EthicalAIEnvironmentalConsciousnessConfig getEthicalAIEnvironmentalConsciousnessConfig() {
        return this.ethicalAIEnvironmentalConsciousnessConfig;
    }

    @Override
    @Generated
    public EthicalAIFairnessConfig getEthicalAIFairnessConfig() {
        return this.ethicalAIFairnessConfig;
    }

    @Override
    @Generated
    public EthicalAIPrivacyConfig getEthicalAIPrivacyConfig() {
        return this.ethicalAIPrivacyConfig;
    }

    @Override
    @Generated
    public EthicalAIReliabilityAndSafetyConfig getEthicalAIReliabilityAndSafetyConfig() {
        return this.ethicalAIReliabilityAndSafetyConfig;
    }

    @Override
    @Generated
    public EthicalAITransparencyConfig getEthicalAITransparencyConfig() {
        return this.ethicalAITransparencyConfig;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AIModel)) {
            return false;
        }
        AIModel other = (AIModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$aiModelDatasetsDSL = this.getAiModelDatasetsDSL();
        String other$aiModelDatasetsDSL = other.getAiModelDatasetsDSL();
        if (this$aiModelDatasetsDSL == null ? other$aiModelDatasetsDSL != null : !this$aiModelDatasetsDSL.equals(other$aiModelDatasetsDSL)) {
            return false;
        }
        AIModelStatus this$aiModelStatus = this.getAiModelStatus();
        AIModelStatus other$aiModelStatus = other.getAiModelStatus();
        if (this$aiModelStatus == null ? other$aiModelStatus != null : !this$aiModelStatus.equals(other$aiModelStatus)) {
            return false;
        }
        String this$aiModelVersion = this.getAiModelVersion();
        String other$aiModelVersion = other.getAiModelVersion();
        if (this$aiModelVersion == null ? other$aiModelVersion != null : !this$aiModelVersion.equals(other$aiModelVersion)) {
            return false;
        }
        SortedSet<IAIApplication> this$applications = this.getApplications();
        SortedSet<IAIApplication> other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !this$applications.equals(other$applications)) {
            return false;
        }
        EthicalAIAccountabilityConfig this$ethicalAIAccountabilityConfig = this.getEthicalAIAccountabilityConfig();
        EthicalAIAccountabilityConfig other$ethicalAIAccountabilityConfig = other.getEthicalAIAccountabilityConfig();
        if (this$ethicalAIAccountabilityConfig == null ? other$ethicalAIAccountabilityConfig != null : !this$ethicalAIAccountabilityConfig.equals(other$ethicalAIAccountabilityConfig)) {
            return false;
        }
        EthicalAIBiasMitigationConfig this$ethicalAIBiasMitigationConfig = this.getEthicalAIBiasMitigationConfig();
        EthicalAIBiasMitigationConfig other$ethicalAIBiasMitigationConfig = other.getEthicalAIBiasMitigationConfig();
        if (this$ethicalAIBiasMitigationConfig == null ? other$ethicalAIBiasMitigationConfig != null : !this$ethicalAIBiasMitigationConfig.equals(other$ethicalAIBiasMitigationConfig)) {
            return false;
        }
        EthicalAIEnvironmentalConsciousnessConfig this$ethicalAIEnvironmentalConsciousnessConfig = this.getEthicalAIEnvironmentalConsciousnessConfig();
        EthicalAIEnvironmentalConsciousnessConfig other$ethicalAIEnvironmentalConsciousnessConfig = other.getEthicalAIEnvironmentalConsciousnessConfig();
        if (this$ethicalAIEnvironmentalConsciousnessConfig == null ? other$ethicalAIEnvironmentalConsciousnessConfig != null : !this$ethicalAIEnvironmentalConsciousnessConfig.equals(other$ethicalAIEnvironmentalConsciousnessConfig)) {
            return false;
        }
        EthicalAIFairnessConfig this$ethicalAIFairnessConfig = this.getEthicalAIFairnessConfig();
        EthicalAIFairnessConfig other$ethicalAIFairnessConfig = other.getEthicalAIFairnessConfig();
        if (this$ethicalAIFairnessConfig == null ? other$ethicalAIFairnessConfig != null : !this$ethicalAIFairnessConfig.equals(other$ethicalAIFairnessConfig)) {
            return false;
        }
        EthicalAIPrivacyConfig this$ethicalAIPrivacyConfig = this.getEthicalAIPrivacyConfig();
        EthicalAIPrivacyConfig other$ethicalAIPrivacyConfig = other.getEthicalAIPrivacyConfig();
        if (this$ethicalAIPrivacyConfig == null ? other$ethicalAIPrivacyConfig != null : !this$ethicalAIPrivacyConfig.equals(other$ethicalAIPrivacyConfig)) {
            return false;
        }
        EthicalAIReliabilityAndSafetyConfig this$ethicalAIReliabilityAndSafetyConfig = this.getEthicalAIReliabilityAndSafetyConfig();
        EthicalAIReliabilityAndSafetyConfig other$ethicalAIReliabilityAndSafetyConfig = other.getEthicalAIReliabilityAndSafetyConfig();
        if (this$ethicalAIReliabilityAndSafetyConfig == null ? other$ethicalAIReliabilityAndSafetyConfig != null : !this$ethicalAIReliabilityAndSafetyConfig.equals(other$ethicalAIReliabilityAndSafetyConfig)) {
            return false;
        }
        EthicalAITransparencyConfig this$ethicalAITransparencyConfig = this.getEthicalAITransparencyConfig();
        EthicalAITransparencyConfig other$ethicalAITransparencyConfig = other.getEthicalAITransparencyConfig();
        if (this$ethicalAITransparencyConfig == null ? other$ethicalAITransparencyConfig != null : !this$ethicalAITransparencyConfig.equals(other$ethicalAITransparencyConfig)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AIModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $aiModelDatasetsDSL = this.getAiModelDatasetsDSL();
        result = result * 59 + ($aiModelDatasetsDSL == null ? 43 : $aiModelDatasetsDSL.hashCode());
        AIModelStatus $aiModelStatus = this.getAiModelStatus();
        result = result * 59 + ($aiModelStatus == null ? 43 : $aiModelStatus.hashCode());
        String $aiModelVersion = this.getAiModelVersion();
        result = result * 59 + ($aiModelVersion == null ? 43 : $aiModelVersion.hashCode());
        SortedSet<IAIApplication> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : $applications.hashCode());
        EthicalAIAccountabilityConfig $ethicalAIAccountabilityConfig = this.getEthicalAIAccountabilityConfig();
        result = result * 59 + ($ethicalAIAccountabilityConfig == null ? 43 : $ethicalAIAccountabilityConfig.hashCode());
        EthicalAIBiasMitigationConfig $ethicalAIBiasMitigationConfig = this.getEthicalAIBiasMitigationConfig();
        result = result * 59 + ($ethicalAIBiasMitigationConfig == null ? 43 : $ethicalAIBiasMitigationConfig.hashCode());
        EthicalAIEnvironmentalConsciousnessConfig $ethicalAIEnvironmentalConsciousnessConfig = this.getEthicalAIEnvironmentalConsciousnessConfig();
        result = result * 59 + ($ethicalAIEnvironmentalConsciousnessConfig == null ? 43 : $ethicalAIEnvironmentalConsciousnessConfig.hashCode());
        EthicalAIFairnessConfig $ethicalAIFairnessConfig = this.getEthicalAIFairnessConfig();
        result = result * 59 + ($ethicalAIFairnessConfig == null ? 43 : $ethicalAIFairnessConfig.hashCode());
        EthicalAIPrivacyConfig $ethicalAIPrivacyConfig = this.getEthicalAIPrivacyConfig();
        result = result * 59 + ($ethicalAIPrivacyConfig == null ? 43 : $ethicalAIPrivacyConfig.hashCode());
        EthicalAIReliabilityAndSafetyConfig $ethicalAIReliabilityAndSafetyConfig = this.getEthicalAIReliabilityAndSafetyConfig();
        result = result * 59 + ($ethicalAIReliabilityAndSafetyConfig == null ? 43 : $ethicalAIReliabilityAndSafetyConfig.hashCode());
        EthicalAITransparencyConfig $ethicalAITransparencyConfig = this.getEthicalAITransparencyConfig();
        result = result * 59 + ($ethicalAITransparencyConfig == null ? 43 : $ethicalAITransparencyConfig.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AIModel(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", aiModelDatasetsDSL=" + this.getAiModelDatasetsDSL() + ", aiModelStatus=" + String.valueOf(this.getAiModelStatus()) + ", aiModelVersion=" + this.getAiModelVersion() + ", applications=" + String.valueOf(this.getApplications()) + ", ethicalAIAccountabilityConfig=" + String.valueOf(this.getEthicalAIAccountabilityConfig()) + ", ethicalAIBiasMitigationConfig=" + String.valueOf(this.getEthicalAIBiasMitigationConfig()) + ", ethicalAIEnvironmentalConsciousnessConfig=" + String.valueOf(this.getEthicalAIEnvironmentalConsciousnessConfig()) + ", ethicalAIFairnessConfig=" + String.valueOf(this.getEthicalAIFairnessConfig()) + ", ethicalAIPrivacyConfig=" + String.valueOf(this.getEthicalAIPrivacyConfig()) + ", ethicalAIReliabilityAndSafetyConfig=" + String.valueOf(this.getEthicalAIReliabilityAndSafetyConfig()) + ", ethicalAITransparencyConfig=" + String.valueOf(this.getEthicalAITransparencyConfig()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AIModelBuilder<C extends AIModel, B extends AIModelBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String aiModelDatasetsDSL;
        @Generated
        private AIModelStatus aiModelStatus;
        @Generated
        private String aiModelVersion;
        @Generated
        private ArrayList<IAIApplication> applications;
        @Generated
        private EthicalAIAccountabilityConfig ethicalAIAccountabilityConfig;
        @Generated
        private EthicalAIBiasMitigationConfig ethicalAIBiasMitigationConfig;
        @Generated
        private EthicalAIEnvironmentalConsciousnessConfig ethicalAIEnvironmentalConsciousnessConfig;
        @Generated
        private EthicalAIFairnessConfig ethicalAIFairnessConfig;
        @Generated
        private EthicalAIPrivacyConfig ethicalAIPrivacyConfig;
        @Generated
        private EthicalAIReliabilityAndSafetyConfig ethicalAIReliabilityAndSafetyConfig;
        @Generated
        private EthicalAITransparencyConfig ethicalAITransparencyConfig;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AIModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AIModel instance, AIModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.aiModelDatasetsDSL(instance.aiModelDatasetsDSL);
            b.aiModelStatus(instance.aiModelStatus);
            b.aiModelVersion(instance.aiModelVersion);
            b.applications(instance.applications == null ? Collections.emptySortedSet() : instance.applications);
            b.ethicalAIAccountabilityConfig(instance.ethicalAIAccountabilityConfig);
            b.ethicalAIBiasMitigationConfig(instance.ethicalAIBiasMitigationConfig);
            b.ethicalAIEnvironmentalConsciousnessConfig(instance.ethicalAIEnvironmentalConsciousnessConfig);
            b.ethicalAIFairnessConfig(instance.ethicalAIFairnessConfig);
            b.ethicalAIPrivacyConfig(instance.ethicalAIPrivacyConfig);
            b.ethicalAIReliabilityAndSafetyConfig(instance.ethicalAIReliabilityAndSafetyConfig);
            b.ethicalAITransparencyConfig(instance.ethicalAITransparencyConfig);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B aiModelDatasetsDSL(String aiModelDatasetsDSL) {
            this.aiModelDatasetsDSL = aiModelDatasetsDSL;
            return (B)this.self();
        }

        @Generated
        public B aiModelStatus(AIModelStatus aiModelStatus) {
            this.aiModelStatus = aiModelStatus;
            return (B)this.self();
        }

        @Generated
        public B aiModelVersion(String aiModelVersion) {
            this.aiModelVersion = aiModelVersion;
            return (B)this.self();
        }

        @Generated
        public B aiApplication(IAIApplication aiApplication) {
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.add(aiApplication);
            return (B)this.self();
        }

        @Generated
        public B applications(Collection<? extends IAIApplication> applications) {
            if (applications == null) {
                throw new NullPointerException("applications cannot be null");
            }
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.addAll(applications);
            return (B)this.self();
        }

        @Generated
        public B clearApplications() {
            if (this.applications != null) {
                this.applications.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ethicalAIAccountabilityConfig(EthicalAIAccountabilityConfig ethicalAIAccountabilityConfig) {
            this.ethicalAIAccountabilityConfig = ethicalAIAccountabilityConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAIBiasMitigationConfig(EthicalAIBiasMitigationConfig ethicalAIBiasMitigationConfig) {
            this.ethicalAIBiasMitigationConfig = ethicalAIBiasMitigationConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAIEnvironmentalConsciousnessConfig(EthicalAIEnvironmentalConsciousnessConfig ethicalAIEnvironmentalConsciousnessConfig) {
            this.ethicalAIEnvironmentalConsciousnessConfig = ethicalAIEnvironmentalConsciousnessConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAIFairnessConfig(EthicalAIFairnessConfig ethicalAIFairnessConfig) {
            this.ethicalAIFairnessConfig = ethicalAIFairnessConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAIPrivacyConfig(EthicalAIPrivacyConfig ethicalAIPrivacyConfig) {
            this.ethicalAIPrivacyConfig = ethicalAIPrivacyConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAIReliabilityAndSafetyConfig(EthicalAIReliabilityAndSafetyConfig ethicalAIReliabilityAndSafetyConfig) {
            this.ethicalAIReliabilityAndSafetyConfig = ethicalAIReliabilityAndSafetyConfig;
            return (B)this.self();
        }

        @Generated
        public B ethicalAITransparencyConfig(EthicalAITransparencyConfig ethicalAITransparencyConfig) {
            this.ethicalAITransparencyConfig = ethicalAITransparencyConfig;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AIModel.AIModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", aiModelDatasetsDSL=" + this.aiModelDatasetsDSL + ", aiModelStatus=" + String.valueOf(this.aiModelStatus) + ", aiModelVersion=" + this.aiModelVersion + ", applications=" + String.valueOf(this.applications) + ", ethicalAIAccountabilityConfig=" + String.valueOf(this.ethicalAIAccountabilityConfig) + ", ethicalAIBiasMitigationConfig=" + String.valueOf(this.ethicalAIBiasMitigationConfig) + ", ethicalAIEnvironmentalConsciousnessConfig=" + String.valueOf(this.ethicalAIEnvironmentalConsciousnessConfig) + ", ethicalAIFairnessConfig=" + String.valueOf(this.ethicalAIFairnessConfig) + ", ethicalAIPrivacyConfig=" + String.valueOf(this.ethicalAIPrivacyConfig) + ", ethicalAIReliabilityAndSafetyConfig=" + String.valueOf(this.ethicalAIReliabilityAndSafetyConfig) + ", ethicalAITransparencyConfig=" + String.valueOf(this.ethicalAITransparencyConfig) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AIModelBuilderImpl
    extends AIModelBuilder<AIModel, AIModelBuilderImpl> {
        @Generated
        private AIModelBuilderImpl() {
        }

        @Override
        @Generated
        protected AIModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AIModel build() {
            return new AIModel(this);
        }
    }
}

