/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAPI;
import com.atlan.model.assets.IAPIField;
import com.atlan.model.assets.IAPIQuery;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIQuery
extends Asset
implements IAPIQuery,
IAPI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(APIQuery.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APIQuery";
    String typeName;
    @Attribute
    Map<String, String> apiExternalDocs;
    @Attribute
    SortedSet<IAPIField> apiFields;
    @Attribute
    Long apiInputFieldCount;
    @Attribute
    Boolean apiIsAuthOptional;
    @Attribute
    Boolean apiIsObjectReference;
    @Attribute
    String apiObjectQualifiedName;
    @Attribute
    String apiQueryOutputType;
    @Attribute
    String apiQueryOutputTypeSecondary;
    @Attribute
    String apiSpecName;
    @Attribute
    String apiSpecQualifiedName;
    @Attribute
    String apiSpecType;
    @Attribute
    String apiSpecVersion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public APIQuery trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return APIQuery.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return APIQuery.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return APIQuery.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return APIQuery.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static APIQuery refByGuid(String guid) {
        return APIQuery.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static APIQuery refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((APIQueryBuilder)((APIQueryBuilder)APIQuery._internal().guid(guid)).semantic(semantic)).build();
    }

    public static APIQuery refByQualifiedName(String qualifiedName) {
        return APIQuery.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static APIQuery refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((APIQueryBuilder)((APIQueryBuilder)APIQuery._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static APIQuery get(AtlanClient client, String id) throws AtlanException {
        return APIQuery.get(client, id, false);
    }

    @JsonIgnore
    public static APIQuery get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof APIQuery) {
                return (APIQuery)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof APIQuery) {
            return (APIQuery)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static APIQuery get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return APIQuery.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static APIQuery get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)APIQuery.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof APIQuery) {
                return (APIQuery)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)APIQuery.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof APIQuery) {
            return (APIQuery)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static APIQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return (APIQueryBuilder)((APIQueryBuilder)((APIQueryBuilder)APIQuery._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public APIQueryBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        APIQuery.validateRequired(TYPE_NAME, map);
        return APIQuery.updater(this.getQualifiedName(), this.getName());
    }

    public static APIQuery removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIQuery)Asset.removeDescription(client, APIQuery.updater(qualifiedName, name));
    }

    public static APIQuery removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIQuery)Asset.removeUserDescription(client, APIQuery.updater(qualifiedName, name));
    }

    public static APIQuery removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIQuery)Asset.removeOwners(client, APIQuery.updater(qualifiedName, name));
    }

    public static APIQuery updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (APIQuery)Asset.updateCertificate(client, APIQuery._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static APIQuery removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIQuery)Asset.removeCertificate(client, APIQuery.updater(qualifiedName, name));
    }

    public static APIQuery updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APIQuery)Asset.updateAnnouncement(client, APIQuery._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static APIQuery removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (APIQuery)Asset.removeAnnouncement(client, APIQuery.updater(qualifiedName, name));
    }

    public static APIQuery replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIQuery)Asset.replaceTerms(client, APIQuery.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static APIQuery appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIQuery)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static APIQuery removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (APIQuery)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static APIQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (APIQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static APIQuery appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (APIQuery)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected APIQuery(APIQueryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> apiExternalDocs;
        this.typeName = b.typeName$set ? b.typeName$value : APIQuery.$default$typeName();
        switch (b.apiExternalDocs$key == null ? 0 : b.apiExternalDocs$key.size()) {
            case 0: {
                apiExternalDocs = Collections.emptyMap();
                break;
            }
            case 1: {
                apiExternalDocs = Collections.singletonMap(b.apiExternalDocs$key.get(0), b.apiExternalDocs$value.get(0));
                break;
            }
            default: {
                apiExternalDocs = new LinkedHashMap(b.apiExternalDocs$key.size() < 0x40000000 ? 1 + b.apiExternalDocs$key.size() + (b.apiExternalDocs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.apiExternalDocs$key.size(); ++$i) {
                    apiExternalDocs.put(b.apiExternalDocs$key.get($i), b.apiExternalDocs$value.get($i));
                }
                apiExternalDocs = Collections.unmodifiableMap(apiExternalDocs);
            }
        }
        this.apiExternalDocs = apiExternalDocs;
        SortedSet<IAPIField> apiFields = new TreeSet<IAPIField>();
        if (b.apiFields != null) {
            apiFields.addAll(b.apiFields);
        }
        apiFields = Collections.unmodifiableSortedSet(apiFields);
        this.apiFields = apiFields;
        this.apiInputFieldCount = b.apiInputFieldCount;
        this.apiIsAuthOptional = b.apiIsAuthOptional;
        this.apiIsObjectReference = b.apiIsObjectReference;
        this.apiObjectQualifiedName = b.apiObjectQualifiedName;
        this.apiQueryOutputType = b.apiQueryOutputType;
        this.apiQueryOutputTypeSecondary = b.apiQueryOutputTypeSecondary;
        this.apiSpecName = b.apiSpecName;
        this.apiSpecQualifiedName = b.apiSpecQualifiedName;
        this.apiSpecType = b.apiSpecType;
        this.apiSpecVersion = b.apiSpecVersion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static APIQueryBuilder<?, ?> _internal() {
        return new APIQueryBuilderImpl();
    }

    @Generated
    public APIQueryBuilder<?, ?> toBuilder() {
        return new APIQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getApiExternalDocs() {
        return this.apiExternalDocs;
    }

    @Override
    @Generated
    public SortedSet<IAPIField> getApiFields() {
        return this.apiFields;
    }

    @Override
    @Generated
    public Long getApiInputFieldCount() {
        return this.apiInputFieldCount;
    }

    @Override
    @Generated
    public Boolean getApiIsAuthOptional() {
        return this.apiIsAuthOptional;
    }

    @Override
    @Generated
    public Boolean getApiIsObjectReference() {
        return this.apiIsObjectReference;
    }

    @Override
    @Generated
    public String getApiObjectQualifiedName() {
        return this.apiObjectQualifiedName;
    }

    @Override
    @Generated
    public String getApiQueryOutputType() {
        return this.apiQueryOutputType;
    }

    @Override
    @Generated
    public String getApiQueryOutputTypeSecondary() {
        return this.apiQueryOutputTypeSecondary;
    }

    @Override
    @Generated
    public String getApiSpecName() {
        return this.apiSpecName;
    }

    @Override
    @Generated
    public String getApiSpecQualifiedName() {
        return this.apiSpecQualifiedName;
    }

    @Override
    @Generated
    public String getApiSpecType() {
        return this.apiSpecType;
    }

    @Override
    @Generated
    public String getApiSpecVersion() {
        return this.apiSpecVersion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIQuery)) {
            return false;
        }
        APIQuery other = (APIQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$apiInputFieldCount = this.getApiInputFieldCount();
        Long other$apiInputFieldCount = other.getApiInputFieldCount();
        if (this$apiInputFieldCount == null ? other$apiInputFieldCount != null : !((Object)this$apiInputFieldCount).equals(other$apiInputFieldCount)) {
            return false;
        }
        Boolean this$apiIsAuthOptional = this.getApiIsAuthOptional();
        Boolean other$apiIsAuthOptional = other.getApiIsAuthOptional();
        if (this$apiIsAuthOptional == null ? other$apiIsAuthOptional != null : !((Object)this$apiIsAuthOptional).equals(other$apiIsAuthOptional)) {
            return false;
        }
        Boolean this$apiIsObjectReference = this.getApiIsObjectReference();
        Boolean other$apiIsObjectReference = other.getApiIsObjectReference();
        if (this$apiIsObjectReference == null ? other$apiIsObjectReference != null : !((Object)this$apiIsObjectReference).equals(other$apiIsObjectReference)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$apiExternalDocs = this.getApiExternalDocs();
        Map<String, String> other$apiExternalDocs = other.getApiExternalDocs();
        if (this$apiExternalDocs == null ? other$apiExternalDocs != null : !((Object)this$apiExternalDocs).equals(other$apiExternalDocs)) {
            return false;
        }
        SortedSet<IAPIField> this$apiFields = this.getApiFields();
        SortedSet<IAPIField> other$apiFields = other.getApiFields();
        if (this$apiFields == null ? other$apiFields != null : !this$apiFields.equals(other$apiFields)) {
            return false;
        }
        String this$apiObjectQualifiedName = this.getApiObjectQualifiedName();
        String other$apiObjectQualifiedName = other.getApiObjectQualifiedName();
        if (this$apiObjectQualifiedName == null ? other$apiObjectQualifiedName != null : !this$apiObjectQualifiedName.equals(other$apiObjectQualifiedName)) {
            return false;
        }
        String this$apiQueryOutputType = this.getApiQueryOutputType();
        String other$apiQueryOutputType = other.getApiQueryOutputType();
        if (this$apiQueryOutputType == null ? other$apiQueryOutputType != null : !this$apiQueryOutputType.equals(other$apiQueryOutputType)) {
            return false;
        }
        String this$apiQueryOutputTypeSecondary = this.getApiQueryOutputTypeSecondary();
        String other$apiQueryOutputTypeSecondary = other.getApiQueryOutputTypeSecondary();
        if (this$apiQueryOutputTypeSecondary == null ? other$apiQueryOutputTypeSecondary != null : !this$apiQueryOutputTypeSecondary.equals(other$apiQueryOutputTypeSecondary)) {
            return false;
        }
        String this$apiSpecName = this.getApiSpecName();
        String other$apiSpecName = other.getApiSpecName();
        if (this$apiSpecName == null ? other$apiSpecName != null : !this$apiSpecName.equals(other$apiSpecName)) {
            return false;
        }
        String this$apiSpecQualifiedName = this.getApiSpecQualifiedName();
        String other$apiSpecQualifiedName = other.getApiSpecQualifiedName();
        if (this$apiSpecQualifiedName == null ? other$apiSpecQualifiedName != null : !this$apiSpecQualifiedName.equals(other$apiSpecQualifiedName)) {
            return false;
        }
        String this$apiSpecType = this.getApiSpecType();
        String other$apiSpecType = other.getApiSpecType();
        if (this$apiSpecType == null ? other$apiSpecType != null : !this$apiSpecType.equals(other$apiSpecType)) {
            return false;
        }
        String this$apiSpecVersion = this.getApiSpecVersion();
        String other$apiSpecVersion = other.getApiSpecVersion();
        if (this$apiSpecVersion == null ? other$apiSpecVersion != null : !this$apiSpecVersion.equals(other$apiSpecVersion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APIQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $apiInputFieldCount = this.getApiInputFieldCount();
        result = result * 59 + ($apiInputFieldCount == null ? 43 : ((Object)$apiInputFieldCount).hashCode());
        Boolean $apiIsAuthOptional = this.getApiIsAuthOptional();
        result = result * 59 + ($apiIsAuthOptional == null ? 43 : ((Object)$apiIsAuthOptional).hashCode());
        Boolean $apiIsObjectReference = this.getApiIsObjectReference();
        result = result * 59 + ($apiIsObjectReference == null ? 43 : ((Object)$apiIsObjectReference).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $apiExternalDocs = this.getApiExternalDocs();
        result = result * 59 + ($apiExternalDocs == null ? 43 : ((Object)$apiExternalDocs).hashCode());
        SortedSet<IAPIField> $apiFields = this.getApiFields();
        result = result * 59 + ($apiFields == null ? 43 : $apiFields.hashCode());
        String $apiObjectQualifiedName = this.getApiObjectQualifiedName();
        result = result * 59 + ($apiObjectQualifiedName == null ? 43 : $apiObjectQualifiedName.hashCode());
        String $apiQueryOutputType = this.getApiQueryOutputType();
        result = result * 59 + ($apiQueryOutputType == null ? 43 : $apiQueryOutputType.hashCode());
        String $apiQueryOutputTypeSecondary = this.getApiQueryOutputTypeSecondary();
        result = result * 59 + ($apiQueryOutputTypeSecondary == null ? 43 : $apiQueryOutputTypeSecondary.hashCode());
        String $apiSpecName = this.getApiSpecName();
        result = result * 59 + ($apiSpecName == null ? 43 : $apiSpecName.hashCode());
        String $apiSpecQualifiedName = this.getApiSpecQualifiedName();
        result = result * 59 + ($apiSpecQualifiedName == null ? 43 : $apiSpecQualifiedName.hashCode());
        String $apiSpecType = this.getApiSpecType();
        result = result * 59 + ($apiSpecType == null ? 43 : $apiSpecType.hashCode());
        String $apiSpecVersion = this.getApiSpecVersion();
        result = result * 59 + ($apiSpecVersion == null ? 43 : $apiSpecVersion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "APIQuery(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiExternalDocs=" + String.valueOf(this.getApiExternalDocs()) + ", apiFields=" + String.valueOf(this.getApiFields()) + ", apiInputFieldCount=" + this.getApiInputFieldCount() + ", apiIsAuthOptional=" + this.getApiIsAuthOptional() + ", apiIsObjectReference=" + this.getApiIsObjectReference() + ", apiObjectQualifiedName=" + this.getApiObjectQualifiedName() + ", apiQueryOutputType=" + this.getApiQueryOutputType() + ", apiQueryOutputTypeSecondary=" + this.getApiQueryOutputTypeSecondary() + ", apiSpecName=" + this.getApiSpecName() + ", apiSpecQualifiedName=" + this.getApiSpecQualifiedName() + ", apiSpecType=" + this.getApiSpecType() + ", apiSpecVersion=" + this.getApiSpecVersion() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class APIQueryBuilder<C extends APIQuery, B extends APIQueryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> apiExternalDocs$key;
        @Generated
        private ArrayList<String> apiExternalDocs$value;
        @Generated
        private ArrayList<IAPIField> apiFields;
        @Generated
        private Long apiInputFieldCount;
        @Generated
        private Boolean apiIsAuthOptional;
        @Generated
        private Boolean apiIsObjectReference;
        @Generated
        private String apiObjectQualifiedName;
        @Generated
        private String apiQueryOutputType;
        @Generated
        private String apiQueryOutputTypeSecondary;
        @Generated
        private String apiSpecName;
        @Generated
        private String apiSpecQualifiedName;
        @Generated
        private String apiSpecType;
        @Generated
        private String apiSpecVersion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            APIQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(APIQuery instance, APIQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiExternalDocs(instance.apiExternalDocs == null ? Collections.emptyMap() : instance.apiExternalDocs);
            b.apiFields(instance.apiFields == null ? Collections.emptySortedSet() : instance.apiFields);
            b.apiInputFieldCount(instance.apiInputFieldCount);
            b.apiIsAuthOptional(instance.apiIsAuthOptional);
            b.apiIsObjectReference(instance.apiIsObjectReference);
            b.apiObjectQualifiedName(instance.apiObjectQualifiedName);
            b.apiQueryOutputType(instance.apiQueryOutputType);
            b.apiQueryOutputTypeSecondary(instance.apiQueryOutputTypeSecondary);
            b.apiSpecName(instance.apiSpecName);
            b.apiSpecQualifiedName(instance.apiSpecQualifiedName);
            b.apiSpecType(instance.apiSpecType);
            b.apiSpecVersion(instance.apiSpecVersion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiExternalDoc(String apiExternalDocKey, String apiExternalDocValue) {
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            this.apiExternalDocs$key.add(apiExternalDocKey);
            this.apiExternalDocs$value.add(apiExternalDocValue);
            return (B)this.self();
        }

        @Generated
        public B apiExternalDocs(Map<? extends String, ? extends String> apiExternalDocs) {
            if (apiExternalDocs == null) {
                throw new NullPointerException("apiExternalDocs cannot be null");
            }
            if (this.apiExternalDocs$key == null) {
                this.apiExternalDocs$key = new ArrayList();
                this.apiExternalDocs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : apiExternalDocs.entrySet()) {
                this.apiExternalDocs$key.add($lombokEntry.getKey());
                this.apiExternalDocs$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearApiExternalDocs() {
            if (this.apiExternalDocs$key != null) {
                this.apiExternalDocs$key.clear();
                this.apiExternalDocs$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiField(IAPIField apiField) {
            if (this.apiFields == null) {
                this.apiFields = new ArrayList();
            }
            this.apiFields.add(apiField);
            return (B)this.self();
        }

        @Generated
        public B apiFields(Collection<? extends IAPIField> apiFields) {
            if (apiFields == null) {
                throw new NullPointerException("apiFields cannot be null");
            }
            if (this.apiFields == null) {
                this.apiFields = new ArrayList();
            }
            this.apiFields.addAll(apiFields);
            return (B)this.self();
        }

        @Generated
        public B clearApiFields() {
            if (this.apiFields != null) {
                this.apiFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiInputFieldCount(Long apiInputFieldCount) {
            this.apiInputFieldCount = apiInputFieldCount;
            return (B)this.self();
        }

        @Generated
        public B apiIsAuthOptional(Boolean apiIsAuthOptional) {
            this.apiIsAuthOptional = apiIsAuthOptional;
            return (B)this.self();
        }

        @Generated
        public B apiIsObjectReference(Boolean apiIsObjectReference) {
            this.apiIsObjectReference = apiIsObjectReference;
            return (B)this.self();
        }

        @Generated
        public B apiObjectQualifiedName(String apiObjectQualifiedName) {
            this.apiObjectQualifiedName = apiObjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B apiQueryOutputType(String apiQueryOutputType) {
            this.apiQueryOutputType = apiQueryOutputType;
            return (B)this.self();
        }

        @Generated
        public B apiQueryOutputTypeSecondary(String apiQueryOutputTypeSecondary) {
            this.apiQueryOutputTypeSecondary = apiQueryOutputTypeSecondary;
            return (B)this.self();
        }

        @Generated
        public B apiSpecName(String apiSpecName) {
            this.apiSpecName = apiSpecName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecQualifiedName(String apiSpecQualifiedName) {
            this.apiSpecQualifiedName = apiSpecQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecType(String apiSpecType) {
            this.apiSpecType = apiSpecType;
            return (B)this.self();
        }

        @Generated
        public B apiSpecVersion(String apiSpecVersion) {
            this.apiSpecVersion = apiSpecVersion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "APIQuery.APIQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiExternalDocs$key=" + String.valueOf(this.apiExternalDocs$key) + ", apiExternalDocs$value=" + String.valueOf(this.apiExternalDocs$value) + ", apiFields=" + String.valueOf(this.apiFields) + ", apiInputFieldCount=" + this.apiInputFieldCount + ", apiIsAuthOptional=" + this.apiIsAuthOptional + ", apiIsObjectReference=" + this.apiIsObjectReference + ", apiObjectQualifiedName=" + this.apiObjectQualifiedName + ", apiQueryOutputType=" + this.apiQueryOutputType + ", apiQueryOutputTypeSecondary=" + this.apiQueryOutputTypeSecondary + ", apiSpecName=" + this.apiSpecName + ", apiSpecQualifiedName=" + this.apiSpecQualifiedName + ", apiSpecType=" + this.apiSpecType + ", apiSpecVersion=" + this.apiSpecVersion + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class APIQueryBuilderImpl
    extends APIQueryBuilder<APIQuery, APIQueryBuilderImpl> {
        @Generated
        private APIQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected APIQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public APIQuery build() {
            return new APIQuery(this);
        }
    }
}

