/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADF;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAdfDataflow;
import com.atlan.model.assets.IAdfDataset;
import com.atlan.model.assets.IAdfLinkedservice;
import com.atlan.model.assets.IAdfPipeline;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AdfActivityState;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfActivity
extends Asset
implements IAdfActivity,
IADF,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdfActivity.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AdfActivity";
    String typeName;
    @Attribute
    Integer adfActivityBatchCount;
    @Attribute
    Boolean adfActivityFirstRowOnly;
    @Attribute
    Boolean adfActivityIsSequential;
    @Attribute
    String adfActivityMainClassName;
    @Attribute
    String adfActivityNotebookPath;
    @Attribute
    Integer adfActivityPolictRetryInterval;
    @Attribute
    String adfActivityPolicyTimeout;
    @Attribute
    @JsonProperty(value="adfActivityPrecedingDependency")
    SortedSet<String> adfActivityPrecedingDependencies;
    @Attribute
    String adfActivityPythonFilePath;
    @Attribute
    String adfActivityReferenceDataflow;
    @Attribute
    List<Map<String, String>> adfActivityRuns;
    @Attribute
    String adfActivitySinkType;
    @Attribute
    SortedSet<String> adfActivitySinks;
    @Attribute
    String adfActivitySourceType;
    @Attribute
    SortedSet<String> adfActivitySources;
    @Attribute
    AdfActivityState adfActivityState;
    @Attribute
    SortedSet<String> adfActivitySubActivities;
    @Attribute
    String adfActivityType;
    @Attribute
    String adfAssetFolderPath;
    @Attribute
    IAdfDataflow adfDataflow;
    @Attribute
    SortedSet<IAdfDataset> adfDatasets;
    @Attribute
    String adfFactoryName;
    @Attribute
    SortedSet<IAdfLinkedservice> adfLinkedservices;
    @Attribute
    IAdfPipeline adfPipeline;
    @Attribute
    String adfPipelineQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ILineageProcess> processes;

    @Override
    public AdfActivity trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AdfActivity.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AdfActivity.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AdfActivity.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AdfActivity.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AdfActivity refByGuid(String guid) {
        return AdfActivity.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AdfActivity refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AdfActivityBuilder)((AdfActivityBuilder)AdfActivity._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AdfActivity refByQualifiedName(String qualifiedName) {
        return AdfActivity.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AdfActivity refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AdfActivityBuilder)((AdfActivityBuilder)AdfActivity._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AdfActivity get(AtlanClient client, String id) throws AtlanException {
        return AdfActivity.get(client, id, false);
    }

    @JsonIgnore
    public static AdfActivity get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AdfActivity) {
                return (AdfActivity)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AdfActivity) {
            return (AdfActivity)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AdfActivity get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AdfActivity.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AdfActivity get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfActivity.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AdfActivity) {
                return (AdfActivity)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfActivity.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AdfActivity) {
            return (AdfActivity)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AdfActivityBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AdfActivityBuilder)((AdfActivityBuilder)((AdfActivityBuilder)AdfActivity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AdfActivityBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AdfActivity.validateRequired(TYPE_NAME, map);
        return AdfActivity.updater(this.getQualifiedName(), this.getName());
    }

    public static AdfActivity removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfActivity)Asset.removeDescription(client, AdfActivity.updater(qualifiedName, name));
    }

    public static AdfActivity removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfActivity)Asset.removeUserDescription(client, AdfActivity.updater(qualifiedName, name));
    }

    public static AdfActivity removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfActivity)Asset.removeOwners(client, AdfActivity.updater(qualifiedName, name));
    }

    public static AdfActivity updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AdfActivity)Asset.updateCertificate(client, AdfActivity._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AdfActivity removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfActivity)Asset.removeCertificate(client, AdfActivity.updater(qualifiedName, name));
    }

    public static AdfActivity updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AdfActivity)Asset.updateAnnouncement(client, AdfActivity._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AdfActivity removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfActivity)Asset.removeAnnouncement(client, AdfActivity.updater(qualifiedName, name));
    }

    public static AdfActivity replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfActivity)Asset.replaceTerms(client, AdfActivity.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AdfActivity appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfActivity)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AdfActivity removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfActivity)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AdfActivity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AdfActivity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AdfActivity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AdfActivity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AdfActivity(AdfActivityBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AdfActivity.$default$typeName();
        this.adfActivityBatchCount = b.adfActivityBatchCount;
        this.adfActivityFirstRowOnly = b.adfActivityFirstRowOnly;
        this.adfActivityIsSequential = b.adfActivityIsSequential;
        this.adfActivityMainClassName = b.adfActivityMainClassName;
        this.adfActivityNotebookPath = b.adfActivityNotebookPath;
        this.adfActivityPolictRetryInterval = b.adfActivityPolictRetryInterval;
        this.adfActivityPolicyTimeout = b.adfActivityPolicyTimeout;
        SortedSet<String> adfActivityPrecedingDependencies = new TreeSet<String>();
        if (b.adfActivityPrecedingDependencies != null) {
            adfActivityPrecedingDependencies.addAll(b.adfActivityPrecedingDependencies);
        }
        adfActivityPrecedingDependencies = Collections.unmodifiableSortedSet(adfActivityPrecedingDependencies);
        this.adfActivityPrecedingDependencies = adfActivityPrecedingDependencies;
        this.adfActivityPythonFilePath = b.adfActivityPythonFilePath;
        this.adfActivityReferenceDataflow = b.adfActivityReferenceDataflow;
        this.adfActivityRuns = switch (b.adfActivityRuns == null ? 0 : b.adfActivityRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.adfActivityRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.adfActivityRuns));
        };
        this.adfActivitySinkType = b.adfActivitySinkType;
        SortedSet<String> adfActivitySinks = new TreeSet<String>();
        if (b.adfActivitySinks != null) {
            adfActivitySinks.addAll(b.adfActivitySinks);
        }
        adfActivitySinks = Collections.unmodifiableSortedSet(adfActivitySinks);
        this.adfActivitySinks = adfActivitySinks;
        this.adfActivitySourceType = b.adfActivitySourceType;
        SortedSet<String> adfActivitySources = new TreeSet<String>();
        if (b.adfActivitySources != null) {
            adfActivitySources.addAll(b.adfActivitySources);
        }
        adfActivitySources = Collections.unmodifiableSortedSet(adfActivitySources);
        this.adfActivitySources = adfActivitySources;
        this.adfActivityState = b.adfActivityState;
        SortedSet<String> adfActivitySubActivities = new TreeSet<String>();
        if (b.adfActivitySubActivities != null) {
            adfActivitySubActivities.addAll(b.adfActivitySubActivities);
        }
        adfActivitySubActivities = Collections.unmodifiableSortedSet(adfActivitySubActivities);
        this.adfActivitySubActivities = adfActivitySubActivities;
        this.adfActivityType = b.adfActivityType;
        this.adfAssetFolderPath = b.adfAssetFolderPath;
        this.adfDataflow = b.adfDataflow;
        SortedSet<IAdfDataset> adfDatasets = new TreeSet<IAdfDataset>();
        if (b.adfDatasets != null) {
            adfDatasets.addAll(b.adfDatasets);
        }
        adfDatasets = Collections.unmodifiableSortedSet(adfDatasets);
        this.adfDatasets = adfDatasets;
        this.adfFactoryName = b.adfFactoryName;
        SortedSet<IAdfLinkedservice> adfLinkedservices = new TreeSet<IAdfLinkedservice>();
        if (b.adfLinkedservices != null) {
            adfLinkedservices.addAll(b.adfLinkedservices);
        }
        adfLinkedservices = Collections.unmodifiableSortedSet(adfLinkedservices);
        this.adfLinkedservices = adfLinkedservices;
        this.adfPipeline = b.adfPipeline;
        this.adfPipelineQualifiedName = b.adfPipelineQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ILineageProcess> processes = new TreeSet<ILineageProcess>();
        if (b.processes != null) {
            processes.addAll(b.processes);
        }
        processes = Collections.unmodifiableSortedSet(processes);
        this.processes = processes;
    }

    @Generated
    public static AdfActivityBuilder<?, ?> _internal() {
        return new AdfActivityBuilderImpl();
    }

    @Generated
    public AdfActivityBuilder<?, ?> toBuilder() {
        return new AdfActivityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Integer getAdfActivityBatchCount() {
        return this.adfActivityBatchCount;
    }

    @Override
    @Generated
    public Boolean getAdfActivityFirstRowOnly() {
        return this.adfActivityFirstRowOnly;
    }

    @Override
    @Generated
    public Boolean getAdfActivityIsSequential() {
        return this.adfActivityIsSequential;
    }

    @Override
    @Generated
    public String getAdfActivityMainClassName() {
        return this.adfActivityMainClassName;
    }

    @Override
    @Generated
    public String getAdfActivityNotebookPath() {
        return this.adfActivityNotebookPath;
    }

    @Override
    @Generated
    public Integer getAdfActivityPolictRetryInterval() {
        return this.adfActivityPolictRetryInterval;
    }

    @Override
    @Generated
    public String getAdfActivityPolicyTimeout() {
        return this.adfActivityPolicyTimeout;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfActivityPrecedingDependencies() {
        return this.adfActivityPrecedingDependencies;
    }

    @Override
    @Generated
    public String getAdfActivityPythonFilePath() {
        return this.adfActivityPythonFilePath;
    }

    @Override
    @Generated
    public String getAdfActivityReferenceDataflow() {
        return this.adfActivityReferenceDataflow;
    }

    @Override
    @Generated
    public List<Map<String, String>> getAdfActivityRuns() {
        return this.adfActivityRuns;
    }

    @Override
    @Generated
    public String getAdfActivitySinkType() {
        return this.adfActivitySinkType;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfActivitySinks() {
        return this.adfActivitySinks;
    }

    @Override
    @Generated
    public String getAdfActivitySourceType() {
        return this.adfActivitySourceType;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfActivitySources() {
        return this.adfActivitySources;
    }

    @Override
    @Generated
    public AdfActivityState getAdfActivityState() {
        return this.adfActivityState;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfActivitySubActivities() {
        return this.adfActivitySubActivities;
    }

    @Override
    @Generated
    public String getAdfActivityType() {
        return this.adfActivityType;
    }

    @Override
    @Generated
    public String getAdfAssetFolderPath() {
        return this.adfAssetFolderPath;
    }

    @Override
    @Generated
    public IAdfDataflow getAdfDataflow() {
        return this.adfDataflow;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataset> getAdfDatasets() {
        return this.adfDatasets;
    }

    @Override
    @Generated
    public String getAdfFactoryName() {
        return this.adfFactoryName;
    }

    @Override
    @Generated
    public SortedSet<IAdfLinkedservice> getAdfLinkedservices() {
        return this.adfLinkedservices;
    }

    @Override
    @Generated
    public IAdfPipeline getAdfPipeline() {
        return this.adfPipeline;
    }

    @Override
    @Generated
    public String getAdfPipelineQualifiedName() {
        return this.adfPipelineQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getProcesses() {
        return this.processes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdfActivity)) {
            return false;
        }
        AdfActivity other = (AdfActivity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$adfActivityBatchCount = this.getAdfActivityBatchCount();
        Integer other$adfActivityBatchCount = other.getAdfActivityBatchCount();
        if (this$adfActivityBatchCount == null ? other$adfActivityBatchCount != null : !((Object)this$adfActivityBatchCount).equals(other$adfActivityBatchCount)) {
            return false;
        }
        Boolean this$adfActivityFirstRowOnly = this.getAdfActivityFirstRowOnly();
        Boolean other$adfActivityFirstRowOnly = other.getAdfActivityFirstRowOnly();
        if (this$adfActivityFirstRowOnly == null ? other$adfActivityFirstRowOnly != null : !((Object)this$adfActivityFirstRowOnly).equals(other$adfActivityFirstRowOnly)) {
            return false;
        }
        Boolean this$adfActivityIsSequential = this.getAdfActivityIsSequential();
        Boolean other$adfActivityIsSequential = other.getAdfActivityIsSequential();
        if (this$adfActivityIsSequential == null ? other$adfActivityIsSequential != null : !((Object)this$adfActivityIsSequential).equals(other$adfActivityIsSequential)) {
            return false;
        }
        Integer this$adfActivityPolictRetryInterval = this.getAdfActivityPolictRetryInterval();
        Integer other$adfActivityPolictRetryInterval = other.getAdfActivityPolictRetryInterval();
        if (this$adfActivityPolictRetryInterval == null ? other$adfActivityPolictRetryInterval != null : !((Object)this$adfActivityPolictRetryInterval).equals(other$adfActivityPolictRetryInterval)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$adfActivityMainClassName = this.getAdfActivityMainClassName();
        String other$adfActivityMainClassName = other.getAdfActivityMainClassName();
        if (this$adfActivityMainClassName == null ? other$adfActivityMainClassName != null : !this$adfActivityMainClassName.equals(other$adfActivityMainClassName)) {
            return false;
        }
        String this$adfActivityNotebookPath = this.getAdfActivityNotebookPath();
        String other$adfActivityNotebookPath = other.getAdfActivityNotebookPath();
        if (this$adfActivityNotebookPath == null ? other$adfActivityNotebookPath != null : !this$adfActivityNotebookPath.equals(other$adfActivityNotebookPath)) {
            return false;
        }
        String this$adfActivityPolicyTimeout = this.getAdfActivityPolicyTimeout();
        String other$adfActivityPolicyTimeout = other.getAdfActivityPolicyTimeout();
        if (this$adfActivityPolicyTimeout == null ? other$adfActivityPolicyTimeout != null : !this$adfActivityPolicyTimeout.equals(other$adfActivityPolicyTimeout)) {
            return false;
        }
        SortedSet<String> this$adfActivityPrecedingDependencies = this.getAdfActivityPrecedingDependencies();
        SortedSet<String> other$adfActivityPrecedingDependencies = other.getAdfActivityPrecedingDependencies();
        if (this$adfActivityPrecedingDependencies == null ? other$adfActivityPrecedingDependencies != null : !this$adfActivityPrecedingDependencies.equals(other$adfActivityPrecedingDependencies)) {
            return false;
        }
        String this$adfActivityPythonFilePath = this.getAdfActivityPythonFilePath();
        String other$adfActivityPythonFilePath = other.getAdfActivityPythonFilePath();
        if (this$adfActivityPythonFilePath == null ? other$adfActivityPythonFilePath != null : !this$adfActivityPythonFilePath.equals(other$adfActivityPythonFilePath)) {
            return false;
        }
        String this$adfActivityReferenceDataflow = this.getAdfActivityReferenceDataflow();
        String other$adfActivityReferenceDataflow = other.getAdfActivityReferenceDataflow();
        if (this$adfActivityReferenceDataflow == null ? other$adfActivityReferenceDataflow != null : !this$adfActivityReferenceDataflow.equals(other$adfActivityReferenceDataflow)) {
            return false;
        }
        List<Map<String, String>> this$adfActivityRuns = this.getAdfActivityRuns();
        List<Map<String, String>> other$adfActivityRuns = other.getAdfActivityRuns();
        if (this$adfActivityRuns == null ? other$adfActivityRuns != null : !((Object)this$adfActivityRuns).equals(other$adfActivityRuns)) {
            return false;
        }
        String this$adfActivitySinkType = this.getAdfActivitySinkType();
        String other$adfActivitySinkType = other.getAdfActivitySinkType();
        if (this$adfActivitySinkType == null ? other$adfActivitySinkType != null : !this$adfActivitySinkType.equals(other$adfActivitySinkType)) {
            return false;
        }
        SortedSet<String> this$adfActivitySinks = this.getAdfActivitySinks();
        SortedSet<String> other$adfActivitySinks = other.getAdfActivitySinks();
        if (this$adfActivitySinks == null ? other$adfActivitySinks != null : !this$adfActivitySinks.equals(other$adfActivitySinks)) {
            return false;
        }
        String this$adfActivitySourceType = this.getAdfActivitySourceType();
        String other$adfActivitySourceType = other.getAdfActivitySourceType();
        if (this$adfActivitySourceType == null ? other$adfActivitySourceType != null : !this$adfActivitySourceType.equals(other$adfActivitySourceType)) {
            return false;
        }
        SortedSet<String> this$adfActivitySources = this.getAdfActivitySources();
        SortedSet<String> other$adfActivitySources = other.getAdfActivitySources();
        if (this$adfActivitySources == null ? other$adfActivitySources != null : !this$adfActivitySources.equals(other$adfActivitySources)) {
            return false;
        }
        AdfActivityState this$adfActivityState = this.getAdfActivityState();
        AdfActivityState other$adfActivityState = other.getAdfActivityState();
        if (this$adfActivityState == null ? other$adfActivityState != null : !this$adfActivityState.equals(other$adfActivityState)) {
            return false;
        }
        SortedSet<String> this$adfActivitySubActivities = this.getAdfActivitySubActivities();
        SortedSet<String> other$adfActivitySubActivities = other.getAdfActivitySubActivities();
        if (this$adfActivitySubActivities == null ? other$adfActivitySubActivities != null : !this$adfActivitySubActivities.equals(other$adfActivitySubActivities)) {
            return false;
        }
        String this$adfActivityType = this.getAdfActivityType();
        String other$adfActivityType = other.getAdfActivityType();
        if (this$adfActivityType == null ? other$adfActivityType != null : !this$adfActivityType.equals(other$adfActivityType)) {
            return false;
        }
        String this$adfAssetFolderPath = this.getAdfAssetFolderPath();
        String other$adfAssetFolderPath = other.getAdfAssetFolderPath();
        if (this$adfAssetFolderPath == null ? other$adfAssetFolderPath != null : !this$adfAssetFolderPath.equals(other$adfAssetFolderPath)) {
            return false;
        }
        IAdfDataflow this$adfDataflow = this.getAdfDataflow();
        IAdfDataflow other$adfDataflow = other.getAdfDataflow();
        if (this$adfDataflow == null ? other$adfDataflow != null : !this$adfDataflow.equals(other$adfDataflow)) {
            return false;
        }
        SortedSet<IAdfDataset> this$adfDatasets = this.getAdfDatasets();
        SortedSet<IAdfDataset> other$adfDatasets = other.getAdfDatasets();
        if (this$adfDatasets == null ? other$adfDatasets != null : !this$adfDatasets.equals(other$adfDatasets)) {
            return false;
        }
        String this$adfFactoryName = this.getAdfFactoryName();
        String other$adfFactoryName = other.getAdfFactoryName();
        if (this$adfFactoryName == null ? other$adfFactoryName != null : !this$adfFactoryName.equals(other$adfFactoryName)) {
            return false;
        }
        SortedSet<IAdfLinkedservice> this$adfLinkedservices = this.getAdfLinkedservices();
        SortedSet<IAdfLinkedservice> other$adfLinkedservices = other.getAdfLinkedservices();
        if (this$adfLinkedservices == null ? other$adfLinkedservices != null : !this$adfLinkedservices.equals(other$adfLinkedservices)) {
            return false;
        }
        IAdfPipeline this$adfPipeline = this.getAdfPipeline();
        IAdfPipeline other$adfPipeline = other.getAdfPipeline();
        if (this$adfPipeline == null ? other$adfPipeline != null : !this$adfPipeline.equals(other$adfPipeline)) {
            return false;
        }
        String this$adfPipelineQualifiedName = this.getAdfPipelineQualifiedName();
        String other$adfPipelineQualifiedName = other.getAdfPipelineQualifiedName();
        if (this$adfPipelineQualifiedName == null ? other$adfPipelineQualifiedName != null : !this$adfPipelineQualifiedName.equals(other$adfPipelineQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ILineageProcess> this$processes = this.getProcesses();
        SortedSet<ILineageProcess> other$processes = other.getProcesses();
        return !(this$processes == null ? other$processes != null : !this$processes.equals(other$processes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdfActivity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $adfActivityBatchCount = this.getAdfActivityBatchCount();
        result = result * 59 + ($adfActivityBatchCount == null ? 43 : ((Object)$adfActivityBatchCount).hashCode());
        Boolean $adfActivityFirstRowOnly = this.getAdfActivityFirstRowOnly();
        result = result * 59 + ($adfActivityFirstRowOnly == null ? 43 : ((Object)$adfActivityFirstRowOnly).hashCode());
        Boolean $adfActivityIsSequential = this.getAdfActivityIsSequential();
        result = result * 59 + ($adfActivityIsSequential == null ? 43 : ((Object)$adfActivityIsSequential).hashCode());
        Integer $adfActivityPolictRetryInterval = this.getAdfActivityPolictRetryInterval();
        result = result * 59 + ($adfActivityPolictRetryInterval == null ? 43 : ((Object)$adfActivityPolictRetryInterval).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $adfActivityMainClassName = this.getAdfActivityMainClassName();
        result = result * 59 + ($adfActivityMainClassName == null ? 43 : $adfActivityMainClassName.hashCode());
        String $adfActivityNotebookPath = this.getAdfActivityNotebookPath();
        result = result * 59 + ($adfActivityNotebookPath == null ? 43 : $adfActivityNotebookPath.hashCode());
        String $adfActivityPolicyTimeout = this.getAdfActivityPolicyTimeout();
        result = result * 59 + ($adfActivityPolicyTimeout == null ? 43 : $adfActivityPolicyTimeout.hashCode());
        SortedSet<String> $adfActivityPrecedingDependencies = this.getAdfActivityPrecedingDependencies();
        result = result * 59 + ($adfActivityPrecedingDependencies == null ? 43 : $adfActivityPrecedingDependencies.hashCode());
        String $adfActivityPythonFilePath = this.getAdfActivityPythonFilePath();
        result = result * 59 + ($adfActivityPythonFilePath == null ? 43 : $adfActivityPythonFilePath.hashCode());
        String $adfActivityReferenceDataflow = this.getAdfActivityReferenceDataflow();
        result = result * 59 + ($adfActivityReferenceDataflow == null ? 43 : $adfActivityReferenceDataflow.hashCode());
        List<Map<String, String>> $adfActivityRuns = this.getAdfActivityRuns();
        result = result * 59 + ($adfActivityRuns == null ? 43 : ((Object)$adfActivityRuns).hashCode());
        String $adfActivitySinkType = this.getAdfActivitySinkType();
        result = result * 59 + ($adfActivitySinkType == null ? 43 : $adfActivitySinkType.hashCode());
        SortedSet<String> $adfActivitySinks = this.getAdfActivitySinks();
        result = result * 59 + ($adfActivitySinks == null ? 43 : $adfActivitySinks.hashCode());
        String $adfActivitySourceType = this.getAdfActivitySourceType();
        result = result * 59 + ($adfActivitySourceType == null ? 43 : $adfActivitySourceType.hashCode());
        SortedSet<String> $adfActivitySources = this.getAdfActivitySources();
        result = result * 59 + ($adfActivitySources == null ? 43 : $adfActivitySources.hashCode());
        AdfActivityState $adfActivityState = this.getAdfActivityState();
        result = result * 59 + ($adfActivityState == null ? 43 : $adfActivityState.hashCode());
        SortedSet<String> $adfActivitySubActivities = this.getAdfActivitySubActivities();
        result = result * 59 + ($adfActivitySubActivities == null ? 43 : $adfActivitySubActivities.hashCode());
        String $adfActivityType = this.getAdfActivityType();
        result = result * 59 + ($adfActivityType == null ? 43 : $adfActivityType.hashCode());
        String $adfAssetFolderPath = this.getAdfAssetFolderPath();
        result = result * 59 + ($adfAssetFolderPath == null ? 43 : $adfAssetFolderPath.hashCode());
        IAdfDataflow $adfDataflow = this.getAdfDataflow();
        result = result * 59 + ($adfDataflow == null ? 43 : $adfDataflow.hashCode());
        SortedSet<IAdfDataset> $adfDatasets = this.getAdfDatasets();
        result = result * 59 + ($adfDatasets == null ? 43 : $adfDatasets.hashCode());
        String $adfFactoryName = this.getAdfFactoryName();
        result = result * 59 + ($adfFactoryName == null ? 43 : $adfFactoryName.hashCode());
        SortedSet<IAdfLinkedservice> $adfLinkedservices = this.getAdfLinkedservices();
        result = result * 59 + ($adfLinkedservices == null ? 43 : $adfLinkedservices.hashCode());
        IAdfPipeline $adfPipeline = this.getAdfPipeline();
        result = result * 59 + ($adfPipeline == null ? 43 : $adfPipeline.hashCode());
        String $adfPipelineQualifiedName = this.getAdfPipelineQualifiedName();
        result = result * 59 + ($adfPipelineQualifiedName == null ? 43 : $adfPipelineQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ILineageProcess> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : $processes.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AdfActivity(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adfActivityBatchCount=" + this.getAdfActivityBatchCount() + ", adfActivityFirstRowOnly=" + this.getAdfActivityFirstRowOnly() + ", adfActivityIsSequential=" + this.getAdfActivityIsSequential() + ", adfActivityMainClassName=" + this.getAdfActivityMainClassName() + ", adfActivityNotebookPath=" + this.getAdfActivityNotebookPath() + ", adfActivityPolictRetryInterval=" + this.getAdfActivityPolictRetryInterval() + ", adfActivityPolicyTimeout=" + this.getAdfActivityPolicyTimeout() + ", adfActivityPrecedingDependencies=" + String.valueOf(this.getAdfActivityPrecedingDependencies()) + ", adfActivityPythonFilePath=" + this.getAdfActivityPythonFilePath() + ", adfActivityReferenceDataflow=" + this.getAdfActivityReferenceDataflow() + ", adfActivityRuns=" + String.valueOf(this.getAdfActivityRuns()) + ", adfActivitySinkType=" + this.getAdfActivitySinkType() + ", adfActivitySinks=" + String.valueOf(this.getAdfActivitySinks()) + ", adfActivitySourceType=" + this.getAdfActivitySourceType() + ", adfActivitySources=" + String.valueOf(this.getAdfActivitySources()) + ", adfActivityState=" + String.valueOf(this.getAdfActivityState()) + ", adfActivitySubActivities=" + String.valueOf(this.getAdfActivitySubActivities()) + ", adfActivityType=" + this.getAdfActivityType() + ", adfAssetFolderPath=" + this.getAdfAssetFolderPath() + ", adfDataflow=" + String.valueOf(this.getAdfDataflow()) + ", adfDatasets=" + String.valueOf(this.getAdfDatasets()) + ", adfFactoryName=" + this.getAdfFactoryName() + ", adfLinkedservices=" + String.valueOf(this.getAdfLinkedservices()) + ", adfPipeline=" + String.valueOf(this.getAdfPipeline()) + ", adfPipelineQualifiedName=" + this.getAdfPipelineQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", processes=" + String.valueOf(this.getProcesses()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AdfActivityBuilder<C extends AdfActivity, B extends AdfActivityBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Integer adfActivityBatchCount;
        @Generated
        private Boolean adfActivityFirstRowOnly;
        @Generated
        private Boolean adfActivityIsSequential;
        @Generated
        private String adfActivityMainClassName;
        @Generated
        private String adfActivityNotebookPath;
        @Generated
        private Integer adfActivityPolictRetryInterval;
        @Generated
        private String adfActivityPolicyTimeout;
        @Generated
        private ArrayList<String> adfActivityPrecedingDependencies;
        @Generated
        private String adfActivityPythonFilePath;
        @Generated
        private String adfActivityReferenceDataflow;
        @Generated
        private ArrayList<Map<String, String>> adfActivityRuns;
        @Generated
        private String adfActivitySinkType;
        @Generated
        private ArrayList<String> adfActivitySinks;
        @Generated
        private String adfActivitySourceType;
        @Generated
        private ArrayList<String> adfActivitySources;
        @Generated
        private AdfActivityState adfActivityState;
        @Generated
        private ArrayList<String> adfActivitySubActivities;
        @Generated
        private String adfActivityType;
        @Generated
        private String adfAssetFolderPath;
        @Generated
        private IAdfDataflow adfDataflow;
        @Generated
        private ArrayList<IAdfDataset> adfDatasets;
        @Generated
        private String adfFactoryName;
        @Generated
        private ArrayList<IAdfLinkedservice> adfLinkedservices;
        @Generated
        private IAdfPipeline adfPipeline;
        @Generated
        private String adfPipelineQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ILineageProcess> processes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AdfActivityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AdfActivity instance, AdfActivityBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adfActivityBatchCount(instance.adfActivityBatchCount);
            b.adfActivityFirstRowOnly(instance.adfActivityFirstRowOnly);
            b.adfActivityIsSequential(instance.adfActivityIsSequential);
            b.adfActivityMainClassName(instance.adfActivityMainClassName);
            b.adfActivityNotebookPath(instance.adfActivityNotebookPath);
            b.adfActivityPolictRetryInterval(instance.adfActivityPolictRetryInterval);
            b.adfActivityPolicyTimeout(instance.adfActivityPolicyTimeout);
            b.adfActivityPrecedingDependencies(instance.adfActivityPrecedingDependencies == null ? Collections.emptySortedSet() : instance.adfActivityPrecedingDependencies);
            b.adfActivityPythonFilePath(instance.adfActivityPythonFilePath);
            b.adfActivityReferenceDataflow(instance.adfActivityReferenceDataflow);
            b.adfActivityRuns(instance.adfActivityRuns == null ? Collections.emptyList() : instance.adfActivityRuns);
            b.adfActivitySinkType(instance.adfActivitySinkType);
            b.adfActivitySinks(instance.adfActivitySinks == null ? Collections.emptySortedSet() : instance.adfActivitySinks);
            b.adfActivitySourceType(instance.adfActivitySourceType);
            b.adfActivitySources(instance.adfActivitySources == null ? Collections.emptySortedSet() : instance.adfActivitySources);
            b.adfActivityState(instance.adfActivityState);
            b.adfActivitySubActivities(instance.adfActivitySubActivities == null ? Collections.emptySortedSet() : instance.adfActivitySubActivities);
            b.adfActivityType(instance.adfActivityType);
            b.adfAssetFolderPath(instance.adfAssetFolderPath);
            b.adfDataflow(instance.adfDataflow);
            b.adfDatasets(instance.adfDatasets == null ? Collections.emptySortedSet() : instance.adfDatasets);
            b.adfFactoryName(instance.adfFactoryName);
            b.adfLinkedservices(instance.adfLinkedservices == null ? Collections.emptySortedSet() : instance.adfLinkedservices);
            b.adfPipeline(instance.adfPipeline);
            b.adfPipelineQualifiedName(instance.adfPipelineQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.processes(instance.processes == null ? Collections.emptySortedSet() : instance.processes);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adfActivityBatchCount(Integer adfActivityBatchCount) {
            this.adfActivityBatchCount = adfActivityBatchCount;
            return (B)this.self();
        }

        @Generated
        public B adfActivityFirstRowOnly(Boolean adfActivityFirstRowOnly) {
            this.adfActivityFirstRowOnly = adfActivityFirstRowOnly;
            return (B)this.self();
        }

        @Generated
        public B adfActivityIsSequential(Boolean adfActivityIsSequential) {
            this.adfActivityIsSequential = adfActivityIsSequential;
            return (B)this.self();
        }

        @Generated
        public B adfActivityMainClassName(String adfActivityMainClassName) {
            this.adfActivityMainClassName = adfActivityMainClassName;
            return (B)this.self();
        }

        @Generated
        public B adfActivityNotebookPath(String adfActivityNotebookPath) {
            this.adfActivityNotebookPath = adfActivityNotebookPath;
            return (B)this.self();
        }

        @Generated
        public B adfActivityPolictRetryInterval(Integer adfActivityPolictRetryInterval) {
            this.adfActivityPolictRetryInterval = adfActivityPolictRetryInterval;
            return (B)this.self();
        }

        @Generated
        public B adfActivityPolicyTimeout(String adfActivityPolicyTimeout) {
            this.adfActivityPolicyTimeout = adfActivityPolicyTimeout;
            return (B)this.self();
        }

        @Generated
        public B adfActivityPrecedingDependency(String adfActivityPrecedingDependency) {
            if (this.adfActivityPrecedingDependencies == null) {
                this.adfActivityPrecedingDependencies = new ArrayList();
            }
            this.adfActivityPrecedingDependencies.add(adfActivityPrecedingDependency);
            return (B)this.self();
        }

        @JsonProperty(value="adfActivityPrecedingDependency")
        @Generated
        public B adfActivityPrecedingDependencies(Collection<? extends String> adfActivityPrecedingDependencies) {
            if (adfActivityPrecedingDependencies == null) {
                throw new NullPointerException("adfActivityPrecedingDependencies cannot be null");
            }
            if (this.adfActivityPrecedingDependencies == null) {
                this.adfActivityPrecedingDependencies = new ArrayList();
            }
            this.adfActivityPrecedingDependencies.addAll(adfActivityPrecedingDependencies);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivityPrecedingDependencies() {
            if (this.adfActivityPrecedingDependencies != null) {
                this.adfActivityPrecedingDependencies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfActivityPythonFilePath(String adfActivityPythonFilePath) {
            this.adfActivityPythonFilePath = adfActivityPythonFilePath;
            return (B)this.self();
        }

        @Generated
        public B adfActivityReferenceDataflow(String adfActivityReferenceDataflow) {
            this.adfActivityReferenceDataflow = adfActivityReferenceDataflow;
            return (B)this.self();
        }

        @Generated
        public B adfActivityRun(Map<String, String> adfActivityRun) {
            if (this.adfActivityRuns == null) {
                this.adfActivityRuns = new ArrayList();
            }
            this.adfActivityRuns.add(adfActivityRun);
            return (B)this.self();
        }

        @Generated
        public B adfActivityRuns(Collection<? extends Map<String, String>> adfActivityRuns) {
            if (adfActivityRuns == null) {
                throw new NullPointerException("adfActivityRuns cannot be null");
            }
            if (this.adfActivityRuns == null) {
                this.adfActivityRuns = new ArrayList();
            }
            this.adfActivityRuns.addAll(adfActivityRuns);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivityRuns() {
            if (this.adfActivityRuns != null) {
                this.adfActivityRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfActivitySinkType(String adfActivitySinkType) {
            this.adfActivitySinkType = adfActivitySinkType;
            return (B)this.self();
        }

        @Generated
        public B adfActivitySink(String adfActivitySink) {
            if (this.adfActivitySinks == null) {
                this.adfActivitySinks = new ArrayList();
            }
            this.adfActivitySinks.add(adfActivitySink);
            return (B)this.self();
        }

        @Generated
        public B adfActivitySinks(Collection<? extends String> adfActivitySinks) {
            if (adfActivitySinks == null) {
                throw new NullPointerException("adfActivitySinks cannot be null");
            }
            if (this.adfActivitySinks == null) {
                this.adfActivitySinks = new ArrayList();
            }
            this.adfActivitySinks.addAll(adfActivitySinks);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivitySinks() {
            if (this.adfActivitySinks != null) {
                this.adfActivitySinks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfActivitySourceType(String adfActivitySourceType) {
            this.adfActivitySourceType = adfActivitySourceType;
            return (B)this.self();
        }

        @Generated
        public B adfActivitySource(String adfActivitySource) {
            if (this.adfActivitySources == null) {
                this.adfActivitySources = new ArrayList();
            }
            this.adfActivitySources.add(adfActivitySource);
            return (B)this.self();
        }

        @Generated
        public B adfActivitySources(Collection<? extends String> adfActivitySources) {
            if (adfActivitySources == null) {
                throw new NullPointerException("adfActivitySources cannot be null");
            }
            if (this.adfActivitySources == null) {
                this.adfActivitySources = new ArrayList();
            }
            this.adfActivitySources.addAll(adfActivitySources);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivitySources() {
            if (this.adfActivitySources != null) {
                this.adfActivitySources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfActivityState(AdfActivityState adfActivityState) {
            this.adfActivityState = adfActivityState;
            return (B)this.self();
        }

        @Generated
        public B adfActivitySubActivity(String adfActivitySubActivity) {
            if (this.adfActivitySubActivities == null) {
                this.adfActivitySubActivities = new ArrayList();
            }
            this.adfActivitySubActivities.add(adfActivitySubActivity);
            return (B)this.self();
        }

        @Generated
        public B adfActivitySubActivities(Collection<? extends String> adfActivitySubActivities) {
            if (adfActivitySubActivities == null) {
                throw new NullPointerException("adfActivitySubActivities cannot be null");
            }
            if (this.adfActivitySubActivities == null) {
                this.adfActivitySubActivities = new ArrayList();
            }
            this.adfActivitySubActivities.addAll(adfActivitySubActivities);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivitySubActivities() {
            if (this.adfActivitySubActivities != null) {
                this.adfActivitySubActivities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfActivityType(String adfActivityType) {
            this.adfActivityType = adfActivityType;
            return (B)this.self();
        }

        @Generated
        public B adfAssetFolderPath(String adfAssetFolderPath) {
            this.adfAssetFolderPath = adfAssetFolderPath;
            return (B)this.self();
        }

        @Generated
        public B adfDataflow(IAdfDataflow adfDataflow) {
            this.adfDataflow = adfDataflow;
            return (B)this.self();
        }

        @Generated
        public B adfDataset(IAdfDataset adfDataset) {
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.add(adfDataset);
            return (B)this.self();
        }

        @Generated
        public B adfDatasets(Collection<? extends IAdfDataset> adfDatasets) {
            if (adfDatasets == null) {
                throw new NullPointerException("adfDatasets cannot be null");
            }
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.addAll(adfDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDatasets() {
            if (this.adfDatasets != null) {
                this.adfDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfFactoryName(String adfFactoryName) {
            this.adfFactoryName = adfFactoryName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedservice(IAdfLinkedservice adfLinkedservice) {
            if (this.adfLinkedservices == null) {
                this.adfLinkedservices = new ArrayList();
            }
            this.adfLinkedservices.add(adfLinkedservice);
            return (B)this.self();
        }

        @Generated
        public B adfLinkedservices(Collection<? extends IAdfLinkedservice> adfLinkedservices) {
            if (adfLinkedservices == null) {
                throw new NullPointerException("adfLinkedservices cannot be null");
            }
            if (this.adfLinkedservices == null) {
                this.adfLinkedservices = new ArrayList();
            }
            this.adfLinkedservices.addAll(adfLinkedservices);
            return (B)this.self();
        }

        @Generated
        public B clearAdfLinkedservices() {
            if (this.adfLinkedservices != null) {
                this.adfLinkedservices.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfPipeline(IAdfPipeline adfPipeline) {
            this.adfPipeline = adfPipeline;
            return (B)this.self();
        }

        @Generated
        public B adfPipelineQualifiedName(String adfPipelineQualifiedName) {
            this.adfPipelineQualifiedName = adfPipelineQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.add(process);
            return (B)this.self();
        }

        @Generated
        public B processes(Collection<? extends ILineageProcess> processes) {
            if (processes == null) {
                throw new NullPointerException("processes cannot be null");
            }
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.addAll(processes);
            return (B)this.self();
        }

        @Generated
        public B clearProcesses() {
            if (this.processes != null) {
                this.processes.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AdfActivity.AdfActivityBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adfActivityBatchCount=" + this.adfActivityBatchCount + ", adfActivityFirstRowOnly=" + this.adfActivityFirstRowOnly + ", adfActivityIsSequential=" + this.adfActivityIsSequential + ", adfActivityMainClassName=" + this.adfActivityMainClassName + ", adfActivityNotebookPath=" + this.adfActivityNotebookPath + ", adfActivityPolictRetryInterval=" + this.adfActivityPolictRetryInterval + ", adfActivityPolicyTimeout=" + this.adfActivityPolicyTimeout + ", adfActivityPrecedingDependencies=" + String.valueOf(this.adfActivityPrecedingDependencies) + ", adfActivityPythonFilePath=" + this.adfActivityPythonFilePath + ", adfActivityReferenceDataflow=" + this.adfActivityReferenceDataflow + ", adfActivityRuns=" + String.valueOf(this.adfActivityRuns) + ", adfActivitySinkType=" + this.adfActivitySinkType + ", adfActivitySinks=" + String.valueOf(this.adfActivitySinks) + ", adfActivitySourceType=" + this.adfActivitySourceType + ", adfActivitySources=" + String.valueOf(this.adfActivitySources) + ", adfActivityState=" + String.valueOf(this.adfActivityState) + ", adfActivitySubActivities=" + String.valueOf(this.adfActivitySubActivities) + ", adfActivityType=" + this.adfActivityType + ", adfAssetFolderPath=" + this.adfAssetFolderPath + ", adfDataflow=" + String.valueOf(this.adfDataflow) + ", adfDatasets=" + String.valueOf(this.adfDatasets) + ", adfFactoryName=" + this.adfFactoryName + ", adfLinkedservices=" + String.valueOf(this.adfLinkedservices) + ", adfPipeline=" + String.valueOf(this.adfPipeline) + ", adfPipelineQualifiedName=" + this.adfPipelineQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", processes=" + String.valueOf(this.processes) + ")";
        }
    }

    @Generated
    private static final class AdfActivityBuilderImpl
    extends AdfActivityBuilder<AdfActivity, AdfActivityBuilderImpl> {
        @Generated
        private AdfActivityBuilderImpl() {
        }

        @Override
        @Generated
        protected AdfActivityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AdfActivity build() {
            return new AdfActivity(this);
        }
    }
}

