/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IADF;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAdfDataflow;
import com.atlan.model.assets.IAdfDataset;
import com.atlan.model.assets.IAdfLinkedservice;
import com.atlan.model.assets.IAdfPipeline;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfLinkedservice
extends Asset
implements IAdfLinkedservice,
IADF,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdfLinkedservice.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AdfLinkedservice";
    String typeName;
    @Attribute
    SortedSet<IAdfActivity> adfActivities;
    @Attribute
    String adfAssetFolderPath;
    @Attribute
    SortedSet<IAdfDataflow> adfDataflows;
    @Attribute
    SortedSet<IAdfDataset> adfDatasets;
    @Attribute
    String adfFactoryName;
    @Attribute
    String adfLinkedserviceAccountName;
    @Attribute
    SortedSet<String> adfLinkedserviceAnnotations;
    @Attribute
    String adfLinkedserviceAzureCloudType;
    @Attribute
    String adfLinkedserviceClusterId;
    @Attribute
    String adfLinkedserviceCredentialType;
    @Attribute
    String adfLinkedserviceDatabaseName;
    @Attribute
    String adfLinkedserviceDomainEndpoint;
    @Attribute
    String adfLinkedserviceResourceId;
    @Attribute
    String adfLinkedserviceRoleName;
    @Attribute
    String adfLinkedserviceTenant;
    @Attribute
    String adfLinkedserviceType;
    @Attribute
    String adfLinkedserviceUserName;
    @Attribute
    String adfLinkedserviceVersion;
    @Attribute
    Boolean adfLinkedserviceVersionAbove;
    @Attribute
    String adfLinkedserviceWarehouseName;
    @Attribute
    SortedSet<IAdfPipeline> adfPipelines;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AdfLinkedservice trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AdfLinkedservice.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AdfLinkedservice.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AdfLinkedservice.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AdfLinkedservice.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AdfLinkedservice refByGuid(String guid) {
        return AdfLinkedservice.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AdfLinkedservice refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AdfLinkedserviceBuilder)((AdfLinkedserviceBuilder)AdfLinkedservice._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AdfLinkedservice refByQualifiedName(String qualifiedName) {
        return AdfLinkedservice.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AdfLinkedservice refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AdfLinkedserviceBuilder)((AdfLinkedserviceBuilder)AdfLinkedservice._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AdfLinkedservice get(AtlanClient client, String id) throws AtlanException {
        return AdfLinkedservice.get(client, id, false);
    }

    @JsonIgnore
    public static AdfLinkedservice get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AdfLinkedservice) {
                return (AdfLinkedservice)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AdfLinkedservice) {
            return (AdfLinkedservice)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AdfLinkedservice get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AdfLinkedservice.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AdfLinkedservice get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfLinkedservice.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AdfLinkedservice) {
                return (AdfLinkedservice)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AdfLinkedservice.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AdfLinkedservice) {
            return (AdfLinkedservice)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AdfLinkedserviceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AdfLinkedserviceBuilder)((AdfLinkedserviceBuilder)((AdfLinkedserviceBuilder)AdfLinkedservice._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AdfLinkedserviceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AdfLinkedservice.validateRequired(TYPE_NAME, map);
        return AdfLinkedservice.updater(this.getQualifiedName(), this.getName());
    }

    public static AdfLinkedservice removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfLinkedservice)Asset.removeDescription(client, AdfLinkedservice.updater(qualifiedName, name));
    }

    public static AdfLinkedservice removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfLinkedservice)Asset.removeUserDescription(client, AdfLinkedservice.updater(qualifiedName, name));
    }

    public static AdfLinkedservice removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfLinkedservice)Asset.removeOwners(client, AdfLinkedservice.updater(qualifiedName, name));
    }

    public static AdfLinkedservice updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AdfLinkedservice)Asset.updateCertificate(client, AdfLinkedservice._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AdfLinkedservice removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfLinkedservice)Asset.removeCertificate(client, AdfLinkedservice.updater(qualifiedName, name));
    }

    public static AdfLinkedservice updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AdfLinkedservice)Asset.updateAnnouncement(client, AdfLinkedservice._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AdfLinkedservice removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AdfLinkedservice)Asset.removeAnnouncement(client, AdfLinkedservice.updater(qualifiedName, name));
    }

    public static AdfLinkedservice replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfLinkedservice)Asset.replaceTerms(client, AdfLinkedservice.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AdfLinkedservice appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfLinkedservice)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AdfLinkedservice removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AdfLinkedservice)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AdfLinkedservice appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AdfLinkedservice)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AdfLinkedservice appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AdfLinkedservice)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AdfLinkedservice(AdfLinkedserviceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AdfLinkedservice.$default$typeName();
        SortedSet<IAdfActivity> adfActivities = new TreeSet<IAdfActivity>();
        if (b.adfActivities != null) {
            adfActivities.addAll(b.adfActivities);
        }
        adfActivities = Collections.unmodifiableSortedSet(adfActivities);
        this.adfActivities = adfActivities;
        this.adfAssetFolderPath = b.adfAssetFolderPath;
        SortedSet<IAdfDataflow> adfDataflows = new TreeSet<IAdfDataflow>();
        if (b.adfDataflows != null) {
            adfDataflows.addAll(b.adfDataflows);
        }
        adfDataflows = Collections.unmodifiableSortedSet(adfDataflows);
        this.adfDataflows = adfDataflows;
        SortedSet<IAdfDataset> adfDatasets = new TreeSet<IAdfDataset>();
        if (b.adfDatasets != null) {
            adfDatasets.addAll(b.adfDatasets);
        }
        adfDatasets = Collections.unmodifiableSortedSet(adfDatasets);
        this.adfDatasets = adfDatasets;
        this.adfFactoryName = b.adfFactoryName;
        this.adfLinkedserviceAccountName = b.adfLinkedserviceAccountName;
        SortedSet<String> adfLinkedserviceAnnotations = new TreeSet<String>();
        if (b.adfLinkedserviceAnnotations != null) {
            adfLinkedserviceAnnotations.addAll(b.adfLinkedserviceAnnotations);
        }
        adfLinkedserviceAnnotations = Collections.unmodifiableSortedSet(adfLinkedserviceAnnotations);
        this.adfLinkedserviceAnnotations = adfLinkedserviceAnnotations;
        this.adfLinkedserviceAzureCloudType = b.adfLinkedserviceAzureCloudType;
        this.adfLinkedserviceClusterId = b.adfLinkedserviceClusterId;
        this.adfLinkedserviceCredentialType = b.adfLinkedserviceCredentialType;
        this.adfLinkedserviceDatabaseName = b.adfLinkedserviceDatabaseName;
        this.adfLinkedserviceDomainEndpoint = b.adfLinkedserviceDomainEndpoint;
        this.adfLinkedserviceResourceId = b.adfLinkedserviceResourceId;
        this.adfLinkedserviceRoleName = b.adfLinkedserviceRoleName;
        this.adfLinkedserviceTenant = b.adfLinkedserviceTenant;
        this.adfLinkedserviceType = b.adfLinkedserviceType;
        this.adfLinkedserviceUserName = b.adfLinkedserviceUserName;
        this.adfLinkedserviceVersion = b.adfLinkedserviceVersion;
        this.adfLinkedserviceVersionAbove = b.adfLinkedserviceVersionAbove;
        this.adfLinkedserviceWarehouseName = b.adfLinkedserviceWarehouseName;
        SortedSet<IAdfPipeline> adfPipelines = new TreeSet<IAdfPipeline>();
        if (b.adfPipelines != null) {
            adfPipelines.addAll(b.adfPipelines);
        }
        adfPipelines = Collections.unmodifiableSortedSet(adfPipelines);
        this.adfPipelines = adfPipelines;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AdfLinkedserviceBuilder<?, ?> _internal() {
        return new AdfLinkedserviceBuilderImpl();
    }

    @Generated
    public AdfLinkedserviceBuilder<?, ?> toBuilder() {
        return new AdfLinkedserviceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAdfActivity> getAdfActivities() {
        return this.adfActivities;
    }

    @Override
    @Generated
    public String getAdfAssetFolderPath() {
        return this.adfAssetFolderPath;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataflow> getAdfDataflows() {
        return this.adfDataflows;
    }

    @Override
    @Generated
    public SortedSet<IAdfDataset> getAdfDatasets() {
        return this.adfDatasets;
    }

    @Override
    @Generated
    public String getAdfFactoryName() {
        return this.adfFactoryName;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceAccountName() {
        return this.adfLinkedserviceAccountName;
    }

    @Override
    @Generated
    public SortedSet<String> getAdfLinkedserviceAnnotations() {
        return this.adfLinkedserviceAnnotations;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceAzureCloudType() {
        return this.adfLinkedserviceAzureCloudType;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceClusterId() {
        return this.adfLinkedserviceClusterId;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceCredentialType() {
        return this.adfLinkedserviceCredentialType;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceDatabaseName() {
        return this.adfLinkedserviceDatabaseName;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceDomainEndpoint() {
        return this.adfLinkedserviceDomainEndpoint;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceResourceId() {
        return this.adfLinkedserviceResourceId;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceRoleName() {
        return this.adfLinkedserviceRoleName;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceTenant() {
        return this.adfLinkedserviceTenant;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceType() {
        return this.adfLinkedserviceType;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceUserName() {
        return this.adfLinkedserviceUserName;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceVersion() {
        return this.adfLinkedserviceVersion;
    }

    @Override
    @Generated
    public Boolean getAdfLinkedserviceVersionAbove() {
        return this.adfLinkedserviceVersionAbove;
    }

    @Override
    @Generated
    public String getAdfLinkedserviceWarehouseName() {
        return this.adfLinkedserviceWarehouseName;
    }

    @Override
    @Generated
    public SortedSet<IAdfPipeline> getAdfPipelines() {
        return this.adfPipelines;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdfLinkedservice)) {
            return false;
        }
        AdfLinkedservice other = (AdfLinkedservice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$adfLinkedserviceVersionAbove = this.getAdfLinkedserviceVersionAbove();
        Boolean other$adfLinkedserviceVersionAbove = other.getAdfLinkedserviceVersionAbove();
        if (this$adfLinkedserviceVersionAbove == null ? other$adfLinkedserviceVersionAbove != null : !((Object)this$adfLinkedserviceVersionAbove).equals(other$adfLinkedserviceVersionAbove)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAdfActivity> this$adfActivities = this.getAdfActivities();
        SortedSet<IAdfActivity> other$adfActivities = other.getAdfActivities();
        if (this$adfActivities == null ? other$adfActivities != null : !this$adfActivities.equals(other$adfActivities)) {
            return false;
        }
        String this$adfAssetFolderPath = this.getAdfAssetFolderPath();
        String other$adfAssetFolderPath = other.getAdfAssetFolderPath();
        if (this$adfAssetFolderPath == null ? other$adfAssetFolderPath != null : !this$adfAssetFolderPath.equals(other$adfAssetFolderPath)) {
            return false;
        }
        SortedSet<IAdfDataflow> this$adfDataflows = this.getAdfDataflows();
        SortedSet<IAdfDataflow> other$adfDataflows = other.getAdfDataflows();
        if (this$adfDataflows == null ? other$adfDataflows != null : !this$adfDataflows.equals(other$adfDataflows)) {
            return false;
        }
        SortedSet<IAdfDataset> this$adfDatasets = this.getAdfDatasets();
        SortedSet<IAdfDataset> other$adfDatasets = other.getAdfDatasets();
        if (this$adfDatasets == null ? other$adfDatasets != null : !this$adfDatasets.equals(other$adfDatasets)) {
            return false;
        }
        String this$adfFactoryName = this.getAdfFactoryName();
        String other$adfFactoryName = other.getAdfFactoryName();
        if (this$adfFactoryName == null ? other$adfFactoryName != null : !this$adfFactoryName.equals(other$adfFactoryName)) {
            return false;
        }
        String this$adfLinkedserviceAccountName = this.getAdfLinkedserviceAccountName();
        String other$adfLinkedserviceAccountName = other.getAdfLinkedserviceAccountName();
        if (this$adfLinkedserviceAccountName == null ? other$adfLinkedserviceAccountName != null : !this$adfLinkedserviceAccountName.equals(other$adfLinkedserviceAccountName)) {
            return false;
        }
        SortedSet<String> this$adfLinkedserviceAnnotations = this.getAdfLinkedserviceAnnotations();
        SortedSet<String> other$adfLinkedserviceAnnotations = other.getAdfLinkedserviceAnnotations();
        if (this$adfLinkedserviceAnnotations == null ? other$adfLinkedserviceAnnotations != null : !this$adfLinkedserviceAnnotations.equals(other$adfLinkedserviceAnnotations)) {
            return false;
        }
        String this$adfLinkedserviceAzureCloudType = this.getAdfLinkedserviceAzureCloudType();
        String other$adfLinkedserviceAzureCloudType = other.getAdfLinkedserviceAzureCloudType();
        if (this$adfLinkedserviceAzureCloudType == null ? other$adfLinkedserviceAzureCloudType != null : !this$adfLinkedserviceAzureCloudType.equals(other$adfLinkedserviceAzureCloudType)) {
            return false;
        }
        String this$adfLinkedserviceClusterId = this.getAdfLinkedserviceClusterId();
        String other$adfLinkedserviceClusterId = other.getAdfLinkedserviceClusterId();
        if (this$adfLinkedserviceClusterId == null ? other$adfLinkedserviceClusterId != null : !this$adfLinkedserviceClusterId.equals(other$adfLinkedserviceClusterId)) {
            return false;
        }
        String this$adfLinkedserviceCredentialType = this.getAdfLinkedserviceCredentialType();
        String other$adfLinkedserviceCredentialType = other.getAdfLinkedserviceCredentialType();
        if (this$adfLinkedserviceCredentialType == null ? other$adfLinkedserviceCredentialType != null : !this$adfLinkedserviceCredentialType.equals(other$adfLinkedserviceCredentialType)) {
            return false;
        }
        String this$adfLinkedserviceDatabaseName = this.getAdfLinkedserviceDatabaseName();
        String other$adfLinkedserviceDatabaseName = other.getAdfLinkedserviceDatabaseName();
        if (this$adfLinkedserviceDatabaseName == null ? other$adfLinkedserviceDatabaseName != null : !this$adfLinkedserviceDatabaseName.equals(other$adfLinkedserviceDatabaseName)) {
            return false;
        }
        String this$adfLinkedserviceDomainEndpoint = this.getAdfLinkedserviceDomainEndpoint();
        String other$adfLinkedserviceDomainEndpoint = other.getAdfLinkedserviceDomainEndpoint();
        if (this$adfLinkedserviceDomainEndpoint == null ? other$adfLinkedserviceDomainEndpoint != null : !this$adfLinkedserviceDomainEndpoint.equals(other$adfLinkedserviceDomainEndpoint)) {
            return false;
        }
        String this$adfLinkedserviceResourceId = this.getAdfLinkedserviceResourceId();
        String other$adfLinkedserviceResourceId = other.getAdfLinkedserviceResourceId();
        if (this$adfLinkedserviceResourceId == null ? other$adfLinkedserviceResourceId != null : !this$adfLinkedserviceResourceId.equals(other$adfLinkedserviceResourceId)) {
            return false;
        }
        String this$adfLinkedserviceRoleName = this.getAdfLinkedserviceRoleName();
        String other$adfLinkedserviceRoleName = other.getAdfLinkedserviceRoleName();
        if (this$adfLinkedserviceRoleName == null ? other$adfLinkedserviceRoleName != null : !this$adfLinkedserviceRoleName.equals(other$adfLinkedserviceRoleName)) {
            return false;
        }
        String this$adfLinkedserviceTenant = this.getAdfLinkedserviceTenant();
        String other$adfLinkedserviceTenant = other.getAdfLinkedserviceTenant();
        if (this$adfLinkedserviceTenant == null ? other$adfLinkedserviceTenant != null : !this$adfLinkedserviceTenant.equals(other$adfLinkedserviceTenant)) {
            return false;
        }
        String this$adfLinkedserviceType = this.getAdfLinkedserviceType();
        String other$adfLinkedserviceType = other.getAdfLinkedserviceType();
        if (this$adfLinkedserviceType == null ? other$adfLinkedserviceType != null : !this$adfLinkedserviceType.equals(other$adfLinkedserviceType)) {
            return false;
        }
        String this$adfLinkedserviceUserName = this.getAdfLinkedserviceUserName();
        String other$adfLinkedserviceUserName = other.getAdfLinkedserviceUserName();
        if (this$adfLinkedserviceUserName == null ? other$adfLinkedserviceUserName != null : !this$adfLinkedserviceUserName.equals(other$adfLinkedserviceUserName)) {
            return false;
        }
        String this$adfLinkedserviceVersion = this.getAdfLinkedserviceVersion();
        String other$adfLinkedserviceVersion = other.getAdfLinkedserviceVersion();
        if (this$adfLinkedserviceVersion == null ? other$adfLinkedserviceVersion != null : !this$adfLinkedserviceVersion.equals(other$adfLinkedserviceVersion)) {
            return false;
        }
        String this$adfLinkedserviceWarehouseName = this.getAdfLinkedserviceWarehouseName();
        String other$adfLinkedserviceWarehouseName = other.getAdfLinkedserviceWarehouseName();
        if (this$adfLinkedserviceWarehouseName == null ? other$adfLinkedserviceWarehouseName != null : !this$adfLinkedserviceWarehouseName.equals(other$adfLinkedserviceWarehouseName)) {
            return false;
        }
        SortedSet<IAdfPipeline> this$adfPipelines = this.getAdfPipelines();
        SortedSet<IAdfPipeline> other$adfPipelines = other.getAdfPipelines();
        if (this$adfPipelines == null ? other$adfPipelines != null : !this$adfPipelines.equals(other$adfPipelines)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdfLinkedservice;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $adfLinkedserviceVersionAbove = this.getAdfLinkedserviceVersionAbove();
        result = result * 59 + ($adfLinkedserviceVersionAbove == null ? 43 : ((Object)$adfLinkedserviceVersionAbove).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAdfActivity> $adfActivities = this.getAdfActivities();
        result = result * 59 + ($adfActivities == null ? 43 : $adfActivities.hashCode());
        String $adfAssetFolderPath = this.getAdfAssetFolderPath();
        result = result * 59 + ($adfAssetFolderPath == null ? 43 : $adfAssetFolderPath.hashCode());
        SortedSet<IAdfDataflow> $adfDataflows = this.getAdfDataflows();
        result = result * 59 + ($adfDataflows == null ? 43 : $adfDataflows.hashCode());
        SortedSet<IAdfDataset> $adfDatasets = this.getAdfDatasets();
        result = result * 59 + ($adfDatasets == null ? 43 : $adfDatasets.hashCode());
        String $adfFactoryName = this.getAdfFactoryName();
        result = result * 59 + ($adfFactoryName == null ? 43 : $adfFactoryName.hashCode());
        String $adfLinkedserviceAccountName = this.getAdfLinkedserviceAccountName();
        result = result * 59 + ($adfLinkedserviceAccountName == null ? 43 : $adfLinkedserviceAccountName.hashCode());
        SortedSet<String> $adfLinkedserviceAnnotations = this.getAdfLinkedserviceAnnotations();
        result = result * 59 + ($adfLinkedserviceAnnotations == null ? 43 : $adfLinkedserviceAnnotations.hashCode());
        String $adfLinkedserviceAzureCloudType = this.getAdfLinkedserviceAzureCloudType();
        result = result * 59 + ($adfLinkedserviceAzureCloudType == null ? 43 : $adfLinkedserviceAzureCloudType.hashCode());
        String $adfLinkedserviceClusterId = this.getAdfLinkedserviceClusterId();
        result = result * 59 + ($adfLinkedserviceClusterId == null ? 43 : $adfLinkedserviceClusterId.hashCode());
        String $adfLinkedserviceCredentialType = this.getAdfLinkedserviceCredentialType();
        result = result * 59 + ($adfLinkedserviceCredentialType == null ? 43 : $adfLinkedserviceCredentialType.hashCode());
        String $adfLinkedserviceDatabaseName = this.getAdfLinkedserviceDatabaseName();
        result = result * 59 + ($adfLinkedserviceDatabaseName == null ? 43 : $adfLinkedserviceDatabaseName.hashCode());
        String $adfLinkedserviceDomainEndpoint = this.getAdfLinkedserviceDomainEndpoint();
        result = result * 59 + ($adfLinkedserviceDomainEndpoint == null ? 43 : $adfLinkedserviceDomainEndpoint.hashCode());
        String $adfLinkedserviceResourceId = this.getAdfLinkedserviceResourceId();
        result = result * 59 + ($adfLinkedserviceResourceId == null ? 43 : $adfLinkedserviceResourceId.hashCode());
        String $adfLinkedserviceRoleName = this.getAdfLinkedserviceRoleName();
        result = result * 59 + ($adfLinkedserviceRoleName == null ? 43 : $adfLinkedserviceRoleName.hashCode());
        String $adfLinkedserviceTenant = this.getAdfLinkedserviceTenant();
        result = result * 59 + ($adfLinkedserviceTenant == null ? 43 : $adfLinkedserviceTenant.hashCode());
        String $adfLinkedserviceType = this.getAdfLinkedserviceType();
        result = result * 59 + ($adfLinkedserviceType == null ? 43 : $adfLinkedserviceType.hashCode());
        String $adfLinkedserviceUserName = this.getAdfLinkedserviceUserName();
        result = result * 59 + ($adfLinkedserviceUserName == null ? 43 : $adfLinkedserviceUserName.hashCode());
        String $adfLinkedserviceVersion = this.getAdfLinkedserviceVersion();
        result = result * 59 + ($adfLinkedserviceVersion == null ? 43 : $adfLinkedserviceVersion.hashCode());
        String $adfLinkedserviceWarehouseName = this.getAdfLinkedserviceWarehouseName();
        result = result * 59 + ($adfLinkedserviceWarehouseName == null ? 43 : $adfLinkedserviceWarehouseName.hashCode());
        SortedSet<IAdfPipeline> $adfPipelines = this.getAdfPipelines();
        result = result * 59 + ($adfPipelines == null ? 43 : $adfPipelines.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AdfLinkedservice(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", adfActivities=" + String.valueOf(this.getAdfActivities()) + ", adfAssetFolderPath=" + this.getAdfAssetFolderPath() + ", adfDataflows=" + String.valueOf(this.getAdfDataflows()) + ", adfDatasets=" + String.valueOf(this.getAdfDatasets()) + ", adfFactoryName=" + this.getAdfFactoryName() + ", adfLinkedserviceAccountName=" + this.getAdfLinkedserviceAccountName() + ", adfLinkedserviceAnnotations=" + String.valueOf(this.getAdfLinkedserviceAnnotations()) + ", adfLinkedserviceAzureCloudType=" + this.getAdfLinkedserviceAzureCloudType() + ", adfLinkedserviceClusterId=" + this.getAdfLinkedserviceClusterId() + ", adfLinkedserviceCredentialType=" + this.getAdfLinkedserviceCredentialType() + ", adfLinkedserviceDatabaseName=" + this.getAdfLinkedserviceDatabaseName() + ", adfLinkedserviceDomainEndpoint=" + this.getAdfLinkedserviceDomainEndpoint() + ", adfLinkedserviceResourceId=" + this.getAdfLinkedserviceResourceId() + ", adfLinkedserviceRoleName=" + this.getAdfLinkedserviceRoleName() + ", adfLinkedserviceTenant=" + this.getAdfLinkedserviceTenant() + ", adfLinkedserviceType=" + this.getAdfLinkedserviceType() + ", adfLinkedserviceUserName=" + this.getAdfLinkedserviceUserName() + ", adfLinkedserviceVersion=" + this.getAdfLinkedserviceVersion() + ", adfLinkedserviceVersionAbove=" + this.getAdfLinkedserviceVersionAbove() + ", adfLinkedserviceWarehouseName=" + this.getAdfLinkedserviceWarehouseName() + ", adfPipelines=" + String.valueOf(this.getAdfPipelines()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AdfLinkedserviceBuilder<C extends AdfLinkedservice, B extends AdfLinkedserviceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAdfActivity> adfActivities;
        @Generated
        private String adfAssetFolderPath;
        @Generated
        private ArrayList<IAdfDataflow> adfDataflows;
        @Generated
        private ArrayList<IAdfDataset> adfDatasets;
        @Generated
        private String adfFactoryName;
        @Generated
        private String adfLinkedserviceAccountName;
        @Generated
        private ArrayList<String> adfLinkedserviceAnnotations;
        @Generated
        private String adfLinkedserviceAzureCloudType;
        @Generated
        private String adfLinkedserviceClusterId;
        @Generated
        private String adfLinkedserviceCredentialType;
        @Generated
        private String adfLinkedserviceDatabaseName;
        @Generated
        private String adfLinkedserviceDomainEndpoint;
        @Generated
        private String adfLinkedserviceResourceId;
        @Generated
        private String adfLinkedserviceRoleName;
        @Generated
        private String adfLinkedserviceTenant;
        @Generated
        private String adfLinkedserviceType;
        @Generated
        private String adfLinkedserviceUserName;
        @Generated
        private String adfLinkedserviceVersion;
        @Generated
        private Boolean adfLinkedserviceVersionAbove;
        @Generated
        private String adfLinkedserviceWarehouseName;
        @Generated
        private ArrayList<IAdfPipeline> adfPipelines;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AdfLinkedserviceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AdfLinkedservice instance, AdfLinkedserviceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.adfActivities(instance.adfActivities == null ? Collections.emptySortedSet() : instance.adfActivities);
            b.adfAssetFolderPath(instance.adfAssetFolderPath);
            b.adfDataflows(instance.adfDataflows == null ? Collections.emptySortedSet() : instance.adfDataflows);
            b.adfDatasets(instance.adfDatasets == null ? Collections.emptySortedSet() : instance.adfDatasets);
            b.adfFactoryName(instance.adfFactoryName);
            b.adfLinkedserviceAccountName(instance.adfLinkedserviceAccountName);
            b.adfLinkedserviceAnnotations(instance.adfLinkedserviceAnnotations == null ? Collections.emptySortedSet() : instance.adfLinkedserviceAnnotations);
            b.adfLinkedserviceAzureCloudType(instance.adfLinkedserviceAzureCloudType);
            b.adfLinkedserviceClusterId(instance.adfLinkedserviceClusterId);
            b.adfLinkedserviceCredentialType(instance.adfLinkedserviceCredentialType);
            b.adfLinkedserviceDatabaseName(instance.adfLinkedserviceDatabaseName);
            b.adfLinkedserviceDomainEndpoint(instance.adfLinkedserviceDomainEndpoint);
            b.adfLinkedserviceResourceId(instance.adfLinkedserviceResourceId);
            b.adfLinkedserviceRoleName(instance.adfLinkedserviceRoleName);
            b.adfLinkedserviceTenant(instance.adfLinkedserviceTenant);
            b.adfLinkedserviceType(instance.adfLinkedserviceType);
            b.adfLinkedserviceUserName(instance.adfLinkedserviceUserName);
            b.adfLinkedserviceVersion(instance.adfLinkedserviceVersion);
            b.adfLinkedserviceVersionAbove(instance.adfLinkedserviceVersionAbove);
            b.adfLinkedserviceWarehouseName(instance.adfLinkedserviceWarehouseName);
            b.adfPipelines(instance.adfPipelines == null ? Collections.emptySortedSet() : instance.adfPipelines);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B adfActivity(IAdfActivity adfActivity) {
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.add(adfActivity);
            return (B)this.self();
        }

        @Generated
        public B adfActivities(Collection<? extends IAdfActivity> adfActivities) {
            if (adfActivities == null) {
                throw new NullPointerException("adfActivities cannot be null");
            }
            if (this.adfActivities == null) {
                this.adfActivities = new ArrayList();
            }
            this.adfActivities.addAll(adfActivities);
            return (B)this.self();
        }

        @Generated
        public B clearAdfActivities() {
            if (this.adfActivities != null) {
                this.adfActivities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfAssetFolderPath(String adfAssetFolderPath) {
            this.adfAssetFolderPath = adfAssetFolderPath;
            return (B)this.self();
        }

        @Generated
        public B adfDataflow(IAdfDataflow adfDataflow) {
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.add(adfDataflow);
            return (B)this.self();
        }

        @Generated
        public B adfDataflows(Collection<? extends IAdfDataflow> adfDataflows) {
            if (adfDataflows == null) {
                throw new NullPointerException("adfDataflows cannot be null");
            }
            if (this.adfDataflows == null) {
                this.adfDataflows = new ArrayList();
            }
            this.adfDataflows.addAll(adfDataflows);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDataflows() {
            if (this.adfDataflows != null) {
                this.adfDataflows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfDataset(IAdfDataset adfDataset) {
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.add(adfDataset);
            return (B)this.self();
        }

        @Generated
        public B adfDatasets(Collection<? extends IAdfDataset> adfDatasets) {
            if (adfDatasets == null) {
                throw new NullPointerException("adfDatasets cannot be null");
            }
            if (this.adfDatasets == null) {
                this.adfDatasets = new ArrayList();
            }
            this.adfDatasets.addAll(adfDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearAdfDatasets() {
            if (this.adfDatasets != null) {
                this.adfDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfFactoryName(String adfFactoryName) {
            this.adfFactoryName = adfFactoryName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceAccountName(String adfLinkedserviceAccountName) {
            this.adfLinkedserviceAccountName = adfLinkedserviceAccountName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceAnnotation(String adfLinkedserviceAnnotation) {
            if (this.adfLinkedserviceAnnotations == null) {
                this.adfLinkedserviceAnnotations = new ArrayList();
            }
            this.adfLinkedserviceAnnotations.add(adfLinkedserviceAnnotation);
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceAnnotations(Collection<? extends String> adfLinkedserviceAnnotations) {
            if (adfLinkedserviceAnnotations == null) {
                throw new NullPointerException("adfLinkedserviceAnnotations cannot be null");
            }
            if (this.adfLinkedserviceAnnotations == null) {
                this.adfLinkedserviceAnnotations = new ArrayList();
            }
            this.adfLinkedserviceAnnotations.addAll(adfLinkedserviceAnnotations);
            return (B)this.self();
        }

        @Generated
        public B clearAdfLinkedserviceAnnotations() {
            if (this.adfLinkedserviceAnnotations != null) {
                this.adfLinkedserviceAnnotations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceAzureCloudType(String adfLinkedserviceAzureCloudType) {
            this.adfLinkedserviceAzureCloudType = adfLinkedserviceAzureCloudType;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceClusterId(String adfLinkedserviceClusterId) {
            this.adfLinkedserviceClusterId = adfLinkedserviceClusterId;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceCredentialType(String adfLinkedserviceCredentialType) {
            this.adfLinkedserviceCredentialType = adfLinkedserviceCredentialType;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceDatabaseName(String adfLinkedserviceDatabaseName) {
            this.adfLinkedserviceDatabaseName = adfLinkedserviceDatabaseName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceDomainEndpoint(String adfLinkedserviceDomainEndpoint) {
            this.adfLinkedserviceDomainEndpoint = adfLinkedserviceDomainEndpoint;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceResourceId(String adfLinkedserviceResourceId) {
            this.adfLinkedserviceResourceId = adfLinkedserviceResourceId;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceRoleName(String adfLinkedserviceRoleName) {
            this.adfLinkedserviceRoleName = adfLinkedserviceRoleName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceTenant(String adfLinkedserviceTenant) {
            this.adfLinkedserviceTenant = adfLinkedserviceTenant;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceType(String adfLinkedserviceType) {
            this.adfLinkedserviceType = adfLinkedserviceType;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceUserName(String adfLinkedserviceUserName) {
            this.adfLinkedserviceUserName = adfLinkedserviceUserName;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceVersion(String adfLinkedserviceVersion) {
            this.adfLinkedserviceVersion = adfLinkedserviceVersion;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceVersionAbove(Boolean adfLinkedserviceVersionAbove) {
            this.adfLinkedserviceVersionAbove = adfLinkedserviceVersionAbove;
            return (B)this.self();
        }

        @Generated
        public B adfLinkedserviceWarehouseName(String adfLinkedserviceWarehouseName) {
            this.adfLinkedserviceWarehouseName = adfLinkedserviceWarehouseName;
            return (B)this.self();
        }

        @Generated
        public B adfPipeline(IAdfPipeline adfPipeline) {
            if (this.adfPipelines == null) {
                this.adfPipelines = new ArrayList();
            }
            this.adfPipelines.add(adfPipeline);
            return (B)this.self();
        }

        @Generated
        public B adfPipelines(Collection<? extends IAdfPipeline> adfPipelines) {
            if (adfPipelines == null) {
                throw new NullPointerException("adfPipelines cannot be null");
            }
            if (this.adfPipelines == null) {
                this.adfPipelines = new ArrayList();
            }
            this.adfPipelines.addAll(adfPipelines);
            return (B)this.self();
        }

        @Generated
        public B clearAdfPipelines() {
            if (this.adfPipelines != null) {
                this.adfPipelines.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AdfLinkedservice.AdfLinkedserviceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", adfActivities=" + String.valueOf(this.adfActivities) + ", adfAssetFolderPath=" + this.adfAssetFolderPath + ", adfDataflows=" + String.valueOf(this.adfDataflows) + ", adfDatasets=" + String.valueOf(this.adfDatasets) + ", adfFactoryName=" + this.adfFactoryName + ", adfLinkedserviceAccountName=" + this.adfLinkedserviceAccountName + ", adfLinkedserviceAnnotations=" + String.valueOf(this.adfLinkedserviceAnnotations) + ", adfLinkedserviceAzureCloudType=" + this.adfLinkedserviceAzureCloudType + ", adfLinkedserviceClusterId=" + this.adfLinkedserviceClusterId + ", adfLinkedserviceCredentialType=" + this.adfLinkedserviceCredentialType + ", adfLinkedserviceDatabaseName=" + this.adfLinkedserviceDatabaseName + ", adfLinkedserviceDomainEndpoint=" + this.adfLinkedserviceDomainEndpoint + ", adfLinkedserviceResourceId=" + this.adfLinkedserviceResourceId + ", adfLinkedserviceRoleName=" + this.adfLinkedserviceRoleName + ", adfLinkedserviceTenant=" + this.adfLinkedserviceTenant + ", adfLinkedserviceType=" + this.adfLinkedserviceType + ", adfLinkedserviceUserName=" + this.adfLinkedserviceUserName + ", adfLinkedserviceVersion=" + this.adfLinkedserviceVersion + ", adfLinkedserviceVersionAbove=" + this.adfLinkedserviceVersionAbove + ", adfLinkedserviceWarehouseName=" + this.adfLinkedserviceWarehouseName + ", adfPipelines=" + String.valueOf(this.adfPipelines) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AdfLinkedserviceBuilderImpl
    extends AdfLinkedserviceBuilder<AdfLinkedservice, AdfLinkedserviceBuilderImpl> {
        @Generated
        private AdfLinkedserviceBuilderImpl() {
        }

        @Override
        @Generated
        protected AdfLinkedserviceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AdfLinkedservice build() {
            return new AdfLinkedservice(this);
        }
    }
}

