/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AirflowDag;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflow;
import com.atlan.model.assets.IAirflowDag;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.OpenLineageRunState;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowTask
extends Asset
implements IAirflowTask,
IAirflow,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AirflowTask.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AirflowTask";
    String typeName;
    @Attribute
    IAirflowDag airflowDag;
    @Attribute
    String airflowDagName;
    @Attribute
    String airflowDagQualifiedName;
    @Attribute
    @Date
    Long airflowRunEndTime;
    @Attribute
    String airflowRunName;
    @Attribute
    OpenLineageRunState airflowRunOpenLineageState;
    @Attribute
    String airflowRunOpenLineageVersion;
    @Attribute
    @Date
    Long airflowRunStartTime;
    @Attribute
    String airflowRunType;
    @Attribute
    String airflowRunVersion;
    @Attribute
    SortedSet<String> airflowTags;
    @Attribute
    String airflowTaskConnectionId;
    @Attribute
    String airflowTaskGroupName;
    @Attribute
    String airflowTaskOperatorClass;
    @Attribute
    String airflowTaskPool;
    @Attribute
    Long airflowTaskPoolSlots;
    @Attribute
    Long airflowTaskPriorityWeight;
    @Attribute
    String airflowTaskQueue;
    @Attribute
    Long airflowTaskRetryNumber;
    @Attribute
    String airflowTaskSql;
    @Attribute
    String airflowTaskTriggerRule;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    ILineageProcess process;

    @Override
    public AirflowTask trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AirflowTask.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AirflowTask.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AirflowTask.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AirflowTask.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AirflowTask refByGuid(String guid) {
        return AirflowTask.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AirflowTask refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AirflowTaskBuilder)((AirflowTaskBuilder)AirflowTask._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AirflowTask refByQualifiedName(String qualifiedName) {
        return AirflowTask.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AirflowTask refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AirflowTaskBuilder)((AirflowTaskBuilder)AirflowTask._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id) throws AtlanException {
        return AirflowTask.get(client, id, false);
    }

    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AirflowTask) {
                return (AirflowTask)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AirflowTask) {
            return (AirflowTask)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AirflowTask.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AirflowTask get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AirflowTask.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AirflowTask) {
                return (AirflowTask)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AirflowTask.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AirflowTask) {
            return (AirflowTask)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AirflowTaskBuilder<?, ?> creator(String name, AirflowDag airflowDag) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", airflowDag.getQualifiedName());
        AirflowTask.validateRelationship("AirflowDag", map);
        return AirflowTask.creator(name, airflowDag.getQualifiedName()).airflowDag(airflowDag.trimToReference());
    }

    public static AirflowTaskBuilder<?, ?> creator(String name, String airflowDagQualifiedName) {
        String[] tokens = airflowDagQualifiedName.split("/");
        String airflowDagName = StringUtils.getNameFromQualifiedName(airflowDagQualifiedName);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(airflowDagQualifiedName);
        return (AirflowTaskBuilder)((Asset.AssetBuilder)((AirflowTaskBuilder)((AirflowTaskBuilder)((AirflowTaskBuilder)((AirflowTaskBuilder)((AirflowTaskBuilder)AirflowTask._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(airflowDagQualifiedName + "/" + name)).name(name)).airflowDagQualifiedName(airflowDagQualifiedName)).airflowDagName(airflowDagName)).airflowDag(AirflowDag.refByQualifiedName(airflowDagQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static AirflowTaskBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AirflowTaskBuilder)((AirflowTaskBuilder)((AirflowTaskBuilder)AirflowTask._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AirflowTaskBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AirflowTask.validateRequired(TYPE_NAME, map);
        return AirflowTask.updater(this.getQualifiedName(), this.getName());
    }

    public static AirflowTask removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask)Asset.removeDescription(client, AirflowTask.updater(qualifiedName, name));
    }

    public static AirflowTask removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask)Asset.removeUserDescription(client, AirflowTask.updater(qualifiedName, name));
    }

    public static AirflowTask removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask)Asset.removeOwners(client, AirflowTask.updater(qualifiedName, name));
    }

    public static AirflowTask updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AirflowTask)Asset.updateCertificate(client, AirflowTask._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AirflowTask removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask)Asset.removeCertificate(client, AirflowTask.updater(qualifiedName, name));
    }

    public static AirflowTask updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AirflowTask)Asset.updateAnnouncement(client, AirflowTask._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AirflowTask removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AirflowTask)Asset.removeAnnouncement(client, AirflowTask.updater(qualifiedName, name));
    }

    public static AirflowTask replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask)Asset.replaceTerms(client, AirflowTask.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AirflowTask appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AirflowTask removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AirflowTask)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AirflowTask appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AirflowTask)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AirflowTask appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AirflowTask)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AirflowTask(AirflowTaskBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AirflowTask.$default$typeName();
        this.airflowDag = b.airflowDag;
        this.airflowDagName = b.airflowDagName;
        this.airflowDagQualifiedName = b.airflowDagQualifiedName;
        this.airflowRunEndTime = b.airflowRunEndTime;
        this.airflowRunName = b.airflowRunName;
        this.airflowRunOpenLineageState = b.airflowRunOpenLineageState;
        this.airflowRunOpenLineageVersion = b.airflowRunOpenLineageVersion;
        this.airflowRunStartTime = b.airflowRunStartTime;
        this.airflowRunType = b.airflowRunType;
        this.airflowRunVersion = b.airflowRunVersion;
        SortedSet<String> airflowTags = new TreeSet<String>();
        if (b.airflowTags != null) {
            airflowTags.addAll(b.airflowTags);
        }
        airflowTags = Collections.unmodifiableSortedSet(airflowTags);
        this.airflowTags = airflowTags;
        this.airflowTaskConnectionId = b.airflowTaskConnectionId;
        this.airflowTaskGroupName = b.airflowTaskGroupName;
        this.airflowTaskOperatorClass = b.airflowTaskOperatorClass;
        this.airflowTaskPool = b.airflowTaskPool;
        this.airflowTaskPoolSlots = b.airflowTaskPoolSlots;
        this.airflowTaskPriorityWeight = b.airflowTaskPriorityWeight;
        this.airflowTaskQueue = b.airflowTaskQueue;
        this.airflowTaskRetryNumber = b.airflowTaskRetryNumber;
        this.airflowTaskSql = b.airflowTaskSql;
        this.airflowTaskTriggerRule = b.airflowTaskTriggerRule;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.process = b.process;
    }

    @Generated
    public static AirflowTaskBuilder<?, ?> _internal() {
        return new AirflowTaskBuilderImpl();
    }

    @Generated
    public AirflowTaskBuilder<?, ?> toBuilder() {
        return new AirflowTaskBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IAirflowDag getAirflowDag() {
        return this.airflowDag;
    }

    @Override
    @Generated
    public String getAirflowDagName() {
        return this.airflowDagName;
    }

    @Override
    @Generated
    public String getAirflowDagQualifiedName() {
        return this.airflowDagQualifiedName;
    }

    @Override
    @Generated
    public Long getAirflowRunEndTime() {
        return this.airflowRunEndTime;
    }

    @Override
    @Generated
    public String getAirflowRunName() {
        return this.airflowRunName;
    }

    @Override
    @Generated
    public OpenLineageRunState getAirflowRunOpenLineageState() {
        return this.airflowRunOpenLineageState;
    }

    @Override
    @Generated
    public String getAirflowRunOpenLineageVersion() {
        return this.airflowRunOpenLineageVersion;
    }

    @Override
    @Generated
    public Long getAirflowRunStartTime() {
        return this.airflowRunStartTime;
    }

    @Override
    @Generated
    public String getAirflowRunType() {
        return this.airflowRunType;
    }

    @Override
    @Generated
    public String getAirflowRunVersion() {
        return this.airflowRunVersion;
    }

    @Override
    @Generated
    public SortedSet<String> getAirflowTags() {
        return this.airflowTags;
    }

    @Override
    @Generated
    public String getAirflowTaskConnectionId() {
        return this.airflowTaskConnectionId;
    }

    @Override
    @Generated
    public String getAirflowTaskGroupName() {
        return this.airflowTaskGroupName;
    }

    @Override
    @Generated
    public String getAirflowTaskOperatorClass() {
        return this.airflowTaskOperatorClass;
    }

    @Override
    @Generated
    public String getAirflowTaskPool() {
        return this.airflowTaskPool;
    }

    @Override
    @Generated
    public Long getAirflowTaskPoolSlots() {
        return this.airflowTaskPoolSlots;
    }

    @Override
    @Generated
    public Long getAirflowTaskPriorityWeight() {
        return this.airflowTaskPriorityWeight;
    }

    @Override
    @Generated
    public String getAirflowTaskQueue() {
        return this.airflowTaskQueue;
    }

    @Override
    @Generated
    public Long getAirflowTaskRetryNumber() {
        return this.airflowTaskRetryNumber;
    }

    @Override
    @Generated
    public String getAirflowTaskSql() {
        return this.airflowTaskSql;
    }

    @Override
    @Generated
    public String getAirflowTaskTriggerRule() {
        return this.airflowTaskTriggerRule;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public ILineageProcess getProcess() {
        return this.process;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirflowTask)) {
            return false;
        }
        AirflowTask other = (AirflowTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$airflowRunEndTime = this.getAirflowRunEndTime();
        Long other$airflowRunEndTime = other.getAirflowRunEndTime();
        if (this$airflowRunEndTime == null ? other$airflowRunEndTime != null : !((Object)this$airflowRunEndTime).equals(other$airflowRunEndTime)) {
            return false;
        }
        Long this$airflowRunStartTime = this.getAirflowRunStartTime();
        Long other$airflowRunStartTime = other.getAirflowRunStartTime();
        if (this$airflowRunStartTime == null ? other$airflowRunStartTime != null : !((Object)this$airflowRunStartTime).equals(other$airflowRunStartTime)) {
            return false;
        }
        Long this$airflowTaskPoolSlots = this.getAirflowTaskPoolSlots();
        Long other$airflowTaskPoolSlots = other.getAirflowTaskPoolSlots();
        if (this$airflowTaskPoolSlots == null ? other$airflowTaskPoolSlots != null : !((Object)this$airflowTaskPoolSlots).equals(other$airflowTaskPoolSlots)) {
            return false;
        }
        Long this$airflowTaskPriorityWeight = this.getAirflowTaskPriorityWeight();
        Long other$airflowTaskPriorityWeight = other.getAirflowTaskPriorityWeight();
        if (this$airflowTaskPriorityWeight == null ? other$airflowTaskPriorityWeight != null : !((Object)this$airflowTaskPriorityWeight).equals(other$airflowTaskPriorityWeight)) {
            return false;
        }
        Long this$airflowTaskRetryNumber = this.getAirflowTaskRetryNumber();
        Long other$airflowTaskRetryNumber = other.getAirflowTaskRetryNumber();
        if (this$airflowTaskRetryNumber == null ? other$airflowTaskRetryNumber != null : !((Object)this$airflowTaskRetryNumber).equals(other$airflowTaskRetryNumber)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IAirflowDag this$airflowDag = this.getAirflowDag();
        IAirflowDag other$airflowDag = other.getAirflowDag();
        if (this$airflowDag == null ? other$airflowDag != null : !this$airflowDag.equals(other$airflowDag)) {
            return false;
        }
        String this$airflowDagName = this.getAirflowDagName();
        String other$airflowDagName = other.getAirflowDagName();
        if (this$airflowDagName == null ? other$airflowDagName != null : !this$airflowDagName.equals(other$airflowDagName)) {
            return false;
        }
        String this$airflowDagQualifiedName = this.getAirflowDagQualifiedName();
        String other$airflowDagQualifiedName = other.getAirflowDagQualifiedName();
        if (this$airflowDagQualifiedName == null ? other$airflowDagQualifiedName != null : !this$airflowDagQualifiedName.equals(other$airflowDagQualifiedName)) {
            return false;
        }
        String this$airflowRunName = this.getAirflowRunName();
        String other$airflowRunName = other.getAirflowRunName();
        if (this$airflowRunName == null ? other$airflowRunName != null : !this$airflowRunName.equals(other$airflowRunName)) {
            return false;
        }
        OpenLineageRunState this$airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        OpenLineageRunState other$airflowRunOpenLineageState = other.getAirflowRunOpenLineageState();
        if (this$airflowRunOpenLineageState == null ? other$airflowRunOpenLineageState != null : !this$airflowRunOpenLineageState.equals(other$airflowRunOpenLineageState)) {
            return false;
        }
        String this$airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        String other$airflowRunOpenLineageVersion = other.getAirflowRunOpenLineageVersion();
        if (this$airflowRunOpenLineageVersion == null ? other$airflowRunOpenLineageVersion != null : !this$airflowRunOpenLineageVersion.equals(other$airflowRunOpenLineageVersion)) {
            return false;
        }
        String this$airflowRunType = this.getAirflowRunType();
        String other$airflowRunType = other.getAirflowRunType();
        if (this$airflowRunType == null ? other$airflowRunType != null : !this$airflowRunType.equals(other$airflowRunType)) {
            return false;
        }
        String this$airflowRunVersion = this.getAirflowRunVersion();
        String other$airflowRunVersion = other.getAirflowRunVersion();
        if (this$airflowRunVersion == null ? other$airflowRunVersion != null : !this$airflowRunVersion.equals(other$airflowRunVersion)) {
            return false;
        }
        SortedSet<String> this$airflowTags = this.getAirflowTags();
        SortedSet<String> other$airflowTags = other.getAirflowTags();
        if (this$airflowTags == null ? other$airflowTags != null : !this$airflowTags.equals(other$airflowTags)) {
            return false;
        }
        String this$airflowTaskConnectionId = this.getAirflowTaskConnectionId();
        String other$airflowTaskConnectionId = other.getAirflowTaskConnectionId();
        if (this$airflowTaskConnectionId == null ? other$airflowTaskConnectionId != null : !this$airflowTaskConnectionId.equals(other$airflowTaskConnectionId)) {
            return false;
        }
        String this$airflowTaskGroupName = this.getAirflowTaskGroupName();
        String other$airflowTaskGroupName = other.getAirflowTaskGroupName();
        if (this$airflowTaskGroupName == null ? other$airflowTaskGroupName != null : !this$airflowTaskGroupName.equals(other$airflowTaskGroupName)) {
            return false;
        }
        String this$airflowTaskOperatorClass = this.getAirflowTaskOperatorClass();
        String other$airflowTaskOperatorClass = other.getAirflowTaskOperatorClass();
        if (this$airflowTaskOperatorClass == null ? other$airflowTaskOperatorClass != null : !this$airflowTaskOperatorClass.equals(other$airflowTaskOperatorClass)) {
            return false;
        }
        String this$airflowTaskPool = this.getAirflowTaskPool();
        String other$airflowTaskPool = other.getAirflowTaskPool();
        if (this$airflowTaskPool == null ? other$airflowTaskPool != null : !this$airflowTaskPool.equals(other$airflowTaskPool)) {
            return false;
        }
        String this$airflowTaskQueue = this.getAirflowTaskQueue();
        String other$airflowTaskQueue = other.getAirflowTaskQueue();
        if (this$airflowTaskQueue == null ? other$airflowTaskQueue != null : !this$airflowTaskQueue.equals(other$airflowTaskQueue)) {
            return false;
        }
        String this$airflowTaskSql = this.getAirflowTaskSql();
        String other$airflowTaskSql = other.getAirflowTaskSql();
        if (this$airflowTaskSql == null ? other$airflowTaskSql != null : !this$airflowTaskSql.equals(other$airflowTaskSql)) {
            return false;
        }
        String this$airflowTaskTriggerRule = this.getAirflowTaskTriggerRule();
        String other$airflowTaskTriggerRule = other.getAirflowTaskTriggerRule();
        if (this$airflowTaskTriggerRule == null ? other$airflowTaskTriggerRule != null : !this$airflowTaskTriggerRule.equals(other$airflowTaskTriggerRule)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        ILineageProcess this$process = this.getProcess();
        ILineageProcess other$process = other.getProcess();
        return !(this$process == null ? other$process != null : !this$process.equals(other$process));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AirflowTask;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $airflowRunEndTime = this.getAirflowRunEndTime();
        result = result * 59 + ($airflowRunEndTime == null ? 43 : ((Object)$airflowRunEndTime).hashCode());
        Long $airflowRunStartTime = this.getAirflowRunStartTime();
        result = result * 59 + ($airflowRunStartTime == null ? 43 : ((Object)$airflowRunStartTime).hashCode());
        Long $airflowTaskPoolSlots = this.getAirflowTaskPoolSlots();
        result = result * 59 + ($airflowTaskPoolSlots == null ? 43 : ((Object)$airflowTaskPoolSlots).hashCode());
        Long $airflowTaskPriorityWeight = this.getAirflowTaskPriorityWeight();
        result = result * 59 + ($airflowTaskPriorityWeight == null ? 43 : ((Object)$airflowTaskPriorityWeight).hashCode());
        Long $airflowTaskRetryNumber = this.getAirflowTaskRetryNumber();
        result = result * 59 + ($airflowTaskRetryNumber == null ? 43 : ((Object)$airflowTaskRetryNumber).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IAirflowDag $airflowDag = this.getAirflowDag();
        result = result * 59 + ($airflowDag == null ? 43 : $airflowDag.hashCode());
        String $airflowDagName = this.getAirflowDagName();
        result = result * 59 + ($airflowDagName == null ? 43 : $airflowDagName.hashCode());
        String $airflowDagQualifiedName = this.getAirflowDagQualifiedName();
        result = result * 59 + ($airflowDagQualifiedName == null ? 43 : $airflowDagQualifiedName.hashCode());
        String $airflowRunName = this.getAirflowRunName();
        result = result * 59 + ($airflowRunName == null ? 43 : $airflowRunName.hashCode());
        OpenLineageRunState $airflowRunOpenLineageState = this.getAirflowRunOpenLineageState();
        result = result * 59 + ($airflowRunOpenLineageState == null ? 43 : $airflowRunOpenLineageState.hashCode());
        String $airflowRunOpenLineageVersion = this.getAirflowRunOpenLineageVersion();
        result = result * 59 + ($airflowRunOpenLineageVersion == null ? 43 : $airflowRunOpenLineageVersion.hashCode());
        String $airflowRunType = this.getAirflowRunType();
        result = result * 59 + ($airflowRunType == null ? 43 : $airflowRunType.hashCode());
        String $airflowRunVersion = this.getAirflowRunVersion();
        result = result * 59 + ($airflowRunVersion == null ? 43 : $airflowRunVersion.hashCode());
        SortedSet<String> $airflowTags = this.getAirflowTags();
        result = result * 59 + ($airflowTags == null ? 43 : $airflowTags.hashCode());
        String $airflowTaskConnectionId = this.getAirflowTaskConnectionId();
        result = result * 59 + ($airflowTaskConnectionId == null ? 43 : $airflowTaskConnectionId.hashCode());
        String $airflowTaskGroupName = this.getAirflowTaskGroupName();
        result = result * 59 + ($airflowTaskGroupName == null ? 43 : $airflowTaskGroupName.hashCode());
        String $airflowTaskOperatorClass = this.getAirflowTaskOperatorClass();
        result = result * 59 + ($airflowTaskOperatorClass == null ? 43 : $airflowTaskOperatorClass.hashCode());
        String $airflowTaskPool = this.getAirflowTaskPool();
        result = result * 59 + ($airflowTaskPool == null ? 43 : $airflowTaskPool.hashCode());
        String $airflowTaskQueue = this.getAirflowTaskQueue();
        result = result * 59 + ($airflowTaskQueue == null ? 43 : $airflowTaskQueue.hashCode());
        String $airflowTaskSql = this.getAirflowTaskSql();
        result = result * 59 + ($airflowTaskSql == null ? 43 : $airflowTaskSql.hashCode());
        String $airflowTaskTriggerRule = this.getAirflowTaskTriggerRule();
        result = result * 59 + ($airflowTaskTriggerRule == null ? 43 : $airflowTaskTriggerRule.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        ILineageProcess $process = this.getProcess();
        result = result * 59 + ($process == null ? 43 : $process.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AirflowTask(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", airflowDag=" + String.valueOf(this.getAirflowDag()) + ", airflowDagName=" + this.getAirflowDagName() + ", airflowDagQualifiedName=" + this.getAirflowDagQualifiedName() + ", airflowRunEndTime=" + this.getAirflowRunEndTime() + ", airflowRunName=" + this.getAirflowRunName() + ", airflowRunOpenLineageState=" + String.valueOf(this.getAirflowRunOpenLineageState()) + ", airflowRunOpenLineageVersion=" + this.getAirflowRunOpenLineageVersion() + ", airflowRunStartTime=" + this.getAirflowRunStartTime() + ", airflowRunType=" + this.getAirflowRunType() + ", airflowRunVersion=" + this.getAirflowRunVersion() + ", airflowTags=" + String.valueOf(this.getAirflowTags()) + ", airflowTaskConnectionId=" + this.getAirflowTaskConnectionId() + ", airflowTaskGroupName=" + this.getAirflowTaskGroupName() + ", airflowTaskOperatorClass=" + this.getAirflowTaskOperatorClass() + ", airflowTaskPool=" + this.getAirflowTaskPool() + ", airflowTaskPoolSlots=" + this.getAirflowTaskPoolSlots() + ", airflowTaskPriorityWeight=" + this.getAirflowTaskPriorityWeight() + ", airflowTaskQueue=" + this.getAirflowTaskQueue() + ", airflowTaskRetryNumber=" + this.getAirflowTaskRetryNumber() + ", airflowTaskSql=" + this.getAirflowTaskSql() + ", airflowTaskTriggerRule=" + this.getAirflowTaskTriggerRule() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", inputs=" + String.valueOf(this.getInputs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", process=" + String.valueOf(this.getProcess()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AirflowTaskBuilder<C extends AirflowTask, B extends AirflowTaskBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IAirflowDag airflowDag;
        @Generated
        private String airflowDagName;
        @Generated
        private String airflowDagQualifiedName;
        @Generated
        private Long airflowRunEndTime;
        @Generated
        private String airflowRunName;
        @Generated
        private OpenLineageRunState airflowRunOpenLineageState;
        @Generated
        private String airflowRunOpenLineageVersion;
        @Generated
        private Long airflowRunStartTime;
        @Generated
        private String airflowRunType;
        @Generated
        private String airflowRunVersion;
        @Generated
        private ArrayList<String> airflowTags;
        @Generated
        private String airflowTaskConnectionId;
        @Generated
        private String airflowTaskGroupName;
        @Generated
        private String airflowTaskOperatorClass;
        @Generated
        private String airflowTaskPool;
        @Generated
        private Long airflowTaskPoolSlots;
        @Generated
        private Long airflowTaskPriorityWeight;
        @Generated
        private String airflowTaskQueue;
        @Generated
        private Long airflowTaskRetryNumber;
        @Generated
        private String airflowTaskSql;
        @Generated
        private String airflowTaskTriggerRule;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private ILineageProcess process;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AirflowTaskBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AirflowTask instance, AirflowTaskBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.airflowDag(instance.airflowDag);
            b.airflowDagName(instance.airflowDagName);
            b.airflowDagQualifiedName(instance.airflowDagQualifiedName);
            b.airflowRunEndTime(instance.airflowRunEndTime);
            b.airflowRunName(instance.airflowRunName);
            b.airflowRunOpenLineageState(instance.airflowRunOpenLineageState);
            b.airflowRunOpenLineageVersion(instance.airflowRunOpenLineageVersion);
            b.airflowRunStartTime(instance.airflowRunStartTime);
            b.airflowRunType(instance.airflowRunType);
            b.airflowRunVersion(instance.airflowRunVersion);
            b.airflowTags(instance.airflowTags == null ? Collections.emptySortedSet() : instance.airflowTags);
            b.airflowTaskConnectionId(instance.airflowTaskConnectionId);
            b.airflowTaskGroupName(instance.airflowTaskGroupName);
            b.airflowTaskOperatorClass(instance.airflowTaskOperatorClass);
            b.airflowTaskPool(instance.airflowTaskPool);
            b.airflowTaskPoolSlots(instance.airflowTaskPoolSlots);
            b.airflowTaskPriorityWeight(instance.airflowTaskPriorityWeight);
            b.airflowTaskQueue(instance.airflowTaskQueue);
            b.airflowTaskRetryNumber(instance.airflowTaskRetryNumber);
            b.airflowTaskSql(instance.airflowTaskSql);
            b.airflowTaskTriggerRule(instance.airflowTaskTriggerRule);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.process(instance.process);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B airflowDag(IAirflowDag airflowDag) {
            this.airflowDag = airflowDag;
            return (B)this.self();
        }

        @Generated
        public B airflowDagName(String airflowDagName) {
            this.airflowDagName = airflowDagName;
            return (B)this.self();
        }

        @Generated
        public B airflowDagQualifiedName(String airflowDagQualifiedName) {
            this.airflowDagQualifiedName = airflowDagQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B airflowRunEndTime(Long airflowRunEndTime) {
            this.airflowRunEndTime = airflowRunEndTime;
            return (B)this.self();
        }

        @Generated
        public B airflowRunName(String airflowRunName) {
            this.airflowRunName = airflowRunName;
            return (B)this.self();
        }

        @Generated
        public B airflowRunOpenLineageState(OpenLineageRunState airflowRunOpenLineageState) {
            this.airflowRunOpenLineageState = airflowRunOpenLineageState;
            return (B)this.self();
        }

        @Generated
        public B airflowRunOpenLineageVersion(String airflowRunOpenLineageVersion) {
            this.airflowRunOpenLineageVersion = airflowRunOpenLineageVersion;
            return (B)this.self();
        }

        @Generated
        public B airflowRunStartTime(Long airflowRunStartTime) {
            this.airflowRunStartTime = airflowRunStartTime;
            return (B)this.self();
        }

        @Generated
        public B airflowRunType(String airflowRunType) {
            this.airflowRunType = airflowRunType;
            return (B)this.self();
        }

        @Generated
        public B airflowRunVersion(String airflowRunVersion) {
            this.airflowRunVersion = airflowRunVersion;
            return (B)this.self();
        }

        @Generated
        public B airflowTag(String airflowTag) {
            if (this.airflowTags == null) {
                this.airflowTags = new ArrayList();
            }
            this.airflowTags.add(airflowTag);
            return (B)this.self();
        }

        @Generated
        public B airflowTags(Collection<? extends String> airflowTags) {
            if (airflowTags == null) {
                throw new NullPointerException("airflowTags cannot be null");
            }
            if (this.airflowTags == null) {
                this.airflowTags = new ArrayList();
            }
            this.airflowTags.addAll(airflowTags);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTags() {
            if (this.airflowTags != null) {
                this.airflowTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B airflowTaskConnectionId(String airflowTaskConnectionId) {
            this.airflowTaskConnectionId = airflowTaskConnectionId;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskGroupName(String airflowTaskGroupName) {
            this.airflowTaskGroupName = airflowTaskGroupName;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskOperatorClass(String airflowTaskOperatorClass) {
            this.airflowTaskOperatorClass = airflowTaskOperatorClass;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskPool(String airflowTaskPool) {
            this.airflowTaskPool = airflowTaskPool;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskPoolSlots(Long airflowTaskPoolSlots) {
            this.airflowTaskPoolSlots = airflowTaskPoolSlots;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskPriorityWeight(Long airflowTaskPriorityWeight) {
            this.airflowTaskPriorityWeight = airflowTaskPriorityWeight;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskQueue(String airflowTaskQueue) {
            this.airflowTaskQueue = airflowTaskQueue;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskRetryNumber(Long airflowTaskRetryNumber) {
            this.airflowTaskRetryNumber = airflowTaskRetryNumber;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskSql(String airflowTaskSql) {
            this.airflowTaskSql = airflowTaskSql;
            return (B)this.self();
        }

        @Generated
        public B airflowTaskTriggerRule(String airflowTaskTriggerRule) {
            this.airflowTaskTriggerRule = airflowTaskTriggerRule;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B process(ILineageProcess process) {
            this.process = process;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AirflowTask.AirflowTaskBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", airflowDag=" + String.valueOf(this.airflowDag) + ", airflowDagName=" + this.airflowDagName + ", airflowDagQualifiedName=" + this.airflowDagQualifiedName + ", airflowRunEndTime=" + this.airflowRunEndTime + ", airflowRunName=" + this.airflowRunName + ", airflowRunOpenLineageState=" + String.valueOf(this.airflowRunOpenLineageState) + ", airflowRunOpenLineageVersion=" + this.airflowRunOpenLineageVersion + ", airflowRunStartTime=" + this.airflowRunStartTime + ", airflowRunType=" + this.airflowRunType + ", airflowRunVersion=" + this.airflowRunVersion + ", airflowTags=" + String.valueOf(this.airflowTags) + ", airflowTaskConnectionId=" + this.airflowTaskConnectionId + ", airflowTaskGroupName=" + this.airflowTaskGroupName + ", airflowTaskOperatorClass=" + this.airflowTaskOperatorClass + ", airflowTaskPool=" + this.airflowTaskPool + ", airflowTaskPoolSlots=" + this.airflowTaskPoolSlots + ", airflowTaskPriorityWeight=" + this.airflowTaskPriorityWeight + ", airflowTaskQueue=" + this.airflowTaskQueue + ", airflowTaskRetryNumber=" + this.airflowTaskRetryNumber + ", airflowTaskSql=" + this.airflowTaskSql + ", airflowTaskTriggerRule=" + this.airflowTaskTriggerRule + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", inputs=" + String.valueOf(this.inputs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", outputs=" + String.valueOf(this.outputs) + ", process=" + String.valueOf(this.process) + ")";
        }
    }

    @Generated
    private static final class AirflowTaskBuilderImpl
    extends AirflowTaskBuilder<AirflowTask, AirflowTaskBuilderImpl> {
        @Generated
        private AirflowTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected AirflowTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AirflowTask build() {
            return new AirflowTask(this);
        }
    }
}

