/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAnomalo;
import com.atlan.model.assets.IAnomaloCheck;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataQuality;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomaloCheck
extends Asset
implements IAnomaloCheck,
IAnomalo,
IDataQuality,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomaloCheck.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AnomaloCheck";
    String typeName;
    @Attribute
    IAsset anomaloCheckAsset;
    @Attribute
    String anomaloCheckCategoryType;
    @Attribute
    String anomaloCheckHistoricRunStatus;
    @Attribute
    Boolean anomaloCheckIsSystemAdded;
    @Attribute
    @Date
    Long anomaloCheckLastRunCompletedAt;
    @Attribute
    String anomaloCheckLastRunEvaluatedMessage;
    @Attribute
    String anomaloCheckLastRunUrl;
    @Attribute
    String anomaloCheckLinkedAssetQualifiedName;
    @Attribute
    String anomaloCheckPriorityLevel;
    @Attribute
    String anomaloCheckStatus;
    @Attribute
    String anomaloCheckStatusImageUrl;
    @Attribute
    String anomaloCheckType;
    @Attribute
    Boolean dqIsPartOfContract;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public AnomaloCheck trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return AnomaloCheck.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return AnomaloCheck.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return AnomaloCheck.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return AnomaloCheck.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static AnomaloCheck refByGuid(String guid) {
        return AnomaloCheck.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static AnomaloCheck refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((AnomaloCheckBuilder)((AnomaloCheckBuilder)AnomaloCheck._internal().guid(guid)).semantic(semantic)).build();
    }

    public static AnomaloCheck refByQualifiedName(String qualifiedName) {
        return AnomaloCheck.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static AnomaloCheck refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((AnomaloCheckBuilder)((AnomaloCheckBuilder)AnomaloCheck._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id) throws AtlanException {
        return AnomaloCheck.get(client, id, false);
    }

    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof AnomaloCheck) {
                return (AnomaloCheck)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof AnomaloCheck) {
            return (AnomaloCheck)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return AnomaloCheck.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static AnomaloCheck get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnomaloCheck.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof AnomaloCheck) {
                return (AnomaloCheck)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)AnomaloCheck.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof AnomaloCheck) {
            return (AnomaloCheck)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static AnomaloCheckBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AnomaloCheckBuilder)((AnomaloCheckBuilder)((AnomaloCheckBuilder)AnomaloCheck._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public AnomaloCheckBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        AnomaloCheck.validateRequired(TYPE_NAME, map);
        return AnomaloCheck.updater(this.getQualifiedName(), this.getName());
    }

    public static AnomaloCheck removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck)Asset.removeDescription(client, AnomaloCheck.updater(qualifiedName, name));
    }

    public static AnomaloCheck removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck)Asset.removeUserDescription(client, AnomaloCheck.updater(qualifiedName, name));
    }

    public static AnomaloCheck removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck)Asset.removeOwners(client, AnomaloCheck.updater(qualifiedName, name));
    }

    public static AnomaloCheck updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (AnomaloCheck)Asset.updateCertificate(client, AnomaloCheck._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AnomaloCheck removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck)Asset.removeCertificate(client, AnomaloCheck.updater(qualifiedName, name));
    }

    public static AnomaloCheck updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AnomaloCheck)Asset.updateAnnouncement(client, AnomaloCheck._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AnomaloCheck removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (AnomaloCheck)Asset.removeAnnouncement(client, AnomaloCheck.updater(qualifiedName, name));
    }

    public static AnomaloCheck replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck)Asset.replaceTerms(client, AnomaloCheck.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static AnomaloCheck appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AnomaloCheck removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (AnomaloCheck)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static AnomaloCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (AnomaloCheck)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static AnomaloCheck appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (AnomaloCheck)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AnomaloCheck(AnomaloCheckBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AnomaloCheck.$default$typeName();
        this.anomaloCheckAsset = b.anomaloCheckAsset;
        this.anomaloCheckCategoryType = b.anomaloCheckCategoryType;
        this.anomaloCheckHistoricRunStatus = b.anomaloCheckHistoricRunStatus;
        this.anomaloCheckIsSystemAdded = b.anomaloCheckIsSystemAdded;
        this.anomaloCheckLastRunCompletedAt = b.anomaloCheckLastRunCompletedAt;
        this.anomaloCheckLastRunEvaluatedMessage = b.anomaloCheckLastRunEvaluatedMessage;
        this.anomaloCheckLastRunUrl = b.anomaloCheckLastRunUrl;
        this.anomaloCheckLinkedAssetQualifiedName = b.anomaloCheckLinkedAssetQualifiedName;
        this.anomaloCheckPriorityLevel = b.anomaloCheckPriorityLevel;
        this.anomaloCheckStatus = b.anomaloCheckStatus;
        this.anomaloCheckStatusImageUrl = b.anomaloCheckStatusImageUrl;
        this.anomaloCheckType = b.anomaloCheckType;
        this.dqIsPartOfContract = b.dqIsPartOfContract;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static AnomaloCheckBuilder<?, ?> _internal() {
        return new AnomaloCheckBuilderImpl();
    }

    @Generated
    public AnomaloCheckBuilder<?, ?> toBuilder() {
        return new AnomaloCheckBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IAsset getAnomaloCheckAsset() {
        return this.anomaloCheckAsset;
    }

    @Override
    @Generated
    public String getAnomaloCheckCategoryType() {
        return this.anomaloCheckCategoryType;
    }

    @Override
    @Generated
    public String getAnomaloCheckHistoricRunStatus() {
        return this.anomaloCheckHistoricRunStatus;
    }

    @Override
    @Generated
    public Boolean getAnomaloCheckIsSystemAdded() {
        return this.anomaloCheckIsSystemAdded;
    }

    @Override
    @Generated
    public Long getAnomaloCheckLastRunCompletedAt() {
        return this.anomaloCheckLastRunCompletedAt;
    }

    @Override
    @Generated
    public String getAnomaloCheckLastRunEvaluatedMessage() {
        return this.anomaloCheckLastRunEvaluatedMessage;
    }

    @Override
    @Generated
    public String getAnomaloCheckLastRunUrl() {
        return this.anomaloCheckLastRunUrl;
    }

    @Override
    @Generated
    public String getAnomaloCheckLinkedAssetQualifiedName() {
        return this.anomaloCheckLinkedAssetQualifiedName;
    }

    @Override
    @Generated
    public String getAnomaloCheckPriorityLevel() {
        return this.anomaloCheckPriorityLevel;
    }

    @Override
    @Generated
    public String getAnomaloCheckStatus() {
        return this.anomaloCheckStatus;
    }

    @Override
    @Generated
    public String getAnomaloCheckStatusImageUrl() {
        return this.anomaloCheckStatusImageUrl;
    }

    @Override
    @Generated
    public String getAnomaloCheckType() {
        return this.anomaloCheckType;
    }

    @Override
    @Generated
    public Boolean getDqIsPartOfContract() {
        return this.dqIsPartOfContract;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnomaloCheck)) {
            return false;
        }
        AnomaloCheck other = (AnomaloCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$anomaloCheckIsSystemAdded = this.getAnomaloCheckIsSystemAdded();
        Boolean other$anomaloCheckIsSystemAdded = other.getAnomaloCheckIsSystemAdded();
        if (this$anomaloCheckIsSystemAdded == null ? other$anomaloCheckIsSystemAdded != null : !((Object)this$anomaloCheckIsSystemAdded).equals(other$anomaloCheckIsSystemAdded)) {
            return false;
        }
        Long this$anomaloCheckLastRunCompletedAt = this.getAnomaloCheckLastRunCompletedAt();
        Long other$anomaloCheckLastRunCompletedAt = other.getAnomaloCheckLastRunCompletedAt();
        if (this$anomaloCheckLastRunCompletedAt == null ? other$anomaloCheckLastRunCompletedAt != null : !((Object)this$anomaloCheckLastRunCompletedAt).equals(other$anomaloCheckLastRunCompletedAt)) {
            return false;
        }
        Boolean this$dqIsPartOfContract = this.getDqIsPartOfContract();
        Boolean other$dqIsPartOfContract = other.getDqIsPartOfContract();
        if (this$dqIsPartOfContract == null ? other$dqIsPartOfContract != null : !((Object)this$dqIsPartOfContract).equals(other$dqIsPartOfContract)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IAsset this$anomaloCheckAsset = this.getAnomaloCheckAsset();
        IAsset other$anomaloCheckAsset = other.getAnomaloCheckAsset();
        if (this$anomaloCheckAsset == null ? other$anomaloCheckAsset != null : !this$anomaloCheckAsset.equals(other$anomaloCheckAsset)) {
            return false;
        }
        String this$anomaloCheckCategoryType = this.getAnomaloCheckCategoryType();
        String other$anomaloCheckCategoryType = other.getAnomaloCheckCategoryType();
        if (this$anomaloCheckCategoryType == null ? other$anomaloCheckCategoryType != null : !this$anomaloCheckCategoryType.equals(other$anomaloCheckCategoryType)) {
            return false;
        }
        String this$anomaloCheckHistoricRunStatus = this.getAnomaloCheckHistoricRunStatus();
        String other$anomaloCheckHistoricRunStatus = other.getAnomaloCheckHistoricRunStatus();
        if (this$anomaloCheckHistoricRunStatus == null ? other$anomaloCheckHistoricRunStatus != null : !this$anomaloCheckHistoricRunStatus.equals(other$anomaloCheckHistoricRunStatus)) {
            return false;
        }
        String this$anomaloCheckLastRunEvaluatedMessage = this.getAnomaloCheckLastRunEvaluatedMessage();
        String other$anomaloCheckLastRunEvaluatedMessage = other.getAnomaloCheckLastRunEvaluatedMessage();
        if (this$anomaloCheckLastRunEvaluatedMessage == null ? other$anomaloCheckLastRunEvaluatedMessage != null : !this$anomaloCheckLastRunEvaluatedMessage.equals(other$anomaloCheckLastRunEvaluatedMessage)) {
            return false;
        }
        String this$anomaloCheckLastRunUrl = this.getAnomaloCheckLastRunUrl();
        String other$anomaloCheckLastRunUrl = other.getAnomaloCheckLastRunUrl();
        if (this$anomaloCheckLastRunUrl == null ? other$anomaloCheckLastRunUrl != null : !this$anomaloCheckLastRunUrl.equals(other$anomaloCheckLastRunUrl)) {
            return false;
        }
        String this$anomaloCheckLinkedAssetQualifiedName = this.getAnomaloCheckLinkedAssetQualifiedName();
        String other$anomaloCheckLinkedAssetQualifiedName = other.getAnomaloCheckLinkedAssetQualifiedName();
        if (this$anomaloCheckLinkedAssetQualifiedName == null ? other$anomaloCheckLinkedAssetQualifiedName != null : !this$anomaloCheckLinkedAssetQualifiedName.equals(other$anomaloCheckLinkedAssetQualifiedName)) {
            return false;
        }
        String this$anomaloCheckPriorityLevel = this.getAnomaloCheckPriorityLevel();
        String other$anomaloCheckPriorityLevel = other.getAnomaloCheckPriorityLevel();
        if (this$anomaloCheckPriorityLevel == null ? other$anomaloCheckPriorityLevel != null : !this$anomaloCheckPriorityLevel.equals(other$anomaloCheckPriorityLevel)) {
            return false;
        }
        String this$anomaloCheckStatus = this.getAnomaloCheckStatus();
        String other$anomaloCheckStatus = other.getAnomaloCheckStatus();
        if (this$anomaloCheckStatus == null ? other$anomaloCheckStatus != null : !this$anomaloCheckStatus.equals(other$anomaloCheckStatus)) {
            return false;
        }
        String this$anomaloCheckStatusImageUrl = this.getAnomaloCheckStatusImageUrl();
        String other$anomaloCheckStatusImageUrl = other.getAnomaloCheckStatusImageUrl();
        if (this$anomaloCheckStatusImageUrl == null ? other$anomaloCheckStatusImageUrl != null : !this$anomaloCheckStatusImageUrl.equals(other$anomaloCheckStatusImageUrl)) {
            return false;
        }
        String this$anomaloCheckType = this.getAnomaloCheckType();
        String other$anomaloCheckType = other.getAnomaloCheckType();
        if (this$anomaloCheckType == null ? other$anomaloCheckType != null : !this$anomaloCheckType.equals(other$anomaloCheckType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnomaloCheck;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $anomaloCheckIsSystemAdded = this.getAnomaloCheckIsSystemAdded();
        result = result * 59 + ($anomaloCheckIsSystemAdded == null ? 43 : ((Object)$anomaloCheckIsSystemAdded).hashCode());
        Long $anomaloCheckLastRunCompletedAt = this.getAnomaloCheckLastRunCompletedAt();
        result = result * 59 + ($anomaloCheckLastRunCompletedAt == null ? 43 : ((Object)$anomaloCheckLastRunCompletedAt).hashCode());
        Boolean $dqIsPartOfContract = this.getDqIsPartOfContract();
        result = result * 59 + ($dqIsPartOfContract == null ? 43 : ((Object)$dqIsPartOfContract).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IAsset $anomaloCheckAsset = this.getAnomaloCheckAsset();
        result = result * 59 + ($anomaloCheckAsset == null ? 43 : $anomaloCheckAsset.hashCode());
        String $anomaloCheckCategoryType = this.getAnomaloCheckCategoryType();
        result = result * 59 + ($anomaloCheckCategoryType == null ? 43 : $anomaloCheckCategoryType.hashCode());
        String $anomaloCheckHistoricRunStatus = this.getAnomaloCheckHistoricRunStatus();
        result = result * 59 + ($anomaloCheckHistoricRunStatus == null ? 43 : $anomaloCheckHistoricRunStatus.hashCode());
        String $anomaloCheckLastRunEvaluatedMessage = this.getAnomaloCheckLastRunEvaluatedMessage();
        result = result * 59 + ($anomaloCheckLastRunEvaluatedMessage == null ? 43 : $anomaloCheckLastRunEvaluatedMessage.hashCode());
        String $anomaloCheckLastRunUrl = this.getAnomaloCheckLastRunUrl();
        result = result * 59 + ($anomaloCheckLastRunUrl == null ? 43 : $anomaloCheckLastRunUrl.hashCode());
        String $anomaloCheckLinkedAssetQualifiedName = this.getAnomaloCheckLinkedAssetQualifiedName();
        result = result * 59 + ($anomaloCheckLinkedAssetQualifiedName == null ? 43 : $anomaloCheckLinkedAssetQualifiedName.hashCode());
        String $anomaloCheckPriorityLevel = this.getAnomaloCheckPriorityLevel();
        result = result * 59 + ($anomaloCheckPriorityLevel == null ? 43 : $anomaloCheckPriorityLevel.hashCode());
        String $anomaloCheckStatus = this.getAnomaloCheckStatus();
        result = result * 59 + ($anomaloCheckStatus == null ? 43 : $anomaloCheckStatus.hashCode());
        String $anomaloCheckStatusImageUrl = this.getAnomaloCheckStatusImageUrl();
        result = result * 59 + ($anomaloCheckStatusImageUrl == null ? 43 : $anomaloCheckStatusImageUrl.hashCode());
        String $anomaloCheckType = this.getAnomaloCheckType();
        result = result * 59 + ($anomaloCheckType == null ? 43 : $anomaloCheckType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AnomaloCheck(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", anomaloCheckAsset=" + String.valueOf(this.getAnomaloCheckAsset()) + ", anomaloCheckCategoryType=" + this.getAnomaloCheckCategoryType() + ", anomaloCheckHistoricRunStatus=" + this.getAnomaloCheckHistoricRunStatus() + ", anomaloCheckIsSystemAdded=" + this.getAnomaloCheckIsSystemAdded() + ", anomaloCheckLastRunCompletedAt=" + this.getAnomaloCheckLastRunCompletedAt() + ", anomaloCheckLastRunEvaluatedMessage=" + this.getAnomaloCheckLastRunEvaluatedMessage() + ", anomaloCheckLastRunUrl=" + this.getAnomaloCheckLastRunUrl() + ", anomaloCheckLinkedAssetQualifiedName=" + this.getAnomaloCheckLinkedAssetQualifiedName() + ", anomaloCheckPriorityLevel=" + this.getAnomaloCheckPriorityLevel() + ", anomaloCheckStatus=" + this.getAnomaloCheckStatus() + ", anomaloCheckStatusImageUrl=" + this.getAnomaloCheckStatusImageUrl() + ", anomaloCheckType=" + this.getAnomaloCheckType() + ", dqIsPartOfContract=" + this.getDqIsPartOfContract() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class AnomaloCheckBuilder<C extends AnomaloCheck, B extends AnomaloCheckBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IAsset anomaloCheckAsset;
        @Generated
        private String anomaloCheckCategoryType;
        @Generated
        private String anomaloCheckHistoricRunStatus;
        @Generated
        private Boolean anomaloCheckIsSystemAdded;
        @Generated
        private Long anomaloCheckLastRunCompletedAt;
        @Generated
        private String anomaloCheckLastRunEvaluatedMessage;
        @Generated
        private String anomaloCheckLastRunUrl;
        @Generated
        private String anomaloCheckLinkedAssetQualifiedName;
        @Generated
        private String anomaloCheckPriorityLevel;
        @Generated
        private String anomaloCheckStatus;
        @Generated
        private String anomaloCheckStatusImageUrl;
        @Generated
        private String anomaloCheckType;
        @Generated
        private Boolean dqIsPartOfContract;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AnomaloCheckBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AnomaloCheck instance, AnomaloCheckBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.anomaloCheckAsset(instance.anomaloCheckAsset);
            b.anomaloCheckCategoryType(instance.anomaloCheckCategoryType);
            b.anomaloCheckHistoricRunStatus(instance.anomaloCheckHistoricRunStatus);
            b.anomaloCheckIsSystemAdded(instance.anomaloCheckIsSystemAdded);
            b.anomaloCheckLastRunCompletedAt(instance.anomaloCheckLastRunCompletedAt);
            b.anomaloCheckLastRunEvaluatedMessage(instance.anomaloCheckLastRunEvaluatedMessage);
            b.anomaloCheckLastRunUrl(instance.anomaloCheckLastRunUrl);
            b.anomaloCheckLinkedAssetQualifiedName(instance.anomaloCheckLinkedAssetQualifiedName);
            b.anomaloCheckPriorityLevel(instance.anomaloCheckPriorityLevel);
            b.anomaloCheckStatus(instance.anomaloCheckStatus);
            b.anomaloCheckStatusImageUrl(instance.anomaloCheckStatusImageUrl);
            b.anomaloCheckType(instance.anomaloCheckType);
            b.dqIsPartOfContract(instance.dqIsPartOfContract);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckAsset(IAsset anomaloCheckAsset) {
            this.anomaloCheckAsset = anomaloCheckAsset;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckCategoryType(String anomaloCheckCategoryType) {
            this.anomaloCheckCategoryType = anomaloCheckCategoryType;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckHistoricRunStatus(String anomaloCheckHistoricRunStatus) {
            this.anomaloCheckHistoricRunStatus = anomaloCheckHistoricRunStatus;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckIsSystemAdded(Boolean anomaloCheckIsSystemAdded) {
            this.anomaloCheckIsSystemAdded = anomaloCheckIsSystemAdded;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckLastRunCompletedAt(Long anomaloCheckLastRunCompletedAt) {
            this.anomaloCheckLastRunCompletedAt = anomaloCheckLastRunCompletedAt;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckLastRunEvaluatedMessage(String anomaloCheckLastRunEvaluatedMessage) {
            this.anomaloCheckLastRunEvaluatedMessage = anomaloCheckLastRunEvaluatedMessage;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckLastRunUrl(String anomaloCheckLastRunUrl) {
            this.anomaloCheckLastRunUrl = anomaloCheckLastRunUrl;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckLinkedAssetQualifiedName(String anomaloCheckLinkedAssetQualifiedName) {
            this.anomaloCheckLinkedAssetQualifiedName = anomaloCheckLinkedAssetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckPriorityLevel(String anomaloCheckPriorityLevel) {
            this.anomaloCheckPriorityLevel = anomaloCheckPriorityLevel;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckStatus(String anomaloCheckStatus) {
            this.anomaloCheckStatus = anomaloCheckStatus;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckStatusImageUrl(String anomaloCheckStatusImageUrl) {
            this.anomaloCheckStatusImageUrl = anomaloCheckStatusImageUrl;
            return (B)this.self();
        }

        @Generated
        public B anomaloCheckType(String anomaloCheckType) {
            this.anomaloCheckType = anomaloCheckType;
            return (B)this.self();
        }

        @Generated
        public B dqIsPartOfContract(Boolean dqIsPartOfContract) {
            this.dqIsPartOfContract = dqIsPartOfContract;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AnomaloCheck.AnomaloCheckBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", anomaloCheckAsset=" + String.valueOf(this.anomaloCheckAsset) + ", anomaloCheckCategoryType=" + this.anomaloCheckCategoryType + ", anomaloCheckHistoricRunStatus=" + this.anomaloCheckHistoricRunStatus + ", anomaloCheckIsSystemAdded=" + this.anomaloCheckIsSystemAdded + ", anomaloCheckLastRunCompletedAt=" + this.anomaloCheckLastRunCompletedAt + ", anomaloCheckLastRunEvaluatedMessage=" + this.anomaloCheckLastRunEvaluatedMessage + ", anomaloCheckLastRunUrl=" + this.anomaloCheckLastRunUrl + ", anomaloCheckLinkedAssetQualifiedName=" + this.anomaloCheckLinkedAssetQualifiedName + ", anomaloCheckPriorityLevel=" + this.anomaloCheckPriorityLevel + ", anomaloCheckStatus=" + this.anomaloCheckStatus + ", anomaloCheckStatusImageUrl=" + this.anomaloCheckStatusImageUrl + ", anomaloCheckType=" + this.anomaloCheckType + ", dqIsPartOfContract=" + this.dqIsPartOfContract + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class AnomaloCheckBuilderImpl
    extends AnomaloCheckBuilder<AnomaloCheck, AnomaloCheckBuilderImpl> {
        @Generated
        private AnomaloCheckBuilderImpl() {
        }

        @Override
        @Generated
        protected AnomaloCheckBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AnomaloCheck build() {
            return new AnomaloCheck(this);
        }
    }
}

