/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBusinessPolicy;
import com.atlan.model.assets.IBusinessPolicyException;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessPolicyException
extends Asset
implements IBusinessPolicyException,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessPolicyException.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BusinessPolicyException";
    String typeName;
    @Attribute
    String businessPolicyExceptionFilterDSL;
    @Attribute
    SortedSet<String> businessPolicyExceptionGroups;
    @Attribute
    SortedSet<String> businessPolicyExceptionUsers;
    @Attribute
    IBusinessPolicy businessPolicyForException;
    @Attribute
    String businessPolicyQualifiedName;

    @Override
    public BusinessPolicyException trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return BusinessPolicyException.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return BusinessPolicyException.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return BusinessPolicyException.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return BusinessPolicyException.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static BusinessPolicyException refByGuid(String guid) {
        return BusinessPolicyException.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyException refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyExceptionBuilder)((BusinessPolicyExceptionBuilder)BusinessPolicyException._internal().guid(guid)).semantic(semantic)).build();
    }

    public static BusinessPolicyException refByQualifiedName(String qualifiedName) {
        return BusinessPolicyException.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static BusinessPolicyException refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((BusinessPolicyExceptionBuilder)((BusinessPolicyExceptionBuilder)BusinessPolicyException._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static BusinessPolicyException get(AtlanClient client, String id) throws AtlanException {
        return BusinessPolicyException.get(client, id, false);
    }

    @JsonIgnore
    public static BusinessPolicyException get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof BusinessPolicyException) {
                return (BusinessPolicyException)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof BusinessPolicyException) {
            return (BusinessPolicyException)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static BusinessPolicyException get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return BusinessPolicyException.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static BusinessPolicyException get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)BusinessPolicyException.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof BusinessPolicyException) {
                return (BusinessPolicyException)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)BusinessPolicyException.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof BusinessPolicyException) {
            return (BusinessPolicyException)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static BusinessPolicyExceptionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BusinessPolicyExceptionBuilder)((BusinessPolicyExceptionBuilder)((BusinessPolicyExceptionBuilder)BusinessPolicyException._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public BusinessPolicyExceptionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        BusinessPolicyException.validateRequired(TYPE_NAME, map);
        return BusinessPolicyException.updater(this.getQualifiedName(), this.getName());
    }

    public static BusinessPolicyException removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyException)Asset.removeDescription(client, BusinessPolicyException.updater(qualifiedName, name));
    }

    public static BusinessPolicyException removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyException)Asset.removeUserDescription(client, BusinessPolicyException.updater(qualifiedName, name));
    }

    public static BusinessPolicyException removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyException)Asset.removeOwners(client, BusinessPolicyException.updater(qualifiedName, name));
    }

    public static BusinessPolicyException updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (BusinessPolicyException)Asset.updateCertificate(client, BusinessPolicyException._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BusinessPolicyException removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyException)Asset.removeCertificate(client, BusinessPolicyException.updater(qualifiedName, name));
    }

    public static BusinessPolicyException updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BusinessPolicyException)Asset.updateAnnouncement(client, BusinessPolicyException._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BusinessPolicyException removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (BusinessPolicyException)Asset.removeAnnouncement(client, BusinessPolicyException.updater(qualifiedName, name));
    }

    public static BusinessPolicyException replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyException)Asset.replaceTerms(client, BusinessPolicyException.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static BusinessPolicyException appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyException)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static BusinessPolicyException removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (BusinessPolicyException)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static BusinessPolicyException appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (BusinessPolicyException)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static BusinessPolicyException appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (BusinessPolicyException)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BusinessPolicyException(BusinessPolicyExceptionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BusinessPolicyException.$default$typeName();
        this.businessPolicyExceptionFilterDSL = b.businessPolicyExceptionFilterDSL;
        SortedSet<String> businessPolicyExceptionGroups = new TreeSet<String>();
        if (b.businessPolicyExceptionGroups != null) {
            businessPolicyExceptionGroups.addAll(b.businessPolicyExceptionGroups);
        }
        businessPolicyExceptionGroups = Collections.unmodifiableSortedSet(businessPolicyExceptionGroups);
        this.businessPolicyExceptionGroups = businessPolicyExceptionGroups;
        SortedSet<String> businessPolicyExceptionUsers = new TreeSet<String>();
        if (b.businessPolicyExceptionUsers != null) {
            businessPolicyExceptionUsers.addAll(b.businessPolicyExceptionUsers);
        }
        businessPolicyExceptionUsers = Collections.unmodifiableSortedSet(businessPolicyExceptionUsers);
        this.businessPolicyExceptionUsers = businessPolicyExceptionUsers;
        this.businessPolicyForException = b.businessPolicyForException;
        this.businessPolicyQualifiedName = b.businessPolicyQualifiedName;
    }

    @Generated
    public static BusinessPolicyExceptionBuilder<?, ?> _internal() {
        return new BusinessPolicyExceptionBuilderImpl();
    }

    @Generated
    public BusinessPolicyExceptionBuilder<?, ?> toBuilder() {
        return new BusinessPolicyExceptionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getBusinessPolicyExceptionFilterDSL() {
        return this.businessPolicyExceptionFilterDSL;
    }

    @Override
    @Generated
    public SortedSet<String> getBusinessPolicyExceptionGroups() {
        return this.businessPolicyExceptionGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getBusinessPolicyExceptionUsers() {
        return this.businessPolicyExceptionUsers;
    }

    @Override
    @Generated
    public IBusinessPolicy getBusinessPolicyForException() {
        return this.businessPolicyForException;
    }

    @Override
    @Generated
    public String getBusinessPolicyQualifiedName() {
        return this.businessPolicyQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessPolicyException)) {
            return false;
        }
        BusinessPolicyException other = (BusinessPolicyException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$businessPolicyExceptionFilterDSL = this.getBusinessPolicyExceptionFilterDSL();
        String other$businessPolicyExceptionFilterDSL = other.getBusinessPolicyExceptionFilterDSL();
        if (this$businessPolicyExceptionFilterDSL == null ? other$businessPolicyExceptionFilterDSL != null : !this$businessPolicyExceptionFilterDSL.equals(other$businessPolicyExceptionFilterDSL)) {
            return false;
        }
        SortedSet<String> this$businessPolicyExceptionGroups = this.getBusinessPolicyExceptionGroups();
        SortedSet<String> other$businessPolicyExceptionGroups = other.getBusinessPolicyExceptionGroups();
        if (this$businessPolicyExceptionGroups == null ? other$businessPolicyExceptionGroups != null : !this$businessPolicyExceptionGroups.equals(other$businessPolicyExceptionGroups)) {
            return false;
        }
        SortedSet<String> this$businessPolicyExceptionUsers = this.getBusinessPolicyExceptionUsers();
        SortedSet<String> other$businessPolicyExceptionUsers = other.getBusinessPolicyExceptionUsers();
        if (this$businessPolicyExceptionUsers == null ? other$businessPolicyExceptionUsers != null : !this$businessPolicyExceptionUsers.equals(other$businessPolicyExceptionUsers)) {
            return false;
        }
        IBusinessPolicy this$businessPolicyForException = this.getBusinessPolicyForException();
        IBusinessPolicy other$businessPolicyForException = other.getBusinessPolicyForException();
        if (this$businessPolicyForException == null ? other$businessPolicyForException != null : !this$businessPolicyForException.equals(other$businessPolicyForException)) {
            return false;
        }
        String this$businessPolicyQualifiedName = this.getBusinessPolicyQualifiedName();
        String other$businessPolicyQualifiedName = other.getBusinessPolicyQualifiedName();
        return !(this$businessPolicyQualifiedName == null ? other$businessPolicyQualifiedName != null : !this$businessPolicyQualifiedName.equals(other$businessPolicyQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessPolicyException;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $businessPolicyExceptionFilterDSL = this.getBusinessPolicyExceptionFilterDSL();
        result = result * 59 + ($businessPolicyExceptionFilterDSL == null ? 43 : $businessPolicyExceptionFilterDSL.hashCode());
        SortedSet<String> $businessPolicyExceptionGroups = this.getBusinessPolicyExceptionGroups();
        result = result * 59 + ($businessPolicyExceptionGroups == null ? 43 : $businessPolicyExceptionGroups.hashCode());
        SortedSet<String> $businessPolicyExceptionUsers = this.getBusinessPolicyExceptionUsers();
        result = result * 59 + ($businessPolicyExceptionUsers == null ? 43 : $businessPolicyExceptionUsers.hashCode());
        IBusinessPolicy $businessPolicyForException = this.getBusinessPolicyForException();
        result = result * 59 + ($businessPolicyForException == null ? 43 : $businessPolicyForException.hashCode());
        String $businessPolicyQualifiedName = this.getBusinessPolicyQualifiedName();
        result = result * 59 + ($businessPolicyQualifiedName == null ? 43 : $businessPolicyQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BusinessPolicyException(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", businessPolicyExceptionFilterDSL=" + this.getBusinessPolicyExceptionFilterDSL() + ", businessPolicyExceptionGroups=" + String.valueOf(this.getBusinessPolicyExceptionGroups()) + ", businessPolicyExceptionUsers=" + String.valueOf(this.getBusinessPolicyExceptionUsers()) + ", businessPolicyForException=" + String.valueOf(this.getBusinessPolicyForException()) + ", businessPolicyQualifiedName=" + this.getBusinessPolicyQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class BusinessPolicyExceptionBuilder<C extends BusinessPolicyException, B extends BusinessPolicyExceptionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String businessPolicyExceptionFilterDSL;
        @Generated
        private ArrayList<String> businessPolicyExceptionGroups;
        @Generated
        private ArrayList<String> businessPolicyExceptionUsers;
        @Generated
        private IBusinessPolicy businessPolicyForException;
        @Generated
        private String businessPolicyQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BusinessPolicyExceptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BusinessPolicyException instance, BusinessPolicyExceptionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.businessPolicyExceptionFilterDSL(instance.businessPolicyExceptionFilterDSL);
            b.businessPolicyExceptionGroups(instance.businessPolicyExceptionGroups == null ? Collections.emptySortedSet() : instance.businessPolicyExceptionGroups);
            b.businessPolicyExceptionUsers(instance.businessPolicyExceptionUsers == null ? Collections.emptySortedSet() : instance.businessPolicyExceptionUsers);
            b.businessPolicyForException(instance.businessPolicyForException);
            b.businessPolicyQualifiedName(instance.businessPolicyQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyExceptionFilterDSL(String businessPolicyExceptionFilterDSL) {
            this.businessPolicyExceptionFilterDSL = businessPolicyExceptionFilterDSL;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyExceptionGroup(String businessPolicyExceptionGroup) {
            if (this.businessPolicyExceptionGroups == null) {
                this.businessPolicyExceptionGroups = new ArrayList();
            }
            this.businessPolicyExceptionGroups.add(businessPolicyExceptionGroup);
            return (B)this.self();
        }

        @Generated
        public B businessPolicyExceptionGroups(Collection<? extends String> businessPolicyExceptionGroups) {
            if (businessPolicyExceptionGroups == null) {
                throw new NullPointerException("businessPolicyExceptionGroups cannot be null");
            }
            if (this.businessPolicyExceptionGroups == null) {
                this.businessPolicyExceptionGroups = new ArrayList();
            }
            this.businessPolicyExceptionGroups.addAll(businessPolicyExceptionGroups);
            return (B)this.self();
        }

        @Generated
        public B clearBusinessPolicyExceptionGroups() {
            if (this.businessPolicyExceptionGroups != null) {
                this.businessPolicyExceptionGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B businessPolicyExceptionUser(String businessPolicyExceptionUser) {
            if (this.businessPolicyExceptionUsers == null) {
                this.businessPolicyExceptionUsers = new ArrayList();
            }
            this.businessPolicyExceptionUsers.add(businessPolicyExceptionUser);
            return (B)this.self();
        }

        @Generated
        public B businessPolicyExceptionUsers(Collection<? extends String> businessPolicyExceptionUsers) {
            if (businessPolicyExceptionUsers == null) {
                throw new NullPointerException("businessPolicyExceptionUsers cannot be null");
            }
            if (this.businessPolicyExceptionUsers == null) {
                this.businessPolicyExceptionUsers = new ArrayList();
            }
            this.businessPolicyExceptionUsers.addAll(businessPolicyExceptionUsers);
            return (B)this.self();
        }

        @Generated
        public B clearBusinessPolicyExceptionUsers() {
            if (this.businessPolicyExceptionUsers != null) {
                this.businessPolicyExceptionUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B businessPolicyForException(IBusinessPolicy businessPolicyForException) {
            this.businessPolicyForException = businessPolicyForException;
            return (B)this.self();
        }

        @Generated
        public B businessPolicyQualifiedName(String businessPolicyQualifiedName) {
            this.businessPolicyQualifiedName = businessPolicyQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BusinessPolicyException.BusinessPolicyExceptionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", businessPolicyExceptionFilterDSL=" + this.businessPolicyExceptionFilterDSL + ", businessPolicyExceptionGroups=" + String.valueOf(this.businessPolicyExceptionGroups) + ", businessPolicyExceptionUsers=" + String.valueOf(this.businessPolicyExceptionUsers) + ", businessPolicyForException=" + String.valueOf(this.businessPolicyForException) + ", businessPolicyQualifiedName=" + this.businessPolicyQualifiedName + ")";
        }
    }

    @Generated
    private static final class BusinessPolicyExceptionBuilderImpl
    extends BusinessPolicyExceptionBuilder<BusinessPolicyException, BusinessPolicyExceptionBuilderImpl> {
        @Generated
        private BusinessPolicyExceptionBuilderImpl() {
        }

        @Override
        @Generated
        protected BusinessPolicyExceptionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BusinessPolicyException build() {
            return new BusinessPolicyException(this);
        }
    }
}

