/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICalculationView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSeed;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISchema;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculationView
extends Asset
implements ICalculationView,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculationView.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CalculationView";
    String typeName;
    @Attribute
    @Date
    Long calculationViewActivatedAt;
    @Attribute
    String calculationViewActivatedBy;
    @Attribute
    String calculationViewName;
    @Attribute
    String calculationViewPackageId;
    @Attribute
    String calculationViewQualifiedName;
    @Attribute
    Long calculationViewVersionId;
    @Attribute
    Long columnCount;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSeed> dbtSeedAssets;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isProfiled;
    @Attribute
    @Date
    Long lastProfiledAt;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Long queryCount;
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    @JsonProperty(value="atlanSchema")
    ISchema schema;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    @Override
    public CalculationView trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CalculationView.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CalculationView.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CalculationView.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CalculationView.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CalculationView refByGuid(String guid) {
        return CalculationView.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CalculationView refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CalculationViewBuilder)((CalculationViewBuilder)CalculationView._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CalculationView refByQualifiedName(String qualifiedName) {
        return CalculationView.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CalculationView refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CalculationViewBuilder)((CalculationViewBuilder)CalculationView._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CalculationView get(AtlanClient client, String id) throws AtlanException {
        return CalculationView.get(client, id, false);
    }

    @JsonIgnore
    public static CalculationView get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CalculationView) {
                return (CalculationView)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CalculationView) {
            return (CalculationView)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CalculationView get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CalculationView.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CalculationView get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CalculationView.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CalculationView) {
                return (CalculationView)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CalculationView.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CalculationView) {
            return (CalculationView)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CalculationViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CalculationViewBuilder)((CalculationViewBuilder)((CalculationViewBuilder)CalculationView._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CalculationViewBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CalculationView.validateRequired(TYPE_NAME, map);
        return CalculationView.updater(this.getQualifiedName(), this.getName());
    }

    public static CalculationView removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CalculationView)Asset.removeDescription(client, CalculationView.updater(qualifiedName, name));
    }

    public static CalculationView removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CalculationView)Asset.removeUserDescription(client, CalculationView.updater(qualifiedName, name));
    }

    public static CalculationView removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CalculationView)Asset.removeOwners(client, CalculationView.updater(qualifiedName, name));
    }

    public static CalculationView updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CalculationView)Asset.updateCertificate(client, CalculationView._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CalculationView removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CalculationView)Asset.removeCertificate(client, CalculationView.updater(qualifiedName, name));
    }

    public static CalculationView updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CalculationView)Asset.updateAnnouncement(client, CalculationView._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CalculationView removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CalculationView)Asset.removeAnnouncement(client, CalculationView.updater(qualifiedName, name));
    }

    public static CalculationView replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CalculationView)Asset.replaceTerms(client, CalculationView.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CalculationView appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CalculationView)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CalculationView removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CalculationView)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CalculationView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CalculationView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CalculationView appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CalculationView)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CalculationView(CalculationViewBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        this.typeName = b.typeName$set ? b.typeName$value : CalculationView.$default$typeName();
        this.calculationViewActivatedAt = b.calculationViewActivatedAt;
        this.calculationViewActivatedBy = b.calculationViewActivatedBy;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewPackageId = b.calculationViewPackageId;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.calculationViewVersionId = b.calculationViewVersionId;
        this.columnCount = b.columnCount;
        SortedSet<IColumn> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSeed> dbtSeedAssets = new TreeSet<IDbtSeed>();
        if (b.dbtSeedAssets != null) {
            dbtSeedAssets.addAll(b.dbtSeedAssets);
        }
        dbtSeedAssets = Collections.unmodifiableSortedSet(dbtSeedAssets);
        this.dbtSeedAssets = dbtSeedAssets;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isProfiled = b.isProfiled;
        this.lastProfiledAt = b.lastProfiledAt;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.schema = b.schema;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @Generated
    public static CalculationViewBuilder<?, ?> _internal() {
        return new CalculationViewBuilderImpl();
    }

    @Generated
    public CalculationViewBuilder<?, ?> toBuilder() {
        return new CalculationViewBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Long getCalculationViewActivatedAt() {
        return this.calculationViewActivatedAt;
    }

    @Override
    @Generated
    public String getCalculationViewActivatedBy() {
        return this.calculationViewActivatedBy;
    }

    @Override
    @Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    @Override
    @Generated
    public String getCalculationViewPackageId() {
        return this.calculationViewPackageId;
    }

    @Override
    @Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    @Override
    @Generated
    public Long getCalculationViewVersionId() {
        return this.calculationViewVersionId;
    }

    @Override
    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSeed> getDbtSeedAssets() {
        return this.dbtSeedAssets;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public ISchema getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculationView)) {
            return false;
        }
        CalculationView other = (CalculationView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$calculationViewActivatedAt = this.getCalculationViewActivatedAt();
        Long other$calculationViewActivatedAt = other.getCalculationViewActivatedAt();
        if (this$calculationViewActivatedAt == null ? other$calculationViewActivatedAt != null : !((Object)this$calculationViewActivatedAt).equals(other$calculationViewActivatedAt)) {
            return false;
        }
        Long this$calculationViewVersionId = this.getCalculationViewVersionId();
        Long other$calculationViewVersionId = other.getCalculationViewVersionId();
        if (this$calculationViewVersionId == null ? other$calculationViewVersionId != null : !((Object)this$calculationViewVersionId).equals(other$calculationViewVersionId)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$calculationViewActivatedBy = this.getCalculationViewActivatedBy();
        String other$calculationViewActivatedBy = other.getCalculationViewActivatedBy();
        if (this$calculationViewActivatedBy == null ? other$calculationViewActivatedBy != null : !this$calculationViewActivatedBy.equals(other$calculationViewActivatedBy)) {
            return false;
        }
        String this$calculationViewName = this.getCalculationViewName();
        String other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) {
            return false;
        }
        String this$calculationViewPackageId = this.getCalculationViewPackageId();
        String other$calculationViewPackageId = other.getCalculationViewPackageId();
        if (this$calculationViewPackageId == null ? other$calculationViewPackageId != null : !this$calculationViewPackageId.equals(other$calculationViewPackageId)) {
            return false;
        }
        String this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        String other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSeed> this$dbtSeedAssets = this.getDbtSeedAssets();
        SortedSet<IDbtSeed> other$dbtSeedAssets = other.getDbtSeedAssets();
        if (this$dbtSeedAssets == null ? other$dbtSeedAssets != null : !this$dbtSeedAssets.equals(other$dbtSeedAssets)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        ISchema this$schema = this.getSchema();
        ISchema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculationView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $calculationViewActivatedAt = this.getCalculationViewActivatedAt();
        result = result * 59 + ($calculationViewActivatedAt == null ? 43 : ((Object)$calculationViewActivatedAt).hashCode());
        Long $calculationViewVersionId = this.getCalculationViewVersionId();
        result = result * 59 + ($calculationViewVersionId == null ? 43 : ((Object)$calculationViewVersionId).hashCode());
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $calculationViewActivatedBy = this.getCalculationViewActivatedBy();
        result = result * 59 + ($calculationViewActivatedBy == null ? 43 : $calculationViewActivatedBy.hashCode());
        String $calculationViewName = this.getCalculationViewName();
        result = result * 59 + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        String $calculationViewPackageId = this.getCalculationViewPackageId();
        result = result * 59 + ($calculationViewPackageId == null ? 43 : $calculationViewPackageId.hashCode());
        String $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * 59 + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSeed> $dbtSeedAssets = this.getDbtSeedAssets();
        result = result * 59 + ($dbtSeedAssets == null ? 43 : $dbtSeedAssets.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        ISchema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CalculationView(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationViewActivatedAt=" + this.getCalculationViewActivatedAt() + ", calculationViewActivatedBy=" + this.getCalculationViewActivatedBy() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewPackageId=" + this.getCalculationViewPackageId() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", calculationViewVersionId=" + this.getCalculationViewVersionId() + ", columnCount=" + this.getColumnCount() + ", columns=" + String.valueOf(this.getColumns()) + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + String.valueOf(this.getDbtModels()) + ", dbtSeedAssets=" + String.valueOf(this.getDbtSeedAssets()) + ", dbtSources=" + String.valueOf(this.getDbtSources()) + ", dbtTests=" + String.valueOf(this.getDbtTests()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isProfiled=" + this.getIsProfiled() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + String.valueOf(this.getQueryUserMap()) + ", schema=" + String.valueOf(this.getSchema()) + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sqlDBTSources=" + String.valueOf(this.getSqlDBTSources()) + ", sqlDbtModels=" + String.valueOf(this.getSqlDbtModels()) + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CalculationViewBuilder<C extends CalculationView, B extends CalculationViewBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long calculationViewActivatedAt;
        @Generated
        private String calculationViewActivatedBy;
        @Generated
        private String calculationViewName;
        @Generated
        private String calculationViewPackageId;
        @Generated
        private String calculationViewQualifiedName;
        @Generated
        private Long calculationViewVersionId;
        @Generated
        private Long columnCount;
        @Generated
        private ArrayList<IColumn> columns;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSeed> dbtSeedAssets;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private ISchema schema;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CalculationViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CalculationView instance, CalculationViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationViewActivatedAt(instance.calculationViewActivatedAt);
            b.calculationViewActivatedBy(instance.calculationViewActivatedBy);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewPackageId(instance.calculationViewPackageId);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.calculationViewVersionId(instance.calculationViewVersionId);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSeedAssets(instance.dbtSeedAssets == null ? Collections.emptySortedSet() : instance.dbtSeedAssets);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isProfiled(instance.isProfiled);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.schema(instance.schema);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B calculationViewActivatedAt(Long calculationViewActivatedAt) {
            this.calculationViewActivatedAt = calculationViewActivatedAt;
            return (B)this.self();
        }

        @Generated
        public B calculationViewActivatedBy(String calculationViewActivatedBy) {
            this.calculationViewActivatedBy = calculationViewActivatedBy;
            return (B)this.self();
        }

        @Generated
        public B calculationViewName(String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewPackageId(String calculationViewPackageId) {
            this.calculationViewPackageId = calculationViewPackageId;
            return (B)this.self();
        }

        @Generated
        public B calculationViewQualifiedName(String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewVersionId(Long calculationViewVersionId) {
            this.calculationViewVersionId = calculationViewVersionId;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAsset(IDbtSeed dbtSeedAsset) {
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.add(dbtSeedAsset);
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAssets(Collection<? extends IDbtSeed> dbtSeedAssets) {
            if (dbtSeedAssets == null) {
                throw new NullPointerException("dbtSeedAssets cannot be null");
            }
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.addAll(dbtSeedAssets);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSeedAssets() {
            if (this.dbtSeedAssets != null) {
                this.dbtSeedAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(ISchema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CalculationView.CalculationViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationViewActivatedAt=" + this.calculationViewActivatedAt + ", calculationViewActivatedBy=" + this.calculationViewActivatedBy + ", calculationViewName=" + this.calculationViewName + ", calculationViewPackageId=" + this.calculationViewPackageId + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", calculationViewVersionId=" + this.calculationViewVersionId + ", columnCount=" + this.columnCount + ", columns=" + String.valueOf(this.columns) + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + String.valueOf(this.dbtModels) + ", dbtSeedAssets=" + String.valueOf(this.dbtSeedAssets) + ", dbtSources=" + String.valueOf(this.dbtSources) + ", dbtTests=" + String.valueOf(this.dbtTests) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isProfiled=" + this.isProfiled + ", lastProfiledAt=" + this.lastProfiledAt + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + String.valueOf(this.queryUserMap$key) + ", queryUserMap$value=" + String.valueOf(this.queryUserMap$value) + ", schema=" + String.valueOf(this.schema) + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sqlDBTSources=" + String.valueOf(this.sqlDBTSources) + ", sqlDbtModels=" + String.valueOf(this.sqlDbtModels) + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }

    @Generated
    private static final class CalculationViewBuilderImpl
    extends CalculationViewBuilder<CalculationView, CalculationViewBuilderImpl> {
        @Generated
        private CalculationViewBuilderImpl() {
        }

        @Override
        @Generated
        protected CalculationViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CalculationView build() {
            return new CalculationView(this);
        }
    }
}

