/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICustom;
import com.atlan.model.assets.ICustomEntity;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEntity
extends Asset
implements ICustomEntity,
ICustom,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomEntity.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CustomEntity";
    String typeName;
    @Attribute
    SortedSet<ICustomEntity> customChildEntities;
    @Attribute
    String customChildrenSubtype;
    @Attribute
    ICustomEntity customParentEntity;
    @Attribute
    SortedSet<ICustomEntity> customRelatedFromEntities;
    @Attribute
    SortedSet<ICustomEntity> customRelatedToEntities;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CustomEntity trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CustomEntity.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CustomEntity.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CustomEntity.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CustomEntity.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CustomEntity refByGuid(String guid) {
        return CustomEntity.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CustomEntity refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CustomEntityBuilder)((CustomEntityBuilder)CustomEntity._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CustomEntity refByQualifiedName(String qualifiedName) {
        return CustomEntity.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CustomEntity refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CustomEntityBuilder)((CustomEntityBuilder)CustomEntity._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CustomEntity get(AtlanClient client, String id) throws AtlanException {
        return CustomEntity.get(client, id, false);
    }

    @JsonIgnore
    public static CustomEntity get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CustomEntity) {
                return (CustomEntity)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof CustomEntity) {
            return (CustomEntity)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static CustomEntity get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return CustomEntity.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static CustomEntity get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CustomEntity.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof CustomEntity) {
                return (CustomEntity)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)CustomEntity.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof CustomEntity) {
            return (CustomEntity)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CustomEntityBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (CustomEntityBuilder)((CustomEntityBuilder)((CustomEntityBuilder)((CustomEntityBuilder)CustomEntity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName);
    }

    public static CustomEntityBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CustomEntityBuilder)((CustomEntityBuilder)((CustomEntityBuilder)CustomEntity._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public CustomEntityBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        CustomEntity.validateRequired(TYPE_NAME, map);
        return CustomEntity.updater(this.getQualifiedName(), this.getName());
    }

    public static CustomEntity removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CustomEntity)Asset.removeDescription(client, CustomEntity.updater(qualifiedName, name));
    }

    public static CustomEntity removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CustomEntity)Asset.removeUserDescription(client, CustomEntity.updater(qualifiedName, name));
    }

    public static CustomEntity removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CustomEntity)Asset.removeOwners(client, CustomEntity.updater(qualifiedName, name));
    }

    public static CustomEntity updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CustomEntity)Asset.updateCertificate(client, CustomEntity._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CustomEntity removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CustomEntity)Asset.removeCertificate(client, CustomEntity.updater(qualifiedName, name));
    }

    public static CustomEntity updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CustomEntity)Asset.updateAnnouncement(client, CustomEntity._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CustomEntity removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CustomEntity)Asset.removeAnnouncement(client, CustomEntity.updater(qualifiedName, name));
    }

    public static CustomEntity replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CustomEntity)Asset.replaceTerms(client, CustomEntity.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static CustomEntity appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CustomEntity)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CustomEntity removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CustomEntity)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static CustomEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CustomEntity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static CustomEntity appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CustomEntity)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CustomEntity(CustomEntityBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CustomEntity.$default$typeName();
        SortedSet<ICustomEntity> customChildEntities = new TreeSet<ICustomEntity>();
        if (b.customChildEntities != null) {
            customChildEntities.addAll(b.customChildEntities);
        }
        customChildEntities = Collections.unmodifiableSortedSet(customChildEntities);
        this.customChildEntities = customChildEntities;
        this.customChildrenSubtype = b.customChildrenSubtype;
        this.customParentEntity = b.customParentEntity;
        SortedSet<ICustomEntity> customRelatedFromEntities = new TreeSet<ICustomEntity>();
        if (b.customRelatedFromEntities != null) {
            customRelatedFromEntities.addAll(b.customRelatedFromEntities);
        }
        customRelatedFromEntities = Collections.unmodifiableSortedSet(customRelatedFromEntities);
        this.customRelatedFromEntities = customRelatedFromEntities;
        SortedSet<ICustomEntity> customRelatedToEntities = new TreeSet<ICustomEntity>();
        if (b.customRelatedToEntities != null) {
            customRelatedToEntities.addAll(b.customRelatedToEntities);
        }
        customRelatedToEntities = Collections.unmodifiableSortedSet(customRelatedToEntities);
        this.customRelatedToEntities = customRelatedToEntities;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CustomEntityBuilder<?, ?> _internal() {
        return new CustomEntityBuilderImpl();
    }

    @Generated
    public CustomEntityBuilder<?, ?> toBuilder() {
        return new CustomEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ICustomEntity> getCustomChildEntities() {
        return this.customChildEntities;
    }

    @Override
    @Generated
    public String getCustomChildrenSubtype() {
        return this.customChildrenSubtype;
    }

    @Override
    @Generated
    public ICustomEntity getCustomParentEntity() {
        return this.customParentEntity;
    }

    @Override
    @Generated
    public SortedSet<ICustomEntity> getCustomRelatedFromEntities() {
        return this.customRelatedFromEntities;
    }

    @Override
    @Generated
    public SortedSet<ICustomEntity> getCustomRelatedToEntities() {
        return this.customRelatedToEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomEntity)) {
            return false;
        }
        CustomEntity other = (CustomEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ICustomEntity> this$customChildEntities = this.getCustomChildEntities();
        SortedSet<ICustomEntity> other$customChildEntities = other.getCustomChildEntities();
        if (this$customChildEntities == null ? other$customChildEntities != null : !this$customChildEntities.equals(other$customChildEntities)) {
            return false;
        }
        String this$customChildrenSubtype = this.getCustomChildrenSubtype();
        String other$customChildrenSubtype = other.getCustomChildrenSubtype();
        if (this$customChildrenSubtype == null ? other$customChildrenSubtype != null : !this$customChildrenSubtype.equals(other$customChildrenSubtype)) {
            return false;
        }
        ICustomEntity this$customParentEntity = this.getCustomParentEntity();
        ICustomEntity other$customParentEntity = other.getCustomParentEntity();
        if (this$customParentEntity == null ? other$customParentEntity != null : !this$customParentEntity.equals(other$customParentEntity)) {
            return false;
        }
        SortedSet<ICustomEntity> this$customRelatedFromEntities = this.getCustomRelatedFromEntities();
        SortedSet<ICustomEntity> other$customRelatedFromEntities = other.getCustomRelatedFromEntities();
        if (this$customRelatedFromEntities == null ? other$customRelatedFromEntities != null : !this$customRelatedFromEntities.equals(other$customRelatedFromEntities)) {
            return false;
        }
        SortedSet<ICustomEntity> this$customRelatedToEntities = this.getCustomRelatedToEntities();
        SortedSet<ICustomEntity> other$customRelatedToEntities = other.getCustomRelatedToEntities();
        if (this$customRelatedToEntities == null ? other$customRelatedToEntities != null : !this$customRelatedToEntities.equals(other$customRelatedToEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomEntity;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ICustomEntity> $customChildEntities = this.getCustomChildEntities();
        result = result * 59 + ($customChildEntities == null ? 43 : $customChildEntities.hashCode());
        String $customChildrenSubtype = this.getCustomChildrenSubtype();
        result = result * 59 + ($customChildrenSubtype == null ? 43 : $customChildrenSubtype.hashCode());
        ICustomEntity $customParentEntity = this.getCustomParentEntity();
        result = result * 59 + ($customParentEntity == null ? 43 : $customParentEntity.hashCode());
        SortedSet<ICustomEntity> $customRelatedFromEntities = this.getCustomRelatedFromEntities();
        result = result * 59 + ($customRelatedFromEntities == null ? 43 : $customRelatedFromEntities.hashCode());
        SortedSet<ICustomEntity> $customRelatedToEntities = this.getCustomRelatedToEntities();
        result = result * 59 + ($customRelatedToEntities == null ? 43 : $customRelatedToEntities.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CustomEntity(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", customChildEntities=" + String.valueOf(this.getCustomChildEntities()) + ", customChildrenSubtype=" + this.getCustomChildrenSubtype() + ", customParentEntity=" + String.valueOf(this.getCustomParentEntity()) + ", customRelatedFromEntities=" + String.valueOf(this.getCustomRelatedFromEntities()) + ", customRelatedToEntities=" + String.valueOf(this.getCustomRelatedToEntities()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class CustomEntityBuilder<C extends CustomEntity, B extends CustomEntityBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ICustomEntity> customChildEntities;
        @Generated
        private String customChildrenSubtype;
        @Generated
        private ICustomEntity customParentEntity;
        @Generated
        private ArrayList<ICustomEntity> customRelatedFromEntities;
        @Generated
        private ArrayList<ICustomEntity> customRelatedToEntities;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CustomEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CustomEntity instance, CustomEntityBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.customChildEntities(instance.customChildEntities == null ? Collections.emptySortedSet() : instance.customChildEntities);
            b.customChildrenSubtype(instance.customChildrenSubtype);
            b.customParentEntity(instance.customParentEntity);
            b.customRelatedFromEntities(instance.customRelatedFromEntities == null ? Collections.emptySortedSet() : instance.customRelatedFromEntities);
            b.customRelatedToEntities(instance.customRelatedToEntities == null ? Collections.emptySortedSet() : instance.customRelatedToEntities);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B customChildEntity(ICustomEntity customChildEntity) {
            if (this.customChildEntities == null) {
                this.customChildEntities = new ArrayList();
            }
            this.customChildEntities.add(customChildEntity);
            return (B)this.self();
        }

        @Generated
        public B customChildEntities(Collection<? extends ICustomEntity> customChildEntities) {
            if (customChildEntities == null) {
                throw new NullPointerException("customChildEntities cannot be null");
            }
            if (this.customChildEntities == null) {
                this.customChildEntities = new ArrayList();
            }
            this.customChildEntities.addAll(customChildEntities);
            return (B)this.self();
        }

        @Generated
        public B clearCustomChildEntities() {
            if (this.customChildEntities != null) {
                this.customChildEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customChildrenSubtype(String customChildrenSubtype) {
            this.customChildrenSubtype = customChildrenSubtype;
            return (B)this.self();
        }

        @Generated
        public B customParentEntity(ICustomEntity customParentEntity) {
            this.customParentEntity = customParentEntity;
            return (B)this.self();
        }

        @Generated
        public B customRelatedFromEntity(ICustomEntity customRelatedFromEntity) {
            if (this.customRelatedFromEntities == null) {
                this.customRelatedFromEntities = new ArrayList();
            }
            this.customRelatedFromEntities.add(customRelatedFromEntity);
            return (B)this.self();
        }

        @Generated
        public B customRelatedFromEntities(Collection<? extends ICustomEntity> customRelatedFromEntities) {
            if (customRelatedFromEntities == null) {
                throw new NullPointerException("customRelatedFromEntities cannot be null");
            }
            if (this.customRelatedFromEntities == null) {
                this.customRelatedFromEntities = new ArrayList();
            }
            this.customRelatedFromEntities.addAll(customRelatedFromEntities);
            return (B)this.self();
        }

        @Generated
        public B clearCustomRelatedFromEntities() {
            if (this.customRelatedFromEntities != null) {
                this.customRelatedFromEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B customRelatedToEntity(ICustomEntity customRelatedToEntity) {
            if (this.customRelatedToEntities == null) {
                this.customRelatedToEntities = new ArrayList();
            }
            this.customRelatedToEntities.add(customRelatedToEntity);
            return (B)this.self();
        }

        @Generated
        public B customRelatedToEntities(Collection<? extends ICustomEntity> customRelatedToEntities) {
            if (customRelatedToEntities == null) {
                throw new NullPointerException("customRelatedToEntities cannot be null");
            }
            if (this.customRelatedToEntities == null) {
                this.customRelatedToEntities = new ArrayList();
            }
            this.customRelatedToEntities.addAll(customRelatedToEntities);
            return (B)this.self();
        }

        @Generated
        public B clearCustomRelatedToEntities() {
            if (this.customRelatedToEntities != null) {
                this.customRelatedToEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CustomEntity.CustomEntityBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", customChildEntities=" + String.valueOf(this.customChildEntities) + ", customChildrenSubtype=" + this.customChildrenSubtype + ", customParentEntity=" + String.valueOf(this.customParentEntity) + ", customRelatedFromEntities=" + String.valueOf(this.customRelatedFromEntities) + ", customRelatedToEntities=" + String.valueOf(this.customRelatedToEntities) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class CustomEntityBuilderImpl
    extends CustomEntityBuilder<CustomEntity, CustomEntityBuilderImpl> {
        @Generated
        private CustomEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected CustomEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CustomEntity build() {
            return new CustomEntity(this);
        }
    }
}

