/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.LogicException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.DataDomain;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDataDomain;
import com.atlan.model.assets.IDataMesh;
import com.atlan.model.assets.IDataProduct;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DataProductCriticality;
import com.atlan.model.enums.DataProductLineageStatus;
import com.atlan.model.enums.DataProductSensitivity;
import com.atlan.model.enums.DataProductStatus;
import com.atlan.model.enums.DataProductVisibility;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.mesh.DataProductAssetsDSL;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProduct
extends Asset
implements IDataProduct,
IDataMesh,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataProduct.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataProduct";
    String typeName;
    @Attribute
    DataProductCriticality daapCriticality;
    @Attribute
    SortedSet<String> daapInputPortGuids;
    @Attribute
    DataProductLineageStatus daapLineageStatus;
    @Attribute
    SortedSet<String> daapOutputPortGuids;
    @Attribute
    DataProductSensitivity daapSensitivity;
    @Attribute
    DataProductStatus daapStatus;
    @Attribute
    DataProductVisibility daapVisibility;
    @Attribute
    SortedSet<String> daapVisibilityGroups;
    @Attribute
    SortedSet<String> daapVisibilityUsers;
    @Attribute
    IDataDomain dataDomain;
    @Attribute
    String dataProductAssetsDSL;
    @Attribute
    String dataProductAssetsPlaybookFilter;
    @Attribute
    DataProductCriticality dataProductCriticality;
    @Attribute
    @Date
    Long dataProductScoreUpdatedAt;
    @Attribute
    Double dataProductScoreValue;
    @Attribute
    DataProductSensitivity dataProductSensitivity;
    @Attribute
    DataProductStatus dataProductStatus;
    @Attribute
    DataProductVisibility dataProductVisibility;
    @Attribute
    SortedSet<IAsset> inputPorts;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<IAsset> outputPorts;
    @Attribute
    String parentDomainQualifiedName;
    @Attribute
    String superDomainQualifiedName;

    @Override
    public DataProduct trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataProduct.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataProduct.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataProduct.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataProduct.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataProduct refByGuid(String guid) {
        return DataProduct.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataProduct refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataProductBuilder)((DataProductBuilder)DataProduct._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataProduct refByQualifiedName(String qualifiedName) {
        return DataProduct.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataProduct refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataProductBuilder)((DataProductBuilder)DataProduct._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id) throws AtlanException {
        return DataProduct.get(client, id, false);
    }

    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataProduct) {
                return (DataProduct)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DataProduct) {
            return (DataProduct)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DataProduct.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DataProduct get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataProduct.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DataProduct) {
                return (DataProduct)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataProduct.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DataProduct) {
            return (DataProduct)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataProductBuilder<?, ?> creator(AtlanClient client, String name, String domainQualifiedName, FluentSearch assetSelection) throws InvalidRequestException {
        return DataProduct.creator(name, domainQualifiedName, "").assetSelection(client, assetSelection);
    }

    public static DataProductBuilder<?, ?> creator(AtlanClient client, String name, String domainQualifiedName, IndexSearchDSL assetSelection) {
        return ((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(domainQualifiedName + "/product/" + name)).name(name)).dataProductStatus(DataProductStatus.ACTIVE)).parentDomainQualifiedName(domainQualifiedName)).superDomainQualifiedName(StringUtils.getSuperDomainQualifiedName(domainQualifiedName))).dataDomain(DataDomain.refByQualifiedName(domainQualifiedName))).assetSelection(client, assetSelection)).dataProductAssetsPlaybookFilter("{\"condition\":\"AND\",\"isGroupLocked\":false,\"rules\":[]}")).daapStatus(DataProductStatus.ACTIVE);
    }

    public static DataProductBuilder<?, ?> creator(String name, String domainQualifiedName, String assetSelection) {
        return ((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)((DataProductBuilder)DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(domainQualifiedName + "/product/" + name)).name(name)).dataProductStatus(DataProductStatus.ACTIVE)).parentDomainQualifiedName(domainQualifiedName)).superDomainQualifiedName(StringUtils.getSuperDomainQualifiedName(domainQualifiedName))).dataDomain(DataDomain.refByQualifiedName(domainQualifiedName))).dataProductAssetsDSL(assetSelection)).dataProductAssetsPlaybookFilter("{\"condition\":\"AND\",\"isGroupLocked\":false,\"rules\":[]}")).daapStatus(DataProductStatus.ACTIVE);
    }

    public static DataProductBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataProductBuilder)((DataProductBuilder)((DataProductBuilder)DataProduct._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DataProductBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataProduct.validateRequired(TYPE_NAME, map);
        return DataProduct.updater(this.getQualifiedName(), this.getName());
    }

    @JsonIgnore
    public IndexSearchResponse getAssets(AtlanClient client) throws AtlanException {
        try {
            DataProductAssetsDSL dsl = client.readValue(this.getDataProductAssetsDSL(), DataProductAssetsDSL.class);
            return client.assets.search(dsl.getQuery());
        }
        catch (IOException e) {
            throw new LogicException(ErrorCode.DATA_PRODUCT_QUERY_ERROR, (Throwable)e);
        }
    }

    public static List<DataProduct> findByName(AtlanClient client, String name) throws AtlanException {
        return DataProduct.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<DataProduct> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<DataProduct> results = new ArrayList<DataProduct>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataProduct.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof DataProduct).forEach(d -> results.add((DataProduct)d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static List<DataProduct> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<DataProduct> results = new ArrayList<DataProduct>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataProduct.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof DataProduct).forEach(d -> results.add((DataProduct)d));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        return results;
    }

    public static DataProduct removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct)Asset.removeDescription(client, DataProduct.updater(qualifiedName, name));
    }

    public static DataProduct removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct)Asset.removeUserDescription(client, DataProduct.updater(qualifiedName, name));
    }

    public static DataProduct removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct)Asset.removeOwners(client, DataProduct.updater(qualifiedName, name));
    }

    public static DataProduct updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataProduct)Asset.updateCertificate(client, DataProduct._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataProduct removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct)Asset.removeCertificate(client, DataProduct.updater(qualifiedName, name));
    }

    public static DataProduct updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataProduct)Asset.updateAnnouncement(client, DataProduct._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataProduct removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataProduct)Asset.removeAnnouncement(client, DataProduct.updater(qualifiedName, name));
    }

    public static DataProduct replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct)Asset.replaceTerms(client, DataProduct.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static DataProduct appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataProduct removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataProduct)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataProduct appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataProduct)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static DataProduct appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataProduct)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataProduct(DataProductBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataProduct.$default$typeName();
        this.daapCriticality = b.daapCriticality;
        SortedSet<String> daapInputPortGuids = new TreeSet<String>();
        if (b.daapInputPortGuids != null) {
            daapInputPortGuids.addAll(b.daapInputPortGuids);
        }
        daapInputPortGuids = Collections.unmodifiableSortedSet(daapInputPortGuids);
        this.daapInputPortGuids = daapInputPortGuids;
        this.daapLineageStatus = b.daapLineageStatus;
        SortedSet<String> daapOutputPortGuids = new TreeSet<String>();
        if (b.daapOutputPortGuids != null) {
            daapOutputPortGuids.addAll(b.daapOutputPortGuids);
        }
        daapOutputPortGuids = Collections.unmodifiableSortedSet(daapOutputPortGuids);
        this.daapOutputPortGuids = daapOutputPortGuids;
        this.daapSensitivity = b.daapSensitivity;
        this.daapStatus = b.daapStatus;
        this.daapVisibility = b.daapVisibility;
        SortedSet<String> daapVisibilityGroups = new TreeSet<String>();
        if (b.daapVisibilityGroups != null) {
            daapVisibilityGroups.addAll(b.daapVisibilityGroups);
        }
        daapVisibilityGroups = Collections.unmodifiableSortedSet(daapVisibilityGroups);
        this.daapVisibilityGroups = daapVisibilityGroups;
        SortedSet<String> daapVisibilityUsers = new TreeSet<String>();
        if (b.daapVisibilityUsers != null) {
            daapVisibilityUsers.addAll(b.daapVisibilityUsers);
        }
        daapVisibilityUsers = Collections.unmodifiableSortedSet(daapVisibilityUsers);
        this.daapVisibilityUsers = daapVisibilityUsers;
        this.dataDomain = b.dataDomain;
        this.dataProductAssetsDSL = b.dataProductAssetsDSL;
        this.dataProductAssetsPlaybookFilter = b.dataProductAssetsPlaybookFilter;
        this.dataProductCriticality = b.dataProductCriticality;
        this.dataProductScoreUpdatedAt = b.dataProductScoreUpdatedAt;
        this.dataProductScoreValue = b.dataProductScoreValue;
        this.dataProductSensitivity = b.dataProductSensitivity;
        this.dataProductStatus = b.dataProductStatus;
        this.dataProductVisibility = b.dataProductVisibility;
        SortedSet<IAsset> inputPorts = new TreeSet<IAsset>();
        if (b.inputPorts != null) {
            inputPorts.addAll(b.inputPorts);
        }
        inputPorts = Collections.unmodifiableSortedSet(inputPorts);
        this.inputPorts = inputPorts;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<IAsset> outputPorts = new TreeSet<IAsset>();
        if (b.outputPorts != null) {
            outputPorts.addAll(b.outputPorts);
        }
        outputPorts = Collections.unmodifiableSortedSet(outputPorts);
        this.outputPorts = outputPorts;
        this.parentDomainQualifiedName = b.parentDomainQualifiedName;
        this.superDomainQualifiedName = b.superDomainQualifiedName;
    }

    @Generated
    public static DataProductBuilder<?, ?> _internal() {
        return new DataProductBuilderImpl();
    }

    @Generated
    public DataProductBuilder<?, ?> toBuilder() {
        return new DataProductBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public DataProductCriticality getDaapCriticality() {
        return this.daapCriticality;
    }

    @Override
    @Generated
    public SortedSet<String> getDaapInputPortGuids() {
        return this.daapInputPortGuids;
    }

    @Override
    @Generated
    public DataProductLineageStatus getDaapLineageStatus() {
        return this.daapLineageStatus;
    }

    @Override
    @Generated
    public SortedSet<String> getDaapOutputPortGuids() {
        return this.daapOutputPortGuids;
    }

    @Override
    @Generated
    public DataProductSensitivity getDaapSensitivity() {
        return this.daapSensitivity;
    }

    @Override
    @Generated
    public DataProductStatus getDaapStatus() {
        return this.daapStatus;
    }

    @Override
    @Generated
    public DataProductVisibility getDaapVisibility() {
        return this.daapVisibility;
    }

    @Override
    @Generated
    public SortedSet<String> getDaapVisibilityGroups() {
        return this.daapVisibilityGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getDaapVisibilityUsers() {
        return this.daapVisibilityUsers;
    }

    @Override
    @Generated
    public IDataDomain getDataDomain() {
        return this.dataDomain;
    }

    @Override
    @Generated
    public String getDataProductAssetsDSL() {
        return this.dataProductAssetsDSL;
    }

    @Override
    @Generated
    public String getDataProductAssetsPlaybookFilter() {
        return this.dataProductAssetsPlaybookFilter;
    }

    @Override
    @Generated
    public DataProductCriticality getDataProductCriticality() {
        return this.dataProductCriticality;
    }

    @Override
    @Generated
    public Long getDataProductScoreUpdatedAt() {
        return this.dataProductScoreUpdatedAt;
    }

    @Override
    @Generated
    public Double getDataProductScoreValue() {
        return this.dataProductScoreValue;
    }

    @Override
    @Generated
    public DataProductSensitivity getDataProductSensitivity() {
        return this.dataProductSensitivity;
    }

    @Override
    @Generated
    public DataProductStatus getDataProductStatus() {
        return this.dataProductStatus;
    }

    @Override
    @Generated
    public DataProductVisibility getDataProductVisibility() {
        return this.dataProductVisibility;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getInputPorts() {
        return this.inputPorts;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getOutputPorts() {
        return this.outputPorts;
    }

    @Override
    @Generated
    public String getParentDomainQualifiedName() {
        return this.parentDomainQualifiedName;
    }

    @Override
    @Generated
    public String getSuperDomainQualifiedName() {
        return this.superDomainQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataProduct)) {
            return false;
        }
        DataProduct other = (DataProduct)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dataProductScoreUpdatedAt = this.getDataProductScoreUpdatedAt();
        Long other$dataProductScoreUpdatedAt = other.getDataProductScoreUpdatedAt();
        if (this$dataProductScoreUpdatedAt == null ? other$dataProductScoreUpdatedAt != null : !((Object)this$dataProductScoreUpdatedAt).equals(other$dataProductScoreUpdatedAt)) {
            return false;
        }
        Double this$dataProductScoreValue = this.getDataProductScoreValue();
        Double other$dataProductScoreValue = other.getDataProductScoreValue();
        if (this$dataProductScoreValue == null ? other$dataProductScoreValue != null : !((Object)this$dataProductScoreValue).equals(other$dataProductScoreValue)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        DataProductCriticality this$daapCriticality = this.getDaapCriticality();
        DataProductCriticality other$daapCriticality = other.getDaapCriticality();
        if (this$daapCriticality == null ? other$daapCriticality != null : !this$daapCriticality.equals(other$daapCriticality)) {
            return false;
        }
        SortedSet<String> this$daapInputPortGuids = this.getDaapInputPortGuids();
        SortedSet<String> other$daapInputPortGuids = other.getDaapInputPortGuids();
        if (this$daapInputPortGuids == null ? other$daapInputPortGuids != null : !this$daapInputPortGuids.equals(other$daapInputPortGuids)) {
            return false;
        }
        DataProductLineageStatus this$daapLineageStatus = this.getDaapLineageStatus();
        DataProductLineageStatus other$daapLineageStatus = other.getDaapLineageStatus();
        if (this$daapLineageStatus == null ? other$daapLineageStatus != null : !this$daapLineageStatus.equals(other$daapLineageStatus)) {
            return false;
        }
        SortedSet<String> this$daapOutputPortGuids = this.getDaapOutputPortGuids();
        SortedSet<String> other$daapOutputPortGuids = other.getDaapOutputPortGuids();
        if (this$daapOutputPortGuids == null ? other$daapOutputPortGuids != null : !this$daapOutputPortGuids.equals(other$daapOutputPortGuids)) {
            return false;
        }
        DataProductSensitivity this$daapSensitivity = this.getDaapSensitivity();
        DataProductSensitivity other$daapSensitivity = other.getDaapSensitivity();
        if (this$daapSensitivity == null ? other$daapSensitivity != null : !this$daapSensitivity.equals(other$daapSensitivity)) {
            return false;
        }
        DataProductStatus this$daapStatus = this.getDaapStatus();
        DataProductStatus other$daapStatus = other.getDaapStatus();
        if (this$daapStatus == null ? other$daapStatus != null : !this$daapStatus.equals(other$daapStatus)) {
            return false;
        }
        DataProductVisibility this$daapVisibility = this.getDaapVisibility();
        DataProductVisibility other$daapVisibility = other.getDaapVisibility();
        if (this$daapVisibility == null ? other$daapVisibility != null : !this$daapVisibility.equals(other$daapVisibility)) {
            return false;
        }
        SortedSet<String> this$daapVisibilityGroups = this.getDaapVisibilityGroups();
        SortedSet<String> other$daapVisibilityGroups = other.getDaapVisibilityGroups();
        if (this$daapVisibilityGroups == null ? other$daapVisibilityGroups != null : !this$daapVisibilityGroups.equals(other$daapVisibilityGroups)) {
            return false;
        }
        SortedSet<String> this$daapVisibilityUsers = this.getDaapVisibilityUsers();
        SortedSet<String> other$daapVisibilityUsers = other.getDaapVisibilityUsers();
        if (this$daapVisibilityUsers == null ? other$daapVisibilityUsers != null : !this$daapVisibilityUsers.equals(other$daapVisibilityUsers)) {
            return false;
        }
        IDataDomain this$dataDomain = this.getDataDomain();
        IDataDomain other$dataDomain = other.getDataDomain();
        if (this$dataDomain == null ? other$dataDomain != null : !this$dataDomain.equals(other$dataDomain)) {
            return false;
        }
        String this$dataProductAssetsDSL = this.getDataProductAssetsDSL();
        String other$dataProductAssetsDSL = other.getDataProductAssetsDSL();
        if (this$dataProductAssetsDSL == null ? other$dataProductAssetsDSL != null : !this$dataProductAssetsDSL.equals(other$dataProductAssetsDSL)) {
            return false;
        }
        String this$dataProductAssetsPlaybookFilter = this.getDataProductAssetsPlaybookFilter();
        String other$dataProductAssetsPlaybookFilter = other.getDataProductAssetsPlaybookFilter();
        if (this$dataProductAssetsPlaybookFilter == null ? other$dataProductAssetsPlaybookFilter != null : !this$dataProductAssetsPlaybookFilter.equals(other$dataProductAssetsPlaybookFilter)) {
            return false;
        }
        DataProductCriticality this$dataProductCriticality = this.getDataProductCriticality();
        DataProductCriticality other$dataProductCriticality = other.getDataProductCriticality();
        if (this$dataProductCriticality == null ? other$dataProductCriticality != null : !this$dataProductCriticality.equals(other$dataProductCriticality)) {
            return false;
        }
        DataProductSensitivity this$dataProductSensitivity = this.getDataProductSensitivity();
        DataProductSensitivity other$dataProductSensitivity = other.getDataProductSensitivity();
        if (this$dataProductSensitivity == null ? other$dataProductSensitivity != null : !this$dataProductSensitivity.equals(other$dataProductSensitivity)) {
            return false;
        }
        DataProductStatus this$dataProductStatus = this.getDataProductStatus();
        DataProductStatus other$dataProductStatus = other.getDataProductStatus();
        if (this$dataProductStatus == null ? other$dataProductStatus != null : !this$dataProductStatus.equals(other$dataProductStatus)) {
            return false;
        }
        DataProductVisibility this$dataProductVisibility = this.getDataProductVisibility();
        DataProductVisibility other$dataProductVisibility = other.getDataProductVisibility();
        if (this$dataProductVisibility == null ? other$dataProductVisibility != null : !this$dataProductVisibility.equals(other$dataProductVisibility)) {
            return false;
        }
        SortedSet<IAsset> this$inputPorts = this.getInputPorts();
        SortedSet<IAsset> other$inputPorts = other.getInputPorts();
        if (this$inputPorts == null ? other$inputPorts != null : !this$inputPorts.equals(other$inputPorts)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<IAsset> this$outputPorts = this.getOutputPorts();
        SortedSet<IAsset> other$outputPorts = other.getOutputPorts();
        if (this$outputPorts == null ? other$outputPorts != null : !this$outputPorts.equals(other$outputPorts)) {
            return false;
        }
        String this$parentDomainQualifiedName = this.getParentDomainQualifiedName();
        String other$parentDomainQualifiedName = other.getParentDomainQualifiedName();
        if (this$parentDomainQualifiedName == null ? other$parentDomainQualifiedName != null : !this$parentDomainQualifiedName.equals(other$parentDomainQualifiedName)) {
            return false;
        }
        String this$superDomainQualifiedName = this.getSuperDomainQualifiedName();
        String other$superDomainQualifiedName = other.getSuperDomainQualifiedName();
        return !(this$superDomainQualifiedName == null ? other$superDomainQualifiedName != null : !this$superDomainQualifiedName.equals(other$superDomainQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataProduct;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dataProductScoreUpdatedAt = this.getDataProductScoreUpdatedAt();
        result = result * 59 + ($dataProductScoreUpdatedAt == null ? 43 : ((Object)$dataProductScoreUpdatedAt).hashCode());
        Double $dataProductScoreValue = this.getDataProductScoreValue();
        result = result * 59 + ($dataProductScoreValue == null ? 43 : ((Object)$dataProductScoreValue).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        DataProductCriticality $daapCriticality = this.getDaapCriticality();
        result = result * 59 + ($daapCriticality == null ? 43 : $daapCriticality.hashCode());
        SortedSet<String> $daapInputPortGuids = this.getDaapInputPortGuids();
        result = result * 59 + ($daapInputPortGuids == null ? 43 : $daapInputPortGuids.hashCode());
        DataProductLineageStatus $daapLineageStatus = this.getDaapLineageStatus();
        result = result * 59 + ($daapLineageStatus == null ? 43 : $daapLineageStatus.hashCode());
        SortedSet<String> $daapOutputPortGuids = this.getDaapOutputPortGuids();
        result = result * 59 + ($daapOutputPortGuids == null ? 43 : $daapOutputPortGuids.hashCode());
        DataProductSensitivity $daapSensitivity = this.getDaapSensitivity();
        result = result * 59 + ($daapSensitivity == null ? 43 : $daapSensitivity.hashCode());
        DataProductStatus $daapStatus = this.getDaapStatus();
        result = result * 59 + ($daapStatus == null ? 43 : $daapStatus.hashCode());
        DataProductVisibility $daapVisibility = this.getDaapVisibility();
        result = result * 59 + ($daapVisibility == null ? 43 : $daapVisibility.hashCode());
        SortedSet<String> $daapVisibilityGroups = this.getDaapVisibilityGroups();
        result = result * 59 + ($daapVisibilityGroups == null ? 43 : $daapVisibilityGroups.hashCode());
        SortedSet<String> $daapVisibilityUsers = this.getDaapVisibilityUsers();
        result = result * 59 + ($daapVisibilityUsers == null ? 43 : $daapVisibilityUsers.hashCode());
        IDataDomain $dataDomain = this.getDataDomain();
        result = result * 59 + ($dataDomain == null ? 43 : $dataDomain.hashCode());
        String $dataProductAssetsDSL = this.getDataProductAssetsDSL();
        result = result * 59 + ($dataProductAssetsDSL == null ? 43 : $dataProductAssetsDSL.hashCode());
        String $dataProductAssetsPlaybookFilter = this.getDataProductAssetsPlaybookFilter();
        result = result * 59 + ($dataProductAssetsPlaybookFilter == null ? 43 : $dataProductAssetsPlaybookFilter.hashCode());
        DataProductCriticality $dataProductCriticality = this.getDataProductCriticality();
        result = result * 59 + ($dataProductCriticality == null ? 43 : $dataProductCriticality.hashCode());
        DataProductSensitivity $dataProductSensitivity = this.getDataProductSensitivity();
        result = result * 59 + ($dataProductSensitivity == null ? 43 : $dataProductSensitivity.hashCode());
        DataProductStatus $dataProductStatus = this.getDataProductStatus();
        result = result * 59 + ($dataProductStatus == null ? 43 : $dataProductStatus.hashCode());
        DataProductVisibility $dataProductVisibility = this.getDataProductVisibility();
        result = result * 59 + ($dataProductVisibility == null ? 43 : $dataProductVisibility.hashCode());
        SortedSet<IAsset> $inputPorts = this.getInputPorts();
        result = result * 59 + ($inputPorts == null ? 43 : $inputPorts.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<IAsset> $outputPorts = this.getOutputPorts();
        result = result * 59 + ($outputPorts == null ? 43 : $outputPorts.hashCode());
        String $parentDomainQualifiedName = this.getParentDomainQualifiedName();
        result = result * 59 + ($parentDomainQualifiedName == null ? 43 : $parentDomainQualifiedName.hashCode());
        String $superDomainQualifiedName = this.getSuperDomainQualifiedName();
        result = result * 59 + ($superDomainQualifiedName == null ? 43 : $superDomainQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataProduct(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", daapCriticality=" + String.valueOf(this.getDaapCriticality()) + ", daapInputPortGuids=" + String.valueOf(this.getDaapInputPortGuids()) + ", daapLineageStatus=" + String.valueOf(this.getDaapLineageStatus()) + ", daapOutputPortGuids=" + String.valueOf(this.getDaapOutputPortGuids()) + ", daapSensitivity=" + String.valueOf(this.getDaapSensitivity()) + ", daapStatus=" + String.valueOf(this.getDaapStatus()) + ", daapVisibility=" + String.valueOf(this.getDaapVisibility()) + ", daapVisibilityGroups=" + String.valueOf(this.getDaapVisibilityGroups()) + ", daapVisibilityUsers=" + String.valueOf(this.getDaapVisibilityUsers()) + ", dataDomain=" + String.valueOf(this.getDataDomain()) + ", dataProductAssetsDSL=" + this.getDataProductAssetsDSL() + ", dataProductAssetsPlaybookFilter=" + this.getDataProductAssetsPlaybookFilter() + ", dataProductCriticality=" + String.valueOf(this.getDataProductCriticality()) + ", dataProductScoreUpdatedAt=" + this.getDataProductScoreUpdatedAt() + ", dataProductScoreValue=" + this.getDataProductScoreValue() + ", dataProductSensitivity=" + String.valueOf(this.getDataProductSensitivity()) + ", dataProductStatus=" + String.valueOf(this.getDataProductStatus()) + ", dataProductVisibility=" + String.valueOf(this.getDataProductVisibility()) + ", inputPorts=" + String.valueOf(this.getInputPorts()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", outputPorts=" + String.valueOf(this.getOutputPorts()) + ", parentDomainQualifiedName=" + this.getParentDomainQualifiedName() + ", superDomainQualifiedName=" + this.getSuperDomainQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class DataProductBuilder<C extends DataProduct, B extends DataProductBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private DataProductCriticality daapCriticality;
        @Generated
        private ArrayList<String> daapInputPortGuids;
        @Generated
        private DataProductLineageStatus daapLineageStatus;
        @Generated
        private ArrayList<String> daapOutputPortGuids;
        @Generated
        private DataProductSensitivity daapSensitivity;
        @Generated
        private DataProductStatus daapStatus;
        @Generated
        private DataProductVisibility daapVisibility;
        @Generated
        private ArrayList<String> daapVisibilityGroups;
        @Generated
        private ArrayList<String> daapVisibilityUsers;
        @Generated
        private IDataDomain dataDomain;
        @Generated
        private String dataProductAssetsDSL;
        @Generated
        private String dataProductAssetsPlaybookFilter;
        @Generated
        private DataProductCriticality dataProductCriticality;
        @Generated
        private Long dataProductScoreUpdatedAt;
        @Generated
        private Double dataProductScoreValue;
        @Generated
        private DataProductSensitivity dataProductSensitivity;
        @Generated
        private DataProductStatus dataProductStatus;
        @Generated
        private DataProductVisibility dataProductVisibility;
        @Generated
        private ArrayList<IAsset> inputPorts;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<IAsset> outputPorts;
        @Generated
        private String parentDomainQualifiedName;
        @Generated
        private String superDomainQualifiedName;

        public B assetSelection(AtlanClient client, FluentSearch assetSelection) {
            return this.assetSelection(client, IndexSearchDSL.of(assetSelection.toUnfilteredQuery()));
        }

        public B assetSelection(AtlanClient client, IndexSearchDSL assetSelection) {
            return this.dataProductAssetsDSL(DataProductAssetsDSL.builder(assetSelection).build().toJson(client));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataProductBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataProduct instance, DataProductBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.daapCriticality(instance.daapCriticality);
            b.daapInputPortGuids(instance.daapInputPortGuids == null ? Collections.emptySortedSet() : instance.daapInputPortGuids);
            b.daapLineageStatus(instance.daapLineageStatus);
            b.daapOutputPortGuids(instance.daapOutputPortGuids == null ? Collections.emptySortedSet() : instance.daapOutputPortGuids);
            b.daapSensitivity(instance.daapSensitivity);
            b.daapStatus(instance.daapStatus);
            b.daapVisibility(instance.daapVisibility);
            b.daapVisibilityGroups(instance.daapVisibilityGroups == null ? Collections.emptySortedSet() : instance.daapVisibilityGroups);
            b.daapVisibilityUsers(instance.daapVisibilityUsers == null ? Collections.emptySortedSet() : instance.daapVisibilityUsers);
            b.dataDomain(instance.dataDomain);
            b.dataProductAssetsDSL(instance.dataProductAssetsDSL);
            b.dataProductAssetsPlaybookFilter(instance.dataProductAssetsPlaybookFilter);
            b.dataProductCriticality(instance.dataProductCriticality);
            b.dataProductScoreUpdatedAt(instance.dataProductScoreUpdatedAt);
            b.dataProductScoreValue(instance.dataProductScoreValue);
            b.dataProductSensitivity(instance.dataProductSensitivity);
            b.dataProductStatus(instance.dataProductStatus);
            b.dataProductVisibility(instance.dataProductVisibility);
            b.inputPorts(instance.inputPorts == null ? Collections.emptySortedSet() : instance.inputPorts);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.outputPorts(instance.outputPorts == null ? Collections.emptySortedSet() : instance.outputPorts);
            b.parentDomainQualifiedName(instance.parentDomainQualifiedName);
            b.superDomainQualifiedName(instance.superDomainQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B daapCriticality(DataProductCriticality daapCriticality) {
            this.daapCriticality = daapCriticality;
            return (B)this.self();
        }

        @Generated
        public B daapInputPortGuid(String daapInputPortGuid) {
            if (this.daapInputPortGuids == null) {
                this.daapInputPortGuids = new ArrayList();
            }
            this.daapInputPortGuids.add(daapInputPortGuid);
            return (B)this.self();
        }

        @Generated
        public B daapInputPortGuids(Collection<? extends String> daapInputPortGuids) {
            if (daapInputPortGuids == null) {
                throw new NullPointerException("daapInputPortGuids cannot be null");
            }
            if (this.daapInputPortGuids == null) {
                this.daapInputPortGuids = new ArrayList();
            }
            this.daapInputPortGuids.addAll(daapInputPortGuids);
            return (B)this.self();
        }

        @Generated
        public B clearDaapInputPortGuids() {
            if (this.daapInputPortGuids != null) {
                this.daapInputPortGuids.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B daapLineageStatus(DataProductLineageStatus daapLineageStatus) {
            this.daapLineageStatus = daapLineageStatus;
            return (B)this.self();
        }

        @Generated
        public B daapOutputPortGuid(String daapOutputPortGuid) {
            if (this.daapOutputPortGuids == null) {
                this.daapOutputPortGuids = new ArrayList();
            }
            this.daapOutputPortGuids.add(daapOutputPortGuid);
            return (B)this.self();
        }

        @Generated
        public B daapOutputPortGuids(Collection<? extends String> daapOutputPortGuids) {
            if (daapOutputPortGuids == null) {
                throw new NullPointerException("daapOutputPortGuids cannot be null");
            }
            if (this.daapOutputPortGuids == null) {
                this.daapOutputPortGuids = new ArrayList();
            }
            this.daapOutputPortGuids.addAll(daapOutputPortGuids);
            return (B)this.self();
        }

        @Generated
        public B clearDaapOutputPortGuids() {
            if (this.daapOutputPortGuids != null) {
                this.daapOutputPortGuids.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B daapSensitivity(DataProductSensitivity daapSensitivity) {
            this.daapSensitivity = daapSensitivity;
            return (B)this.self();
        }

        @Generated
        public B daapStatus(DataProductStatus daapStatus) {
            this.daapStatus = daapStatus;
            return (B)this.self();
        }

        @Generated
        public B daapVisibility(DataProductVisibility daapVisibility) {
            this.daapVisibility = daapVisibility;
            return (B)this.self();
        }

        @Generated
        public B daapVisibilityGroup(String daapVisibilityGroup) {
            if (this.daapVisibilityGroups == null) {
                this.daapVisibilityGroups = new ArrayList();
            }
            this.daapVisibilityGroups.add(daapVisibilityGroup);
            return (B)this.self();
        }

        @Generated
        public B daapVisibilityGroups(Collection<? extends String> daapVisibilityGroups) {
            if (daapVisibilityGroups == null) {
                throw new NullPointerException("daapVisibilityGroups cannot be null");
            }
            if (this.daapVisibilityGroups == null) {
                this.daapVisibilityGroups = new ArrayList();
            }
            this.daapVisibilityGroups.addAll(daapVisibilityGroups);
            return (B)this.self();
        }

        @Generated
        public B clearDaapVisibilityGroups() {
            if (this.daapVisibilityGroups != null) {
                this.daapVisibilityGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B daapVisibilityUser(String daapVisibilityUser) {
            if (this.daapVisibilityUsers == null) {
                this.daapVisibilityUsers = new ArrayList();
            }
            this.daapVisibilityUsers.add(daapVisibilityUser);
            return (B)this.self();
        }

        @Generated
        public B daapVisibilityUsers(Collection<? extends String> daapVisibilityUsers) {
            if (daapVisibilityUsers == null) {
                throw new NullPointerException("daapVisibilityUsers cannot be null");
            }
            if (this.daapVisibilityUsers == null) {
                this.daapVisibilityUsers = new ArrayList();
            }
            this.daapVisibilityUsers.addAll(daapVisibilityUsers);
            return (B)this.self();
        }

        @Generated
        public B clearDaapVisibilityUsers() {
            if (this.daapVisibilityUsers != null) {
                this.daapVisibilityUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataDomain(IDataDomain dataDomain) {
            this.dataDomain = dataDomain;
            return (B)this.self();
        }

        @Generated
        public B dataProductAssetsDSL(String dataProductAssetsDSL) {
            this.dataProductAssetsDSL = dataProductAssetsDSL;
            return (B)this.self();
        }

        @Generated
        public B dataProductAssetsPlaybookFilter(String dataProductAssetsPlaybookFilter) {
            this.dataProductAssetsPlaybookFilter = dataProductAssetsPlaybookFilter;
            return (B)this.self();
        }

        @Generated
        public B dataProductCriticality(DataProductCriticality dataProductCriticality) {
            this.dataProductCriticality = dataProductCriticality;
            return (B)this.self();
        }

        @Generated
        public B dataProductScoreUpdatedAt(Long dataProductScoreUpdatedAt) {
            this.dataProductScoreUpdatedAt = dataProductScoreUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B dataProductScoreValue(Double dataProductScoreValue) {
            this.dataProductScoreValue = dataProductScoreValue;
            return (B)this.self();
        }

        @Generated
        public B dataProductSensitivity(DataProductSensitivity dataProductSensitivity) {
            this.dataProductSensitivity = dataProductSensitivity;
            return (B)this.self();
        }

        @Generated
        public B dataProductStatus(DataProductStatus dataProductStatus) {
            this.dataProductStatus = dataProductStatus;
            return (B)this.self();
        }

        @Generated
        public B dataProductVisibility(DataProductVisibility dataProductVisibility) {
            this.dataProductVisibility = dataProductVisibility;
            return (B)this.self();
        }

        @Generated
        public B inputPort(IAsset inputPort) {
            if (this.inputPorts == null) {
                this.inputPorts = new ArrayList();
            }
            this.inputPorts.add(inputPort);
            return (B)this.self();
        }

        @Generated
        public B inputPorts(Collection<? extends IAsset> inputPorts) {
            if (inputPorts == null) {
                throw new NullPointerException("inputPorts cannot be null");
            }
            if (this.inputPorts == null) {
                this.inputPorts = new ArrayList();
            }
            this.inputPorts.addAll(inputPorts);
            return (B)this.self();
        }

        @Generated
        public B clearInputPorts() {
            if (this.inputPorts != null) {
                this.inputPorts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputPort(IAsset outputPort) {
            if (this.outputPorts == null) {
                this.outputPorts = new ArrayList();
            }
            this.outputPorts.add(outputPort);
            return (B)this.self();
        }

        @Generated
        public B outputPorts(Collection<? extends IAsset> outputPorts) {
            if (outputPorts == null) {
                throw new NullPointerException("outputPorts cannot be null");
            }
            if (this.outputPorts == null) {
                this.outputPorts = new ArrayList();
            }
            this.outputPorts.addAll(outputPorts);
            return (B)this.self();
        }

        @Generated
        public B clearOutputPorts() {
            if (this.outputPorts != null) {
                this.outputPorts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentDomainQualifiedName(String parentDomainQualifiedName) {
            this.parentDomainQualifiedName = parentDomainQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B superDomainQualifiedName(String superDomainQualifiedName) {
            this.superDomainQualifiedName = superDomainQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataProduct.DataProductBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", daapCriticality=" + String.valueOf(this.daapCriticality) + ", daapInputPortGuids=" + String.valueOf(this.daapInputPortGuids) + ", daapLineageStatus=" + String.valueOf(this.daapLineageStatus) + ", daapOutputPortGuids=" + String.valueOf(this.daapOutputPortGuids) + ", daapSensitivity=" + String.valueOf(this.daapSensitivity) + ", daapStatus=" + String.valueOf(this.daapStatus) + ", daapVisibility=" + String.valueOf(this.daapVisibility) + ", daapVisibilityGroups=" + String.valueOf(this.daapVisibilityGroups) + ", daapVisibilityUsers=" + String.valueOf(this.daapVisibilityUsers) + ", dataDomain=" + String.valueOf(this.dataDomain) + ", dataProductAssetsDSL=" + this.dataProductAssetsDSL + ", dataProductAssetsPlaybookFilter=" + this.dataProductAssetsPlaybookFilter + ", dataProductCriticality=" + String.valueOf(this.dataProductCriticality) + ", dataProductScoreUpdatedAt=" + this.dataProductScoreUpdatedAt + ", dataProductScoreValue=" + this.dataProductScoreValue + ", dataProductSensitivity=" + String.valueOf(this.dataProductSensitivity) + ", dataProductStatus=" + String.valueOf(this.dataProductStatus) + ", dataProductVisibility=" + String.valueOf(this.dataProductVisibility) + ", inputPorts=" + String.valueOf(this.inputPorts) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", outputPorts=" + String.valueOf(this.outputPorts) + ", parentDomainQualifiedName=" + this.parentDomainQualifiedName + ", superDomainQualifiedName=" + this.superDomainQualifiedName + ")";
        }
    }

    @Generated
    private static final class DataProductBuilderImpl
    extends DataProductBuilder<DataProduct, DataProductBuilderImpl> {
        @Generated
        private DataProductBuilderImpl() {
        }

        @Override
        @Generated
        protected DataProductBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataProduct build() {
            return new DataProduct(this);
        }
    }
}

