/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICloud;
import com.atlan.model.assets.IDataStudio;
import com.atlan.model.assets.IDataStudioAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IGoogle;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.GoogleDataStudioAssetType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.GoogleLabel;
import com.atlan.model.structs.GoogleTag;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStudioAsset
extends Asset
implements IDataStudioAsset,
IDataStudio,
IGoogle,
IBI,
ICloud,
IAsset,
IReferenceable,
ICatalog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataStudioAsset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataStudioAsset";
    String typeName;
    @Attribute
    String dataStudioAssetOwner;
    @Attribute
    String dataStudioAssetTitle;
    @Attribute
    GoogleDataStudioAssetType dataStudioAssetType;
    @Attribute
    List<GoogleLabel> googleLabels;
    @Attribute
    String googleLocation;
    @Attribute
    String googleLocationType;
    @Attribute
    String googleProjectId;
    @Attribute
    String googleProjectName;
    @Attribute
    Long googleProjectNumber;
    @Attribute
    String googleService;
    @Attribute
    List<GoogleTag> googleTags;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isTrashedDataStudioAsset;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DataStudioAsset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DataStudioAsset.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DataStudioAsset.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DataStudioAsset.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DataStudioAsset.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DataStudioAsset refByGuid(String guid) {
        return DataStudioAsset.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DataStudioAsset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DataStudioAsset refByQualifiedName(String qualifiedName) {
        return DataStudioAsset.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DataStudioAsset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id) throws AtlanException {
        return DataStudioAsset.get(client, id, false);
    }

    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DataStudioAsset) {
                return (DataStudioAsset)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof DataStudioAsset) {
            return (DataStudioAsset)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return DataStudioAsset.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static DataStudioAsset get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataStudioAsset.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof DataStudioAsset) {
                return (DataStudioAsset)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)DataStudioAsset.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof DataStudioAsset) {
            return (DataStudioAsset)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DataStudioAssetBuilder<?, ?> creator(String name, String connectionQualifiedName, GoogleDataStudioAssetType assetType) {
        return DataStudioAsset.creator(name, connectionQualifiedName, assetType, UUID.randomUUID().toString());
    }

    public static DataStudioAssetBuilder<?, ?> creator(String name, String connectionQualifiedName, GoogleDataStudioAssetType assetType, String gdsId) {
        return ((DataStudioAssetBuilder)((DataStudioAssetBuilder)((DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(DataStudioAsset.generateQualifiedName(gdsId, connectionQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).dataStudioAssetType(assetType);
    }

    public static String generateQualifiedName(String gdsId, String connectionQualifiedName) {
        return connectionQualifiedName + "/" + gdsId;
    }

    public static DataStudioAssetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataStudioAssetBuilder)((DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DataStudioAssetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        DataStudioAsset.validateRequired(TYPE_NAME, map);
        return DataStudioAsset.updater(this.getQualifiedName(), this.getName());
    }

    public static DataStudioAsset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeDescription(client, DataStudioAsset.updater(qualifiedName, name));
    }

    public static DataStudioAsset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeUserDescription(client, DataStudioAsset.updater(qualifiedName, name));
    }

    public static DataStudioAsset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeOwners(client, DataStudioAsset.updater(qualifiedName, name));
    }

    public static DataStudioAsset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DataStudioAsset)Asset.updateCertificate(client, DataStudioAsset._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataStudioAsset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeCertificate(client, DataStudioAsset.updater(qualifiedName, name));
    }

    public static DataStudioAsset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataStudioAsset)Asset.updateAnnouncement(client, DataStudioAsset._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataStudioAsset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeAnnouncement(client, DataStudioAsset.updater(qualifiedName, name));
    }

    public static DataStudioAsset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.replaceTerms(client, DataStudioAsset.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static DataStudioAsset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataStudioAsset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static DataStudioAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DataStudioAsset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static DataStudioAsset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DataStudioAsset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataStudioAsset(DataStudioAssetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataStudioAsset.$default$typeName();
        this.dataStudioAssetOwner = b.dataStudioAssetOwner;
        this.dataStudioAssetTitle = b.dataStudioAssetTitle;
        this.dataStudioAssetType = b.dataStudioAssetType;
        this.googleLabels = switch (b.googleLabels == null ? 0 : b.googleLabels.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.googleLabels.get(0));
            default -> Collections.unmodifiableList(new ArrayList<GoogleLabel>(b.googleLabels));
        };
        this.googleLocation = b.googleLocation;
        this.googleLocationType = b.googleLocationType;
        this.googleProjectId = b.googleProjectId;
        this.googleProjectName = b.googleProjectName;
        this.googleProjectNumber = b.googleProjectNumber;
        this.googleService = b.googleService;
        this.googleTags = switch (b.googleTags == null ? 0 : b.googleTags.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.googleTags.get(0));
            default -> Collections.unmodifiableList(new ArrayList<GoogleTag>(b.googleTags));
        };
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isTrashedDataStudioAsset = b.isTrashedDataStudioAsset;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DataStudioAssetBuilder<?, ?> _internal() {
        return new DataStudioAssetBuilderImpl();
    }

    @Generated
    public DataStudioAssetBuilder<?, ?> toBuilder() {
        return new DataStudioAssetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getDataStudioAssetOwner() {
        return this.dataStudioAssetOwner;
    }

    @Override
    @Generated
    public String getDataStudioAssetTitle() {
        return this.dataStudioAssetTitle;
    }

    @Override
    @Generated
    public GoogleDataStudioAssetType getDataStudioAssetType() {
        return this.dataStudioAssetType;
    }

    @Override
    @Generated
    public List<GoogleLabel> getGoogleLabels() {
        return this.googleLabels;
    }

    @Override
    @Generated
    public String getGoogleLocation() {
        return this.googleLocation;
    }

    @Override
    @Generated
    public String getGoogleLocationType() {
        return this.googleLocationType;
    }

    @Override
    @Generated
    public String getGoogleProjectId() {
        return this.googleProjectId;
    }

    @Override
    @Generated
    public String getGoogleProjectName() {
        return this.googleProjectName;
    }

    @Override
    @Generated
    public Long getGoogleProjectNumber() {
        return this.googleProjectNumber;
    }

    @Override
    @Generated
    public String getGoogleService() {
        return this.googleService;
    }

    @Override
    @Generated
    public List<GoogleTag> getGoogleTags() {
        return this.googleTags;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsTrashedDataStudioAsset() {
        return this.isTrashedDataStudioAsset;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataStudioAsset)) {
            return false;
        }
        DataStudioAsset other = (DataStudioAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$googleProjectNumber = this.getGoogleProjectNumber();
        Long other$googleProjectNumber = other.getGoogleProjectNumber();
        if (this$googleProjectNumber == null ? other$googleProjectNumber != null : !((Object)this$googleProjectNumber).equals(other$googleProjectNumber)) {
            return false;
        }
        Boolean this$isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        Boolean other$isTrashedDataStudioAsset = other.getIsTrashedDataStudioAsset();
        if (this$isTrashedDataStudioAsset == null ? other$isTrashedDataStudioAsset != null : !((Object)this$isTrashedDataStudioAsset).equals(other$isTrashedDataStudioAsset)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dataStudioAssetOwner = this.getDataStudioAssetOwner();
        String other$dataStudioAssetOwner = other.getDataStudioAssetOwner();
        if (this$dataStudioAssetOwner == null ? other$dataStudioAssetOwner != null : !this$dataStudioAssetOwner.equals(other$dataStudioAssetOwner)) {
            return false;
        }
        String this$dataStudioAssetTitle = this.getDataStudioAssetTitle();
        String other$dataStudioAssetTitle = other.getDataStudioAssetTitle();
        if (this$dataStudioAssetTitle == null ? other$dataStudioAssetTitle != null : !this$dataStudioAssetTitle.equals(other$dataStudioAssetTitle)) {
            return false;
        }
        GoogleDataStudioAssetType this$dataStudioAssetType = this.getDataStudioAssetType();
        GoogleDataStudioAssetType other$dataStudioAssetType = other.getDataStudioAssetType();
        if (this$dataStudioAssetType == null ? other$dataStudioAssetType != null : !this$dataStudioAssetType.equals(other$dataStudioAssetType)) {
            return false;
        }
        List<GoogleLabel> this$googleLabels = this.getGoogleLabels();
        List<GoogleLabel> other$googleLabels = other.getGoogleLabels();
        if (this$googleLabels == null ? other$googleLabels != null : !((Object)this$googleLabels).equals(other$googleLabels)) {
            return false;
        }
        String this$googleLocation = this.getGoogleLocation();
        String other$googleLocation = other.getGoogleLocation();
        if (this$googleLocation == null ? other$googleLocation != null : !this$googleLocation.equals(other$googleLocation)) {
            return false;
        }
        String this$googleLocationType = this.getGoogleLocationType();
        String other$googleLocationType = other.getGoogleLocationType();
        if (this$googleLocationType == null ? other$googleLocationType != null : !this$googleLocationType.equals(other$googleLocationType)) {
            return false;
        }
        String this$googleProjectId = this.getGoogleProjectId();
        String other$googleProjectId = other.getGoogleProjectId();
        if (this$googleProjectId == null ? other$googleProjectId != null : !this$googleProjectId.equals(other$googleProjectId)) {
            return false;
        }
        String this$googleProjectName = this.getGoogleProjectName();
        String other$googleProjectName = other.getGoogleProjectName();
        if (this$googleProjectName == null ? other$googleProjectName != null : !this$googleProjectName.equals(other$googleProjectName)) {
            return false;
        }
        String this$googleService = this.getGoogleService();
        String other$googleService = other.getGoogleService();
        if (this$googleService == null ? other$googleService != null : !this$googleService.equals(other$googleService)) {
            return false;
        }
        List<GoogleTag> this$googleTags = this.getGoogleTags();
        List<GoogleTag> other$googleTags = other.getGoogleTags();
        if (this$googleTags == null ? other$googleTags != null : !((Object)this$googleTags).equals(other$googleTags)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataStudioAsset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $googleProjectNumber = this.getGoogleProjectNumber();
        result = result * 59 + ($googleProjectNumber == null ? 43 : ((Object)$googleProjectNumber).hashCode());
        Boolean $isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        result = result * 59 + ($isTrashedDataStudioAsset == null ? 43 : ((Object)$isTrashedDataStudioAsset).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dataStudioAssetOwner = this.getDataStudioAssetOwner();
        result = result * 59 + ($dataStudioAssetOwner == null ? 43 : $dataStudioAssetOwner.hashCode());
        String $dataStudioAssetTitle = this.getDataStudioAssetTitle();
        result = result * 59 + ($dataStudioAssetTitle == null ? 43 : $dataStudioAssetTitle.hashCode());
        GoogleDataStudioAssetType $dataStudioAssetType = this.getDataStudioAssetType();
        result = result * 59 + ($dataStudioAssetType == null ? 43 : $dataStudioAssetType.hashCode());
        List<GoogleLabel> $googleLabels = this.getGoogleLabels();
        result = result * 59 + ($googleLabels == null ? 43 : ((Object)$googleLabels).hashCode());
        String $googleLocation = this.getGoogleLocation();
        result = result * 59 + ($googleLocation == null ? 43 : $googleLocation.hashCode());
        String $googleLocationType = this.getGoogleLocationType();
        result = result * 59 + ($googleLocationType == null ? 43 : $googleLocationType.hashCode());
        String $googleProjectId = this.getGoogleProjectId();
        result = result * 59 + ($googleProjectId == null ? 43 : $googleProjectId.hashCode());
        String $googleProjectName = this.getGoogleProjectName();
        result = result * 59 + ($googleProjectName == null ? 43 : $googleProjectName.hashCode());
        String $googleService = this.getGoogleService();
        result = result * 59 + ($googleService == null ? 43 : $googleService.hashCode());
        List<GoogleTag> $googleTags = this.getGoogleTags();
        result = result * 59 + ($googleTags == null ? 43 : ((Object)$googleTags).hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataStudioAsset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dataStudioAssetOwner=" + this.getDataStudioAssetOwner() + ", dataStudioAssetTitle=" + this.getDataStudioAssetTitle() + ", dataStudioAssetType=" + String.valueOf(this.getDataStudioAssetType()) + ", googleLabels=" + String.valueOf(this.getGoogleLabels()) + ", googleLocation=" + this.getGoogleLocation() + ", googleLocationType=" + this.getGoogleLocationType() + ", googleProjectId=" + this.getGoogleProjectId() + ", googleProjectName=" + this.getGoogleProjectName() + ", googleProjectNumber=" + this.getGoogleProjectNumber() + ", googleService=" + this.getGoogleService() + ", googleTags=" + String.valueOf(this.getGoogleTags()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isTrashedDataStudioAsset=" + this.getIsTrashedDataStudioAsset() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class DataStudioAssetBuilder<C extends DataStudioAsset, B extends DataStudioAssetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dataStudioAssetOwner;
        @Generated
        private String dataStudioAssetTitle;
        @Generated
        private GoogleDataStudioAssetType dataStudioAssetType;
        @Generated
        private ArrayList<GoogleLabel> googleLabels;
        @Generated
        private String googleLocation;
        @Generated
        private String googleLocationType;
        @Generated
        private String googleProjectId;
        @Generated
        private String googleProjectName;
        @Generated
        private Long googleProjectNumber;
        @Generated
        private String googleService;
        @Generated
        private ArrayList<GoogleTag> googleTags;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isTrashedDataStudioAsset;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataStudioAssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataStudioAsset instance, DataStudioAssetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataStudioAssetOwner(instance.dataStudioAssetOwner);
            b.dataStudioAssetTitle(instance.dataStudioAssetTitle);
            b.dataStudioAssetType(instance.dataStudioAssetType);
            b.googleLabels(instance.googleLabels == null ? Collections.emptyList() : instance.googleLabels);
            b.googleLocation(instance.googleLocation);
            b.googleLocationType(instance.googleLocationType);
            b.googleProjectId(instance.googleProjectId);
            b.googleProjectName(instance.googleProjectName);
            b.googleProjectNumber(instance.googleProjectNumber);
            b.googleService(instance.googleService);
            b.googleTags(instance.googleTags == null ? Collections.emptyList() : instance.googleTags);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isTrashedDataStudioAsset(instance.isTrashedDataStudioAsset);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetOwner(String dataStudioAssetOwner) {
            this.dataStudioAssetOwner = dataStudioAssetOwner;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetTitle(String dataStudioAssetTitle) {
            this.dataStudioAssetTitle = dataStudioAssetTitle;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetType(GoogleDataStudioAssetType dataStudioAssetType) {
            this.dataStudioAssetType = dataStudioAssetType;
            return (B)this.self();
        }

        @Generated
        public B googleLabel(GoogleLabel googleLabel) {
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.add(googleLabel);
            return (B)this.self();
        }

        @Generated
        public B googleLabels(Collection<? extends GoogleLabel> googleLabels) {
            if (googleLabels == null) {
                throw new NullPointerException("googleLabels cannot be null");
            }
            if (this.googleLabels == null) {
                this.googleLabels = new ArrayList();
            }
            this.googleLabels.addAll(googleLabels);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleLabels() {
            if (this.googleLabels != null) {
                this.googleLabels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B googleLocation(String googleLocation) {
            this.googleLocation = googleLocation;
            return (B)this.self();
        }

        @Generated
        public B googleLocationType(String googleLocationType) {
            this.googleLocationType = googleLocationType;
            return (B)this.self();
        }

        @Generated
        public B googleProjectId(String googleProjectId) {
            this.googleProjectId = googleProjectId;
            return (B)this.self();
        }

        @Generated
        public B googleProjectName(String googleProjectName) {
            this.googleProjectName = googleProjectName;
            return (B)this.self();
        }

        @Generated
        public B googleProjectNumber(Long googleProjectNumber) {
            this.googleProjectNumber = googleProjectNumber;
            return (B)this.self();
        }

        @Generated
        public B googleService(String googleService) {
            this.googleService = googleService;
            return (B)this.self();
        }

        @Generated
        public B googleTag(GoogleTag googleTag) {
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.add(googleTag);
            return (B)this.self();
        }

        @Generated
        public B googleTags(Collection<? extends GoogleTag> googleTags) {
            if (googleTags == null) {
                throw new NullPointerException("googleTags cannot be null");
            }
            if (this.googleTags == null) {
                this.googleTags = new ArrayList();
            }
            this.googleTags.addAll(googleTags);
            return (B)this.self();
        }

        @Generated
        public B clearGoogleTags() {
            if (this.googleTags != null) {
                this.googleTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isTrashedDataStudioAsset(Boolean isTrashedDataStudioAsset) {
            this.isTrashedDataStudioAsset = isTrashedDataStudioAsset;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DataStudioAsset.DataStudioAssetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataStudioAssetOwner=" + this.dataStudioAssetOwner + ", dataStudioAssetTitle=" + this.dataStudioAssetTitle + ", dataStudioAssetType=" + String.valueOf(this.dataStudioAssetType) + ", googleLabels=" + String.valueOf(this.googleLabels) + ", googleLocation=" + this.googleLocation + ", googleLocationType=" + this.googleLocationType + ", googleProjectId=" + this.googleProjectId + ", googleProjectName=" + this.googleProjectName + ", googleProjectNumber=" + this.googleProjectNumber + ", googleService=" + this.googleService + ", googleTags=" + String.valueOf(this.googleTags) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isTrashedDataStudioAsset=" + this.isTrashedDataStudioAsset + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class DataStudioAssetBuilderImpl
    extends DataStudioAssetBuilder<DataStudioAsset, DataStudioAssetBuilderImpl> {
        @Generated
        private DataStudioAssetBuilderImpl() {
        }

        @Override
        @Generated
        protected DataStudioAssetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataStudioAsset build() {
            return new DataStudioAsset(this);
        }
    }
}

