/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IFlow;
import com.atlan.model.assets.IFlowDataset;
import com.atlan.model.assets.IFlowField;
import com.atlan.model.assets.IFlowReusableUnit;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowDataset
extends Asset
implements IFlowDataset,
ICatalog,
IFlow,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowDataset.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "FlowDataset";
    String typeName;
    @Attribute
    IFlowReusableUnit flowDetailedBy;
    @Attribute
    String flowErrorMessage;
    @Attribute
    String flowExpression;
    @Attribute
    Long flowFieldCount;
    @Attribute
    SortedSet<IFlowField> flowFields;
    @Attribute
    @Date
    Long flowFinishedAt;
    @Attribute
    String flowFolderName;
    @Attribute
    String flowFolderQualifiedName;
    @Attribute
    String flowId;
    @Attribute
    IFlowReusableUnit flowParentUnit;
    @Attribute
    String flowProjectName;
    @Attribute
    String flowProjectQualifiedName;
    @Attribute
    String flowQuery;
    @Attribute
    String flowReusableUnitName;
    @Attribute
    String flowReusableUnitQualifiedName;
    @Attribute
    String flowRunId;
    @Attribute
    String flowSchedule;
    @Attribute
    @Date
    Long flowStartedAt;
    @Attribute
    String flowStatus;
    @Attribute
    String flowType;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public FlowDataset trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return FlowDataset.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return FlowDataset.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return FlowDataset.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return FlowDataset.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static FlowDataset refByGuid(String guid) {
        return FlowDataset.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static FlowDataset refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FlowDatasetBuilder)((FlowDatasetBuilder)FlowDataset._internal().guid(guid)).semantic(semantic)).build();
    }

    public static FlowDataset refByQualifiedName(String qualifiedName) {
        return FlowDataset.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static FlowDataset refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FlowDatasetBuilder)((FlowDatasetBuilder)FlowDataset._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static FlowDataset get(AtlanClient client, String id) throws AtlanException {
        return FlowDataset.get(client, id, false);
    }

    @JsonIgnore
    public static FlowDataset get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof FlowDataset) {
                return (FlowDataset)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof FlowDataset) {
            return (FlowDataset)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static FlowDataset get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return FlowDataset.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static FlowDataset get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowDataset.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof FlowDataset) {
                return (FlowDataset)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowDataset.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof FlowDataset) {
            return (FlowDataset)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FlowDatasetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FlowDatasetBuilder)((FlowDatasetBuilder)((FlowDatasetBuilder)FlowDataset._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FlowDatasetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        FlowDataset.validateRequired(TYPE_NAME, map);
        return FlowDataset.updater(this.getQualifiedName(), this.getName());
    }

    public static FlowDataset removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDataset)Asset.removeDescription(client, FlowDataset.updater(qualifiedName, name));
    }

    public static FlowDataset removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDataset)Asset.removeUserDescription(client, FlowDataset.updater(qualifiedName, name));
    }

    public static FlowDataset removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDataset)Asset.removeOwners(client, FlowDataset.updater(qualifiedName, name));
    }

    public static FlowDataset updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (FlowDataset)Asset.updateCertificate(client, FlowDataset._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static FlowDataset removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDataset)Asset.removeCertificate(client, FlowDataset.updater(qualifiedName, name));
    }

    public static FlowDataset updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (FlowDataset)Asset.updateAnnouncement(client, FlowDataset._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static FlowDataset removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDataset)Asset.removeAnnouncement(client, FlowDataset.updater(qualifiedName, name));
    }

    public static FlowDataset replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDataset)Asset.replaceTerms(client, FlowDataset.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static FlowDataset appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDataset)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowDataset removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDataset)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (FlowDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static FlowDataset appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (FlowDataset)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected FlowDataset(FlowDatasetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : FlowDataset.$default$typeName();
        this.flowDetailedBy = b.flowDetailedBy;
        this.flowErrorMessage = b.flowErrorMessage;
        this.flowExpression = b.flowExpression;
        this.flowFieldCount = b.flowFieldCount;
        SortedSet<IFlowField> flowFields = new TreeSet<IFlowField>();
        if (b.flowFields != null) {
            flowFields.addAll(b.flowFields);
        }
        flowFields = Collections.unmodifiableSortedSet(flowFields);
        this.flowFields = flowFields;
        this.flowFinishedAt = b.flowFinishedAt;
        this.flowFolderName = b.flowFolderName;
        this.flowFolderQualifiedName = b.flowFolderQualifiedName;
        this.flowId = b.flowId;
        this.flowParentUnit = b.flowParentUnit;
        this.flowProjectName = b.flowProjectName;
        this.flowProjectQualifiedName = b.flowProjectQualifiedName;
        this.flowQuery = b.flowQuery;
        this.flowReusableUnitName = b.flowReusableUnitName;
        this.flowReusableUnitQualifiedName = b.flowReusableUnitQualifiedName;
        this.flowRunId = b.flowRunId;
        this.flowSchedule = b.flowSchedule;
        this.flowStartedAt = b.flowStartedAt;
        this.flowStatus = b.flowStatus;
        this.flowType = b.flowType;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static FlowDatasetBuilder<?, ?> _internal() {
        return new FlowDatasetBuilderImpl();
    }

    @Generated
    public FlowDatasetBuilder<?, ?> toBuilder() {
        return new FlowDatasetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public IFlowReusableUnit getFlowDetailedBy() {
        return this.flowDetailedBy;
    }

    @Override
    @Generated
    public String getFlowErrorMessage() {
        return this.flowErrorMessage;
    }

    @Override
    @Generated
    public String getFlowExpression() {
        return this.flowExpression;
    }

    @Override
    @Generated
    public Long getFlowFieldCount() {
        return this.flowFieldCount;
    }

    @Override
    @Generated
    public SortedSet<IFlowField> getFlowFields() {
        return this.flowFields;
    }

    @Override
    @Generated
    public Long getFlowFinishedAt() {
        return this.flowFinishedAt;
    }

    @Override
    @Generated
    public String getFlowFolderName() {
        return this.flowFolderName;
    }

    @Override
    @Generated
    public String getFlowFolderQualifiedName() {
        return this.flowFolderQualifiedName;
    }

    @Override
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    @Generated
    public IFlowReusableUnit getFlowParentUnit() {
        return this.flowParentUnit;
    }

    @Override
    @Generated
    public String getFlowProjectName() {
        return this.flowProjectName;
    }

    @Override
    @Generated
    public String getFlowProjectQualifiedName() {
        return this.flowProjectQualifiedName;
    }

    @Override
    @Generated
    public String getFlowQuery() {
        return this.flowQuery;
    }

    @Override
    @Generated
    public String getFlowReusableUnitName() {
        return this.flowReusableUnitName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitQualifiedName() {
        return this.flowReusableUnitQualifiedName;
    }

    @Override
    @Generated
    public String getFlowRunId() {
        return this.flowRunId;
    }

    @Override
    @Generated
    public String getFlowSchedule() {
        return this.flowSchedule;
    }

    @Override
    @Generated
    public Long getFlowStartedAt() {
        return this.flowStartedAt;
    }

    @Override
    @Generated
    public String getFlowStatus() {
        return this.flowStatus;
    }

    @Override
    @Generated
    public String getFlowType() {
        return this.flowType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowDataset)) {
            return false;
        }
        FlowDataset other = (FlowDataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$flowFieldCount = this.getFlowFieldCount();
        Long other$flowFieldCount = other.getFlowFieldCount();
        if (this$flowFieldCount == null ? other$flowFieldCount != null : !((Object)this$flowFieldCount).equals(other$flowFieldCount)) {
            return false;
        }
        Long this$flowFinishedAt = this.getFlowFinishedAt();
        Long other$flowFinishedAt = other.getFlowFinishedAt();
        if (this$flowFinishedAt == null ? other$flowFinishedAt != null : !((Object)this$flowFinishedAt).equals(other$flowFinishedAt)) {
            return false;
        }
        Long this$flowStartedAt = this.getFlowStartedAt();
        Long other$flowStartedAt = other.getFlowStartedAt();
        if (this$flowStartedAt == null ? other$flowStartedAt != null : !((Object)this$flowStartedAt).equals(other$flowStartedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        IFlowReusableUnit this$flowDetailedBy = this.getFlowDetailedBy();
        IFlowReusableUnit other$flowDetailedBy = other.getFlowDetailedBy();
        if (this$flowDetailedBy == null ? other$flowDetailedBy != null : !this$flowDetailedBy.equals(other$flowDetailedBy)) {
            return false;
        }
        String this$flowErrorMessage = this.getFlowErrorMessage();
        String other$flowErrorMessage = other.getFlowErrorMessage();
        if (this$flowErrorMessage == null ? other$flowErrorMessage != null : !this$flowErrorMessage.equals(other$flowErrorMessage)) {
            return false;
        }
        String this$flowExpression = this.getFlowExpression();
        String other$flowExpression = other.getFlowExpression();
        if (this$flowExpression == null ? other$flowExpression != null : !this$flowExpression.equals(other$flowExpression)) {
            return false;
        }
        SortedSet<IFlowField> this$flowFields = this.getFlowFields();
        SortedSet<IFlowField> other$flowFields = other.getFlowFields();
        if (this$flowFields == null ? other$flowFields != null : !this$flowFields.equals(other$flowFields)) {
            return false;
        }
        String this$flowFolderName = this.getFlowFolderName();
        String other$flowFolderName = other.getFlowFolderName();
        if (this$flowFolderName == null ? other$flowFolderName != null : !this$flowFolderName.equals(other$flowFolderName)) {
            return false;
        }
        String this$flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        String other$flowFolderQualifiedName = other.getFlowFolderQualifiedName();
        if (this$flowFolderQualifiedName == null ? other$flowFolderQualifiedName != null : !this$flowFolderQualifiedName.equals(other$flowFolderQualifiedName)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        IFlowReusableUnit this$flowParentUnit = this.getFlowParentUnit();
        IFlowReusableUnit other$flowParentUnit = other.getFlowParentUnit();
        if (this$flowParentUnit == null ? other$flowParentUnit != null : !this$flowParentUnit.equals(other$flowParentUnit)) {
            return false;
        }
        String this$flowProjectName = this.getFlowProjectName();
        String other$flowProjectName = other.getFlowProjectName();
        if (this$flowProjectName == null ? other$flowProjectName != null : !this$flowProjectName.equals(other$flowProjectName)) {
            return false;
        }
        String this$flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        String other$flowProjectQualifiedName = other.getFlowProjectQualifiedName();
        if (this$flowProjectQualifiedName == null ? other$flowProjectQualifiedName != null : !this$flowProjectQualifiedName.equals(other$flowProjectQualifiedName)) {
            return false;
        }
        String this$flowQuery = this.getFlowQuery();
        String other$flowQuery = other.getFlowQuery();
        if (this$flowQuery == null ? other$flowQuery != null : !this$flowQuery.equals(other$flowQuery)) {
            return false;
        }
        String this$flowReusableUnitName = this.getFlowReusableUnitName();
        String other$flowReusableUnitName = other.getFlowReusableUnitName();
        if (this$flowReusableUnitName == null ? other$flowReusableUnitName != null : !this$flowReusableUnitName.equals(other$flowReusableUnitName)) {
            return false;
        }
        String this$flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        String other$flowReusableUnitQualifiedName = other.getFlowReusableUnitQualifiedName();
        if (this$flowReusableUnitQualifiedName == null ? other$flowReusableUnitQualifiedName != null : !this$flowReusableUnitQualifiedName.equals(other$flowReusableUnitQualifiedName)) {
            return false;
        }
        String this$flowRunId = this.getFlowRunId();
        String other$flowRunId = other.getFlowRunId();
        if (this$flowRunId == null ? other$flowRunId != null : !this$flowRunId.equals(other$flowRunId)) {
            return false;
        }
        String this$flowSchedule = this.getFlowSchedule();
        String other$flowSchedule = other.getFlowSchedule();
        if (this$flowSchedule == null ? other$flowSchedule != null : !this$flowSchedule.equals(other$flowSchedule)) {
            return false;
        }
        String this$flowStatus = this.getFlowStatus();
        String other$flowStatus = other.getFlowStatus();
        if (this$flowStatus == null ? other$flowStatus != null : !this$flowStatus.equals(other$flowStatus)) {
            return false;
        }
        String this$flowType = this.getFlowType();
        String other$flowType = other.getFlowType();
        if (this$flowType == null ? other$flowType != null : !this$flowType.equals(other$flowType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowDataset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $flowFieldCount = this.getFlowFieldCount();
        result = result * 59 + ($flowFieldCount == null ? 43 : ((Object)$flowFieldCount).hashCode());
        Long $flowFinishedAt = this.getFlowFinishedAt();
        result = result * 59 + ($flowFinishedAt == null ? 43 : ((Object)$flowFinishedAt).hashCode());
        Long $flowStartedAt = this.getFlowStartedAt();
        result = result * 59 + ($flowStartedAt == null ? 43 : ((Object)$flowStartedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        IFlowReusableUnit $flowDetailedBy = this.getFlowDetailedBy();
        result = result * 59 + ($flowDetailedBy == null ? 43 : $flowDetailedBy.hashCode());
        String $flowErrorMessage = this.getFlowErrorMessage();
        result = result * 59 + ($flowErrorMessage == null ? 43 : $flowErrorMessage.hashCode());
        String $flowExpression = this.getFlowExpression();
        result = result * 59 + ($flowExpression == null ? 43 : $flowExpression.hashCode());
        SortedSet<IFlowField> $flowFields = this.getFlowFields();
        result = result * 59 + ($flowFields == null ? 43 : $flowFields.hashCode());
        String $flowFolderName = this.getFlowFolderName();
        result = result * 59 + ($flowFolderName == null ? 43 : $flowFolderName.hashCode());
        String $flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        result = result * 59 + ($flowFolderQualifiedName == null ? 43 : $flowFolderQualifiedName.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        IFlowReusableUnit $flowParentUnit = this.getFlowParentUnit();
        result = result * 59 + ($flowParentUnit == null ? 43 : $flowParentUnit.hashCode());
        String $flowProjectName = this.getFlowProjectName();
        result = result * 59 + ($flowProjectName == null ? 43 : $flowProjectName.hashCode());
        String $flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        result = result * 59 + ($flowProjectQualifiedName == null ? 43 : $flowProjectQualifiedName.hashCode());
        String $flowQuery = this.getFlowQuery();
        result = result * 59 + ($flowQuery == null ? 43 : $flowQuery.hashCode());
        String $flowReusableUnitName = this.getFlowReusableUnitName();
        result = result * 59 + ($flowReusableUnitName == null ? 43 : $flowReusableUnitName.hashCode());
        String $flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        result = result * 59 + ($flowReusableUnitQualifiedName == null ? 43 : $flowReusableUnitQualifiedName.hashCode());
        String $flowRunId = this.getFlowRunId();
        result = result * 59 + ($flowRunId == null ? 43 : $flowRunId.hashCode());
        String $flowSchedule = this.getFlowSchedule();
        result = result * 59 + ($flowSchedule == null ? 43 : $flowSchedule.hashCode());
        String $flowStatus = this.getFlowStatus();
        result = result * 59 + ($flowStatus == null ? 43 : $flowStatus.hashCode());
        String $flowType = this.getFlowType();
        result = result * 59 + ($flowType == null ? 43 : $flowType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FlowDataset(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", flowDetailedBy=" + String.valueOf(this.getFlowDetailedBy()) + ", flowErrorMessage=" + this.getFlowErrorMessage() + ", flowExpression=" + this.getFlowExpression() + ", flowFieldCount=" + this.getFlowFieldCount() + ", flowFields=" + String.valueOf(this.getFlowFields()) + ", flowFinishedAt=" + this.getFlowFinishedAt() + ", flowFolderName=" + this.getFlowFolderName() + ", flowFolderQualifiedName=" + this.getFlowFolderQualifiedName() + ", flowId=" + this.getFlowId() + ", flowParentUnit=" + String.valueOf(this.getFlowParentUnit()) + ", flowProjectName=" + this.getFlowProjectName() + ", flowProjectQualifiedName=" + this.getFlowProjectQualifiedName() + ", flowQuery=" + this.getFlowQuery() + ", flowReusableUnitName=" + this.getFlowReusableUnitName() + ", flowReusableUnitQualifiedName=" + this.getFlowReusableUnitQualifiedName() + ", flowRunId=" + this.getFlowRunId() + ", flowSchedule=" + this.getFlowSchedule() + ", flowStartedAt=" + this.getFlowStartedAt() + ", flowStatus=" + this.getFlowStatus() + ", flowType=" + this.getFlowType() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class FlowDatasetBuilder<C extends FlowDataset, B extends FlowDatasetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private IFlowReusableUnit flowDetailedBy;
        @Generated
        private String flowErrorMessage;
        @Generated
        private String flowExpression;
        @Generated
        private Long flowFieldCount;
        @Generated
        private ArrayList<IFlowField> flowFields;
        @Generated
        private Long flowFinishedAt;
        @Generated
        private String flowFolderName;
        @Generated
        private String flowFolderQualifiedName;
        @Generated
        private String flowId;
        @Generated
        private IFlowReusableUnit flowParentUnit;
        @Generated
        private String flowProjectName;
        @Generated
        private String flowProjectQualifiedName;
        @Generated
        private String flowQuery;
        @Generated
        private String flowReusableUnitName;
        @Generated
        private String flowReusableUnitQualifiedName;
        @Generated
        private String flowRunId;
        @Generated
        private String flowSchedule;
        @Generated
        private Long flowStartedAt;
        @Generated
        private String flowStatus;
        @Generated
        private String flowType;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowDatasetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowDataset instance, FlowDatasetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.flowDetailedBy(instance.flowDetailedBy);
            b.flowErrorMessage(instance.flowErrorMessage);
            b.flowExpression(instance.flowExpression);
            b.flowFieldCount(instance.flowFieldCount);
            b.flowFields(instance.flowFields == null ? Collections.emptySortedSet() : instance.flowFields);
            b.flowFinishedAt(instance.flowFinishedAt);
            b.flowFolderName(instance.flowFolderName);
            b.flowFolderQualifiedName(instance.flowFolderQualifiedName);
            b.flowId(instance.flowId);
            b.flowParentUnit(instance.flowParentUnit);
            b.flowProjectName(instance.flowProjectName);
            b.flowProjectQualifiedName(instance.flowProjectQualifiedName);
            b.flowQuery(instance.flowQuery);
            b.flowReusableUnitName(instance.flowReusableUnitName);
            b.flowReusableUnitQualifiedName(instance.flowReusableUnitQualifiedName);
            b.flowRunId(instance.flowRunId);
            b.flowSchedule(instance.flowSchedule);
            b.flowStartedAt(instance.flowStartedAt);
            b.flowStatus(instance.flowStatus);
            b.flowType(instance.flowType);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B flowDetailedBy(IFlowReusableUnit flowDetailedBy) {
            this.flowDetailedBy = flowDetailedBy;
            return (B)this.self();
        }

        @Generated
        public B flowErrorMessage(String flowErrorMessage) {
            this.flowErrorMessage = flowErrorMessage;
            return (B)this.self();
        }

        @Generated
        public B flowExpression(String flowExpression) {
            this.flowExpression = flowExpression;
            return (B)this.self();
        }

        @Generated
        public B flowFieldCount(Long flowFieldCount) {
            this.flowFieldCount = flowFieldCount;
            return (B)this.self();
        }

        @Generated
        public B flowField(IFlowField flowField) {
            if (this.flowFields == null) {
                this.flowFields = new ArrayList();
            }
            this.flowFields.add(flowField);
            return (B)this.self();
        }

        @Generated
        public B flowFields(Collection<? extends IFlowField> flowFields) {
            if (flowFields == null) {
                throw new NullPointerException("flowFields cannot be null");
            }
            if (this.flowFields == null) {
                this.flowFields = new ArrayList();
            }
            this.flowFields.addAll(flowFields);
            return (B)this.self();
        }

        @Generated
        public B clearFlowFields() {
            if (this.flowFields != null) {
                this.flowFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flowFinishedAt(Long flowFinishedAt) {
            this.flowFinishedAt = flowFinishedAt;
            return (B)this.self();
        }

        @Generated
        public B flowFolderName(String flowFolderName) {
            this.flowFolderName = flowFolderName;
            return (B)this.self();
        }

        @Generated
        public B flowFolderQualifiedName(String flowFolderQualifiedName) {
            this.flowFolderQualifiedName = flowFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B flowParentUnit(IFlowReusableUnit flowParentUnit) {
            this.flowParentUnit = flowParentUnit;
            return (B)this.self();
        }

        @Generated
        public B flowProjectName(String flowProjectName) {
            this.flowProjectName = flowProjectName;
            return (B)this.self();
        }

        @Generated
        public B flowProjectQualifiedName(String flowProjectQualifiedName) {
            this.flowProjectQualifiedName = flowProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowQuery(String flowQuery) {
            this.flowQuery = flowQuery;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitName(String flowReusableUnitName) {
            this.flowReusableUnitName = flowReusableUnitName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitQualifiedName(String flowReusableUnitQualifiedName) {
            this.flowReusableUnitQualifiedName = flowReusableUnitQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowRunId(String flowRunId) {
            this.flowRunId = flowRunId;
            return (B)this.self();
        }

        @Generated
        public B flowSchedule(String flowSchedule) {
            this.flowSchedule = flowSchedule;
            return (B)this.self();
        }

        @Generated
        public B flowStartedAt(Long flowStartedAt) {
            this.flowStartedAt = flowStartedAt;
            return (B)this.self();
        }

        @Generated
        public B flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return (B)this.self();
        }

        @Generated
        public B flowType(String flowType) {
            this.flowType = flowType;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowDataset.FlowDatasetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", flowDetailedBy=" + String.valueOf(this.flowDetailedBy) + ", flowErrorMessage=" + this.flowErrorMessage + ", flowExpression=" + this.flowExpression + ", flowFieldCount=" + this.flowFieldCount + ", flowFields=" + String.valueOf(this.flowFields) + ", flowFinishedAt=" + this.flowFinishedAt + ", flowFolderName=" + this.flowFolderName + ", flowFolderQualifiedName=" + this.flowFolderQualifiedName + ", flowId=" + this.flowId + ", flowParentUnit=" + String.valueOf(this.flowParentUnit) + ", flowProjectName=" + this.flowProjectName + ", flowProjectQualifiedName=" + this.flowProjectQualifiedName + ", flowQuery=" + this.flowQuery + ", flowReusableUnitName=" + this.flowReusableUnitName + ", flowReusableUnitQualifiedName=" + this.flowReusableUnitQualifiedName + ", flowRunId=" + this.flowRunId + ", flowSchedule=" + this.flowSchedule + ", flowStartedAt=" + this.flowStartedAt + ", flowStatus=" + this.flowStatus + ", flowType=" + this.flowType + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class FlowDatasetBuilderImpl
    extends FlowDatasetBuilder<FlowDataset, FlowDatasetBuilderImpl> {
        @Generated
        private FlowDatasetBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowDatasetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowDataset build() {
            return new FlowDataset(this);
        }
    }
}

