/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAdfActivity;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumnProcess;
import com.atlan.model.assets.IFivetranConnector;
import com.atlan.model.assets.IFlow;
import com.atlan.model.assets.IFlowControlOperation;
import com.atlan.model.assets.IFlowDatasetOperation;
import com.atlan.model.assets.IFlowReusableUnit;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMatillionComponent;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AIDatasetType;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowDatasetOperation
extends Asset
implements IFlowDatasetOperation,
ILineageProcess,
IFlow,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowDatasetOperation.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "FlowDatasetOperation";
    String typeName;
    @Attribute
    String additionalEtlContext;
    @Attribute
    IAdfActivity adfActivity;
    @Attribute
    AIDatasetType aiDatasetType;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    String ast;
    @Attribute
    String code;
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    @Attribute
    IFivetranConnector fivetranConnector;
    @Attribute
    String flowErrorMessage;
    @Attribute
    @Date
    Long flowFinishedAt;
    @Attribute
    String flowFolderName;
    @Attribute
    String flowFolderQualifiedName;
    @Attribute
    String flowId;
    @Attribute
    IFlowControlOperation flowOrchestratedBy;
    @Attribute
    String flowProjectName;
    @Attribute
    String flowProjectQualifiedName;
    @Attribute
    IFlowReusableUnit flowReusableUnit;
    @Attribute
    String flowReusableUnitName;
    @Attribute
    String flowReusableUnitQualifiedName;
    @Attribute
    String flowRunId;
    @Attribute
    String flowSchedule;
    @Attribute
    @Date
    Long flowStartedAt;
    @Attribute
    String flowStatus;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    IMatillionComponent matillionComponent;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    @JsonProperty(value="parentConnectionProcessQualifiedName")
    SortedSet<String> parentConnectionProcessQualifiedNames;
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    @Attribute
    String sql;

    @Override
    public FlowDatasetOperation trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return FlowDatasetOperation.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return FlowDatasetOperation.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return FlowDatasetOperation.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return FlowDatasetOperation.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static FlowDatasetOperation refByGuid(String guid) {
        return FlowDatasetOperation.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static FlowDatasetOperation refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FlowDatasetOperationBuilder)((FlowDatasetOperationBuilder)FlowDatasetOperation._internal().guid(guid)).semantic(semantic)).build();
    }

    public static FlowDatasetOperation refByQualifiedName(String qualifiedName) {
        return FlowDatasetOperation.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static FlowDatasetOperation refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FlowDatasetOperationBuilder)((FlowDatasetOperationBuilder)FlowDatasetOperation._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static FlowDatasetOperation get(AtlanClient client, String id) throws AtlanException {
        return FlowDatasetOperation.get(client, id, false);
    }

    @JsonIgnore
    public static FlowDatasetOperation get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof FlowDatasetOperation) {
                return (FlowDatasetOperation)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof FlowDatasetOperation) {
            return (FlowDatasetOperation)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static FlowDatasetOperation get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return FlowDatasetOperation.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static FlowDatasetOperation get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowDatasetOperation.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof FlowDatasetOperation) {
                return (FlowDatasetOperation)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowDatasetOperation.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof FlowDatasetOperation) {
            return (FlowDatasetOperation)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FlowDatasetOperationBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FlowDatasetOperationBuilder)((FlowDatasetOperationBuilder)((FlowDatasetOperationBuilder)FlowDatasetOperation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FlowDatasetOperationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        FlowDatasetOperation.validateRequired(TYPE_NAME, map);
        return FlowDatasetOperation.updater(this.getQualifiedName(), this.getName());
    }

    public static FlowDatasetOperation removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeDescription(client, FlowDatasetOperation.updater(qualifiedName, name));
    }

    public static FlowDatasetOperation removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeUserDescription(client, FlowDatasetOperation.updater(qualifiedName, name));
    }

    public static FlowDatasetOperation removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeOwners(client, FlowDatasetOperation.updater(qualifiedName, name));
    }

    public static FlowDatasetOperation updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (FlowDatasetOperation)Asset.updateCertificate(client, FlowDatasetOperation._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static FlowDatasetOperation removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeCertificate(client, FlowDatasetOperation.updater(qualifiedName, name));
    }

    public static FlowDatasetOperation updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (FlowDatasetOperation)Asset.updateAnnouncement(client, FlowDatasetOperation._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static FlowDatasetOperation removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeAnnouncement(client, FlowDatasetOperation.updater(qualifiedName, name));
    }

    public static FlowDatasetOperation replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDatasetOperation)Asset.replaceTerms(client, FlowDatasetOperation.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static FlowDatasetOperation appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDatasetOperation)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowDatasetOperation removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowDatasetOperation)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowDatasetOperation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (FlowDatasetOperation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static FlowDatasetOperation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (FlowDatasetOperation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected FlowDatasetOperation(FlowDatasetOperationBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : FlowDatasetOperation.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        this.adfActivity = b.adfActivity;
        this.aiDatasetType = b.aiDatasetType;
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        SortedSet<IColumnProcess> columnProcesses = new TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        this.fivetranConnector = b.fivetranConnector;
        this.flowErrorMessage = b.flowErrorMessage;
        this.flowFinishedAt = b.flowFinishedAt;
        this.flowFolderName = b.flowFolderName;
        this.flowFolderQualifiedName = b.flowFolderQualifiedName;
        this.flowId = b.flowId;
        this.flowOrchestratedBy = b.flowOrchestratedBy;
        this.flowProjectName = b.flowProjectName;
        this.flowProjectQualifiedName = b.flowProjectQualifiedName;
        this.flowReusableUnit = b.flowReusableUnit;
        this.flowReusableUnitName = b.flowReusableUnitName;
        this.flowReusableUnitQualifiedName = b.flowReusableUnitQualifiedName;
        this.flowRunId = b.flowRunId;
        this.flowSchedule = b.flowSchedule;
        this.flowStartedAt = b.flowStartedAt;
        this.flowStatus = b.flowStatus;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        SortedSet<String> parentConnectionProcessQualifiedNames = new TreeSet<String>();
        if (b.parentConnectionProcessQualifiedNames != null) {
            parentConnectionProcessQualifiedNames.addAll(b.parentConnectionProcessQualifiedNames);
        }
        parentConnectionProcessQualifiedNames = Collections.unmodifiableSortedSet(parentConnectionProcessQualifiedNames);
        this.parentConnectionProcessQualifiedNames = parentConnectionProcessQualifiedNames;
        this.powerBIDataflow = b.powerBIDataflow;
        SortedSet<ISparkJob> sparkJobs = new TreeSet<ISparkJob>();
        if (b.sparkJobs != null) {
            sparkJobs.addAll(b.sparkJobs);
        }
        sparkJobs = Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @Generated
    public static FlowDatasetOperationBuilder<?, ?> _internal() {
        return new FlowDatasetOperationBuilderImpl();
    }

    @Generated
    public FlowDatasetOperationBuilder<?, ?> toBuilder() {
        return new FlowDatasetOperationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    @Override
    @Generated
    public IAdfActivity getAdfActivity() {
        return this.adfActivity;
    }

    @Override
    @Generated
    public AIDatasetType getAiDatasetType() {
        return this.aiDatasetType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public String getAst() {
        return this.ast;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Override
    @Generated
    public IFivetranConnector getFivetranConnector() {
        return this.fivetranConnector;
    }

    @Override
    @Generated
    public String getFlowErrorMessage() {
        return this.flowErrorMessage;
    }

    @Override
    @Generated
    public Long getFlowFinishedAt() {
        return this.flowFinishedAt;
    }

    @Override
    @Generated
    public String getFlowFolderName() {
        return this.flowFolderName;
    }

    @Override
    @Generated
    public String getFlowFolderQualifiedName() {
        return this.flowFolderQualifiedName;
    }

    @Override
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    @Generated
    public IFlowControlOperation getFlowOrchestratedBy() {
        return this.flowOrchestratedBy;
    }

    @Override
    @Generated
    public String getFlowProjectName() {
        return this.flowProjectName;
    }

    @Override
    @Generated
    public String getFlowProjectQualifiedName() {
        return this.flowProjectQualifiedName;
    }

    @Override
    @Generated
    public IFlowReusableUnit getFlowReusableUnit() {
        return this.flowReusableUnit;
    }

    @Override
    @Generated
    public String getFlowReusableUnitName() {
        return this.flowReusableUnitName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitQualifiedName() {
        return this.flowReusableUnitQualifiedName;
    }

    @Override
    @Generated
    public String getFlowRunId() {
        return this.flowRunId;
    }

    @Override
    @Generated
    public String getFlowSchedule() {
        return this.flowSchedule;
    }

    @Override
    @Generated
    public Long getFlowStartedAt() {
        return this.flowStartedAt;
    }

    @Override
    @Generated
    public String getFlowStatus() {
        return this.flowStatus;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public SortedSet<String> getParentConnectionProcessQualifiedNames() {
        return this.parentConnectionProcessQualifiedNames;
    }

    @Override
    @Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowDatasetOperation)) {
            return false;
        }
        FlowDatasetOperation other = (FlowDatasetOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$flowFinishedAt = this.getFlowFinishedAt();
        Long other$flowFinishedAt = other.getFlowFinishedAt();
        if (this$flowFinishedAt == null ? other$flowFinishedAt != null : !((Object)this$flowFinishedAt).equals(other$flowFinishedAt)) {
            return false;
        }
        Long this$flowStartedAt = this.getFlowStartedAt();
        Long other$flowStartedAt = other.getFlowStartedAt();
        if (this$flowStartedAt == null ? other$flowStartedAt != null : !((Object)this$flowStartedAt).equals(other$flowStartedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$additionalEtlContext = this.getAdditionalEtlContext();
        String other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) {
            return false;
        }
        IAdfActivity this$adfActivity = this.getAdfActivity();
        IAdfActivity other$adfActivity = other.getAdfActivity();
        if (this$adfActivity == null ? other$adfActivity != null : !this$adfActivity.equals(other$adfActivity)) {
            return false;
        }
        AIDatasetType this$aiDatasetType = this.getAiDatasetType();
        AIDatasetType other$aiDatasetType = other.getAiDatasetType();
        if (this$aiDatasetType == null ? other$aiDatasetType != null : !this$aiDatasetType.equals(other$aiDatasetType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SortedSet<IColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<IColumnProcess> other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) {
            return false;
        }
        IFivetranConnector this$fivetranConnector = this.getFivetranConnector();
        IFivetranConnector other$fivetranConnector = other.getFivetranConnector();
        if (this$fivetranConnector == null ? other$fivetranConnector != null : !this$fivetranConnector.equals(other$fivetranConnector)) {
            return false;
        }
        String this$flowErrorMessage = this.getFlowErrorMessage();
        String other$flowErrorMessage = other.getFlowErrorMessage();
        if (this$flowErrorMessage == null ? other$flowErrorMessage != null : !this$flowErrorMessage.equals(other$flowErrorMessage)) {
            return false;
        }
        String this$flowFolderName = this.getFlowFolderName();
        String other$flowFolderName = other.getFlowFolderName();
        if (this$flowFolderName == null ? other$flowFolderName != null : !this$flowFolderName.equals(other$flowFolderName)) {
            return false;
        }
        String this$flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        String other$flowFolderQualifiedName = other.getFlowFolderQualifiedName();
        if (this$flowFolderQualifiedName == null ? other$flowFolderQualifiedName != null : !this$flowFolderQualifiedName.equals(other$flowFolderQualifiedName)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        IFlowControlOperation this$flowOrchestratedBy = this.getFlowOrchestratedBy();
        IFlowControlOperation other$flowOrchestratedBy = other.getFlowOrchestratedBy();
        if (this$flowOrchestratedBy == null ? other$flowOrchestratedBy != null : !this$flowOrchestratedBy.equals(other$flowOrchestratedBy)) {
            return false;
        }
        String this$flowProjectName = this.getFlowProjectName();
        String other$flowProjectName = other.getFlowProjectName();
        if (this$flowProjectName == null ? other$flowProjectName != null : !this$flowProjectName.equals(other$flowProjectName)) {
            return false;
        }
        String this$flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        String other$flowProjectQualifiedName = other.getFlowProjectQualifiedName();
        if (this$flowProjectQualifiedName == null ? other$flowProjectQualifiedName != null : !this$flowProjectQualifiedName.equals(other$flowProjectQualifiedName)) {
            return false;
        }
        IFlowReusableUnit this$flowReusableUnit = this.getFlowReusableUnit();
        IFlowReusableUnit other$flowReusableUnit = other.getFlowReusableUnit();
        if (this$flowReusableUnit == null ? other$flowReusableUnit != null : !this$flowReusableUnit.equals(other$flowReusableUnit)) {
            return false;
        }
        String this$flowReusableUnitName = this.getFlowReusableUnitName();
        String other$flowReusableUnitName = other.getFlowReusableUnitName();
        if (this$flowReusableUnitName == null ? other$flowReusableUnitName != null : !this$flowReusableUnitName.equals(other$flowReusableUnitName)) {
            return false;
        }
        String this$flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        String other$flowReusableUnitQualifiedName = other.getFlowReusableUnitQualifiedName();
        if (this$flowReusableUnitQualifiedName == null ? other$flowReusableUnitQualifiedName != null : !this$flowReusableUnitQualifiedName.equals(other$flowReusableUnitQualifiedName)) {
            return false;
        }
        String this$flowRunId = this.getFlowRunId();
        String other$flowRunId = other.getFlowRunId();
        if (this$flowRunId == null ? other$flowRunId != null : !this$flowRunId.equals(other$flowRunId)) {
            return false;
        }
        String this$flowSchedule = this.getFlowSchedule();
        String other$flowSchedule = other.getFlowSchedule();
        if (this$flowSchedule == null ? other$flowSchedule != null : !this$flowSchedule.equals(other$flowSchedule)) {
            return false;
        }
        String this$flowStatus = this.getFlowStatus();
        String other$flowStatus = other.getFlowStatus();
        if (this$flowStatus == null ? other$flowStatus != null : !this$flowStatus.equals(other$flowStatus)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        IMatillionComponent this$matillionComponent = this.getMatillionComponent();
        IMatillionComponent other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        SortedSet<String> this$parentConnectionProcessQualifiedNames = this.getParentConnectionProcessQualifiedNames();
        SortedSet<String> other$parentConnectionProcessQualifiedNames = other.getParentConnectionProcessQualifiedNames();
        if (this$parentConnectionProcessQualifiedNames == null ? other$parentConnectionProcessQualifiedNames != null : !this$parentConnectionProcessQualifiedNames.equals(other$parentConnectionProcessQualifiedNames)) {
            return false;
        }
        IPowerBIDataflow this$powerBIDataflow = this.getPowerBIDataflow();
        IPowerBIDataflow other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) {
            return false;
        }
        SortedSet<ISparkJob> this$sparkJobs = this.getSparkJobs();
        SortedSet<ISparkJob> other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowDatasetOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $flowFinishedAt = this.getFlowFinishedAt();
        result = result * 59 + ($flowFinishedAt == null ? 43 : ((Object)$flowFinishedAt).hashCode());
        Long $flowStartedAt = this.getFlowStartedAt();
        result = result * 59 + ($flowStartedAt == null ? 43 : ((Object)$flowStartedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * 59 + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        IAdfActivity $adfActivity = this.getAdfActivity();
        result = result * 59 + ($adfActivity == null ? 43 : $adfActivity.hashCode());
        AIDatasetType $aiDatasetType = this.getAiDatasetType();
        result = result * 59 + ($aiDatasetType == null ? 43 : $aiDatasetType.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SortedSet<IColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        IFivetranConnector $fivetranConnector = this.getFivetranConnector();
        result = result * 59 + ($fivetranConnector == null ? 43 : $fivetranConnector.hashCode());
        String $flowErrorMessage = this.getFlowErrorMessage();
        result = result * 59 + ($flowErrorMessage == null ? 43 : $flowErrorMessage.hashCode());
        String $flowFolderName = this.getFlowFolderName();
        result = result * 59 + ($flowFolderName == null ? 43 : $flowFolderName.hashCode());
        String $flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        result = result * 59 + ($flowFolderQualifiedName == null ? 43 : $flowFolderQualifiedName.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        IFlowControlOperation $flowOrchestratedBy = this.getFlowOrchestratedBy();
        result = result * 59 + ($flowOrchestratedBy == null ? 43 : $flowOrchestratedBy.hashCode());
        String $flowProjectName = this.getFlowProjectName();
        result = result * 59 + ($flowProjectName == null ? 43 : $flowProjectName.hashCode());
        String $flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        result = result * 59 + ($flowProjectQualifiedName == null ? 43 : $flowProjectQualifiedName.hashCode());
        IFlowReusableUnit $flowReusableUnit = this.getFlowReusableUnit();
        result = result * 59 + ($flowReusableUnit == null ? 43 : $flowReusableUnit.hashCode());
        String $flowReusableUnitName = this.getFlowReusableUnitName();
        result = result * 59 + ($flowReusableUnitName == null ? 43 : $flowReusableUnitName.hashCode());
        String $flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        result = result * 59 + ($flowReusableUnitQualifiedName == null ? 43 : $flowReusableUnitQualifiedName.hashCode());
        String $flowRunId = this.getFlowRunId();
        result = result * 59 + ($flowRunId == null ? 43 : $flowRunId.hashCode());
        String $flowSchedule = this.getFlowSchedule();
        result = result * 59 + ($flowSchedule == null ? 43 : $flowSchedule.hashCode());
        String $flowStatus = this.getFlowStatus();
        result = result * 59 + ($flowStatus == null ? 43 : $flowStatus.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        IMatillionComponent $matillionComponent = this.getMatillionComponent();
        result = result * 59 + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        SortedSet<String> $parentConnectionProcessQualifiedNames = this.getParentConnectionProcessQualifiedNames();
        result = result * 59 + ($parentConnectionProcessQualifiedNames == null ? 43 : $parentConnectionProcessQualifiedNames.hashCode());
        IPowerBIDataflow $powerBIDataflow = this.getPowerBIDataflow();
        result = result * 59 + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        SortedSet<ISparkJob> $sparkJobs = this.getSparkJobs();
        result = result * 59 + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FlowDatasetOperation(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", adfActivity=" + String.valueOf(this.getAdfActivity()) + ", aiDatasetType=" + String.valueOf(this.getAiDatasetType()) + ", airflowTasks=" + String.valueOf(this.getAirflowTasks()) + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + String.valueOf(this.getColumnProcesses()) + ", fivetranConnector=" + String.valueOf(this.getFivetranConnector()) + ", flowErrorMessage=" + this.getFlowErrorMessage() + ", flowFinishedAt=" + this.getFlowFinishedAt() + ", flowFolderName=" + this.getFlowFolderName() + ", flowFolderQualifiedName=" + this.getFlowFolderQualifiedName() + ", flowId=" + this.getFlowId() + ", flowOrchestratedBy=" + String.valueOf(this.getFlowOrchestratedBy()) + ", flowProjectName=" + this.getFlowProjectName() + ", flowProjectQualifiedName=" + this.getFlowProjectQualifiedName() + ", flowReusableUnit=" + String.valueOf(this.getFlowReusableUnit()) + ", flowReusableUnitName=" + this.getFlowReusableUnitName() + ", flowReusableUnitQualifiedName=" + this.getFlowReusableUnitQualifiedName() + ", flowRunId=" + this.getFlowRunId() + ", flowSchedule=" + this.getFlowSchedule() + ", flowStartedAt=" + this.getFlowStartedAt() + ", flowStatus=" + this.getFlowStatus() + ", inputs=" + String.valueOf(this.getInputs()) + ", matillionComponent=" + String.valueOf(this.getMatillionComponent()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", parentConnectionProcessQualifiedNames=" + String.valueOf(this.getParentConnectionProcessQualifiedNames()) + ", powerBIDataflow=" + String.valueOf(this.getPowerBIDataflow()) + ", sparkJobs=" + String.valueOf(this.getSparkJobs()) + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class FlowDatasetOperationBuilder<C extends FlowDatasetOperation, B extends FlowDatasetOperationBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String additionalEtlContext;
        @Generated
        private IAdfActivity adfActivity;
        @Generated
        private AIDatasetType aiDatasetType;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private String ast;
        @Generated
        private String code;
        @Generated
        private ArrayList<IColumnProcess> columnProcesses;
        @Generated
        private IFivetranConnector fivetranConnector;
        @Generated
        private String flowErrorMessage;
        @Generated
        private Long flowFinishedAt;
        @Generated
        private String flowFolderName;
        @Generated
        private String flowFolderQualifiedName;
        @Generated
        private String flowId;
        @Generated
        private IFlowControlOperation flowOrchestratedBy;
        @Generated
        private String flowProjectName;
        @Generated
        private String flowProjectQualifiedName;
        @Generated
        private IFlowReusableUnit flowReusableUnit;
        @Generated
        private String flowReusableUnitName;
        @Generated
        private String flowReusableUnitQualifiedName;
        @Generated
        private String flowRunId;
        @Generated
        private String flowSchedule;
        @Generated
        private Long flowStartedAt;
        @Generated
        private String flowStatus;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private IMatillionComponent matillionComponent;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private ArrayList<String> parentConnectionProcessQualifiedNames;
        @Generated
        private IPowerBIDataflow powerBIDataflow;
        @Generated
        private ArrayList<ISparkJob> sparkJobs;
        @Generated
        private String sql;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowDatasetOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowDatasetOperation instance, FlowDatasetOperationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.adfActivity(instance.adfActivity);
            b.aiDatasetType(instance.aiDatasetType);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
            b.fivetranConnector(instance.fivetranConnector);
            b.flowErrorMessage(instance.flowErrorMessage);
            b.flowFinishedAt(instance.flowFinishedAt);
            b.flowFolderName(instance.flowFolderName);
            b.flowFolderQualifiedName(instance.flowFolderQualifiedName);
            b.flowId(instance.flowId);
            b.flowOrchestratedBy(instance.flowOrchestratedBy);
            b.flowProjectName(instance.flowProjectName);
            b.flowProjectQualifiedName(instance.flowProjectQualifiedName);
            b.flowReusableUnit(instance.flowReusableUnit);
            b.flowReusableUnitName(instance.flowReusableUnitName);
            b.flowReusableUnitQualifiedName(instance.flowReusableUnitQualifiedName);
            b.flowRunId(instance.flowRunId);
            b.flowSchedule(instance.flowSchedule);
            b.flowStartedAt(instance.flowStartedAt);
            b.flowStatus(instance.flowStatus);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.parentConnectionProcessQualifiedNames(instance.parentConnectionProcessQualifiedNames == null ? Collections.emptySortedSet() : instance.parentConnectionProcessQualifiedNames);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.sparkJobs(instance.sparkJobs == null ? Collections.emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalEtlContext(String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return (B)this.self();
        }

        @Generated
        public B adfActivity(IAdfActivity adfActivity) {
            this.adfActivity = adfActivity;
            return (B)this.self();
        }

        @Generated
        public B aiDatasetType(AIDatasetType aiDatasetType) {
            this.aiDatasetType = aiDatasetType;
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B columnProcess(IColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B fivetranConnector(IFivetranConnector fivetranConnector) {
            this.fivetranConnector = fivetranConnector;
            return (B)this.self();
        }

        @Generated
        public B flowErrorMessage(String flowErrorMessage) {
            this.flowErrorMessage = flowErrorMessage;
            return (B)this.self();
        }

        @Generated
        public B flowFinishedAt(Long flowFinishedAt) {
            this.flowFinishedAt = flowFinishedAt;
            return (B)this.self();
        }

        @Generated
        public B flowFolderName(String flowFolderName) {
            this.flowFolderName = flowFolderName;
            return (B)this.self();
        }

        @Generated
        public B flowFolderQualifiedName(String flowFolderQualifiedName) {
            this.flowFolderQualifiedName = flowFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B flowOrchestratedBy(IFlowControlOperation flowOrchestratedBy) {
            this.flowOrchestratedBy = flowOrchestratedBy;
            return (B)this.self();
        }

        @Generated
        public B flowProjectName(String flowProjectName) {
            this.flowProjectName = flowProjectName;
            return (B)this.self();
        }

        @Generated
        public B flowProjectQualifiedName(String flowProjectQualifiedName) {
            this.flowProjectQualifiedName = flowProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnit(IFlowReusableUnit flowReusableUnit) {
            this.flowReusableUnit = flowReusableUnit;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitName(String flowReusableUnitName) {
            this.flowReusableUnitName = flowReusableUnitName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitQualifiedName(String flowReusableUnitQualifiedName) {
            this.flowReusableUnitQualifiedName = flowReusableUnitQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowRunId(String flowRunId) {
            this.flowRunId = flowRunId;
            return (B)this.self();
        }

        @Generated
        public B flowSchedule(String flowSchedule) {
            this.flowSchedule = flowSchedule;
            return (B)this.self();
        }

        @Generated
        public B flowStartedAt(Long flowStartedAt) {
            this.flowStartedAt = flowStartedAt;
            return (B)this.self();
        }

        @Generated
        public B flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponent(IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentConnectionProcessQualifiedName(String parentConnectionProcessQualifiedName) {
            if (this.parentConnectionProcessQualifiedNames == null) {
                this.parentConnectionProcessQualifiedNames = new ArrayList();
            }
            this.parentConnectionProcessQualifiedNames.add(parentConnectionProcessQualifiedName);
            return (B)this.self();
        }

        @JsonProperty(value="parentConnectionProcessQualifiedName")
        @Generated
        public B parentConnectionProcessQualifiedNames(Collection<? extends String> parentConnectionProcessQualifiedNames) {
            if (parentConnectionProcessQualifiedNames == null) {
                throw new NullPointerException("parentConnectionProcessQualifiedNames cannot be null");
            }
            if (this.parentConnectionProcessQualifiedNames == null) {
                this.parentConnectionProcessQualifiedNames = new ArrayList();
            }
            this.parentConnectionProcessQualifiedNames.addAll(parentConnectionProcessQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearParentConnectionProcessQualifiedNames() {
            if (this.parentConnectionProcessQualifiedNames != null) {
                this.parentConnectionProcessQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflow(IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return (B)this.self();
        }

        @Generated
        public B sparkJob(ISparkJob sparkJob) {
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.add(sparkJob);
            return (B)this.self();
        }

        @Generated
        public B sparkJobs(Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.addAll(sparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) {
                this.sparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowDatasetOperation.FlowDatasetOperationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", adfActivity=" + String.valueOf(this.adfActivity) + ", aiDatasetType=" + String.valueOf(this.aiDatasetType) + ", airflowTasks=" + String.valueOf(this.airflowTasks) + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + String.valueOf(this.columnProcesses) + ", fivetranConnector=" + String.valueOf(this.fivetranConnector) + ", flowErrorMessage=" + this.flowErrorMessage + ", flowFinishedAt=" + this.flowFinishedAt + ", flowFolderName=" + this.flowFolderName + ", flowFolderQualifiedName=" + this.flowFolderQualifiedName + ", flowId=" + this.flowId + ", flowOrchestratedBy=" + String.valueOf(this.flowOrchestratedBy) + ", flowProjectName=" + this.flowProjectName + ", flowProjectQualifiedName=" + this.flowProjectQualifiedName + ", flowReusableUnit=" + String.valueOf(this.flowReusableUnit) + ", flowReusableUnitName=" + this.flowReusableUnitName + ", flowReusableUnitQualifiedName=" + this.flowReusableUnitQualifiedName + ", flowRunId=" + this.flowRunId + ", flowSchedule=" + this.flowSchedule + ", flowStartedAt=" + this.flowStartedAt + ", flowStatus=" + this.flowStatus + ", inputs=" + String.valueOf(this.inputs) + ", matillionComponent=" + String.valueOf(this.matillionComponent) + ", outputs=" + String.valueOf(this.outputs) + ", parentConnectionProcessQualifiedNames=" + String.valueOf(this.parentConnectionProcessQualifiedNames) + ", powerBIDataflow=" + String.valueOf(this.powerBIDataflow) + ", sparkJobs=" + String.valueOf(this.sparkJobs) + ", sql=" + this.sql + ")";
        }
    }

    @Generated
    private static final class FlowDatasetOperationBuilderImpl
    extends FlowDatasetOperationBuilder<FlowDatasetOperation, FlowDatasetOperationBuilderImpl> {
        @Generated
        private FlowDatasetOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowDatasetOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowDatasetOperation build() {
            return new FlowDatasetOperation(this);
        }
    }
}

