/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IFlow;
import com.atlan.model.assets.IFlowFolder;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFolder
extends Asset
implements IFlowFolder,
IFlow,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "FlowFolder";
    String typeName;
    @Attribute
    String flowErrorMessage;
    @Attribute
    @Date
    Long flowFinishedAt;
    @Attribute
    String flowFolderName;
    @Attribute
    String flowFolderQualifiedName;
    @Attribute
    String flowId;
    @Attribute
    IFlowFolder flowParentFolder;
    @Attribute
    String flowProjectName;
    @Attribute
    String flowProjectQualifiedName;
    @Attribute
    String flowReusableUnitName;
    @Attribute
    String flowReusableUnitQualifiedName;
    @Attribute
    String flowRunId;
    @Attribute
    String flowSchedule;
    @Attribute
    @Date
    Long flowStartedAt;
    @Attribute
    String flowStatus;
    @Attribute
    SortedSet<IFlowFolder> flowSubFolders;

    @Override
    public FlowFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return FlowFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return FlowFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return FlowFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return FlowFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static FlowFolder refByGuid(String guid) {
        return FlowFolder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static FlowFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FlowFolderBuilder)((FlowFolderBuilder)FlowFolder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static FlowFolder refByQualifiedName(String qualifiedName) {
        return FlowFolder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static FlowFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FlowFolderBuilder)((FlowFolderBuilder)FlowFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static FlowFolder get(AtlanClient client, String id) throws AtlanException {
        return FlowFolder.get(client, id, false);
    }

    @JsonIgnore
    public static FlowFolder get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof FlowFolder) {
                return (FlowFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof FlowFolder) {
            return (FlowFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static FlowFolder get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return FlowFolder.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static FlowFolder get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowFolder.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof FlowFolder) {
                return (FlowFolder)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowFolder.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof FlowFolder) {
            return (FlowFolder)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FlowFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FlowFolderBuilder)((FlowFolderBuilder)((FlowFolderBuilder)FlowFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FlowFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        FlowFolder.validateRequired(TYPE_NAME, map);
        return FlowFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static FlowFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowFolder)Asset.removeDescription(client, FlowFolder.updater(qualifiedName, name));
    }

    public static FlowFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowFolder)Asset.removeUserDescription(client, FlowFolder.updater(qualifiedName, name));
    }

    public static FlowFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowFolder)Asset.removeOwners(client, FlowFolder.updater(qualifiedName, name));
    }

    public static FlowFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (FlowFolder)Asset.updateCertificate(client, FlowFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static FlowFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowFolder)Asset.removeCertificate(client, FlowFolder.updater(qualifiedName, name));
    }

    public static FlowFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (FlowFolder)Asset.updateAnnouncement(client, FlowFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static FlowFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowFolder)Asset.removeAnnouncement(client, FlowFolder.updater(qualifiedName, name));
    }

    public static FlowFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowFolder)Asset.replaceTerms(client, FlowFolder.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static FlowFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (FlowFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static FlowFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (FlowFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected FlowFolder(FlowFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : FlowFolder.$default$typeName();
        this.flowErrorMessage = b.flowErrorMessage;
        this.flowFinishedAt = b.flowFinishedAt;
        this.flowFolderName = b.flowFolderName;
        this.flowFolderQualifiedName = b.flowFolderQualifiedName;
        this.flowId = b.flowId;
        this.flowParentFolder = b.flowParentFolder;
        this.flowProjectName = b.flowProjectName;
        this.flowProjectQualifiedName = b.flowProjectQualifiedName;
        this.flowReusableUnitName = b.flowReusableUnitName;
        this.flowReusableUnitQualifiedName = b.flowReusableUnitQualifiedName;
        this.flowRunId = b.flowRunId;
        this.flowSchedule = b.flowSchedule;
        this.flowStartedAt = b.flowStartedAt;
        this.flowStatus = b.flowStatus;
        SortedSet<IFlowFolder> flowSubFolders = new TreeSet<IFlowFolder>();
        if (b.flowSubFolders != null) {
            flowSubFolders.addAll(b.flowSubFolders);
        }
        flowSubFolders = Collections.unmodifiableSortedSet(flowSubFolders);
        this.flowSubFolders = flowSubFolders;
    }

    @Generated
    public static FlowFolderBuilder<?, ?> _internal() {
        return new FlowFolderBuilderImpl();
    }

    @Generated
    public FlowFolderBuilder<?, ?> toBuilder() {
        return new FlowFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getFlowErrorMessage() {
        return this.flowErrorMessage;
    }

    @Override
    @Generated
    public Long getFlowFinishedAt() {
        return this.flowFinishedAt;
    }

    @Override
    @Generated
    public String getFlowFolderName() {
        return this.flowFolderName;
    }

    @Override
    @Generated
    public String getFlowFolderQualifiedName() {
        return this.flowFolderQualifiedName;
    }

    @Override
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    @Generated
    public IFlowFolder getFlowParentFolder() {
        return this.flowParentFolder;
    }

    @Override
    @Generated
    public String getFlowProjectName() {
        return this.flowProjectName;
    }

    @Override
    @Generated
    public String getFlowProjectQualifiedName() {
        return this.flowProjectQualifiedName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitName() {
        return this.flowReusableUnitName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitQualifiedName() {
        return this.flowReusableUnitQualifiedName;
    }

    @Override
    @Generated
    public String getFlowRunId() {
        return this.flowRunId;
    }

    @Override
    @Generated
    public String getFlowSchedule() {
        return this.flowSchedule;
    }

    @Override
    @Generated
    public Long getFlowStartedAt() {
        return this.flowStartedAt;
    }

    @Override
    @Generated
    public String getFlowStatus() {
        return this.flowStatus;
    }

    @Override
    @Generated
    public SortedSet<IFlowFolder> getFlowSubFolders() {
        return this.flowSubFolders;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowFolder)) {
            return false;
        }
        FlowFolder other = (FlowFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$flowFinishedAt = this.getFlowFinishedAt();
        Long other$flowFinishedAt = other.getFlowFinishedAt();
        if (this$flowFinishedAt == null ? other$flowFinishedAt != null : !((Object)this$flowFinishedAt).equals(other$flowFinishedAt)) {
            return false;
        }
        Long this$flowStartedAt = this.getFlowStartedAt();
        Long other$flowStartedAt = other.getFlowStartedAt();
        if (this$flowStartedAt == null ? other$flowStartedAt != null : !((Object)this$flowStartedAt).equals(other$flowStartedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$flowErrorMessage = this.getFlowErrorMessage();
        String other$flowErrorMessage = other.getFlowErrorMessage();
        if (this$flowErrorMessage == null ? other$flowErrorMessage != null : !this$flowErrorMessage.equals(other$flowErrorMessage)) {
            return false;
        }
        String this$flowFolderName = this.getFlowFolderName();
        String other$flowFolderName = other.getFlowFolderName();
        if (this$flowFolderName == null ? other$flowFolderName != null : !this$flowFolderName.equals(other$flowFolderName)) {
            return false;
        }
        String this$flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        String other$flowFolderQualifiedName = other.getFlowFolderQualifiedName();
        if (this$flowFolderQualifiedName == null ? other$flowFolderQualifiedName != null : !this$flowFolderQualifiedName.equals(other$flowFolderQualifiedName)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        IFlowFolder this$flowParentFolder = this.getFlowParentFolder();
        IFlowFolder other$flowParentFolder = other.getFlowParentFolder();
        if (this$flowParentFolder == null ? other$flowParentFolder != null : !this$flowParentFolder.equals(other$flowParentFolder)) {
            return false;
        }
        String this$flowProjectName = this.getFlowProjectName();
        String other$flowProjectName = other.getFlowProjectName();
        if (this$flowProjectName == null ? other$flowProjectName != null : !this$flowProjectName.equals(other$flowProjectName)) {
            return false;
        }
        String this$flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        String other$flowProjectQualifiedName = other.getFlowProjectQualifiedName();
        if (this$flowProjectQualifiedName == null ? other$flowProjectQualifiedName != null : !this$flowProjectQualifiedName.equals(other$flowProjectQualifiedName)) {
            return false;
        }
        String this$flowReusableUnitName = this.getFlowReusableUnitName();
        String other$flowReusableUnitName = other.getFlowReusableUnitName();
        if (this$flowReusableUnitName == null ? other$flowReusableUnitName != null : !this$flowReusableUnitName.equals(other$flowReusableUnitName)) {
            return false;
        }
        String this$flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        String other$flowReusableUnitQualifiedName = other.getFlowReusableUnitQualifiedName();
        if (this$flowReusableUnitQualifiedName == null ? other$flowReusableUnitQualifiedName != null : !this$flowReusableUnitQualifiedName.equals(other$flowReusableUnitQualifiedName)) {
            return false;
        }
        String this$flowRunId = this.getFlowRunId();
        String other$flowRunId = other.getFlowRunId();
        if (this$flowRunId == null ? other$flowRunId != null : !this$flowRunId.equals(other$flowRunId)) {
            return false;
        }
        String this$flowSchedule = this.getFlowSchedule();
        String other$flowSchedule = other.getFlowSchedule();
        if (this$flowSchedule == null ? other$flowSchedule != null : !this$flowSchedule.equals(other$flowSchedule)) {
            return false;
        }
        String this$flowStatus = this.getFlowStatus();
        String other$flowStatus = other.getFlowStatus();
        if (this$flowStatus == null ? other$flowStatus != null : !this$flowStatus.equals(other$flowStatus)) {
            return false;
        }
        SortedSet<IFlowFolder> this$flowSubFolders = this.getFlowSubFolders();
        SortedSet<IFlowFolder> other$flowSubFolders = other.getFlowSubFolders();
        return !(this$flowSubFolders == null ? other$flowSubFolders != null : !this$flowSubFolders.equals(other$flowSubFolders));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $flowFinishedAt = this.getFlowFinishedAt();
        result = result * 59 + ($flowFinishedAt == null ? 43 : ((Object)$flowFinishedAt).hashCode());
        Long $flowStartedAt = this.getFlowStartedAt();
        result = result * 59 + ($flowStartedAt == null ? 43 : ((Object)$flowStartedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $flowErrorMessage = this.getFlowErrorMessage();
        result = result * 59 + ($flowErrorMessage == null ? 43 : $flowErrorMessage.hashCode());
        String $flowFolderName = this.getFlowFolderName();
        result = result * 59 + ($flowFolderName == null ? 43 : $flowFolderName.hashCode());
        String $flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        result = result * 59 + ($flowFolderQualifiedName == null ? 43 : $flowFolderQualifiedName.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        IFlowFolder $flowParentFolder = this.getFlowParentFolder();
        result = result * 59 + ($flowParentFolder == null ? 43 : $flowParentFolder.hashCode());
        String $flowProjectName = this.getFlowProjectName();
        result = result * 59 + ($flowProjectName == null ? 43 : $flowProjectName.hashCode());
        String $flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        result = result * 59 + ($flowProjectQualifiedName == null ? 43 : $flowProjectQualifiedName.hashCode());
        String $flowReusableUnitName = this.getFlowReusableUnitName();
        result = result * 59 + ($flowReusableUnitName == null ? 43 : $flowReusableUnitName.hashCode());
        String $flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        result = result * 59 + ($flowReusableUnitQualifiedName == null ? 43 : $flowReusableUnitQualifiedName.hashCode());
        String $flowRunId = this.getFlowRunId();
        result = result * 59 + ($flowRunId == null ? 43 : $flowRunId.hashCode());
        String $flowSchedule = this.getFlowSchedule();
        result = result * 59 + ($flowSchedule == null ? 43 : $flowSchedule.hashCode());
        String $flowStatus = this.getFlowStatus();
        result = result * 59 + ($flowStatus == null ? 43 : $flowStatus.hashCode());
        SortedSet<IFlowFolder> $flowSubFolders = this.getFlowSubFolders();
        result = result * 59 + ($flowSubFolders == null ? 43 : $flowSubFolders.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FlowFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", flowErrorMessage=" + this.getFlowErrorMessage() + ", flowFinishedAt=" + this.getFlowFinishedAt() + ", flowFolderName=" + this.getFlowFolderName() + ", flowFolderQualifiedName=" + this.getFlowFolderQualifiedName() + ", flowId=" + this.getFlowId() + ", flowParentFolder=" + String.valueOf(this.getFlowParentFolder()) + ", flowProjectName=" + this.getFlowProjectName() + ", flowProjectQualifiedName=" + this.getFlowProjectQualifiedName() + ", flowReusableUnitName=" + this.getFlowReusableUnitName() + ", flowReusableUnitQualifiedName=" + this.getFlowReusableUnitQualifiedName() + ", flowRunId=" + this.getFlowRunId() + ", flowSchedule=" + this.getFlowSchedule() + ", flowStartedAt=" + this.getFlowStartedAt() + ", flowStatus=" + this.getFlowStatus() + ", flowSubFolders=" + String.valueOf(this.getFlowSubFolders()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class FlowFolderBuilder<C extends FlowFolder, B extends FlowFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String flowErrorMessage;
        @Generated
        private Long flowFinishedAt;
        @Generated
        private String flowFolderName;
        @Generated
        private String flowFolderQualifiedName;
        @Generated
        private String flowId;
        @Generated
        private IFlowFolder flowParentFolder;
        @Generated
        private String flowProjectName;
        @Generated
        private String flowProjectQualifiedName;
        @Generated
        private String flowReusableUnitName;
        @Generated
        private String flowReusableUnitQualifiedName;
        @Generated
        private String flowRunId;
        @Generated
        private String flowSchedule;
        @Generated
        private Long flowStartedAt;
        @Generated
        private String flowStatus;
        @Generated
        private ArrayList<IFlowFolder> flowSubFolders;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowFolder instance, FlowFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.flowErrorMessage(instance.flowErrorMessage);
            b.flowFinishedAt(instance.flowFinishedAt);
            b.flowFolderName(instance.flowFolderName);
            b.flowFolderQualifiedName(instance.flowFolderQualifiedName);
            b.flowId(instance.flowId);
            b.flowParentFolder(instance.flowParentFolder);
            b.flowProjectName(instance.flowProjectName);
            b.flowProjectQualifiedName(instance.flowProjectQualifiedName);
            b.flowReusableUnitName(instance.flowReusableUnitName);
            b.flowReusableUnitQualifiedName(instance.flowReusableUnitQualifiedName);
            b.flowRunId(instance.flowRunId);
            b.flowSchedule(instance.flowSchedule);
            b.flowStartedAt(instance.flowStartedAt);
            b.flowStatus(instance.flowStatus);
            b.flowSubFolders(instance.flowSubFolders == null ? Collections.emptySortedSet() : instance.flowSubFolders);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B flowErrorMessage(String flowErrorMessage) {
            this.flowErrorMessage = flowErrorMessage;
            return (B)this.self();
        }

        @Generated
        public B flowFinishedAt(Long flowFinishedAt) {
            this.flowFinishedAt = flowFinishedAt;
            return (B)this.self();
        }

        @Generated
        public B flowFolderName(String flowFolderName) {
            this.flowFolderName = flowFolderName;
            return (B)this.self();
        }

        @Generated
        public B flowFolderQualifiedName(String flowFolderQualifiedName) {
            this.flowFolderQualifiedName = flowFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B flowParentFolder(IFlowFolder flowParentFolder) {
            this.flowParentFolder = flowParentFolder;
            return (B)this.self();
        }

        @Generated
        public B flowProjectName(String flowProjectName) {
            this.flowProjectName = flowProjectName;
            return (B)this.self();
        }

        @Generated
        public B flowProjectQualifiedName(String flowProjectQualifiedName) {
            this.flowProjectQualifiedName = flowProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitName(String flowReusableUnitName) {
            this.flowReusableUnitName = flowReusableUnitName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitQualifiedName(String flowReusableUnitQualifiedName) {
            this.flowReusableUnitQualifiedName = flowReusableUnitQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowRunId(String flowRunId) {
            this.flowRunId = flowRunId;
            return (B)this.self();
        }

        @Generated
        public B flowSchedule(String flowSchedule) {
            this.flowSchedule = flowSchedule;
            return (B)this.self();
        }

        @Generated
        public B flowStartedAt(Long flowStartedAt) {
            this.flowStartedAt = flowStartedAt;
            return (B)this.self();
        }

        @Generated
        public B flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return (B)this.self();
        }

        @Generated
        public B flowSubFolder(IFlowFolder flowSubFolder) {
            if (this.flowSubFolders == null) {
                this.flowSubFolders = new ArrayList();
            }
            this.flowSubFolders.add(flowSubFolder);
            return (B)this.self();
        }

        @Generated
        public B flowSubFolders(Collection<? extends IFlowFolder> flowSubFolders) {
            if (flowSubFolders == null) {
                throw new NullPointerException("flowSubFolders cannot be null");
            }
            if (this.flowSubFolders == null) {
                this.flowSubFolders = new ArrayList();
            }
            this.flowSubFolders.addAll(flowSubFolders);
            return (B)this.self();
        }

        @Generated
        public B clearFlowSubFolders() {
            if (this.flowSubFolders != null) {
                this.flowSubFolders.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowFolder.FlowFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", flowErrorMessage=" + this.flowErrorMessage + ", flowFinishedAt=" + this.flowFinishedAt + ", flowFolderName=" + this.flowFolderName + ", flowFolderQualifiedName=" + this.flowFolderQualifiedName + ", flowId=" + this.flowId + ", flowParentFolder=" + String.valueOf(this.flowParentFolder) + ", flowProjectName=" + this.flowProjectName + ", flowProjectQualifiedName=" + this.flowProjectQualifiedName + ", flowReusableUnitName=" + this.flowReusableUnitName + ", flowReusableUnitQualifiedName=" + this.flowReusableUnitQualifiedName + ", flowRunId=" + this.flowRunId + ", flowSchedule=" + this.flowSchedule + ", flowStartedAt=" + this.flowStartedAt + ", flowStatus=" + this.flowStatus + ", flowSubFolders=" + String.valueOf(this.flowSubFolders) + ")";
        }
    }

    @Generated
    private static final class FlowFolderBuilderImpl
    extends FlowFolderBuilder<FlowFolder, FlowFolderBuilderImpl> {
        @Generated
        private FlowFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowFolder build() {
            return new FlowFolder(this);
        }
    }
}

