/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IFlow;
import com.atlan.model.assets.IFlowDataset;
import com.atlan.model.assets.IFlowDatasetOperation;
import com.atlan.model.assets.IFlowReusableUnit;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowReusableUnit
extends Asset
implements IFlowReusableUnit,
IFlow,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowReusableUnit.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "FlowReusableUnit";
    String typeName;
    @Attribute
    SortedSet<IFlowDataset> flowAbstracts;
    @Attribute
    Long flowControlOperationCount;
    @Attribute
    SortedSet<IFlowDatasetOperation> flowDataFlows;
    @Attribute
    Long flowDatasetCount;
    @Attribute
    SortedSet<IFlowDataset> flowDatasets;
    @Attribute
    String flowErrorMessage;
    @Attribute
    @Date
    Long flowFinishedAt;
    @Attribute
    String flowFolderName;
    @Attribute
    String flowFolderQualifiedName;
    @Attribute
    String flowId;
    @Attribute
    String flowProjectName;
    @Attribute
    String flowProjectQualifiedName;
    @Attribute
    String flowReusableUnitName;
    @Attribute
    String flowReusableUnitQualifiedName;
    @Attribute
    String flowRunId;
    @Attribute
    String flowSchedule;
    @Attribute
    @Date
    Long flowStartedAt;
    @Attribute
    String flowStatus;

    @Override
    public FlowReusableUnit trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return FlowReusableUnit.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return FlowReusableUnit.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return FlowReusableUnit.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return FlowReusableUnit.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static FlowReusableUnit refByGuid(String guid) {
        return FlowReusableUnit.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static FlowReusableUnit refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((FlowReusableUnitBuilder)((FlowReusableUnitBuilder)FlowReusableUnit._internal().guid(guid)).semantic(semantic)).build();
    }

    public static FlowReusableUnit refByQualifiedName(String qualifiedName) {
        return FlowReusableUnit.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static FlowReusableUnit refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((FlowReusableUnitBuilder)((FlowReusableUnitBuilder)FlowReusableUnit._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static FlowReusableUnit get(AtlanClient client, String id) throws AtlanException {
        return FlowReusableUnit.get(client, id, false);
    }

    @JsonIgnore
    public static FlowReusableUnit get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof FlowReusableUnit) {
                return (FlowReusableUnit)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof FlowReusableUnit) {
            return (FlowReusableUnit)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static FlowReusableUnit get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return FlowReusableUnit.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static FlowReusableUnit get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowReusableUnit.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof FlowReusableUnit) {
                return (FlowReusableUnit)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)FlowReusableUnit.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof FlowReusableUnit) {
            return (FlowReusableUnit)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static FlowReusableUnitBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FlowReusableUnitBuilder)((FlowReusableUnitBuilder)((FlowReusableUnitBuilder)FlowReusableUnit._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public FlowReusableUnitBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        FlowReusableUnit.validateRequired(TYPE_NAME, map);
        return FlowReusableUnit.updater(this.getQualifiedName(), this.getName());
    }

    public static FlowReusableUnit removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowReusableUnit)Asset.removeDescription(client, FlowReusableUnit.updater(qualifiedName, name));
    }

    public static FlowReusableUnit removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowReusableUnit)Asset.removeUserDescription(client, FlowReusableUnit.updater(qualifiedName, name));
    }

    public static FlowReusableUnit removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowReusableUnit)Asset.removeOwners(client, FlowReusableUnit.updater(qualifiedName, name));
    }

    public static FlowReusableUnit updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (FlowReusableUnit)Asset.updateCertificate(client, FlowReusableUnit._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static FlowReusableUnit removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowReusableUnit)Asset.removeCertificate(client, FlowReusableUnit.updater(qualifiedName, name));
    }

    public static FlowReusableUnit updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (FlowReusableUnit)Asset.updateAnnouncement(client, FlowReusableUnit._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static FlowReusableUnit removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (FlowReusableUnit)Asset.removeAnnouncement(client, FlowReusableUnit.updater(qualifiedName, name));
    }

    public static FlowReusableUnit replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowReusableUnit)Asset.replaceTerms(client, FlowReusableUnit.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static FlowReusableUnit appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowReusableUnit)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowReusableUnit removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (FlowReusableUnit)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static FlowReusableUnit appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (FlowReusableUnit)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static FlowReusableUnit appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (FlowReusableUnit)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected FlowReusableUnit(FlowReusableUnitBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : FlowReusableUnit.$default$typeName();
        SortedSet<IFlowDataset> flowAbstracts = new TreeSet<IFlowDataset>();
        if (b.flowAbstracts != null) {
            flowAbstracts.addAll(b.flowAbstracts);
        }
        flowAbstracts = Collections.unmodifiableSortedSet(flowAbstracts);
        this.flowAbstracts = flowAbstracts;
        this.flowControlOperationCount = b.flowControlOperationCount;
        SortedSet<IFlowDatasetOperation> flowDataFlows = new TreeSet<IFlowDatasetOperation>();
        if (b.flowDataFlows != null) {
            flowDataFlows.addAll(b.flowDataFlows);
        }
        flowDataFlows = Collections.unmodifiableSortedSet(flowDataFlows);
        this.flowDataFlows = flowDataFlows;
        this.flowDatasetCount = b.flowDatasetCount;
        SortedSet<IFlowDataset> flowDatasets = new TreeSet<IFlowDataset>();
        if (b.flowDatasets != null) {
            flowDatasets.addAll(b.flowDatasets);
        }
        flowDatasets = Collections.unmodifiableSortedSet(flowDatasets);
        this.flowDatasets = flowDatasets;
        this.flowErrorMessage = b.flowErrorMessage;
        this.flowFinishedAt = b.flowFinishedAt;
        this.flowFolderName = b.flowFolderName;
        this.flowFolderQualifiedName = b.flowFolderQualifiedName;
        this.flowId = b.flowId;
        this.flowProjectName = b.flowProjectName;
        this.flowProjectQualifiedName = b.flowProjectQualifiedName;
        this.flowReusableUnitName = b.flowReusableUnitName;
        this.flowReusableUnitQualifiedName = b.flowReusableUnitQualifiedName;
        this.flowRunId = b.flowRunId;
        this.flowSchedule = b.flowSchedule;
        this.flowStartedAt = b.flowStartedAt;
        this.flowStatus = b.flowStatus;
    }

    @Generated
    public static FlowReusableUnitBuilder<?, ?> _internal() {
        return new FlowReusableUnitBuilderImpl();
    }

    @Generated
    public FlowReusableUnitBuilder<?, ?> toBuilder() {
        return new FlowReusableUnitBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IFlowDataset> getFlowAbstracts() {
        return this.flowAbstracts;
    }

    @Override
    @Generated
    public Long getFlowControlOperationCount() {
        return this.flowControlOperationCount;
    }

    @Override
    @Generated
    public SortedSet<IFlowDatasetOperation> getFlowDataFlows() {
        return this.flowDataFlows;
    }

    @Override
    @Generated
    public Long getFlowDatasetCount() {
        return this.flowDatasetCount;
    }

    @Override
    @Generated
    public SortedSet<IFlowDataset> getFlowDatasets() {
        return this.flowDatasets;
    }

    @Override
    @Generated
    public String getFlowErrorMessage() {
        return this.flowErrorMessage;
    }

    @Override
    @Generated
    public Long getFlowFinishedAt() {
        return this.flowFinishedAt;
    }

    @Override
    @Generated
    public String getFlowFolderName() {
        return this.flowFolderName;
    }

    @Override
    @Generated
    public String getFlowFolderQualifiedName() {
        return this.flowFolderQualifiedName;
    }

    @Override
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    @Generated
    public String getFlowProjectName() {
        return this.flowProjectName;
    }

    @Override
    @Generated
    public String getFlowProjectQualifiedName() {
        return this.flowProjectQualifiedName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitName() {
        return this.flowReusableUnitName;
    }

    @Override
    @Generated
    public String getFlowReusableUnitQualifiedName() {
        return this.flowReusableUnitQualifiedName;
    }

    @Override
    @Generated
    public String getFlowRunId() {
        return this.flowRunId;
    }

    @Override
    @Generated
    public String getFlowSchedule() {
        return this.flowSchedule;
    }

    @Override
    @Generated
    public Long getFlowStartedAt() {
        return this.flowStartedAt;
    }

    @Override
    @Generated
    public String getFlowStatus() {
        return this.flowStatus;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowReusableUnit)) {
            return false;
        }
        FlowReusableUnit other = (FlowReusableUnit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$flowControlOperationCount = this.getFlowControlOperationCount();
        Long other$flowControlOperationCount = other.getFlowControlOperationCount();
        if (this$flowControlOperationCount == null ? other$flowControlOperationCount != null : !((Object)this$flowControlOperationCount).equals(other$flowControlOperationCount)) {
            return false;
        }
        Long this$flowDatasetCount = this.getFlowDatasetCount();
        Long other$flowDatasetCount = other.getFlowDatasetCount();
        if (this$flowDatasetCount == null ? other$flowDatasetCount != null : !((Object)this$flowDatasetCount).equals(other$flowDatasetCount)) {
            return false;
        }
        Long this$flowFinishedAt = this.getFlowFinishedAt();
        Long other$flowFinishedAt = other.getFlowFinishedAt();
        if (this$flowFinishedAt == null ? other$flowFinishedAt != null : !((Object)this$flowFinishedAt).equals(other$flowFinishedAt)) {
            return false;
        }
        Long this$flowStartedAt = this.getFlowStartedAt();
        Long other$flowStartedAt = other.getFlowStartedAt();
        if (this$flowStartedAt == null ? other$flowStartedAt != null : !((Object)this$flowStartedAt).equals(other$flowStartedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IFlowDataset> this$flowAbstracts = this.getFlowAbstracts();
        SortedSet<IFlowDataset> other$flowAbstracts = other.getFlowAbstracts();
        if (this$flowAbstracts == null ? other$flowAbstracts != null : !this$flowAbstracts.equals(other$flowAbstracts)) {
            return false;
        }
        SortedSet<IFlowDatasetOperation> this$flowDataFlows = this.getFlowDataFlows();
        SortedSet<IFlowDatasetOperation> other$flowDataFlows = other.getFlowDataFlows();
        if (this$flowDataFlows == null ? other$flowDataFlows != null : !this$flowDataFlows.equals(other$flowDataFlows)) {
            return false;
        }
        SortedSet<IFlowDataset> this$flowDatasets = this.getFlowDatasets();
        SortedSet<IFlowDataset> other$flowDatasets = other.getFlowDatasets();
        if (this$flowDatasets == null ? other$flowDatasets != null : !this$flowDatasets.equals(other$flowDatasets)) {
            return false;
        }
        String this$flowErrorMessage = this.getFlowErrorMessage();
        String other$flowErrorMessage = other.getFlowErrorMessage();
        if (this$flowErrorMessage == null ? other$flowErrorMessage != null : !this$flowErrorMessage.equals(other$flowErrorMessage)) {
            return false;
        }
        String this$flowFolderName = this.getFlowFolderName();
        String other$flowFolderName = other.getFlowFolderName();
        if (this$flowFolderName == null ? other$flowFolderName != null : !this$flowFolderName.equals(other$flowFolderName)) {
            return false;
        }
        String this$flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        String other$flowFolderQualifiedName = other.getFlowFolderQualifiedName();
        if (this$flowFolderQualifiedName == null ? other$flowFolderQualifiedName != null : !this$flowFolderQualifiedName.equals(other$flowFolderQualifiedName)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$flowProjectName = this.getFlowProjectName();
        String other$flowProjectName = other.getFlowProjectName();
        if (this$flowProjectName == null ? other$flowProjectName != null : !this$flowProjectName.equals(other$flowProjectName)) {
            return false;
        }
        String this$flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        String other$flowProjectQualifiedName = other.getFlowProjectQualifiedName();
        if (this$flowProjectQualifiedName == null ? other$flowProjectQualifiedName != null : !this$flowProjectQualifiedName.equals(other$flowProjectQualifiedName)) {
            return false;
        }
        String this$flowReusableUnitName = this.getFlowReusableUnitName();
        String other$flowReusableUnitName = other.getFlowReusableUnitName();
        if (this$flowReusableUnitName == null ? other$flowReusableUnitName != null : !this$flowReusableUnitName.equals(other$flowReusableUnitName)) {
            return false;
        }
        String this$flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        String other$flowReusableUnitQualifiedName = other.getFlowReusableUnitQualifiedName();
        if (this$flowReusableUnitQualifiedName == null ? other$flowReusableUnitQualifiedName != null : !this$flowReusableUnitQualifiedName.equals(other$flowReusableUnitQualifiedName)) {
            return false;
        }
        String this$flowRunId = this.getFlowRunId();
        String other$flowRunId = other.getFlowRunId();
        if (this$flowRunId == null ? other$flowRunId != null : !this$flowRunId.equals(other$flowRunId)) {
            return false;
        }
        String this$flowSchedule = this.getFlowSchedule();
        String other$flowSchedule = other.getFlowSchedule();
        if (this$flowSchedule == null ? other$flowSchedule != null : !this$flowSchedule.equals(other$flowSchedule)) {
            return false;
        }
        String this$flowStatus = this.getFlowStatus();
        String other$flowStatus = other.getFlowStatus();
        return !(this$flowStatus == null ? other$flowStatus != null : !this$flowStatus.equals(other$flowStatus));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowReusableUnit;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $flowControlOperationCount = this.getFlowControlOperationCount();
        result = result * 59 + ($flowControlOperationCount == null ? 43 : ((Object)$flowControlOperationCount).hashCode());
        Long $flowDatasetCount = this.getFlowDatasetCount();
        result = result * 59 + ($flowDatasetCount == null ? 43 : ((Object)$flowDatasetCount).hashCode());
        Long $flowFinishedAt = this.getFlowFinishedAt();
        result = result * 59 + ($flowFinishedAt == null ? 43 : ((Object)$flowFinishedAt).hashCode());
        Long $flowStartedAt = this.getFlowStartedAt();
        result = result * 59 + ($flowStartedAt == null ? 43 : ((Object)$flowStartedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IFlowDataset> $flowAbstracts = this.getFlowAbstracts();
        result = result * 59 + ($flowAbstracts == null ? 43 : $flowAbstracts.hashCode());
        SortedSet<IFlowDatasetOperation> $flowDataFlows = this.getFlowDataFlows();
        result = result * 59 + ($flowDataFlows == null ? 43 : $flowDataFlows.hashCode());
        SortedSet<IFlowDataset> $flowDatasets = this.getFlowDatasets();
        result = result * 59 + ($flowDatasets == null ? 43 : $flowDatasets.hashCode());
        String $flowErrorMessage = this.getFlowErrorMessage();
        result = result * 59 + ($flowErrorMessage == null ? 43 : $flowErrorMessage.hashCode());
        String $flowFolderName = this.getFlowFolderName();
        result = result * 59 + ($flowFolderName == null ? 43 : $flowFolderName.hashCode());
        String $flowFolderQualifiedName = this.getFlowFolderQualifiedName();
        result = result * 59 + ($flowFolderQualifiedName == null ? 43 : $flowFolderQualifiedName.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $flowProjectName = this.getFlowProjectName();
        result = result * 59 + ($flowProjectName == null ? 43 : $flowProjectName.hashCode());
        String $flowProjectQualifiedName = this.getFlowProjectQualifiedName();
        result = result * 59 + ($flowProjectQualifiedName == null ? 43 : $flowProjectQualifiedName.hashCode());
        String $flowReusableUnitName = this.getFlowReusableUnitName();
        result = result * 59 + ($flowReusableUnitName == null ? 43 : $flowReusableUnitName.hashCode());
        String $flowReusableUnitQualifiedName = this.getFlowReusableUnitQualifiedName();
        result = result * 59 + ($flowReusableUnitQualifiedName == null ? 43 : $flowReusableUnitQualifiedName.hashCode());
        String $flowRunId = this.getFlowRunId();
        result = result * 59 + ($flowRunId == null ? 43 : $flowRunId.hashCode());
        String $flowSchedule = this.getFlowSchedule();
        result = result * 59 + ($flowSchedule == null ? 43 : $flowSchedule.hashCode());
        String $flowStatus = this.getFlowStatus();
        result = result * 59 + ($flowStatus == null ? 43 : $flowStatus.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FlowReusableUnit(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", flowAbstracts=" + String.valueOf(this.getFlowAbstracts()) + ", flowControlOperationCount=" + this.getFlowControlOperationCount() + ", flowDataFlows=" + String.valueOf(this.getFlowDataFlows()) + ", flowDatasetCount=" + this.getFlowDatasetCount() + ", flowDatasets=" + String.valueOf(this.getFlowDatasets()) + ", flowErrorMessage=" + this.getFlowErrorMessage() + ", flowFinishedAt=" + this.getFlowFinishedAt() + ", flowFolderName=" + this.getFlowFolderName() + ", flowFolderQualifiedName=" + this.getFlowFolderQualifiedName() + ", flowId=" + this.getFlowId() + ", flowProjectName=" + this.getFlowProjectName() + ", flowProjectQualifiedName=" + this.getFlowProjectQualifiedName() + ", flowReusableUnitName=" + this.getFlowReusableUnitName() + ", flowReusableUnitQualifiedName=" + this.getFlowReusableUnitQualifiedName() + ", flowRunId=" + this.getFlowRunId() + ", flowSchedule=" + this.getFlowSchedule() + ", flowStartedAt=" + this.getFlowStartedAt() + ", flowStatus=" + this.getFlowStatus() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class FlowReusableUnitBuilder<C extends FlowReusableUnit, B extends FlowReusableUnitBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IFlowDataset> flowAbstracts;
        @Generated
        private Long flowControlOperationCount;
        @Generated
        private ArrayList<IFlowDatasetOperation> flowDataFlows;
        @Generated
        private Long flowDatasetCount;
        @Generated
        private ArrayList<IFlowDataset> flowDatasets;
        @Generated
        private String flowErrorMessage;
        @Generated
        private Long flowFinishedAt;
        @Generated
        private String flowFolderName;
        @Generated
        private String flowFolderQualifiedName;
        @Generated
        private String flowId;
        @Generated
        private String flowProjectName;
        @Generated
        private String flowProjectQualifiedName;
        @Generated
        private String flowReusableUnitName;
        @Generated
        private String flowReusableUnitQualifiedName;
        @Generated
        private String flowRunId;
        @Generated
        private String flowSchedule;
        @Generated
        private Long flowStartedAt;
        @Generated
        private String flowStatus;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowReusableUnitBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowReusableUnit instance, FlowReusableUnitBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.flowAbstracts(instance.flowAbstracts == null ? Collections.emptySortedSet() : instance.flowAbstracts);
            b.flowControlOperationCount(instance.flowControlOperationCount);
            b.flowDataFlows(instance.flowDataFlows == null ? Collections.emptySortedSet() : instance.flowDataFlows);
            b.flowDatasetCount(instance.flowDatasetCount);
            b.flowDatasets(instance.flowDatasets == null ? Collections.emptySortedSet() : instance.flowDatasets);
            b.flowErrorMessage(instance.flowErrorMessage);
            b.flowFinishedAt(instance.flowFinishedAt);
            b.flowFolderName(instance.flowFolderName);
            b.flowFolderQualifiedName(instance.flowFolderQualifiedName);
            b.flowId(instance.flowId);
            b.flowProjectName(instance.flowProjectName);
            b.flowProjectQualifiedName(instance.flowProjectQualifiedName);
            b.flowReusableUnitName(instance.flowReusableUnitName);
            b.flowReusableUnitQualifiedName(instance.flowReusableUnitQualifiedName);
            b.flowRunId(instance.flowRunId);
            b.flowSchedule(instance.flowSchedule);
            b.flowStartedAt(instance.flowStartedAt);
            b.flowStatus(instance.flowStatus);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B flowAbstract(IFlowDataset flowAbstract) {
            if (this.flowAbstracts == null) {
                this.flowAbstracts = new ArrayList();
            }
            this.flowAbstracts.add(flowAbstract);
            return (B)this.self();
        }

        @Generated
        public B flowAbstracts(Collection<? extends IFlowDataset> flowAbstracts) {
            if (flowAbstracts == null) {
                throw new NullPointerException("flowAbstracts cannot be null");
            }
            if (this.flowAbstracts == null) {
                this.flowAbstracts = new ArrayList();
            }
            this.flowAbstracts.addAll(flowAbstracts);
            return (B)this.self();
        }

        @Generated
        public B clearFlowAbstracts() {
            if (this.flowAbstracts != null) {
                this.flowAbstracts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flowControlOperationCount(Long flowControlOperationCount) {
            this.flowControlOperationCount = flowControlOperationCount;
            return (B)this.self();
        }

        @Generated
        public B flowDataFlow(IFlowDatasetOperation flowDataFlow) {
            if (this.flowDataFlows == null) {
                this.flowDataFlows = new ArrayList();
            }
            this.flowDataFlows.add(flowDataFlow);
            return (B)this.self();
        }

        @Generated
        public B flowDataFlows(Collection<? extends IFlowDatasetOperation> flowDataFlows) {
            if (flowDataFlows == null) {
                throw new NullPointerException("flowDataFlows cannot be null");
            }
            if (this.flowDataFlows == null) {
                this.flowDataFlows = new ArrayList();
            }
            this.flowDataFlows.addAll(flowDataFlows);
            return (B)this.self();
        }

        @Generated
        public B clearFlowDataFlows() {
            if (this.flowDataFlows != null) {
                this.flowDataFlows.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flowDatasetCount(Long flowDatasetCount) {
            this.flowDatasetCount = flowDatasetCount;
            return (B)this.self();
        }

        @Generated
        public B flowDataset(IFlowDataset flowDataset) {
            if (this.flowDatasets == null) {
                this.flowDatasets = new ArrayList();
            }
            this.flowDatasets.add(flowDataset);
            return (B)this.self();
        }

        @Generated
        public B flowDatasets(Collection<? extends IFlowDataset> flowDatasets) {
            if (flowDatasets == null) {
                throw new NullPointerException("flowDatasets cannot be null");
            }
            if (this.flowDatasets == null) {
                this.flowDatasets = new ArrayList();
            }
            this.flowDatasets.addAll(flowDatasets);
            return (B)this.self();
        }

        @Generated
        public B clearFlowDatasets() {
            if (this.flowDatasets != null) {
                this.flowDatasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B flowErrorMessage(String flowErrorMessage) {
            this.flowErrorMessage = flowErrorMessage;
            return (B)this.self();
        }

        @Generated
        public B flowFinishedAt(Long flowFinishedAt) {
            this.flowFinishedAt = flowFinishedAt;
            return (B)this.self();
        }

        @Generated
        public B flowFolderName(String flowFolderName) {
            this.flowFolderName = flowFolderName;
            return (B)this.self();
        }

        @Generated
        public B flowFolderQualifiedName(String flowFolderQualifiedName) {
            this.flowFolderQualifiedName = flowFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B flowProjectName(String flowProjectName) {
            this.flowProjectName = flowProjectName;
            return (B)this.self();
        }

        @Generated
        public B flowProjectQualifiedName(String flowProjectQualifiedName) {
            this.flowProjectQualifiedName = flowProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitName(String flowReusableUnitName) {
            this.flowReusableUnitName = flowReusableUnitName;
            return (B)this.self();
        }

        @Generated
        public B flowReusableUnitQualifiedName(String flowReusableUnitQualifiedName) {
            this.flowReusableUnitQualifiedName = flowReusableUnitQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B flowRunId(String flowRunId) {
            this.flowRunId = flowRunId;
            return (B)this.self();
        }

        @Generated
        public B flowSchedule(String flowSchedule) {
            this.flowSchedule = flowSchedule;
            return (B)this.self();
        }

        @Generated
        public B flowStartedAt(Long flowStartedAt) {
            this.flowStartedAt = flowStartedAt;
            return (B)this.self();
        }

        @Generated
        public B flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowReusableUnit.FlowReusableUnitBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", flowAbstracts=" + String.valueOf(this.flowAbstracts) + ", flowControlOperationCount=" + this.flowControlOperationCount + ", flowDataFlows=" + String.valueOf(this.flowDataFlows) + ", flowDatasetCount=" + this.flowDatasetCount + ", flowDatasets=" + String.valueOf(this.flowDatasets) + ", flowErrorMessage=" + this.flowErrorMessage + ", flowFinishedAt=" + this.flowFinishedAt + ", flowFolderName=" + this.flowFolderName + ", flowFolderQualifiedName=" + this.flowFolderQualifiedName + ", flowId=" + this.flowId + ", flowProjectName=" + this.flowProjectName + ", flowProjectQualifiedName=" + this.flowProjectQualifiedName + ", flowReusableUnitName=" + this.flowReusableUnitName + ", flowReusableUnitQualifiedName=" + this.flowReusableUnitQualifiedName + ", flowRunId=" + this.flowRunId + ", flowSchedule=" + this.flowSchedule + ", flowStartedAt=" + this.flowStartedAt + ", flowStatus=" + this.flowStatus + ")";
        }
    }

    @Generated
    private static final class FlowReusableUnitBuilderImpl
    extends FlowReusableUnitBuilder<FlowReusableUnit, FlowReusableUnitBuilderImpl> {
        @Generated
        private FlowReusableUnitBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowReusableUnitBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowReusableUnit build() {
            return new FlowReusableUnit(this);
        }
    }
}

