/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossary;
import com.atlan.model.assets.IGlossaryCategory;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlasGlossaryTermType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTerm
extends Asset
implements IGlossaryTerm,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlossaryTerm.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryTerm";
    String typeName;
    @Attribute
    String abbreviation;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    IGlossary anchor;
    @Attribute
    SortedSet<IGlossaryTerm> antonyms;
    @Attribute
    SortedSet<IAsset> assignedEntities;
    @Attribute
    SortedSet<IGlossaryCategory> categories;
    @Attribute
    SortedSet<IGlossaryTerm> classifies;
    @Attribute
    SortedSet<String> examples;
    @Attribute
    SortedSet<IGlossaryTerm> isA;
    @Attribute
    String longDescription;
    @Attribute
    SortedSet<IGlossaryTerm> preferredTerms;
    @Attribute
    SortedSet<IGlossaryTerm> preferredToTerms;
    @Attribute
    SortedSet<IGlossaryTerm> replacedBy;
    @Attribute
    SortedSet<IGlossaryTerm> replacementTerms;
    @Attribute
    SortedSet<IGlossaryTerm> seeAlso;
    @Attribute
    String shortDescription;
    @Attribute
    SortedSet<IGlossaryTerm> synonyms;
    @Attribute
    AtlasGlossaryTermType termType;
    @Attribute
    SortedSet<IGlossaryTerm> translatedTerms;
    @Attribute
    SortedSet<IGlossaryTerm> translationTerms;
    @Attribute
    String usage;
    @Attribute
    SortedSet<IGlossaryTerm> validValues;
    @Attribute
    SortedSet<IGlossaryTerm> validValuesFor;

    @Override
    public GlossaryTerm trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return GlossaryTerm.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return GlossaryTerm.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return GlossaryTerm.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return GlossaryTerm.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static GlossaryTerm refByGuid(String guid) {
        return GlossaryTerm.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static GlossaryTerm refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm._internal().guid(guid)).semantic(semantic)).build();
    }

    public static GlossaryTerm refByQualifiedName(String qualifiedName) {
        return GlossaryTerm.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static GlossaryTerm refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id) throws AtlanException {
        return GlossaryTerm.get(client, id, false);
    }

    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof GlossaryTerm) {
                return (GlossaryTerm)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof GlossaryTerm) {
            return (GlossaryTerm)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return GlossaryTerm.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static GlossaryTerm get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryTerm.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof GlossaryTerm) {
                return (GlossaryTerm)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryTerm.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof GlossaryTerm) {
            return (GlossaryTerm)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static GlossaryTermBuilder<?, ?> creator(String name, Glossary glossary) throws InvalidRequestException {
        return GlossaryTerm.creator(name, (String)null).anchor(glossary.trimToReference());
    }

    public static GlossaryTermBuilder<?, ?> creator(String name, String glossaryId) {
        Glossary anchor = StringUtils.isUUID(glossaryId) ? Glossary.refByGuid(glossaryId) : Glossary.refByQualifiedName(glossaryId);
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).anchor(anchor);
    }

    public static GlossaryTermBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).anchor(Glossary.refByGuid(glossaryGuid));
    }

    public GlossaryTermBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        GlossaryTerm.validateRequired(TYPE_NAME, map);
        if (this.getAnchor() == null || !this.getAnchor().isValidReferenceByGuid()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, "anchor.guid");
        }
        return GlossaryTerm.updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName) throws AtlanException {
        return GlossaryTerm.findByName(client, name, glossaryName, (List<AtlanField>)null);
    }

    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName, Collection<String> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return GlossaryTerm.findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    public static GlossaryTerm findByName(AtlanClient client, String name, String glossaryName, List<AtlanField> attributes) throws AtlanException {
        Glossary glossary = Glossary.findByName(client, glossaryName);
        return GlossaryTerm.findByNameFast(client, name, glossary.getQualifiedName(), attributes);
    }

    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName) throws AtlanException {
        return GlossaryTerm.findByNameFast(client, name, glossaryQualifiedName, (List<AtlanField>)null);
    }

    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        ArrayList results = new ArrayList();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryTerm.select(client).where(NAME.eq(name))).where(ANCHOR.eq(glossaryQualifiedName))).includeOnResults(ANCHOR))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).includeOnRelations(Asset.NAME)).includeRelationshipAttributes(true)).pageSize(2)).stream().limit(2L).filter(a -> a instanceof GlossaryTerm).forEach(t -> results.add((GlossaryTerm)t));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        if (results.size() > 1) {
            log.warn("Multiple terms found with the name '{}' in glossary '{}', returning only the first.", (Object)name, (Object)glossaryQualifiedName);
        }
        return (GlossaryTerm)results.get(0);
    }

    public static GlossaryTerm findByNameFast(AtlanClient client, String name, String glossaryQualifiedName, List<AtlanField> attributes) throws AtlanException {
        ArrayList results = new ArrayList();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)GlossaryTerm.select(client).where(NAME.eq(name))).where(ANCHOR.eq(glossaryQualifiedName))).includeOnResults(ANCHOR)).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).includeOnRelations(Asset.NAME)).includeRelationshipAttributes(true)).pageSize(2)).stream().limit(2L).filter(a -> a instanceof GlossaryTerm).forEach(t -> results.add((GlossaryTerm)t));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_NAME, TYPE_NAME, name);
        }
        if (results.size() > 1) {
            log.warn("Multiple terms found with the name '{}' in glossary '{}', returning only the first.", (Object)name, (Object)glossaryQualifiedName);
        }
        return (GlossaryTerm)results.get(0);
    }

    public static GlossaryTerm removeDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeDescription(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm removeUserDescription(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeUserDescription(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm removeOwners(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeOwners(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm updateCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid, CertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryTerm)Asset.updateCertificate(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    public static GlossaryTerm removeCertificate(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeCertificate(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm updateAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryTerm)Asset.updateAnnouncement(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    public static GlossaryTerm removeAnnouncement(AtlanClient client, String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeAnnouncement(client, GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    @Deprecated
    public static GlossaryTerm appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (GlossaryTerm)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static GlossaryTerm appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (GlossaryTerm)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GlossaryTerm(GlossaryTermBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : GlossaryTerm.$default$typeName();
        this.abbreviation = b.abbreviation;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        this.anchor = b.anchor;
        SortedSet<IGlossaryTerm> antonyms = new TreeSet<IGlossaryTerm>();
        if (b.antonyms != null) {
            antonyms.addAll(b.antonyms);
        }
        antonyms = Collections.unmodifiableSortedSet(antonyms);
        this.antonyms = antonyms;
        SortedSet<IAsset> assignedEntities = new TreeSet<IAsset>();
        if (b.assignedEntities != null) {
            assignedEntities.addAll(b.assignedEntities);
        }
        assignedEntities = Collections.unmodifiableSortedSet(assignedEntities);
        this.assignedEntities = assignedEntities;
        SortedSet<IGlossaryCategory> categories = new TreeSet<IGlossaryCategory>();
        if (b.categories != null) {
            categories.addAll(b.categories);
        }
        categories = Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
        SortedSet<IGlossaryTerm> classifies = new TreeSet<IGlossaryTerm>();
        if (b.classifies != null) {
            classifies.addAll(b.classifies);
        }
        classifies = Collections.unmodifiableSortedSet(classifies);
        this.classifies = classifies;
        SortedSet<String> examples = new TreeSet<String>();
        if (b.examples != null) {
            examples.addAll(b.examples);
        }
        examples = Collections.unmodifiableSortedSet(examples);
        this.examples = examples;
        SortedSet<IGlossaryTerm> isA = new TreeSet<IGlossaryTerm>();
        if (b.isA != null) {
            isA.addAll(b.isA);
        }
        isA = Collections.unmodifiableSortedSet(isA);
        this.isA = isA;
        this.longDescription = b.longDescription;
        SortedSet<IGlossaryTerm> preferredTerms = new TreeSet<IGlossaryTerm>();
        if (b.preferredTerms != null) {
            preferredTerms.addAll(b.preferredTerms);
        }
        preferredTerms = Collections.unmodifiableSortedSet(preferredTerms);
        this.preferredTerms = preferredTerms;
        SortedSet<IGlossaryTerm> preferredToTerms = new TreeSet<IGlossaryTerm>();
        if (b.preferredToTerms != null) {
            preferredToTerms.addAll(b.preferredToTerms);
        }
        preferredToTerms = Collections.unmodifiableSortedSet(preferredToTerms);
        this.preferredToTerms = preferredToTerms;
        SortedSet<IGlossaryTerm> replacedBy = new TreeSet<IGlossaryTerm>();
        if (b.replacedBy != null) {
            replacedBy.addAll(b.replacedBy);
        }
        replacedBy = Collections.unmodifiableSortedSet(replacedBy);
        this.replacedBy = replacedBy;
        SortedSet<IGlossaryTerm> replacementTerms = new TreeSet<IGlossaryTerm>();
        if (b.replacementTerms != null) {
            replacementTerms.addAll(b.replacementTerms);
        }
        replacementTerms = Collections.unmodifiableSortedSet(replacementTerms);
        this.replacementTerms = replacementTerms;
        SortedSet<IGlossaryTerm> seeAlso = new TreeSet<IGlossaryTerm>();
        if (b.seeAlso != null) {
            seeAlso.addAll(b.seeAlso);
        }
        seeAlso = Collections.unmodifiableSortedSet(seeAlso);
        this.seeAlso = seeAlso;
        this.shortDescription = b.shortDescription;
        SortedSet<IGlossaryTerm> synonyms = new TreeSet<IGlossaryTerm>();
        if (b.synonyms != null) {
            synonyms.addAll(b.synonyms);
        }
        synonyms = Collections.unmodifiableSortedSet(synonyms);
        this.synonyms = synonyms;
        this.termType = b.termType;
        SortedSet<IGlossaryTerm> translatedTerms = new TreeSet<IGlossaryTerm>();
        if (b.translatedTerms != null) {
            translatedTerms.addAll(b.translatedTerms);
        }
        translatedTerms = Collections.unmodifiableSortedSet(translatedTerms);
        this.translatedTerms = translatedTerms;
        SortedSet<IGlossaryTerm> translationTerms = new TreeSet<IGlossaryTerm>();
        if (b.translationTerms != null) {
            translationTerms.addAll(b.translationTerms);
        }
        translationTerms = Collections.unmodifiableSortedSet(translationTerms);
        this.translationTerms = translationTerms;
        this.usage = b.usage;
        SortedSet<IGlossaryTerm> validValues = new TreeSet<IGlossaryTerm>();
        if (b.validValues != null) {
            validValues.addAll(b.validValues);
        }
        validValues = Collections.unmodifiableSortedSet(validValues);
        this.validValues = validValues;
        SortedSet<IGlossaryTerm> validValuesFor = new TreeSet<IGlossaryTerm>();
        if (b.validValuesFor != null) {
            validValuesFor.addAll(b.validValuesFor);
        }
        validValuesFor = Collections.unmodifiableSortedSet(validValuesFor);
        this.validValuesFor = validValuesFor;
    }

    @Generated
    public static GlossaryTermBuilder<?, ?> _internal() {
        return new GlossaryTermBuilderImpl();
    }

    @Generated
    public GlossaryTermBuilder<?, ?> toBuilder() {
        return new GlossaryTermBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    @Generated
    public IGlossary getAnchor() {
        return this.anchor;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getAntonyms() {
        return this.antonyms;
    }

    @Override
    @Generated
    public SortedSet<IAsset> getAssignedEntities() {
        return this.assignedEntities;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryCategory> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getClassifies() {
        return this.classifies;
    }

    @Override
    @Generated
    public SortedSet<String> getExamples() {
        return this.examples;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getIsA() {
        return this.isA;
    }

    @Override
    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getPreferredTerms() {
        return this.preferredTerms;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getPreferredToTerms() {
        return this.preferredToTerms;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getReplacementTerms() {
        return this.replacementTerms;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getSeeAlso() {
        return this.seeAlso;
    }

    @Override
    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getSynonyms() {
        return this.synonyms;
    }

    @Override
    @Generated
    public AtlasGlossaryTermType getTermType() {
        return this.termType;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getTranslatedTerms() {
        return this.translatedTerms;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getTranslationTerms() {
        return this.translationTerms;
    }

    @Override
    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getValidValues() {
        return this.validValues;
    }

    @Override
    @Generated
    public SortedSet<IGlossaryTerm> getValidValuesFor() {
        return this.validValuesFor;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlossaryTerm)) {
            return false;
        }
        GlossaryTerm other = (GlossaryTerm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$abbreviation = this.getAbbreviation();
        String other$abbreviation = other.getAbbreviation();
        if (this$abbreviation == null ? other$abbreviation != null : !this$abbreviation.equals(other$abbreviation)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        IGlossary this$anchor = this.getAnchor();
        IGlossary other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$antonyms = this.getAntonyms();
        SortedSet<IGlossaryTerm> other$antonyms = other.getAntonyms();
        if (this$antonyms == null ? other$antonyms != null : !this$antonyms.equals(other$antonyms)) {
            return false;
        }
        SortedSet<IAsset> this$assignedEntities = this.getAssignedEntities();
        SortedSet<IAsset> other$assignedEntities = other.getAssignedEntities();
        if (this$assignedEntities == null ? other$assignedEntities != null : !this$assignedEntities.equals(other$assignedEntities)) {
            return false;
        }
        SortedSet<IGlossaryCategory> this$categories = this.getCategories();
        SortedSet<IGlossaryCategory> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$classifies = this.getClassifies();
        SortedSet<IGlossaryTerm> other$classifies = other.getClassifies();
        if (this$classifies == null ? other$classifies != null : !this$classifies.equals(other$classifies)) {
            return false;
        }
        SortedSet<String> this$examples = this.getExamples();
        SortedSet<String> other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !this$examples.equals(other$examples)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$isA = this.getIsA();
        SortedSet<IGlossaryTerm> other$isA = other.getIsA();
        if (this$isA == null ? other$isA != null : !this$isA.equals(other$isA)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$preferredTerms = this.getPreferredTerms();
        SortedSet<IGlossaryTerm> other$preferredTerms = other.getPreferredTerms();
        if (this$preferredTerms == null ? other$preferredTerms != null : !this$preferredTerms.equals(other$preferredTerms)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$preferredToTerms = this.getPreferredToTerms();
        SortedSet<IGlossaryTerm> other$preferredToTerms = other.getPreferredToTerms();
        if (this$preferredToTerms == null ? other$preferredToTerms != null : !this$preferredToTerms.equals(other$preferredToTerms)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$replacedBy = this.getReplacedBy();
        SortedSet<IGlossaryTerm> other$replacedBy = other.getReplacedBy();
        if (this$replacedBy == null ? other$replacedBy != null : !this$replacedBy.equals(other$replacedBy)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$replacementTerms = this.getReplacementTerms();
        SortedSet<IGlossaryTerm> other$replacementTerms = other.getReplacementTerms();
        if (this$replacementTerms == null ? other$replacementTerms != null : !this$replacementTerms.equals(other$replacementTerms)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$seeAlso = this.getSeeAlso();
        SortedSet<IGlossaryTerm> other$seeAlso = other.getSeeAlso();
        if (this$seeAlso == null ? other$seeAlso != null : !this$seeAlso.equals(other$seeAlso)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$synonyms = this.getSynonyms();
        SortedSet<IGlossaryTerm> other$synonyms = other.getSynonyms();
        if (this$synonyms == null ? other$synonyms != null : !this$synonyms.equals(other$synonyms)) {
            return false;
        }
        AtlasGlossaryTermType this$termType = this.getTermType();
        AtlasGlossaryTermType other$termType = other.getTermType();
        if (this$termType == null ? other$termType != null : !this$termType.equals(other$termType)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$translatedTerms = this.getTranslatedTerms();
        SortedSet<IGlossaryTerm> other$translatedTerms = other.getTranslatedTerms();
        if (this$translatedTerms == null ? other$translatedTerms != null : !this$translatedTerms.equals(other$translatedTerms)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$translationTerms = this.getTranslationTerms();
        SortedSet<IGlossaryTerm> other$translationTerms = other.getTranslationTerms();
        if (this$translationTerms == null ? other$translationTerms != null : !this$translationTerms.equals(other$translationTerms)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$validValues = this.getValidValues();
        SortedSet<IGlossaryTerm> other$validValues = other.getValidValues();
        if (this$validValues == null ? other$validValues != null : !this$validValues.equals(other$validValues)) {
            return false;
        }
        SortedSet<IGlossaryTerm> this$validValuesFor = this.getValidValuesFor();
        SortedSet<IGlossaryTerm> other$validValuesFor = other.getValidValuesFor();
        return !(this$validValuesFor == null ? other$validValuesFor != null : !this$validValuesFor.equals(other$validValuesFor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlossaryTerm;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $abbreviation = this.getAbbreviation();
        result = result * 59 + ($abbreviation == null ? 43 : $abbreviation.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        IGlossary $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        SortedSet<IGlossaryTerm> $antonyms = this.getAntonyms();
        result = result * 59 + ($antonyms == null ? 43 : $antonyms.hashCode());
        SortedSet<IAsset> $assignedEntities = this.getAssignedEntities();
        result = result * 59 + ($assignedEntities == null ? 43 : $assignedEntities.hashCode());
        SortedSet<IGlossaryCategory> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : $categories.hashCode());
        SortedSet<IGlossaryTerm> $classifies = this.getClassifies();
        result = result * 59 + ($classifies == null ? 43 : $classifies.hashCode());
        SortedSet<String> $examples = this.getExamples();
        result = result * 59 + ($examples == null ? 43 : $examples.hashCode());
        SortedSet<IGlossaryTerm> $isA = this.getIsA();
        result = result * 59 + ($isA == null ? 43 : $isA.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        SortedSet<IGlossaryTerm> $preferredTerms = this.getPreferredTerms();
        result = result * 59 + ($preferredTerms == null ? 43 : $preferredTerms.hashCode());
        SortedSet<IGlossaryTerm> $preferredToTerms = this.getPreferredToTerms();
        result = result * 59 + ($preferredToTerms == null ? 43 : $preferredToTerms.hashCode());
        SortedSet<IGlossaryTerm> $replacedBy = this.getReplacedBy();
        result = result * 59 + ($replacedBy == null ? 43 : $replacedBy.hashCode());
        SortedSet<IGlossaryTerm> $replacementTerms = this.getReplacementTerms();
        result = result * 59 + ($replacementTerms == null ? 43 : $replacementTerms.hashCode());
        SortedSet<IGlossaryTerm> $seeAlso = this.getSeeAlso();
        result = result * 59 + ($seeAlso == null ? 43 : $seeAlso.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        SortedSet<IGlossaryTerm> $synonyms = this.getSynonyms();
        result = result * 59 + ($synonyms == null ? 43 : $synonyms.hashCode());
        AtlasGlossaryTermType $termType = this.getTermType();
        result = result * 59 + ($termType == null ? 43 : $termType.hashCode());
        SortedSet<IGlossaryTerm> $translatedTerms = this.getTranslatedTerms();
        result = result * 59 + ($translatedTerms == null ? 43 : $translatedTerms.hashCode());
        SortedSet<IGlossaryTerm> $translationTerms = this.getTranslationTerms();
        result = result * 59 + ($translationTerms == null ? 43 : $translationTerms.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        SortedSet<IGlossaryTerm> $validValues = this.getValidValues();
        result = result * 59 + ($validValues == null ? 43 : $validValues.hashCode());
        SortedSet<IGlossaryTerm> $validValuesFor = this.getValidValuesFor();
        result = result * 59 + ($validValuesFor == null ? 43 : $validValuesFor.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GlossaryTerm(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", abbreviation=" + this.getAbbreviation() + ", additionalAttributes=" + String.valueOf(this.getAdditionalAttributes()) + ", anchor=" + String.valueOf(this.getAnchor()) + ", antonyms=" + String.valueOf(this.getAntonyms()) + ", assignedEntities=" + String.valueOf(this.getAssignedEntities()) + ", categories=" + String.valueOf(this.getCategories()) + ", classifies=" + String.valueOf(this.getClassifies()) + ", examples=" + String.valueOf(this.getExamples()) + ", isA=" + String.valueOf(this.getIsA()) + ", longDescription=" + this.getLongDescription() + ", preferredTerms=" + String.valueOf(this.getPreferredTerms()) + ", preferredToTerms=" + String.valueOf(this.getPreferredToTerms()) + ", replacedBy=" + String.valueOf(this.getReplacedBy()) + ", replacementTerms=" + String.valueOf(this.getReplacementTerms()) + ", seeAlso=" + String.valueOf(this.getSeeAlso()) + ", shortDescription=" + this.getShortDescription() + ", synonyms=" + String.valueOf(this.getSynonyms()) + ", termType=" + String.valueOf(this.getTermType()) + ", translatedTerms=" + String.valueOf(this.getTranslatedTerms()) + ", translationTerms=" + String.valueOf(this.getTranslationTerms()) + ", usage=" + this.getUsage() + ", validValues=" + String.valueOf(this.getValidValues()) + ", validValuesFor=" + String.valueOf(this.getValidValuesFor()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class GlossaryTermBuilder<C extends GlossaryTerm, B extends GlossaryTermBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String abbreviation;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private IGlossary anchor;
        @Generated
        private ArrayList<IGlossaryTerm> antonyms;
        @Generated
        private ArrayList<IAsset> assignedEntities;
        @Generated
        private ArrayList<IGlossaryCategory> categories;
        @Generated
        private ArrayList<IGlossaryTerm> classifies;
        @Generated
        private ArrayList<String> examples;
        @Generated
        private ArrayList<IGlossaryTerm> isA;
        @Generated
        private String longDescription;
        @Generated
        private ArrayList<IGlossaryTerm> preferredTerms;
        @Generated
        private ArrayList<IGlossaryTerm> preferredToTerms;
        @Generated
        private ArrayList<IGlossaryTerm> replacedBy;
        @Generated
        private ArrayList<IGlossaryTerm> replacementTerms;
        @Generated
        private ArrayList<IGlossaryTerm> seeAlso;
        @Generated
        private String shortDescription;
        @Generated
        private ArrayList<IGlossaryTerm> synonyms;
        @Generated
        private AtlasGlossaryTermType termType;
        @Generated
        private ArrayList<IGlossaryTerm> translatedTerms;
        @Generated
        private ArrayList<IGlossaryTerm> translationTerms;
        @Generated
        private String usage;
        @Generated
        private ArrayList<IGlossaryTerm> validValues;
        @Generated
        private ArrayList<IGlossaryTerm> validValuesFor;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryTermBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GlossaryTerm instance, GlossaryTermBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.abbreviation(instance.abbreviation);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.anchor(instance.anchor);
            b.antonyms(instance.antonyms == null ? Collections.emptySortedSet() : instance.antonyms);
            b.assignedEntities(instance.assignedEntities == null ? Collections.emptySortedSet() : instance.assignedEntities);
            b.categories(instance.categories == null ? Collections.emptySortedSet() : instance.categories);
            b.classifies(instance.classifies == null ? Collections.emptySortedSet() : instance.classifies);
            b.examples(instance.examples == null ? Collections.emptySortedSet() : instance.examples);
            b.isA(instance.isA == null ? Collections.emptySortedSet() : instance.isA);
            b.longDescription(instance.longDescription);
            b.preferredTerms(instance.preferredTerms == null ? Collections.emptySortedSet() : instance.preferredTerms);
            b.preferredToTerms(instance.preferredToTerms == null ? Collections.emptySortedSet() : instance.preferredToTerms);
            b.replacedBy(instance.replacedBy == null ? Collections.emptySortedSet() : instance.replacedBy);
            b.replacementTerms(instance.replacementTerms == null ? Collections.emptySortedSet() : instance.replacementTerms);
            b.seeAlso(instance.seeAlso == null ? Collections.emptySortedSet() : instance.seeAlso);
            b.shortDescription(instance.shortDescription);
            b.synonyms(instance.synonyms == null ? Collections.emptySortedSet() : instance.synonyms);
            b.termType(instance.termType);
            b.translatedTerms(instance.translatedTerms == null ? Collections.emptySortedSet() : instance.translatedTerms);
            b.translationTerms(instance.translationTerms == null ? Collections.emptySortedSet() : instance.translationTerms);
            b.usage(instance.usage);
            b.validValues(instance.validValues == null ? Collections.emptySortedSet() : instance.validValues);
            b.validValuesFor(instance.validValuesFor == null ? Collections.emptySortedSet() : instance.validValuesFor);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anchor(IGlossary anchor) {
            this.anchor = anchor;
            return (B)this.self();
        }

        @Generated
        public B antonym(IGlossaryTerm antonym) {
            if (this.antonyms == null) {
                this.antonyms = new ArrayList();
            }
            this.antonyms.add(antonym);
            return (B)this.self();
        }

        @Generated
        public B antonyms(Collection<? extends IGlossaryTerm> antonyms) {
            if (antonyms == null) {
                throw new NullPointerException("antonyms cannot be null");
            }
            if (this.antonyms == null) {
                this.antonyms = new ArrayList();
            }
            this.antonyms.addAll(antonyms);
            return (B)this.self();
        }

        @Generated
        public B clearAntonyms() {
            if (this.antonyms != null) {
                this.antonyms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assignedEntity(IAsset assignedEntity) {
            if (this.assignedEntities == null) {
                this.assignedEntities = new ArrayList();
            }
            this.assignedEntities.add(assignedEntity);
            return (B)this.self();
        }

        @Generated
        public B assignedEntities(Collection<? extends IAsset> assignedEntities) {
            if (assignedEntities == null) {
                throw new NullPointerException("assignedEntities cannot be null");
            }
            if (this.assignedEntities == null) {
                this.assignedEntities = new ArrayList();
            }
            this.assignedEntities.addAll(assignedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearAssignedEntities() {
            if (this.assignedEntities != null) {
                this.assignedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B category(IGlossaryCategory category) {
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.add(category);
            return (B)this.self();
        }

        @Generated
        public B categories(Collection<? extends IGlossaryCategory> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.addAll(categories);
            return (B)this.self();
        }

        @Generated
        public B clearCategories() {
            if (this.categories != null) {
                this.categories.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B classify(IGlossaryTerm classify) {
            if (this.classifies == null) {
                this.classifies = new ArrayList();
            }
            this.classifies.add(classify);
            return (B)this.self();
        }

        @Generated
        public B classifies(Collection<? extends IGlossaryTerm> classifies) {
            if (classifies == null) {
                throw new NullPointerException("classifies cannot be null");
            }
            if (this.classifies == null) {
                this.classifies = new ArrayList();
            }
            this.classifies.addAll(classifies);
            return (B)this.self();
        }

        @Generated
        public B clearClassifies() {
            if (this.classifies != null) {
                this.classifies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B example(String example) {
            if (this.examples == null) {
                this.examples = new ArrayList();
            }
            this.examples.add(example);
            return (B)this.self();
        }

        @Generated
        public B examples(Collection<? extends String> examples) {
            if (examples == null) {
                throw new NullPointerException("examples cannot be null");
            }
            if (this.examples == null) {
                this.examples = new ArrayList();
            }
            this.examples.addAll(examples);
            return (B)this.self();
        }

        @Generated
        public B clearExamples() {
            if (this.examples != null) {
                this.examples.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isATerm(IGlossaryTerm isATerm) {
            if (this.isA == null) {
                this.isA = new ArrayList();
            }
            this.isA.add(isATerm);
            return (B)this.self();
        }

        @Generated
        public B isA(Collection<? extends IGlossaryTerm> isA) {
            if (isA == null) {
                throw new NullPointerException("isA cannot be null");
            }
            if (this.isA == null) {
                this.isA = new ArrayList();
            }
            this.isA.addAll(isA);
            return (B)this.self();
        }

        @Generated
        public B clearIsA() {
            if (this.isA != null) {
                this.isA.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B preferredTerm(IGlossaryTerm preferredTerm) {
            if (this.preferredTerms == null) {
                this.preferredTerms = new ArrayList();
            }
            this.preferredTerms.add(preferredTerm);
            return (B)this.self();
        }

        @Generated
        public B preferredTerms(Collection<? extends IGlossaryTerm> preferredTerms) {
            if (preferredTerms == null) {
                throw new NullPointerException("preferredTerms cannot be null");
            }
            if (this.preferredTerms == null) {
                this.preferredTerms = new ArrayList();
            }
            this.preferredTerms.addAll(preferredTerms);
            return (B)this.self();
        }

        @Generated
        public B clearPreferredTerms() {
            if (this.preferredTerms != null) {
                this.preferredTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B preferredToTerm(IGlossaryTerm preferredToTerm) {
            if (this.preferredToTerms == null) {
                this.preferredToTerms = new ArrayList();
            }
            this.preferredToTerms.add(preferredToTerm);
            return (B)this.self();
        }

        @Generated
        public B preferredToTerms(Collection<? extends IGlossaryTerm> preferredToTerms) {
            if (preferredToTerms == null) {
                throw new NullPointerException("preferredToTerms cannot be null");
            }
            if (this.preferredToTerms == null) {
                this.preferredToTerms = new ArrayList();
            }
            this.preferredToTerms.addAll(preferredToTerms);
            return (B)this.self();
        }

        @Generated
        public B clearPreferredToTerms() {
            if (this.preferredToTerms != null) {
                this.preferredToTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B replacedByTerm(IGlossaryTerm replacedByTerm) {
            if (this.replacedBy == null) {
                this.replacedBy = new ArrayList();
            }
            this.replacedBy.add(replacedByTerm);
            return (B)this.self();
        }

        @Generated
        public B replacedBy(Collection<? extends IGlossaryTerm> replacedBy) {
            if (replacedBy == null) {
                throw new NullPointerException("replacedBy cannot be null");
            }
            if (this.replacedBy == null) {
                this.replacedBy = new ArrayList();
            }
            this.replacedBy.addAll(replacedBy);
            return (B)this.self();
        }

        @Generated
        public B clearReplacedBy() {
            if (this.replacedBy != null) {
                this.replacedBy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B replacementTerm(IGlossaryTerm replacementTerm) {
            if (this.replacementTerms == null) {
                this.replacementTerms = new ArrayList();
            }
            this.replacementTerms.add(replacementTerm);
            return (B)this.self();
        }

        @Generated
        public B replacementTerms(Collection<? extends IGlossaryTerm> replacementTerms) {
            if (replacementTerms == null) {
                throw new NullPointerException("replacementTerms cannot be null");
            }
            if (this.replacementTerms == null) {
                this.replacementTerms = new ArrayList();
            }
            this.replacementTerms.addAll(replacementTerms);
            return (B)this.self();
        }

        @Generated
        public B clearReplacementTerms() {
            if (this.replacementTerms != null) {
                this.replacementTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B seeAlsoOne(IGlossaryTerm seeAlsoOne) {
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.add(seeAlsoOne);
            return (B)this.self();
        }

        @Generated
        public B seeAlso(Collection<? extends IGlossaryTerm> seeAlso) {
            if (seeAlso == null) {
                throw new NullPointerException("seeAlso cannot be null");
            }
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.addAll(seeAlso);
            return (B)this.self();
        }

        @Generated
        public B clearSeeAlso() {
            if (this.seeAlso != null) {
                this.seeAlso.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B synonym(IGlossaryTerm synonym) {
            if (this.synonyms == null) {
                this.synonyms = new ArrayList();
            }
            this.synonyms.add(synonym);
            return (B)this.self();
        }

        @Generated
        public B synonyms(Collection<? extends IGlossaryTerm> synonyms) {
            if (synonyms == null) {
                throw new NullPointerException("synonyms cannot be null");
            }
            if (this.synonyms == null) {
                this.synonyms = new ArrayList();
            }
            this.synonyms.addAll(synonyms);
            return (B)this.self();
        }

        @Generated
        public B clearSynonyms() {
            if (this.synonyms != null) {
                this.synonyms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B termType(AtlasGlossaryTermType termType) {
            this.termType = termType;
            return (B)this.self();
        }

        @Generated
        public B translatedTerm(IGlossaryTerm translatedTerm) {
            if (this.translatedTerms == null) {
                this.translatedTerms = new ArrayList();
            }
            this.translatedTerms.add(translatedTerm);
            return (B)this.self();
        }

        @Generated
        public B translatedTerms(Collection<? extends IGlossaryTerm> translatedTerms) {
            if (translatedTerms == null) {
                throw new NullPointerException("translatedTerms cannot be null");
            }
            if (this.translatedTerms == null) {
                this.translatedTerms = new ArrayList();
            }
            this.translatedTerms.addAll(translatedTerms);
            return (B)this.self();
        }

        @Generated
        public B clearTranslatedTerms() {
            if (this.translatedTerms != null) {
                this.translatedTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B translationTerm(IGlossaryTerm translationTerm) {
            if (this.translationTerms == null) {
                this.translationTerms = new ArrayList();
            }
            this.translationTerms.add(translationTerm);
            return (B)this.self();
        }

        @Generated
        public B translationTerms(Collection<? extends IGlossaryTerm> translationTerms) {
            if (translationTerms == null) {
                throw new NullPointerException("translationTerms cannot be null");
            }
            if (this.translationTerms == null) {
                this.translationTerms = new ArrayList();
            }
            this.translationTerms.addAll(translationTerms);
            return (B)this.self();
        }

        @Generated
        public B clearTranslationTerms() {
            if (this.translationTerms != null) {
                this.translationTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B usage(String usage) {
            this.usage = usage;
            return (B)this.self();
        }

        @Generated
        public B validValue(IGlossaryTerm validValue) {
            if (this.validValues == null) {
                this.validValues = new ArrayList();
            }
            this.validValues.add(validValue);
            return (B)this.self();
        }

        @Generated
        public B validValues(Collection<? extends IGlossaryTerm> validValues) {
            if (validValues == null) {
                throw new NullPointerException("validValues cannot be null");
            }
            if (this.validValues == null) {
                this.validValues = new ArrayList();
            }
            this.validValues.addAll(validValues);
            return (B)this.self();
        }

        @Generated
        public B clearValidValues() {
            if (this.validValues != null) {
                this.validValues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B validValueFor(IGlossaryTerm validValueFor) {
            if (this.validValuesFor == null) {
                this.validValuesFor = new ArrayList();
            }
            this.validValuesFor.add(validValueFor);
            return (B)this.self();
        }

        @Generated
        public B validValuesFor(Collection<? extends IGlossaryTerm> validValuesFor) {
            if (validValuesFor == null) {
                throw new NullPointerException("validValuesFor cannot be null");
            }
            if (this.validValuesFor == null) {
                this.validValuesFor = new ArrayList();
            }
            this.validValuesFor.addAll(validValuesFor);
            return (B)this.self();
        }

        @Generated
        public B clearValidValuesFor() {
            if (this.validValuesFor != null) {
                this.validValuesFor.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GlossaryTerm.GlossaryTermBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", abbreviation=" + this.abbreviation + ", additionalAttributes$key=" + String.valueOf(this.additionalAttributes$key) + ", additionalAttributes$value=" + String.valueOf(this.additionalAttributes$value) + ", anchor=" + String.valueOf(this.anchor) + ", antonyms=" + String.valueOf(this.antonyms) + ", assignedEntities=" + String.valueOf(this.assignedEntities) + ", categories=" + String.valueOf(this.categories) + ", classifies=" + String.valueOf(this.classifies) + ", examples=" + String.valueOf(this.examples) + ", isA=" + String.valueOf(this.isA) + ", longDescription=" + this.longDescription + ", preferredTerms=" + String.valueOf(this.preferredTerms) + ", preferredToTerms=" + String.valueOf(this.preferredToTerms) + ", replacedBy=" + String.valueOf(this.replacedBy) + ", replacementTerms=" + String.valueOf(this.replacementTerms) + ", seeAlso=" + String.valueOf(this.seeAlso) + ", shortDescription=" + this.shortDescription + ", synonyms=" + String.valueOf(this.synonyms) + ", termType=" + String.valueOf(this.termType) + ", translatedTerms=" + String.valueOf(this.translatedTerms) + ", translationTerms=" + String.valueOf(this.translationTerms) + ", usage=" + this.usage + ", validValues=" + String.valueOf(this.validValues) + ", validValuesFor=" + String.valueOf(this.validValuesFor) + ")";
        }
    }

    @Generated
    private static final class GlossaryTermBuilderImpl
    extends GlossaryTermBuilder<GlossaryTerm, GlossaryTermBuilderImpl> {
        @Generated
        private GlossaryTermBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryTermBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GlossaryTerm build() {
            return new GlossaryTerm(this);
        }
    }
}

