/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IEventStore;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IKafka;
import com.atlan.model.assets.IKafkaConsumerGroup;
import com.atlan.model.assets.IKafkaTopic;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.KafkaTopic;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.KafkaTopicConsumption;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerGroup
extends Asset
implements IKafkaConsumerGroup,
IKafka,
IEventStore,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerGroup.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "KafkaConsumerGroup";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Long kafkaConsumerGroupMemberCount;
    @Attribute
    List<KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties;
    @Attribute
    SortedSet<String> kafkaTopicNames;
    @Attribute
    SortedSet<String> kafkaTopicQualifiedNames;
    @Attribute
    SortedSet<IKafkaTopic> kafkaTopics;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public KafkaConsumerGroup trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return KafkaConsumerGroup.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return KafkaConsumerGroup.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return KafkaConsumerGroup.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return KafkaConsumerGroup.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static KafkaConsumerGroup refByGuid(String guid) {
        return KafkaConsumerGroup.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static KafkaConsumerGroup refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)KafkaConsumerGroup._internal().guid(guid)).semantic(semantic)).build();
    }

    public static KafkaConsumerGroup refByQualifiedName(String qualifiedName) {
        return KafkaConsumerGroup.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static KafkaConsumerGroup refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)KafkaConsumerGroup._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static KafkaConsumerGroup get(AtlanClient client, String id) throws AtlanException {
        return KafkaConsumerGroup.get(client, id, false);
    }

    @JsonIgnore
    public static KafkaConsumerGroup get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof KafkaConsumerGroup) {
                return (KafkaConsumerGroup)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof KafkaConsumerGroup) {
            return (KafkaConsumerGroup)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static KafkaConsumerGroup get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return KafkaConsumerGroup.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static KafkaConsumerGroup get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)KafkaConsumerGroup.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof KafkaConsumerGroup) {
                return (KafkaConsumerGroup)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)KafkaConsumerGroup.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof KafkaConsumerGroup) {
            return (KafkaConsumerGroup)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static KafkaConsumerGroupBuilder<?, ?> creatorObj(String name, List<KafkaTopic> topics) throws InvalidRequestException {
        if (topics == null || topics.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "KafkaTopic", "null");
        }
        ArrayList<String> topicNames = new ArrayList<String>();
        ArrayList<String> topicQualifiedNames = new ArrayList<String>();
        ArrayList<KafkaTopic> minimalTopics = new ArrayList<KafkaTopic>();
        for (KafkaTopic topic : topics) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("qualifiedName", topic.getQualifiedName());
            map.put("name", topic.getName());
            map.put("connectionQualifiedName", topic.getConnectionQualifiedName());
            KafkaConsumerGroup.validateRelationship("KafkaTopic", map);
            topicNames.add(topic.getName());
            topicQualifiedNames.add(topic.getQualifiedName());
            minimalTopics.add(topic.trimToReference());
        }
        return KafkaConsumerGroup.creator(name, topics.get(0).getConnectionQualifiedName(), topicNames, topicQualifiedNames).kafkaTopics(minimalTopics);
    }

    public static KafkaConsumerGroupBuilder<?, ?> creator(String name, List<String> topicQualifiedNames) throws InvalidRequestException {
        if (topicQualifiedNames == null || topicQualifiedNames.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "KafkaTopic", "null");
        }
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(topicQualifiedNames.get(0));
        List<String> topicNames = topicQualifiedNames.stream().map(t -> StringUtils.getNameFromQualifiedName(t)).collect(Collectors.toList());
        return KafkaConsumerGroup.creator(name, connectionQualifiedName, topicNames, topicQualifiedNames);
    }

    public static KafkaConsumerGroupBuilder<?, ?> creator(String name, String connectionQualifiedName, List<String> topicNames, List<String> topicQualifiedNames) {
        return ((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)KafkaConsumerGroup._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(KafkaConsumerGroup.generateQualifiedName(name, connectionQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).kafkaTopics(topicQualifiedNames.stream().map(t -> KafkaTopic.refByQualifiedName(t)).collect(Collectors.toList()))).kafkaTopicNames(topicNames)).kafkaTopicQualifiedNames(topicQualifiedNames);
    }

    public static String generateQualifiedName(String name, String connectionQualifiedName) {
        return connectionQualifiedName + "/consumer-group/" + name;
    }

    public static KafkaConsumerGroupBuilder<?, ?> updater(String qualifiedName, String name) {
        return (KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)((KafkaConsumerGroupBuilder)KafkaConsumerGroup._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public KafkaConsumerGroupBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        KafkaConsumerGroup.validateRequired(TYPE_NAME, map);
        return KafkaConsumerGroup.updater(this.getQualifiedName(), this.getName());
    }

    public static KafkaConsumerGroup removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeDescription(client, KafkaConsumerGroup.updater(qualifiedName, name));
    }

    public static KafkaConsumerGroup removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeUserDescription(client, KafkaConsumerGroup.updater(qualifiedName, name));
    }

    public static KafkaConsumerGroup removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeOwners(client, KafkaConsumerGroup.updater(qualifiedName, name));
    }

    public static KafkaConsumerGroup updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (KafkaConsumerGroup)Asset.updateCertificate(client, KafkaConsumerGroup._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static KafkaConsumerGroup removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeCertificate(client, KafkaConsumerGroup.updater(qualifiedName, name));
    }

    public static KafkaConsumerGroup updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (KafkaConsumerGroup)Asset.updateAnnouncement(client, KafkaConsumerGroup._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static KafkaConsumerGroup removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeAnnouncement(client, KafkaConsumerGroup.updater(qualifiedName, name));
    }

    public static KafkaConsumerGroup replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaConsumerGroup)Asset.replaceTerms(client, KafkaConsumerGroup.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static KafkaConsumerGroup appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaConsumerGroup)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static KafkaConsumerGroup removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (KafkaConsumerGroup)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static KafkaConsumerGroup appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (KafkaConsumerGroup)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static KafkaConsumerGroup appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (KafkaConsumerGroup)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected KafkaConsumerGroup(KafkaConsumerGroupBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : KafkaConsumerGroup.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.kafkaConsumerGroupMemberCount = b.kafkaConsumerGroupMemberCount;
        this.kafkaConsumerGroupTopicConsumptionProperties = switch (b.kafkaConsumerGroupTopicConsumptionProperties == null ? 0 : b.kafkaConsumerGroupTopicConsumptionProperties.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.kafkaConsumerGroupTopicConsumptionProperties.get(0));
            default -> Collections.unmodifiableList(new ArrayList<KafkaTopicConsumption>(b.kafkaConsumerGroupTopicConsumptionProperties));
        };
        SortedSet<String> kafkaTopicNames = new TreeSet<String>();
        if (b.kafkaTopicNames != null) {
            kafkaTopicNames.addAll(b.kafkaTopicNames);
        }
        kafkaTopicNames = Collections.unmodifiableSortedSet(kafkaTopicNames);
        this.kafkaTopicNames = kafkaTopicNames;
        SortedSet<String> kafkaTopicQualifiedNames = new TreeSet<String>();
        if (b.kafkaTopicQualifiedNames != null) {
            kafkaTopicQualifiedNames.addAll(b.kafkaTopicQualifiedNames);
        }
        kafkaTopicQualifiedNames = Collections.unmodifiableSortedSet(kafkaTopicQualifiedNames);
        this.kafkaTopicQualifiedNames = kafkaTopicQualifiedNames;
        SortedSet<IKafkaTopic> kafkaTopics = new TreeSet<IKafkaTopic>();
        if (b.kafkaTopics != null) {
            kafkaTopics.addAll(b.kafkaTopics);
        }
        kafkaTopics = Collections.unmodifiableSortedSet(kafkaTopics);
        this.kafkaTopics = kafkaTopics;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static KafkaConsumerGroupBuilder<?, ?> _internal() {
        return new KafkaConsumerGroupBuilderImpl();
    }

    @Generated
    public KafkaConsumerGroupBuilder<?, ?> toBuilder() {
        return new KafkaConsumerGroupBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Long getKafkaConsumerGroupMemberCount() {
        return this.kafkaConsumerGroupMemberCount;
    }

    @Override
    @Generated
    public List<KafkaTopicConsumption> getKafkaConsumerGroupTopicConsumptionProperties() {
        return this.kafkaConsumerGroupTopicConsumptionProperties;
    }

    @Override
    @Generated
    public SortedSet<String> getKafkaTopicNames() {
        return this.kafkaTopicNames;
    }

    @Override
    @Generated
    public SortedSet<String> getKafkaTopicQualifiedNames() {
        return this.kafkaTopicQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<IKafkaTopic> getKafkaTopics() {
        return this.kafkaTopics;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConsumerGroup)) {
            return false;
        }
        KafkaConsumerGroup other = (KafkaConsumerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$kafkaConsumerGroupMemberCount = this.getKafkaConsumerGroupMemberCount();
        Long other$kafkaConsumerGroupMemberCount = other.getKafkaConsumerGroupMemberCount();
        if (this$kafkaConsumerGroupMemberCount == null ? other$kafkaConsumerGroupMemberCount != null : !((Object)this$kafkaConsumerGroupMemberCount).equals(other$kafkaConsumerGroupMemberCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        List<KafkaTopicConsumption> this$kafkaConsumerGroupTopicConsumptionProperties = this.getKafkaConsumerGroupTopicConsumptionProperties();
        List<KafkaTopicConsumption> other$kafkaConsumerGroupTopicConsumptionProperties = other.getKafkaConsumerGroupTopicConsumptionProperties();
        if (this$kafkaConsumerGroupTopicConsumptionProperties == null ? other$kafkaConsumerGroupTopicConsumptionProperties != null : !((Object)this$kafkaConsumerGroupTopicConsumptionProperties).equals(other$kafkaConsumerGroupTopicConsumptionProperties)) {
            return false;
        }
        SortedSet<String> this$kafkaTopicNames = this.getKafkaTopicNames();
        SortedSet<String> other$kafkaTopicNames = other.getKafkaTopicNames();
        if (this$kafkaTopicNames == null ? other$kafkaTopicNames != null : !this$kafkaTopicNames.equals(other$kafkaTopicNames)) {
            return false;
        }
        SortedSet<String> this$kafkaTopicQualifiedNames = this.getKafkaTopicQualifiedNames();
        SortedSet<String> other$kafkaTopicQualifiedNames = other.getKafkaTopicQualifiedNames();
        if (this$kafkaTopicQualifiedNames == null ? other$kafkaTopicQualifiedNames != null : !this$kafkaTopicQualifiedNames.equals(other$kafkaTopicQualifiedNames)) {
            return false;
        }
        SortedSet<IKafkaTopic> this$kafkaTopics = this.getKafkaTopics();
        SortedSet<IKafkaTopic> other$kafkaTopics = other.getKafkaTopics();
        if (this$kafkaTopics == null ? other$kafkaTopics != null : !this$kafkaTopics.equals(other$kafkaTopics)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KafkaConsumerGroup;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $kafkaConsumerGroupMemberCount = this.getKafkaConsumerGroupMemberCount();
        result = result * 59 + ($kafkaConsumerGroupMemberCount == null ? 43 : ((Object)$kafkaConsumerGroupMemberCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        List<KafkaTopicConsumption> $kafkaConsumerGroupTopicConsumptionProperties = this.getKafkaConsumerGroupTopicConsumptionProperties();
        result = result * 59 + ($kafkaConsumerGroupTopicConsumptionProperties == null ? 43 : ((Object)$kafkaConsumerGroupTopicConsumptionProperties).hashCode());
        SortedSet<String> $kafkaTopicNames = this.getKafkaTopicNames();
        result = result * 59 + ($kafkaTopicNames == null ? 43 : $kafkaTopicNames.hashCode());
        SortedSet<String> $kafkaTopicQualifiedNames = this.getKafkaTopicQualifiedNames();
        result = result * 59 + ($kafkaTopicQualifiedNames == null ? 43 : $kafkaTopicQualifiedNames.hashCode());
        SortedSet<IKafkaTopic> $kafkaTopics = this.getKafkaTopics();
        result = result * 59 + ($kafkaTopics == null ? 43 : $kafkaTopics.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "KafkaConsumerGroup(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", kafkaConsumerGroupMemberCount=" + this.getKafkaConsumerGroupMemberCount() + ", kafkaConsumerGroupTopicConsumptionProperties=" + String.valueOf(this.getKafkaConsumerGroupTopicConsumptionProperties()) + ", kafkaTopicNames=" + String.valueOf(this.getKafkaTopicNames()) + ", kafkaTopicQualifiedNames=" + String.valueOf(this.getKafkaTopicQualifiedNames()) + ", kafkaTopics=" + String.valueOf(this.getKafkaTopics()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class KafkaConsumerGroupBuilder<C extends KafkaConsumerGroup, B extends KafkaConsumerGroupBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Long kafkaConsumerGroupMemberCount;
        @Generated
        private ArrayList<KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties;
        @Generated
        private ArrayList<String> kafkaTopicNames;
        @Generated
        private ArrayList<String> kafkaTopicQualifiedNames;
        @Generated
        private ArrayList<IKafkaTopic> kafkaTopics;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            KafkaConsumerGroupBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(KafkaConsumerGroup instance, KafkaConsumerGroupBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.kafkaConsumerGroupMemberCount(instance.kafkaConsumerGroupMemberCount);
            b.kafkaConsumerGroupTopicConsumptionProperties(instance.kafkaConsumerGroupTopicConsumptionProperties == null ? Collections.emptyList() : instance.kafkaConsumerGroupTopicConsumptionProperties);
            b.kafkaTopicNames(instance.kafkaTopicNames == null ? Collections.emptySortedSet() : instance.kafkaTopicNames);
            b.kafkaTopicQualifiedNames(instance.kafkaTopicQualifiedNames == null ? Collections.emptySortedSet() : instance.kafkaTopicQualifiedNames);
            b.kafkaTopics(instance.kafkaTopics == null ? Collections.emptySortedSet() : instance.kafkaTopics);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaConsumerGroupMemberCount(Long kafkaConsumerGroupMemberCount) {
            this.kafkaConsumerGroupMemberCount = kafkaConsumerGroupMemberCount;
            return (B)this.self();
        }

        @Generated
        public B kafkaConsumerGroupTopicConsumptionProperty(KafkaTopicConsumption kafkaConsumerGroupTopicConsumptionProperty) {
            if (this.kafkaConsumerGroupTopicConsumptionProperties == null) {
                this.kafkaConsumerGroupTopicConsumptionProperties = new ArrayList();
            }
            this.kafkaConsumerGroupTopicConsumptionProperties.add(kafkaConsumerGroupTopicConsumptionProperty);
            return (B)this.self();
        }

        @Generated
        public B kafkaConsumerGroupTopicConsumptionProperties(Collection<? extends KafkaTopicConsumption> kafkaConsumerGroupTopicConsumptionProperties) {
            if (kafkaConsumerGroupTopicConsumptionProperties == null) {
                throw new NullPointerException("kafkaConsumerGroupTopicConsumptionProperties cannot be null");
            }
            if (this.kafkaConsumerGroupTopicConsumptionProperties == null) {
                this.kafkaConsumerGroupTopicConsumptionProperties = new ArrayList();
            }
            this.kafkaConsumerGroupTopicConsumptionProperties.addAll(kafkaConsumerGroupTopicConsumptionProperties);
            return (B)this.self();
        }

        @Generated
        public B clearKafkaConsumerGroupTopicConsumptionProperties() {
            if (this.kafkaConsumerGroupTopicConsumptionProperties != null) {
                this.kafkaConsumerGroupTopicConsumptionProperties.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicName(String kafkaTopicName) {
            if (this.kafkaTopicNames == null) {
                this.kafkaTopicNames = new ArrayList();
            }
            this.kafkaTopicNames.add(kafkaTopicName);
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicNames(Collection<? extends String> kafkaTopicNames) {
            if (kafkaTopicNames == null) {
                throw new NullPointerException("kafkaTopicNames cannot be null");
            }
            if (this.kafkaTopicNames == null) {
                this.kafkaTopicNames = new ArrayList();
            }
            this.kafkaTopicNames.addAll(kafkaTopicNames);
            return (B)this.self();
        }

        @Generated
        public B clearKafkaTopicNames() {
            if (this.kafkaTopicNames != null) {
                this.kafkaTopicNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicQualifiedName(String kafkaTopicQualifiedName) {
            if (this.kafkaTopicQualifiedNames == null) {
                this.kafkaTopicQualifiedNames = new ArrayList();
            }
            this.kafkaTopicQualifiedNames.add(kafkaTopicQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B kafkaTopicQualifiedNames(Collection<? extends String> kafkaTopicQualifiedNames) {
            if (kafkaTopicQualifiedNames == null) {
                throw new NullPointerException("kafkaTopicQualifiedNames cannot be null");
            }
            if (this.kafkaTopicQualifiedNames == null) {
                this.kafkaTopicQualifiedNames = new ArrayList();
            }
            this.kafkaTopicQualifiedNames.addAll(kafkaTopicQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearKafkaTopicQualifiedNames() {
            if (this.kafkaTopicQualifiedNames != null) {
                this.kafkaTopicQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B kafkaTopic(IKafkaTopic kafkaTopic) {
            if (this.kafkaTopics == null) {
                this.kafkaTopics = new ArrayList();
            }
            this.kafkaTopics.add(kafkaTopic);
            return (B)this.self();
        }

        @Generated
        public B kafkaTopics(Collection<? extends IKafkaTopic> kafkaTopics) {
            if (kafkaTopics == null) {
                throw new NullPointerException("kafkaTopics cannot be null");
            }
            if (this.kafkaTopics == null) {
                this.kafkaTopics = new ArrayList();
            }
            this.kafkaTopics.addAll(kafkaTopics);
            return (B)this.self();
        }

        @Generated
        public B clearKafkaTopics() {
            if (this.kafkaTopics != null) {
                this.kafkaTopics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "KafkaConsumerGroup.KafkaConsumerGroupBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", kafkaConsumerGroupMemberCount=" + this.kafkaConsumerGroupMemberCount + ", kafkaConsumerGroupTopicConsumptionProperties=" + String.valueOf(this.kafkaConsumerGroupTopicConsumptionProperties) + ", kafkaTopicNames=" + String.valueOf(this.kafkaTopicNames) + ", kafkaTopicQualifiedNames=" + String.valueOf(this.kafkaTopicQualifiedNames) + ", kafkaTopics=" + String.valueOf(this.kafkaTopics) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class KafkaConsumerGroupBuilderImpl
    extends KafkaConsumerGroupBuilder<KafkaConsumerGroup, KafkaConsumerGroupBuilderImpl> {
        @Generated
        private KafkaConsumerGroupBuilderImpl() {
        }

        @Override
        @Generated
        protected KafkaConsumerGroupBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KafkaConsumerGroup build() {
            return new KafkaConsumerGroup(this);
        }
    }
}

