/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerDashboard;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerFolder;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.ILookerModel;
import com.atlan.model.assets.ILookerQuery;
import com.atlan.model.assets.ILookerTile;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerLook
extends Asset
implements ILookerLook,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerLook.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerLook";
    String typeName;
    @Attribute
    ILookerDashboard dashboard;
    @Attribute
    SortedSet<ILookerField> fields;
    @Attribute
    ILookerFolder folder;
    @Attribute
    String folderName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    String lookerSlug;
    @Attribute
    String lookerSourceQueryId;
    @Attribute
    ILookerModel model;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String modelName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ILookerQuery query;
    @Attribute
    Integer sourceContentMetadataId;
    @Attribute
    @Date
    Long sourceLastAccessedAt;
    @Attribute
    @Date
    Long sourceLastViewedAt;
    @Attribute
    Integer sourceQueryId;
    @Attribute
    Integer sourceUserId;
    @Attribute
    Integer sourceViewCount;
    @Attribute
    Integer sourcelastUpdaterId;
    @Attribute
    ILookerTile tile;

    @Override
    public LookerLook trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerLook.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerLook.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerLook.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerLook.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LookerLook refByGuid(String guid) {
        return LookerLook.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LookerLook refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LookerLookBuilder)((LookerLookBuilder)LookerLook._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LookerLook refByQualifiedName(String qualifiedName) {
        return LookerLook.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LookerLook refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LookerLookBuilder)((LookerLookBuilder)LookerLook._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id) throws AtlanException {
        return LookerLook.get(client, id, false);
    }

    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerLook) {
                return (LookerLook)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof LookerLook) {
            return (LookerLook)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return LookerLook.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static LookerLook get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerLook.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof LookerLook) {
                return (LookerLook)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)LookerLook.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof LookerLook) {
            return (LookerLook)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerLookBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerLookBuilder)((LookerLookBuilder)((LookerLookBuilder)LookerLook._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerLookBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        LookerLook.validateRequired(TYPE_NAME, map);
        return LookerLook.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerLook removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeDescription(client, LookerLook.updater(qualifiedName, name));
    }

    public static LookerLook removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeUserDescription(client, LookerLook.updater(qualifiedName, name));
    }

    public static LookerLook removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeOwners(client, LookerLook.updater(qualifiedName, name));
    }

    public static LookerLook updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerLook)Asset.updateCertificate(client, LookerLook._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerLook removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeCertificate(client, LookerLook.updater(qualifiedName, name));
    }

    public static LookerLook updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerLook)Asset.updateAnnouncement(client, LookerLook._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerLook removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeAnnouncement(client, LookerLook.updater(qualifiedName, name));
    }

    public static LookerLook replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.replaceTerms(client, LookerLook.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static LookerLook appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerLook removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static LookerLook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerLook)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static LookerLook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerLook)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerLook(LookerLookBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerLook.$default$typeName();
        this.dashboard = b.dashboard;
        SortedSet<ILookerField> fields = new TreeSet<ILookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.folder = b.folder;
        this.folderName = b.folderName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.lookerSlug = b.lookerSlug;
        this.lookerSourceQueryId = b.lookerSourceQueryId;
        this.model = b.model;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.modelName = b.modelName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.query = b.query;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceLastAccessedAt = b.sourceLastAccessedAt;
        this.sourceLastViewedAt = b.sourceLastViewedAt;
        this.sourceQueryId = b.sourceQueryId;
        this.sourceUserId = b.sourceUserId;
        this.sourceViewCount = b.sourceViewCount;
        this.sourcelastUpdaterId = b.sourcelastUpdaterId;
        this.tile = b.tile;
    }

    @Generated
    public static LookerLookBuilder<?, ?> _internal() {
        return new LookerLookBuilderImpl();
    }

    @Generated
    public LookerLookBuilder<?, ?> toBuilder() {
        return new LookerLookBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ILookerDashboard getDashboard() {
        return this.dashboard;
    }

    @Override
    @Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public ILookerFolder getFolder() {
        return this.folder;
    }

    @Override
    @Generated
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public String getLookerSlug() {
        return this.lookerSlug;
    }

    @Override
    @Generated
    public String getLookerSourceQueryId() {
        return this.lookerSourceQueryId;
    }

    @Override
    @Generated
    public ILookerModel getModel() {
        return this.model;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ILookerQuery getQuery() {
        return this.query;
    }

    @Override
    @Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    @Override
    @Generated
    public Long getSourceLastAccessedAt() {
        return this.sourceLastAccessedAt;
    }

    @Override
    @Generated
    public Long getSourceLastViewedAt() {
        return this.sourceLastViewedAt;
    }

    @Override
    @Generated
    public Integer getSourceQueryId() {
        return this.sourceQueryId;
    }

    @Override
    @Generated
    public Integer getSourceUserId() {
        return this.sourceUserId;
    }

    @Override
    @Generated
    public Integer getSourceViewCount() {
        return this.sourceViewCount;
    }

    @Override
    @Generated
    public Integer getSourcelastUpdaterId() {
        return this.sourcelastUpdaterId;
    }

    @Override
    @Generated
    public ILookerTile getTile() {
        return this.tile;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerLook)) {
            return false;
        }
        LookerLook other = (LookerLook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceContentMetadataId = this.getSourceContentMetadataId();
        Integer other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !((Object)this$sourceContentMetadataId).equals(other$sourceContentMetadataId)) {
            return false;
        }
        Long this$sourceLastAccessedAt = this.getSourceLastAccessedAt();
        Long other$sourceLastAccessedAt = other.getSourceLastAccessedAt();
        if (this$sourceLastAccessedAt == null ? other$sourceLastAccessedAt != null : !((Object)this$sourceLastAccessedAt).equals(other$sourceLastAccessedAt)) {
            return false;
        }
        Long this$sourceLastViewedAt = this.getSourceLastViewedAt();
        Long other$sourceLastViewedAt = other.getSourceLastViewedAt();
        if (this$sourceLastViewedAt == null ? other$sourceLastViewedAt != null : !((Object)this$sourceLastViewedAt).equals(other$sourceLastViewedAt)) {
            return false;
        }
        Integer this$sourceQueryId = this.getSourceQueryId();
        Integer other$sourceQueryId = other.getSourceQueryId();
        if (this$sourceQueryId == null ? other$sourceQueryId != null : !((Object)this$sourceQueryId).equals(other$sourceQueryId)) {
            return false;
        }
        Integer this$sourceUserId = this.getSourceUserId();
        Integer other$sourceUserId = other.getSourceUserId();
        if (this$sourceUserId == null ? other$sourceUserId != null : !((Object)this$sourceUserId).equals(other$sourceUserId)) {
            return false;
        }
        Integer this$sourceViewCount = this.getSourceViewCount();
        Integer other$sourceViewCount = other.getSourceViewCount();
        if (this$sourceViewCount == null ? other$sourceViewCount != null : !((Object)this$sourceViewCount).equals(other$sourceViewCount)) {
            return false;
        }
        Integer this$sourcelastUpdaterId = this.getSourcelastUpdaterId();
        Integer other$sourcelastUpdaterId = other.getSourcelastUpdaterId();
        if (this$sourcelastUpdaterId == null ? other$sourcelastUpdaterId != null : !((Object)this$sourcelastUpdaterId).equals(other$sourcelastUpdaterId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ILookerDashboard this$dashboard = this.getDashboard();
        ILookerDashboard other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) {
            return false;
        }
        SortedSet<ILookerField> this$fields = this.getFields();
        SortedSet<ILookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        ILookerFolder this$folder = this.getFolder();
        ILookerFolder other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !this$folder.equals(other$folder)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$lookerSlug = this.getLookerSlug();
        String other$lookerSlug = other.getLookerSlug();
        if (this$lookerSlug == null ? other$lookerSlug != null : !this$lookerSlug.equals(other$lookerSlug)) {
            return false;
        }
        String this$lookerSourceQueryId = this.getLookerSourceQueryId();
        String other$lookerSourceQueryId = other.getLookerSourceQueryId();
        if (this$lookerSourceQueryId == null ? other$lookerSourceQueryId != null : !this$lookerSourceQueryId.equals(other$lookerSourceQueryId)) {
            return false;
        }
        ILookerModel this$model = this.getModel();
        ILookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ILookerQuery this$query = this.getQuery();
        ILookerQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        ILookerTile this$tile = this.getTile();
        ILookerTile other$tile = other.getTile();
        return !(this$tile == null ? other$tile != null : !this$tile.equals(other$tile));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerLook;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * 59 + ($sourceContentMetadataId == null ? 43 : ((Object)$sourceContentMetadataId).hashCode());
        Long $sourceLastAccessedAt = this.getSourceLastAccessedAt();
        result = result * 59 + ($sourceLastAccessedAt == null ? 43 : ((Object)$sourceLastAccessedAt).hashCode());
        Long $sourceLastViewedAt = this.getSourceLastViewedAt();
        result = result * 59 + ($sourceLastViewedAt == null ? 43 : ((Object)$sourceLastViewedAt).hashCode());
        Integer $sourceQueryId = this.getSourceQueryId();
        result = result * 59 + ($sourceQueryId == null ? 43 : ((Object)$sourceQueryId).hashCode());
        Integer $sourceUserId = this.getSourceUserId();
        result = result * 59 + ($sourceUserId == null ? 43 : ((Object)$sourceUserId).hashCode());
        Integer $sourceViewCount = this.getSourceViewCount();
        result = result * 59 + ($sourceViewCount == null ? 43 : ((Object)$sourceViewCount).hashCode());
        Integer $sourcelastUpdaterId = this.getSourcelastUpdaterId();
        result = result * 59 + ($sourcelastUpdaterId == null ? 43 : ((Object)$sourcelastUpdaterId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ILookerDashboard $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        SortedSet<ILookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        ILookerFolder $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : $folder.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $lookerSlug = this.getLookerSlug();
        result = result * 59 + ($lookerSlug == null ? 43 : $lookerSlug.hashCode());
        String $lookerSourceQueryId = this.getLookerSourceQueryId();
        result = result * 59 + ($lookerSourceQueryId == null ? 43 : $lookerSourceQueryId.hashCode());
        ILookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ILookerQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        ILookerTile $tile = this.getTile();
        result = result * 59 + ($tile == null ? 43 : $tile.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerLook(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dashboard=" + String.valueOf(this.getDashboard()) + ", fields=" + String.valueOf(this.getFields()) + ", folder=" + String.valueOf(this.getFolder()) + ", folderName=" + this.getFolderName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", lookerSlug=" + this.getLookerSlug() + ", lookerSourceQueryId=" + this.getLookerSourceQueryId() + ", model=" + String.valueOf(this.getModel()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", modelName=" + this.getModelName() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", query=" + String.valueOf(this.getQuery()) + ", sourceContentMetadataId=" + this.getSourceContentMetadataId() + ", sourceLastAccessedAt=" + this.getSourceLastAccessedAt() + ", sourceLastViewedAt=" + this.getSourceLastViewedAt() + ", sourceQueryId=" + this.getSourceQueryId() + ", sourceUserId=" + this.getSourceUserId() + ", sourceViewCount=" + this.getSourceViewCount() + ", sourcelastUpdaterId=" + this.getSourcelastUpdaterId() + ", tile=" + String.valueOf(this.getTile()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class LookerLookBuilder<C extends LookerLook, B extends LookerLookBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ILookerDashboard dashboard;
        @Generated
        private ArrayList<ILookerField> fields;
        @Generated
        private ILookerFolder folder;
        @Generated
        private String folderName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private String lookerSlug;
        @Generated
        private String lookerSourceQueryId;
        @Generated
        private ILookerModel model;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String modelName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ILookerQuery query;
        @Generated
        private Integer sourceContentMetadataId;
        @Generated
        private Long sourceLastAccessedAt;
        @Generated
        private Long sourceLastViewedAt;
        @Generated
        private Integer sourceQueryId;
        @Generated
        private Integer sourceUserId;
        @Generated
        private Integer sourceViewCount;
        @Generated
        private Integer sourcelastUpdaterId;
        @Generated
        private ILookerTile tile;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerLookBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerLook instance, LookerLookBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dashboard(instance.dashboard);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.folder(instance.folder);
            b.folderName(instance.folderName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.lookerSlug(instance.lookerSlug);
            b.lookerSourceQueryId(instance.lookerSourceQueryId);
            b.model(instance.model);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.modelName(instance.modelName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.query(instance.query);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceLastAccessedAt(instance.sourceLastAccessedAt);
            b.sourceLastViewedAt(instance.sourceLastViewedAt);
            b.sourceQueryId(instance.sourceQueryId);
            b.sourceUserId(instance.sourceUserId);
            b.sourceViewCount(instance.sourceViewCount);
            b.sourcelastUpdaterId(instance.sourcelastUpdaterId);
            b.tile(instance.tile);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dashboard(ILookerDashboard dashboard) {
            this.dashboard = dashboard;
            return (B)this.self();
        }

        @Generated
        public B field(ILookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B folder(ILookerFolder folder) {
            this.folder = folder;
            return (B)this.self();
        }

        @Generated
        public B folderName(String folderName) {
            this.folderName = folderName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B lookerSlug(String lookerSlug) {
            this.lookerSlug = lookerSlug;
            return (B)this.self();
        }

        @Generated
        public B lookerSourceQueryId(String lookerSourceQueryId) {
            this.lookerSourceQueryId = lookerSourceQueryId;
            return (B)this.self();
        }

        @Generated
        public B model(ILookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B query(ILookerQuery query) {
            this.query = query;
            return (B)this.self();
        }

        @Generated
        public B sourceContentMetadataId(Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceLastAccessedAt(Long sourceLastAccessedAt) {
            this.sourceLastAccessedAt = sourceLastAccessedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceLastViewedAt(Long sourceLastViewedAt) {
            this.sourceLastViewedAt = sourceLastViewedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceQueryId(Integer sourceQueryId) {
            this.sourceQueryId = sourceQueryId;
            return (B)this.self();
        }

        @Generated
        public B sourceUserId(Integer sourceUserId) {
            this.sourceUserId = sourceUserId;
            return (B)this.self();
        }

        @Generated
        public B sourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return (B)this.self();
        }

        @Generated
        public B sourcelastUpdaterId(Integer sourcelastUpdaterId) {
            this.sourcelastUpdaterId = sourcelastUpdaterId;
            return (B)this.self();
        }

        @Generated
        public B tile(ILookerTile tile) {
            this.tile = tile;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerLook.LookerLookBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dashboard=" + String.valueOf(this.dashboard) + ", fields=" + String.valueOf(this.fields) + ", folder=" + String.valueOf(this.folder) + ", folderName=" + this.folderName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", lookerSlug=" + this.lookerSlug + ", lookerSourceQueryId=" + this.lookerSourceQueryId + ", model=" + String.valueOf(this.model) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", modelName=" + this.modelName + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", query=" + String.valueOf(this.query) + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceLastAccessedAt=" + this.sourceLastAccessedAt + ", sourceLastViewedAt=" + this.sourceLastViewedAt + ", sourceQueryId=" + this.sourceQueryId + ", sourceUserId=" + this.sourceUserId + ", sourceViewCount=" + this.sourceViewCount + ", sourcelastUpdaterId=" + this.sourcelastUpdaterId + ", tile=" + String.valueOf(this.tile) + ")";
        }
    }

    @Generated
    private static final class LookerLookBuilderImpl
    extends LookerLookBuilder<LookerLook, LookerLookBuilderImpl> {
        @Generated
        private LookerLookBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerLookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerLook build() {
            return new LookerLook(this);
        }
    }
}

