/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMetabase;
import com.atlan.model.assets.IMetabaseCollection;
import com.atlan.model.assets.IMetabaseDashboard;
import com.atlan.model.assets.IMetabaseQuestion;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetabaseQuestion
extends Asset
implements IMetabaseQuestion,
IMetabase,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetabaseQuestion.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseQuestion";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    IMetabaseCollection metabaseCollection;
    @Attribute
    String metabaseCollectionName;
    @Attribute
    String metabaseCollectionQualifiedName;
    @Attribute
    Long metabaseDashboardCount;
    @Attribute
    SortedSet<IMetabaseDashboard> metabaseDashboards;
    @Attribute
    String metabaseQuery;
    @Attribute
    String metabaseQueryType;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MetabaseQuestion trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MetabaseQuestion.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MetabaseQuestion.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MetabaseQuestion.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MetabaseQuestion.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MetabaseQuestion refByGuid(String guid) {
        return MetabaseQuestion.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MetabaseQuestion refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MetabaseQuestionBuilder)((MetabaseQuestionBuilder)MetabaseQuestion._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MetabaseQuestion refByQualifiedName(String qualifiedName) {
        return MetabaseQuestion.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MetabaseQuestion refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MetabaseQuestionBuilder)((MetabaseQuestionBuilder)MetabaseQuestion._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id) throws AtlanException {
        return MetabaseQuestion.get(client, id, false);
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MetabaseQuestion) {
                return (MetabaseQuestion)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof MetabaseQuestion) {
            return (MetabaseQuestion)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return MetabaseQuestion.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static MetabaseQuestion get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MetabaseQuestion.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof MetabaseQuestion) {
                return (MetabaseQuestion)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)MetabaseQuestion.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof MetabaseQuestion) {
            return (MetabaseQuestion)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MetabaseQuestionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseQuestionBuilder)((MetabaseQuestionBuilder)((MetabaseQuestionBuilder)MetabaseQuestion._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MetabaseQuestionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        MetabaseQuestion.validateRequired(TYPE_NAME, map);
        return MetabaseQuestion.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseQuestion removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeDescription(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeUserDescription(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeOwners(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateCertificate(client, MetabaseQuestion._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseQuestion removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeCertificate(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateAnnouncement(client, MetabaseQuestion._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseQuestion removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeAnnouncement(client, MetabaseQuestion.updater(qualifiedName, name));
    }

    public static MetabaseQuestion replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.replaceTerms(client, MetabaseQuestion.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static MetabaseQuestion appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MetabaseQuestion removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static MetabaseQuestion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MetabaseQuestion)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static MetabaseQuestion appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MetabaseQuestion)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseQuestion(MetabaseQuestionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseQuestion.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.metabaseCollection = b.metabaseCollection;
        this.metabaseCollectionName = b.metabaseCollectionName;
        this.metabaseCollectionQualifiedName = b.metabaseCollectionQualifiedName;
        this.metabaseDashboardCount = b.metabaseDashboardCount;
        SortedSet<IMetabaseDashboard> metabaseDashboards = new TreeSet<IMetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseQuery = b.metabaseQuery;
        this.metabaseQueryType = b.metabaseQueryType;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MetabaseQuestionBuilder<?, ?> _internal() {
        return new MetabaseQuestionBuilderImpl();
    }

    @Generated
    public MetabaseQuestionBuilder<?, ?> toBuilder() {
        return new MetabaseQuestionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public IMetabaseCollection getMetabaseCollection() {
        return this.metabaseCollection;
    }

    @Override
    @Generated
    public String getMetabaseCollectionName() {
        return this.metabaseCollectionName;
    }

    @Override
    @Generated
    public String getMetabaseCollectionQualifiedName() {
        return this.metabaseCollectionQualifiedName;
    }

    @Override
    @Generated
    public Long getMetabaseDashboardCount() {
        return this.metabaseDashboardCount;
    }

    @Override
    @Generated
    public SortedSet<IMetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Override
    @Generated
    public String getMetabaseQuery() {
        return this.metabaseQuery;
    }

    @Override
    @Generated
    public String getMetabaseQueryType() {
        return this.metabaseQueryType;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseQuestion)) {
            return false;
        }
        MetabaseQuestion other = (MetabaseQuestion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$metabaseDashboardCount = this.getMetabaseDashboardCount();
        Long other$metabaseDashboardCount = other.getMetabaseDashboardCount();
        if (this$metabaseDashboardCount == null ? other$metabaseDashboardCount != null : !((Object)this$metabaseDashboardCount).equals(other$metabaseDashboardCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        IMetabaseCollection this$metabaseCollection = this.getMetabaseCollection();
        IMetabaseCollection other$metabaseCollection = other.getMetabaseCollection();
        if (this$metabaseCollection == null ? other$metabaseCollection != null : !this$metabaseCollection.equals(other$metabaseCollection)) {
            return false;
        }
        String this$metabaseCollectionName = this.getMetabaseCollectionName();
        String other$metabaseCollectionName = other.getMetabaseCollectionName();
        if (this$metabaseCollectionName == null ? other$metabaseCollectionName != null : !this$metabaseCollectionName.equals(other$metabaseCollectionName)) {
            return false;
        }
        String this$metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        String other$metabaseCollectionQualifiedName = other.getMetabaseCollectionQualifiedName();
        if (this$metabaseCollectionQualifiedName == null ? other$metabaseCollectionQualifiedName != null : !this$metabaseCollectionQualifiedName.equals(other$metabaseCollectionQualifiedName)) {
            return false;
        }
        SortedSet<IMetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<IMetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        String this$metabaseQuery = this.getMetabaseQuery();
        String other$metabaseQuery = other.getMetabaseQuery();
        if (this$metabaseQuery == null ? other$metabaseQuery != null : !this$metabaseQuery.equals(other$metabaseQuery)) {
            return false;
        }
        String this$metabaseQueryType = this.getMetabaseQueryType();
        String other$metabaseQueryType = other.getMetabaseQueryType();
        if (this$metabaseQueryType == null ? other$metabaseQueryType != null : !this$metabaseQueryType.equals(other$metabaseQueryType)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseQuestion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $metabaseDashboardCount = this.getMetabaseDashboardCount();
        result = result * 59 + ($metabaseDashboardCount == null ? 43 : ((Object)$metabaseDashboardCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        IMetabaseCollection $metabaseCollection = this.getMetabaseCollection();
        result = result * 59 + ($metabaseCollection == null ? 43 : $metabaseCollection.hashCode());
        String $metabaseCollectionName = this.getMetabaseCollectionName();
        result = result * 59 + ($metabaseCollectionName == null ? 43 : $metabaseCollectionName.hashCode());
        String $metabaseCollectionQualifiedName = this.getMetabaseCollectionQualifiedName();
        result = result * 59 + ($metabaseCollectionQualifiedName == null ? 43 : $metabaseCollectionQualifiedName.hashCode());
        SortedSet<IMetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        String $metabaseQuery = this.getMetabaseQuery();
        result = result * 59 + ($metabaseQuery == null ? 43 : $metabaseQuery.hashCode());
        String $metabaseQueryType = this.getMetabaseQueryType();
        result = result * 59 + ($metabaseQueryType == null ? 43 : $metabaseQueryType.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MetabaseQuestion(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", metabaseCollection=" + String.valueOf(this.getMetabaseCollection()) + ", metabaseCollectionName=" + this.getMetabaseCollectionName() + ", metabaseCollectionQualifiedName=" + this.getMetabaseCollectionQualifiedName() + ", metabaseDashboardCount=" + this.getMetabaseDashboardCount() + ", metabaseDashboards=" + String.valueOf(this.getMetabaseDashboards()) + ", metabaseQuery=" + this.getMetabaseQuery() + ", metabaseQueryType=" + this.getMetabaseQueryType() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class MetabaseQuestionBuilder<C extends MetabaseQuestion, B extends MetabaseQuestionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private IMetabaseCollection metabaseCollection;
        @Generated
        private String metabaseCollectionName;
        @Generated
        private String metabaseCollectionQualifiedName;
        @Generated
        private Long metabaseDashboardCount;
        @Generated
        private ArrayList<IMetabaseDashboard> metabaseDashboards;
        @Generated
        private String metabaseQuery;
        @Generated
        private String metabaseQueryType;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseQuestionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseQuestion instance, MetabaseQuestionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.metabaseCollection(instance.metabaseCollection);
            b.metabaseCollectionName(instance.metabaseCollectionName);
            b.metabaseCollectionQualifiedName(instance.metabaseCollectionQualifiedName);
            b.metabaseDashboardCount(instance.metabaseDashboardCount);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseQuery(instance.metabaseQuery);
            b.metabaseQueryType(instance.metabaseQueryType);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollection(IMetabaseCollection metabaseCollection) {
            this.metabaseCollection = metabaseCollection;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionName(String metabaseCollectionName) {
            this.metabaseCollectionName = metabaseCollectionName;
            return (B)this.self();
        }

        @Generated
        public B metabaseCollectionQualifiedName(String metabaseCollectionQualifiedName) {
            this.metabaseCollectionQualifiedName = metabaseCollectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboardCount(Long metabaseDashboardCount) {
            this.metabaseDashboardCount = metabaseDashboardCount;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(IMetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends IMetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseQuery(String metabaseQuery) {
            this.metabaseQuery = metabaseQuery;
            return (B)this.self();
        }

        @Generated
        public B metabaseQueryType(String metabaseQueryType) {
            this.metabaseQueryType = metabaseQueryType;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MetabaseQuestion.MetabaseQuestionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", metabaseCollection=" + String.valueOf(this.metabaseCollection) + ", metabaseCollectionName=" + this.metabaseCollectionName + ", metabaseCollectionQualifiedName=" + this.metabaseCollectionQualifiedName + ", metabaseDashboardCount=" + this.metabaseDashboardCount + ", metabaseDashboards=" + String.valueOf(this.metabaseDashboards) + ", metabaseQuery=" + this.metabaseQuery + ", metabaseQueryType=" + this.metabaseQueryType + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class MetabaseQuestionBuilderImpl
    extends MetabaseQuestionBuilder<MetabaseQuestion, MetabaseQuestionBuilderImpl> {
        @Generated
        private MetabaseQuestionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseQuestionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseQuestion build() {
            return new MetabaseQuestion(this);
        }
    }
}

