/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModel;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IModelEntityAssociation;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ModelEntity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.ModelCardinalityType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEntityAssociation
extends Asset
implements IModelEntityAssociation,
IModel,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelEntityAssociation.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ModelEntityAssociation";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    @Date
    Long modelBusinessDate;
    @Attribute
    String modelDomain;
    @Attribute
    ModelCardinalityType modelEntityAssociationCardinality;
    @Attribute
    IModelEntity modelEntityAssociationFrom;
    @Attribute
    String modelEntityAssociationFromLabel;
    @Attribute
    Long modelEntityAssociationFromMaxCardinality;
    @Attribute
    Long modelEntityAssociationFromMinCardinality;
    @Attribute
    String modelEntityAssociationFromQualifiedName;
    @Attribute
    String modelEntityAssociationLabel;
    @Attribute
    IModelEntity modelEntityAssociationTo;
    @Attribute
    String modelEntityAssociationToLabel;
    @Attribute
    Long modelEntityAssociationToMaxCardinality;
    @Attribute
    Long modelEntityAssociationToMinCardinality;
    @Attribute
    String modelEntityAssociationToQualifiedName;
    @Attribute
    String modelEntityName;
    @Attribute
    String modelEntityQualifiedName;
    @Attribute
    @Date
    Long modelExpiredAtBusinessDate;
    @Attribute
    @Date
    Long modelExpiredAtSystemDate;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    String modelName;
    @Attribute
    String modelNamespace;
    @Attribute
    String modelQualifiedName;
    @Attribute
    @Date
    Long modelSystemDate;
    @Attribute
    String modelType;
    @Attribute
    String modelVersionAgnosticQualifiedName;
    @Attribute
    String modelVersionName;
    @Attribute
    String modelVersionQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public ModelEntityAssociation trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ModelEntityAssociation.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ModelEntityAssociation.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ModelEntityAssociation.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ModelEntityAssociation.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ModelEntityAssociation refByGuid(String guid) {
        return ModelEntityAssociation.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ModelEntityAssociation refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)ModelEntityAssociation._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ModelEntityAssociation refByQualifiedName(String qualifiedName) {
        return ModelEntityAssociation.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ModelEntityAssociation refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)ModelEntityAssociation._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ModelEntityAssociation get(AtlanClient client, String id) throws AtlanException {
        return ModelEntityAssociation.get(client, id, false);
    }

    @JsonIgnore
    public static ModelEntityAssociation get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ModelEntityAssociation) {
                return (ModelEntityAssociation)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof ModelEntityAssociation) {
            return (ModelEntityAssociation)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static ModelEntityAssociation get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return ModelEntityAssociation.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static ModelEntityAssociation get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModelEntityAssociation.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof ModelEntityAssociation) {
                return (ModelEntityAssociation)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)ModelEntityAssociation.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof ModelEntityAssociation) {
            return (ModelEntityAssociation)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ModelEntityAssociationBuilder<?, ?> creator(String name, ModelEntity from, ModelEntity to) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("from_connectionQualifiedName", from.getConnectionQualifiedName());
        map.put("from_qualifiedName", from.getModelVersionAgnosticQualifiedName());
        map.put("to_qualifiedName", to.getModelVersionAgnosticQualifiedName());
        ModelEntityAssociation.validateRelationship("ModelEntity", map);
        return ((ModelEntityAssociationBuilder)ModelEntityAssociation.creator(name, from.getConnectionQualifiedName(), from.getModelVersionAgnosticQualifiedName(), to.getModelVersionAgnosticQualifiedName()).modelEntityAssociationFrom(from.trimToReference())).modelEntityAssociationTo(to.trimToReference());
    }

    public static ModelEntityAssociationBuilder<?, ?> creator(String name, String fromQualifiedName, String toQualifiedName) {
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(fromQualifiedName);
        return ModelEntityAssociation.creator(name, connectionQualifiedName, fromQualifiedName, toQualifiedName);
    }

    public static ModelEntityAssociationBuilder<?, ?> creator(String name, String connectionQualifiedName, String fromQualifiedName, String toQualifiedName) {
        String qualifiedName = ModelEntityAssociation.generateQualifiedName(name, fromQualifiedName, toQualifiedName);
        String modelQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(fromQualifiedName);
        String modelName = IModel.getNameFromSlug(StringUtils.getNameFromQualifiedName(modelQualifiedName));
        return ((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((Asset.AssetBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)ModelEntityAssociation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(qualifiedName)).modelVersionAgnosticQualifiedName(qualifiedName)).connectionQualifiedName(connectionQualifiedName)).modelName(modelName)).modelQualifiedName(modelQualifiedName)).modelEntityAssociationFrom(ModelEntity.refByQualifiedName(fromQualifiedName))).modelEntityAssociationFromQualifiedName(fromQualifiedName)).modelEntityAssociationTo(ModelEntity.refByQualifiedName(toQualifiedName))).modelEntityAssociationToQualifiedName(toQualifiedName)).modelEntityAssociationLabel(name);
    }

    public static ModelEntityAssociationBuilder<?, ?> updater(String versionAgnosticQualifiedName, String name) {
        return (ModelEntityAssociationBuilder)((Asset.AssetBuilder)((ModelEntityAssociationBuilder)ModelEntityAssociation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).modelVersionAgnosticQualifiedName(versionAgnosticQualifiedName)).name(name);
    }

    public static ModelEntityAssociationBuilder<?, ?> updaterForVersion(String qualifiedName, String name) {
        return (ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)((ModelEntityAssociationBuilder)ModelEntityAssociation._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public static String generateQualifiedName(String name, String fromQualifiedName, String toQualifiedName) {
        return fromQualifiedName + "<<" + name + ">>" + toQualifiedName;
    }

    public ModelEntityAssociationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modelVersionAgnosticQualifiedName", this.getModelVersionAgnosticQualifiedName());
        map.put("name", this.getName());
        ModelEntityAssociation.validateRequired(TYPE_NAME, map);
        return ModelEntityAssociation.updater(this.getModelVersionAgnosticQualifiedName(), this.getName());
    }

    public static ModelEntityAssociation removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeDescription(client, ModelEntityAssociation.updater(qualifiedName, name));
    }

    public static ModelEntityAssociation removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeUserDescription(client, ModelEntityAssociation.updater(qualifiedName, name));
    }

    public static ModelEntityAssociation removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeOwners(client, ModelEntityAssociation.updater(qualifiedName, name));
    }

    public static ModelEntityAssociation updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ModelEntityAssociation)Asset.updateCertificate(client, ModelEntityAssociation._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ModelEntityAssociation removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeCertificate(client, ModelEntityAssociation.updater(qualifiedName, name));
    }

    public static ModelEntityAssociation updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ModelEntityAssociation)Asset.updateAnnouncement(client, ModelEntityAssociation._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ModelEntityAssociation removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeAnnouncement(client, ModelEntityAssociation.updater(qualifiedName, name));
    }

    public static ModelEntityAssociation replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntityAssociation)Asset.replaceTerms(client, ModelEntityAssociation.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static ModelEntityAssociation appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntityAssociation)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ModelEntityAssociation removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ModelEntityAssociation)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static ModelEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ModelEntityAssociation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static ModelEntityAssociation appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ModelEntityAssociation)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ModelEntityAssociation(ModelEntityAssociationBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ModelEntityAssociation.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.modelBusinessDate = b.modelBusinessDate;
        this.modelDomain = b.modelDomain;
        this.modelEntityAssociationCardinality = b.modelEntityAssociationCardinality;
        this.modelEntityAssociationFrom = b.modelEntityAssociationFrom;
        this.modelEntityAssociationFromLabel = b.modelEntityAssociationFromLabel;
        this.modelEntityAssociationFromMaxCardinality = b.modelEntityAssociationFromMaxCardinality;
        this.modelEntityAssociationFromMinCardinality = b.modelEntityAssociationFromMinCardinality;
        this.modelEntityAssociationFromQualifiedName = b.modelEntityAssociationFromQualifiedName;
        this.modelEntityAssociationLabel = b.modelEntityAssociationLabel;
        this.modelEntityAssociationTo = b.modelEntityAssociationTo;
        this.modelEntityAssociationToLabel = b.modelEntityAssociationToLabel;
        this.modelEntityAssociationToMaxCardinality = b.modelEntityAssociationToMaxCardinality;
        this.modelEntityAssociationToMinCardinality = b.modelEntityAssociationToMinCardinality;
        this.modelEntityAssociationToQualifiedName = b.modelEntityAssociationToQualifiedName;
        this.modelEntityName = b.modelEntityName;
        this.modelEntityQualifiedName = b.modelEntityQualifiedName;
        this.modelExpiredAtBusinessDate = b.modelExpiredAtBusinessDate;
        this.modelExpiredAtSystemDate = b.modelExpiredAtSystemDate;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        this.modelName = b.modelName;
        this.modelNamespace = b.modelNamespace;
        this.modelQualifiedName = b.modelQualifiedName;
        this.modelSystemDate = b.modelSystemDate;
        this.modelType = b.modelType;
        this.modelVersionAgnosticQualifiedName = b.modelVersionAgnosticQualifiedName;
        this.modelVersionName = b.modelVersionName;
        this.modelVersionQualifiedName = b.modelVersionQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static ModelEntityAssociationBuilder<?, ?> _internal() {
        return new ModelEntityAssociationBuilderImpl();
    }

    @Generated
    public ModelEntityAssociationBuilder<?, ?> toBuilder() {
        return new ModelEntityAssociationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Long getModelBusinessDate() {
        return this.modelBusinessDate;
    }

    @Override
    @Generated
    public String getModelDomain() {
        return this.modelDomain;
    }

    @Override
    @Generated
    public ModelCardinalityType getModelEntityAssociationCardinality() {
        return this.modelEntityAssociationCardinality;
    }

    @Override
    @Generated
    public IModelEntity getModelEntityAssociationFrom() {
        return this.modelEntityAssociationFrom;
    }

    @Override
    @Generated
    public String getModelEntityAssociationFromLabel() {
        return this.modelEntityAssociationFromLabel;
    }

    @Override
    @Generated
    public Long getModelEntityAssociationFromMaxCardinality() {
        return this.modelEntityAssociationFromMaxCardinality;
    }

    @Override
    @Generated
    public Long getModelEntityAssociationFromMinCardinality() {
        return this.modelEntityAssociationFromMinCardinality;
    }

    @Override
    @Generated
    public String getModelEntityAssociationFromQualifiedName() {
        return this.modelEntityAssociationFromQualifiedName;
    }

    @Override
    @Generated
    public String getModelEntityAssociationLabel() {
        return this.modelEntityAssociationLabel;
    }

    @Override
    @Generated
    public IModelEntity getModelEntityAssociationTo() {
        return this.modelEntityAssociationTo;
    }

    @Override
    @Generated
    public String getModelEntityAssociationToLabel() {
        return this.modelEntityAssociationToLabel;
    }

    @Override
    @Generated
    public Long getModelEntityAssociationToMaxCardinality() {
        return this.modelEntityAssociationToMaxCardinality;
    }

    @Override
    @Generated
    public Long getModelEntityAssociationToMinCardinality() {
        return this.modelEntityAssociationToMinCardinality;
    }

    @Override
    @Generated
    public String getModelEntityAssociationToQualifiedName() {
        return this.modelEntityAssociationToQualifiedName;
    }

    @Override
    @Generated
    public String getModelEntityName() {
        return this.modelEntityName;
    }

    @Override
    @Generated
    public String getModelEntityQualifiedName() {
        return this.modelEntityQualifiedName;
    }

    @Override
    @Generated
    public Long getModelExpiredAtBusinessDate() {
        return this.modelExpiredAtBusinessDate;
    }

    @Override
    @Generated
    public Long getModelExpiredAtSystemDate() {
        return this.modelExpiredAtSystemDate;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Override
    @Generated
    public String getModelNamespace() {
        return this.modelNamespace;
    }

    @Override
    @Generated
    public String getModelQualifiedName() {
        return this.modelQualifiedName;
    }

    @Override
    @Generated
    public Long getModelSystemDate() {
        return this.modelSystemDate;
    }

    @Override
    @Generated
    public String getModelType() {
        return this.modelType;
    }

    @Override
    @Generated
    public String getModelVersionAgnosticQualifiedName() {
        return this.modelVersionAgnosticQualifiedName;
    }

    @Override
    @Generated
    public String getModelVersionName() {
        return this.modelVersionName;
    }

    @Override
    @Generated
    public String getModelVersionQualifiedName() {
        return this.modelVersionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelEntityAssociation)) {
            return false;
        }
        ModelEntityAssociation other = (ModelEntityAssociation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$modelBusinessDate = this.getModelBusinessDate();
        Long other$modelBusinessDate = other.getModelBusinessDate();
        if (this$modelBusinessDate == null ? other$modelBusinessDate != null : !((Object)this$modelBusinessDate).equals(other$modelBusinessDate)) {
            return false;
        }
        Long this$modelEntityAssociationFromMaxCardinality = this.getModelEntityAssociationFromMaxCardinality();
        Long other$modelEntityAssociationFromMaxCardinality = other.getModelEntityAssociationFromMaxCardinality();
        if (this$modelEntityAssociationFromMaxCardinality == null ? other$modelEntityAssociationFromMaxCardinality != null : !((Object)this$modelEntityAssociationFromMaxCardinality).equals(other$modelEntityAssociationFromMaxCardinality)) {
            return false;
        }
        Long this$modelEntityAssociationFromMinCardinality = this.getModelEntityAssociationFromMinCardinality();
        Long other$modelEntityAssociationFromMinCardinality = other.getModelEntityAssociationFromMinCardinality();
        if (this$modelEntityAssociationFromMinCardinality == null ? other$modelEntityAssociationFromMinCardinality != null : !((Object)this$modelEntityAssociationFromMinCardinality).equals(other$modelEntityAssociationFromMinCardinality)) {
            return false;
        }
        Long this$modelEntityAssociationToMaxCardinality = this.getModelEntityAssociationToMaxCardinality();
        Long other$modelEntityAssociationToMaxCardinality = other.getModelEntityAssociationToMaxCardinality();
        if (this$modelEntityAssociationToMaxCardinality == null ? other$modelEntityAssociationToMaxCardinality != null : !((Object)this$modelEntityAssociationToMaxCardinality).equals(other$modelEntityAssociationToMaxCardinality)) {
            return false;
        }
        Long this$modelEntityAssociationToMinCardinality = this.getModelEntityAssociationToMinCardinality();
        Long other$modelEntityAssociationToMinCardinality = other.getModelEntityAssociationToMinCardinality();
        if (this$modelEntityAssociationToMinCardinality == null ? other$modelEntityAssociationToMinCardinality != null : !((Object)this$modelEntityAssociationToMinCardinality).equals(other$modelEntityAssociationToMinCardinality)) {
            return false;
        }
        Long this$modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        Long other$modelExpiredAtBusinessDate = other.getModelExpiredAtBusinessDate();
        if (this$modelExpiredAtBusinessDate == null ? other$modelExpiredAtBusinessDate != null : !((Object)this$modelExpiredAtBusinessDate).equals(other$modelExpiredAtBusinessDate)) {
            return false;
        }
        Long this$modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        Long other$modelExpiredAtSystemDate = other.getModelExpiredAtSystemDate();
        if (this$modelExpiredAtSystemDate == null ? other$modelExpiredAtSystemDate != null : !((Object)this$modelExpiredAtSystemDate).equals(other$modelExpiredAtSystemDate)) {
            return false;
        }
        Long this$modelSystemDate = this.getModelSystemDate();
        Long other$modelSystemDate = other.getModelSystemDate();
        if (this$modelSystemDate == null ? other$modelSystemDate != null : !((Object)this$modelSystemDate).equals(other$modelSystemDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$modelDomain = this.getModelDomain();
        String other$modelDomain = other.getModelDomain();
        if (this$modelDomain == null ? other$modelDomain != null : !this$modelDomain.equals(other$modelDomain)) {
            return false;
        }
        ModelCardinalityType this$modelEntityAssociationCardinality = this.getModelEntityAssociationCardinality();
        ModelCardinalityType other$modelEntityAssociationCardinality = other.getModelEntityAssociationCardinality();
        if (this$modelEntityAssociationCardinality == null ? other$modelEntityAssociationCardinality != null : !this$modelEntityAssociationCardinality.equals(other$modelEntityAssociationCardinality)) {
            return false;
        }
        IModelEntity this$modelEntityAssociationFrom = this.getModelEntityAssociationFrom();
        IModelEntity other$modelEntityAssociationFrom = other.getModelEntityAssociationFrom();
        if (this$modelEntityAssociationFrom == null ? other$modelEntityAssociationFrom != null : !this$modelEntityAssociationFrom.equals(other$modelEntityAssociationFrom)) {
            return false;
        }
        String this$modelEntityAssociationFromLabel = this.getModelEntityAssociationFromLabel();
        String other$modelEntityAssociationFromLabel = other.getModelEntityAssociationFromLabel();
        if (this$modelEntityAssociationFromLabel == null ? other$modelEntityAssociationFromLabel != null : !this$modelEntityAssociationFromLabel.equals(other$modelEntityAssociationFromLabel)) {
            return false;
        }
        String this$modelEntityAssociationFromQualifiedName = this.getModelEntityAssociationFromQualifiedName();
        String other$modelEntityAssociationFromQualifiedName = other.getModelEntityAssociationFromQualifiedName();
        if (this$modelEntityAssociationFromQualifiedName == null ? other$modelEntityAssociationFromQualifiedName != null : !this$modelEntityAssociationFromQualifiedName.equals(other$modelEntityAssociationFromQualifiedName)) {
            return false;
        }
        String this$modelEntityAssociationLabel = this.getModelEntityAssociationLabel();
        String other$modelEntityAssociationLabel = other.getModelEntityAssociationLabel();
        if (this$modelEntityAssociationLabel == null ? other$modelEntityAssociationLabel != null : !this$modelEntityAssociationLabel.equals(other$modelEntityAssociationLabel)) {
            return false;
        }
        IModelEntity this$modelEntityAssociationTo = this.getModelEntityAssociationTo();
        IModelEntity other$modelEntityAssociationTo = other.getModelEntityAssociationTo();
        if (this$modelEntityAssociationTo == null ? other$modelEntityAssociationTo != null : !this$modelEntityAssociationTo.equals(other$modelEntityAssociationTo)) {
            return false;
        }
        String this$modelEntityAssociationToLabel = this.getModelEntityAssociationToLabel();
        String other$modelEntityAssociationToLabel = other.getModelEntityAssociationToLabel();
        if (this$modelEntityAssociationToLabel == null ? other$modelEntityAssociationToLabel != null : !this$modelEntityAssociationToLabel.equals(other$modelEntityAssociationToLabel)) {
            return false;
        }
        String this$modelEntityAssociationToQualifiedName = this.getModelEntityAssociationToQualifiedName();
        String other$modelEntityAssociationToQualifiedName = other.getModelEntityAssociationToQualifiedName();
        if (this$modelEntityAssociationToQualifiedName == null ? other$modelEntityAssociationToQualifiedName != null : !this$modelEntityAssociationToQualifiedName.equals(other$modelEntityAssociationToQualifiedName)) {
            return false;
        }
        String this$modelEntityName = this.getModelEntityName();
        String other$modelEntityName = other.getModelEntityName();
        if (this$modelEntityName == null ? other$modelEntityName != null : !this$modelEntityName.equals(other$modelEntityName)) {
            return false;
        }
        String this$modelEntityQualifiedName = this.getModelEntityQualifiedName();
        String other$modelEntityQualifiedName = other.getModelEntityQualifiedName();
        if (this$modelEntityQualifiedName == null ? other$modelEntityQualifiedName != null : !this$modelEntityQualifiedName.equals(other$modelEntityQualifiedName)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$modelNamespace = this.getModelNamespace();
        String other$modelNamespace = other.getModelNamespace();
        if (this$modelNamespace == null ? other$modelNamespace != null : !this$modelNamespace.equals(other$modelNamespace)) {
            return false;
        }
        String this$modelQualifiedName = this.getModelQualifiedName();
        String other$modelQualifiedName = other.getModelQualifiedName();
        if (this$modelQualifiedName == null ? other$modelQualifiedName != null : !this$modelQualifiedName.equals(other$modelQualifiedName)) {
            return false;
        }
        String this$modelType = this.getModelType();
        String other$modelType = other.getModelType();
        if (this$modelType == null ? other$modelType != null : !this$modelType.equals(other$modelType)) {
            return false;
        }
        String this$modelVersionAgnosticQualifiedName = this.getModelVersionAgnosticQualifiedName();
        String other$modelVersionAgnosticQualifiedName = other.getModelVersionAgnosticQualifiedName();
        if (this$modelVersionAgnosticQualifiedName == null ? other$modelVersionAgnosticQualifiedName != null : !this$modelVersionAgnosticQualifiedName.equals(other$modelVersionAgnosticQualifiedName)) {
            return false;
        }
        String this$modelVersionName = this.getModelVersionName();
        String other$modelVersionName = other.getModelVersionName();
        if (this$modelVersionName == null ? other$modelVersionName != null : !this$modelVersionName.equals(other$modelVersionName)) {
            return false;
        }
        String this$modelVersionQualifiedName = this.getModelVersionQualifiedName();
        String other$modelVersionQualifiedName = other.getModelVersionQualifiedName();
        if (this$modelVersionQualifiedName == null ? other$modelVersionQualifiedName != null : !this$modelVersionQualifiedName.equals(other$modelVersionQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelEntityAssociation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $modelBusinessDate = this.getModelBusinessDate();
        result = result * 59 + ($modelBusinessDate == null ? 43 : ((Object)$modelBusinessDate).hashCode());
        Long $modelEntityAssociationFromMaxCardinality = this.getModelEntityAssociationFromMaxCardinality();
        result = result * 59 + ($modelEntityAssociationFromMaxCardinality == null ? 43 : ((Object)$modelEntityAssociationFromMaxCardinality).hashCode());
        Long $modelEntityAssociationFromMinCardinality = this.getModelEntityAssociationFromMinCardinality();
        result = result * 59 + ($modelEntityAssociationFromMinCardinality == null ? 43 : ((Object)$modelEntityAssociationFromMinCardinality).hashCode());
        Long $modelEntityAssociationToMaxCardinality = this.getModelEntityAssociationToMaxCardinality();
        result = result * 59 + ($modelEntityAssociationToMaxCardinality == null ? 43 : ((Object)$modelEntityAssociationToMaxCardinality).hashCode());
        Long $modelEntityAssociationToMinCardinality = this.getModelEntityAssociationToMinCardinality();
        result = result * 59 + ($modelEntityAssociationToMinCardinality == null ? 43 : ((Object)$modelEntityAssociationToMinCardinality).hashCode());
        Long $modelExpiredAtBusinessDate = this.getModelExpiredAtBusinessDate();
        result = result * 59 + ($modelExpiredAtBusinessDate == null ? 43 : ((Object)$modelExpiredAtBusinessDate).hashCode());
        Long $modelExpiredAtSystemDate = this.getModelExpiredAtSystemDate();
        result = result * 59 + ($modelExpiredAtSystemDate == null ? 43 : ((Object)$modelExpiredAtSystemDate).hashCode());
        Long $modelSystemDate = this.getModelSystemDate();
        result = result * 59 + ($modelSystemDate == null ? 43 : ((Object)$modelSystemDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $modelDomain = this.getModelDomain();
        result = result * 59 + ($modelDomain == null ? 43 : $modelDomain.hashCode());
        ModelCardinalityType $modelEntityAssociationCardinality = this.getModelEntityAssociationCardinality();
        result = result * 59 + ($modelEntityAssociationCardinality == null ? 43 : $modelEntityAssociationCardinality.hashCode());
        IModelEntity $modelEntityAssociationFrom = this.getModelEntityAssociationFrom();
        result = result * 59 + ($modelEntityAssociationFrom == null ? 43 : $modelEntityAssociationFrom.hashCode());
        String $modelEntityAssociationFromLabel = this.getModelEntityAssociationFromLabel();
        result = result * 59 + ($modelEntityAssociationFromLabel == null ? 43 : $modelEntityAssociationFromLabel.hashCode());
        String $modelEntityAssociationFromQualifiedName = this.getModelEntityAssociationFromQualifiedName();
        result = result * 59 + ($modelEntityAssociationFromQualifiedName == null ? 43 : $modelEntityAssociationFromQualifiedName.hashCode());
        String $modelEntityAssociationLabel = this.getModelEntityAssociationLabel();
        result = result * 59 + ($modelEntityAssociationLabel == null ? 43 : $modelEntityAssociationLabel.hashCode());
        IModelEntity $modelEntityAssociationTo = this.getModelEntityAssociationTo();
        result = result * 59 + ($modelEntityAssociationTo == null ? 43 : $modelEntityAssociationTo.hashCode());
        String $modelEntityAssociationToLabel = this.getModelEntityAssociationToLabel();
        result = result * 59 + ($modelEntityAssociationToLabel == null ? 43 : $modelEntityAssociationToLabel.hashCode());
        String $modelEntityAssociationToQualifiedName = this.getModelEntityAssociationToQualifiedName();
        result = result * 59 + ($modelEntityAssociationToQualifiedName == null ? 43 : $modelEntityAssociationToQualifiedName.hashCode());
        String $modelEntityName = this.getModelEntityName();
        result = result * 59 + ($modelEntityName == null ? 43 : $modelEntityName.hashCode());
        String $modelEntityQualifiedName = this.getModelEntityQualifiedName();
        result = result * 59 + ($modelEntityQualifiedName == null ? 43 : $modelEntityQualifiedName.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $modelNamespace = this.getModelNamespace();
        result = result * 59 + ($modelNamespace == null ? 43 : $modelNamespace.hashCode());
        String $modelQualifiedName = this.getModelQualifiedName();
        result = result * 59 + ($modelQualifiedName == null ? 43 : $modelQualifiedName.hashCode());
        String $modelType = this.getModelType();
        result = result * 59 + ($modelType == null ? 43 : $modelType.hashCode());
        String $modelVersionAgnosticQualifiedName = this.getModelVersionAgnosticQualifiedName();
        result = result * 59 + ($modelVersionAgnosticQualifiedName == null ? 43 : $modelVersionAgnosticQualifiedName.hashCode());
        String $modelVersionName = this.getModelVersionName();
        result = result * 59 + ($modelVersionName == null ? 43 : $modelVersionName.hashCode());
        String $modelVersionQualifiedName = this.getModelVersionQualifiedName();
        result = result * 59 + ($modelVersionQualifiedName == null ? 43 : $modelVersionQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ModelEntityAssociation(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelBusinessDate=" + this.getModelBusinessDate() + ", modelDomain=" + this.getModelDomain() + ", modelEntityAssociationCardinality=" + String.valueOf(this.getModelEntityAssociationCardinality()) + ", modelEntityAssociationFrom=" + String.valueOf(this.getModelEntityAssociationFrom()) + ", modelEntityAssociationFromLabel=" + this.getModelEntityAssociationFromLabel() + ", modelEntityAssociationFromMaxCardinality=" + this.getModelEntityAssociationFromMaxCardinality() + ", modelEntityAssociationFromMinCardinality=" + this.getModelEntityAssociationFromMinCardinality() + ", modelEntityAssociationFromQualifiedName=" + this.getModelEntityAssociationFromQualifiedName() + ", modelEntityAssociationLabel=" + this.getModelEntityAssociationLabel() + ", modelEntityAssociationTo=" + String.valueOf(this.getModelEntityAssociationTo()) + ", modelEntityAssociationToLabel=" + this.getModelEntityAssociationToLabel() + ", modelEntityAssociationToMaxCardinality=" + this.getModelEntityAssociationToMaxCardinality() + ", modelEntityAssociationToMinCardinality=" + this.getModelEntityAssociationToMinCardinality() + ", modelEntityAssociationToQualifiedName=" + this.getModelEntityAssociationToQualifiedName() + ", modelEntityName=" + this.getModelEntityName() + ", modelEntityQualifiedName=" + this.getModelEntityQualifiedName() + ", modelExpiredAtBusinessDate=" + this.getModelExpiredAtBusinessDate() + ", modelExpiredAtSystemDate=" + this.getModelExpiredAtSystemDate() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", modelName=" + this.getModelName() + ", modelNamespace=" + this.getModelNamespace() + ", modelQualifiedName=" + this.getModelQualifiedName() + ", modelSystemDate=" + this.getModelSystemDate() + ", modelType=" + this.getModelType() + ", modelVersionAgnosticQualifiedName=" + this.getModelVersionAgnosticQualifiedName() + ", modelVersionName=" + this.getModelVersionName() + ", modelVersionQualifiedName=" + this.getModelVersionQualifiedName() + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class ModelEntityAssociationBuilder<C extends ModelEntityAssociation, B extends ModelEntityAssociationBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Long modelBusinessDate;
        @Generated
        private String modelDomain;
        @Generated
        private ModelCardinalityType modelEntityAssociationCardinality;
        @Generated
        private IModelEntity modelEntityAssociationFrom;
        @Generated
        private String modelEntityAssociationFromLabel;
        @Generated
        private Long modelEntityAssociationFromMaxCardinality;
        @Generated
        private Long modelEntityAssociationFromMinCardinality;
        @Generated
        private String modelEntityAssociationFromQualifiedName;
        @Generated
        private String modelEntityAssociationLabel;
        @Generated
        private IModelEntity modelEntityAssociationTo;
        @Generated
        private String modelEntityAssociationToLabel;
        @Generated
        private Long modelEntityAssociationToMaxCardinality;
        @Generated
        private Long modelEntityAssociationToMinCardinality;
        @Generated
        private String modelEntityAssociationToQualifiedName;
        @Generated
        private String modelEntityName;
        @Generated
        private String modelEntityQualifiedName;
        @Generated
        private Long modelExpiredAtBusinessDate;
        @Generated
        private Long modelExpiredAtSystemDate;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private String modelName;
        @Generated
        private String modelNamespace;
        @Generated
        private String modelQualifiedName;
        @Generated
        private Long modelSystemDate;
        @Generated
        private String modelType;
        @Generated
        private String modelVersionAgnosticQualifiedName;
        @Generated
        private String modelVersionName;
        @Generated
        private String modelVersionQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModelEntityAssociationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ModelEntityAssociation instance, ModelEntityAssociationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelBusinessDate(instance.modelBusinessDate);
            b.modelDomain(instance.modelDomain);
            b.modelEntityAssociationCardinality(instance.modelEntityAssociationCardinality);
            b.modelEntityAssociationFrom(instance.modelEntityAssociationFrom);
            b.modelEntityAssociationFromLabel(instance.modelEntityAssociationFromLabel);
            b.modelEntityAssociationFromMaxCardinality(instance.modelEntityAssociationFromMaxCardinality);
            b.modelEntityAssociationFromMinCardinality(instance.modelEntityAssociationFromMinCardinality);
            b.modelEntityAssociationFromQualifiedName(instance.modelEntityAssociationFromQualifiedName);
            b.modelEntityAssociationLabel(instance.modelEntityAssociationLabel);
            b.modelEntityAssociationTo(instance.modelEntityAssociationTo);
            b.modelEntityAssociationToLabel(instance.modelEntityAssociationToLabel);
            b.modelEntityAssociationToMaxCardinality(instance.modelEntityAssociationToMaxCardinality);
            b.modelEntityAssociationToMinCardinality(instance.modelEntityAssociationToMinCardinality);
            b.modelEntityAssociationToQualifiedName(instance.modelEntityAssociationToQualifiedName);
            b.modelEntityName(instance.modelEntityName);
            b.modelEntityQualifiedName(instance.modelEntityQualifiedName);
            b.modelExpiredAtBusinessDate(instance.modelExpiredAtBusinessDate);
            b.modelExpiredAtSystemDate(instance.modelExpiredAtSystemDate);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.modelName(instance.modelName);
            b.modelNamespace(instance.modelNamespace);
            b.modelQualifiedName(instance.modelQualifiedName);
            b.modelSystemDate(instance.modelSystemDate);
            b.modelType(instance.modelType);
            b.modelVersionAgnosticQualifiedName(instance.modelVersionAgnosticQualifiedName);
            b.modelVersionName(instance.modelVersionName);
            b.modelVersionQualifiedName(instance.modelVersionQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelBusinessDate(Long modelBusinessDate) {
            this.modelBusinessDate = modelBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B modelDomain(String modelDomain) {
            this.modelDomain = modelDomain;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationCardinality(ModelCardinalityType modelEntityAssociationCardinality) {
            this.modelEntityAssociationCardinality = modelEntityAssociationCardinality;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationFrom(IModelEntity modelEntityAssociationFrom) {
            this.modelEntityAssociationFrom = modelEntityAssociationFrom;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationFromLabel(String modelEntityAssociationFromLabel) {
            this.modelEntityAssociationFromLabel = modelEntityAssociationFromLabel;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationFromMaxCardinality(Long modelEntityAssociationFromMaxCardinality) {
            this.modelEntityAssociationFromMaxCardinality = modelEntityAssociationFromMaxCardinality;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationFromMinCardinality(Long modelEntityAssociationFromMinCardinality) {
            this.modelEntityAssociationFromMinCardinality = modelEntityAssociationFromMinCardinality;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationFromQualifiedName(String modelEntityAssociationFromQualifiedName) {
            this.modelEntityAssociationFromQualifiedName = modelEntityAssociationFromQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationLabel(String modelEntityAssociationLabel) {
            this.modelEntityAssociationLabel = modelEntityAssociationLabel;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationTo(IModelEntity modelEntityAssociationTo) {
            this.modelEntityAssociationTo = modelEntityAssociationTo;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationToLabel(String modelEntityAssociationToLabel) {
            this.modelEntityAssociationToLabel = modelEntityAssociationToLabel;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationToMaxCardinality(Long modelEntityAssociationToMaxCardinality) {
            this.modelEntityAssociationToMaxCardinality = modelEntityAssociationToMaxCardinality;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationToMinCardinality(Long modelEntityAssociationToMinCardinality) {
            this.modelEntityAssociationToMinCardinality = modelEntityAssociationToMinCardinality;
            return (B)this.self();
        }

        @Generated
        public B modelEntityAssociationToQualifiedName(String modelEntityAssociationToQualifiedName) {
            this.modelEntityAssociationToQualifiedName = modelEntityAssociationToQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelEntityName(String modelEntityName) {
            this.modelEntityName = modelEntityName;
            return (B)this.self();
        }

        @Generated
        public B modelEntityQualifiedName(String modelEntityQualifiedName) {
            this.modelEntityQualifiedName = modelEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelExpiredAtBusinessDate(Long modelExpiredAtBusinessDate) {
            this.modelExpiredAtBusinessDate = modelExpiredAtBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B modelExpiredAtSystemDate(Long modelExpiredAtSystemDate) {
            this.modelExpiredAtSystemDate = modelExpiredAtSystemDate;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B modelNamespace(String modelNamespace) {
            this.modelNamespace = modelNamespace;
            return (B)this.self();
        }

        @Generated
        public B modelQualifiedName(String modelQualifiedName) {
            this.modelQualifiedName = modelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelSystemDate(Long modelSystemDate) {
            this.modelSystemDate = modelSystemDate;
            return (B)this.self();
        }

        @Generated
        public B modelType(String modelType) {
            this.modelType = modelType;
            return (B)this.self();
        }

        @Generated
        public B modelVersionAgnosticQualifiedName(String modelVersionAgnosticQualifiedName) {
            this.modelVersionAgnosticQualifiedName = modelVersionAgnosticQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelVersionName(String modelVersionName) {
            this.modelVersionName = modelVersionName;
            return (B)this.self();
        }

        @Generated
        public B modelVersionQualifiedName(String modelVersionQualifiedName) {
            this.modelVersionQualifiedName = modelVersionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ModelEntityAssociation.ModelEntityAssociationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelBusinessDate=" + this.modelBusinessDate + ", modelDomain=" + this.modelDomain + ", modelEntityAssociationCardinality=" + String.valueOf(this.modelEntityAssociationCardinality) + ", modelEntityAssociationFrom=" + String.valueOf(this.modelEntityAssociationFrom) + ", modelEntityAssociationFromLabel=" + this.modelEntityAssociationFromLabel + ", modelEntityAssociationFromMaxCardinality=" + this.modelEntityAssociationFromMaxCardinality + ", modelEntityAssociationFromMinCardinality=" + this.modelEntityAssociationFromMinCardinality + ", modelEntityAssociationFromQualifiedName=" + this.modelEntityAssociationFromQualifiedName + ", modelEntityAssociationLabel=" + this.modelEntityAssociationLabel + ", modelEntityAssociationTo=" + String.valueOf(this.modelEntityAssociationTo) + ", modelEntityAssociationToLabel=" + this.modelEntityAssociationToLabel + ", modelEntityAssociationToMaxCardinality=" + this.modelEntityAssociationToMaxCardinality + ", modelEntityAssociationToMinCardinality=" + this.modelEntityAssociationToMinCardinality + ", modelEntityAssociationToQualifiedName=" + this.modelEntityAssociationToQualifiedName + ", modelEntityName=" + this.modelEntityName + ", modelEntityQualifiedName=" + this.modelEntityQualifiedName + ", modelExpiredAtBusinessDate=" + this.modelExpiredAtBusinessDate + ", modelExpiredAtSystemDate=" + this.modelExpiredAtSystemDate + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", modelName=" + this.modelName + ", modelNamespace=" + this.modelNamespace + ", modelQualifiedName=" + this.modelQualifiedName + ", modelSystemDate=" + this.modelSystemDate + ", modelType=" + this.modelType + ", modelVersionAgnosticQualifiedName=" + this.modelVersionAgnosticQualifiedName + ", modelVersionName=" + this.modelVersionName + ", modelVersionQualifiedName=" + this.modelVersionQualifiedName + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ")";
        }
    }

    @Generated
    private static final class ModelEntityAssociationBuilderImpl
    extends ModelEntityAssociationBuilder<ModelEntityAssociation, ModelEntityAssociationBuilderImpl> {
        @Generated
        private ModelEntityAssociationBuilderImpl() {
        }

        @Override
        @Generated
        protected ModelEntityAssociationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ModelEntityAssociation build() {
            return new ModelEntityAssociation(this);
        }
    }
}

