/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.AuthPolicy;
import com.atlan.model.assets.IAccessControl;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAuthPolicy;
import com.atlan.model.assets.IPersona;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.enums.AssetFilterGroup;
import com.atlan.model.enums.AssetSidebarTab;
import com.atlan.model.enums.AuthPolicyCategory;
import com.atlan.model.enums.AuthPolicyResourceCategory;
import com.atlan.model.enums.AuthPolicyType;
import com.atlan.model.enums.DataAction;
import com.atlan.model.enums.PersonaDomainAction;
import com.atlan.model.enums.PersonaGlossaryAction;
import com.atlan.model.enums.PersonaMetadataAction;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Persona
extends Asset
implements IPersona,
IAccessControl,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Persona.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Persona";
    String typeName;
    @Attribute
    String channelLink;
    @Attribute
    String defaultNavigation;
    @Attribute
    SortedSet<AssetFilterGroup> denyAssetFilters;
    @Attribute
    SortedSet<String> denyAssetMetadataTypes;
    @Attribute
    SortedSet<AssetSidebarTab> denyAssetTabs;
    @Attribute
    SortedSet<String> denyAssetTypes;
    @Attribute
    SortedSet<String> denyCustomMetadataGuids;
    @Attribute
    SortedSet<String> denyNavigationPages;
    @Attribute
    SortedSet<String> denySidebarTabs;
    @Attribute
    SortedSet<String> displayPreferences;
    @Attribute
    Boolean isAccessControlEnabled;
    @Attribute
    SortedSet<String> personaGroups;
    @Attribute
    SortedSet<String> personaUsers;
    @Attribute
    SortedSet<IAuthPolicy> policies;
    @Attribute
    String roleId;

    @Override
    public Persona trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Persona.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Persona.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Persona.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Persona.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Persona refByGuid(String guid) {
        return Persona.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Persona refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PersonaBuilder)((PersonaBuilder)Persona._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Persona refByQualifiedName(String qualifiedName) {
        return Persona.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Persona refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PersonaBuilder)((PersonaBuilder)Persona._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id) throws AtlanException {
        return Persona.get(client, id, false);
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Persona) {
                return (Persona)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Persona) {
            return (Persona)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Persona.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Persona get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Persona) {
                return (Persona)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Persona) {
            return (Persona)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PersonaBuilder<?, ?> creator(String name) {
        return (PersonaBuilder)((Asset.AssetBuilder)((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)Persona._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(name)).name(name)).displayName(name)).isAccessControlEnabled(true)).description("");
    }

    public static PersonaBuilder<?, ?> updater(String qualifiedName, String name, boolean isEnabled) {
        return ((PersonaBuilder)((PersonaBuilder)((PersonaBuilder)Persona._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name)).isAccessControlEnabled(isEnabled);
    }

    public PersonaBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Persona.validateRequired(TYPE_NAME, map);
        if (this.getIsAccessControlEnabled() == null) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_UPDATE_PARAM, TYPE_NAME, "isAccessControlEnabled");
        }
        return Persona.updater(this.getQualifiedName(), this.getName(), this.getIsAccessControlEnabled());
    }

    public static List<Persona> findByName(AtlanClient client, String name) throws AtlanException {
        return Persona.findByName(client, name, (List<AtlanField>)null);
    }

    public static List<Persona> findByName(AtlanClient client, String name, Collection<String> attributes) throws AtlanException {
        ArrayList<Persona> results = new ArrayList<Persona>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(NAME.eq(name)))._includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Persona).forEach(p -> results.add((Persona)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PERSONA_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static List<Persona> findByName(AtlanClient client, String name, List<AtlanField> attributes) throws AtlanException {
        ArrayList<Persona> results = new ArrayList<Persona>();
        ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Persona.select(client).where(NAME.eq(name))).includesOnResults(attributes == null ? Collections.emptyList() : attributes)).stream().filter(a -> a instanceof Persona).forEach(p -> results.add((Persona)p));
        if (results.isEmpty()) {
            throw new NotFoundException(ErrorCode.PERSONA_NOT_FOUND_BY_NAME, name);
        }
        return results;
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createMetadataPolicy(String name, String personaId, AuthPolicyType policyType, Collection<PersonaMetadataAction> actions, String connectionQualifiedName, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((Asset.AssetBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).connectionQualifiedName(connectionQualifiedName)).policyResources(resources)).policyResourceCategory(AuthPolicyResourceCategory.CUSTOM)).policyServiceName("atlas")).policySubCategory("metadata")).accessControl(Persona.refByGuid(personaId));
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDataPolicy(String name, String personaId, AuthPolicyType policyType, String connectionQualifiedName, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((Asset.AssetBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyAction(DataAction.SELECT)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).connectionQualifiedName(connectionQualifiedName)).policyResources(resources)).policyResource("entity-type:*")).policyResourceCategory(AuthPolicyResourceCategory.ENTITY)).policyServiceName("heka")).policySubCategory("data")).accessControl(Persona.refByGuid(personaId));
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createGlossaryPolicy(String name, String personaId, AuthPolicyType policyType, Collection<PersonaGlossaryAction> actions, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(policyType)).policyResources(resources)).policyResourceCategory(AuthPolicyResourceCategory.CUSTOM)).policyServiceName("atlas")).policySubCategory("glossary")).accessControl(Persona.refByGuid(personaId));
    }

    public static AuthPolicy.AuthPolicyBuilder<?, ?> createDomainPolicy(String name, String personaId, Collection<PersonaDomainAction> actions, Collection<String> resources) {
        return ((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)((AuthPolicy.AuthPolicyBuilder)AuthPolicy.creator(name).policyActions(actions)).policyCategory(AuthPolicyCategory.PERSONA)).policyType(AuthPolicyType.ALLOW)).policyResources(resources)).policyResourceCategory(AuthPolicyResourceCategory.CUSTOM)).policyServiceName("atlas")).policySubCategory("domain")).accessControl(Persona.refByGuid(personaId));
    }

    public static Persona removeDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Persona)Asset.removeDescription(client, Persona.updater(qualifiedName, name, isEnabled));
    }

    public static Persona removeUserDescription(AtlanClient client, String qualifiedName, String name, boolean isEnabled) throws AtlanException {
        return (Persona)Asset.removeUserDescription(client, Persona.updater(qualifiedName, name, isEnabled));
    }

    @Deprecated
    public static Persona appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Persona)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Persona appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Persona)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Persona(PersonaBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Persona.$default$typeName();
        this.channelLink = b.channelLink;
        this.defaultNavigation = b.defaultNavigation;
        SortedSet<AssetFilterGroup> denyAssetFilters = new TreeSet<AssetFilterGroup>();
        if (b.denyAssetFilters != null) {
            denyAssetFilters.addAll(b.denyAssetFilters);
        }
        denyAssetFilters = Collections.unmodifiableSortedSet(denyAssetFilters);
        this.denyAssetFilters = denyAssetFilters;
        SortedSet<String> denyAssetMetadataTypes = new TreeSet<String>();
        if (b.denyAssetMetadataTypes != null) {
            denyAssetMetadataTypes.addAll(b.denyAssetMetadataTypes);
        }
        denyAssetMetadataTypes = Collections.unmodifiableSortedSet(denyAssetMetadataTypes);
        this.denyAssetMetadataTypes = denyAssetMetadataTypes;
        SortedSet<AssetSidebarTab> denyAssetTabs = new TreeSet<AssetSidebarTab>();
        if (b.denyAssetTabs != null) {
            denyAssetTabs.addAll(b.denyAssetTabs);
        }
        denyAssetTabs = Collections.unmodifiableSortedSet(denyAssetTabs);
        this.denyAssetTabs = denyAssetTabs;
        SortedSet<String> denyAssetTypes = new TreeSet<String>();
        if (b.denyAssetTypes != null) {
            denyAssetTypes.addAll(b.denyAssetTypes);
        }
        denyAssetTypes = Collections.unmodifiableSortedSet(denyAssetTypes);
        this.denyAssetTypes = denyAssetTypes;
        SortedSet<String> denyCustomMetadataGuids = new TreeSet<String>();
        if (b.denyCustomMetadataGuids != null) {
            denyCustomMetadataGuids.addAll(b.denyCustomMetadataGuids);
        }
        denyCustomMetadataGuids = Collections.unmodifiableSortedSet(denyCustomMetadataGuids);
        this.denyCustomMetadataGuids = denyCustomMetadataGuids;
        SortedSet<String> denyNavigationPages = new TreeSet<String>();
        if (b.denyNavigationPages != null) {
            denyNavigationPages.addAll(b.denyNavigationPages);
        }
        denyNavigationPages = Collections.unmodifiableSortedSet(denyNavigationPages);
        this.denyNavigationPages = denyNavigationPages;
        SortedSet<String> denySidebarTabs = new TreeSet<String>();
        if (b.denySidebarTabs != null) {
            denySidebarTabs.addAll(b.denySidebarTabs);
        }
        denySidebarTabs = Collections.unmodifiableSortedSet(denySidebarTabs);
        this.denySidebarTabs = denySidebarTabs;
        SortedSet<String> displayPreferences = new TreeSet<String>();
        if (b.displayPreferences != null) {
            displayPreferences.addAll(b.displayPreferences);
        }
        displayPreferences = Collections.unmodifiableSortedSet(displayPreferences);
        this.displayPreferences = displayPreferences;
        this.isAccessControlEnabled = b.isAccessControlEnabled;
        SortedSet<String> personaGroups = new TreeSet<String>();
        if (b.personaGroups != null) {
            personaGroups.addAll(b.personaGroups);
        }
        personaGroups = Collections.unmodifiableSortedSet(personaGroups);
        this.personaGroups = personaGroups;
        SortedSet<String> personaUsers = new TreeSet<String>();
        if (b.personaUsers != null) {
            personaUsers.addAll(b.personaUsers);
        }
        personaUsers = Collections.unmodifiableSortedSet(personaUsers);
        this.personaUsers = personaUsers;
        SortedSet<IAuthPolicy> policies = new TreeSet<IAuthPolicy>();
        if (b.policies != null) {
            policies.addAll(b.policies);
        }
        policies = Collections.unmodifiableSortedSet(policies);
        this.policies = policies;
        this.roleId = b.roleId;
    }

    @Generated
    public static PersonaBuilder<?, ?> _internal() {
        return new PersonaBuilderImpl();
    }

    @Generated
    public PersonaBuilder<?, ?> toBuilder() {
        return new PersonaBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getChannelLink() {
        return this.channelLink;
    }

    @Override
    @Generated
    public String getDefaultNavigation() {
        return this.defaultNavigation;
    }

    @Override
    @Generated
    public SortedSet<AssetFilterGroup> getDenyAssetFilters() {
        return this.denyAssetFilters;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyAssetMetadataTypes() {
        return this.denyAssetMetadataTypes;
    }

    @Override
    @Generated
    public SortedSet<AssetSidebarTab> getDenyAssetTabs() {
        return this.denyAssetTabs;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyAssetTypes() {
        return this.denyAssetTypes;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyCustomMetadataGuids() {
        return this.denyCustomMetadataGuids;
    }

    @Override
    @Generated
    public SortedSet<String> getDenyNavigationPages() {
        return this.denyNavigationPages;
    }

    @Override
    @Generated
    public SortedSet<String> getDenySidebarTabs() {
        return this.denySidebarTabs;
    }

    @Override
    @Generated
    public SortedSet<String> getDisplayPreferences() {
        return this.displayPreferences;
    }

    @Override
    @Generated
    public Boolean getIsAccessControlEnabled() {
        return this.isAccessControlEnabled;
    }

    @Override
    @Generated
    public SortedSet<String> getPersonaGroups() {
        return this.personaGroups;
    }

    @Override
    @Generated
    public SortedSet<String> getPersonaUsers() {
        return this.personaUsers;
    }

    @Override
    @Generated
    public SortedSet<IAuthPolicy> getPolicies() {
        return this.policies;
    }

    @Override
    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Persona)) {
            return false;
        }
        Persona other = (Persona)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAccessControlEnabled = this.getIsAccessControlEnabled();
        Boolean other$isAccessControlEnabled = other.getIsAccessControlEnabled();
        if (this$isAccessControlEnabled == null ? other$isAccessControlEnabled != null : !((Object)this$isAccessControlEnabled).equals(other$isAccessControlEnabled)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$channelLink = this.getChannelLink();
        String other$channelLink = other.getChannelLink();
        if (this$channelLink == null ? other$channelLink != null : !this$channelLink.equals(other$channelLink)) {
            return false;
        }
        String this$defaultNavigation = this.getDefaultNavigation();
        String other$defaultNavigation = other.getDefaultNavigation();
        if (this$defaultNavigation == null ? other$defaultNavigation != null : !this$defaultNavigation.equals(other$defaultNavigation)) {
            return false;
        }
        SortedSet<AssetFilterGroup> this$denyAssetFilters = this.getDenyAssetFilters();
        SortedSet<AssetFilterGroup> other$denyAssetFilters = other.getDenyAssetFilters();
        if (this$denyAssetFilters == null ? other$denyAssetFilters != null : !this$denyAssetFilters.equals(other$denyAssetFilters)) {
            return false;
        }
        SortedSet<String> this$denyAssetMetadataTypes = this.getDenyAssetMetadataTypes();
        SortedSet<String> other$denyAssetMetadataTypes = other.getDenyAssetMetadataTypes();
        if (this$denyAssetMetadataTypes == null ? other$denyAssetMetadataTypes != null : !this$denyAssetMetadataTypes.equals(other$denyAssetMetadataTypes)) {
            return false;
        }
        SortedSet<AssetSidebarTab> this$denyAssetTabs = this.getDenyAssetTabs();
        SortedSet<AssetSidebarTab> other$denyAssetTabs = other.getDenyAssetTabs();
        if (this$denyAssetTabs == null ? other$denyAssetTabs != null : !this$denyAssetTabs.equals(other$denyAssetTabs)) {
            return false;
        }
        SortedSet<String> this$denyAssetTypes = this.getDenyAssetTypes();
        SortedSet<String> other$denyAssetTypes = other.getDenyAssetTypes();
        if (this$denyAssetTypes == null ? other$denyAssetTypes != null : !this$denyAssetTypes.equals(other$denyAssetTypes)) {
            return false;
        }
        SortedSet<String> this$denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        SortedSet<String> other$denyCustomMetadataGuids = other.getDenyCustomMetadataGuids();
        if (this$denyCustomMetadataGuids == null ? other$denyCustomMetadataGuids != null : !this$denyCustomMetadataGuids.equals(other$denyCustomMetadataGuids)) {
            return false;
        }
        SortedSet<String> this$denyNavigationPages = this.getDenyNavigationPages();
        SortedSet<String> other$denyNavigationPages = other.getDenyNavigationPages();
        if (this$denyNavigationPages == null ? other$denyNavigationPages != null : !this$denyNavigationPages.equals(other$denyNavigationPages)) {
            return false;
        }
        SortedSet<String> this$denySidebarTabs = this.getDenySidebarTabs();
        SortedSet<String> other$denySidebarTabs = other.getDenySidebarTabs();
        if (this$denySidebarTabs == null ? other$denySidebarTabs != null : !this$denySidebarTabs.equals(other$denySidebarTabs)) {
            return false;
        }
        SortedSet<String> this$displayPreferences = this.getDisplayPreferences();
        SortedSet<String> other$displayPreferences = other.getDisplayPreferences();
        if (this$displayPreferences == null ? other$displayPreferences != null : !this$displayPreferences.equals(other$displayPreferences)) {
            return false;
        }
        SortedSet<String> this$personaGroups = this.getPersonaGroups();
        SortedSet<String> other$personaGroups = other.getPersonaGroups();
        if (this$personaGroups == null ? other$personaGroups != null : !this$personaGroups.equals(other$personaGroups)) {
            return false;
        }
        SortedSet<String> this$personaUsers = this.getPersonaUsers();
        SortedSet<String> other$personaUsers = other.getPersonaUsers();
        if (this$personaUsers == null ? other$personaUsers != null : !this$personaUsers.equals(other$personaUsers)) {
            return false;
        }
        SortedSet<IAuthPolicy> this$policies = this.getPolicies();
        SortedSet<IAuthPolicy> other$policies = other.getPolicies();
        if (this$policies == null ? other$policies != null : !this$policies.equals(other$policies)) {
            return false;
        }
        String this$roleId = this.getRoleId();
        String other$roleId = other.getRoleId();
        return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Persona;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAccessControlEnabled = this.getIsAccessControlEnabled();
        result = result * 59 + ($isAccessControlEnabled == null ? 43 : ((Object)$isAccessControlEnabled).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $channelLink = this.getChannelLink();
        result = result * 59 + ($channelLink == null ? 43 : $channelLink.hashCode());
        String $defaultNavigation = this.getDefaultNavigation();
        result = result * 59 + ($defaultNavigation == null ? 43 : $defaultNavigation.hashCode());
        SortedSet<AssetFilterGroup> $denyAssetFilters = this.getDenyAssetFilters();
        result = result * 59 + ($denyAssetFilters == null ? 43 : $denyAssetFilters.hashCode());
        SortedSet<String> $denyAssetMetadataTypes = this.getDenyAssetMetadataTypes();
        result = result * 59 + ($denyAssetMetadataTypes == null ? 43 : $denyAssetMetadataTypes.hashCode());
        SortedSet<AssetSidebarTab> $denyAssetTabs = this.getDenyAssetTabs();
        result = result * 59 + ($denyAssetTabs == null ? 43 : $denyAssetTabs.hashCode());
        SortedSet<String> $denyAssetTypes = this.getDenyAssetTypes();
        result = result * 59 + ($denyAssetTypes == null ? 43 : $denyAssetTypes.hashCode());
        SortedSet<String> $denyCustomMetadataGuids = this.getDenyCustomMetadataGuids();
        result = result * 59 + ($denyCustomMetadataGuids == null ? 43 : $denyCustomMetadataGuids.hashCode());
        SortedSet<String> $denyNavigationPages = this.getDenyNavigationPages();
        result = result * 59 + ($denyNavigationPages == null ? 43 : $denyNavigationPages.hashCode());
        SortedSet<String> $denySidebarTabs = this.getDenySidebarTabs();
        result = result * 59 + ($denySidebarTabs == null ? 43 : $denySidebarTabs.hashCode());
        SortedSet<String> $displayPreferences = this.getDisplayPreferences();
        result = result * 59 + ($displayPreferences == null ? 43 : $displayPreferences.hashCode());
        SortedSet<String> $personaGroups = this.getPersonaGroups();
        result = result * 59 + ($personaGroups == null ? 43 : $personaGroups.hashCode());
        SortedSet<String> $personaUsers = this.getPersonaUsers();
        result = result * 59 + ($personaUsers == null ? 43 : $personaUsers.hashCode());
        SortedSet<IAuthPolicy> $policies = this.getPolicies();
        result = result * 59 + ($policies == null ? 43 : $policies.hashCode());
        String $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Persona(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", channelLink=" + this.getChannelLink() + ", defaultNavigation=" + this.getDefaultNavigation() + ", denyAssetFilters=" + String.valueOf(this.getDenyAssetFilters()) + ", denyAssetMetadataTypes=" + String.valueOf(this.getDenyAssetMetadataTypes()) + ", denyAssetTabs=" + String.valueOf(this.getDenyAssetTabs()) + ", denyAssetTypes=" + String.valueOf(this.getDenyAssetTypes()) + ", denyCustomMetadataGuids=" + String.valueOf(this.getDenyCustomMetadataGuids()) + ", denyNavigationPages=" + String.valueOf(this.getDenyNavigationPages()) + ", denySidebarTabs=" + String.valueOf(this.getDenySidebarTabs()) + ", displayPreferences=" + String.valueOf(this.getDisplayPreferences()) + ", isAccessControlEnabled=" + this.getIsAccessControlEnabled() + ", personaGroups=" + String.valueOf(this.getPersonaGroups()) + ", personaUsers=" + String.valueOf(this.getPersonaUsers()) + ", policies=" + String.valueOf(this.getPolicies()) + ", roleId=" + this.getRoleId() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class PersonaBuilder<C extends Persona, B extends PersonaBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String channelLink;
        @Generated
        private String defaultNavigation;
        @Generated
        private ArrayList<AssetFilterGroup> denyAssetFilters;
        @Generated
        private ArrayList<String> denyAssetMetadataTypes;
        @Generated
        private ArrayList<AssetSidebarTab> denyAssetTabs;
        @Generated
        private ArrayList<String> denyAssetTypes;
        @Generated
        private ArrayList<String> denyCustomMetadataGuids;
        @Generated
        private ArrayList<String> denyNavigationPages;
        @Generated
        private ArrayList<String> denySidebarTabs;
        @Generated
        private ArrayList<String> displayPreferences;
        @Generated
        private Boolean isAccessControlEnabled;
        @Generated
        private ArrayList<String> personaGroups;
        @Generated
        private ArrayList<String> personaUsers;
        @Generated
        private ArrayList<IAuthPolicy> policies;
        @Generated
        private String roleId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Persona instance, PersonaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.channelLink(instance.channelLink);
            b.defaultNavigation(instance.defaultNavigation);
            b.denyAssetFilters(instance.denyAssetFilters == null ? Collections.emptySortedSet() : instance.denyAssetFilters);
            b.denyAssetMetadataTypes(instance.denyAssetMetadataTypes == null ? Collections.emptySortedSet() : instance.denyAssetMetadataTypes);
            b.denyAssetTabs(instance.denyAssetTabs == null ? Collections.emptySortedSet() : instance.denyAssetTabs);
            b.denyAssetTypes(instance.denyAssetTypes == null ? Collections.emptySortedSet() : instance.denyAssetTypes);
            b.denyCustomMetadataGuids(instance.denyCustomMetadataGuids == null ? Collections.emptySortedSet() : instance.denyCustomMetadataGuids);
            b.denyNavigationPages(instance.denyNavigationPages == null ? Collections.emptySortedSet() : instance.denyNavigationPages);
            b.denySidebarTabs(instance.denySidebarTabs == null ? Collections.emptySortedSet() : instance.denySidebarTabs);
            b.displayPreferences(instance.displayPreferences == null ? Collections.emptySortedSet() : instance.displayPreferences);
            b.isAccessControlEnabled(instance.isAccessControlEnabled);
            b.personaGroups(instance.personaGroups == null ? Collections.emptySortedSet() : instance.personaGroups);
            b.personaUsers(instance.personaUsers == null ? Collections.emptySortedSet() : instance.personaUsers);
            b.policies(instance.policies == null ? Collections.emptySortedSet() : instance.policies);
            b.roleId(instance.roleId);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B channelLink(String channelLink) {
            this.channelLink = channelLink;
            return (B)this.self();
        }

        @Generated
        public B defaultNavigation(String defaultNavigation) {
            this.defaultNavigation = defaultNavigation;
            return (B)this.self();
        }

        @Generated
        public B denyAssetFilter(AssetFilterGroup denyAssetFilter) {
            if (this.denyAssetFilters == null) {
                this.denyAssetFilters = new ArrayList();
            }
            this.denyAssetFilters.add(denyAssetFilter);
            return (B)this.self();
        }

        @Generated
        public B denyAssetFilters(Collection<? extends AssetFilterGroup> denyAssetFilters) {
            if (denyAssetFilters == null) {
                throw new NullPointerException("denyAssetFilters cannot be null");
            }
            if (this.denyAssetFilters == null) {
                this.denyAssetFilters = new ArrayList();
            }
            this.denyAssetFilters.addAll(denyAssetFilters);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetFilters() {
            if (this.denyAssetFilters != null) {
                this.denyAssetFilters.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyAssetMetadataType(String denyAssetMetadataType) {
            if (this.denyAssetMetadataTypes == null) {
                this.denyAssetMetadataTypes = new ArrayList();
            }
            this.denyAssetMetadataTypes.add(denyAssetMetadataType);
            return (B)this.self();
        }

        @Generated
        public B denyAssetMetadataTypes(Collection<? extends String> denyAssetMetadataTypes) {
            if (denyAssetMetadataTypes == null) {
                throw new NullPointerException("denyAssetMetadataTypes cannot be null");
            }
            if (this.denyAssetMetadataTypes == null) {
                this.denyAssetMetadataTypes = new ArrayList();
            }
            this.denyAssetMetadataTypes.addAll(denyAssetMetadataTypes);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetMetadataTypes() {
            if (this.denyAssetMetadataTypes != null) {
                this.denyAssetMetadataTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyAssetTab(AssetSidebarTab denyAssetTab) {
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.add(denyAssetTab);
            return (B)this.self();
        }

        @Generated
        public B denyAssetTabs(Collection<? extends AssetSidebarTab> denyAssetTabs) {
            if (denyAssetTabs == null) {
                throw new NullPointerException("denyAssetTabs cannot be null");
            }
            if (this.denyAssetTabs == null) {
                this.denyAssetTabs = new ArrayList();
            }
            this.denyAssetTabs.addAll(denyAssetTabs);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetTabs() {
            if (this.denyAssetTabs != null) {
                this.denyAssetTabs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyAssetType(String denyAssetType) {
            if (this.denyAssetTypes == null) {
                this.denyAssetTypes = new ArrayList();
            }
            this.denyAssetTypes.add(denyAssetType);
            return (B)this.self();
        }

        @Generated
        public B denyAssetTypes(Collection<? extends String> denyAssetTypes) {
            if (denyAssetTypes == null) {
                throw new NullPointerException("denyAssetTypes cannot be null");
            }
            if (this.denyAssetTypes == null) {
                this.denyAssetTypes = new ArrayList();
            }
            this.denyAssetTypes.addAll(denyAssetTypes);
            return (B)this.self();
        }

        @Generated
        public B clearDenyAssetTypes() {
            if (this.denyAssetTypes != null) {
                this.denyAssetTypes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuid(String denyCustomMetadataGuid) {
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.add(denyCustomMetadataGuid);
            return (B)this.self();
        }

        @Generated
        public B denyCustomMetadataGuids(Collection<? extends String> denyCustomMetadataGuids) {
            if (denyCustomMetadataGuids == null) {
                throw new NullPointerException("denyCustomMetadataGuids cannot be null");
            }
            if (this.denyCustomMetadataGuids == null) {
                this.denyCustomMetadataGuids = new ArrayList();
            }
            this.denyCustomMetadataGuids.addAll(denyCustomMetadataGuids);
            return (B)this.self();
        }

        @Generated
        public B clearDenyCustomMetadataGuids() {
            if (this.denyCustomMetadataGuids != null) {
                this.denyCustomMetadataGuids.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denyNavigationPage(String denyNavigationPage) {
            if (this.denyNavigationPages == null) {
                this.denyNavigationPages = new ArrayList();
            }
            this.denyNavigationPages.add(denyNavigationPage);
            return (B)this.self();
        }

        @Generated
        public B denyNavigationPages(Collection<? extends String> denyNavigationPages) {
            if (denyNavigationPages == null) {
                throw new NullPointerException("denyNavigationPages cannot be null");
            }
            if (this.denyNavigationPages == null) {
                this.denyNavigationPages = new ArrayList();
            }
            this.denyNavigationPages.addAll(denyNavigationPages);
            return (B)this.self();
        }

        @Generated
        public B clearDenyNavigationPages() {
            if (this.denyNavigationPages != null) {
                this.denyNavigationPages.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B denySidebarTab(String denySidebarTab) {
            if (this.denySidebarTabs == null) {
                this.denySidebarTabs = new ArrayList();
            }
            this.denySidebarTabs.add(denySidebarTab);
            return (B)this.self();
        }

        @Generated
        public B denySidebarTabs(Collection<? extends String> denySidebarTabs) {
            if (denySidebarTabs == null) {
                throw new NullPointerException("denySidebarTabs cannot be null");
            }
            if (this.denySidebarTabs == null) {
                this.denySidebarTabs = new ArrayList();
            }
            this.denySidebarTabs.addAll(denySidebarTabs);
            return (B)this.self();
        }

        @Generated
        public B clearDenySidebarTabs() {
            if (this.denySidebarTabs != null) {
                this.denySidebarTabs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B displayPreference(String displayPreference) {
            if (this.displayPreferences == null) {
                this.displayPreferences = new ArrayList();
            }
            this.displayPreferences.add(displayPreference);
            return (B)this.self();
        }

        @Generated
        public B displayPreferences(Collection<? extends String> displayPreferences) {
            if (displayPreferences == null) {
                throw new NullPointerException("displayPreferences cannot be null");
            }
            if (this.displayPreferences == null) {
                this.displayPreferences = new ArrayList();
            }
            this.displayPreferences.addAll(displayPreferences);
            return (B)this.self();
        }

        @Generated
        public B clearDisplayPreferences() {
            if (this.displayPreferences != null) {
                this.displayPreferences.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isAccessControlEnabled(Boolean isAccessControlEnabled) {
            this.isAccessControlEnabled = isAccessControlEnabled;
            return (B)this.self();
        }

        @Generated
        public B personaGroup(String personaGroup) {
            if (this.personaGroups == null) {
                this.personaGroups = new ArrayList();
            }
            this.personaGroups.add(personaGroup);
            return (B)this.self();
        }

        @Generated
        public B personaGroups(Collection<? extends String> personaGroups) {
            if (personaGroups == null) {
                throw new NullPointerException("personaGroups cannot be null");
            }
            if (this.personaGroups == null) {
                this.personaGroups = new ArrayList();
            }
            this.personaGroups.addAll(personaGroups);
            return (B)this.self();
        }

        @Generated
        public B clearPersonaGroups() {
            if (this.personaGroups != null) {
                this.personaGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B personaUser(String personaUser) {
            if (this.personaUsers == null) {
                this.personaUsers = new ArrayList();
            }
            this.personaUsers.add(personaUser);
            return (B)this.self();
        }

        @Generated
        public B personaUsers(Collection<? extends String> personaUsers) {
            if (personaUsers == null) {
                throw new NullPointerException("personaUsers cannot be null");
            }
            if (this.personaUsers == null) {
                this.personaUsers = new ArrayList();
            }
            this.personaUsers.addAll(personaUsers);
            return (B)this.self();
        }

        @Generated
        public B clearPersonaUsers() {
            if (this.personaUsers != null) {
                this.personaUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B policy(IAuthPolicy policy) {
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.add(policy);
            return (B)this.self();
        }

        @Generated
        public B policies(Collection<? extends IAuthPolicy> policies) {
            if (policies == null) {
                throw new NullPointerException("policies cannot be null");
            }
            if (this.policies == null) {
                this.policies = new ArrayList();
            }
            this.policies.addAll(policies);
            return (B)this.self();
        }

        @Generated
        public B clearPolicies() {
            if (this.policies != null) {
                this.policies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B roleId(String roleId) {
            this.roleId = roleId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Persona.PersonaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", channelLink=" + this.channelLink + ", defaultNavigation=" + this.defaultNavigation + ", denyAssetFilters=" + String.valueOf(this.denyAssetFilters) + ", denyAssetMetadataTypes=" + String.valueOf(this.denyAssetMetadataTypes) + ", denyAssetTabs=" + String.valueOf(this.denyAssetTabs) + ", denyAssetTypes=" + String.valueOf(this.denyAssetTypes) + ", denyCustomMetadataGuids=" + String.valueOf(this.denyCustomMetadataGuids) + ", denyNavigationPages=" + String.valueOf(this.denyNavigationPages) + ", denySidebarTabs=" + String.valueOf(this.denySidebarTabs) + ", displayPreferences=" + String.valueOf(this.displayPreferences) + ", isAccessControlEnabled=" + this.isAccessControlEnabled + ", personaGroups=" + String.valueOf(this.personaGroups) + ", personaUsers=" + String.valueOf(this.personaUsers) + ", policies=" + String.valueOf(this.policies) + ", roleId=" + this.roleId + ")";
        }
    }

    @Generated
    private static final class PersonaBuilderImpl
    extends PersonaBuilder<Persona, PersonaBuilderImpl> {
        @Generated
        private PersonaBuilderImpl() {
        }

        @Override
        @Generated
        protected PersonaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Persona build() {
            return new Persona(this);
        }
    }
}

