/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIApp;
import com.atlan.model.assets.IPowerBIDashboard;
import com.atlan.model.assets.IPowerBIReport;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBIApp
extends Asset
implements IPowerBIApp,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIApp.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIApp";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    List<Map<String, String>> powerBIAppGroups;
    @Attribute
    String powerBIAppId;
    @Attribute
    List<Map<String, String>> powerBIAppUsers;
    @Attribute
    SortedSet<IPowerBIDashboard> powerBIDashboards;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    SortedSet<IPowerBIReport> powerBIReports;
    @Attribute
    String powerBITableQualifiedName;

    @Override
    public PowerBIApp trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBIApp.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBIApp.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBIApp.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBIApp.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PowerBIApp refByGuid(String guid) {
        return PowerBIApp.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIApp refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PowerBIAppBuilder)((PowerBIAppBuilder)PowerBIApp._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PowerBIApp refByQualifiedName(String qualifiedName) {
        return PowerBIApp.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIApp refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PowerBIAppBuilder)((PowerBIAppBuilder)PowerBIApp._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PowerBIApp get(AtlanClient client, String id) throws AtlanException {
        return PowerBIApp.get(client, id, false);
    }

    @JsonIgnore
    public static PowerBIApp get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBIApp) {
                return (PowerBIApp)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof PowerBIApp) {
            return (PowerBIApp)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static PowerBIApp get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return PowerBIApp.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static PowerBIApp get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIApp.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof PowerBIApp) {
                return (PowerBIApp)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIApp.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof PowerBIApp) {
            return (PowerBIApp)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBIAppBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIAppBuilder)((PowerBIAppBuilder)((PowerBIAppBuilder)PowerBIApp._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBIAppBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        PowerBIApp.validateRequired(TYPE_NAME, map);
        return PowerBIApp.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIApp removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIApp)Asset.removeDescription(client, PowerBIApp.updater(qualifiedName, name));
    }

    public static PowerBIApp removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIApp)Asset.removeUserDescription(client, PowerBIApp.updater(qualifiedName, name));
    }

    public static PowerBIApp removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIApp)Asset.removeOwners(client, PowerBIApp.updater(qualifiedName, name));
    }

    public static PowerBIApp updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIApp)Asset.updateCertificate(client, PowerBIApp._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIApp removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIApp)Asset.removeCertificate(client, PowerBIApp.updater(qualifiedName, name));
    }

    public static PowerBIApp updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIApp)Asset.updateAnnouncement(client, PowerBIApp._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIApp removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIApp)Asset.removeAnnouncement(client, PowerBIApp.updater(qualifiedName, name));
    }

    public static PowerBIApp replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIApp)Asset.replaceTerms(client, PowerBIApp.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static PowerBIApp appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIApp)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PowerBIApp removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIApp)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PowerBIApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIApp)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static PowerBIApp appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIApp)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIApp(PowerBIAppBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIApp.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIAppGroups = switch (b.powerBIAppGroups == null ? 0 : b.powerBIAppGroups.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.powerBIAppGroups.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.powerBIAppGroups));
        };
        this.powerBIAppId = b.powerBIAppId;
        this.powerBIAppUsers = switch (b.powerBIAppUsers == null ? 0 : b.powerBIAppUsers.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.powerBIAppUsers.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.powerBIAppUsers));
        };
        SortedSet<IPowerBIDashboard> powerBIDashboards = new TreeSet<IPowerBIDashboard>();
        if (b.powerBIDashboards != null) {
            powerBIDashboards.addAll(b.powerBIDashboards);
        }
        powerBIDashboards = Collections.unmodifiableSortedSet(powerBIDashboards);
        this.powerBIDashboards = powerBIDashboards;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        SortedSet<IPowerBIReport> powerBIReports = new TreeSet<IPowerBIReport>();
        if (b.powerBIReports != null) {
            powerBIReports.addAll(b.powerBIReports);
        }
        powerBIReports = Collections.unmodifiableSortedSet(powerBIReports);
        this.powerBIReports = powerBIReports;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
    }

    @Generated
    public static PowerBIAppBuilder<?, ?> _internal() {
        return new PowerBIAppBuilderImpl();
    }

    @Generated
    public PowerBIAppBuilder<?, ?> toBuilder() {
        return new PowerBIAppBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public List<Map<String, String>> getPowerBIAppGroups() {
        return this.powerBIAppGroups;
    }

    @Override
    @Generated
    public String getPowerBIAppId() {
        return this.powerBIAppId;
    }

    @Override
    @Generated
    public List<Map<String, String>> getPowerBIAppUsers() {
        return this.powerBIAppUsers;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDashboard> getPowerBIDashboards() {
        return this.powerBIDashboards;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIReport> getPowerBIReports() {
        return this.powerBIReports;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIApp)) {
            return false;
        }
        PowerBIApp other = (PowerBIApp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        List<Map<String, String>> this$powerBIAppGroups = this.getPowerBIAppGroups();
        List<Map<String, String>> other$powerBIAppGroups = other.getPowerBIAppGroups();
        if (this$powerBIAppGroups == null ? other$powerBIAppGroups != null : !((Object)this$powerBIAppGroups).equals(other$powerBIAppGroups)) {
            return false;
        }
        String this$powerBIAppId = this.getPowerBIAppId();
        String other$powerBIAppId = other.getPowerBIAppId();
        if (this$powerBIAppId == null ? other$powerBIAppId != null : !this$powerBIAppId.equals(other$powerBIAppId)) {
            return false;
        }
        List<Map<String, String>> this$powerBIAppUsers = this.getPowerBIAppUsers();
        List<Map<String, String>> other$powerBIAppUsers = other.getPowerBIAppUsers();
        if (this$powerBIAppUsers == null ? other$powerBIAppUsers != null : !((Object)this$powerBIAppUsers).equals(other$powerBIAppUsers)) {
            return false;
        }
        SortedSet<IPowerBIDashboard> this$powerBIDashboards = this.getPowerBIDashboards();
        SortedSet<IPowerBIDashboard> other$powerBIDashboards = other.getPowerBIDashboards();
        if (this$powerBIDashboards == null ? other$powerBIDashboards != null : !this$powerBIDashboards.equals(other$powerBIDashboards)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        SortedSet<IPowerBIReport> this$powerBIReports = this.getPowerBIReports();
        SortedSet<IPowerBIReport> other$powerBIReports = other.getPowerBIReports();
        if (this$powerBIReports == null ? other$powerBIReports != null : !this$powerBIReports.equals(other$powerBIReports)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        return !(this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIApp;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        List<Map<String, String>> $powerBIAppGroups = this.getPowerBIAppGroups();
        result = result * 59 + ($powerBIAppGroups == null ? 43 : ((Object)$powerBIAppGroups).hashCode());
        String $powerBIAppId = this.getPowerBIAppId();
        result = result * 59 + ($powerBIAppId == null ? 43 : $powerBIAppId.hashCode());
        List<Map<String, String>> $powerBIAppUsers = this.getPowerBIAppUsers();
        result = result * 59 + ($powerBIAppUsers == null ? 43 : ((Object)$powerBIAppUsers).hashCode());
        SortedSet<IPowerBIDashboard> $powerBIDashboards = this.getPowerBIDashboards();
        result = result * 59 + ($powerBIDashboards == null ? 43 : $powerBIDashboards.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        SortedSet<IPowerBIReport> $powerBIReports = this.getPowerBIReports();
        result = result * 59 + ($powerBIReports == null ? 43 : $powerBIReports.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBIApp(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", powerBIAppGroups=" + String.valueOf(this.getPowerBIAppGroups()) + ", powerBIAppId=" + this.getPowerBIAppId() + ", powerBIAppUsers=" + String.valueOf(this.getPowerBIAppUsers()) + ", powerBIDashboards=" + String.valueOf(this.getPowerBIDashboards()) + ", powerBIEndorsement=" + String.valueOf(this.getPowerBIEndorsement()) + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBIReports=" + String.valueOf(this.getPowerBIReports()) + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class PowerBIAppBuilder<C extends PowerBIApp, B extends PowerBIAppBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<Map<String, String>> powerBIAppGroups;
        @Generated
        private String powerBIAppId;
        @Generated
        private ArrayList<Map<String, String>> powerBIAppUsers;
        @Generated
        private ArrayList<IPowerBIDashboard> powerBIDashboards;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private ArrayList<IPowerBIReport> powerBIReports;
        @Generated
        private String powerBITableQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIAppBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIApp instance, PowerBIAppBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIAppGroups(instance.powerBIAppGroups == null ? Collections.emptyList() : instance.powerBIAppGroups);
            b.powerBIAppId(instance.powerBIAppId);
            b.powerBIAppUsers(instance.powerBIAppUsers == null ? Collections.emptyList() : instance.powerBIAppUsers);
            b.powerBIDashboards(instance.powerBIDashboards == null ? Collections.emptySortedSet() : instance.powerBIDashboards);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBIReports(instance.powerBIReports == null ? Collections.emptySortedSet() : instance.powerBIReports);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIAppGroup(Map<String, String> powerBIAppGroup) {
            if (this.powerBIAppGroups == null) {
                this.powerBIAppGroups = new ArrayList();
            }
            this.powerBIAppGroups.add(powerBIAppGroup);
            return (B)this.self();
        }

        @Generated
        public B powerBIAppGroups(Collection<? extends Map<String, String>> powerBIAppGroups) {
            if (powerBIAppGroups == null) {
                throw new NullPointerException("powerBIAppGroups cannot be null");
            }
            if (this.powerBIAppGroups == null) {
                this.powerBIAppGroups = new ArrayList();
            }
            this.powerBIAppGroups.addAll(powerBIAppGroups);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIAppGroups() {
            if (this.powerBIAppGroups != null) {
                this.powerBIAppGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIAppId(String powerBIAppId) {
            this.powerBIAppId = powerBIAppId;
            return (B)this.self();
        }

        @Generated
        public B powerBIAppUser(Map<String, String> powerBIAppUser) {
            if (this.powerBIAppUsers == null) {
                this.powerBIAppUsers = new ArrayList();
            }
            this.powerBIAppUsers.add(powerBIAppUser);
            return (B)this.self();
        }

        @Generated
        public B powerBIAppUsers(Collection<? extends Map<String, String>> powerBIAppUsers) {
            if (powerBIAppUsers == null) {
                throw new NullPointerException("powerBIAppUsers cannot be null");
            }
            if (this.powerBIAppUsers == null) {
                this.powerBIAppUsers = new ArrayList();
            }
            this.powerBIAppUsers.addAll(powerBIAppUsers);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIAppUsers() {
            if (this.powerBIAppUsers != null) {
                this.powerBIAppUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDashboard(IPowerBIDashboard powerBIDashboard) {
            if (this.powerBIDashboards == null) {
                this.powerBIDashboards = new ArrayList();
            }
            this.powerBIDashboards.add(powerBIDashboard);
            return (B)this.self();
        }

        @Generated
        public B powerBIDashboards(Collection<? extends IPowerBIDashboard> powerBIDashboards) {
            if (powerBIDashboards == null) {
                throw new NullPointerException("powerBIDashboards cannot be null");
            }
            if (this.powerBIDashboards == null) {
                this.powerBIDashboards = new ArrayList();
            }
            this.powerBIDashboards.addAll(powerBIDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDashboards() {
            if (this.powerBIDashboards != null) {
                this.powerBIDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBIReport(IPowerBIReport powerBIReport) {
            if (this.powerBIReports == null) {
                this.powerBIReports = new ArrayList();
            }
            this.powerBIReports.add(powerBIReport);
            return (B)this.self();
        }

        @Generated
        public B powerBIReports(Collection<? extends IPowerBIReport> powerBIReports) {
            if (powerBIReports == null) {
                throw new NullPointerException("powerBIReports cannot be null");
            }
            if (this.powerBIReports == null) {
                this.powerBIReports = new ArrayList();
            }
            this.powerBIReports.addAll(powerBIReports);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIReports() {
            if (this.powerBIReports != null) {
                this.powerBIReports.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBIApp.PowerBIAppBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", powerBIAppGroups=" + String.valueOf(this.powerBIAppGroups) + ", powerBIAppId=" + this.powerBIAppId + ", powerBIAppUsers=" + String.valueOf(this.powerBIAppUsers) + ", powerBIDashboards=" + String.valueOf(this.powerBIDashboards) + ", powerBIEndorsement=" + String.valueOf(this.powerBIEndorsement) + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBIReports=" + String.valueOf(this.powerBIReports) + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ")";
        }
    }

    @Generated
    private static final class PowerBIAppBuilderImpl
    extends PowerBIAppBuilder<PowerBIApp, PowerBIAppBuilderImpl> {
        @Generated
        private PowerBIAppBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIAppBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIApp build() {
            return new PowerBIApp(this);
        }
    }
}

