/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IPowerBIDataflowEntityColumn;
import com.atlan.model.assets.IPowerBIDataset;
import com.atlan.model.assets.IPowerBIDatasource;
import com.atlan.model.assets.IPowerBITable;
import com.atlan.model.assets.IPowerBIWorkspace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBIDataflow
extends Asset
implements IPowerBIDataflow,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIDataflow.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDataflow";
    String typeName;
    @Attribute
    SortedSet<IPowerBIDataset> datasets;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<IPowerBIDataflow> powerBIDataflowChildren;
    @Attribute
    SortedSet<IPowerBIDataflowEntityColumn> powerBIDataflowEntityColumns;
    @Attribute
    SortedSet<IPowerBIDataflow> powerBIDataflowParents;
    @Attribute
    String powerBIDataflowRefreshScheduleFrequency;
    @Attribute
    String powerBIDataflowRefreshScheduleTimeZone;
    @Attribute
    SortedSet<String> powerBIDataflowRefreshScheduleTimes;
    @Attribute
    SortedSet<IPowerBIDatasource> powerBIDatasources;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    SortedSet<ILineageProcess> powerBIProcesses;
    @Attribute
    String powerBITableQualifiedName;
    @Attribute
    SortedSet<IPowerBITable> tables;
    @Attribute
    String webUrl;
    @Attribute
    IPowerBIWorkspace workspace;
    @Attribute
    String workspaceQualifiedName;

    @Override
    public PowerBIDataflow trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBIDataflow.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBIDataflow.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBIDataflow.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBIDataflow.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PowerBIDataflow refByGuid(String guid) {
        return PowerBIDataflow.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDataflow refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PowerBIDataflowBuilder)((PowerBIDataflowBuilder)PowerBIDataflow._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PowerBIDataflow refByQualifiedName(String qualifiedName) {
        return PowerBIDataflow.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDataflow refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PowerBIDataflowBuilder)((PowerBIDataflowBuilder)PowerBIDataflow._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id) throws AtlanException {
        return PowerBIDataflow.get(client, id, false);
    }

    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBIDataflow) {
                return (PowerBIDataflow)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof PowerBIDataflow) {
            return (PowerBIDataflow)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return PowerBIDataflow.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static PowerBIDataflow get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIDataflow.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof PowerBIDataflow) {
                return (PowerBIDataflow)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PowerBIDataflow.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof PowerBIDataflow) {
            return (PowerBIDataflow)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBIDataflowBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDataflowBuilder)((PowerBIDataflowBuilder)((PowerBIDataflowBuilder)PowerBIDataflow._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBIDataflowBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        PowerBIDataflow.validateRequired(TYPE_NAME, map);
        return PowerBIDataflow.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDataflow removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeDescription(client, PowerBIDataflow.updater(qualifiedName, name));
    }

    public static PowerBIDataflow removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeUserDescription(client, PowerBIDataflow.updater(qualifiedName, name));
    }

    public static PowerBIDataflow removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeOwners(client, PowerBIDataflow.updater(qualifiedName, name));
    }

    public static PowerBIDataflow updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDataflow)Asset.updateCertificate(client, PowerBIDataflow._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDataflow removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeCertificate(client, PowerBIDataflow.updater(qualifiedName, name));
    }

    public static PowerBIDataflow updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDataflow)Asset.updateAnnouncement(client, PowerBIDataflow._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDataflow removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDataflow)Asset.removeAnnouncement(client, PowerBIDataflow.updater(qualifiedName, name));
    }

    public static PowerBIDataflow replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.replaceTerms(client, PowerBIDataflow.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static PowerBIDataflow appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PowerBIDataflow removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDataflow)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PowerBIDataflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIDataflow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static PowerBIDataflow appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIDataflow)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDataflow(PowerBIDataflowBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDataflow.$default$typeName();
        SortedSet<IPowerBIDataset> datasets = new TreeSet<IPowerBIDataset>();
        if (b.datasets != null) {
            datasets.addAll(b.datasets);
        }
        datasets = Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<IPowerBIDataflow> powerBIDataflowChildren = new TreeSet<IPowerBIDataflow>();
        if (b.powerBIDataflowChildren != null) {
            powerBIDataflowChildren.addAll(b.powerBIDataflowChildren);
        }
        powerBIDataflowChildren = Collections.unmodifiableSortedSet(powerBIDataflowChildren);
        this.powerBIDataflowChildren = powerBIDataflowChildren;
        SortedSet<IPowerBIDataflowEntityColumn> powerBIDataflowEntityColumns = new TreeSet<IPowerBIDataflowEntityColumn>();
        if (b.powerBIDataflowEntityColumns != null) {
            powerBIDataflowEntityColumns.addAll(b.powerBIDataflowEntityColumns);
        }
        powerBIDataflowEntityColumns = Collections.unmodifiableSortedSet(powerBIDataflowEntityColumns);
        this.powerBIDataflowEntityColumns = powerBIDataflowEntityColumns;
        SortedSet<IPowerBIDataflow> powerBIDataflowParents = new TreeSet<IPowerBIDataflow>();
        if (b.powerBIDataflowParents != null) {
            powerBIDataflowParents.addAll(b.powerBIDataflowParents);
        }
        powerBIDataflowParents = Collections.unmodifiableSortedSet(powerBIDataflowParents);
        this.powerBIDataflowParents = powerBIDataflowParents;
        this.powerBIDataflowRefreshScheduleFrequency = b.powerBIDataflowRefreshScheduleFrequency;
        this.powerBIDataflowRefreshScheduleTimeZone = b.powerBIDataflowRefreshScheduleTimeZone;
        SortedSet<String> powerBIDataflowRefreshScheduleTimes = new TreeSet<String>();
        if (b.powerBIDataflowRefreshScheduleTimes != null) {
            powerBIDataflowRefreshScheduleTimes.addAll(b.powerBIDataflowRefreshScheduleTimes);
        }
        powerBIDataflowRefreshScheduleTimes = Collections.unmodifiableSortedSet(powerBIDataflowRefreshScheduleTimes);
        this.powerBIDataflowRefreshScheduleTimes = powerBIDataflowRefreshScheduleTimes;
        SortedSet<IPowerBIDatasource> powerBIDatasources = new TreeSet<IPowerBIDatasource>();
        if (b.powerBIDatasources != null) {
            powerBIDatasources.addAll(b.powerBIDatasources);
        }
        powerBIDatasources = Collections.unmodifiableSortedSet(powerBIDatasources);
        this.powerBIDatasources = powerBIDatasources;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        SortedSet<ILineageProcess> powerBIProcesses = new TreeSet<ILineageProcess>();
        if (b.powerBIProcesses != null) {
            powerBIProcesses.addAll(b.powerBIProcesses);
        }
        powerBIProcesses = Collections.unmodifiableSortedSet(powerBIProcesses);
        this.powerBIProcesses = powerBIProcesses;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
        SortedSet<IPowerBITable> tables = new TreeSet<IPowerBITable>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.webUrl = b.webUrl;
        this.workspace = b.workspace;
        this.workspaceQualifiedName = b.workspaceQualifiedName;
    }

    @Generated
    public static PowerBIDataflowBuilder<?, ?> _internal() {
        return new PowerBIDataflowBuilderImpl();
    }

    @Generated
    public PowerBIDataflowBuilder<?, ?> toBuilder() {
        return new PowerBIDataflowBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataset> getDatasets() {
        return this.datasets;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataflow> getPowerBIDataflowChildren() {
        return this.powerBIDataflowChildren;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataflowEntityColumn> getPowerBIDataflowEntityColumns() {
        return this.powerBIDataflowEntityColumns;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataflow> getPowerBIDataflowParents() {
        return this.powerBIDataflowParents;
    }

    @Override
    @Generated
    public String getPowerBIDataflowRefreshScheduleFrequency() {
        return this.powerBIDataflowRefreshScheduleFrequency;
    }

    @Override
    @Generated
    public String getPowerBIDataflowRefreshScheduleTimeZone() {
        return this.powerBIDataflowRefreshScheduleTimeZone;
    }

    @Override
    @Generated
    public SortedSet<String> getPowerBIDataflowRefreshScheduleTimes() {
        return this.powerBIDataflowRefreshScheduleTimes;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDatasource> getPowerBIDatasources() {
        return this.powerBIDatasources;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getPowerBIProcesses() {
        return this.powerBIProcesses;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IPowerBITable> getTables() {
        return this.tables;
    }

    @Override
    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    @Override
    @Generated
    public IPowerBIWorkspace getWorkspace() {
        return this.workspace;
    }

    @Override
    @Generated
    public String getWorkspaceQualifiedName() {
        return this.workspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDataflow)) {
            return false;
        }
        PowerBIDataflow other = (PowerBIDataflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IPowerBIDataset> this$datasets = this.getDatasets();
        SortedSet<IPowerBIDataset> other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<IPowerBIDataflow> this$powerBIDataflowChildren = this.getPowerBIDataflowChildren();
        SortedSet<IPowerBIDataflow> other$powerBIDataflowChildren = other.getPowerBIDataflowChildren();
        if (this$powerBIDataflowChildren == null ? other$powerBIDataflowChildren != null : !this$powerBIDataflowChildren.equals(other$powerBIDataflowChildren)) {
            return false;
        }
        SortedSet<IPowerBIDataflowEntityColumn> this$powerBIDataflowEntityColumns = this.getPowerBIDataflowEntityColumns();
        SortedSet<IPowerBIDataflowEntityColumn> other$powerBIDataflowEntityColumns = other.getPowerBIDataflowEntityColumns();
        if (this$powerBIDataflowEntityColumns == null ? other$powerBIDataflowEntityColumns != null : !this$powerBIDataflowEntityColumns.equals(other$powerBIDataflowEntityColumns)) {
            return false;
        }
        SortedSet<IPowerBIDataflow> this$powerBIDataflowParents = this.getPowerBIDataflowParents();
        SortedSet<IPowerBIDataflow> other$powerBIDataflowParents = other.getPowerBIDataflowParents();
        if (this$powerBIDataflowParents == null ? other$powerBIDataflowParents != null : !this$powerBIDataflowParents.equals(other$powerBIDataflowParents)) {
            return false;
        }
        String this$powerBIDataflowRefreshScheduleFrequency = this.getPowerBIDataflowRefreshScheduleFrequency();
        String other$powerBIDataflowRefreshScheduleFrequency = other.getPowerBIDataflowRefreshScheduleFrequency();
        if (this$powerBIDataflowRefreshScheduleFrequency == null ? other$powerBIDataflowRefreshScheduleFrequency != null : !this$powerBIDataflowRefreshScheduleFrequency.equals(other$powerBIDataflowRefreshScheduleFrequency)) {
            return false;
        }
        String this$powerBIDataflowRefreshScheduleTimeZone = this.getPowerBIDataflowRefreshScheduleTimeZone();
        String other$powerBIDataflowRefreshScheduleTimeZone = other.getPowerBIDataflowRefreshScheduleTimeZone();
        if (this$powerBIDataflowRefreshScheduleTimeZone == null ? other$powerBIDataflowRefreshScheduleTimeZone != null : !this$powerBIDataflowRefreshScheduleTimeZone.equals(other$powerBIDataflowRefreshScheduleTimeZone)) {
            return false;
        }
        SortedSet<String> this$powerBIDataflowRefreshScheduleTimes = this.getPowerBIDataflowRefreshScheduleTimes();
        SortedSet<String> other$powerBIDataflowRefreshScheduleTimes = other.getPowerBIDataflowRefreshScheduleTimes();
        if (this$powerBIDataflowRefreshScheduleTimes == null ? other$powerBIDataflowRefreshScheduleTimes != null : !this$powerBIDataflowRefreshScheduleTimes.equals(other$powerBIDataflowRefreshScheduleTimes)) {
            return false;
        }
        SortedSet<IPowerBIDatasource> this$powerBIDatasources = this.getPowerBIDatasources();
        SortedSet<IPowerBIDatasource> other$powerBIDatasources = other.getPowerBIDatasources();
        if (this$powerBIDatasources == null ? other$powerBIDatasources != null : !this$powerBIDatasources.equals(other$powerBIDatasources)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        SortedSet<ILineageProcess> this$powerBIProcesses = this.getPowerBIProcesses();
        SortedSet<ILineageProcess> other$powerBIProcesses = other.getPowerBIProcesses();
        if (this$powerBIProcesses == null ? other$powerBIProcesses != null : !this$powerBIProcesses.equals(other$powerBIProcesses)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        if (this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName)) {
            return false;
        }
        SortedSet<IPowerBITable> this$tables = this.getTables();
        SortedSet<IPowerBITable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        String this$webUrl = this.getWebUrl();
        String other$webUrl = other.getWebUrl();
        if (this$webUrl == null ? other$webUrl != null : !this$webUrl.equals(other$webUrl)) {
            return false;
        }
        IPowerBIWorkspace this$workspace = this.getWorkspace();
        IPowerBIWorkspace other$workspace = other.getWorkspace();
        if (this$workspace == null ? other$workspace != null : !this$workspace.equals(other$workspace)) {
            return false;
        }
        String this$workspaceQualifiedName = this.getWorkspaceQualifiedName();
        String other$workspaceQualifiedName = other.getWorkspaceQualifiedName();
        return !(this$workspaceQualifiedName == null ? other$workspaceQualifiedName != null : !this$workspaceQualifiedName.equals(other$workspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDataflow;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IPowerBIDataset> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : $datasets.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<IPowerBIDataflow> $powerBIDataflowChildren = this.getPowerBIDataflowChildren();
        result = result * 59 + ($powerBIDataflowChildren == null ? 43 : $powerBIDataflowChildren.hashCode());
        SortedSet<IPowerBIDataflowEntityColumn> $powerBIDataflowEntityColumns = this.getPowerBIDataflowEntityColumns();
        result = result * 59 + ($powerBIDataflowEntityColumns == null ? 43 : $powerBIDataflowEntityColumns.hashCode());
        SortedSet<IPowerBIDataflow> $powerBIDataflowParents = this.getPowerBIDataflowParents();
        result = result * 59 + ($powerBIDataflowParents == null ? 43 : $powerBIDataflowParents.hashCode());
        String $powerBIDataflowRefreshScheduleFrequency = this.getPowerBIDataflowRefreshScheduleFrequency();
        result = result * 59 + ($powerBIDataflowRefreshScheduleFrequency == null ? 43 : $powerBIDataflowRefreshScheduleFrequency.hashCode());
        String $powerBIDataflowRefreshScheduleTimeZone = this.getPowerBIDataflowRefreshScheduleTimeZone();
        result = result * 59 + ($powerBIDataflowRefreshScheduleTimeZone == null ? 43 : $powerBIDataflowRefreshScheduleTimeZone.hashCode());
        SortedSet<String> $powerBIDataflowRefreshScheduleTimes = this.getPowerBIDataflowRefreshScheduleTimes();
        result = result * 59 + ($powerBIDataflowRefreshScheduleTimes == null ? 43 : $powerBIDataflowRefreshScheduleTimes.hashCode());
        SortedSet<IPowerBIDatasource> $powerBIDatasources = this.getPowerBIDatasources();
        result = result * 59 + ($powerBIDatasources == null ? 43 : $powerBIDatasources.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        SortedSet<ILineageProcess> $powerBIProcesses = this.getPowerBIProcesses();
        result = result * 59 + ($powerBIProcesses == null ? 43 : $powerBIProcesses.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        SortedSet<IPowerBITable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        String $webUrl = this.getWebUrl();
        result = result * 59 + ($webUrl == null ? 43 : $webUrl.hashCode());
        IPowerBIWorkspace $workspace = this.getWorkspace();
        result = result * 59 + ($workspace == null ? 43 : $workspace.hashCode());
        String $workspaceQualifiedName = this.getWorkspaceQualifiedName();
        result = result * 59 + ($workspaceQualifiedName == null ? 43 : $workspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBIDataflow(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", datasets=" + String.valueOf(this.getDatasets()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", powerBIDataflowChildren=" + String.valueOf(this.getPowerBIDataflowChildren()) + ", powerBIDataflowEntityColumns=" + String.valueOf(this.getPowerBIDataflowEntityColumns()) + ", powerBIDataflowParents=" + String.valueOf(this.getPowerBIDataflowParents()) + ", powerBIDataflowRefreshScheduleFrequency=" + this.getPowerBIDataflowRefreshScheduleFrequency() + ", powerBIDataflowRefreshScheduleTimeZone=" + this.getPowerBIDataflowRefreshScheduleTimeZone() + ", powerBIDataflowRefreshScheduleTimes=" + String.valueOf(this.getPowerBIDataflowRefreshScheduleTimes()) + ", powerBIDatasources=" + String.valueOf(this.getPowerBIDatasources()) + ", powerBIEndorsement=" + String.valueOf(this.getPowerBIEndorsement()) + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBIProcesses=" + String.valueOf(this.getPowerBIProcesses()) + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ", tables=" + String.valueOf(this.getTables()) + ", webUrl=" + this.getWebUrl() + ", workspace=" + String.valueOf(this.getWorkspace()) + ", workspaceQualifiedName=" + this.getWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class PowerBIDataflowBuilder<C extends PowerBIDataflow, B extends PowerBIDataflowBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IPowerBIDataset> datasets;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<IPowerBIDataflow> powerBIDataflowChildren;
        @Generated
        private ArrayList<IPowerBIDataflowEntityColumn> powerBIDataflowEntityColumns;
        @Generated
        private ArrayList<IPowerBIDataflow> powerBIDataflowParents;
        @Generated
        private String powerBIDataflowRefreshScheduleFrequency;
        @Generated
        private String powerBIDataflowRefreshScheduleTimeZone;
        @Generated
        private ArrayList<String> powerBIDataflowRefreshScheduleTimes;
        @Generated
        private ArrayList<IPowerBIDatasource> powerBIDatasources;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private ArrayList<ILineageProcess> powerBIProcesses;
        @Generated
        private String powerBITableQualifiedName;
        @Generated
        private ArrayList<IPowerBITable> tables;
        @Generated
        private String webUrl;
        @Generated
        private IPowerBIWorkspace workspace;
        @Generated
        private String workspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDataflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDataflow instance, PowerBIDataflowBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.datasets(instance.datasets == null ? Collections.emptySortedSet() : instance.datasets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIDataflowChildren(instance.powerBIDataflowChildren == null ? Collections.emptySortedSet() : instance.powerBIDataflowChildren);
            b.powerBIDataflowEntityColumns(instance.powerBIDataflowEntityColumns == null ? Collections.emptySortedSet() : instance.powerBIDataflowEntityColumns);
            b.powerBIDataflowParents(instance.powerBIDataflowParents == null ? Collections.emptySortedSet() : instance.powerBIDataflowParents);
            b.powerBIDataflowRefreshScheduleFrequency(instance.powerBIDataflowRefreshScheduleFrequency);
            b.powerBIDataflowRefreshScheduleTimeZone(instance.powerBIDataflowRefreshScheduleTimeZone);
            b.powerBIDataflowRefreshScheduleTimes(instance.powerBIDataflowRefreshScheduleTimes == null ? Collections.emptySortedSet() : instance.powerBIDataflowRefreshScheduleTimes);
            b.powerBIDatasources(instance.powerBIDatasources == null ? Collections.emptySortedSet() : instance.powerBIDatasources);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBIProcesses(instance.powerBIProcesses == null ? Collections.emptySortedSet() : instance.powerBIProcesses);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.webUrl(instance.webUrl);
            b.workspace(instance.workspace);
            b.workspaceQualifiedName(instance.workspaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataset(IPowerBIDataset dataset) {
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.add(dataset);
            return (B)this.self();
        }

        @Generated
        public B datasets(Collection<? extends IPowerBIDataset> datasets) {
            if (datasets == null) {
                throw new NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.addAll(datasets);
            return (B)this.self();
        }

        @Generated
        public B clearDatasets() {
            if (this.datasets != null) {
                this.datasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowChild(IPowerBIDataflow powerBIDataflowChild) {
            if (this.powerBIDataflowChildren == null) {
                this.powerBIDataflowChildren = new ArrayList();
            }
            this.powerBIDataflowChildren.add(powerBIDataflowChild);
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowChildren(Collection<? extends IPowerBIDataflow> powerBIDataflowChildren) {
            if (powerBIDataflowChildren == null) {
                throw new NullPointerException("powerBIDataflowChildren cannot be null");
            }
            if (this.powerBIDataflowChildren == null) {
                this.powerBIDataflowChildren = new ArrayList();
            }
            this.powerBIDataflowChildren.addAll(powerBIDataflowChildren);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDataflowChildren() {
            if (this.powerBIDataflowChildren != null) {
                this.powerBIDataflowChildren.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowEntityColumn(IPowerBIDataflowEntityColumn powerBIDataflowEntityColumn) {
            if (this.powerBIDataflowEntityColumns == null) {
                this.powerBIDataflowEntityColumns = new ArrayList();
            }
            this.powerBIDataflowEntityColumns.add(powerBIDataflowEntityColumn);
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowEntityColumns(Collection<? extends IPowerBIDataflowEntityColumn> powerBIDataflowEntityColumns) {
            if (powerBIDataflowEntityColumns == null) {
                throw new NullPointerException("powerBIDataflowEntityColumns cannot be null");
            }
            if (this.powerBIDataflowEntityColumns == null) {
                this.powerBIDataflowEntityColumns = new ArrayList();
            }
            this.powerBIDataflowEntityColumns.addAll(powerBIDataflowEntityColumns);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDataflowEntityColumns() {
            if (this.powerBIDataflowEntityColumns != null) {
                this.powerBIDataflowEntityColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowParent(IPowerBIDataflow powerBIDataflowParent) {
            if (this.powerBIDataflowParents == null) {
                this.powerBIDataflowParents = new ArrayList();
            }
            this.powerBIDataflowParents.add(powerBIDataflowParent);
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowParents(Collection<? extends IPowerBIDataflow> powerBIDataflowParents) {
            if (powerBIDataflowParents == null) {
                throw new NullPointerException("powerBIDataflowParents cannot be null");
            }
            if (this.powerBIDataflowParents == null) {
                this.powerBIDataflowParents = new ArrayList();
            }
            this.powerBIDataflowParents.addAll(powerBIDataflowParents);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDataflowParents() {
            if (this.powerBIDataflowParents != null) {
                this.powerBIDataflowParents.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowRefreshScheduleFrequency(String powerBIDataflowRefreshScheduleFrequency) {
            this.powerBIDataflowRefreshScheduleFrequency = powerBIDataflowRefreshScheduleFrequency;
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowRefreshScheduleTimeZone(String powerBIDataflowRefreshScheduleTimeZone) {
            this.powerBIDataflowRefreshScheduleTimeZone = powerBIDataflowRefreshScheduleTimeZone;
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowRefreshScheduleTime(String powerBIDataflowRefreshScheduleTime) {
            if (this.powerBIDataflowRefreshScheduleTimes == null) {
                this.powerBIDataflowRefreshScheduleTimes = new ArrayList();
            }
            this.powerBIDataflowRefreshScheduleTimes.add(powerBIDataflowRefreshScheduleTime);
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflowRefreshScheduleTimes(Collection<? extends String> powerBIDataflowRefreshScheduleTimes) {
            if (powerBIDataflowRefreshScheduleTimes == null) {
                throw new NullPointerException("powerBIDataflowRefreshScheduleTimes cannot be null");
            }
            if (this.powerBIDataflowRefreshScheduleTimes == null) {
                this.powerBIDataflowRefreshScheduleTimes = new ArrayList();
            }
            this.powerBIDataflowRefreshScheduleTimes.addAll(powerBIDataflowRefreshScheduleTimes);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDataflowRefreshScheduleTimes() {
            if (this.powerBIDataflowRefreshScheduleTimes != null) {
                this.powerBIDataflowRefreshScheduleTimes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDatasource(IPowerBIDatasource powerBIDatasource) {
            if (this.powerBIDatasources == null) {
                this.powerBIDatasources = new ArrayList();
            }
            this.powerBIDatasources.add(powerBIDatasource);
            return (B)this.self();
        }

        @Generated
        public B powerBIDatasources(Collection<? extends IPowerBIDatasource> powerBIDatasources) {
            if (powerBIDatasources == null) {
                throw new NullPointerException("powerBIDatasources cannot be null");
            }
            if (this.powerBIDatasources == null) {
                this.powerBIDatasources = new ArrayList();
            }
            this.powerBIDatasources.addAll(powerBIDatasources);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIDatasources() {
            if (this.powerBIDatasources != null) {
                this.powerBIDatasources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBIProcess(ILineageProcess powerBIProcess) {
            if (this.powerBIProcesses == null) {
                this.powerBIProcesses = new ArrayList();
            }
            this.powerBIProcesses.add(powerBIProcess);
            return (B)this.self();
        }

        @Generated
        public B powerBIProcesses(Collection<? extends ILineageProcess> powerBIProcesses) {
            if (powerBIProcesses == null) {
                throw new NullPointerException("powerBIProcesses cannot be null");
            }
            if (this.powerBIProcesses == null) {
                this.powerBIProcesses = new ArrayList();
            }
            this.powerBIProcesses.addAll(powerBIProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearPowerBIProcesses() {
            if (this.powerBIProcesses != null) {
                this.powerBIProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B table(IPowerBITable table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends IPowerBITable> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B webUrl(String webUrl) {
            this.webUrl = webUrl;
            return (B)this.self();
        }

        @Generated
        public B workspace(IPowerBIWorkspace workspace) {
            this.workspace = workspace;
            return (B)this.self();
        }

        @Generated
        public B workspaceQualifiedName(String workspaceQualifiedName) {
            this.workspaceQualifiedName = workspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBIDataflow.PowerBIDataflowBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", datasets=" + String.valueOf(this.datasets) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", powerBIDataflowChildren=" + String.valueOf(this.powerBIDataflowChildren) + ", powerBIDataflowEntityColumns=" + String.valueOf(this.powerBIDataflowEntityColumns) + ", powerBIDataflowParents=" + String.valueOf(this.powerBIDataflowParents) + ", powerBIDataflowRefreshScheduleFrequency=" + this.powerBIDataflowRefreshScheduleFrequency + ", powerBIDataflowRefreshScheduleTimeZone=" + this.powerBIDataflowRefreshScheduleTimeZone + ", powerBIDataflowRefreshScheduleTimes=" + String.valueOf(this.powerBIDataflowRefreshScheduleTimes) + ", powerBIDatasources=" + String.valueOf(this.powerBIDatasources) + ", powerBIEndorsement=" + String.valueOf(this.powerBIEndorsement) + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBIProcesses=" + String.valueOf(this.powerBIProcesses) + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ", tables=" + String.valueOf(this.tables) + ", webUrl=" + this.webUrl + ", workspace=" + String.valueOf(this.workspace) + ", workspaceQualifiedName=" + this.workspaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class PowerBIDataflowBuilderImpl
    extends PowerBIDataflowBuilder<PowerBIDataflow, PowerBIDataflowBuilderImpl> {
        @Generated
        private PowerBIDataflowBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDataflowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDataflow build() {
            return new PowerBIDataflow(this);
        }
    }
}

