/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IPreset;
import com.atlan.model.assets.IPresetDashboard;
import com.atlan.model.assets.IPresetWorkspace;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetWorkspace
extends Asset
implements IPresetWorkspace,
IPreset,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PresetWorkspace.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetWorkspace";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Long presetDashboardId;
    @Attribute
    String presetDashboardQualifiedName;
    @Attribute
    SortedSet<IPresetDashboard> presetDashboards;
    @Attribute
    Long presetWorkspaceClusterId;
    @Attribute
    Long presetWorkspaceDashboardCount;
    @Attribute
    Long presetWorkspaceDatasetCount;
    @Attribute
    Long presetWorkspaceDeploymentId;
    @Attribute
    String presetWorkspaceHostname;
    @Attribute
    Long presetWorkspaceId;
    @Attribute
    Boolean presetWorkspaceIsInMaintenanceMode;
    @Attribute
    Boolean presetWorkspacePublicDashboardsAllowed;
    @Attribute
    String presetWorkspaceQualifiedName;
    @Attribute
    String presetWorkspaceRegion;
    @Attribute
    String presetWorkspaceStatus;

    @Override
    public PresetWorkspace trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PresetWorkspace.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PresetWorkspace.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PresetWorkspace.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PresetWorkspace.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PresetWorkspace refByGuid(String guid) {
        return PresetWorkspace.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PresetWorkspace refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PresetWorkspace refByQualifiedName(String qualifiedName) {
        return PresetWorkspace.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PresetWorkspace refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id) throws AtlanException {
        return PresetWorkspace.get(client, id, false);
    }

    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PresetWorkspace) {
                return (PresetWorkspace)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof PresetWorkspace) {
            return (PresetWorkspace)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return PresetWorkspace.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static PresetWorkspace get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PresetWorkspace.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof PresetWorkspace) {
                return (PresetWorkspace)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)PresetWorkspace.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof PresetWorkspace) {
            return (PresetWorkspace)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PresetWorkspaceBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (PresetWorkspaceBuilder)((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(PresetWorkspace.generateQualifiedName(connectionQualifiedName, name))).name(name)).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetWorkspaceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetWorkspaceBuilder)((PresetWorkspaceBuilder)((PresetWorkspaceBuilder)PresetWorkspace._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PresetWorkspaceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        PresetWorkspace.validateRequired(TYPE_NAME, map);
        return PresetWorkspace.updater(this.getQualifiedName(), this.getName());
    }

    private static String generateQualifiedName(String connectionQualifiedName, String name) {
        return connectionQualifiedName + "/" + name;
    }

    public static PresetWorkspace removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeDescription(client, PresetWorkspace.updater(qualifiedName, name));
    }

    public static PresetWorkspace removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeUserDescription(client, PresetWorkspace.updater(qualifiedName, name));
    }

    public static PresetWorkspace removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeOwners(client, PresetWorkspace.updater(qualifiedName, name));
    }

    public static PresetWorkspace updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PresetWorkspace)Asset.updateCertificate(client, PresetWorkspace._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetWorkspace removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeCertificate(client, PresetWorkspace.updater(qualifiedName, name));
    }

    public static PresetWorkspace updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetWorkspace)Asset.updateAnnouncement(client, PresetWorkspace._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetWorkspace removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetWorkspace)Asset.removeAnnouncement(client, PresetWorkspace.updater(qualifiedName, name));
    }

    public static PresetWorkspace replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.replaceTerms(client, PresetWorkspace.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static PresetWorkspace appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PresetWorkspace removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetWorkspace)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static PresetWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PresetWorkspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static PresetWorkspace appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PresetWorkspace)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetWorkspace(PresetWorkspaceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : PresetWorkspace.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.presetDashboardId = b.presetDashboardId;
        this.presetDashboardQualifiedName = b.presetDashboardQualifiedName;
        SortedSet<IPresetDashboard> presetDashboards = new TreeSet<IPresetDashboard>();
        if (b.presetDashboards != null) {
            presetDashboards.addAll(b.presetDashboards);
        }
        presetDashboards = Collections.unmodifiableSortedSet(presetDashboards);
        this.presetDashboards = presetDashboards;
        this.presetWorkspaceClusterId = b.presetWorkspaceClusterId;
        this.presetWorkspaceDashboardCount = b.presetWorkspaceDashboardCount;
        this.presetWorkspaceDatasetCount = b.presetWorkspaceDatasetCount;
        this.presetWorkspaceDeploymentId = b.presetWorkspaceDeploymentId;
        this.presetWorkspaceHostname = b.presetWorkspaceHostname;
        this.presetWorkspaceId = b.presetWorkspaceId;
        this.presetWorkspaceIsInMaintenanceMode = b.presetWorkspaceIsInMaintenanceMode;
        this.presetWorkspacePublicDashboardsAllowed = b.presetWorkspacePublicDashboardsAllowed;
        this.presetWorkspaceQualifiedName = b.presetWorkspaceQualifiedName;
        this.presetWorkspaceRegion = b.presetWorkspaceRegion;
        this.presetWorkspaceStatus = b.presetWorkspaceStatus;
    }

    @Generated
    public static PresetWorkspaceBuilder<?, ?> _internal() {
        return new PresetWorkspaceBuilderImpl();
    }

    @Generated
    public PresetWorkspaceBuilder<?, ?> toBuilder() {
        return new PresetWorkspaceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Long getPresetDashboardId() {
        return this.presetDashboardId;
    }

    @Override
    @Generated
    public String getPresetDashboardQualifiedName() {
        return this.presetDashboardQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IPresetDashboard> getPresetDashboards() {
        return this.presetDashboards;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceClusterId() {
        return this.presetWorkspaceClusterId;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceDashboardCount() {
        return this.presetWorkspaceDashboardCount;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceDatasetCount() {
        return this.presetWorkspaceDatasetCount;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceDeploymentId() {
        return this.presetWorkspaceDeploymentId;
    }

    @Override
    @Generated
    public String getPresetWorkspaceHostname() {
        return this.presetWorkspaceHostname;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceId() {
        return this.presetWorkspaceId;
    }

    @Override
    @Generated
    public Boolean getPresetWorkspaceIsInMaintenanceMode() {
        return this.presetWorkspaceIsInMaintenanceMode;
    }

    @Override
    @Generated
    public Boolean getPresetWorkspacePublicDashboardsAllowed() {
        return this.presetWorkspacePublicDashboardsAllowed;
    }

    @Override
    @Generated
    public String getPresetWorkspaceQualifiedName() {
        return this.presetWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public String getPresetWorkspaceRegion() {
        return this.presetWorkspaceRegion;
    }

    @Override
    @Generated
    public String getPresetWorkspaceStatus() {
        return this.presetWorkspaceStatus;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetWorkspace)) {
            return false;
        }
        PresetWorkspace other = (PresetWorkspace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$presetDashboardId = this.getPresetDashboardId();
        Long other$presetDashboardId = other.getPresetDashboardId();
        if (this$presetDashboardId == null ? other$presetDashboardId != null : !((Object)this$presetDashboardId).equals(other$presetDashboardId)) {
            return false;
        }
        Long this$presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        Long other$presetWorkspaceClusterId = other.getPresetWorkspaceClusterId();
        if (this$presetWorkspaceClusterId == null ? other$presetWorkspaceClusterId != null : !((Object)this$presetWorkspaceClusterId).equals(other$presetWorkspaceClusterId)) {
            return false;
        }
        Long this$presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        Long other$presetWorkspaceDashboardCount = other.getPresetWorkspaceDashboardCount();
        if (this$presetWorkspaceDashboardCount == null ? other$presetWorkspaceDashboardCount != null : !((Object)this$presetWorkspaceDashboardCount).equals(other$presetWorkspaceDashboardCount)) {
            return false;
        }
        Long this$presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        Long other$presetWorkspaceDatasetCount = other.getPresetWorkspaceDatasetCount();
        if (this$presetWorkspaceDatasetCount == null ? other$presetWorkspaceDatasetCount != null : !((Object)this$presetWorkspaceDatasetCount).equals(other$presetWorkspaceDatasetCount)) {
            return false;
        }
        Long this$presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        Long other$presetWorkspaceDeploymentId = other.getPresetWorkspaceDeploymentId();
        if (this$presetWorkspaceDeploymentId == null ? other$presetWorkspaceDeploymentId != null : !((Object)this$presetWorkspaceDeploymentId).equals(other$presetWorkspaceDeploymentId)) {
            return false;
        }
        Long this$presetWorkspaceId = this.getPresetWorkspaceId();
        Long other$presetWorkspaceId = other.getPresetWorkspaceId();
        if (this$presetWorkspaceId == null ? other$presetWorkspaceId != null : !((Object)this$presetWorkspaceId).equals(other$presetWorkspaceId)) {
            return false;
        }
        Boolean this$presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        Boolean other$presetWorkspaceIsInMaintenanceMode = other.getPresetWorkspaceIsInMaintenanceMode();
        if (this$presetWorkspaceIsInMaintenanceMode == null ? other$presetWorkspaceIsInMaintenanceMode != null : !((Object)this$presetWorkspaceIsInMaintenanceMode).equals(other$presetWorkspaceIsInMaintenanceMode)) {
            return false;
        }
        Boolean this$presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        Boolean other$presetWorkspacePublicDashboardsAllowed = other.getPresetWorkspacePublicDashboardsAllowed();
        if (this$presetWorkspacePublicDashboardsAllowed == null ? other$presetWorkspacePublicDashboardsAllowed != null : !((Object)this$presetWorkspacePublicDashboardsAllowed).equals(other$presetWorkspacePublicDashboardsAllowed)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        String other$presetDashboardQualifiedName = other.getPresetDashboardQualifiedName();
        if (this$presetDashboardQualifiedName == null ? other$presetDashboardQualifiedName != null : !this$presetDashboardQualifiedName.equals(other$presetDashboardQualifiedName)) {
            return false;
        }
        SortedSet<IPresetDashboard> this$presetDashboards = this.getPresetDashboards();
        SortedSet<IPresetDashboard> other$presetDashboards = other.getPresetDashboards();
        if (this$presetDashboards == null ? other$presetDashboards != null : !this$presetDashboards.equals(other$presetDashboards)) {
            return false;
        }
        String this$presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        String other$presetWorkspaceHostname = other.getPresetWorkspaceHostname();
        if (this$presetWorkspaceHostname == null ? other$presetWorkspaceHostname != null : !this$presetWorkspaceHostname.equals(other$presetWorkspaceHostname)) {
            return false;
        }
        String this$presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        String other$presetWorkspaceQualifiedName = other.getPresetWorkspaceQualifiedName();
        if (this$presetWorkspaceQualifiedName == null ? other$presetWorkspaceQualifiedName != null : !this$presetWorkspaceQualifiedName.equals(other$presetWorkspaceQualifiedName)) {
            return false;
        }
        String this$presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        String other$presetWorkspaceRegion = other.getPresetWorkspaceRegion();
        if (this$presetWorkspaceRegion == null ? other$presetWorkspaceRegion != null : !this$presetWorkspaceRegion.equals(other$presetWorkspaceRegion)) {
            return false;
        }
        String this$presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        String other$presetWorkspaceStatus = other.getPresetWorkspaceStatus();
        return !(this$presetWorkspaceStatus == null ? other$presetWorkspaceStatus != null : !this$presetWorkspaceStatus.equals(other$presetWorkspaceStatus));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetWorkspace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $presetDashboardId = this.getPresetDashboardId();
        result = result * 59 + ($presetDashboardId == null ? 43 : ((Object)$presetDashboardId).hashCode());
        Long $presetWorkspaceClusterId = this.getPresetWorkspaceClusterId();
        result = result * 59 + ($presetWorkspaceClusterId == null ? 43 : ((Object)$presetWorkspaceClusterId).hashCode());
        Long $presetWorkspaceDashboardCount = this.getPresetWorkspaceDashboardCount();
        result = result * 59 + ($presetWorkspaceDashboardCount == null ? 43 : ((Object)$presetWorkspaceDashboardCount).hashCode());
        Long $presetWorkspaceDatasetCount = this.getPresetWorkspaceDatasetCount();
        result = result * 59 + ($presetWorkspaceDatasetCount == null ? 43 : ((Object)$presetWorkspaceDatasetCount).hashCode());
        Long $presetWorkspaceDeploymentId = this.getPresetWorkspaceDeploymentId();
        result = result * 59 + ($presetWorkspaceDeploymentId == null ? 43 : ((Object)$presetWorkspaceDeploymentId).hashCode());
        Long $presetWorkspaceId = this.getPresetWorkspaceId();
        result = result * 59 + ($presetWorkspaceId == null ? 43 : ((Object)$presetWorkspaceId).hashCode());
        Boolean $presetWorkspaceIsInMaintenanceMode = this.getPresetWorkspaceIsInMaintenanceMode();
        result = result * 59 + ($presetWorkspaceIsInMaintenanceMode == null ? 43 : ((Object)$presetWorkspaceIsInMaintenanceMode).hashCode());
        Boolean $presetWorkspacePublicDashboardsAllowed = this.getPresetWorkspacePublicDashboardsAllowed();
        result = result * 59 + ($presetWorkspacePublicDashboardsAllowed == null ? 43 : ((Object)$presetWorkspacePublicDashboardsAllowed).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        result = result * 59 + ($presetDashboardQualifiedName == null ? 43 : $presetDashboardQualifiedName.hashCode());
        SortedSet<IPresetDashboard> $presetDashboards = this.getPresetDashboards();
        result = result * 59 + ($presetDashboards == null ? 43 : $presetDashboards.hashCode());
        String $presetWorkspaceHostname = this.getPresetWorkspaceHostname();
        result = result * 59 + ($presetWorkspaceHostname == null ? 43 : $presetWorkspaceHostname.hashCode());
        String $presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        result = result * 59 + ($presetWorkspaceQualifiedName == null ? 43 : $presetWorkspaceQualifiedName.hashCode());
        String $presetWorkspaceRegion = this.getPresetWorkspaceRegion();
        result = result * 59 + ($presetWorkspaceRegion == null ? 43 : $presetWorkspaceRegion.hashCode());
        String $presetWorkspaceStatus = this.getPresetWorkspaceStatus();
        result = result * 59 + ($presetWorkspaceStatus == null ? 43 : $presetWorkspaceStatus.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PresetWorkspace(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", presetDashboardId=" + this.getPresetDashboardId() + ", presetDashboardQualifiedName=" + this.getPresetDashboardQualifiedName() + ", presetDashboards=" + String.valueOf(this.getPresetDashboards()) + ", presetWorkspaceClusterId=" + this.getPresetWorkspaceClusterId() + ", presetWorkspaceDashboardCount=" + this.getPresetWorkspaceDashboardCount() + ", presetWorkspaceDatasetCount=" + this.getPresetWorkspaceDatasetCount() + ", presetWorkspaceDeploymentId=" + this.getPresetWorkspaceDeploymentId() + ", presetWorkspaceHostname=" + this.getPresetWorkspaceHostname() + ", presetWorkspaceId=" + this.getPresetWorkspaceId() + ", presetWorkspaceIsInMaintenanceMode=" + this.getPresetWorkspaceIsInMaintenanceMode() + ", presetWorkspacePublicDashboardsAllowed=" + this.getPresetWorkspacePublicDashboardsAllowed() + ", presetWorkspaceQualifiedName=" + this.getPresetWorkspaceQualifiedName() + ", presetWorkspaceRegion=" + this.getPresetWorkspaceRegion() + ", presetWorkspaceStatus=" + this.getPresetWorkspaceStatus() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class PresetWorkspaceBuilder<C extends PresetWorkspace, B extends PresetWorkspaceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Long presetDashboardId;
        @Generated
        private String presetDashboardQualifiedName;
        @Generated
        private ArrayList<IPresetDashboard> presetDashboards;
        @Generated
        private Long presetWorkspaceClusterId;
        @Generated
        private Long presetWorkspaceDashboardCount;
        @Generated
        private Long presetWorkspaceDatasetCount;
        @Generated
        private Long presetWorkspaceDeploymentId;
        @Generated
        private String presetWorkspaceHostname;
        @Generated
        private Long presetWorkspaceId;
        @Generated
        private Boolean presetWorkspaceIsInMaintenanceMode;
        @Generated
        private Boolean presetWorkspacePublicDashboardsAllowed;
        @Generated
        private String presetWorkspaceQualifiedName;
        @Generated
        private String presetWorkspaceRegion;
        @Generated
        private String presetWorkspaceStatus;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetWorkspaceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetWorkspace instance, PresetWorkspaceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.presetDashboardId(instance.presetDashboardId);
            b.presetDashboardQualifiedName(instance.presetDashboardQualifiedName);
            b.presetDashboards(instance.presetDashboards == null ? Collections.emptySortedSet() : instance.presetDashboards);
            b.presetWorkspaceClusterId(instance.presetWorkspaceClusterId);
            b.presetWorkspaceDashboardCount(instance.presetWorkspaceDashboardCount);
            b.presetWorkspaceDatasetCount(instance.presetWorkspaceDatasetCount);
            b.presetWorkspaceDeploymentId(instance.presetWorkspaceDeploymentId);
            b.presetWorkspaceHostname(instance.presetWorkspaceHostname);
            b.presetWorkspaceId(instance.presetWorkspaceId);
            b.presetWorkspaceIsInMaintenanceMode(instance.presetWorkspaceIsInMaintenanceMode);
            b.presetWorkspacePublicDashboardsAllowed(instance.presetWorkspacePublicDashboardsAllowed);
            b.presetWorkspaceQualifiedName(instance.presetWorkspaceQualifiedName);
            b.presetWorkspaceRegion(instance.presetWorkspaceRegion);
            b.presetWorkspaceStatus(instance.presetWorkspaceStatus);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetDashboardId(Long presetDashboardId) {
            this.presetDashboardId = presetDashboardId;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardQualifiedName(String presetDashboardQualifiedName) {
            this.presetDashboardQualifiedName = presetDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B presetDashboard(IPresetDashboard presetDashboard) {
            if (this.presetDashboards == null) {
                this.presetDashboards = new ArrayList();
            }
            this.presetDashboards.add(presetDashboard);
            return (B)this.self();
        }

        @Generated
        public B presetDashboards(Collection<? extends IPresetDashboard> presetDashboards) {
            if (presetDashboards == null) {
                throw new NullPointerException("presetDashboards cannot be null");
            }
            if (this.presetDashboards == null) {
                this.presetDashboards = new ArrayList();
            }
            this.presetDashboards.addAll(presetDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearPresetDashboards() {
            if (this.presetDashboards != null) {
                this.presetDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceClusterId(Long presetWorkspaceClusterId) {
            this.presetWorkspaceClusterId = presetWorkspaceClusterId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDashboardCount(Long presetWorkspaceDashboardCount) {
            this.presetWorkspaceDashboardCount = presetWorkspaceDashboardCount;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDatasetCount(Long presetWorkspaceDatasetCount) {
            this.presetWorkspaceDatasetCount = presetWorkspaceDatasetCount;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceDeploymentId(Long presetWorkspaceDeploymentId) {
            this.presetWorkspaceDeploymentId = presetWorkspaceDeploymentId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceHostname(String presetWorkspaceHostname) {
            this.presetWorkspaceHostname = presetWorkspaceHostname;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceId(Long presetWorkspaceId) {
            this.presetWorkspaceId = presetWorkspaceId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceIsInMaintenanceMode(Boolean presetWorkspaceIsInMaintenanceMode) {
            this.presetWorkspaceIsInMaintenanceMode = presetWorkspaceIsInMaintenanceMode;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspacePublicDashboardsAllowed(Boolean presetWorkspacePublicDashboardsAllowed) {
            this.presetWorkspacePublicDashboardsAllowed = presetWorkspacePublicDashboardsAllowed;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceQualifiedName(String presetWorkspaceQualifiedName) {
            this.presetWorkspaceQualifiedName = presetWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceRegion(String presetWorkspaceRegion) {
            this.presetWorkspaceRegion = presetWorkspaceRegion;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceStatus(String presetWorkspaceStatus) {
            this.presetWorkspaceStatus = presetWorkspaceStatus;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PresetWorkspace.PresetWorkspaceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", presetDashboardId=" + this.presetDashboardId + ", presetDashboardQualifiedName=" + this.presetDashboardQualifiedName + ", presetDashboards=" + String.valueOf(this.presetDashboards) + ", presetWorkspaceClusterId=" + this.presetWorkspaceClusterId + ", presetWorkspaceDashboardCount=" + this.presetWorkspaceDashboardCount + ", presetWorkspaceDatasetCount=" + this.presetWorkspaceDatasetCount + ", presetWorkspaceDeploymentId=" + this.presetWorkspaceDeploymentId + ", presetWorkspaceHostname=" + this.presetWorkspaceHostname + ", presetWorkspaceId=" + this.presetWorkspaceId + ", presetWorkspaceIsInMaintenanceMode=" + this.presetWorkspaceIsInMaintenanceMode + ", presetWorkspacePublicDashboardsAllowed=" + this.presetWorkspacePublicDashboardsAllowed + ", presetWorkspaceQualifiedName=" + this.presetWorkspaceQualifiedName + ", presetWorkspaceRegion=" + this.presetWorkspaceRegion + ", presetWorkspaceStatus=" + this.presetWorkspaceStatus + ")";
        }
    }

    @Generated
    private static final class PresetWorkspaceBuilderImpl
    extends PresetWorkspaceBuilder<PresetWorkspace, PresetWorkspaceBuilderImpl> {
        @Generated
        private PresetWorkspaceBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetWorkspaceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetWorkspace build() {
            return new PresetWorkspace(this);
        }
    }
}

