/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IQuickSight;
import com.atlan.model.assets.IQuickSightAnalysis;
import com.atlan.model.assets.IQuickSightAnalysisVisual;
import com.atlan.model.assets.IQuickSightFolder;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QuickSightAnalysisStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickSightAnalysis
extends Asset
implements IQuickSightAnalysis,
IQuickSight,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickSightAnalysis.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightAnalysis";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<String> quickSightAnalysisCalculatedFields;
    @Attribute
    SortedSet<String> quickSightAnalysisFilterGroups;
    @Attribute
    SortedSet<IQuickSightFolder> quickSightAnalysisFolders;
    @Attribute
    SortedSet<String> quickSightAnalysisParameterDeclarations;
    @Attribute
    QuickSightAnalysisStatus quickSightAnalysisStatus;
    @Attribute
    SortedSet<IQuickSightAnalysisVisual> quickSightAnalysisVisuals;
    @Attribute
    String quickSightId;
    @Attribute
    String quickSightSheetId;
    @Attribute
    String quickSightSheetName;

    @Override
    public QuickSightAnalysis trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QuickSightAnalysis.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QuickSightAnalysis.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QuickSightAnalysis.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QuickSightAnalysis.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QuickSightAnalysis refByGuid(String guid) {
        return QuickSightAnalysis.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightAnalysis refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QuickSightAnalysisBuilder)((QuickSightAnalysisBuilder)QuickSightAnalysis._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QuickSightAnalysis refByQualifiedName(String qualifiedName) {
        return QuickSightAnalysis.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightAnalysis refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QuickSightAnalysisBuilder)((QuickSightAnalysisBuilder)QuickSightAnalysis._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QuickSightAnalysis get(AtlanClient client, String id) throws AtlanException {
        return QuickSightAnalysis.get(client, id, false);
    }

    @JsonIgnore
    public static QuickSightAnalysis get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QuickSightAnalysis) {
                return (QuickSightAnalysis)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof QuickSightAnalysis) {
            return (QuickSightAnalysis)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static QuickSightAnalysis get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return QuickSightAnalysis.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static QuickSightAnalysis get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)QuickSightAnalysis.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof QuickSightAnalysis) {
                return (QuickSightAnalysis)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)QuickSightAnalysis.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof QuickSightAnalysis) {
            return (QuickSightAnalysis)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QuickSightAnalysisBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QuickSightAnalysisBuilder)((QuickSightAnalysisBuilder)((QuickSightAnalysisBuilder)QuickSightAnalysis._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QuickSightAnalysisBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        QuickSightAnalysis.validateRequired(TYPE_NAME, map);
        return QuickSightAnalysis.updater(this.getQualifiedName(), this.getName());
    }

    public static QuickSightAnalysis removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeDescription(client, QuickSightAnalysis.updater(qualifiedName, name));
    }

    public static QuickSightAnalysis removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeUserDescription(client, QuickSightAnalysis.updater(qualifiedName, name));
    }

    public static QuickSightAnalysis removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeOwners(client, QuickSightAnalysis.updater(qualifiedName, name));
    }

    public static QuickSightAnalysis updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightAnalysis)Asset.updateCertificate(client, QuickSightAnalysis._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QuickSightAnalysis removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeCertificate(client, QuickSightAnalysis.updater(qualifiedName, name));
    }

    public static QuickSightAnalysis updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightAnalysis)Asset.updateAnnouncement(client, QuickSightAnalysis._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QuickSightAnalysis removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeAnnouncement(client, QuickSightAnalysis.updater(qualifiedName, name));
    }

    public static QuickSightAnalysis replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysis)Asset.replaceTerms(client, QuickSightAnalysis.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static QuickSightAnalysis appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysis)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static QuickSightAnalysis removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysis)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static QuickSightAnalysis appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightAnalysis)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static QuickSightAnalysis appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightAnalysis)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QuickSightAnalysis(QuickSightAnalysisBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QuickSightAnalysis.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<String> quickSightAnalysisCalculatedFields = new TreeSet<String>();
        if (b.quickSightAnalysisCalculatedFields != null) {
            quickSightAnalysisCalculatedFields.addAll(b.quickSightAnalysisCalculatedFields);
        }
        quickSightAnalysisCalculatedFields = Collections.unmodifiableSortedSet(quickSightAnalysisCalculatedFields);
        this.quickSightAnalysisCalculatedFields = quickSightAnalysisCalculatedFields;
        SortedSet<String> quickSightAnalysisFilterGroups = new TreeSet<String>();
        if (b.quickSightAnalysisFilterGroups != null) {
            quickSightAnalysisFilterGroups.addAll(b.quickSightAnalysisFilterGroups);
        }
        quickSightAnalysisFilterGroups = Collections.unmodifiableSortedSet(quickSightAnalysisFilterGroups);
        this.quickSightAnalysisFilterGroups = quickSightAnalysisFilterGroups;
        SortedSet<IQuickSightFolder> quickSightAnalysisFolders = new TreeSet<IQuickSightFolder>();
        if (b.quickSightAnalysisFolders != null) {
            quickSightAnalysisFolders.addAll(b.quickSightAnalysisFolders);
        }
        quickSightAnalysisFolders = Collections.unmodifiableSortedSet(quickSightAnalysisFolders);
        this.quickSightAnalysisFolders = quickSightAnalysisFolders;
        SortedSet<String> quickSightAnalysisParameterDeclarations = new TreeSet<String>();
        if (b.quickSightAnalysisParameterDeclarations != null) {
            quickSightAnalysisParameterDeclarations.addAll(b.quickSightAnalysisParameterDeclarations);
        }
        quickSightAnalysisParameterDeclarations = Collections.unmodifiableSortedSet(quickSightAnalysisParameterDeclarations);
        this.quickSightAnalysisParameterDeclarations = quickSightAnalysisParameterDeclarations;
        this.quickSightAnalysisStatus = b.quickSightAnalysisStatus;
        SortedSet<IQuickSightAnalysisVisual> quickSightAnalysisVisuals = new TreeSet<IQuickSightAnalysisVisual>();
        if (b.quickSightAnalysisVisuals != null) {
            quickSightAnalysisVisuals.addAll(b.quickSightAnalysisVisuals);
        }
        quickSightAnalysisVisuals = Collections.unmodifiableSortedSet(quickSightAnalysisVisuals);
        this.quickSightAnalysisVisuals = quickSightAnalysisVisuals;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @Generated
    public static QuickSightAnalysisBuilder<?, ?> _internal() {
        return new QuickSightAnalysisBuilderImpl();
    }

    @Generated
    public QuickSightAnalysisBuilder<?, ?> toBuilder() {
        return new QuickSightAnalysisBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<String> getQuickSightAnalysisCalculatedFields() {
        return this.quickSightAnalysisCalculatedFields;
    }

    @Override
    @Generated
    public SortedSet<String> getQuickSightAnalysisFilterGroups() {
        return this.quickSightAnalysisFilterGroups;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightFolder> getQuickSightAnalysisFolders() {
        return this.quickSightAnalysisFolders;
    }

    @Override
    @Generated
    public SortedSet<String> getQuickSightAnalysisParameterDeclarations() {
        return this.quickSightAnalysisParameterDeclarations;
    }

    @Override
    @Generated
    public QuickSightAnalysisStatus getQuickSightAnalysisStatus() {
        return this.quickSightAnalysisStatus;
    }

    @Override
    @Generated
    public SortedSet<IQuickSightAnalysisVisual> getQuickSightAnalysisVisuals() {
        return this.quickSightAnalysisVisuals;
    }

    @Override
    @Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    @Override
    @Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    @Override
    @Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuickSightAnalysis)) {
            return false;
        }
        QuickSightAnalysis other = (QuickSightAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<String> this$quickSightAnalysisCalculatedFields = this.getQuickSightAnalysisCalculatedFields();
        SortedSet<String> other$quickSightAnalysisCalculatedFields = other.getQuickSightAnalysisCalculatedFields();
        if (this$quickSightAnalysisCalculatedFields == null ? other$quickSightAnalysisCalculatedFields != null : !this$quickSightAnalysisCalculatedFields.equals(other$quickSightAnalysisCalculatedFields)) {
            return false;
        }
        SortedSet<String> this$quickSightAnalysisFilterGroups = this.getQuickSightAnalysisFilterGroups();
        SortedSet<String> other$quickSightAnalysisFilterGroups = other.getQuickSightAnalysisFilterGroups();
        if (this$quickSightAnalysisFilterGroups == null ? other$quickSightAnalysisFilterGroups != null : !this$quickSightAnalysisFilterGroups.equals(other$quickSightAnalysisFilterGroups)) {
            return false;
        }
        SortedSet<IQuickSightFolder> this$quickSightAnalysisFolders = this.getQuickSightAnalysisFolders();
        SortedSet<IQuickSightFolder> other$quickSightAnalysisFolders = other.getQuickSightAnalysisFolders();
        if (this$quickSightAnalysisFolders == null ? other$quickSightAnalysisFolders != null : !this$quickSightAnalysisFolders.equals(other$quickSightAnalysisFolders)) {
            return false;
        }
        SortedSet<String> this$quickSightAnalysisParameterDeclarations = this.getQuickSightAnalysisParameterDeclarations();
        SortedSet<String> other$quickSightAnalysisParameterDeclarations = other.getQuickSightAnalysisParameterDeclarations();
        if (this$quickSightAnalysisParameterDeclarations == null ? other$quickSightAnalysisParameterDeclarations != null : !this$quickSightAnalysisParameterDeclarations.equals(other$quickSightAnalysisParameterDeclarations)) {
            return false;
        }
        QuickSightAnalysisStatus this$quickSightAnalysisStatus = this.getQuickSightAnalysisStatus();
        QuickSightAnalysisStatus other$quickSightAnalysisStatus = other.getQuickSightAnalysisStatus();
        if (this$quickSightAnalysisStatus == null ? other$quickSightAnalysisStatus != null : !this$quickSightAnalysisStatus.equals(other$quickSightAnalysisStatus)) {
            return false;
        }
        SortedSet<IQuickSightAnalysisVisual> this$quickSightAnalysisVisuals = this.getQuickSightAnalysisVisuals();
        SortedSet<IQuickSightAnalysisVisual> other$quickSightAnalysisVisuals = other.getQuickSightAnalysisVisuals();
        if (this$quickSightAnalysisVisuals == null ? other$quickSightAnalysisVisuals != null : !this$quickSightAnalysisVisuals.equals(other$quickSightAnalysisVisuals)) {
            return false;
        }
        String this$quickSightId = this.getQuickSightId();
        String other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) {
            return false;
        }
        String this$quickSightSheetId = this.getQuickSightSheetId();
        String other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) {
            return false;
        }
        String this$quickSightSheetName = this.getQuickSightSheetName();
        String other$quickSightSheetName = other.getQuickSightSheetName();
        return !(this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuickSightAnalysis;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<String> $quickSightAnalysisCalculatedFields = this.getQuickSightAnalysisCalculatedFields();
        result = result * 59 + ($quickSightAnalysisCalculatedFields == null ? 43 : $quickSightAnalysisCalculatedFields.hashCode());
        SortedSet<String> $quickSightAnalysisFilterGroups = this.getQuickSightAnalysisFilterGroups();
        result = result * 59 + ($quickSightAnalysisFilterGroups == null ? 43 : $quickSightAnalysisFilterGroups.hashCode());
        SortedSet<IQuickSightFolder> $quickSightAnalysisFolders = this.getQuickSightAnalysisFolders();
        result = result * 59 + ($quickSightAnalysisFolders == null ? 43 : $quickSightAnalysisFolders.hashCode());
        SortedSet<String> $quickSightAnalysisParameterDeclarations = this.getQuickSightAnalysisParameterDeclarations();
        result = result * 59 + ($quickSightAnalysisParameterDeclarations == null ? 43 : $quickSightAnalysisParameterDeclarations.hashCode());
        QuickSightAnalysisStatus $quickSightAnalysisStatus = this.getQuickSightAnalysisStatus();
        result = result * 59 + ($quickSightAnalysisStatus == null ? 43 : $quickSightAnalysisStatus.hashCode());
        SortedSet<IQuickSightAnalysisVisual> $quickSightAnalysisVisuals = this.getQuickSightAnalysisVisuals();
        result = result * 59 + ($quickSightAnalysisVisuals == null ? 43 : $quickSightAnalysisVisuals.hashCode());
        String $quickSightId = this.getQuickSightId();
        result = result * 59 + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        String $quickSightSheetId = this.getQuickSightSheetId();
        result = result * 59 + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        String $quickSightSheetName = this.getQuickSightSheetName();
        result = result * 59 + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QuickSightAnalysis(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", quickSightAnalysisCalculatedFields=" + String.valueOf(this.getQuickSightAnalysisCalculatedFields()) + ", quickSightAnalysisFilterGroups=" + String.valueOf(this.getQuickSightAnalysisFilterGroups()) + ", quickSightAnalysisFolders=" + String.valueOf(this.getQuickSightAnalysisFolders()) + ", quickSightAnalysisParameterDeclarations=" + String.valueOf(this.getQuickSightAnalysisParameterDeclarations()) + ", quickSightAnalysisStatus=" + String.valueOf(this.getQuickSightAnalysisStatus()) + ", quickSightAnalysisVisuals=" + String.valueOf(this.getQuickSightAnalysisVisuals()) + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class QuickSightAnalysisBuilder<C extends QuickSightAnalysis, B extends QuickSightAnalysisBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<String> quickSightAnalysisCalculatedFields;
        @Generated
        private ArrayList<String> quickSightAnalysisFilterGroups;
        @Generated
        private ArrayList<IQuickSightFolder> quickSightAnalysisFolders;
        @Generated
        private ArrayList<String> quickSightAnalysisParameterDeclarations;
        @Generated
        private QuickSightAnalysisStatus quickSightAnalysisStatus;
        @Generated
        private ArrayList<IQuickSightAnalysisVisual> quickSightAnalysisVisuals;
        @Generated
        private String quickSightId;
        @Generated
        private String quickSightSheetId;
        @Generated
        private String quickSightSheetName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QuickSightAnalysisBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QuickSightAnalysis instance, QuickSightAnalysisBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightAnalysisCalculatedFields(instance.quickSightAnalysisCalculatedFields == null ? Collections.emptySortedSet() : instance.quickSightAnalysisCalculatedFields);
            b.quickSightAnalysisFilterGroups(instance.quickSightAnalysisFilterGroups == null ? Collections.emptySortedSet() : instance.quickSightAnalysisFilterGroups);
            b.quickSightAnalysisFolders(instance.quickSightAnalysisFolders == null ? Collections.emptySortedSet() : instance.quickSightAnalysisFolders);
            b.quickSightAnalysisParameterDeclarations(instance.quickSightAnalysisParameterDeclarations == null ? Collections.emptySortedSet() : instance.quickSightAnalysisParameterDeclarations);
            b.quickSightAnalysisStatus(instance.quickSightAnalysisStatus);
            b.quickSightAnalysisVisuals(instance.quickSightAnalysisVisuals == null ? Collections.emptySortedSet() : instance.quickSightAnalysisVisuals);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisCalculatedField(String quickSightAnalysisCalculatedField) {
            if (this.quickSightAnalysisCalculatedFields == null) {
                this.quickSightAnalysisCalculatedFields = new ArrayList();
            }
            this.quickSightAnalysisCalculatedFields.add(quickSightAnalysisCalculatedField);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisCalculatedFields(Collection<? extends String> quickSightAnalysisCalculatedFields) {
            if (quickSightAnalysisCalculatedFields == null) {
                throw new NullPointerException("quickSightAnalysisCalculatedFields cannot be null");
            }
            if (this.quickSightAnalysisCalculatedFields == null) {
                this.quickSightAnalysisCalculatedFields = new ArrayList();
            }
            this.quickSightAnalysisCalculatedFields.addAll(quickSightAnalysisCalculatedFields);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalysisCalculatedFields() {
            if (this.quickSightAnalysisCalculatedFields != null) {
                this.quickSightAnalysisCalculatedFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisFilterGroup(String quickSightAnalysisFilterGroup) {
            if (this.quickSightAnalysisFilterGroups == null) {
                this.quickSightAnalysisFilterGroups = new ArrayList();
            }
            this.quickSightAnalysisFilterGroups.add(quickSightAnalysisFilterGroup);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisFilterGroups(Collection<? extends String> quickSightAnalysisFilterGroups) {
            if (quickSightAnalysisFilterGroups == null) {
                throw new NullPointerException("quickSightAnalysisFilterGroups cannot be null");
            }
            if (this.quickSightAnalysisFilterGroups == null) {
                this.quickSightAnalysisFilterGroups = new ArrayList();
            }
            this.quickSightAnalysisFilterGroups.addAll(quickSightAnalysisFilterGroups);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalysisFilterGroups() {
            if (this.quickSightAnalysisFilterGroups != null) {
                this.quickSightAnalysisFilterGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisFolder(IQuickSightFolder quickSightAnalysisFolder) {
            if (this.quickSightAnalysisFolders == null) {
                this.quickSightAnalysisFolders = new ArrayList();
            }
            this.quickSightAnalysisFolders.add(quickSightAnalysisFolder);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisFolders(Collection<? extends IQuickSightFolder> quickSightAnalysisFolders) {
            if (quickSightAnalysisFolders == null) {
                throw new NullPointerException("quickSightAnalysisFolders cannot be null");
            }
            if (this.quickSightAnalysisFolders == null) {
                this.quickSightAnalysisFolders = new ArrayList();
            }
            this.quickSightAnalysisFolders.addAll(quickSightAnalysisFolders);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalysisFolders() {
            if (this.quickSightAnalysisFolders != null) {
                this.quickSightAnalysisFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisParameterDeclaration(String quickSightAnalysisParameterDeclaration) {
            if (this.quickSightAnalysisParameterDeclarations == null) {
                this.quickSightAnalysisParameterDeclarations = new ArrayList();
            }
            this.quickSightAnalysisParameterDeclarations.add(quickSightAnalysisParameterDeclaration);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisParameterDeclarations(Collection<? extends String> quickSightAnalysisParameterDeclarations) {
            if (quickSightAnalysisParameterDeclarations == null) {
                throw new NullPointerException("quickSightAnalysisParameterDeclarations cannot be null");
            }
            if (this.quickSightAnalysisParameterDeclarations == null) {
                this.quickSightAnalysisParameterDeclarations = new ArrayList();
            }
            this.quickSightAnalysisParameterDeclarations.addAll(quickSightAnalysisParameterDeclarations);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalysisParameterDeclarations() {
            if (this.quickSightAnalysisParameterDeclarations != null) {
                this.quickSightAnalysisParameterDeclarations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisStatus(QuickSightAnalysisStatus quickSightAnalysisStatus) {
            this.quickSightAnalysisStatus = quickSightAnalysisStatus;
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisVisual(IQuickSightAnalysisVisual quickSightAnalysisVisual) {
            if (this.quickSightAnalysisVisuals == null) {
                this.quickSightAnalysisVisuals = new ArrayList();
            }
            this.quickSightAnalysisVisuals.add(quickSightAnalysisVisual);
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisVisuals(Collection<? extends IQuickSightAnalysisVisual> quickSightAnalysisVisuals) {
            if (quickSightAnalysisVisuals == null) {
                throw new NullPointerException("quickSightAnalysisVisuals cannot be null");
            }
            if (this.quickSightAnalysisVisuals == null) {
                this.quickSightAnalysisVisuals = new ArrayList();
            }
            this.quickSightAnalysisVisuals.addAll(quickSightAnalysisVisuals);
            return (B)this.self();
        }

        @Generated
        public B clearQuickSightAnalysisVisuals() {
            if (this.quickSightAnalysisVisuals != null) {
                this.quickSightAnalysisVisuals.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightId(String quickSightId) {
            this.quickSightId = quickSightId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetId(String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetName(String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QuickSightAnalysis.QuickSightAnalysisBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", quickSightAnalysisCalculatedFields=" + String.valueOf(this.quickSightAnalysisCalculatedFields) + ", quickSightAnalysisFilterGroups=" + String.valueOf(this.quickSightAnalysisFilterGroups) + ", quickSightAnalysisFolders=" + String.valueOf(this.quickSightAnalysisFolders) + ", quickSightAnalysisParameterDeclarations=" + String.valueOf(this.quickSightAnalysisParameterDeclarations) + ", quickSightAnalysisStatus=" + String.valueOf(this.quickSightAnalysisStatus) + ", quickSightAnalysisVisuals=" + String.valueOf(this.quickSightAnalysisVisuals) + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }

    @Generated
    private static final class QuickSightAnalysisBuilderImpl
    extends QuickSightAnalysisBuilder<QuickSightAnalysis, QuickSightAnalysisBuilderImpl> {
        @Generated
        private QuickSightAnalysisBuilderImpl() {
        }

        @Override
        @Generated
        protected QuickSightAnalysisBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QuickSightAnalysis build() {
            return new QuickSightAnalysis(this);
        }
    }
}

