/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISAP;
import com.atlan.model.assets.ISapErpAbapProgram;
import com.atlan.model.assets.ISapErpCdsView;
import com.atlan.model.assets.ISapErpComponent;
import com.atlan.model.assets.ISapErpFunctionModule;
import com.atlan.model.assets.ISapErpTable;
import com.atlan.model.assets.ISapErpTransactionCode;
import com.atlan.model.assets.ISapErpView;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapErpComponent
extends Asset
implements ISapErpComponent,
ISAP,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SapErpComponent.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SapErpComponent";
    String typeName;
    @Attribute
    SortedSet<ISapErpComponent> childComponents;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ISapErpComponent parentComponent;
    @Attribute
    String sapComponentName;
    @Attribute
    String sapDataType;
    @Attribute
    SortedSet<ISapErpAbapProgram> sapErpAbapPrograms;
    @Attribute
    SortedSet<ISapErpCdsView> sapErpCdsViews;
    @Attribute
    SortedSet<ISapErpFunctionModule> sapErpFunctionModules;
    @Attribute
    SortedSet<ISapErpTable> sapErpTables;
    @Attribute
    SortedSet<ISapErpTransactionCode> sapErpTransactionCodes;
    @Attribute
    SortedSet<ISapErpView> sapErpViews;
    @Attribute
    Long sapFieldCount;
    @Attribute
    Integer sapFieldOrder;
    @Attribute
    String sapLogicalName;
    @Attribute
    String sapPackageName;
    @Attribute
    String sapTechnicalName;

    @Override
    public SapErpComponent trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SapErpComponent.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SapErpComponent.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SapErpComponent.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SapErpComponent.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SapErpComponent refByGuid(String guid) {
        return SapErpComponent.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SapErpComponent refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SapErpComponentBuilder)((SapErpComponentBuilder)SapErpComponent._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SapErpComponent refByQualifiedName(String qualifiedName) {
        return SapErpComponent.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SapErpComponent refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SapErpComponentBuilder)((SapErpComponentBuilder)SapErpComponent._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SapErpComponent get(AtlanClient client, String id) throws AtlanException {
        return SapErpComponent.get(client, id, false);
    }

    @JsonIgnore
    public static SapErpComponent get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SapErpComponent) {
                return (SapErpComponent)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SapErpComponent) {
            return (SapErpComponent)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SapErpComponent get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SapErpComponent.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SapErpComponent get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SapErpComponent.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SapErpComponent) {
                return (SapErpComponent)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SapErpComponent.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SapErpComponent) {
            return (SapErpComponent)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SapErpComponentBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SapErpComponentBuilder)((SapErpComponentBuilder)((SapErpComponentBuilder)SapErpComponent._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SapErpComponentBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SapErpComponent.validateRequired(TYPE_NAME, map);
        return SapErpComponent.updater(this.getQualifiedName(), this.getName());
    }

    public static SapErpComponent removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpComponent)Asset.removeDescription(client, SapErpComponent.updater(qualifiedName, name));
    }

    public static SapErpComponent removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpComponent)Asset.removeUserDescription(client, SapErpComponent.updater(qualifiedName, name));
    }

    public static SapErpComponent removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpComponent)Asset.removeOwners(client, SapErpComponent.updater(qualifiedName, name));
    }

    public static SapErpComponent updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SapErpComponent)Asset.updateCertificate(client, SapErpComponent._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SapErpComponent removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpComponent)Asset.removeCertificate(client, SapErpComponent.updater(qualifiedName, name));
    }

    public static SapErpComponent updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SapErpComponent)Asset.updateAnnouncement(client, SapErpComponent._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SapErpComponent removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SapErpComponent)Asset.removeAnnouncement(client, SapErpComponent.updater(qualifiedName, name));
    }

    public static SapErpComponent replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpComponent)Asset.replaceTerms(client, SapErpComponent.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static SapErpComponent appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpComponent)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SapErpComponent removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SapErpComponent)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SapErpComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SapErpComponent)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static SapErpComponent appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SapErpComponent)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SapErpComponent(SapErpComponentBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SapErpComponent.$default$typeName();
        SortedSet<ISapErpComponent> childComponents = new TreeSet<ISapErpComponent>();
        if (b.childComponents != null) {
            childComponents.addAll(b.childComponents);
        }
        childComponents = Collections.unmodifiableSortedSet(childComponents);
        this.childComponents = childComponents;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentComponent = b.parentComponent;
        this.sapComponentName = b.sapComponentName;
        this.sapDataType = b.sapDataType;
        SortedSet<ISapErpAbapProgram> sapErpAbapPrograms = new TreeSet<ISapErpAbapProgram>();
        if (b.sapErpAbapPrograms != null) {
            sapErpAbapPrograms.addAll(b.sapErpAbapPrograms);
        }
        sapErpAbapPrograms = Collections.unmodifiableSortedSet(sapErpAbapPrograms);
        this.sapErpAbapPrograms = sapErpAbapPrograms;
        SortedSet<ISapErpCdsView> sapErpCdsViews = new TreeSet<ISapErpCdsView>();
        if (b.sapErpCdsViews != null) {
            sapErpCdsViews.addAll(b.sapErpCdsViews);
        }
        sapErpCdsViews = Collections.unmodifiableSortedSet(sapErpCdsViews);
        this.sapErpCdsViews = sapErpCdsViews;
        SortedSet<ISapErpFunctionModule> sapErpFunctionModules = new TreeSet<ISapErpFunctionModule>();
        if (b.sapErpFunctionModules != null) {
            sapErpFunctionModules.addAll(b.sapErpFunctionModules);
        }
        sapErpFunctionModules = Collections.unmodifiableSortedSet(sapErpFunctionModules);
        this.sapErpFunctionModules = sapErpFunctionModules;
        SortedSet<ISapErpTable> sapErpTables = new TreeSet<ISapErpTable>();
        if (b.sapErpTables != null) {
            sapErpTables.addAll(b.sapErpTables);
        }
        sapErpTables = Collections.unmodifiableSortedSet(sapErpTables);
        this.sapErpTables = sapErpTables;
        SortedSet<ISapErpTransactionCode> sapErpTransactionCodes = new TreeSet<ISapErpTransactionCode>();
        if (b.sapErpTransactionCodes != null) {
            sapErpTransactionCodes.addAll(b.sapErpTransactionCodes);
        }
        sapErpTransactionCodes = Collections.unmodifiableSortedSet(sapErpTransactionCodes);
        this.sapErpTransactionCodes = sapErpTransactionCodes;
        SortedSet<ISapErpView> sapErpViews = new TreeSet<ISapErpView>();
        if (b.sapErpViews != null) {
            sapErpViews.addAll(b.sapErpViews);
        }
        sapErpViews = Collections.unmodifiableSortedSet(sapErpViews);
        this.sapErpViews = sapErpViews;
        this.sapFieldCount = b.sapFieldCount;
        this.sapFieldOrder = b.sapFieldOrder;
        this.sapLogicalName = b.sapLogicalName;
        this.sapPackageName = b.sapPackageName;
        this.sapTechnicalName = b.sapTechnicalName;
    }

    @Generated
    public static SapErpComponentBuilder<?, ?> _internal() {
        return new SapErpComponentBuilderImpl();
    }

    @Generated
    public SapErpComponentBuilder<?, ?> toBuilder() {
        return new SapErpComponentBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ISapErpComponent> getChildComponents() {
        return this.childComponents;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISapErpComponent getParentComponent() {
        return this.parentComponent;
    }

    @Override
    @Generated
    public String getSapComponentName() {
        return this.sapComponentName;
    }

    @Override
    @Generated
    public String getSapDataType() {
        return this.sapDataType;
    }

    @Override
    @Generated
    public SortedSet<ISapErpAbapProgram> getSapErpAbapPrograms() {
        return this.sapErpAbapPrograms;
    }

    @Override
    @Generated
    public SortedSet<ISapErpCdsView> getSapErpCdsViews() {
        return this.sapErpCdsViews;
    }

    @Override
    @Generated
    public SortedSet<ISapErpFunctionModule> getSapErpFunctionModules() {
        return this.sapErpFunctionModules;
    }

    @Override
    @Generated
    public SortedSet<ISapErpTable> getSapErpTables() {
        return this.sapErpTables;
    }

    @Override
    @Generated
    public SortedSet<ISapErpTransactionCode> getSapErpTransactionCodes() {
        return this.sapErpTransactionCodes;
    }

    @Override
    @Generated
    public SortedSet<ISapErpView> getSapErpViews() {
        return this.sapErpViews;
    }

    @Override
    @Generated
    public Long getSapFieldCount() {
        return this.sapFieldCount;
    }

    @Override
    @Generated
    public Integer getSapFieldOrder() {
        return this.sapFieldOrder;
    }

    @Override
    @Generated
    public String getSapLogicalName() {
        return this.sapLogicalName;
    }

    @Override
    @Generated
    public String getSapPackageName() {
        return this.sapPackageName;
    }

    @Override
    @Generated
    public String getSapTechnicalName() {
        return this.sapTechnicalName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SapErpComponent)) {
            return false;
        }
        SapErpComponent other = (SapErpComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sapFieldCount = this.getSapFieldCount();
        Long other$sapFieldCount = other.getSapFieldCount();
        if (this$sapFieldCount == null ? other$sapFieldCount != null : !((Object)this$sapFieldCount).equals(other$sapFieldCount)) {
            return false;
        }
        Integer this$sapFieldOrder = this.getSapFieldOrder();
        Integer other$sapFieldOrder = other.getSapFieldOrder();
        if (this$sapFieldOrder == null ? other$sapFieldOrder != null : !((Object)this$sapFieldOrder).equals(other$sapFieldOrder)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ISapErpComponent> this$childComponents = this.getChildComponents();
        SortedSet<ISapErpComponent> other$childComponents = other.getChildComponents();
        if (this$childComponents == null ? other$childComponents != null : !this$childComponents.equals(other$childComponents)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISapErpComponent this$parentComponent = this.getParentComponent();
        ISapErpComponent other$parentComponent = other.getParentComponent();
        if (this$parentComponent == null ? other$parentComponent != null : !this$parentComponent.equals(other$parentComponent)) {
            return false;
        }
        String this$sapComponentName = this.getSapComponentName();
        String other$sapComponentName = other.getSapComponentName();
        if (this$sapComponentName == null ? other$sapComponentName != null : !this$sapComponentName.equals(other$sapComponentName)) {
            return false;
        }
        String this$sapDataType = this.getSapDataType();
        String other$sapDataType = other.getSapDataType();
        if (this$sapDataType == null ? other$sapDataType != null : !this$sapDataType.equals(other$sapDataType)) {
            return false;
        }
        SortedSet<ISapErpAbapProgram> this$sapErpAbapPrograms = this.getSapErpAbapPrograms();
        SortedSet<ISapErpAbapProgram> other$sapErpAbapPrograms = other.getSapErpAbapPrograms();
        if (this$sapErpAbapPrograms == null ? other$sapErpAbapPrograms != null : !this$sapErpAbapPrograms.equals(other$sapErpAbapPrograms)) {
            return false;
        }
        SortedSet<ISapErpCdsView> this$sapErpCdsViews = this.getSapErpCdsViews();
        SortedSet<ISapErpCdsView> other$sapErpCdsViews = other.getSapErpCdsViews();
        if (this$sapErpCdsViews == null ? other$sapErpCdsViews != null : !this$sapErpCdsViews.equals(other$sapErpCdsViews)) {
            return false;
        }
        SortedSet<ISapErpFunctionModule> this$sapErpFunctionModules = this.getSapErpFunctionModules();
        SortedSet<ISapErpFunctionModule> other$sapErpFunctionModules = other.getSapErpFunctionModules();
        if (this$sapErpFunctionModules == null ? other$sapErpFunctionModules != null : !this$sapErpFunctionModules.equals(other$sapErpFunctionModules)) {
            return false;
        }
        SortedSet<ISapErpTable> this$sapErpTables = this.getSapErpTables();
        SortedSet<ISapErpTable> other$sapErpTables = other.getSapErpTables();
        if (this$sapErpTables == null ? other$sapErpTables != null : !this$sapErpTables.equals(other$sapErpTables)) {
            return false;
        }
        SortedSet<ISapErpTransactionCode> this$sapErpTransactionCodes = this.getSapErpTransactionCodes();
        SortedSet<ISapErpTransactionCode> other$sapErpTransactionCodes = other.getSapErpTransactionCodes();
        if (this$sapErpTransactionCodes == null ? other$sapErpTransactionCodes != null : !this$sapErpTransactionCodes.equals(other$sapErpTransactionCodes)) {
            return false;
        }
        SortedSet<ISapErpView> this$sapErpViews = this.getSapErpViews();
        SortedSet<ISapErpView> other$sapErpViews = other.getSapErpViews();
        if (this$sapErpViews == null ? other$sapErpViews != null : !this$sapErpViews.equals(other$sapErpViews)) {
            return false;
        }
        String this$sapLogicalName = this.getSapLogicalName();
        String other$sapLogicalName = other.getSapLogicalName();
        if (this$sapLogicalName == null ? other$sapLogicalName != null : !this$sapLogicalName.equals(other$sapLogicalName)) {
            return false;
        }
        String this$sapPackageName = this.getSapPackageName();
        String other$sapPackageName = other.getSapPackageName();
        if (this$sapPackageName == null ? other$sapPackageName != null : !this$sapPackageName.equals(other$sapPackageName)) {
            return false;
        }
        String this$sapTechnicalName = this.getSapTechnicalName();
        String other$sapTechnicalName = other.getSapTechnicalName();
        return !(this$sapTechnicalName == null ? other$sapTechnicalName != null : !this$sapTechnicalName.equals(other$sapTechnicalName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SapErpComponent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sapFieldCount = this.getSapFieldCount();
        result = result * 59 + ($sapFieldCount == null ? 43 : ((Object)$sapFieldCount).hashCode());
        Integer $sapFieldOrder = this.getSapFieldOrder();
        result = result * 59 + ($sapFieldOrder == null ? 43 : ((Object)$sapFieldOrder).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ISapErpComponent> $childComponents = this.getChildComponents();
        result = result * 59 + ($childComponents == null ? 43 : $childComponents.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISapErpComponent $parentComponent = this.getParentComponent();
        result = result * 59 + ($parentComponent == null ? 43 : $parentComponent.hashCode());
        String $sapComponentName = this.getSapComponentName();
        result = result * 59 + ($sapComponentName == null ? 43 : $sapComponentName.hashCode());
        String $sapDataType = this.getSapDataType();
        result = result * 59 + ($sapDataType == null ? 43 : $sapDataType.hashCode());
        SortedSet<ISapErpAbapProgram> $sapErpAbapPrograms = this.getSapErpAbapPrograms();
        result = result * 59 + ($sapErpAbapPrograms == null ? 43 : $sapErpAbapPrograms.hashCode());
        SortedSet<ISapErpCdsView> $sapErpCdsViews = this.getSapErpCdsViews();
        result = result * 59 + ($sapErpCdsViews == null ? 43 : $sapErpCdsViews.hashCode());
        SortedSet<ISapErpFunctionModule> $sapErpFunctionModules = this.getSapErpFunctionModules();
        result = result * 59 + ($sapErpFunctionModules == null ? 43 : $sapErpFunctionModules.hashCode());
        SortedSet<ISapErpTable> $sapErpTables = this.getSapErpTables();
        result = result * 59 + ($sapErpTables == null ? 43 : $sapErpTables.hashCode());
        SortedSet<ISapErpTransactionCode> $sapErpTransactionCodes = this.getSapErpTransactionCodes();
        result = result * 59 + ($sapErpTransactionCodes == null ? 43 : $sapErpTransactionCodes.hashCode());
        SortedSet<ISapErpView> $sapErpViews = this.getSapErpViews();
        result = result * 59 + ($sapErpViews == null ? 43 : $sapErpViews.hashCode());
        String $sapLogicalName = this.getSapLogicalName();
        result = result * 59 + ($sapLogicalName == null ? 43 : $sapLogicalName.hashCode());
        String $sapPackageName = this.getSapPackageName();
        result = result * 59 + ($sapPackageName == null ? 43 : $sapPackageName.hashCode());
        String $sapTechnicalName = this.getSapTechnicalName();
        result = result * 59 + ($sapTechnicalName == null ? 43 : $sapTechnicalName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SapErpComponent(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", childComponents=" + String.valueOf(this.getChildComponents()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", parentComponent=" + String.valueOf(this.getParentComponent()) + ", sapComponentName=" + this.getSapComponentName() + ", sapDataType=" + this.getSapDataType() + ", sapErpAbapPrograms=" + String.valueOf(this.getSapErpAbapPrograms()) + ", sapErpCdsViews=" + String.valueOf(this.getSapErpCdsViews()) + ", sapErpFunctionModules=" + String.valueOf(this.getSapErpFunctionModules()) + ", sapErpTables=" + String.valueOf(this.getSapErpTables()) + ", sapErpTransactionCodes=" + String.valueOf(this.getSapErpTransactionCodes()) + ", sapErpViews=" + String.valueOf(this.getSapErpViews()) + ", sapFieldCount=" + this.getSapFieldCount() + ", sapFieldOrder=" + this.getSapFieldOrder() + ", sapLogicalName=" + this.getSapLogicalName() + ", sapPackageName=" + this.getSapPackageName() + ", sapTechnicalName=" + this.getSapTechnicalName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SapErpComponentBuilder<C extends SapErpComponent, B extends SapErpComponentBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ISapErpComponent> childComponents;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISapErpComponent parentComponent;
        @Generated
        private String sapComponentName;
        @Generated
        private String sapDataType;
        @Generated
        private ArrayList<ISapErpAbapProgram> sapErpAbapPrograms;
        @Generated
        private ArrayList<ISapErpCdsView> sapErpCdsViews;
        @Generated
        private ArrayList<ISapErpFunctionModule> sapErpFunctionModules;
        @Generated
        private ArrayList<ISapErpTable> sapErpTables;
        @Generated
        private ArrayList<ISapErpTransactionCode> sapErpTransactionCodes;
        @Generated
        private ArrayList<ISapErpView> sapErpViews;
        @Generated
        private Long sapFieldCount;
        @Generated
        private Integer sapFieldOrder;
        @Generated
        private String sapLogicalName;
        @Generated
        private String sapPackageName;
        @Generated
        private String sapTechnicalName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SapErpComponentBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SapErpComponent instance, SapErpComponentBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.childComponents(instance.childComponents == null ? Collections.emptySortedSet() : instance.childComponents);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.parentComponent(instance.parentComponent);
            b.sapComponentName(instance.sapComponentName);
            b.sapDataType(instance.sapDataType);
            b.sapErpAbapPrograms(instance.sapErpAbapPrograms == null ? Collections.emptySortedSet() : instance.sapErpAbapPrograms);
            b.sapErpCdsViews(instance.sapErpCdsViews == null ? Collections.emptySortedSet() : instance.sapErpCdsViews);
            b.sapErpFunctionModules(instance.sapErpFunctionModules == null ? Collections.emptySortedSet() : instance.sapErpFunctionModules);
            b.sapErpTables(instance.sapErpTables == null ? Collections.emptySortedSet() : instance.sapErpTables);
            b.sapErpTransactionCodes(instance.sapErpTransactionCodes == null ? Collections.emptySortedSet() : instance.sapErpTransactionCodes);
            b.sapErpViews(instance.sapErpViews == null ? Collections.emptySortedSet() : instance.sapErpViews);
            b.sapFieldCount(instance.sapFieldCount);
            b.sapFieldOrder(instance.sapFieldOrder);
            b.sapLogicalName(instance.sapLogicalName);
            b.sapPackageName(instance.sapPackageName);
            b.sapTechnicalName(instance.sapTechnicalName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B childComponent(ISapErpComponent childComponent) {
            if (this.childComponents == null) {
                this.childComponents = new ArrayList();
            }
            this.childComponents.add(childComponent);
            return (B)this.self();
        }

        @Generated
        public B childComponents(Collection<? extends ISapErpComponent> childComponents) {
            if (childComponents == null) {
                throw new NullPointerException("childComponents cannot be null");
            }
            if (this.childComponents == null) {
                this.childComponents = new ArrayList();
            }
            this.childComponents.addAll(childComponents);
            return (B)this.self();
        }

        @Generated
        public B clearChildComponents() {
            if (this.childComponents != null) {
                this.childComponents.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentComponent(ISapErpComponent parentComponent) {
            this.parentComponent = parentComponent;
            return (B)this.self();
        }

        @Generated
        public B sapComponentName(String sapComponentName) {
            this.sapComponentName = sapComponentName;
            return (B)this.self();
        }

        @Generated
        public B sapDataType(String sapDataType) {
            this.sapDataType = sapDataType;
            return (B)this.self();
        }

        @Generated
        public B sapErpAbapProgram(ISapErpAbapProgram sapErpAbapProgram) {
            if (this.sapErpAbapPrograms == null) {
                this.sapErpAbapPrograms = new ArrayList();
            }
            this.sapErpAbapPrograms.add(sapErpAbapProgram);
            return (B)this.self();
        }

        @Generated
        public B sapErpAbapPrograms(Collection<? extends ISapErpAbapProgram> sapErpAbapPrograms) {
            if (sapErpAbapPrograms == null) {
                throw new NullPointerException("sapErpAbapPrograms cannot be null");
            }
            if (this.sapErpAbapPrograms == null) {
                this.sapErpAbapPrograms = new ArrayList();
            }
            this.sapErpAbapPrograms.addAll(sapErpAbapPrograms);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpAbapPrograms() {
            if (this.sapErpAbapPrograms != null) {
                this.sapErpAbapPrograms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpCdsView(ISapErpCdsView sapErpCdsView) {
            if (this.sapErpCdsViews == null) {
                this.sapErpCdsViews = new ArrayList();
            }
            this.sapErpCdsViews.add(sapErpCdsView);
            return (B)this.self();
        }

        @Generated
        public B sapErpCdsViews(Collection<? extends ISapErpCdsView> sapErpCdsViews) {
            if (sapErpCdsViews == null) {
                throw new NullPointerException("sapErpCdsViews cannot be null");
            }
            if (this.sapErpCdsViews == null) {
                this.sapErpCdsViews = new ArrayList();
            }
            this.sapErpCdsViews.addAll(sapErpCdsViews);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpCdsViews() {
            if (this.sapErpCdsViews != null) {
                this.sapErpCdsViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModule(ISapErpFunctionModule sapErpFunctionModule) {
            if (this.sapErpFunctionModules == null) {
                this.sapErpFunctionModules = new ArrayList();
            }
            this.sapErpFunctionModules.add(sapErpFunctionModule);
            return (B)this.self();
        }

        @Generated
        public B sapErpFunctionModules(Collection<? extends ISapErpFunctionModule> sapErpFunctionModules) {
            if (sapErpFunctionModules == null) {
                throw new NullPointerException("sapErpFunctionModules cannot be null");
            }
            if (this.sapErpFunctionModules == null) {
                this.sapErpFunctionModules = new ArrayList();
            }
            this.sapErpFunctionModules.addAll(sapErpFunctionModules);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpFunctionModules() {
            if (this.sapErpFunctionModules != null) {
                this.sapErpFunctionModules.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpTable(ISapErpTable sapErpTable) {
            if (this.sapErpTables == null) {
                this.sapErpTables = new ArrayList();
            }
            this.sapErpTables.add(sapErpTable);
            return (B)this.self();
        }

        @Generated
        public B sapErpTables(Collection<? extends ISapErpTable> sapErpTables) {
            if (sapErpTables == null) {
                throw new NullPointerException("sapErpTables cannot be null");
            }
            if (this.sapErpTables == null) {
                this.sapErpTables = new ArrayList();
            }
            this.sapErpTables.addAll(sapErpTables);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpTables() {
            if (this.sapErpTables != null) {
                this.sapErpTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpTransactionCode(ISapErpTransactionCode sapErpTransactionCode) {
            if (this.sapErpTransactionCodes == null) {
                this.sapErpTransactionCodes = new ArrayList();
            }
            this.sapErpTransactionCodes.add(sapErpTransactionCode);
            return (B)this.self();
        }

        @Generated
        public B sapErpTransactionCodes(Collection<? extends ISapErpTransactionCode> sapErpTransactionCodes) {
            if (sapErpTransactionCodes == null) {
                throw new NullPointerException("sapErpTransactionCodes cannot be null");
            }
            if (this.sapErpTransactionCodes == null) {
                this.sapErpTransactionCodes = new ArrayList();
            }
            this.sapErpTransactionCodes.addAll(sapErpTransactionCodes);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpTransactionCodes() {
            if (this.sapErpTransactionCodes != null) {
                this.sapErpTransactionCodes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapErpView(ISapErpView sapErpView) {
            if (this.sapErpViews == null) {
                this.sapErpViews = new ArrayList();
            }
            this.sapErpViews.add(sapErpView);
            return (B)this.self();
        }

        @Generated
        public B sapErpViews(Collection<? extends ISapErpView> sapErpViews) {
            if (sapErpViews == null) {
                throw new NullPointerException("sapErpViews cannot be null");
            }
            if (this.sapErpViews == null) {
                this.sapErpViews = new ArrayList();
            }
            this.sapErpViews.addAll(sapErpViews);
            return (B)this.self();
        }

        @Generated
        public B clearSapErpViews() {
            if (this.sapErpViews != null) {
                this.sapErpViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sapFieldCount(Long sapFieldCount) {
            this.sapFieldCount = sapFieldCount;
            return (B)this.self();
        }

        @Generated
        public B sapFieldOrder(Integer sapFieldOrder) {
            this.sapFieldOrder = sapFieldOrder;
            return (B)this.self();
        }

        @Generated
        public B sapLogicalName(String sapLogicalName) {
            this.sapLogicalName = sapLogicalName;
            return (B)this.self();
        }

        @Generated
        public B sapPackageName(String sapPackageName) {
            this.sapPackageName = sapPackageName;
            return (B)this.self();
        }

        @Generated
        public B sapTechnicalName(String sapTechnicalName) {
            this.sapTechnicalName = sapTechnicalName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SapErpComponent.SapErpComponentBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", childComponents=" + String.valueOf(this.childComponents) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", parentComponent=" + String.valueOf(this.parentComponent) + ", sapComponentName=" + this.sapComponentName + ", sapDataType=" + this.sapDataType + ", sapErpAbapPrograms=" + String.valueOf(this.sapErpAbapPrograms) + ", sapErpCdsViews=" + String.valueOf(this.sapErpCdsViews) + ", sapErpFunctionModules=" + String.valueOf(this.sapErpFunctionModules) + ", sapErpTables=" + String.valueOf(this.sapErpTables) + ", sapErpTransactionCodes=" + String.valueOf(this.sapErpTransactionCodes) + ", sapErpViews=" + String.valueOf(this.sapErpViews) + ", sapFieldCount=" + this.sapFieldCount + ", sapFieldOrder=" + this.sapFieldOrder + ", sapLogicalName=" + this.sapLogicalName + ", sapPackageName=" + this.sapPackageName + ", sapTechnicalName=" + this.sapTechnicalName + ")";
        }
    }

    @Generated
    private static final class SapErpComponentBuilderImpl
    extends SapErpComponentBuilder<SapErpComponent, SapErpComponentBuilderImpl> {
        @Generated
        private SapErpComponentBuilderImpl() {
        }

        @Override
        @Generated
        protected SapErpComponentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SapErpComponent build() {
            return new SapErpComponent(this);
        }
    }
}

