/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Database;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICalculationView;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDatabase;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSeed;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IFunction;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMaterializedView;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IProcedure;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISchema;
import com.atlan.model.assets.ISnowflakeDynamicTable;
import com.atlan.model.assets.ISnowflakePipe;
import com.atlan.model.assets.ISnowflakeStage;
import com.atlan.model.assets.ISnowflakeStream;
import com.atlan.model.assets.ISnowflakeTag;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.IView;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema
extends Asset
implements ISchema,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Schema";
    String typeName;
    @Attribute
    String calculationViewName;
    @Attribute
    String calculationViewQualifiedName;
    @Attribute
    SortedSet<ICalculationView> calculationViews;
    @Attribute
    IDatabase database;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSeed> dbtSeedAssets;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    SortedSet<IFunction> functions;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isProfiled;
    @Attribute
    @Date
    Long lastProfiledAt;
    @Attribute
    String linkedSchemaQualifiedName;
    @Attribute
    @JsonProperty(value="materialisedViews")
    SortedSet<IMaterializedView> materializedViews;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<IProcedure> procedures;
    @Attribute
    Long queryCount;
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    String schemaExternalLocation;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    SortedSet<ISnowflakeDynamicTable> snowflakeDynamicTables;
    @Attribute
    SortedSet<ISnowflakePipe> snowflakePipes;
    @Attribute
    SortedSet<ISnowflakeStage> snowflakeStages;
    @Attribute
    SortedSet<ISnowflakeStream> snowflakeStreams;
    @Attribute
    SortedSet<ISnowflakeTag> snowflakeTags;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    Integer tableCount;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    SortedSet<ITable> tables;
    @Attribute
    @JsonProperty(value="viewsCount")
    Integer viewCount;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;
    @Attribute
    SortedSet<IView> views;

    @Override
    public Schema trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return Schema.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return Schema.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return Schema.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return Schema.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static Schema refByGuid(String guid) {
        return Schema.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static Schema refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SchemaBuilder)((SchemaBuilder)Schema._internal().guid(guid)).semantic(semantic)).build();
    }

    public static Schema refByQualifiedName(String qualifiedName) {
        return Schema.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static Schema refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SchemaBuilder)((SchemaBuilder)Schema._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static Schema get(AtlanClient client, String id) throws AtlanException {
        return Schema.get(client, id, false);
    }

    @JsonIgnore
    public static Schema get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof Schema) {
                return (Schema)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof Schema) {
            return (Schema)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static Schema get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return Schema.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static Schema get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Schema.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof Schema) {
                return (Schema)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)Schema.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof Schema) {
            return (Schema)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SchemaBuilder<?, ?> creator(String name, Database database) throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", database.getQualifiedName());
        map.put("name", database.getName());
        map.put("connectionQualifiedName", database.getConnectionQualifiedName());
        Schema.validateRelationship("Database", map);
        return Schema.creator(name, database.getConnectionQualifiedName(), database.getName(), database.getQualifiedName()).database(database.trimToReference());
    }

    public static SchemaBuilder<?, ?> creator(String name, String databaseQualifiedName) {
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return Schema.creator(name, connectionQualifiedName, databaseName, databaseQualifiedName);
    }

    public static SchemaBuilder<?, ?> creator(String name, String connectionQualifiedName, String databaseName, String databaseQualifiedName) {
        return (SchemaBuilder)((Asset.AssetBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)((SchemaBuilder)Schema._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(Schema.generateQualifiedName(name, databaseQualifiedName))).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).database(Database.refByQualifiedName(databaseQualifiedName))).connectionQualifiedName(connectionQualifiedName);
    }

    public static String generateQualifiedName(String name, String databaseQualifiedName) {
        return databaseQualifiedName + "/" + name;
    }

    public static SchemaBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SchemaBuilder)((SchemaBuilder)((SchemaBuilder)Schema._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SchemaBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        Schema.validateRequired(TYPE_NAME, map);
        return Schema.updater(this.getQualifiedName(), this.getName());
    }

    public static Schema removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeDescription(client, Schema.updater(qualifiedName, name));
    }

    public static Schema removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeUserDescription(client, Schema.updater(qualifiedName, name));
    }

    public static Schema removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeOwners(client, Schema.updater(qualifiedName, name));
    }

    public static Schema updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (Schema)Asset.updateCertificate(client, Schema._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Schema removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeCertificate(client, Schema.updater(qualifiedName, name));
    }

    public static Schema updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Schema)Asset.updateAnnouncement(client, Schema._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Schema removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (Schema)Asset.removeAnnouncement(client, Schema.updater(qualifiedName, name));
    }

    public static Schema replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.replaceTerms(client, Schema.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static Schema appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Schema removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (Schema)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static Schema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (Schema)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static Schema appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (Schema)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Schema(SchemaBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        this.typeName = b.typeName$set ? b.typeName$value : Schema.$default$typeName();
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        SortedSet<ICalculationView> calculationViews = new TreeSet<ICalculationView>();
        if (b.calculationViews != null) {
            calculationViews.addAll(b.calculationViews);
        }
        calculationViews = Collections.unmodifiableSortedSet(calculationViews);
        this.calculationViews = calculationViews;
        this.database = b.database;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSeed> dbtSeedAssets = new TreeSet<IDbtSeed>();
        if (b.dbtSeedAssets != null) {
            dbtSeedAssets.addAll(b.dbtSeedAssets);
        }
        dbtSeedAssets = Collections.unmodifiableSortedSet(dbtSeedAssets);
        this.dbtSeedAssets = dbtSeedAssets;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        SortedSet<IFunction> functions = new TreeSet<IFunction>();
        if (b.functions != null) {
            functions.addAll(b.functions);
        }
        functions = Collections.unmodifiableSortedSet(functions);
        this.functions = functions;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isProfiled = b.isProfiled;
        this.lastProfiledAt = b.lastProfiledAt;
        this.linkedSchemaQualifiedName = b.linkedSchemaQualifiedName;
        SortedSet<IMaterializedView> materializedViews = new TreeSet<IMaterializedView>();
        if (b.materializedViews != null) {
            materializedViews.addAll(b.materializedViews);
        }
        materializedViews = Collections.unmodifiableSortedSet(materializedViews);
        this.materializedViews = materializedViews;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<IProcedure> procedures = new TreeSet<IProcedure>();
        if (b.procedures != null) {
            procedures.addAll(b.procedures);
        }
        procedures = Collections.unmodifiableSortedSet(procedures);
        this.procedures = procedures;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.schemaExternalLocation = b.schemaExternalLocation;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        SortedSet<ISnowflakeDynamicTable> snowflakeDynamicTables = new TreeSet<ISnowflakeDynamicTable>();
        if (b.snowflakeDynamicTables != null) {
            snowflakeDynamicTables.addAll(b.snowflakeDynamicTables);
        }
        snowflakeDynamicTables = Collections.unmodifiableSortedSet(snowflakeDynamicTables);
        this.snowflakeDynamicTables = snowflakeDynamicTables;
        SortedSet<ISnowflakePipe> snowflakePipes = new TreeSet<ISnowflakePipe>();
        if (b.snowflakePipes != null) {
            snowflakePipes.addAll(b.snowflakePipes);
        }
        snowflakePipes = Collections.unmodifiableSortedSet(snowflakePipes);
        this.snowflakePipes = snowflakePipes;
        SortedSet<ISnowflakeStage> snowflakeStages = new TreeSet<ISnowflakeStage>();
        if (b.snowflakeStages != null) {
            snowflakeStages.addAll(b.snowflakeStages);
        }
        snowflakeStages = Collections.unmodifiableSortedSet(snowflakeStages);
        this.snowflakeStages = snowflakeStages;
        SortedSet<ISnowflakeStream> snowflakeStreams = new TreeSet<ISnowflakeStream>();
        if (b.snowflakeStreams != null) {
            snowflakeStreams.addAll(b.snowflakeStreams);
        }
        snowflakeStreams = Collections.unmodifiableSortedSet(snowflakeStreams);
        this.snowflakeStreams = snowflakeStreams;
        SortedSet<ISnowflakeTag> snowflakeTags = new TreeSet<ISnowflakeTag>();
        if (b.snowflakeTags != null) {
            snowflakeTags.addAll(b.snowflakeTags);
        }
        snowflakeTags = Collections.unmodifiableSortedSet(snowflakeTags);
        this.snowflakeTags = snowflakeTags;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableCount = b.tableCount;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        SortedSet<ITable> tables = new TreeSet<ITable>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        this.viewCount = b.viewCount;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
        SortedSet<IView> views = new TreeSet<IView>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @Generated
    public static SchemaBuilder<?, ?> _internal() {
        return new SchemaBuilderImpl();
    }

    @Generated
    public SchemaBuilder<?, ?> toBuilder() {
        return new SchemaBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    @Override
    @Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ICalculationView> getCalculationViews() {
        return this.calculationViews;
    }

    @Override
    @Generated
    public IDatabase getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSeed> getDbtSeedAssets() {
        return this.dbtSeedAssets;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public SortedSet<IFunction> getFunctions() {
        return this.functions;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public String getLinkedSchemaQualifiedName() {
        return this.linkedSchemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IMaterializedView> getMaterializedViews() {
        return this.materializedViews;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IProcedure> getProcedures() {
        return this.procedures;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public String getSchemaExternalLocation() {
        return this.schemaExternalLocation;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ISnowflakeDynamicTable> getSnowflakeDynamicTables() {
        return this.snowflakeDynamicTables;
    }

    @Override
    @Generated
    public SortedSet<ISnowflakePipe> getSnowflakePipes() {
        return this.snowflakePipes;
    }

    @Override
    @Generated
    public SortedSet<ISnowflakeStage> getSnowflakeStages() {
        return this.snowflakeStages;
    }

    @Override
    @Generated
    public SortedSet<ISnowflakeStream> getSnowflakeStreams() {
        return this.snowflakeStreams;
    }

    @Override
    @Generated
    public SortedSet<ISnowflakeTag> getSnowflakeTags() {
        return this.snowflakeTags;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public Integer getTableCount() {
        return this.tableCount;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITable> getTables() {
        return this.tables;
    }

    @Override
    @Generated
    public Integer getViewCount() {
        return this.viewCount;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IView> getViews() {
        return this.views;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        Integer this$tableCount = this.getTableCount();
        Integer other$tableCount = other.getTableCount();
        if (this$tableCount == null ? other$tableCount != null : !((Object)this$tableCount).equals(other$tableCount)) {
            return false;
        }
        Integer this$viewCount = this.getViewCount();
        Integer other$viewCount = other.getViewCount();
        if (this$viewCount == null ? other$viewCount != null : !((Object)this$viewCount).equals(other$viewCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$calculationViewName = this.getCalculationViewName();
        String other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) {
            return false;
        }
        String this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        String other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) {
            return false;
        }
        SortedSet<ICalculationView> this$calculationViews = this.getCalculationViews();
        SortedSet<ICalculationView> other$calculationViews = other.getCalculationViews();
        if (this$calculationViews == null ? other$calculationViews != null : !this$calculationViews.equals(other$calculationViews)) {
            return false;
        }
        IDatabase this$database = this.getDatabase();
        IDatabase other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSeed> this$dbtSeedAssets = this.getDbtSeedAssets();
        SortedSet<IDbtSeed> other$dbtSeedAssets = other.getDbtSeedAssets();
        if (this$dbtSeedAssets == null ? other$dbtSeedAssets != null : !this$dbtSeedAssets.equals(other$dbtSeedAssets)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        SortedSet<IFunction> this$functions = this.getFunctions();
        SortedSet<IFunction> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !this$functions.equals(other$functions)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$linkedSchemaQualifiedName = this.getLinkedSchemaQualifiedName();
        String other$linkedSchemaQualifiedName = other.getLinkedSchemaQualifiedName();
        if (this$linkedSchemaQualifiedName == null ? other$linkedSchemaQualifiedName != null : !this$linkedSchemaQualifiedName.equals(other$linkedSchemaQualifiedName)) {
            return false;
        }
        SortedSet<IMaterializedView> this$materializedViews = this.getMaterializedViews();
        SortedSet<IMaterializedView> other$materializedViews = other.getMaterializedViews();
        if (this$materializedViews == null ? other$materializedViews != null : !this$materializedViews.equals(other$materializedViews)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<IProcedure> this$procedures = this.getProcedures();
        SortedSet<IProcedure> other$procedures = other.getProcedures();
        if (this$procedures == null ? other$procedures != null : !this$procedures.equals(other$procedures)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        String this$schemaExternalLocation = this.getSchemaExternalLocation();
        String other$schemaExternalLocation = other.getSchemaExternalLocation();
        if (this$schemaExternalLocation == null ? other$schemaExternalLocation != null : !this$schemaExternalLocation.equals(other$schemaExternalLocation)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<ISnowflakeDynamicTable> this$snowflakeDynamicTables = this.getSnowflakeDynamicTables();
        SortedSet<ISnowflakeDynamicTable> other$snowflakeDynamicTables = other.getSnowflakeDynamicTables();
        if (this$snowflakeDynamicTables == null ? other$snowflakeDynamicTables != null : !this$snowflakeDynamicTables.equals(other$snowflakeDynamicTables)) {
            return false;
        }
        SortedSet<ISnowflakePipe> this$snowflakePipes = this.getSnowflakePipes();
        SortedSet<ISnowflakePipe> other$snowflakePipes = other.getSnowflakePipes();
        if (this$snowflakePipes == null ? other$snowflakePipes != null : !this$snowflakePipes.equals(other$snowflakePipes)) {
            return false;
        }
        SortedSet<ISnowflakeStage> this$snowflakeStages = this.getSnowflakeStages();
        SortedSet<ISnowflakeStage> other$snowflakeStages = other.getSnowflakeStages();
        if (this$snowflakeStages == null ? other$snowflakeStages != null : !this$snowflakeStages.equals(other$snowflakeStages)) {
            return false;
        }
        SortedSet<ISnowflakeStream> this$snowflakeStreams = this.getSnowflakeStreams();
        SortedSet<ISnowflakeStream> other$snowflakeStreams = other.getSnowflakeStreams();
        if (this$snowflakeStreams == null ? other$snowflakeStreams != null : !this$snowflakeStreams.equals(other$snowflakeStreams)) {
            return false;
        }
        SortedSet<ISnowflakeTag> this$snowflakeTags = this.getSnowflakeTags();
        SortedSet<ISnowflakeTag> other$snowflakeTags = other.getSnowflakeTags();
        if (this$snowflakeTags == null ? other$snowflakeTags != null : !this$snowflakeTags.equals(other$snowflakeTags)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        SortedSet<ITable> this$tables = this.getTables();
        SortedSet<ITable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        if (this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName)) {
            return false;
        }
        SortedSet<IView> this$views = this.getViews();
        SortedSet<IView> other$views = other.getViews();
        return !(this$views == null ? other$views != null : !this$views.equals(other$views));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        Integer $tableCount = this.getTableCount();
        result = result * 59 + ($tableCount == null ? 43 : ((Object)$tableCount).hashCode());
        Integer $viewCount = this.getViewCount();
        result = result * 59 + ($viewCount == null ? 43 : ((Object)$viewCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $calculationViewName = this.getCalculationViewName();
        result = result * 59 + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        String $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * 59 + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        SortedSet<ICalculationView> $calculationViews = this.getCalculationViews();
        result = result * 59 + ($calculationViews == null ? 43 : $calculationViews.hashCode());
        IDatabase $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSeed> $dbtSeedAssets = this.getDbtSeedAssets();
        result = result * 59 + ($dbtSeedAssets == null ? 43 : $dbtSeedAssets.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        SortedSet<IFunction> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : $functions.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $linkedSchemaQualifiedName = this.getLinkedSchemaQualifiedName();
        result = result * 59 + ($linkedSchemaQualifiedName == null ? 43 : $linkedSchemaQualifiedName.hashCode());
        SortedSet<IMaterializedView> $materializedViews = this.getMaterializedViews();
        result = result * 59 + ($materializedViews == null ? 43 : $materializedViews.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<IProcedure> $procedures = this.getProcedures();
        result = result * 59 + ($procedures == null ? 43 : $procedures.hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        String $schemaExternalLocation = this.getSchemaExternalLocation();
        result = result * 59 + ($schemaExternalLocation == null ? 43 : $schemaExternalLocation.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<ISnowflakeDynamicTable> $snowflakeDynamicTables = this.getSnowflakeDynamicTables();
        result = result * 59 + ($snowflakeDynamicTables == null ? 43 : $snowflakeDynamicTables.hashCode());
        SortedSet<ISnowflakePipe> $snowflakePipes = this.getSnowflakePipes();
        result = result * 59 + ($snowflakePipes == null ? 43 : $snowflakePipes.hashCode());
        SortedSet<ISnowflakeStage> $snowflakeStages = this.getSnowflakeStages();
        result = result * 59 + ($snowflakeStages == null ? 43 : $snowflakeStages.hashCode());
        SortedSet<ISnowflakeStream> $snowflakeStreams = this.getSnowflakeStreams();
        result = result * 59 + ($snowflakeStreams == null ? 43 : $snowflakeStreams.hashCode());
        SortedSet<ISnowflakeTag> $snowflakeTags = this.getSnowflakeTags();
        result = result * 59 + ($snowflakeTags == null ? 43 : $snowflakeTags.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        SortedSet<ITable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        SortedSet<IView> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Schema(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", calculationViews=" + String.valueOf(this.getCalculationViews()) + ", database=" + String.valueOf(this.getDatabase()) + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + String.valueOf(this.getDbtModels()) + ", dbtSeedAssets=" + String.valueOf(this.getDbtSeedAssets()) + ", dbtSources=" + String.valueOf(this.getDbtSources()) + ", dbtTests=" + String.valueOf(this.getDbtTests()) + ", functions=" + String.valueOf(this.getFunctions()) + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isProfiled=" + this.getIsProfiled() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", linkedSchemaQualifiedName=" + this.getLinkedSchemaQualifiedName() + ", materializedViews=" + String.valueOf(this.getMaterializedViews()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", procedures=" + String.valueOf(this.getProcedures()) + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + String.valueOf(this.getQueryUserMap()) + ", schemaExternalLocation=" + this.getSchemaExternalLocation() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", snowflakeDynamicTables=" + String.valueOf(this.getSnowflakeDynamicTables()) + ", snowflakePipes=" + String.valueOf(this.getSnowflakePipes()) + ", snowflakeStages=" + String.valueOf(this.getSnowflakeStages()) + ", snowflakeStreams=" + String.valueOf(this.getSnowflakeStreams()) + ", snowflakeTags=" + String.valueOf(this.getSnowflakeTags()) + ", sqlDBTSources=" + String.valueOf(this.getSqlDBTSources()) + ", sqlDbtModels=" + String.valueOf(this.getSqlDbtModels()) + ", tableCount=" + this.getTableCount() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", tables=" + String.valueOf(this.getTables()) + ", viewCount=" + this.getViewCount() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ", views=" + String.valueOf(this.getViews()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SchemaBuilder<C extends Schema, B extends SchemaBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String calculationViewName;
        @Generated
        private String calculationViewQualifiedName;
        @Generated
        private ArrayList<ICalculationView> calculationViews;
        @Generated
        private IDatabase database;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSeed> dbtSeedAssets;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private ArrayList<IFunction> functions;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private String linkedSchemaQualifiedName;
        @Generated
        private ArrayList<IMaterializedView> materializedViews;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<IProcedure> procedures;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private String schemaExternalLocation;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private ArrayList<ISnowflakeDynamicTable> snowflakeDynamicTables;
        @Generated
        private ArrayList<ISnowflakePipe> snowflakePipes;
        @Generated
        private ArrayList<ISnowflakeStage> snowflakeStages;
        @Generated
        private ArrayList<ISnowflakeStream> snowflakeStreams;
        @Generated
        private ArrayList<ISnowflakeTag> snowflakeTags;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private Integer tableCount;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private ArrayList<ITable> tables;
        @Generated
        private Integer viewCount;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;
        @Generated
        private ArrayList<IView> views;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SchemaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Schema instance, SchemaBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.calculationViews(instance.calculationViews == null ? Collections.emptySortedSet() : instance.calculationViews);
            b.database(instance.database);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSeedAssets(instance.dbtSeedAssets == null ? Collections.emptySortedSet() : instance.dbtSeedAssets);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.functions(instance.functions == null ? Collections.emptySortedSet() : instance.functions);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isProfiled(instance.isProfiled);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.linkedSchemaQualifiedName(instance.linkedSchemaQualifiedName);
            b.materializedViews(instance.materializedViews == null ? Collections.emptySortedSet() : instance.materializedViews);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.procedures(instance.procedures == null ? Collections.emptySortedSet() : instance.procedures);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.schemaExternalLocation(instance.schemaExternalLocation);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.snowflakeDynamicTables(instance.snowflakeDynamicTables == null ? Collections.emptySortedSet() : instance.snowflakeDynamicTables);
            b.snowflakePipes(instance.snowflakePipes == null ? Collections.emptySortedSet() : instance.snowflakePipes);
            b.snowflakeStages(instance.snowflakeStages == null ? Collections.emptySortedSet() : instance.snowflakeStages);
            b.snowflakeStreams(instance.snowflakeStreams == null ? Collections.emptySortedSet() : instance.snowflakeStreams);
            b.snowflakeTags(instance.snowflakeTags == null ? Collections.emptySortedSet() : instance.snowflakeTags);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableCount(instance.tableCount);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.viewCount(instance.viewCount);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B calculationViewName(String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewQualifiedName(String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B calculationView(ICalculationView calculationView) {
            if (this.calculationViews == null) {
                this.calculationViews = new ArrayList();
            }
            this.calculationViews.add(calculationView);
            return (B)this.self();
        }

        @Generated
        public B calculationViews(Collection<? extends ICalculationView> calculationViews) {
            if (calculationViews == null) {
                throw new NullPointerException("calculationViews cannot be null");
            }
            if (this.calculationViews == null) {
                this.calculationViews = new ArrayList();
            }
            this.calculationViews.addAll(calculationViews);
            return (B)this.self();
        }

        @Generated
        public B clearCalculationViews() {
            if (this.calculationViews != null) {
                this.calculationViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B database(IDatabase database) {
            this.database = database;
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAsset(IDbtSeed dbtSeedAsset) {
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.add(dbtSeedAsset);
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAssets(Collection<? extends IDbtSeed> dbtSeedAssets) {
            if (dbtSeedAssets == null) {
                throw new NullPointerException("dbtSeedAssets cannot be null");
            }
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.addAll(dbtSeedAssets);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSeedAssets() {
            if (this.dbtSeedAssets != null) {
                this.dbtSeedAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B function(IFunction function) {
            if (this.functions == null) {
                this.functions = new ArrayList();
            }
            this.functions.add(function);
            return (B)this.self();
        }

        @Generated
        public B functions(Collection<? extends IFunction> functions) {
            if (functions == null) {
                throw new NullPointerException("functions cannot be null");
            }
            if (this.functions == null) {
                this.functions = new ArrayList();
            }
            this.functions.addAll(functions);
            return (B)this.self();
        }

        @Generated
        public B clearFunctions() {
            if (this.functions != null) {
                this.functions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B linkedSchemaQualifiedName(String linkedSchemaQualifiedName) {
            this.linkedSchemaQualifiedName = linkedSchemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B materializedView(IMaterializedView materializedView) {
            if (this.materializedViews == null) {
                this.materializedViews = new ArrayList();
            }
            this.materializedViews.add(materializedView);
            return (B)this.self();
        }

        @JsonProperty(value="materialisedViews")
        @Generated
        public B materializedViews(Collection<? extends IMaterializedView> materializedViews) {
            if (materializedViews == null) {
                throw new NullPointerException("materializedViews cannot be null");
            }
            if (this.materializedViews == null) {
                this.materializedViews = new ArrayList();
            }
            this.materializedViews.addAll(materializedViews);
            return (B)this.self();
        }

        @Generated
        public B clearMaterializedViews() {
            if (this.materializedViews != null) {
                this.materializedViews.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B procedure(IProcedure procedure) {
            if (this.procedures == null) {
                this.procedures = new ArrayList();
            }
            this.procedures.add(procedure);
            return (B)this.self();
        }

        @Generated
        public B procedures(Collection<? extends IProcedure> procedures) {
            if (procedures == null) {
                throw new NullPointerException("procedures cannot be null");
            }
            if (this.procedures == null) {
                this.procedures = new ArrayList();
            }
            this.procedures.addAll(procedures);
            return (B)this.self();
        }

        @Generated
        public B clearProcedures() {
            if (this.procedures != null) {
                this.procedures.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B schemaExternalLocation(String schemaExternalLocation) {
            this.schemaExternalLocation = schemaExternalLocation;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B snowflakeDynamicTable(ISnowflakeDynamicTable snowflakeDynamicTable) {
            if (this.snowflakeDynamicTables == null) {
                this.snowflakeDynamicTables = new ArrayList();
            }
            this.snowflakeDynamicTables.add(snowflakeDynamicTable);
            return (B)this.self();
        }

        @Generated
        public B snowflakeDynamicTables(Collection<? extends ISnowflakeDynamicTable> snowflakeDynamicTables) {
            if (snowflakeDynamicTables == null) {
                throw new NullPointerException("snowflakeDynamicTables cannot be null");
            }
            if (this.snowflakeDynamicTables == null) {
                this.snowflakeDynamicTables = new ArrayList();
            }
            this.snowflakeDynamicTables.addAll(snowflakeDynamicTables);
            return (B)this.self();
        }

        @Generated
        public B clearSnowflakeDynamicTables() {
            if (this.snowflakeDynamicTables != null) {
                this.snowflakeDynamicTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B snowflakePipe(ISnowflakePipe snowflakePipe) {
            if (this.snowflakePipes == null) {
                this.snowflakePipes = new ArrayList();
            }
            this.snowflakePipes.add(snowflakePipe);
            return (B)this.self();
        }

        @Generated
        public B snowflakePipes(Collection<? extends ISnowflakePipe> snowflakePipes) {
            if (snowflakePipes == null) {
                throw new NullPointerException("snowflakePipes cannot be null");
            }
            if (this.snowflakePipes == null) {
                this.snowflakePipes = new ArrayList();
            }
            this.snowflakePipes.addAll(snowflakePipes);
            return (B)this.self();
        }

        @Generated
        public B clearSnowflakePipes() {
            if (this.snowflakePipes != null) {
                this.snowflakePipes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B snowflakeStage(ISnowflakeStage snowflakeStage) {
            if (this.snowflakeStages == null) {
                this.snowflakeStages = new ArrayList();
            }
            this.snowflakeStages.add(snowflakeStage);
            return (B)this.self();
        }

        @Generated
        public B snowflakeStages(Collection<? extends ISnowflakeStage> snowflakeStages) {
            if (snowflakeStages == null) {
                throw new NullPointerException("snowflakeStages cannot be null");
            }
            if (this.snowflakeStages == null) {
                this.snowflakeStages = new ArrayList();
            }
            this.snowflakeStages.addAll(snowflakeStages);
            return (B)this.self();
        }

        @Generated
        public B clearSnowflakeStages() {
            if (this.snowflakeStages != null) {
                this.snowflakeStages.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B snowflakeStream(ISnowflakeStream snowflakeStream) {
            if (this.snowflakeStreams == null) {
                this.snowflakeStreams = new ArrayList();
            }
            this.snowflakeStreams.add(snowflakeStream);
            return (B)this.self();
        }

        @Generated
        public B snowflakeStreams(Collection<? extends ISnowflakeStream> snowflakeStreams) {
            if (snowflakeStreams == null) {
                throw new NullPointerException("snowflakeStreams cannot be null");
            }
            if (this.snowflakeStreams == null) {
                this.snowflakeStreams = new ArrayList();
            }
            this.snowflakeStreams.addAll(snowflakeStreams);
            return (B)this.self();
        }

        @Generated
        public B clearSnowflakeStreams() {
            if (this.snowflakeStreams != null) {
                this.snowflakeStreams.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B snowflakeTag(ISnowflakeTag snowflakeTag) {
            if (this.snowflakeTags == null) {
                this.snowflakeTags = new ArrayList();
            }
            this.snowflakeTags.add(snowflakeTag);
            return (B)this.self();
        }

        @Generated
        public B snowflakeTags(Collection<? extends ISnowflakeTag> snowflakeTags) {
            if (snowflakeTags == null) {
                throw new NullPointerException("snowflakeTags cannot be null");
            }
            if (this.snowflakeTags == null) {
                this.snowflakeTags = new ArrayList();
            }
            this.snowflakeTags.addAll(snowflakeTags);
            return (B)this.self();
        }

        @Generated
        public B clearSnowflakeTags() {
            if (this.snowflakeTags != null) {
                this.snowflakeTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableCount(Integer tableCount) {
            this.tableCount = tableCount;
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B table(ITable table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends ITable> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="viewsCount")
        @Generated
        public B viewCount(Integer viewCount) {
            this.viewCount = viewCount;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B view(IView view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends IView> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Schema.SchemaBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", calculationViews=" + String.valueOf(this.calculationViews) + ", database=" + String.valueOf(this.database) + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + String.valueOf(this.dbtModels) + ", dbtSeedAssets=" + String.valueOf(this.dbtSeedAssets) + ", dbtSources=" + String.valueOf(this.dbtSources) + ", dbtTests=" + String.valueOf(this.dbtTests) + ", functions=" + String.valueOf(this.functions) + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isProfiled=" + this.isProfiled + ", lastProfiledAt=" + this.lastProfiledAt + ", linkedSchemaQualifiedName=" + this.linkedSchemaQualifiedName + ", materializedViews=" + String.valueOf(this.materializedViews) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", procedures=" + String.valueOf(this.procedures) + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + String.valueOf(this.queryUserMap$key) + ", queryUserMap$value=" + String.valueOf(this.queryUserMap$value) + ", schemaExternalLocation=" + this.schemaExternalLocation + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", snowflakeDynamicTables=" + String.valueOf(this.snowflakeDynamicTables) + ", snowflakePipes=" + String.valueOf(this.snowflakePipes) + ", snowflakeStages=" + String.valueOf(this.snowflakeStages) + ", snowflakeStreams=" + String.valueOf(this.snowflakeStreams) + ", snowflakeTags=" + String.valueOf(this.snowflakeTags) + ", sqlDBTSources=" + String.valueOf(this.sqlDBTSources) + ", sqlDbtModels=" + String.valueOf(this.sqlDbtModels) + ", tableCount=" + this.tableCount + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", tables=" + String.valueOf(this.tables) + ", viewCount=" + this.viewCount + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ", views=" + String.valueOf(this.views) + ")";
        }
    }

    @Generated
    private static final class SchemaBuilderImpl
    extends SchemaBuilder<Schema, SchemaBuilderImpl> {
        @Generated
        private SchemaBuilderImpl() {
        }

        @Override
        @Generated
        protected SchemaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Schema build() {
            return new Schema(this);
        }
    }
}

