/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISigma;
import com.atlan.model.assets.ISigmaPage;
import com.atlan.model.assets.ISigmaWorkbook;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigmaWorkbook
extends Asset
implements ISigmaWorkbook,
ISigma,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigmaWorkbook.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SigmaWorkbook";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String sigmaDataElementName;
    @Attribute
    String sigmaDataElementQualifiedName;
    @Attribute
    Long sigmaPageCount;
    @Attribute
    String sigmaPageName;
    @Attribute
    String sigmaPageQualifiedName;
    @Attribute
    SortedSet<ISigmaPage> sigmaPages;
    @Attribute
    String sigmaWorkbookName;
    @Attribute
    String sigmaWorkbookQualifiedName;

    @Override
    public SigmaWorkbook trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SigmaWorkbook.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SigmaWorkbook.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SigmaWorkbook.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SigmaWorkbook.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SigmaWorkbook refByGuid(String guid) {
        return SigmaWorkbook.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaWorkbook refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SigmaWorkbookBuilder)((SigmaWorkbookBuilder)SigmaWorkbook._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SigmaWorkbook refByQualifiedName(String qualifiedName) {
        return SigmaWorkbook.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaWorkbook refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SigmaWorkbookBuilder)((SigmaWorkbookBuilder)SigmaWorkbook._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SigmaWorkbook get(AtlanClient client, String id) throws AtlanException {
        return SigmaWorkbook.get(client, id, false);
    }

    @JsonIgnore
    public static SigmaWorkbook get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SigmaWorkbook) {
                return (SigmaWorkbook)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SigmaWorkbook) {
            return (SigmaWorkbook)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SigmaWorkbook get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SigmaWorkbook.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SigmaWorkbook get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SigmaWorkbook.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SigmaWorkbook) {
                return (SigmaWorkbook)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SigmaWorkbook.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SigmaWorkbook) {
            return (SigmaWorkbook)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SigmaWorkbookBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SigmaWorkbookBuilder)((SigmaWorkbookBuilder)((SigmaWorkbookBuilder)SigmaWorkbook._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SigmaWorkbookBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SigmaWorkbook.validateRequired(TYPE_NAME, map);
        return SigmaWorkbook.updater(this.getQualifiedName(), this.getName());
    }

    public static SigmaWorkbook removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaWorkbook)Asset.removeDescription(client, SigmaWorkbook.updater(qualifiedName, name));
    }

    public static SigmaWorkbook removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaWorkbook)Asset.removeUserDescription(client, SigmaWorkbook.updater(qualifiedName, name));
    }

    public static SigmaWorkbook removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaWorkbook)Asset.removeOwners(client, SigmaWorkbook.updater(qualifiedName, name));
    }

    public static SigmaWorkbook updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SigmaWorkbook)Asset.updateCertificate(client, SigmaWorkbook._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SigmaWorkbook removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaWorkbook)Asset.removeCertificate(client, SigmaWorkbook.updater(qualifiedName, name));
    }

    public static SigmaWorkbook updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SigmaWorkbook)Asset.updateAnnouncement(client, SigmaWorkbook._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SigmaWorkbook removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaWorkbook)Asset.removeAnnouncement(client, SigmaWorkbook.updater(qualifiedName, name));
    }

    public static SigmaWorkbook replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaWorkbook)Asset.replaceTerms(client, SigmaWorkbook.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static SigmaWorkbook appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaWorkbook)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SigmaWorkbook removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaWorkbook)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SigmaWorkbook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SigmaWorkbook)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static SigmaWorkbook appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SigmaWorkbook)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SigmaWorkbook(SigmaWorkbookBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SigmaWorkbook.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sigmaDataElementName = b.sigmaDataElementName;
        this.sigmaDataElementQualifiedName = b.sigmaDataElementQualifiedName;
        this.sigmaPageCount = b.sigmaPageCount;
        this.sigmaPageName = b.sigmaPageName;
        this.sigmaPageQualifiedName = b.sigmaPageQualifiedName;
        SortedSet<ISigmaPage> sigmaPages = new TreeSet<ISigmaPage>();
        if (b.sigmaPages != null) {
            sigmaPages.addAll(b.sigmaPages);
        }
        sigmaPages = Collections.unmodifiableSortedSet(sigmaPages);
        this.sigmaPages = sigmaPages;
        this.sigmaWorkbookName = b.sigmaWorkbookName;
        this.sigmaWorkbookQualifiedName = b.sigmaWorkbookQualifiedName;
    }

    @Generated
    public static SigmaWorkbookBuilder<?, ?> _internal() {
        return new SigmaWorkbookBuilderImpl();
    }

    @Generated
    public SigmaWorkbookBuilder<?, ?> toBuilder() {
        return new SigmaWorkbookBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getSigmaDataElementName() {
        return this.sigmaDataElementName;
    }

    @Override
    @Generated
    public String getSigmaDataElementQualifiedName() {
        return this.sigmaDataElementQualifiedName;
    }

    @Override
    @Generated
    public Long getSigmaPageCount() {
        return this.sigmaPageCount;
    }

    @Override
    @Generated
    public String getSigmaPageName() {
        return this.sigmaPageName;
    }

    @Override
    @Generated
    public String getSigmaPageQualifiedName() {
        return this.sigmaPageQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ISigmaPage> getSigmaPages() {
        return this.sigmaPages;
    }

    @Override
    @Generated
    public String getSigmaWorkbookName() {
        return this.sigmaWorkbookName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookQualifiedName() {
        return this.sigmaWorkbookQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmaWorkbook)) {
            return false;
        }
        SigmaWorkbook other = (SigmaWorkbook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sigmaPageCount = this.getSigmaPageCount();
        Long other$sigmaPageCount = other.getSigmaPageCount();
        if (this$sigmaPageCount == null ? other$sigmaPageCount != null : !((Object)this$sigmaPageCount).equals(other$sigmaPageCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$sigmaDataElementName = this.getSigmaDataElementName();
        String other$sigmaDataElementName = other.getSigmaDataElementName();
        if (this$sigmaDataElementName == null ? other$sigmaDataElementName != null : !this$sigmaDataElementName.equals(other$sigmaDataElementName)) {
            return false;
        }
        String this$sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        String other$sigmaDataElementQualifiedName = other.getSigmaDataElementQualifiedName();
        if (this$sigmaDataElementQualifiedName == null ? other$sigmaDataElementQualifiedName != null : !this$sigmaDataElementQualifiedName.equals(other$sigmaDataElementQualifiedName)) {
            return false;
        }
        String this$sigmaPageName = this.getSigmaPageName();
        String other$sigmaPageName = other.getSigmaPageName();
        if (this$sigmaPageName == null ? other$sigmaPageName != null : !this$sigmaPageName.equals(other$sigmaPageName)) {
            return false;
        }
        String this$sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        String other$sigmaPageQualifiedName = other.getSigmaPageQualifiedName();
        if (this$sigmaPageQualifiedName == null ? other$sigmaPageQualifiedName != null : !this$sigmaPageQualifiedName.equals(other$sigmaPageQualifiedName)) {
            return false;
        }
        SortedSet<ISigmaPage> this$sigmaPages = this.getSigmaPages();
        SortedSet<ISigmaPage> other$sigmaPages = other.getSigmaPages();
        if (this$sigmaPages == null ? other$sigmaPages != null : !this$sigmaPages.equals(other$sigmaPages)) {
            return false;
        }
        String this$sigmaWorkbookName = this.getSigmaWorkbookName();
        String other$sigmaWorkbookName = other.getSigmaWorkbookName();
        if (this$sigmaWorkbookName == null ? other$sigmaWorkbookName != null : !this$sigmaWorkbookName.equals(other$sigmaWorkbookName)) {
            return false;
        }
        String this$sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        String other$sigmaWorkbookQualifiedName = other.getSigmaWorkbookQualifiedName();
        return !(this$sigmaWorkbookQualifiedName == null ? other$sigmaWorkbookQualifiedName != null : !this$sigmaWorkbookQualifiedName.equals(other$sigmaWorkbookQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SigmaWorkbook;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sigmaPageCount = this.getSigmaPageCount();
        result = result * 59 + ($sigmaPageCount == null ? 43 : ((Object)$sigmaPageCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $sigmaDataElementName = this.getSigmaDataElementName();
        result = result * 59 + ($sigmaDataElementName == null ? 43 : $sigmaDataElementName.hashCode());
        String $sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        result = result * 59 + ($sigmaDataElementQualifiedName == null ? 43 : $sigmaDataElementQualifiedName.hashCode());
        String $sigmaPageName = this.getSigmaPageName();
        result = result * 59 + ($sigmaPageName == null ? 43 : $sigmaPageName.hashCode());
        String $sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        result = result * 59 + ($sigmaPageQualifiedName == null ? 43 : $sigmaPageQualifiedName.hashCode());
        SortedSet<ISigmaPage> $sigmaPages = this.getSigmaPages();
        result = result * 59 + ($sigmaPages == null ? 43 : $sigmaPages.hashCode());
        String $sigmaWorkbookName = this.getSigmaWorkbookName();
        result = result * 59 + ($sigmaWorkbookName == null ? 43 : $sigmaWorkbookName.hashCode());
        String $sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        result = result * 59 + ($sigmaWorkbookQualifiedName == null ? 43 : $sigmaWorkbookQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SigmaWorkbook(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", sigmaDataElementName=" + this.getSigmaDataElementName() + ", sigmaDataElementQualifiedName=" + this.getSigmaDataElementQualifiedName() + ", sigmaPageCount=" + this.getSigmaPageCount() + ", sigmaPageName=" + this.getSigmaPageName() + ", sigmaPageQualifiedName=" + this.getSigmaPageQualifiedName() + ", sigmaPages=" + String.valueOf(this.getSigmaPages()) + ", sigmaWorkbookName=" + this.getSigmaWorkbookName() + ", sigmaWorkbookQualifiedName=" + this.getSigmaWorkbookQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SigmaWorkbookBuilder<C extends SigmaWorkbook, B extends SigmaWorkbookBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String sigmaDataElementName;
        @Generated
        private String sigmaDataElementQualifiedName;
        @Generated
        private Long sigmaPageCount;
        @Generated
        private String sigmaPageName;
        @Generated
        private String sigmaPageQualifiedName;
        @Generated
        private ArrayList<ISigmaPage> sigmaPages;
        @Generated
        private String sigmaWorkbookName;
        @Generated
        private String sigmaWorkbookQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SigmaWorkbookBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SigmaWorkbook instance, SigmaWorkbookBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sigmaDataElementName(instance.sigmaDataElementName);
            b.sigmaDataElementQualifiedName(instance.sigmaDataElementQualifiedName);
            b.sigmaPageCount(instance.sigmaPageCount);
            b.sigmaPageName(instance.sigmaPageName);
            b.sigmaPageQualifiedName(instance.sigmaPageQualifiedName);
            b.sigmaPages(instance.sigmaPages == null ? Collections.emptySortedSet() : instance.sigmaPages);
            b.sigmaWorkbookName(instance.sigmaWorkbookName);
            b.sigmaWorkbookQualifiedName(instance.sigmaWorkbookQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementName(String sigmaDataElementName) {
            this.sigmaDataElementName = sigmaDataElementName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementQualifiedName(String sigmaDataElementQualifiedName) {
            this.sigmaDataElementQualifiedName = sigmaDataElementQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageCount(Long sigmaPageCount) {
            this.sigmaPageCount = sigmaPageCount;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageName(String sigmaPageName) {
            this.sigmaPageName = sigmaPageName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageQualifiedName(String sigmaPageQualifiedName) {
            this.sigmaPageQualifiedName = sigmaPageQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPage(ISigmaPage sigmaPage) {
            if (this.sigmaPages == null) {
                this.sigmaPages = new ArrayList();
            }
            this.sigmaPages.add(sigmaPage);
            return (B)this.self();
        }

        @Generated
        public B sigmaPages(Collection<? extends ISigmaPage> sigmaPages) {
            if (sigmaPages == null) {
                throw new NullPointerException("sigmaPages cannot be null");
            }
            if (this.sigmaPages == null) {
                this.sigmaPages = new ArrayList();
            }
            this.sigmaPages.addAll(sigmaPages);
            return (B)this.self();
        }

        @Generated
        public B clearSigmaPages() {
            if (this.sigmaPages != null) {
                this.sigmaPages.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookName(String sigmaWorkbookName) {
            this.sigmaWorkbookName = sigmaWorkbookName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookQualifiedName(String sigmaWorkbookQualifiedName) {
            this.sigmaWorkbookQualifiedName = sigmaWorkbookQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SigmaWorkbook.SigmaWorkbookBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", sigmaDataElementName=" + this.sigmaDataElementName + ", sigmaDataElementQualifiedName=" + this.sigmaDataElementQualifiedName + ", sigmaPageCount=" + this.sigmaPageCount + ", sigmaPageName=" + this.sigmaPageName + ", sigmaPageQualifiedName=" + this.sigmaPageQualifiedName + ", sigmaPages=" + String.valueOf(this.sigmaPages) + ", sigmaWorkbookName=" + this.sigmaWorkbookName + ", sigmaWorkbookQualifiedName=" + this.sigmaWorkbookQualifiedName + ")";
        }
    }

    @Generated
    private static final class SigmaWorkbookBuilderImpl
    extends SigmaWorkbookBuilder<SigmaWorkbook, SigmaWorkbookBuilderImpl> {
        @Generated
        private SigmaWorkbookBuilderImpl() {
        }

        @Override
        @Generated
        protected SigmaWorkbookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SigmaWorkbook build() {
            return new SigmaWorkbook(this);
        }
    }
}

