/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISisense;
import com.atlan.model.assets.ISisenseDashboard;
import com.atlan.model.assets.ISisenseFolder;
import com.atlan.model.assets.ISisenseWidget;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisenseFolder
extends Asset
implements ISisenseFolder,
ISisense,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SisenseFolder.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SisenseFolder";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ISisenseFolder> sisenseChildFolders;
    @Attribute
    SortedSet<ISisenseDashboard> sisenseDashboards;
    @Attribute
    String sisenseFolderParentFolderQualifiedName;
    @Attribute
    ISisenseFolder sisenseParentFolder;
    @Attribute
    SortedSet<ISisenseWidget> sisenseWidgets;

    @Override
    public SisenseFolder trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SisenseFolder.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SisenseFolder.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SisenseFolder.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SisenseFolder.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SisenseFolder refByGuid(String guid) {
        return SisenseFolder.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseFolder refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SisenseFolderBuilder)((SisenseFolderBuilder)SisenseFolder._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SisenseFolder refByQualifiedName(String qualifiedName) {
        return SisenseFolder.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SisenseFolder refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SisenseFolderBuilder)((SisenseFolderBuilder)SisenseFolder._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id) throws AtlanException {
        return SisenseFolder.get(client, id, false);
    }

    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SisenseFolder) {
                return (SisenseFolder)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof SisenseFolder) {
            return (SisenseFolder)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return SisenseFolder.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static SisenseFolder get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SisenseFolder.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof SisenseFolder) {
                return (SisenseFolder)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)SisenseFolder.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof SisenseFolder) {
            return (SisenseFolder)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SisenseFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SisenseFolderBuilder)((SisenseFolderBuilder)((SisenseFolderBuilder)SisenseFolder._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SisenseFolderBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        SisenseFolder.validateRequired(TYPE_NAME, map);
        return SisenseFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static SisenseFolder removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder)Asset.removeDescription(client, SisenseFolder.updater(qualifiedName, name));
    }

    public static SisenseFolder removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder)Asset.removeUserDescription(client, SisenseFolder.updater(qualifiedName, name));
    }

    public static SisenseFolder removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder)Asset.removeOwners(client, SisenseFolder.updater(qualifiedName, name));
    }

    public static SisenseFolder updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SisenseFolder)Asset.updateCertificate(client, SisenseFolder._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SisenseFolder removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder)Asset.removeCertificate(client, SisenseFolder.updater(qualifiedName, name));
    }

    public static SisenseFolder updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SisenseFolder)Asset.updateAnnouncement(client, SisenseFolder._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SisenseFolder removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SisenseFolder)Asset.removeAnnouncement(client, SisenseFolder.updater(qualifiedName, name));
    }

    public static SisenseFolder replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder)Asset.replaceTerms(client, SisenseFolder.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static SisenseFolder appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SisenseFolder removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SisenseFolder)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static SisenseFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SisenseFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static SisenseFolder appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SisenseFolder)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SisenseFolder(SisenseFolderBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SisenseFolder.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ISisenseFolder> sisenseChildFolders = new TreeSet<ISisenseFolder>();
        if (b.sisenseChildFolders != null) {
            sisenseChildFolders.addAll(b.sisenseChildFolders);
        }
        sisenseChildFolders = Collections.unmodifiableSortedSet(sisenseChildFolders);
        this.sisenseChildFolders = sisenseChildFolders;
        SortedSet<ISisenseDashboard> sisenseDashboards = new TreeSet<ISisenseDashboard>();
        if (b.sisenseDashboards != null) {
            sisenseDashboards.addAll(b.sisenseDashboards);
        }
        sisenseDashboards = Collections.unmodifiableSortedSet(sisenseDashboards);
        this.sisenseDashboards = sisenseDashboards;
        this.sisenseFolderParentFolderQualifiedName = b.sisenseFolderParentFolderQualifiedName;
        this.sisenseParentFolder = b.sisenseParentFolder;
        SortedSet<ISisenseWidget> sisenseWidgets = new TreeSet<ISisenseWidget>();
        if (b.sisenseWidgets != null) {
            sisenseWidgets.addAll(b.sisenseWidgets);
        }
        sisenseWidgets = Collections.unmodifiableSortedSet(sisenseWidgets);
        this.sisenseWidgets = sisenseWidgets;
    }

    @Generated
    public static SisenseFolderBuilder<?, ?> _internal() {
        return new SisenseFolderBuilderImpl();
    }

    @Generated
    public SisenseFolderBuilder<?, ?> toBuilder() {
        return new SisenseFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ISisenseFolder> getSisenseChildFolders() {
        return this.sisenseChildFolders;
    }

    @Override
    @Generated
    public SortedSet<ISisenseDashboard> getSisenseDashboards() {
        return this.sisenseDashboards;
    }

    @Override
    @Generated
    public String getSisenseFolderParentFolderQualifiedName() {
        return this.sisenseFolderParentFolderQualifiedName;
    }

    @Override
    @Generated
    public ISisenseFolder getSisenseParentFolder() {
        return this.sisenseParentFolder;
    }

    @Override
    @Generated
    public SortedSet<ISisenseWidget> getSisenseWidgets() {
        return this.sisenseWidgets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SisenseFolder)) {
            return false;
        }
        SisenseFolder other = (SisenseFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ISisenseFolder> this$sisenseChildFolders = this.getSisenseChildFolders();
        SortedSet<ISisenseFolder> other$sisenseChildFolders = other.getSisenseChildFolders();
        if (this$sisenseChildFolders == null ? other$sisenseChildFolders != null : !this$sisenseChildFolders.equals(other$sisenseChildFolders)) {
            return false;
        }
        SortedSet<ISisenseDashboard> this$sisenseDashboards = this.getSisenseDashboards();
        SortedSet<ISisenseDashboard> other$sisenseDashboards = other.getSisenseDashboards();
        if (this$sisenseDashboards == null ? other$sisenseDashboards != null : !this$sisenseDashboards.equals(other$sisenseDashboards)) {
            return false;
        }
        String this$sisenseFolderParentFolderQualifiedName = this.getSisenseFolderParentFolderQualifiedName();
        String other$sisenseFolderParentFolderQualifiedName = other.getSisenseFolderParentFolderQualifiedName();
        if (this$sisenseFolderParentFolderQualifiedName == null ? other$sisenseFolderParentFolderQualifiedName != null : !this$sisenseFolderParentFolderQualifiedName.equals(other$sisenseFolderParentFolderQualifiedName)) {
            return false;
        }
        ISisenseFolder this$sisenseParentFolder = this.getSisenseParentFolder();
        ISisenseFolder other$sisenseParentFolder = other.getSisenseParentFolder();
        if (this$sisenseParentFolder == null ? other$sisenseParentFolder != null : !this$sisenseParentFolder.equals(other$sisenseParentFolder)) {
            return false;
        }
        SortedSet<ISisenseWidget> this$sisenseWidgets = this.getSisenseWidgets();
        SortedSet<ISisenseWidget> other$sisenseWidgets = other.getSisenseWidgets();
        return !(this$sisenseWidgets == null ? other$sisenseWidgets != null : !this$sisenseWidgets.equals(other$sisenseWidgets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SisenseFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ISisenseFolder> $sisenseChildFolders = this.getSisenseChildFolders();
        result = result * 59 + ($sisenseChildFolders == null ? 43 : $sisenseChildFolders.hashCode());
        SortedSet<ISisenseDashboard> $sisenseDashboards = this.getSisenseDashboards();
        result = result * 59 + ($sisenseDashboards == null ? 43 : $sisenseDashboards.hashCode());
        String $sisenseFolderParentFolderQualifiedName = this.getSisenseFolderParentFolderQualifiedName();
        result = result * 59 + ($sisenseFolderParentFolderQualifiedName == null ? 43 : $sisenseFolderParentFolderQualifiedName.hashCode());
        ISisenseFolder $sisenseParentFolder = this.getSisenseParentFolder();
        result = result * 59 + ($sisenseParentFolder == null ? 43 : $sisenseParentFolder.hashCode());
        SortedSet<ISisenseWidget> $sisenseWidgets = this.getSisenseWidgets();
        result = result * 59 + ($sisenseWidgets == null ? 43 : $sisenseWidgets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SisenseFolder(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", sisenseChildFolders=" + String.valueOf(this.getSisenseChildFolders()) + ", sisenseDashboards=" + String.valueOf(this.getSisenseDashboards()) + ", sisenseFolderParentFolderQualifiedName=" + this.getSisenseFolderParentFolderQualifiedName() + ", sisenseParentFolder=" + String.valueOf(this.getSisenseParentFolder()) + ", sisenseWidgets=" + String.valueOf(this.getSisenseWidgets()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class SisenseFolderBuilder<C extends SisenseFolder, B extends SisenseFolderBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ISisenseFolder> sisenseChildFolders;
        @Generated
        private ArrayList<ISisenseDashboard> sisenseDashboards;
        @Generated
        private String sisenseFolderParentFolderQualifiedName;
        @Generated
        private ISisenseFolder sisenseParentFolder;
        @Generated
        private ArrayList<ISisenseWidget> sisenseWidgets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SisenseFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SisenseFolder instance, SisenseFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sisenseChildFolders(instance.sisenseChildFolders == null ? Collections.emptySortedSet() : instance.sisenseChildFolders);
            b.sisenseDashboards(instance.sisenseDashboards == null ? Collections.emptySortedSet() : instance.sisenseDashboards);
            b.sisenseFolderParentFolderQualifiedName(instance.sisenseFolderParentFolderQualifiedName);
            b.sisenseParentFolder(instance.sisenseParentFolder);
            b.sisenseWidgets(instance.sisenseWidgets == null ? Collections.emptySortedSet() : instance.sisenseWidgets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseChildFolder(ISisenseFolder sisenseChildFolder) {
            if (this.sisenseChildFolders == null) {
                this.sisenseChildFolders = new ArrayList();
            }
            this.sisenseChildFolders.add(sisenseChildFolder);
            return (B)this.self();
        }

        @Generated
        public B sisenseChildFolders(Collection<? extends ISisenseFolder> sisenseChildFolders) {
            if (sisenseChildFolders == null) {
                throw new NullPointerException("sisenseChildFolders cannot be null");
            }
            if (this.sisenseChildFolders == null) {
                this.sisenseChildFolders = new ArrayList();
            }
            this.sisenseChildFolders.addAll(sisenseChildFolders);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseChildFolders() {
            if (this.sisenseChildFolders != null) {
                this.sisenseChildFolders.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboard(ISisenseDashboard sisenseDashboard) {
            if (this.sisenseDashboards == null) {
                this.sisenseDashboards = new ArrayList();
            }
            this.sisenseDashboards.add(sisenseDashboard);
            return (B)this.self();
        }

        @Generated
        public B sisenseDashboards(Collection<? extends ISisenseDashboard> sisenseDashboards) {
            if (sisenseDashboards == null) {
                throw new NullPointerException("sisenseDashboards cannot be null");
            }
            if (this.sisenseDashboards == null) {
                this.sisenseDashboards = new ArrayList();
            }
            this.sisenseDashboards.addAll(sisenseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseDashboards() {
            if (this.sisenseDashboards != null) {
                this.sisenseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sisenseFolderParentFolderQualifiedName(String sisenseFolderParentFolderQualifiedName) {
            this.sisenseFolderParentFolderQualifiedName = sisenseFolderParentFolderQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sisenseParentFolder(ISisenseFolder sisenseParentFolder) {
            this.sisenseParentFolder = sisenseParentFolder;
            return (B)this.self();
        }

        @Generated
        public B sisenseWidget(ISisenseWidget sisenseWidget) {
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.add(sisenseWidget);
            return (B)this.self();
        }

        @Generated
        public B sisenseWidgets(Collection<? extends ISisenseWidget> sisenseWidgets) {
            if (sisenseWidgets == null) {
                throw new NullPointerException("sisenseWidgets cannot be null");
            }
            if (this.sisenseWidgets == null) {
                this.sisenseWidgets = new ArrayList();
            }
            this.sisenseWidgets.addAll(sisenseWidgets);
            return (B)this.self();
        }

        @Generated
        public B clearSisenseWidgets() {
            if (this.sisenseWidgets != null) {
                this.sisenseWidgets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SisenseFolder.SisenseFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", sisenseChildFolders=" + String.valueOf(this.sisenseChildFolders) + ", sisenseDashboards=" + String.valueOf(this.sisenseDashboards) + ", sisenseFolderParentFolderQualifiedName=" + this.sisenseFolderParentFolderQualifiedName + ", sisenseParentFolder=" + String.valueOf(this.sisenseParentFolder) + ", sisenseWidgets=" + String.valueOf(this.sisenseWidgets) + ")";
        }
    }

    @Generated
    private static final class SisenseFolderBuilderImpl
    extends SisenseFolderBuilder<SisenseFolder, SisenseFolderBuilderImpl> {
        @Generated
        private SisenseFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected SisenseFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SisenseFolder build() {
            return new SisenseFolder(this);
        }
    }
}

