/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSeed;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.ITablePartition;
import com.atlan.model.assets.Table;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablePartition
extends Asset
implements ITablePartition,
ISQL,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TablePartition.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TablePartition";
    String typeName;
    @Attribute
    String alias;
    @Attribute
    String calculationViewName;
    @Attribute
    String calculationViewQualifiedName;
    @Attribute
    SortedSet<ITablePartition> childTablePartitions;
    @Attribute
    Long columnCount;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String constraint;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSeed> dbtSeedAssets;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    String externalLocation;
    @Attribute
    String externalLocationFormat;
    @Attribute
    String externalLocationRegion;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isPartitioned;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Boolean isTemporary;
    @Attribute
    @Date
    Long lastProfiledAt;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ITable parentTable;
    @Attribute
    ITablePartition parentTablePartition;
    @Attribute
    Long partitionCount;
    @Attribute
    String partitionList;
    @Attribute
    String partitionStrategy;
    @Attribute
    Long queryCount;
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    Long rowCount;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    Long sizeBytes;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    @Override
    public TablePartition trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TablePartition.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TablePartition.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TablePartition.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TablePartition.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TablePartition refByGuid(String guid) {
        return TablePartition.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TablePartition refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TablePartitionBuilder)((TablePartitionBuilder)TablePartition._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TablePartition refByQualifiedName(String qualifiedName) {
        return TablePartition.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TablePartition refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TablePartitionBuilder)((TablePartitionBuilder)TablePartition._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id) throws AtlanException {
        return TablePartition.get(client, id, false);
    }

    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TablePartition) {
                return (TablePartition)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof TablePartition) {
            return (TablePartition)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return TablePartition.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static TablePartition get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TablePartition.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof TablePartition) {
                return (TablePartition)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TablePartition.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof TablePartition) {
            return (TablePartition)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TablePartitionBuilder<?, ?> creator(String name, Table table) throws InvalidRequestException {
        if (table.getQualifiedName() == null || table.getQualifiedName().isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, "Table", "qualifiedName");
        }
        return TablePartition.creator(name, table.getQualifiedName()).parentTable(table.trimToReference());
    }

    public static TablePartitionBuilder<?, ?> creator(String name, String tableQualifiedName) {
        String tableName = StringUtils.getNameFromQualifiedName(tableQualifiedName);
        String schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(tableQualifiedName);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return TablePartition.creator(name, connectionQualifiedName, databaseName, databaseQualifiedName, schemaName, schemaQualifiedName, tableName, tableQualifiedName);
    }

    public static TablePartitionBuilder<?, ?> creator(String name, String connectionQualifiedName, String databaseName, String databaseQualifiedName, String schemaName, String schemaQualifiedName, String tableName, String tableQualifiedName) {
        return (TablePartitionBuilder)((Asset.AssetBuilder)((TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)TablePartition._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(TablePartition.generateQualifiedName(name, schemaQualifiedName))).parentTable(Table.refByQualifiedName(tableQualifiedName))).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static String generateQualifiedName(String name, String schemaQualifiedName) {
        return schemaQualifiedName + "/" + name;
    }

    public static TablePartitionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TablePartitionBuilder)((TablePartitionBuilder)((TablePartitionBuilder)TablePartition._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TablePartitionBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TablePartition.validateRequired(TYPE_NAME, map);
        return TablePartition.updater(this.getQualifiedName(), this.getName());
    }

    public static TablePartition removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeDescription(client, TablePartition.updater(qualifiedName, name));
    }

    public static TablePartition removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeUserDescription(client, TablePartition.updater(qualifiedName, name));
    }

    public static TablePartition removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeOwners(client, TablePartition.updater(qualifiedName, name));
    }

    public static TablePartition updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TablePartition)Asset.updateCertificate(client, TablePartition._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TablePartition removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeCertificate(client, TablePartition.updater(qualifiedName, name));
    }

    public static TablePartition updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TablePartition)Asset.updateAnnouncement(client, TablePartition._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TablePartition removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TablePartition)Asset.removeAnnouncement(client, TablePartition.updater(qualifiedName, name));
    }

    public static TablePartition replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.replaceTerms(client, TablePartition.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static TablePartition appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TablePartition removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TablePartition)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TablePartition appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TablePartition)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static TablePartition appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TablePartition)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TablePartition(TablePartitionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : TablePartition.$default$typeName();
        this.alias = b.alias;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        SortedSet<ITablePartition> childTablePartitions = new TreeSet<ITablePartition>();
        if (b.childTablePartitions != null) {
            childTablePartitions.addAll(b.childTablePartitions);
        }
        childTablePartitions = Collections.unmodifiableSortedSet(childTablePartitions);
        this.childTablePartitions = childTablePartitions;
        this.columnCount = b.columnCount;
        SortedSet<IColumn> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.constraint = b.constraint;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSeed> dbtSeedAssets = new TreeSet<IDbtSeed>();
        if (b.dbtSeedAssets != null) {
            dbtSeedAssets.addAll(b.dbtSeedAssets);
        }
        dbtSeedAssets = Collections.unmodifiableSortedSet(dbtSeedAssets);
        this.dbtSeedAssets = dbtSeedAssets;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        this.externalLocation = b.externalLocation;
        this.externalLocationFormat = b.externalLocationFormat;
        this.externalLocationRegion = b.externalLocationRegion;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isPartitioned = b.isPartitioned;
        this.isProfiled = b.isProfiled;
        this.isQueryPreview = b.isQueryPreview;
        this.isTemporary = b.isTemporary;
        this.lastProfiledAt = b.lastProfiledAt;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.parentTable = b.parentTable;
        this.parentTablePartition = b.parentTablePartition;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        this.partitionStrategy = b.partitionStrategy;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.rowCount = b.rowCount;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.sizeBytes = b.sizeBytes;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @Generated
    public static TablePartitionBuilder<?, ?> _internal() {
        return new TablePartitionBuilderImpl();
    }

    @Generated
    public TablePartitionBuilder<?, ?> toBuilder() {
        return new TablePartitionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    @Override
    @Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITablePartition> getChildTablePartitions() {
        return this.childTablePartitions;
    }

    @Override
    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public String getConstraint() {
        return this.constraint;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSeed> getDbtSeedAssets() {
        return this.dbtSeedAssets;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public String getExternalLocation() {
        return this.externalLocation;
    }

    @Override
    @Generated
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    @Override
    @Generated
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Override
    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ITable getParentTable() {
        return this.parentTable;
    }

    @Override
    @Generated
    public ITablePartition getParentTablePartition() {
        return this.parentTablePartition;
    }

    @Override
    @Generated
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    @Generated
    public String getPartitionList() {
        return this.partitionList;
    }

    @Override
    @Generated
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablePartition)) {
            return false;
        }
        TablePartition other = (TablePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$partitionCount = this.getPartitionCount();
        Long other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$calculationViewName = this.getCalculationViewName();
        String other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) {
            return false;
        }
        String this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        String other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) {
            return false;
        }
        SortedSet<ITablePartition> this$childTablePartitions = this.getChildTablePartitions();
        SortedSet<ITablePartition> other$childTablePartitions = other.getChildTablePartitions();
        if (this$childTablePartitions == null ? other$childTablePartitions != null : !this$childTablePartitions.equals(other$childTablePartitions)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$constraint = this.getConstraint();
        String other$constraint = other.getConstraint();
        if (this$constraint == null ? other$constraint != null : !this$constraint.equals(other$constraint)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSeed> this$dbtSeedAssets = this.getDbtSeedAssets();
        SortedSet<IDbtSeed> other$dbtSeedAssets = other.getDbtSeedAssets();
        if (this$dbtSeedAssets == null ? other$dbtSeedAssets != null : !this$dbtSeedAssets.equals(other$dbtSeedAssets)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        String this$externalLocation = this.getExternalLocation();
        String other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) {
            return false;
        }
        String this$externalLocationFormat = this.getExternalLocationFormat();
        String other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) {
            return false;
        }
        String this$externalLocationRegion = this.getExternalLocationRegion();
        String other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ITable this$parentTable = this.getParentTable();
        ITable other$parentTable = other.getParentTable();
        if (this$parentTable == null ? other$parentTable != null : !this$parentTable.equals(other$parentTable)) {
            return false;
        }
        ITablePartition this$parentTablePartition = this.getParentTablePartition();
        ITablePartition other$parentTablePartition = other.getParentTablePartition();
        if (this$parentTablePartition == null ? other$parentTablePartition != null : !this$parentTablePartition.equals(other$parentTablePartition)) {
            return false;
        }
        String this$partitionList = this.getPartitionList();
        String other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TablePartition;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $calculationViewName = this.getCalculationViewName();
        result = result * 59 + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        String $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * 59 + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        SortedSet<ITablePartition> $childTablePartitions = this.getChildTablePartitions();
        result = result * 59 + ($childTablePartitions == null ? 43 : $childTablePartitions.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $constraint = this.getConstraint();
        result = result * 59 + ($constraint == null ? 43 : $constraint.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSeed> $dbtSeedAssets = this.getDbtSeedAssets();
        result = result * 59 + ($dbtSeedAssets == null ? 43 : $dbtSeedAssets.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        String $externalLocation = this.getExternalLocation();
        result = result * 59 + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        String $externalLocationFormat = this.getExternalLocationFormat();
        result = result * 59 + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        String $externalLocationRegion = this.getExternalLocationRegion();
        result = result * 59 + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ITable $parentTable = this.getParentTable();
        result = result * 59 + ($parentTable == null ? 43 : $parentTable.hashCode());
        ITablePartition $parentTablePartition = this.getParentTablePartition();
        result = result * 59 + ($parentTablePartition == null ? 43 : $parentTablePartition.hashCode());
        String $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : $partitionList.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TablePartition(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", alias=" + this.getAlias() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", childTablePartitions=" + String.valueOf(this.getChildTablePartitions()) + ", columnCount=" + this.getColumnCount() + ", columns=" + String.valueOf(this.getColumns()) + ", constraint=" + this.getConstraint() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + String.valueOf(this.getDbtModels()) + ", dbtSeedAssets=" + String.valueOf(this.getDbtSeedAssets()) + ", dbtSources=" + String.valueOf(this.getDbtSources()) + ", dbtTests=" + String.valueOf(this.getDbtTests()) + ", externalLocation=" + this.getExternalLocation() + ", externalLocationFormat=" + this.getExternalLocationFormat() + ", externalLocationRegion=" + this.getExternalLocationRegion() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", isPartitioned=" + this.getIsPartitioned() + ", isProfiled=" + this.getIsProfiled() + ", isQueryPreview=" + this.getIsQueryPreview() + ", isTemporary=" + this.getIsTemporary() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", parentTable=" + String.valueOf(this.getParentTable()) + ", parentTablePartition=" + String.valueOf(this.getParentTablePartition()) + ", partitionCount=" + this.getPartitionCount() + ", partitionList=" + this.getPartitionList() + ", partitionStrategy=" + this.getPartitionStrategy() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryPreviewConfig=" + String.valueOf(this.getQueryPreviewConfig()) + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + String.valueOf(this.getQueryUserMap()) + ", rowCount=" + this.getRowCount() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sizeBytes=" + this.getSizeBytes() + ", sqlDBTSources=" + String.valueOf(this.getSqlDBTSources()) + ", sqlDbtModels=" + String.valueOf(this.getSqlDbtModels()) + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class TablePartitionBuilder<C extends TablePartition, B extends TablePartitionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String alias;
        @Generated
        private String calculationViewName;
        @Generated
        private String calculationViewQualifiedName;
        @Generated
        private ArrayList<ITablePartition> childTablePartitions;
        @Generated
        private Long columnCount;
        @Generated
        private ArrayList<IColumn> columns;
        @Generated
        private String constraint;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSeed> dbtSeedAssets;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private String externalLocation;
        @Generated
        private String externalLocationFormat;
        @Generated
        private String externalLocationRegion;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isPartitioned;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private Boolean isTemporary;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ITable parentTable;
        @Generated
        private ITablePartition parentTablePartition;
        @Generated
        private Long partitionCount;
        @Generated
        private String partitionList;
        @Generated
        private String partitionStrategy;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private Long rowCount;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private Long sizeBytes;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TablePartitionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TablePartition instance, TablePartitionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.alias(instance.alias);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.childTablePartitions(instance.childTablePartitions == null ? Collections.emptySortedSet() : instance.childTablePartitions);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.constraint(instance.constraint);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSeedAssets(instance.dbtSeedAssets == null ? Collections.emptySortedSet() : instance.dbtSeedAssets);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.externalLocation(instance.externalLocation);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isPartitioned(instance.isPartitioned);
            b.isProfiled(instance.isProfiled);
            b.isQueryPreview(instance.isQueryPreview);
            b.isTemporary(instance.isTemporary);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.parentTable(instance.parentTable);
            b.parentTablePartition(instance.parentTablePartition);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.partitionStrategy(instance.partitionStrategy);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.rowCount(instance.rowCount);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sizeBytes(instance.sizeBytes);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B calculationViewName(String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewQualifiedName(String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B childTablePartition(ITablePartition childTablePartition) {
            if (this.childTablePartitions == null) {
                this.childTablePartitions = new ArrayList();
            }
            this.childTablePartitions.add(childTablePartition);
            return (B)this.self();
        }

        @Generated
        public B childTablePartitions(Collection<? extends ITablePartition> childTablePartitions) {
            if (childTablePartitions == null) {
                throw new NullPointerException("childTablePartitions cannot be null");
            }
            if (this.childTablePartitions == null) {
                this.childTablePartitions = new ArrayList();
            }
            this.childTablePartitions.addAll(childTablePartitions);
            return (B)this.self();
        }

        @Generated
        public B clearChildTablePartitions() {
            if (this.childTablePartitions != null) {
                this.childTablePartitions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B constraint(String constraint) {
            this.constraint = constraint;
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAsset(IDbtSeed dbtSeedAsset) {
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.add(dbtSeedAsset);
            return (B)this.self();
        }

        @Generated
        public B dbtSeedAssets(Collection<? extends IDbtSeed> dbtSeedAssets) {
            if (dbtSeedAssets == null) {
                throw new NullPointerException("dbtSeedAssets cannot be null");
            }
            if (this.dbtSeedAssets == null) {
                this.dbtSeedAssets = new ArrayList();
            }
            this.dbtSeedAssets.addAll(dbtSeedAssets);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSeedAssets() {
            if (this.dbtSeedAssets != null) {
                this.dbtSeedAssets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B externalLocation(String externalLocation) {
            this.externalLocation = externalLocation;
            return (B)this.self();
        }

        @Generated
        public B externalLocationFormat(String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return (B)this.self();
        }

        @Generated
        public B externalLocationRegion(String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isPartitioned(Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B parentTable(ITable parentTable) {
            this.parentTable = parentTable;
            return (B)this.self();
        }

        @Generated
        public B parentTablePartition(ITablePartition parentTablePartition) {
            this.parentTablePartition = parentTablePartition;
            return (B)this.self();
        }

        @Generated
        public B partitionCount(Long partitionCount) {
            this.partitionCount = partitionCount;
            return (B)this.self();
        }

        @Generated
        public B partitionList(String partitionList) {
            this.partitionList = partitionList;
            return (B)this.self();
        }

        @Generated
        public B partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TablePartition.TablePartitionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", alias=" + this.alias + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", childTablePartitions=" + String.valueOf(this.childTablePartitions) + ", columnCount=" + this.columnCount + ", columns=" + String.valueOf(this.columns) + ", constraint=" + this.constraint + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + String.valueOf(this.dbtModels) + ", dbtSeedAssets=" + String.valueOf(this.dbtSeedAssets) + ", dbtSources=" + String.valueOf(this.dbtSources) + ", dbtTests=" + String.valueOf(this.dbtTests) + ", externalLocation=" + this.externalLocation + ", externalLocationFormat=" + this.externalLocationFormat + ", externalLocationRegion=" + this.externalLocationRegion + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", isPartitioned=" + this.isPartitioned + ", isProfiled=" + this.isProfiled + ", isQueryPreview=" + this.isQueryPreview + ", isTemporary=" + this.isTemporary + ", lastProfiledAt=" + this.lastProfiledAt + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", parentTable=" + String.valueOf(this.parentTable) + ", parentTablePartition=" + String.valueOf(this.parentTablePartition) + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", partitionStrategy=" + this.partitionStrategy + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryPreviewConfig$key=" + String.valueOf(this.queryPreviewConfig$key) + ", queryPreviewConfig$value=" + String.valueOf(this.queryPreviewConfig$value) + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + String.valueOf(this.queryUserMap$key) + ", queryUserMap$value=" + String.valueOf(this.queryUserMap$value) + ", rowCount=" + this.rowCount + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sizeBytes=" + this.sizeBytes + ", sqlDBTSources=" + String.valueOf(this.sqlDBTSources) + ", sqlDbtModels=" + String.valueOf(this.sqlDbtModels) + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }

    @Generated
    private static final class TablePartitionBuilderImpl
    extends TablePartitionBuilder<TablePartition, TablePartitionBuilderImpl> {
        @Generated
        private TablePartitionBuilderImpl() {
        }

        @Override
        @Generated
        protected TablePartitionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TablePartition build() {
            return new TablePartition(this);
        }
    }
}

