/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauDashboard;
import com.atlan.model.assets.ITableauDashboardField;
import com.atlan.model.assets.ITableauWorksheetField;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauDashboardField
extends Asset
implements ITableauDashboardField,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauDashboardField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDashboardField";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ITableauDashboard tableauDashboard;
    @Attribute
    String tableauDashboardFieldBinSize;
    @Attribute
    String tableauDashboardFieldDataCategory;
    @Attribute
    String tableauDashboardFieldDataType;
    @Attribute
    String tableauDashboardFieldFormula;
    @Attribute
    String tableauDashboardFieldRole;
    @Attribute
    String tableauDashboardFieldType;
    @Attribute
    List<Map<String, String>> tableauDashboardFieldUpstreamColumns;
    @Attribute
    List<Map<String, String>> tableauDashboardFieldUpstreamFields;
    @Attribute
    String tableauDashboardQualifiedName;
    @Attribute
    String tableauFullyQualifiedName;
    @Attribute
    List<Map<String, String>> tableauProjectHierarchy;
    @Attribute
    String tableauProjectQualifiedName;
    @Attribute
    String tableauSiteQualifiedName;
    @Attribute
    String tableauTopLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> tableauUpstreamTables;
    @Attribute
    ITableauWorksheetField tableauWorksheetField;

    @Override
    public TableauDashboardField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauDashboardField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauDashboardField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauDashboardField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauDashboardField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TableauDashboardField refByGuid(String guid) {
        return TableauDashboardField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TableauDashboardField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TableauDashboardFieldBuilder)((TableauDashboardFieldBuilder)TableauDashboardField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TableauDashboardField refByQualifiedName(String qualifiedName) {
        return TableauDashboardField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TableauDashboardField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TableauDashboardFieldBuilder)((TableauDashboardFieldBuilder)TableauDashboardField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TableauDashboardField get(AtlanClient client, String id) throws AtlanException {
        return TableauDashboardField.get(client, id, false);
    }

    @JsonIgnore
    public static TableauDashboardField get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauDashboardField) {
                return (TableauDashboardField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof TableauDashboardField) {
            return (TableauDashboardField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static TableauDashboardField get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return TableauDashboardField.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static TableauDashboardField get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauDashboardField.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof TableauDashboardField) {
                return (TableauDashboardField)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauDashboardField.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof TableauDashboardField) {
            return (TableauDashboardField)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauDashboardFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDashboardFieldBuilder)((TableauDashboardFieldBuilder)((TableauDashboardFieldBuilder)TableauDashboardField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauDashboardFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TableauDashboardField.validateRequired(TYPE_NAME, map);
        return TableauDashboardField.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDashboardField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDashboardField)Asset.removeDescription(client, TableauDashboardField.updater(qualifiedName, name));
    }

    public static TableauDashboardField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDashboardField)Asset.removeUserDescription(client, TableauDashboardField.updater(qualifiedName, name));
    }

    public static TableauDashboardField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDashboardField)Asset.removeOwners(client, TableauDashboardField.updater(qualifiedName, name));
    }

    public static TableauDashboardField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauDashboardField)Asset.updateCertificate(client, TableauDashboardField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDashboardField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDashboardField)Asset.removeCertificate(client, TableauDashboardField.updater(qualifiedName, name));
    }

    public static TableauDashboardField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDashboardField)Asset.updateAnnouncement(client, TableauDashboardField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDashboardField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDashboardField)Asset.removeAnnouncement(client, TableauDashboardField.updater(qualifiedName, name));
    }

    public static TableauDashboardField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDashboardField)Asset.replaceTerms(client, TableauDashboardField.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static TableauDashboardField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDashboardField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauDashboardField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDashboardField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauDashboardField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauDashboardField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static TableauDashboardField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauDashboardField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDashboardField(TableauDashboardFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TableauDashboardField.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.tableauDashboard = b.tableauDashboard;
        this.tableauDashboardFieldBinSize = b.tableauDashboardFieldBinSize;
        this.tableauDashboardFieldDataCategory = b.tableauDashboardFieldDataCategory;
        this.tableauDashboardFieldDataType = b.tableauDashboardFieldDataType;
        this.tableauDashboardFieldFormula = b.tableauDashboardFieldFormula;
        this.tableauDashboardFieldRole = b.tableauDashboardFieldRole;
        this.tableauDashboardFieldType = b.tableauDashboardFieldType;
        this.tableauDashboardFieldUpstreamColumns = switch (b.tableauDashboardFieldUpstreamColumns == null ? 0 : b.tableauDashboardFieldUpstreamColumns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauDashboardFieldUpstreamColumns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauDashboardFieldUpstreamColumns));
        };
        this.tableauDashboardFieldUpstreamFields = switch (b.tableauDashboardFieldUpstreamFields == null ? 0 : b.tableauDashboardFieldUpstreamFields.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauDashboardFieldUpstreamFields.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauDashboardFieldUpstreamFields));
        };
        this.tableauDashboardQualifiedName = b.tableauDashboardQualifiedName;
        this.tableauFullyQualifiedName = b.tableauFullyQualifiedName;
        this.tableauProjectHierarchy = switch (b.tableauProjectHierarchy == null ? 0 : b.tableauProjectHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauProjectHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauProjectHierarchy));
        };
        this.tableauProjectQualifiedName = b.tableauProjectQualifiedName;
        this.tableauSiteQualifiedName = b.tableauSiteQualifiedName;
        this.tableauTopLevelProjectQualifiedName = b.tableauTopLevelProjectQualifiedName;
        this.tableauUpstreamTables = switch (b.tableauUpstreamTables == null ? 0 : b.tableauUpstreamTables.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauUpstreamTables.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauUpstreamTables));
        };
        this.tableauWorksheetField = b.tableauWorksheetField;
    }

    @Generated
    public static TableauDashboardFieldBuilder<?, ?> _internal() {
        return new TableauDashboardFieldBuilderImpl();
    }

    @Generated
    public TableauDashboardFieldBuilder<?, ?> toBuilder() {
        return new TableauDashboardFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ITableauDashboard getTableauDashboard() {
        return this.tableauDashboard;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldBinSize() {
        return this.tableauDashboardFieldBinSize;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldDataCategory() {
        return this.tableauDashboardFieldDataCategory;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldDataType() {
        return this.tableauDashboardFieldDataType;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldFormula() {
        return this.tableauDashboardFieldFormula;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldRole() {
        return this.tableauDashboardFieldRole;
    }

    @Override
    @Generated
    public String getTableauDashboardFieldType() {
        return this.tableauDashboardFieldType;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauDashboardFieldUpstreamColumns() {
        return this.tableauDashboardFieldUpstreamColumns;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauDashboardFieldUpstreamFields() {
        return this.tableauDashboardFieldUpstreamFields;
    }

    @Override
    @Generated
    public String getTableauDashboardQualifiedName() {
        return this.tableauDashboardQualifiedName;
    }

    @Override
    @Generated
    public String getTableauFullyQualifiedName() {
        return this.tableauFullyQualifiedName;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauProjectHierarchy() {
        return this.tableauProjectHierarchy;
    }

    @Override
    @Generated
    public String getTableauProjectQualifiedName() {
        return this.tableauProjectQualifiedName;
    }

    @Override
    @Generated
    public String getTableauSiteQualifiedName() {
        return this.tableauSiteQualifiedName;
    }

    @Override
    @Generated
    public String getTableauTopLevelProjectQualifiedName() {
        return this.tableauTopLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauUpstreamTables() {
        return this.tableauUpstreamTables;
    }

    @Override
    @Generated
    public ITableauWorksheetField getTableauWorksheetField() {
        return this.tableauWorksheetField;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDashboardField)) {
            return false;
        }
        TableauDashboardField other = (TableauDashboardField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ITableauDashboard this$tableauDashboard = this.getTableauDashboard();
        ITableauDashboard other$tableauDashboard = other.getTableauDashboard();
        if (this$tableauDashboard == null ? other$tableauDashboard != null : !this$tableauDashboard.equals(other$tableauDashboard)) {
            return false;
        }
        String this$tableauDashboardFieldBinSize = this.getTableauDashboardFieldBinSize();
        String other$tableauDashboardFieldBinSize = other.getTableauDashboardFieldBinSize();
        if (this$tableauDashboardFieldBinSize == null ? other$tableauDashboardFieldBinSize != null : !this$tableauDashboardFieldBinSize.equals(other$tableauDashboardFieldBinSize)) {
            return false;
        }
        String this$tableauDashboardFieldDataCategory = this.getTableauDashboardFieldDataCategory();
        String other$tableauDashboardFieldDataCategory = other.getTableauDashboardFieldDataCategory();
        if (this$tableauDashboardFieldDataCategory == null ? other$tableauDashboardFieldDataCategory != null : !this$tableauDashboardFieldDataCategory.equals(other$tableauDashboardFieldDataCategory)) {
            return false;
        }
        String this$tableauDashboardFieldDataType = this.getTableauDashboardFieldDataType();
        String other$tableauDashboardFieldDataType = other.getTableauDashboardFieldDataType();
        if (this$tableauDashboardFieldDataType == null ? other$tableauDashboardFieldDataType != null : !this$tableauDashboardFieldDataType.equals(other$tableauDashboardFieldDataType)) {
            return false;
        }
        String this$tableauDashboardFieldFormula = this.getTableauDashboardFieldFormula();
        String other$tableauDashboardFieldFormula = other.getTableauDashboardFieldFormula();
        if (this$tableauDashboardFieldFormula == null ? other$tableauDashboardFieldFormula != null : !this$tableauDashboardFieldFormula.equals(other$tableauDashboardFieldFormula)) {
            return false;
        }
        String this$tableauDashboardFieldRole = this.getTableauDashboardFieldRole();
        String other$tableauDashboardFieldRole = other.getTableauDashboardFieldRole();
        if (this$tableauDashboardFieldRole == null ? other$tableauDashboardFieldRole != null : !this$tableauDashboardFieldRole.equals(other$tableauDashboardFieldRole)) {
            return false;
        }
        String this$tableauDashboardFieldType = this.getTableauDashboardFieldType();
        String other$tableauDashboardFieldType = other.getTableauDashboardFieldType();
        if (this$tableauDashboardFieldType == null ? other$tableauDashboardFieldType != null : !this$tableauDashboardFieldType.equals(other$tableauDashboardFieldType)) {
            return false;
        }
        List<Map<String, String>> this$tableauDashboardFieldUpstreamColumns = this.getTableauDashboardFieldUpstreamColumns();
        List<Map<String, String>> other$tableauDashboardFieldUpstreamColumns = other.getTableauDashboardFieldUpstreamColumns();
        if (this$tableauDashboardFieldUpstreamColumns == null ? other$tableauDashboardFieldUpstreamColumns != null : !((Object)this$tableauDashboardFieldUpstreamColumns).equals(other$tableauDashboardFieldUpstreamColumns)) {
            return false;
        }
        List<Map<String, String>> this$tableauDashboardFieldUpstreamFields = this.getTableauDashboardFieldUpstreamFields();
        List<Map<String, String>> other$tableauDashboardFieldUpstreamFields = other.getTableauDashboardFieldUpstreamFields();
        if (this$tableauDashboardFieldUpstreamFields == null ? other$tableauDashboardFieldUpstreamFields != null : !((Object)this$tableauDashboardFieldUpstreamFields).equals(other$tableauDashboardFieldUpstreamFields)) {
            return false;
        }
        String this$tableauDashboardQualifiedName = this.getTableauDashboardQualifiedName();
        String other$tableauDashboardQualifiedName = other.getTableauDashboardQualifiedName();
        if (this$tableauDashboardQualifiedName == null ? other$tableauDashboardQualifiedName != null : !this$tableauDashboardQualifiedName.equals(other$tableauDashboardQualifiedName)) {
            return false;
        }
        String this$tableauFullyQualifiedName = this.getTableauFullyQualifiedName();
        String other$tableauFullyQualifiedName = other.getTableauFullyQualifiedName();
        if (this$tableauFullyQualifiedName == null ? other$tableauFullyQualifiedName != null : !this$tableauFullyQualifiedName.equals(other$tableauFullyQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$tableauProjectHierarchy = this.getTableauProjectHierarchy();
        List<Map<String, String>> other$tableauProjectHierarchy = other.getTableauProjectHierarchy();
        if (this$tableauProjectHierarchy == null ? other$tableauProjectHierarchy != null : !((Object)this$tableauProjectHierarchy).equals(other$tableauProjectHierarchy)) {
            return false;
        }
        String this$tableauProjectQualifiedName = this.getTableauProjectQualifiedName();
        String other$tableauProjectQualifiedName = other.getTableauProjectQualifiedName();
        if (this$tableauProjectQualifiedName == null ? other$tableauProjectQualifiedName != null : !this$tableauProjectQualifiedName.equals(other$tableauProjectQualifiedName)) {
            return false;
        }
        String this$tableauSiteQualifiedName = this.getTableauSiteQualifiedName();
        String other$tableauSiteQualifiedName = other.getTableauSiteQualifiedName();
        if (this$tableauSiteQualifiedName == null ? other$tableauSiteQualifiedName != null : !this$tableauSiteQualifiedName.equals(other$tableauSiteQualifiedName)) {
            return false;
        }
        String this$tableauTopLevelProjectQualifiedName = this.getTableauTopLevelProjectQualifiedName();
        String other$tableauTopLevelProjectQualifiedName = other.getTableauTopLevelProjectQualifiedName();
        if (this$tableauTopLevelProjectQualifiedName == null ? other$tableauTopLevelProjectQualifiedName != null : !this$tableauTopLevelProjectQualifiedName.equals(other$tableauTopLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$tableauUpstreamTables = this.getTableauUpstreamTables();
        List<Map<String, String>> other$tableauUpstreamTables = other.getTableauUpstreamTables();
        if (this$tableauUpstreamTables == null ? other$tableauUpstreamTables != null : !((Object)this$tableauUpstreamTables).equals(other$tableauUpstreamTables)) {
            return false;
        }
        ITableauWorksheetField this$tableauWorksheetField = this.getTableauWorksheetField();
        ITableauWorksheetField other$tableauWorksheetField = other.getTableauWorksheetField();
        return !(this$tableauWorksheetField == null ? other$tableauWorksheetField != null : !this$tableauWorksheetField.equals(other$tableauWorksheetField));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDashboardField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ITableauDashboard $tableauDashboard = this.getTableauDashboard();
        result = result * 59 + ($tableauDashboard == null ? 43 : $tableauDashboard.hashCode());
        String $tableauDashboardFieldBinSize = this.getTableauDashboardFieldBinSize();
        result = result * 59 + ($tableauDashboardFieldBinSize == null ? 43 : $tableauDashboardFieldBinSize.hashCode());
        String $tableauDashboardFieldDataCategory = this.getTableauDashboardFieldDataCategory();
        result = result * 59 + ($tableauDashboardFieldDataCategory == null ? 43 : $tableauDashboardFieldDataCategory.hashCode());
        String $tableauDashboardFieldDataType = this.getTableauDashboardFieldDataType();
        result = result * 59 + ($tableauDashboardFieldDataType == null ? 43 : $tableauDashboardFieldDataType.hashCode());
        String $tableauDashboardFieldFormula = this.getTableauDashboardFieldFormula();
        result = result * 59 + ($tableauDashboardFieldFormula == null ? 43 : $tableauDashboardFieldFormula.hashCode());
        String $tableauDashboardFieldRole = this.getTableauDashboardFieldRole();
        result = result * 59 + ($tableauDashboardFieldRole == null ? 43 : $tableauDashboardFieldRole.hashCode());
        String $tableauDashboardFieldType = this.getTableauDashboardFieldType();
        result = result * 59 + ($tableauDashboardFieldType == null ? 43 : $tableauDashboardFieldType.hashCode());
        List<Map<String, String>> $tableauDashboardFieldUpstreamColumns = this.getTableauDashboardFieldUpstreamColumns();
        result = result * 59 + ($tableauDashboardFieldUpstreamColumns == null ? 43 : ((Object)$tableauDashboardFieldUpstreamColumns).hashCode());
        List<Map<String, String>> $tableauDashboardFieldUpstreamFields = this.getTableauDashboardFieldUpstreamFields();
        result = result * 59 + ($tableauDashboardFieldUpstreamFields == null ? 43 : ((Object)$tableauDashboardFieldUpstreamFields).hashCode());
        String $tableauDashboardQualifiedName = this.getTableauDashboardQualifiedName();
        result = result * 59 + ($tableauDashboardQualifiedName == null ? 43 : $tableauDashboardQualifiedName.hashCode());
        String $tableauFullyQualifiedName = this.getTableauFullyQualifiedName();
        result = result * 59 + ($tableauFullyQualifiedName == null ? 43 : $tableauFullyQualifiedName.hashCode());
        List<Map<String, String>> $tableauProjectHierarchy = this.getTableauProjectHierarchy();
        result = result * 59 + ($tableauProjectHierarchy == null ? 43 : ((Object)$tableauProjectHierarchy).hashCode());
        String $tableauProjectQualifiedName = this.getTableauProjectQualifiedName();
        result = result * 59 + ($tableauProjectQualifiedName == null ? 43 : $tableauProjectQualifiedName.hashCode());
        String $tableauSiteQualifiedName = this.getTableauSiteQualifiedName();
        result = result * 59 + ($tableauSiteQualifiedName == null ? 43 : $tableauSiteQualifiedName.hashCode());
        String $tableauTopLevelProjectQualifiedName = this.getTableauTopLevelProjectQualifiedName();
        result = result * 59 + ($tableauTopLevelProjectQualifiedName == null ? 43 : $tableauTopLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $tableauUpstreamTables = this.getTableauUpstreamTables();
        result = result * 59 + ($tableauUpstreamTables == null ? 43 : ((Object)$tableauUpstreamTables).hashCode());
        ITableauWorksheetField $tableauWorksheetField = this.getTableauWorksheetField();
        result = result * 59 + ($tableauWorksheetField == null ? 43 : $tableauWorksheetField.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauDashboardField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", tableauDashboard=" + String.valueOf(this.getTableauDashboard()) + ", tableauDashboardFieldBinSize=" + this.getTableauDashboardFieldBinSize() + ", tableauDashboardFieldDataCategory=" + this.getTableauDashboardFieldDataCategory() + ", tableauDashboardFieldDataType=" + this.getTableauDashboardFieldDataType() + ", tableauDashboardFieldFormula=" + this.getTableauDashboardFieldFormula() + ", tableauDashboardFieldRole=" + this.getTableauDashboardFieldRole() + ", tableauDashboardFieldType=" + this.getTableauDashboardFieldType() + ", tableauDashboardFieldUpstreamColumns=" + String.valueOf(this.getTableauDashboardFieldUpstreamColumns()) + ", tableauDashboardFieldUpstreamFields=" + String.valueOf(this.getTableauDashboardFieldUpstreamFields()) + ", tableauDashboardQualifiedName=" + this.getTableauDashboardQualifiedName() + ", tableauFullyQualifiedName=" + this.getTableauFullyQualifiedName() + ", tableauProjectHierarchy=" + String.valueOf(this.getTableauProjectHierarchy()) + ", tableauProjectQualifiedName=" + this.getTableauProjectQualifiedName() + ", tableauSiteQualifiedName=" + this.getTableauSiteQualifiedName() + ", tableauTopLevelProjectQualifiedName=" + this.getTableauTopLevelProjectQualifiedName() + ", tableauUpstreamTables=" + String.valueOf(this.getTableauUpstreamTables()) + ", tableauWorksheetField=" + String.valueOf(this.getTableauWorksheetField()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class TableauDashboardFieldBuilder<C extends TableauDashboardField, B extends TableauDashboardFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ITableauDashboard tableauDashboard;
        @Generated
        private String tableauDashboardFieldBinSize;
        @Generated
        private String tableauDashboardFieldDataCategory;
        @Generated
        private String tableauDashboardFieldDataType;
        @Generated
        private String tableauDashboardFieldFormula;
        @Generated
        private String tableauDashboardFieldRole;
        @Generated
        private String tableauDashboardFieldType;
        @Generated
        private ArrayList<Map<String, String>> tableauDashboardFieldUpstreamColumns;
        @Generated
        private ArrayList<Map<String, String>> tableauDashboardFieldUpstreamFields;
        @Generated
        private String tableauDashboardQualifiedName;
        @Generated
        private String tableauFullyQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> tableauProjectHierarchy;
        @Generated
        private String tableauProjectQualifiedName;
        @Generated
        private String tableauSiteQualifiedName;
        @Generated
        private String tableauTopLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> tableauUpstreamTables;
        @Generated
        private ITableauWorksheetField tableauWorksheetField;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDashboardFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDashboardField instance, TableauDashboardFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.tableauDashboard(instance.tableauDashboard);
            b.tableauDashboardFieldBinSize(instance.tableauDashboardFieldBinSize);
            b.tableauDashboardFieldDataCategory(instance.tableauDashboardFieldDataCategory);
            b.tableauDashboardFieldDataType(instance.tableauDashboardFieldDataType);
            b.tableauDashboardFieldFormula(instance.tableauDashboardFieldFormula);
            b.tableauDashboardFieldRole(instance.tableauDashboardFieldRole);
            b.tableauDashboardFieldType(instance.tableauDashboardFieldType);
            b.tableauDashboardFieldUpstreamColumns(instance.tableauDashboardFieldUpstreamColumns == null ? Collections.emptyList() : instance.tableauDashboardFieldUpstreamColumns);
            b.tableauDashboardFieldUpstreamFields(instance.tableauDashboardFieldUpstreamFields == null ? Collections.emptyList() : instance.tableauDashboardFieldUpstreamFields);
            b.tableauDashboardQualifiedName(instance.tableauDashboardQualifiedName);
            b.tableauFullyQualifiedName(instance.tableauFullyQualifiedName);
            b.tableauProjectHierarchy(instance.tableauProjectHierarchy == null ? Collections.emptyList() : instance.tableauProjectHierarchy);
            b.tableauProjectQualifiedName(instance.tableauProjectQualifiedName);
            b.tableauSiteQualifiedName(instance.tableauSiteQualifiedName);
            b.tableauTopLevelProjectQualifiedName(instance.tableauTopLevelProjectQualifiedName);
            b.tableauUpstreamTables(instance.tableauUpstreamTables == null ? Collections.emptyList() : instance.tableauUpstreamTables);
            b.tableauWorksheetField(instance.tableauWorksheetField);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauDashboard(ITableauDashboard tableauDashboard) {
            this.tableauDashboard = tableauDashboard;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldBinSize(String tableauDashboardFieldBinSize) {
            this.tableauDashboardFieldBinSize = tableauDashboardFieldBinSize;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldDataCategory(String tableauDashboardFieldDataCategory) {
            this.tableauDashboardFieldDataCategory = tableauDashboardFieldDataCategory;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldDataType(String tableauDashboardFieldDataType) {
            this.tableauDashboardFieldDataType = tableauDashboardFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldFormula(String tableauDashboardFieldFormula) {
            this.tableauDashboardFieldFormula = tableauDashboardFieldFormula;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldRole(String tableauDashboardFieldRole) {
            this.tableauDashboardFieldRole = tableauDashboardFieldRole;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldType(String tableauDashboardFieldType) {
            this.tableauDashboardFieldType = tableauDashboardFieldType;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldUpstreamColumn(Map<String, String> tableauDashboardFieldUpstreamColumn) {
            if (this.tableauDashboardFieldUpstreamColumns == null) {
                this.tableauDashboardFieldUpstreamColumns = new ArrayList();
            }
            this.tableauDashboardFieldUpstreamColumns.add(tableauDashboardFieldUpstreamColumn);
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldUpstreamColumns(Collection<? extends Map<String, String>> tableauDashboardFieldUpstreamColumns) {
            if (tableauDashboardFieldUpstreamColumns == null) {
                throw new NullPointerException("tableauDashboardFieldUpstreamColumns cannot be null");
            }
            if (this.tableauDashboardFieldUpstreamColumns == null) {
                this.tableauDashboardFieldUpstreamColumns = new ArrayList();
            }
            this.tableauDashboardFieldUpstreamColumns.addAll(tableauDashboardFieldUpstreamColumns);
            return (B)this.self();
        }

        @Generated
        public B clearTableauDashboardFieldUpstreamColumns() {
            if (this.tableauDashboardFieldUpstreamColumns != null) {
                this.tableauDashboardFieldUpstreamColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldUpstreamField(Map<String, String> tableauDashboardFieldUpstreamField) {
            if (this.tableauDashboardFieldUpstreamFields == null) {
                this.tableauDashboardFieldUpstreamFields = new ArrayList();
            }
            this.tableauDashboardFieldUpstreamFields.add(tableauDashboardFieldUpstreamField);
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardFieldUpstreamFields(Collection<? extends Map<String, String>> tableauDashboardFieldUpstreamFields) {
            if (tableauDashboardFieldUpstreamFields == null) {
                throw new NullPointerException("tableauDashboardFieldUpstreamFields cannot be null");
            }
            if (this.tableauDashboardFieldUpstreamFields == null) {
                this.tableauDashboardFieldUpstreamFields = new ArrayList();
            }
            this.tableauDashboardFieldUpstreamFields.addAll(tableauDashboardFieldUpstreamFields);
            return (B)this.self();
        }

        @Generated
        public B clearTableauDashboardFieldUpstreamFields() {
            if (this.tableauDashboardFieldUpstreamFields != null) {
                this.tableauDashboardFieldUpstreamFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardQualifiedName(String tableauDashboardQualifiedName) {
            this.tableauDashboardQualifiedName = tableauDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauFullyQualifiedName(String tableauFullyQualifiedName) {
            this.tableauFullyQualifiedName = tableauFullyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addTableauProjectHierarchy(Map<String, String> addTableauProjectHierarchy) {
            if (this.tableauProjectHierarchy == null) {
                this.tableauProjectHierarchy = new ArrayList();
            }
            this.tableauProjectHierarchy.add(addTableauProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B tableauProjectHierarchy(Collection<? extends Map<String, String>> tableauProjectHierarchy) {
            if (tableauProjectHierarchy == null) {
                throw new NullPointerException("tableauProjectHierarchy cannot be null");
            }
            if (this.tableauProjectHierarchy == null) {
                this.tableauProjectHierarchy = new ArrayList();
            }
            this.tableauProjectHierarchy.addAll(tableauProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearTableauProjectHierarchy() {
            if (this.tableauProjectHierarchy != null) {
                this.tableauProjectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauProjectQualifiedName(String tableauProjectQualifiedName) {
            this.tableauProjectQualifiedName = tableauProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauSiteQualifiedName(String tableauSiteQualifiedName) {
            this.tableauSiteQualifiedName = tableauSiteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauTopLevelProjectQualifiedName(String tableauTopLevelProjectQualifiedName) {
            this.tableauTopLevelProjectQualifiedName = tableauTopLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauUpstreamTable(Map<String, String> tableauUpstreamTable) {
            if (this.tableauUpstreamTables == null) {
                this.tableauUpstreamTables = new ArrayList();
            }
            this.tableauUpstreamTables.add(tableauUpstreamTable);
            return (B)this.self();
        }

        @Generated
        public B tableauUpstreamTables(Collection<? extends Map<String, String>> tableauUpstreamTables) {
            if (tableauUpstreamTables == null) {
                throw new NullPointerException("tableauUpstreamTables cannot be null");
            }
            if (this.tableauUpstreamTables == null) {
                this.tableauUpstreamTables = new ArrayList();
            }
            this.tableauUpstreamTables.addAll(tableauUpstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearTableauUpstreamTables() {
            if (this.tableauUpstreamTables != null) {
                this.tableauUpstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetField(ITableauWorksheetField tableauWorksheetField) {
            this.tableauWorksheetField = tableauWorksheetField;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TableauDashboardField.TableauDashboardFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", tableauDashboard=" + String.valueOf(this.tableauDashboard) + ", tableauDashboardFieldBinSize=" + this.tableauDashboardFieldBinSize + ", tableauDashboardFieldDataCategory=" + this.tableauDashboardFieldDataCategory + ", tableauDashboardFieldDataType=" + this.tableauDashboardFieldDataType + ", tableauDashboardFieldFormula=" + this.tableauDashboardFieldFormula + ", tableauDashboardFieldRole=" + this.tableauDashboardFieldRole + ", tableauDashboardFieldType=" + this.tableauDashboardFieldType + ", tableauDashboardFieldUpstreamColumns=" + String.valueOf(this.tableauDashboardFieldUpstreamColumns) + ", tableauDashboardFieldUpstreamFields=" + String.valueOf(this.tableauDashboardFieldUpstreamFields) + ", tableauDashboardQualifiedName=" + this.tableauDashboardQualifiedName + ", tableauFullyQualifiedName=" + this.tableauFullyQualifiedName + ", tableauProjectHierarchy=" + String.valueOf(this.tableauProjectHierarchy) + ", tableauProjectQualifiedName=" + this.tableauProjectQualifiedName + ", tableauSiteQualifiedName=" + this.tableauSiteQualifiedName + ", tableauTopLevelProjectQualifiedName=" + this.tableauTopLevelProjectQualifiedName + ", tableauUpstreamTables=" + String.valueOf(this.tableauUpstreamTables) + ", tableauWorksheetField=" + String.valueOf(this.tableauWorksheetField) + ")";
        }
    }

    @Generated
    private static final class TableauDashboardFieldBuilderImpl
    extends TableauDashboardFieldBuilder<TableauDashboardField, TableauDashboardFieldBuilderImpl> {
        @Generated
        private TableauDashboardFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDashboardFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDashboardField build() {
            return new TableauDashboardField(this);
        }
    }
}

