/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauDatasource;
import com.atlan.model.assets.ITableauDatasourceField;
import com.atlan.model.assets.ITableauField;
import com.atlan.model.assets.ITableauWorksheet;
import com.atlan.model.assets.ITableauWorksheetField;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauDatasourceField
extends Asset
implements ITableauField,
ITableauDatasourceField,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauDatasourceField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauDatasourceField";
    String typeName;
    @Attribute
    ITableauDatasource datasource;
    @Attribute
    String datasourceFieldType;
    @Attribute
    String datasourceQualifiedName;
    @Attribute
    String fullyQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    List<Map<String, String>> projectHierarchy;
    @Attribute
    String projectQualifiedName;
    @Attribute
    String siteQualifiedName;
    @Attribute
    String tableauDatasourceFieldBinSize;
    @Attribute
    String tableauDatasourceFieldDataCategory;
    @Attribute
    String tableauDatasourceFieldDataType;
    @Attribute
    String tableauDatasourceFieldFormula;
    @Attribute
    String tableauDatasourceFieldRole;
    @Attribute
    ITableauWorksheetField tableauWorksheetField;
    @Attribute
    String topLevelProjectQualifiedName;
    @Attribute
    List<Map<String, String>> upstreamColumns;
    @Attribute
    List<Map<String, String>> upstreamFields;
    @Attribute
    List<Map<String, String>> upstreamTables;
    @Attribute
    String workbookQualifiedName;
    @Attribute
    SortedSet<ITableauWorksheet> worksheets;

    @Override
    public TableauDatasourceField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauDatasourceField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauDatasourceField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauDatasourceField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauDatasourceField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TableauDatasourceField refByGuid(String guid) {
        return TableauDatasourceField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TableauDatasourceField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TableauDatasourceFieldBuilder)((TableauDatasourceFieldBuilder)TableauDatasourceField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TableauDatasourceField refByQualifiedName(String qualifiedName) {
        return TableauDatasourceField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TableauDatasourceField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TableauDatasourceFieldBuilder)((TableauDatasourceFieldBuilder)TableauDatasourceField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id) throws AtlanException {
        return TableauDatasourceField.get(client, id, false);
    }

    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauDatasourceField) {
                return (TableauDatasourceField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof TableauDatasourceField) {
            return (TableauDatasourceField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return TableauDatasourceField.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static TableauDatasourceField get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauDatasourceField.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof TableauDatasourceField) {
                return (TableauDatasourceField)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauDatasourceField.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof TableauDatasourceField) {
            return (TableauDatasourceField)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauDatasourceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauDatasourceFieldBuilder)((TableauDatasourceFieldBuilder)((TableauDatasourceFieldBuilder)TableauDatasourceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauDatasourceFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TableauDatasourceField.validateRequired(TYPE_NAME, map);
        return TableauDatasourceField.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauDatasourceField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeDescription(client, TableauDatasourceField.updater(qualifiedName, name));
    }

    public static TableauDatasourceField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeUserDescription(client, TableauDatasourceField.updater(qualifiedName, name));
    }

    public static TableauDatasourceField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeOwners(client, TableauDatasourceField.updater(qualifiedName, name));
    }

    public static TableauDatasourceField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauDatasourceField)Asset.updateCertificate(client, TableauDatasourceField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauDatasourceField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeCertificate(client, TableauDatasourceField.updater(qualifiedName, name));
    }

    public static TableauDatasourceField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauDatasourceField)Asset.updateAnnouncement(client, TableauDatasourceField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauDatasourceField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauDatasourceField)Asset.removeAnnouncement(client, TableauDatasourceField.updater(qualifiedName, name));
    }

    public static TableauDatasourceField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.replaceTerms(client, TableauDatasourceField.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static TableauDatasourceField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauDatasourceField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauDatasourceField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauDatasourceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauDatasourceField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static TableauDatasourceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauDatasourceField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauDatasourceField(TableauDatasourceFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TableauDatasourceField.$default$typeName();
        this.datasource = b.datasource;
        this.datasourceFieldType = b.datasourceFieldType;
        this.datasourceQualifiedName = b.datasourceQualifiedName;
        this.fullyQualifiedName = b.fullyQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.projectHierarchy = switch (b.projectHierarchy == null ? 0 : b.projectHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.projectHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.projectHierarchy));
        };
        this.projectQualifiedName = b.projectQualifiedName;
        this.siteQualifiedName = b.siteQualifiedName;
        this.tableauDatasourceFieldBinSize = b.tableauDatasourceFieldBinSize;
        this.tableauDatasourceFieldDataCategory = b.tableauDatasourceFieldDataCategory;
        this.tableauDatasourceFieldDataType = b.tableauDatasourceFieldDataType;
        this.tableauDatasourceFieldFormula = b.tableauDatasourceFieldFormula;
        this.tableauDatasourceFieldRole = b.tableauDatasourceFieldRole;
        this.tableauWorksheetField = b.tableauWorksheetField;
        this.topLevelProjectQualifiedName = b.topLevelProjectQualifiedName;
        this.upstreamColumns = switch (b.upstreamColumns == null ? 0 : b.upstreamColumns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.upstreamColumns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamColumns));
        };
        this.upstreamFields = switch (b.upstreamFields == null ? 0 : b.upstreamFields.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.upstreamFields.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamFields));
        };
        this.upstreamTables = switch (b.upstreamTables == null ? 0 : b.upstreamTables.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.upstreamTables.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.upstreamTables));
        };
        this.workbookQualifiedName = b.workbookQualifiedName;
        SortedSet<ITableauWorksheet> worksheets = new TreeSet<ITableauWorksheet>();
        if (b.worksheets != null) {
            worksheets.addAll(b.worksheets);
        }
        worksheets = Collections.unmodifiableSortedSet(worksheets);
        this.worksheets = worksheets;
    }

    @Generated
    public static TableauDatasourceFieldBuilder<?, ?> _internal() {
        return new TableauDatasourceFieldBuilderImpl();
    }

    @Generated
    public TableauDatasourceFieldBuilder<?, ?> toBuilder() {
        return new TableauDatasourceFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public ITableauDatasource getDatasource() {
        return this.datasource;
    }

    @Override
    @Generated
    public String getDatasourceFieldType() {
        return this.datasourceFieldType;
    }

    @Override
    @Generated
    public String getDatasourceQualifiedName() {
        return this.datasourceQualifiedName;
    }

    @Override
    @Generated
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public List<Map<String, String>> getProjectHierarchy() {
        return this.projectHierarchy;
    }

    @Override
    @Generated
    public String getProjectQualifiedName() {
        return this.projectQualifiedName;
    }

    @Override
    @Generated
    public String getSiteQualifiedName() {
        return this.siteQualifiedName;
    }

    @Override
    @Generated
    public String getTableauDatasourceFieldBinSize() {
        return this.tableauDatasourceFieldBinSize;
    }

    @Override
    @Generated
    public String getTableauDatasourceFieldDataCategory() {
        return this.tableauDatasourceFieldDataCategory;
    }

    @Override
    @Generated
    public String getTableauDatasourceFieldDataType() {
        return this.tableauDatasourceFieldDataType;
    }

    @Override
    @Generated
    public String getTableauDatasourceFieldFormula() {
        return this.tableauDatasourceFieldFormula;
    }

    @Override
    @Generated
    public String getTableauDatasourceFieldRole() {
        return this.tableauDatasourceFieldRole;
    }

    @Override
    @Generated
    public ITableauWorksheetField getTableauWorksheetField() {
        return this.tableauWorksheetField;
    }

    @Override
    @Generated
    public String getTopLevelProjectQualifiedName() {
        return this.topLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public List<Map<String, String>> getUpstreamColumns() {
        return this.upstreamColumns;
    }

    @Override
    @Generated
    public List<Map<String, String>> getUpstreamFields() {
        return this.upstreamFields;
    }

    @Override
    @Generated
    public List<Map<String, String>> getUpstreamTables() {
        return this.upstreamTables;
    }

    @Override
    @Generated
    public String getWorkbookQualifiedName() {
        return this.workbookQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<ITableauWorksheet> getWorksheets() {
        return this.worksheets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauDatasourceField)) {
            return false;
        }
        TableauDatasourceField other = (TableauDatasourceField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        ITableauDatasource this$datasource = this.getDatasource();
        ITableauDatasource other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        String this$datasourceFieldType = this.getDatasourceFieldType();
        String other$datasourceFieldType = other.getDatasourceFieldType();
        if (this$datasourceFieldType == null ? other$datasourceFieldType != null : !this$datasourceFieldType.equals(other$datasourceFieldType)) {
            return false;
        }
        String this$datasourceQualifiedName = this.getDatasourceQualifiedName();
        String other$datasourceQualifiedName = other.getDatasourceQualifiedName();
        if (this$datasourceQualifiedName == null ? other$datasourceQualifiedName != null : !this$datasourceQualifiedName.equals(other$datasourceQualifiedName)) {
            return false;
        }
        String this$fullyQualifiedName = this.getFullyQualifiedName();
        String other$fullyQualifiedName = other.getFullyQualifiedName();
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        List<Map<String, String>> this$projectHierarchy = this.getProjectHierarchy();
        List<Map<String, String>> other$projectHierarchy = other.getProjectHierarchy();
        if (this$projectHierarchy == null ? other$projectHierarchy != null : !((Object)this$projectHierarchy).equals(other$projectHierarchy)) {
            return false;
        }
        String this$projectQualifiedName = this.getProjectQualifiedName();
        String other$projectQualifiedName = other.getProjectQualifiedName();
        if (this$projectQualifiedName == null ? other$projectQualifiedName != null : !this$projectQualifiedName.equals(other$projectQualifiedName)) {
            return false;
        }
        String this$siteQualifiedName = this.getSiteQualifiedName();
        String other$siteQualifiedName = other.getSiteQualifiedName();
        if (this$siteQualifiedName == null ? other$siteQualifiedName != null : !this$siteQualifiedName.equals(other$siteQualifiedName)) {
            return false;
        }
        String this$tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        String other$tableauDatasourceFieldBinSize = other.getTableauDatasourceFieldBinSize();
        if (this$tableauDatasourceFieldBinSize == null ? other$tableauDatasourceFieldBinSize != null : !this$tableauDatasourceFieldBinSize.equals(other$tableauDatasourceFieldBinSize)) {
            return false;
        }
        String this$tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        String other$tableauDatasourceFieldDataCategory = other.getTableauDatasourceFieldDataCategory();
        if (this$tableauDatasourceFieldDataCategory == null ? other$tableauDatasourceFieldDataCategory != null : !this$tableauDatasourceFieldDataCategory.equals(other$tableauDatasourceFieldDataCategory)) {
            return false;
        }
        String this$tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        String other$tableauDatasourceFieldDataType = other.getTableauDatasourceFieldDataType();
        if (this$tableauDatasourceFieldDataType == null ? other$tableauDatasourceFieldDataType != null : !this$tableauDatasourceFieldDataType.equals(other$tableauDatasourceFieldDataType)) {
            return false;
        }
        String this$tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        String other$tableauDatasourceFieldFormula = other.getTableauDatasourceFieldFormula();
        if (this$tableauDatasourceFieldFormula == null ? other$tableauDatasourceFieldFormula != null : !this$tableauDatasourceFieldFormula.equals(other$tableauDatasourceFieldFormula)) {
            return false;
        }
        String this$tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        String other$tableauDatasourceFieldRole = other.getTableauDatasourceFieldRole();
        if (this$tableauDatasourceFieldRole == null ? other$tableauDatasourceFieldRole != null : !this$tableauDatasourceFieldRole.equals(other$tableauDatasourceFieldRole)) {
            return false;
        }
        ITableauWorksheetField this$tableauWorksheetField = this.getTableauWorksheetField();
        ITableauWorksheetField other$tableauWorksheetField = other.getTableauWorksheetField();
        if (this$tableauWorksheetField == null ? other$tableauWorksheetField != null : !this$tableauWorksheetField.equals(other$tableauWorksheetField)) {
            return false;
        }
        String this$topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        String other$topLevelProjectQualifiedName = other.getTopLevelProjectQualifiedName();
        if (this$topLevelProjectQualifiedName == null ? other$topLevelProjectQualifiedName != null : !this$topLevelProjectQualifiedName.equals(other$topLevelProjectQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$upstreamColumns = this.getUpstreamColumns();
        List<Map<String, String>> other$upstreamColumns = other.getUpstreamColumns();
        if (this$upstreamColumns == null ? other$upstreamColumns != null : !((Object)this$upstreamColumns).equals(other$upstreamColumns)) {
            return false;
        }
        List<Map<String, String>> this$upstreamFields = this.getUpstreamFields();
        List<Map<String, String>> other$upstreamFields = other.getUpstreamFields();
        if (this$upstreamFields == null ? other$upstreamFields != null : !((Object)this$upstreamFields).equals(other$upstreamFields)) {
            return false;
        }
        List<Map<String, String>> this$upstreamTables = this.getUpstreamTables();
        List<Map<String, String>> other$upstreamTables = other.getUpstreamTables();
        if (this$upstreamTables == null ? other$upstreamTables != null : !((Object)this$upstreamTables).equals(other$upstreamTables)) {
            return false;
        }
        String this$workbookQualifiedName = this.getWorkbookQualifiedName();
        String other$workbookQualifiedName = other.getWorkbookQualifiedName();
        if (this$workbookQualifiedName == null ? other$workbookQualifiedName != null : !this$workbookQualifiedName.equals(other$workbookQualifiedName)) {
            return false;
        }
        SortedSet<ITableauWorksheet> this$worksheets = this.getWorksheets();
        SortedSet<ITableauWorksheet> other$worksheets = other.getWorksheets();
        return !(this$worksheets == null ? other$worksheets != null : !this$worksheets.equals(other$worksheets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauDatasourceField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        ITableauDatasource $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        String $datasourceFieldType = this.getDatasourceFieldType();
        result = result * 59 + ($datasourceFieldType == null ? 43 : $datasourceFieldType.hashCode());
        String $datasourceQualifiedName = this.getDatasourceQualifiedName();
        result = result * 59 + ($datasourceQualifiedName == null ? 43 : $datasourceQualifiedName.hashCode());
        String $fullyQualifiedName = this.getFullyQualifiedName();
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        List<Map<String, String>> $projectHierarchy = this.getProjectHierarchy();
        result = result * 59 + ($projectHierarchy == null ? 43 : ((Object)$projectHierarchy).hashCode());
        String $projectQualifiedName = this.getProjectQualifiedName();
        result = result * 59 + ($projectQualifiedName == null ? 43 : $projectQualifiedName.hashCode());
        String $siteQualifiedName = this.getSiteQualifiedName();
        result = result * 59 + ($siteQualifiedName == null ? 43 : $siteQualifiedName.hashCode());
        String $tableauDatasourceFieldBinSize = this.getTableauDatasourceFieldBinSize();
        result = result * 59 + ($tableauDatasourceFieldBinSize == null ? 43 : $tableauDatasourceFieldBinSize.hashCode());
        String $tableauDatasourceFieldDataCategory = this.getTableauDatasourceFieldDataCategory();
        result = result * 59 + ($tableauDatasourceFieldDataCategory == null ? 43 : $tableauDatasourceFieldDataCategory.hashCode());
        String $tableauDatasourceFieldDataType = this.getTableauDatasourceFieldDataType();
        result = result * 59 + ($tableauDatasourceFieldDataType == null ? 43 : $tableauDatasourceFieldDataType.hashCode());
        String $tableauDatasourceFieldFormula = this.getTableauDatasourceFieldFormula();
        result = result * 59 + ($tableauDatasourceFieldFormula == null ? 43 : $tableauDatasourceFieldFormula.hashCode());
        String $tableauDatasourceFieldRole = this.getTableauDatasourceFieldRole();
        result = result * 59 + ($tableauDatasourceFieldRole == null ? 43 : $tableauDatasourceFieldRole.hashCode());
        ITableauWorksheetField $tableauWorksheetField = this.getTableauWorksheetField();
        result = result * 59 + ($tableauWorksheetField == null ? 43 : $tableauWorksheetField.hashCode());
        String $topLevelProjectQualifiedName = this.getTopLevelProjectQualifiedName();
        result = result * 59 + ($topLevelProjectQualifiedName == null ? 43 : $topLevelProjectQualifiedName.hashCode());
        List<Map<String, String>> $upstreamColumns = this.getUpstreamColumns();
        result = result * 59 + ($upstreamColumns == null ? 43 : ((Object)$upstreamColumns).hashCode());
        List<Map<String, String>> $upstreamFields = this.getUpstreamFields();
        result = result * 59 + ($upstreamFields == null ? 43 : ((Object)$upstreamFields).hashCode());
        List<Map<String, String>> $upstreamTables = this.getUpstreamTables();
        result = result * 59 + ($upstreamTables == null ? 43 : ((Object)$upstreamTables).hashCode());
        String $workbookQualifiedName = this.getWorkbookQualifiedName();
        result = result * 59 + ($workbookQualifiedName == null ? 43 : $workbookQualifiedName.hashCode());
        SortedSet<ITableauWorksheet> $worksheets = this.getWorksheets();
        result = result * 59 + ($worksheets == null ? 43 : $worksheets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauDatasourceField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", datasource=" + String.valueOf(this.getDatasource()) + ", datasourceFieldType=" + this.getDatasourceFieldType() + ", datasourceQualifiedName=" + this.getDatasourceQualifiedName() + ", fullyQualifiedName=" + this.getFullyQualifiedName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", projectHierarchy=" + String.valueOf(this.getProjectHierarchy()) + ", projectQualifiedName=" + this.getProjectQualifiedName() + ", siteQualifiedName=" + this.getSiteQualifiedName() + ", tableauDatasourceFieldBinSize=" + this.getTableauDatasourceFieldBinSize() + ", tableauDatasourceFieldDataCategory=" + this.getTableauDatasourceFieldDataCategory() + ", tableauDatasourceFieldDataType=" + this.getTableauDatasourceFieldDataType() + ", tableauDatasourceFieldFormula=" + this.getTableauDatasourceFieldFormula() + ", tableauDatasourceFieldRole=" + this.getTableauDatasourceFieldRole() + ", tableauWorksheetField=" + String.valueOf(this.getTableauWorksheetField()) + ", topLevelProjectQualifiedName=" + this.getTopLevelProjectQualifiedName() + ", upstreamColumns=" + String.valueOf(this.getUpstreamColumns()) + ", upstreamFields=" + String.valueOf(this.getUpstreamFields()) + ", upstreamTables=" + String.valueOf(this.getUpstreamTables()) + ", workbookQualifiedName=" + this.getWorkbookQualifiedName() + ", worksheets=" + String.valueOf(this.getWorksheets()) + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class TableauDatasourceFieldBuilder<C extends TableauDatasourceField, B extends TableauDatasourceFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ITableauDatasource datasource;
        @Generated
        private String datasourceFieldType;
        @Generated
        private String datasourceQualifiedName;
        @Generated
        private String fullyQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<Map<String, String>> projectHierarchy;
        @Generated
        private String projectQualifiedName;
        @Generated
        private String siteQualifiedName;
        @Generated
        private String tableauDatasourceFieldBinSize;
        @Generated
        private String tableauDatasourceFieldDataCategory;
        @Generated
        private String tableauDatasourceFieldDataType;
        @Generated
        private String tableauDatasourceFieldFormula;
        @Generated
        private String tableauDatasourceFieldRole;
        @Generated
        private ITableauWorksheetField tableauWorksheetField;
        @Generated
        private String topLevelProjectQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> upstreamColumns;
        @Generated
        private ArrayList<Map<String, String>> upstreamFields;
        @Generated
        private ArrayList<Map<String, String>> upstreamTables;
        @Generated
        private String workbookQualifiedName;
        @Generated
        private ArrayList<ITableauWorksheet> worksheets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauDatasourceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauDatasourceField instance, TableauDatasourceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.datasource(instance.datasource);
            b.datasourceFieldType(instance.datasourceFieldType);
            b.datasourceQualifiedName(instance.datasourceQualifiedName);
            b.fullyQualifiedName(instance.fullyQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.projectHierarchy(instance.projectHierarchy == null ? Collections.emptyList() : instance.projectHierarchy);
            b.projectQualifiedName(instance.projectQualifiedName);
            b.siteQualifiedName(instance.siteQualifiedName);
            b.tableauDatasourceFieldBinSize(instance.tableauDatasourceFieldBinSize);
            b.tableauDatasourceFieldDataCategory(instance.tableauDatasourceFieldDataCategory);
            b.tableauDatasourceFieldDataType(instance.tableauDatasourceFieldDataType);
            b.tableauDatasourceFieldFormula(instance.tableauDatasourceFieldFormula);
            b.tableauDatasourceFieldRole(instance.tableauDatasourceFieldRole);
            b.tableauWorksheetField(instance.tableauWorksheetField);
            b.topLevelProjectQualifiedName(instance.topLevelProjectQualifiedName);
            b.upstreamColumns(instance.upstreamColumns == null ? Collections.emptyList() : instance.upstreamColumns);
            b.upstreamFields(instance.upstreamFields == null ? Collections.emptyList() : instance.upstreamFields);
            b.upstreamTables(instance.upstreamTables == null ? Collections.emptyList() : instance.upstreamTables);
            b.workbookQualifiedName(instance.workbookQualifiedName);
            b.worksheets(instance.worksheets == null ? Collections.emptySortedSet() : instance.worksheets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B datasource(ITableauDatasource datasource) {
            this.datasource = datasource;
            return (B)this.self();
        }

        @Generated
        public B datasourceFieldType(String datasourceFieldType) {
            this.datasourceFieldType = datasourceFieldType;
            return (B)this.self();
        }

        @Generated
        public B datasourceQualifiedName(String datasourceQualifiedName) {
            this.datasourceQualifiedName = datasourceQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B addProjectHierarchy(Map<String, String> addProjectHierarchy) {
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.add(addProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B projectHierarchy(Collection<? extends Map<String, String>> projectHierarchy) {
            if (projectHierarchy == null) {
                throw new NullPointerException("projectHierarchy cannot be null");
            }
            if (this.projectHierarchy == null) {
                this.projectHierarchy = new ArrayList();
            }
            this.projectHierarchy.addAll(projectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearProjectHierarchy() {
            if (this.projectHierarchy != null) {
                this.projectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B projectQualifiedName(String projectQualifiedName) {
            this.projectQualifiedName = projectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B siteQualifiedName(String siteQualifiedName) {
            this.siteQualifiedName = siteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldBinSize(String tableauDatasourceFieldBinSize) {
            this.tableauDatasourceFieldBinSize = tableauDatasourceFieldBinSize;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldDataCategory(String tableauDatasourceFieldDataCategory) {
            this.tableauDatasourceFieldDataCategory = tableauDatasourceFieldDataCategory;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldDataType(String tableauDatasourceFieldDataType) {
            this.tableauDatasourceFieldDataType = tableauDatasourceFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldFormula(String tableauDatasourceFieldFormula) {
            this.tableauDatasourceFieldFormula = tableauDatasourceFieldFormula;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceFieldRole(String tableauDatasourceFieldRole) {
            this.tableauDatasourceFieldRole = tableauDatasourceFieldRole;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetField(ITableauWorksheetField tableauWorksheetField) {
            this.tableauWorksheetField = tableauWorksheetField;
            return (B)this.self();
        }

        @Generated
        public B topLevelProjectQualifiedName(String topLevelProjectQualifiedName) {
            this.topLevelProjectQualifiedName = topLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B upstreamColumn(Map<String, String> upstreamColumn) {
            if (this.upstreamColumns == null) {
                this.upstreamColumns = new ArrayList();
            }
            this.upstreamColumns.add(upstreamColumn);
            return (B)this.self();
        }

        @Generated
        public B upstreamColumns(Collection<? extends Map<String, String>> upstreamColumns) {
            if (upstreamColumns == null) {
                throw new NullPointerException("upstreamColumns cannot be null");
            }
            if (this.upstreamColumns == null) {
                this.upstreamColumns = new ArrayList();
            }
            this.upstreamColumns.addAll(upstreamColumns);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamColumns() {
            if (this.upstreamColumns != null) {
                this.upstreamColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B upstreamField(Map<String, String> upstreamField) {
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.add(upstreamField);
            return (B)this.self();
        }

        @Generated
        public B upstreamFields(Collection<? extends Map<String, String>> upstreamFields) {
            if (upstreamFields == null) {
                throw new NullPointerException("upstreamFields cannot be null");
            }
            if (this.upstreamFields == null) {
                this.upstreamFields = new ArrayList();
            }
            this.upstreamFields.addAll(upstreamFields);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamFields() {
            if (this.upstreamFields != null) {
                this.upstreamFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B upstreamTable(Map<String, String> upstreamTable) {
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.add(upstreamTable);
            return (B)this.self();
        }

        @Generated
        public B upstreamTables(Collection<? extends Map<String, String>> upstreamTables) {
            if (upstreamTables == null) {
                throw new NullPointerException("upstreamTables cannot be null");
            }
            if (this.upstreamTables == null) {
                this.upstreamTables = new ArrayList();
            }
            this.upstreamTables.addAll(upstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearUpstreamTables() {
            if (this.upstreamTables != null) {
                this.upstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B workbookQualifiedName(String workbookQualifiedName) {
            this.workbookQualifiedName = workbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B worksheet(ITableauWorksheet worksheet) {
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.add(worksheet);
            return (B)this.self();
        }

        @Generated
        public B worksheets(Collection<? extends ITableauWorksheet> worksheets) {
            if (worksheets == null) {
                throw new NullPointerException("worksheets cannot be null");
            }
            if (this.worksheets == null) {
                this.worksheets = new ArrayList();
            }
            this.worksheets.addAll(worksheets);
            return (B)this.self();
        }

        @Generated
        public B clearWorksheets() {
            if (this.worksheets != null) {
                this.worksheets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TableauDatasourceField.TableauDatasourceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", datasource=" + String.valueOf(this.datasource) + ", datasourceFieldType=" + this.datasourceFieldType + ", datasourceQualifiedName=" + this.datasourceQualifiedName + ", fullyQualifiedName=" + this.fullyQualifiedName + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", projectHierarchy=" + String.valueOf(this.projectHierarchy) + ", projectQualifiedName=" + this.projectQualifiedName + ", siteQualifiedName=" + this.siteQualifiedName + ", tableauDatasourceFieldBinSize=" + this.tableauDatasourceFieldBinSize + ", tableauDatasourceFieldDataCategory=" + this.tableauDatasourceFieldDataCategory + ", tableauDatasourceFieldDataType=" + this.tableauDatasourceFieldDataType + ", tableauDatasourceFieldFormula=" + this.tableauDatasourceFieldFormula + ", tableauDatasourceFieldRole=" + this.tableauDatasourceFieldRole + ", tableauWorksheetField=" + String.valueOf(this.tableauWorksheetField) + ", topLevelProjectQualifiedName=" + this.topLevelProjectQualifiedName + ", upstreamColumns=" + String.valueOf(this.upstreamColumns) + ", upstreamFields=" + String.valueOf(this.upstreamFields) + ", upstreamTables=" + String.valueOf(this.upstreamTables) + ", workbookQualifiedName=" + this.workbookQualifiedName + ", worksheets=" + String.valueOf(this.worksheets) + ")";
        }
    }

    @Generated
    private static final class TableauDatasourceFieldBuilderImpl
    extends TableauDatasourceFieldBuilder<TableauDatasourceField, TableauDatasourceFieldBuilderImpl> {
        @Generated
        private TableauDatasourceFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauDatasourceFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauDatasourceField build() {
            return new TableauDatasourceField(this);
        }
    }
}

