/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IModelAttribute;
import com.atlan.model.assets.IModelEntity;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITableau;
import com.atlan.model.assets.ITableauCalculatedField;
import com.atlan.model.assets.ITableauDashboardField;
import com.atlan.model.assets.ITableauDatasourceField;
import com.atlan.model.assets.ITableauWorksheet;
import com.atlan.model.assets.ITableauWorksheetField;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.fields.AtlanField;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableauWorksheetField
extends Asset
implements ITableauWorksheetField,
ITableau,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableauWorksheetField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "TableauWorksheetField";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IModelAttribute> modelImplementedAttributes;
    @Attribute
    SortedSet<IModelEntity> modelImplementedEntities;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ITableauCalculatedField tableauCalculatedField;
    @Attribute
    ITableauDashboardField tableauDashboardField;
    @Attribute
    ITableauDatasourceField tableauDatasourceField;
    @Attribute
    String tableauFullyQualifiedName;
    @Attribute
    List<Map<String, String>> tableauProjectHierarchy;
    @Attribute
    String tableauProjectQualifiedName;
    @Attribute
    String tableauSiteQualifiedName;
    @Attribute
    String tableauTopLevelProjectQualifiedName;
    @Attribute
    String tableauWorkbookQualifiedName;
    @Attribute
    ITableauWorksheet tableauWorksheet;
    @Attribute
    String tableauWorksheetFieldBinSize;
    @Attribute
    String tableauWorksheetFieldDataCategory;
    @Attribute
    String tableauWorksheetFieldDataType;
    @Attribute
    String tableauWorksheetFieldFormula;
    @Attribute
    String tableauWorksheetFieldRole;
    @Attribute
    String tableauWorksheetFieldType;
    @Attribute
    List<Map<String, String>> tableauWorksheetFieldUpstreamColumns;
    @Attribute
    List<Map<String, String>> tableauWorksheetFieldUpstreamFields;
    @Attribute
    List<Map<String, String>> tableauWorksheetFieldUpstreamTables;
    @Attribute
    String tableauWorksheetQualifiedName;

    @Override
    public TableauWorksheetField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return TableauWorksheetField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return TableauWorksheetField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return TableauWorksheetField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return TableauWorksheetField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static TableauWorksheetField refByGuid(String guid) {
        return TableauWorksheetField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static TableauWorksheetField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((TableauWorksheetFieldBuilder)((TableauWorksheetFieldBuilder)TableauWorksheetField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static TableauWorksheetField refByQualifiedName(String qualifiedName) {
        return TableauWorksheetField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static TableauWorksheetField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((TableauWorksheetFieldBuilder)((TableauWorksheetFieldBuilder)TableauWorksheetField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static TableauWorksheetField get(AtlanClient client, String id) throws AtlanException {
        return TableauWorksheetField.get(client, id, false);
    }

    @JsonIgnore
    public static TableauWorksheetField get(AtlanClient client, String id, boolean includeAllRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeAllRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof TableauWorksheetField) {
                return (TableauWorksheetField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeAllRelationships);
        if (asset instanceof TableauWorksheetField) {
            return (TableauWorksheetField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    @JsonIgnore
    public static TableauWorksheetField get(AtlanClient client, String id, Collection<AtlanField> attributes) throws AtlanException {
        return TableauWorksheetField.get(client, id, attributes, Collections.emptyList());
    }

    @JsonIgnore
    public static TableauWorksheetField get(AtlanClient client, String id, Collection<AtlanField> attributes, Collection<AtlanField> attributesOnRelated) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauWorksheetField.select(client).where(GUID.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
            if (!asset.isPresent()) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset.get() instanceof TableauWorksheetField) {
                return (TableauWorksheetField)asset.get();
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Optional<Asset> asset = ((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)((FluentSearch.FluentSearchBuilder)TableauWorksheetField.select(client).where(QUALIFIED_NAME.eq(id))).includesOnResults(attributes)).includesOnRelations(attributesOnRelated)).includeRelationshipAttributes(true)).pageSize(1)).stream().findFirst();
        if (!asset.isPresent()) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
        }
        if (asset.get() instanceof TableauWorksheetField) {
            return (TableauWorksheetField)asset.get();
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static TableauWorksheetFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (TableauWorksheetFieldBuilder)((TableauWorksheetFieldBuilder)((TableauWorksheetFieldBuilder)TableauWorksheetField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public TableauWorksheetFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("qualifiedName", this.getQualifiedName());
        map.put("name", this.getName());
        TableauWorksheetField.validateRequired(TYPE_NAME, map);
        return TableauWorksheetField.updater(this.getQualifiedName(), this.getName());
    }

    public static TableauWorksheetField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheetField)Asset.removeDescription(client, TableauWorksheetField.updater(qualifiedName, name));
    }

    public static TableauWorksheetField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheetField)Asset.removeUserDescription(client, TableauWorksheetField.updater(qualifiedName, name));
    }

    public static TableauWorksheetField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheetField)Asset.removeOwners(client, TableauWorksheetField.updater(qualifiedName, name));
    }

    public static TableauWorksheetField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (TableauWorksheetField)Asset.updateCertificate(client, TableauWorksheetField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static TableauWorksheetField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheetField)Asset.removeCertificate(client, TableauWorksheetField.updater(qualifiedName, name));
    }

    public static TableauWorksheetField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (TableauWorksheetField)Asset.updateAnnouncement(client, TableauWorksheetField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static TableauWorksheetField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (TableauWorksheetField)Asset.removeAnnouncement(client, TableauWorksheetField.updater(qualifiedName, name));
    }

    public static TableauWorksheetField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheetField)Asset.replaceTerms(client, TableauWorksheetField.updater(qualifiedName, name), terms);
    }

    @Deprecated
    public static TableauWorksheetField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheetField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauWorksheetField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (TableauWorksheetField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    @Deprecated
    public static TableauWorksheetField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (TableauWorksheetField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    @Deprecated
    public static TableauWorksheetField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (TableauWorksheetField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    @Deprecated
    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected TableauWorksheetField(TableauWorksheetFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : TableauWorksheetField.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IModelAttribute> modelImplementedAttributes = new TreeSet<IModelAttribute>();
        if (b.modelImplementedAttributes != null) {
            modelImplementedAttributes.addAll(b.modelImplementedAttributes);
        }
        modelImplementedAttributes = Collections.unmodifiableSortedSet(modelImplementedAttributes);
        this.modelImplementedAttributes = modelImplementedAttributes;
        SortedSet<IModelEntity> modelImplementedEntities = new TreeSet<IModelEntity>();
        if (b.modelImplementedEntities != null) {
            modelImplementedEntities.addAll(b.modelImplementedEntities);
        }
        modelImplementedEntities = Collections.unmodifiableSortedSet(modelImplementedEntities);
        this.modelImplementedEntities = modelImplementedEntities;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.tableauCalculatedField = b.tableauCalculatedField;
        this.tableauDashboardField = b.tableauDashboardField;
        this.tableauDatasourceField = b.tableauDatasourceField;
        this.tableauFullyQualifiedName = b.tableauFullyQualifiedName;
        this.tableauProjectHierarchy = switch (b.tableauProjectHierarchy == null ? 0 : b.tableauProjectHierarchy.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauProjectHierarchy.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauProjectHierarchy));
        };
        this.tableauProjectQualifiedName = b.tableauProjectQualifiedName;
        this.tableauSiteQualifiedName = b.tableauSiteQualifiedName;
        this.tableauTopLevelProjectQualifiedName = b.tableauTopLevelProjectQualifiedName;
        this.tableauWorkbookQualifiedName = b.tableauWorkbookQualifiedName;
        this.tableauWorksheet = b.tableauWorksheet;
        this.tableauWorksheetFieldBinSize = b.tableauWorksheetFieldBinSize;
        this.tableauWorksheetFieldDataCategory = b.tableauWorksheetFieldDataCategory;
        this.tableauWorksheetFieldDataType = b.tableauWorksheetFieldDataType;
        this.tableauWorksheetFieldFormula = b.tableauWorksheetFieldFormula;
        this.tableauWorksheetFieldRole = b.tableauWorksheetFieldRole;
        this.tableauWorksheetFieldType = b.tableauWorksheetFieldType;
        this.tableauWorksheetFieldUpstreamColumns = switch (b.tableauWorksheetFieldUpstreamColumns == null ? 0 : b.tableauWorksheetFieldUpstreamColumns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauWorksheetFieldUpstreamColumns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauWorksheetFieldUpstreamColumns));
        };
        this.tableauWorksheetFieldUpstreamFields = switch (b.tableauWorksheetFieldUpstreamFields == null ? 0 : b.tableauWorksheetFieldUpstreamFields.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauWorksheetFieldUpstreamFields.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauWorksheetFieldUpstreamFields));
        };
        this.tableauWorksheetFieldUpstreamTables = switch (b.tableauWorksheetFieldUpstreamTables == null ? 0 : b.tableauWorksheetFieldUpstreamTables.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.tableauWorksheetFieldUpstreamTables.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.tableauWorksheetFieldUpstreamTables));
        };
        this.tableauWorksheetQualifiedName = b.tableauWorksheetQualifiedName;
    }

    @Generated
    public static TableauWorksheetFieldBuilder<?, ?> _internal() {
        return new TableauWorksheetFieldBuilderImpl();
    }

    @Generated
    public TableauWorksheetFieldBuilder<?, ?> toBuilder() {
        return new TableauWorksheetFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IModelAttribute> getModelImplementedAttributes() {
        return this.modelImplementedAttributes;
    }

    @Override
    @Generated
    public SortedSet<IModelEntity> getModelImplementedEntities() {
        return this.modelImplementedEntities;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ITableauCalculatedField getTableauCalculatedField() {
        return this.tableauCalculatedField;
    }

    @Override
    @Generated
    public ITableauDashboardField getTableauDashboardField() {
        return this.tableauDashboardField;
    }

    @Override
    @Generated
    public ITableauDatasourceField getTableauDatasourceField() {
        return this.tableauDatasourceField;
    }

    @Override
    @Generated
    public String getTableauFullyQualifiedName() {
        return this.tableauFullyQualifiedName;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauProjectHierarchy() {
        return this.tableauProjectHierarchy;
    }

    @Override
    @Generated
    public String getTableauProjectQualifiedName() {
        return this.tableauProjectQualifiedName;
    }

    @Override
    @Generated
    public String getTableauSiteQualifiedName() {
        return this.tableauSiteQualifiedName;
    }

    @Override
    @Generated
    public String getTableauTopLevelProjectQualifiedName() {
        return this.tableauTopLevelProjectQualifiedName;
    }

    @Override
    @Generated
    public String getTableauWorkbookQualifiedName() {
        return this.tableauWorkbookQualifiedName;
    }

    @Override
    @Generated
    public ITableauWorksheet getTableauWorksheet() {
        return this.tableauWorksheet;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldBinSize() {
        return this.tableauWorksheetFieldBinSize;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldDataCategory() {
        return this.tableauWorksheetFieldDataCategory;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldDataType() {
        return this.tableauWorksheetFieldDataType;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldFormula() {
        return this.tableauWorksheetFieldFormula;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldRole() {
        return this.tableauWorksheetFieldRole;
    }

    @Override
    @Generated
    public String getTableauWorksheetFieldType() {
        return this.tableauWorksheetFieldType;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauWorksheetFieldUpstreamColumns() {
        return this.tableauWorksheetFieldUpstreamColumns;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauWorksheetFieldUpstreamFields() {
        return this.tableauWorksheetFieldUpstreamFields;
    }

    @Override
    @Generated
    public List<Map<String, String>> getTableauWorksheetFieldUpstreamTables() {
        return this.tableauWorksheetFieldUpstreamTables;
    }

    @Override
    @Generated
    public String getTableauWorksheetQualifiedName() {
        return this.tableauWorksheetQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauWorksheetField)) {
            return false;
        }
        TableauWorksheetField other = (TableauWorksheetField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IModelAttribute> this$modelImplementedAttributes = this.getModelImplementedAttributes();
        SortedSet<IModelAttribute> other$modelImplementedAttributes = other.getModelImplementedAttributes();
        if (this$modelImplementedAttributes == null ? other$modelImplementedAttributes != null : !this$modelImplementedAttributes.equals(other$modelImplementedAttributes)) {
            return false;
        }
        SortedSet<IModelEntity> this$modelImplementedEntities = this.getModelImplementedEntities();
        SortedSet<IModelEntity> other$modelImplementedEntities = other.getModelImplementedEntities();
        if (this$modelImplementedEntities == null ? other$modelImplementedEntities != null : !this$modelImplementedEntities.equals(other$modelImplementedEntities)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ITableauCalculatedField this$tableauCalculatedField = this.getTableauCalculatedField();
        ITableauCalculatedField other$tableauCalculatedField = other.getTableauCalculatedField();
        if (this$tableauCalculatedField == null ? other$tableauCalculatedField != null : !this$tableauCalculatedField.equals(other$tableauCalculatedField)) {
            return false;
        }
        ITableauDashboardField this$tableauDashboardField = this.getTableauDashboardField();
        ITableauDashboardField other$tableauDashboardField = other.getTableauDashboardField();
        if (this$tableauDashboardField == null ? other$tableauDashboardField != null : !this$tableauDashboardField.equals(other$tableauDashboardField)) {
            return false;
        }
        ITableauDatasourceField this$tableauDatasourceField = this.getTableauDatasourceField();
        ITableauDatasourceField other$tableauDatasourceField = other.getTableauDatasourceField();
        if (this$tableauDatasourceField == null ? other$tableauDatasourceField != null : !this$tableauDatasourceField.equals(other$tableauDatasourceField)) {
            return false;
        }
        String this$tableauFullyQualifiedName = this.getTableauFullyQualifiedName();
        String other$tableauFullyQualifiedName = other.getTableauFullyQualifiedName();
        if (this$tableauFullyQualifiedName == null ? other$tableauFullyQualifiedName != null : !this$tableauFullyQualifiedName.equals(other$tableauFullyQualifiedName)) {
            return false;
        }
        List<Map<String, String>> this$tableauProjectHierarchy = this.getTableauProjectHierarchy();
        List<Map<String, String>> other$tableauProjectHierarchy = other.getTableauProjectHierarchy();
        if (this$tableauProjectHierarchy == null ? other$tableauProjectHierarchy != null : !((Object)this$tableauProjectHierarchy).equals(other$tableauProjectHierarchy)) {
            return false;
        }
        String this$tableauProjectQualifiedName = this.getTableauProjectQualifiedName();
        String other$tableauProjectQualifiedName = other.getTableauProjectQualifiedName();
        if (this$tableauProjectQualifiedName == null ? other$tableauProjectQualifiedName != null : !this$tableauProjectQualifiedName.equals(other$tableauProjectQualifiedName)) {
            return false;
        }
        String this$tableauSiteQualifiedName = this.getTableauSiteQualifiedName();
        String other$tableauSiteQualifiedName = other.getTableauSiteQualifiedName();
        if (this$tableauSiteQualifiedName == null ? other$tableauSiteQualifiedName != null : !this$tableauSiteQualifiedName.equals(other$tableauSiteQualifiedName)) {
            return false;
        }
        String this$tableauTopLevelProjectQualifiedName = this.getTableauTopLevelProjectQualifiedName();
        String other$tableauTopLevelProjectQualifiedName = other.getTableauTopLevelProjectQualifiedName();
        if (this$tableauTopLevelProjectQualifiedName == null ? other$tableauTopLevelProjectQualifiedName != null : !this$tableauTopLevelProjectQualifiedName.equals(other$tableauTopLevelProjectQualifiedName)) {
            return false;
        }
        String this$tableauWorkbookQualifiedName = this.getTableauWorkbookQualifiedName();
        String other$tableauWorkbookQualifiedName = other.getTableauWorkbookQualifiedName();
        if (this$tableauWorkbookQualifiedName == null ? other$tableauWorkbookQualifiedName != null : !this$tableauWorkbookQualifiedName.equals(other$tableauWorkbookQualifiedName)) {
            return false;
        }
        ITableauWorksheet this$tableauWorksheet = this.getTableauWorksheet();
        ITableauWorksheet other$tableauWorksheet = other.getTableauWorksheet();
        if (this$tableauWorksheet == null ? other$tableauWorksheet != null : !this$tableauWorksheet.equals(other$tableauWorksheet)) {
            return false;
        }
        String this$tableauWorksheetFieldBinSize = this.getTableauWorksheetFieldBinSize();
        String other$tableauWorksheetFieldBinSize = other.getTableauWorksheetFieldBinSize();
        if (this$tableauWorksheetFieldBinSize == null ? other$tableauWorksheetFieldBinSize != null : !this$tableauWorksheetFieldBinSize.equals(other$tableauWorksheetFieldBinSize)) {
            return false;
        }
        String this$tableauWorksheetFieldDataCategory = this.getTableauWorksheetFieldDataCategory();
        String other$tableauWorksheetFieldDataCategory = other.getTableauWorksheetFieldDataCategory();
        if (this$tableauWorksheetFieldDataCategory == null ? other$tableauWorksheetFieldDataCategory != null : !this$tableauWorksheetFieldDataCategory.equals(other$tableauWorksheetFieldDataCategory)) {
            return false;
        }
        String this$tableauWorksheetFieldDataType = this.getTableauWorksheetFieldDataType();
        String other$tableauWorksheetFieldDataType = other.getTableauWorksheetFieldDataType();
        if (this$tableauWorksheetFieldDataType == null ? other$tableauWorksheetFieldDataType != null : !this$tableauWorksheetFieldDataType.equals(other$tableauWorksheetFieldDataType)) {
            return false;
        }
        String this$tableauWorksheetFieldFormula = this.getTableauWorksheetFieldFormula();
        String other$tableauWorksheetFieldFormula = other.getTableauWorksheetFieldFormula();
        if (this$tableauWorksheetFieldFormula == null ? other$tableauWorksheetFieldFormula != null : !this$tableauWorksheetFieldFormula.equals(other$tableauWorksheetFieldFormula)) {
            return false;
        }
        String this$tableauWorksheetFieldRole = this.getTableauWorksheetFieldRole();
        String other$tableauWorksheetFieldRole = other.getTableauWorksheetFieldRole();
        if (this$tableauWorksheetFieldRole == null ? other$tableauWorksheetFieldRole != null : !this$tableauWorksheetFieldRole.equals(other$tableauWorksheetFieldRole)) {
            return false;
        }
        String this$tableauWorksheetFieldType = this.getTableauWorksheetFieldType();
        String other$tableauWorksheetFieldType = other.getTableauWorksheetFieldType();
        if (this$tableauWorksheetFieldType == null ? other$tableauWorksheetFieldType != null : !this$tableauWorksheetFieldType.equals(other$tableauWorksheetFieldType)) {
            return false;
        }
        List<Map<String, String>> this$tableauWorksheetFieldUpstreamColumns = this.getTableauWorksheetFieldUpstreamColumns();
        List<Map<String, String>> other$tableauWorksheetFieldUpstreamColumns = other.getTableauWorksheetFieldUpstreamColumns();
        if (this$tableauWorksheetFieldUpstreamColumns == null ? other$tableauWorksheetFieldUpstreamColumns != null : !((Object)this$tableauWorksheetFieldUpstreamColumns).equals(other$tableauWorksheetFieldUpstreamColumns)) {
            return false;
        }
        List<Map<String, String>> this$tableauWorksheetFieldUpstreamFields = this.getTableauWorksheetFieldUpstreamFields();
        List<Map<String, String>> other$tableauWorksheetFieldUpstreamFields = other.getTableauWorksheetFieldUpstreamFields();
        if (this$tableauWorksheetFieldUpstreamFields == null ? other$tableauWorksheetFieldUpstreamFields != null : !((Object)this$tableauWorksheetFieldUpstreamFields).equals(other$tableauWorksheetFieldUpstreamFields)) {
            return false;
        }
        List<Map<String, String>> this$tableauWorksheetFieldUpstreamTables = this.getTableauWorksheetFieldUpstreamTables();
        List<Map<String, String>> other$tableauWorksheetFieldUpstreamTables = other.getTableauWorksheetFieldUpstreamTables();
        if (this$tableauWorksheetFieldUpstreamTables == null ? other$tableauWorksheetFieldUpstreamTables != null : !((Object)this$tableauWorksheetFieldUpstreamTables).equals(other$tableauWorksheetFieldUpstreamTables)) {
            return false;
        }
        String this$tableauWorksheetQualifiedName = this.getTableauWorksheetQualifiedName();
        String other$tableauWorksheetQualifiedName = other.getTableauWorksheetQualifiedName();
        return !(this$tableauWorksheetQualifiedName == null ? other$tableauWorksheetQualifiedName != null : !this$tableauWorksheetQualifiedName.equals(other$tableauWorksheetQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableauWorksheetField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IModelAttribute> $modelImplementedAttributes = this.getModelImplementedAttributes();
        result = result * 59 + ($modelImplementedAttributes == null ? 43 : $modelImplementedAttributes.hashCode());
        SortedSet<IModelEntity> $modelImplementedEntities = this.getModelImplementedEntities();
        result = result * 59 + ($modelImplementedEntities == null ? 43 : $modelImplementedEntities.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ITableauCalculatedField $tableauCalculatedField = this.getTableauCalculatedField();
        result = result * 59 + ($tableauCalculatedField == null ? 43 : $tableauCalculatedField.hashCode());
        ITableauDashboardField $tableauDashboardField = this.getTableauDashboardField();
        result = result * 59 + ($tableauDashboardField == null ? 43 : $tableauDashboardField.hashCode());
        ITableauDatasourceField $tableauDatasourceField = this.getTableauDatasourceField();
        result = result * 59 + ($tableauDatasourceField == null ? 43 : $tableauDatasourceField.hashCode());
        String $tableauFullyQualifiedName = this.getTableauFullyQualifiedName();
        result = result * 59 + ($tableauFullyQualifiedName == null ? 43 : $tableauFullyQualifiedName.hashCode());
        List<Map<String, String>> $tableauProjectHierarchy = this.getTableauProjectHierarchy();
        result = result * 59 + ($tableauProjectHierarchy == null ? 43 : ((Object)$tableauProjectHierarchy).hashCode());
        String $tableauProjectQualifiedName = this.getTableauProjectQualifiedName();
        result = result * 59 + ($tableauProjectQualifiedName == null ? 43 : $tableauProjectQualifiedName.hashCode());
        String $tableauSiteQualifiedName = this.getTableauSiteQualifiedName();
        result = result * 59 + ($tableauSiteQualifiedName == null ? 43 : $tableauSiteQualifiedName.hashCode());
        String $tableauTopLevelProjectQualifiedName = this.getTableauTopLevelProjectQualifiedName();
        result = result * 59 + ($tableauTopLevelProjectQualifiedName == null ? 43 : $tableauTopLevelProjectQualifiedName.hashCode());
        String $tableauWorkbookQualifiedName = this.getTableauWorkbookQualifiedName();
        result = result * 59 + ($tableauWorkbookQualifiedName == null ? 43 : $tableauWorkbookQualifiedName.hashCode());
        ITableauWorksheet $tableauWorksheet = this.getTableauWorksheet();
        result = result * 59 + ($tableauWorksheet == null ? 43 : $tableauWorksheet.hashCode());
        String $tableauWorksheetFieldBinSize = this.getTableauWorksheetFieldBinSize();
        result = result * 59 + ($tableauWorksheetFieldBinSize == null ? 43 : $tableauWorksheetFieldBinSize.hashCode());
        String $tableauWorksheetFieldDataCategory = this.getTableauWorksheetFieldDataCategory();
        result = result * 59 + ($tableauWorksheetFieldDataCategory == null ? 43 : $tableauWorksheetFieldDataCategory.hashCode());
        String $tableauWorksheetFieldDataType = this.getTableauWorksheetFieldDataType();
        result = result * 59 + ($tableauWorksheetFieldDataType == null ? 43 : $tableauWorksheetFieldDataType.hashCode());
        String $tableauWorksheetFieldFormula = this.getTableauWorksheetFieldFormula();
        result = result * 59 + ($tableauWorksheetFieldFormula == null ? 43 : $tableauWorksheetFieldFormula.hashCode());
        String $tableauWorksheetFieldRole = this.getTableauWorksheetFieldRole();
        result = result * 59 + ($tableauWorksheetFieldRole == null ? 43 : $tableauWorksheetFieldRole.hashCode());
        String $tableauWorksheetFieldType = this.getTableauWorksheetFieldType();
        result = result * 59 + ($tableauWorksheetFieldType == null ? 43 : $tableauWorksheetFieldType.hashCode());
        List<Map<String, String>> $tableauWorksheetFieldUpstreamColumns = this.getTableauWorksheetFieldUpstreamColumns();
        result = result * 59 + ($tableauWorksheetFieldUpstreamColumns == null ? 43 : ((Object)$tableauWorksheetFieldUpstreamColumns).hashCode());
        List<Map<String, String>> $tableauWorksheetFieldUpstreamFields = this.getTableauWorksheetFieldUpstreamFields();
        result = result * 59 + ($tableauWorksheetFieldUpstreamFields == null ? 43 : ((Object)$tableauWorksheetFieldUpstreamFields).hashCode());
        List<Map<String, String>> $tableauWorksheetFieldUpstreamTables = this.getTableauWorksheetFieldUpstreamTables();
        result = result * 59 + ($tableauWorksheetFieldUpstreamTables == null ? 43 : ((Object)$tableauWorksheetFieldUpstreamTables).hashCode());
        String $tableauWorksheetQualifiedName = this.getTableauWorksheetQualifiedName();
        result = result * 59 + ($tableauWorksheetQualifiedName == null ? 43 : $tableauWorksheetQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TableauWorksheetField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + String.valueOf(this.getInputToAirflowTasks()) + ", inputToProcesses=" + String.valueOf(this.getInputToProcesses()) + ", inputToSparkJobs=" + String.valueOf(this.getInputToSparkJobs()) + ", modelImplementedAttributes=" + String.valueOf(this.getModelImplementedAttributes()) + ", modelImplementedEntities=" + String.valueOf(this.getModelImplementedEntities()) + ", outputFromAirflowTasks=" + String.valueOf(this.getOutputFromAirflowTasks()) + ", outputFromProcesses=" + String.valueOf(this.getOutputFromProcesses()) + ", outputFromSparkJobs=" + String.valueOf(this.getOutputFromSparkJobs()) + ", tableauCalculatedField=" + String.valueOf(this.getTableauCalculatedField()) + ", tableauDashboardField=" + String.valueOf(this.getTableauDashboardField()) + ", tableauDatasourceField=" + String.valueOf(this.getTableauDatasourceField()) + ", tableauFullyQualifiedName=" + this.getTableauFullyQualifiedName() + ", tableauProjectHierarchy=" + String.valueOf(this.getTableauProjectHierarchy()) + ", tableauProjectQualifiedName=" + this.getTableauProjectQualifiedName() + ", tableauSiteQualifiedName=" + this.getTableauSiteQualifiedName() + ", tableauTopLevelProjectQualifiedName=" + this.getTableauTopLevelProjectQualifiedName() + ", tableauWorkbookQualifiedName=" + this.getTableauWorkbookQualifiedName() + ", tableauWorksheet=" + String.valueOf(this.getTableauWorksheet()) + ", tableauWorksheetFieldBinSize=" + this.getTableauWorksheetFieldBinSize() + ", tableauWorksheetFieldDataCategory=" + this.getTableauWorksheetFieldDataCategory() + ", tableauWorksheetFieldDataType=" + this.getTableauWorksheetFieldDataType() + ", tableauWorksheetFieldFormula=" + this.getTableauWorksheetFieldFormula() + ", tableauWorksheetFieldRole=" + this.getTableauWorksheetFieldRole() + ", tableauWorksheetFieldType=" + this.getTableauWorksheetFieldType() + ", tableauWorksheetFieldUpstreamColumns=" + String.valueOf(this.getTableauWorksheetFieldUpstreamColumns()) + ", tableauWorksheetFieldUpstreamFields=" + String.valueOf(this.getTableauWorksheetFieldUpstreamFields()) + ", tableauWorksheetFieldUpstreamTables=" + String.valueOf(this.getTableauWorksheetFieldUpstreamTables()) + ", tableauWorksheetQualifiedName=" + this.getTableauWorksheetQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    public static abstract class TableauWorksheetFieldBuilder<C extends TableauWorksheetField, B extends TableauWorksheetFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IModelAttribute> modelImplementedAttributes;
        @Generated
        private ArrayList<IModelEntity> modelImplementedEntities;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ITableauCalculatedField tableauCalculatedField;
        @Generated
        private ITableauDashboardField tableauDashboardField;
        @Generated
        private ITableauDatasourceField tableauDatasourceField;
        @Generated
        private String tableauFullyQualifiedName;
        @Generated
        private ArrayList<Map<String, String>> tableauProjectHierarchy;
        @Generated
        private String tableauProjectQualifiedName;
        @Generated
        private String tableauSiteQualifiedName;
        @Generated
        private String tableauTopLevelProjectQualifiedName;
        @Generated
        private String tableauWorkbookQualifiedName;
        @Generated
        private ITableauWorksheet tableauWorksheet;
        @Generated
        private String tableauWorksheetFieldBinSize;
        @Generated
        private String tableauWorksheetFieldDataCategory;
        @Generated
        private String tableauWorksheetFieldDataType;
        @Generated
        private String tableauWorksheetFieldFormula;
        @Generated
        private String tableauWorksheetFieldRole;
        @Generated
        private String tableauWorksheetFieldType;
        @Generated
        private ArrayList<Map<String, String>> tableauWorksheetFieldUpstreamColumns;
        @Generated
        private ArrayList<Map<String, String>> tableauWorksheetFieldUpstreamFields;
        @Generated
        private ArrayList<Map<String, String>> tableauWorksheetFieldUpstreamTables;
        @Generated
        private String tableauWorksheetQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableauWorksheetFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TableauWorksheetField instance, TableauWorksheetFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.modelImplementedAttributes(instance.modelImplementedAttributes == null ? Collections.emptySortedSet() : instance.modelImplementedAttributes);
            b.modelImplementedEntities(instance.modelImplementedEntities == null ? Collections.emptySortedSet() : instance.modelImplementedEntities);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.tableauCalculatedField(instance.tableauCalculatedField);
            b.tableauDashboardField(instance.tableauDashboardField);
            b.tableauDatasourceField(instance.tableauDatasourceField);
            b.tableauFullyQualifiedName(instance.tableauFullyQualifiedName);
            b.tableauProjectHierarchy(instance.tableauProjectHierarchy == null ? Collections.emptyList() : instance.tableauProjectHierarchy);
            b.tableauProjectQualifiedName(instance.tableauProjectQualifiedName);
            b.tableauSiteQualifiedName(instance.tableauSiteQualifiedName);
            b.tableauTopLevelProjectQualifiedName(instance.tableauTopLevelProjectQualifiedName);
            b.tableauWorkbookQualifiedName(instance.tableauWorkbookQualifiedName);
            b.tableauWorksheet(instance.tableauWorksheet);
            b.tableauWorksheetFieldBinSize(instance.tableauWorksheetFieldBinSize);
            b.tableauWorksheetFieldDataCategory(instance.tableauWorksheetFieldDataCategory);
            b.tableauWorksheetFieldDataType(instance.tableauWorksheetFieldDataType);
            b.tableauWorksheetFieldFormula(instance.tableauWorksheetFieldFormula);
            b.tableauWorksheetFieldRole(instance.tableauWorksheetFieldRole);
            b.tableauWorksheetFieldType(instance.tableauWorksheetFieldType);
            b.tableauWorksheetFieldUpstreamColumns(instance.tableauWorksheetFieldUpstreamColumns == null ? Collections.emptyList() : instance.tableauWorksheetFieldUpstreamColumns);
            b.tableauWorksheetFieldUpstreamFields(instance.tableauWorksheetFieldUpstreamFields == null ? Collections.emptyList() : instance.tableauWorksheetFieldUpstreamFields);
            b.tableauWorksheetFieldUpstreamTables(instance.tableauWorksheetFieldUpstreamTables == null ? Collections.emptyList() : instance.tableauWorksheetFieldUpstreamTables);
            b.tableauWorksheetQualifiedName(instance.tableauWorksheetQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttribute(IModelAttribute modelImplementedAttribute) {
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.add(modelImplementedAttribute);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedAttributes(Collection<? extends IModelAttribute> modelImplementedAttributes) {
            if (modelImplementedAttributes == null) {
                throw new NullPointerException("modelImplementedAttributes cannot be null");
            }
            if (this.modelImplementedAttributes == null) {
                this.modelImplementedAttributes = new ArrayList();
            }
            this.modelImplementedAttributes.addAll(modelImplementedAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedAttributes() {
            if (this.modelImplementedAttributes != null) {
                this.modelImplementedAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntity(IModelEntity modelImplementedEntity) {
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.add(modelImplementedEntity);
            return (B)this.self();
        }

        @Generated
        public B modelImplementedEntities(Collection<? extends IModelEntity> modelImplementedEntities) {
            if (modelImplementedEntities == null) {
                throw new NullPointerException("modelImplementedEntities cannot be null");
            }
            if (this.modelImplementedEntities == null) {
                this.modelImplementedEntities = new ArrayList();
            }
            this.modelImplementedEntities.addAll(modelImplementedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearModelImplementedEntities() {
            if (this.modelImplementedEntities != null) {
                this.modelImplementedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauCalculatedField(ITableauCalculatedField tableauCalculatedField) {
            this.tableauCalculatedField = tableauCalculatedField;
            return (B)this.self();
        }

        @Generated
        public B tableauDashboardField(ITableauDashboardField tableauDashboardField) {
            this.tableauDashboardField = tableauDashboardField;
            return (B)this.self();
        }

        @Generated
        public B tableauDatasourceField(ITableauDatasourceField tableauDatasourceField) {
            this.tableauDatasourceField = tableauDatasourceField;
            return (B)this.self();
        }

        @Generated
        public B tableauFullyQualifiedName(String tableauFullyQualifiedName) {
            this.tableauFullyQualifiedName = tableauFullyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B addTableauProjectHierarchy(Map<String, String> addTableauProjectHierarchy) {
            if (this.tableauProjectHierarchy == null) {
                this.tableauProjectHierarchy = new ArrayList();
            }
            this.tableauProjectHierarchy.add(addTableauProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B tableauProjectHierarchy(Collection<? extends Map<String, String>> tableauProjectHierarchy) {
            if (tableauProjectHierarchy == null) {
                throw new NullPointerException("tableauProjectHierarchy cannot be null");
            }
            if (this.tableauProjectHierarchy == null) {
                this.tableauProjectHierarchy = new ArrayList();
            }
            this.tableauProjectHierarchy.addAll(tableauProjectHierarchy);
            return (B)this.self();
        }

        @Generated
        public B clearTableauProjectHierarchy() {
            if (this.tableauProjectHierarchy != null) {
                this.tableauProjectHierarchy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauProjectQualifiedName(String tableauProjectQualifiedName) {
            this.tableauProjectQualifiedName = tableauProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauSiteQualifiedName(String tableauSiteQualifiedName) {
            this.tableauSiteQualifiedName = tableauSiteQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauTopLevelProjectQualifiedName(String tableauTopLevelProjectQualifiedName) {
            this.tableauTopLevelProjectQualifiedName = tableauTopLevelProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauWorkbookQualifiedName(String tableauWorkbookQualifiedName) {
            this.tableauWorkbookQualifiedName = tableauWorkbookQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheet(ITableauWorksheet tableauWorksheet) {
            this.tableauWorksheet = tableauWorksheet;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldBinSize(String tableauWorksheetFieldBinSize) {
            this.tableauWorksheetFieldBinSize = tableauWorksheetFieldBinSize;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldDataCategory(String tableauWorksheetFieldDataCategory) {
            this.tableauWorksheetFieldDataCategory = tableauWorksheetFieldDataCategory;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldDataType(String tableauWorksheetFieldDataType) {
            this.tableauWorksheetFieldDataType = tableauWorksheetFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldFormula(String tableauWorksheetFieldFormula) {
            this.tableauWorksheetFieldFormula = tableauWorksheetFieldFormula;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldRole(String tableauWorksheetFieldRole) {
            this.tableauWorksheetFieldRole = tableauWorksheetFieldRole;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldType(String tableauWorksheetFieldType) {
            this.tableauWorksheetFieldType = tableauWorksheetFieldType;
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamColumn(Map<String, String> tableauWorksheetFieldUpstreamColumn) {
            if (this.tableauWorksheetFieldUpstreamColumns == null) {
                this.tableauWorksheetFieldUpstreamColumns = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamColumns.add(tableauWorksheetFieldUpstreamColumn);
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamColumns(Collection<? extends Map<String, String>> tableauWorksheetFieldUpstreamColumns) {
            if (tableauWorksheetFieldUpstreamColumns == null) {
                throw new NullPointerException("tableauWorksheetFieldUpstreamColumns cannot be null");
            }
            if (this.tableauWorksheetFieldUpstreamColumns == null) {
                this.tableauWorksheetFieldUpstreamColumns = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamColumns.addAll(tableauWorksheetFieldUpstreamColumns);
            return (B)this.self();
        }

        @Generated
        public B clearTableauWorksheetFieldUpstreamColumns() {
            if (this.tableauWorksheetFieldUpstreamColumns != null) {
                this.tableauWorksheetFieldUpstreamColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamField(Map<String, String> tableauWorksheetFieldUpstreamField) {
            if (this.tableauWorksheetFieldUpstreamFields == null) {
                this.tableauWorksheetFieldUpstreamFields = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamFields.add(tableauWorksheetFieldUpstreamField);
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamFields(Collection<? extends Map<String, String>> tableauWorksheetFieldUpstreamFields) {
            if (tableauWorksheetFieldUpstreamFields == null) {
                throw new NullPointerException("tableauWorksheetFieldUpstreamFields cannot be null");
            }
            if (this.tableauWorksheetFieldUpstreamFields == null) {
                this.tableauWorksheetFieldUpstreamFields = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamFields.addAll(tableauWorksheetFieldUpstreamFields);
            return (B)this.self();
        }

        @Generated
        public B clearTableauWorksheetFieldUpstreamFields() {
            if (this.tableauWorksheetFieldUpstreamFields != null) {
                this.tableauWorksheetFieldUpstreamFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamTable(Map<String, String> tableauWorksheetFieldUpstreamTable) {
            if (this.tableauWorksheetFieldUpstreamTables == null) {
                this.tableauWorksheetFieldUpstreamTables = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamTables.add(tableauWorksheetFieldUpstreamTable);
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetFieldUpstreamTables(Collection<? extends Map<String, String>> tableauWorksheetFieldUpstreamTables) {
            if (tableauWorksheetFieldUpstreamTables == null) {
                throw new NullPointerException("tableauWorksheetFieldUpstreamTables cannot be null");
            }
            if (this.tableauWorksheetFieldUpstreamTables == null) {
                this.tableauWorksheetFieldUpstreamTables = new ArrayList();
            }
            this.tableauWorksheetFieldUpstreamTables.addAll(tableauWorksheetFieldUpstreamTables);
            return (B)this.self();
        }

        @Generated
        public B clearTableauWorksheetFieldUpstreamTables() {
            if (this.tableauWorksheetFieldUpstreamTables != null) {
                this.tableauWorksheetFieldUpstreamTables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableauWorksheetQualifiedName(String tableauWorksheetQualifiedName) {
            this.tableauWorksheetQualifiedName = tableauWorksheetQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TableauWorksheetField.TableauWorksheetFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + String.valueOf(this.inputToAirflowTasks) + ", inputToProcesses=" + String.valueOf(this.inputToProcesses) + ", inputToSparkJobs=" + String.valueOf(this.inputToSparkJobs) + ", modelImplementedAttributes=" + String.valueOf(this.modelImplementedAttributes) + ", modelImplementedEntities=" + String.valueOf(this.modelImplementedEntities) + ", outputFromAirflowTasks=" + String.valueOf(this.outputFromAirflowTasks) + ", outputFromProcesses=" + String.valueOf(this.outputFromProcesses) + ", outputFromSparkJobs=" + String.valueOf(this.outputFromSparkJobs) + ", tableauCalculatedField=" + String.valueOf(this.tableauCalculatedField) + ", tableauDashboardField=" + String.valueOf(this.tableauDashboardField) + ", tableauDatasourceField=" + String.valueOf(this.tableauDatasourceField) + ", tableauFullyQualifiedName=" + this.tableauFullyQualifiedName + ", tableauProjectHierarchy=" + String.valueOf(this.tableauProjectHierarchy) + ", tableauProjectQualifiedName=" + this.tableauProjectQualifiedName + ", tableauSiteQualifiedName=" + this.tableauSiteQualifiedName + ", tableauTopLevelProjectQualifiedName=" + this.tableauTopLevelProjectQualifiedName + ", tableauWorkbookQualifiedName=" + this.tableauWorkbookQualifiedName + ", tableauWorksheet=" + String.valueOf(this.tableauWorksheet) + ", tableauWorksheetFieldBinSize=" + this.tableauWorksheetFieldBinSize + ", tableauWorksheetFieldDataCategory=" + this.tableauWorksheetFieldDataCategory + ", tableauWorksheetFieldDataType=" + this.tableauWorksheetFieldDataType + ", tableauWorksheetFieldFormula=" + this.tableauWorksheetFieldFormula + ", tableauWorksheetFieldRole=" + this.tableauWorksheetFieldRole + ", tableauWorksheetFieldType=" + this.tableauWorksheetFieldType + ", tableauWorksheetFieldUpstreamColumns=" + String.valueOf(this.tableauWorksheetFieldUpstreamColumns) + ", tableauWorksheetFieldUpstreamFields=" + String.valueOf(this.tableauWorksheetFieldUpstreamFields) + ", tableauWorksheetFieldUpstreamTables=" + String.valueOf(this.tableauWorksheetFieldUpstreamTables) + ", tableauWorksheetQualifiedName=" + this.tableauWorksheetQualifiedName + ")";
        }
    }

    @Generated
    private static final class TableauWorksheetFieldBuilderImpl
    extends TableauWorksheetFieldBuilder<TableauWorksheetField, TableauWorksheetFieldBuilderImpl> {
        @Generated
        private TableauWorksheetFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected TableauWorksheetFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TableauWorksheetField build() {
            return new TableauWorksheetField(this);
        }
    }
}

