/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.search.AuditDetail;
import com.atlan.model.structs.SourceTagAttachment;
import com.atlan.serde.AtlanTagDeserializer;
import com.atlan.serde.AtlanTagSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(using=AtlanTagDeserializer.class)
@JsonSerialize(using=AtlanTagSerializer.class)
public class AtlanTag
extends AtlanObject
implements AuditDetail,
Comparable<AtlanTag> {
    private static final long serialVersionUID = 2L;
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AtlanTag> atlanTagComparator = Comparator.comparing(AtlanTag::getTypeName, stringComparator).thenComparing(AtlanTag::getEntityGuid, stringComparator).thenComparing(st -> st.getSourceTagAttachments().stream().map(SourceTagAttachment::getSourceTagGuid).toList().toString(), stringComparator);
    @JsonIgnore
    transient Reference.SaveSemantic semantic;
    String typeName;
    String entityGuid;
    AtlanStatus entityStatus;
    Boolean propagate;
    Boolean removePropagationsOnEntityDelete;
    Boolean restrictPropagationThroughLineage;
    Boolean restrictPropagationThroughHierarchy;
    List<SourceTagAttachment> sourceTagAttachments;

    public static AtlanTag of(String atlanTagName) {
        return AtlanTag.of(atlanTagName, (String)null);
    }

    public static AtlanTag of(String atlanTagName, Reference.SaveSemantic semantic) {
        return AtlanTag.of(atlanTagName, semantic, (String)null);
    }

    public static AtlanTag of(String atlanTagName, SourceTagAttachment sta) {
        return AtlanTag.of(atlanTagName, (String)null, sta);
    }

    public static AtlanTag of(String atlanTagName, Reference.SaveSemantic semantic, SourceTagAttachment sta) {
        return AtlanTag.of(atlanTagName, semantic, null, sta);
    }

    public static AtlanTag of(String atlanTagName, String entityGuid) {
        return AtlanTag.of(atlanTagName, Reference.SaveSemantic.REPLACE, entityGuid);
    }

    public static AtlanTag of(String atlanTagName, Reference.SaveSemantic semantic, String entityGuid) {
        return AtlanTag.of(atlanTagName, semantic, entityGuid, null);
    }

    public static AtlanTag of(String atlanTagName, String entityGuid, SourceTagAttachment sta) {
        return AtlanTag.of(atlanTagName, Reference.SaveSemantic.REPLACE, entityGuid, sta);
    }

    public static AtlanTag of(String atlanTagName, Reference.SaveSemantic semantic, String entityGuid, SourceTagAttachment sta) {
        Object builder = ((AtlanTagBuilder)AtlanTag.builder().typeName(atlanTagName)).semantic(semantic);
        if (entityGuid != null) {
            ((AtlanTagBuilder)((AtlanTagBuilder)builder).entityGuid(entityGuid)).entityStatus(AtlanStatus.ACTIVE);
        }
        if (sta != null) {
            ((AtlanTagBuilder)builder).sourceTagAttachment(sta);
        }
        return ((AtlanTagBuilder)builder).build();
    }

    public AtlanTag() {
    }

    @Override
    public int compareTo(AtlanTag o) {
        if (o == null) {
            return -1;
        }
        return atlanTagComparator.compare(this, o);
    }

    @Generated
    private static Reference.SaveSemantic $default$semantic() {
        return Reference.SaveSemantic.REPLACE;
    }

    @Generated
    private static Boolean $default$propagate() {
        return false;
    }

    @Generated
    private static Boolean $default$removePropagationsOnEntityDelete() {
        return true;
    }

    @Generated
    private static Boolean $default$restrictPropagationThroughLineage() {
        return false;
    }

    @Generated
    private static Boolean $default$restrictPropagationThroughHierarchy() {
        return false;
    }

    @Generated
    protected AtlanTag(AtlanTagBuilder<?, ?> b) {
        super(b);
        this.semantic = b.semantic$set ? b.semantic$value : AtlanTag.$default$semantic();
        this.typeName = b.typeName;
        this.entityGuid = b.entityGuid;
        this.entityStatus = b.entityStatus;
        this.propagate = b.propagate$set ? b.propagate$value : AtlanTag.$default$propagate();
        this.removePropagationsOnEntityDelete = b.removePropagationsOnEntityDelete$set ? b.removePropagationsOnEntityDelete$value : AtlanTag.$default$removePropagationsOnEntityDelete();
        this.restrictPropagationThroughLineage = b.restrictPropagationThroughLineage$set ? b.restrictPropagationThroughLineage$value : AtlanTag.$default$restrictPropagationThroughLineage();
        this.restrictPropagationThroughHierarchy = b.restrictPropagationThroughHierarchy$set ? b.restrictPropagationThroughHierarchy$value : AtlanTag.$default$restrictPropagationThroughHierarchy();
        this.sourceTagAttachments = switch (b.sourceTagAttachments == null ? 0 : b.sourceTagAttachments.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.sourceTagAttachments.get(0));
            default -> Collections.unmodifiableList(new ArrayList<SourceTagAttachment>(b.sourceTagAttachments));
        };
    }

    @Generated
    public static AtlanTagBuilder<?, ?> builder() {
        return new AtlanTagBuilderImpl();
    }

    @Generated
    public AtlanTagBuilder<?, ?> toBuilder() {
        return new AtlanTagBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Reference.SaveSemantic getSemantic() {
        return this.semantic;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getEntityGuid() {
        return this.entityGuid;
    }

    @Generated
    public AtlanStatus getEntityStatus() {
        return this.entityStatus;
    }

    @Generated
    public Boolean getPropagate() {
        return this.propagate;
    }

    @Generated
    public Boolean getRemovePropagationsOnEntityDelete() {
        return this.removePropagationsOnEntityDelete;
    }

    @Generated
    public Boolean getRestrictPropagationThroughLineage() {
        return this.restrictPropagationThroughLineage;
    }

    @Generated
    public Boolean getRestrictPropagationThroughHierarchy() {
        return this.restrictPropagationThroughHierarchy;
    }

    @Generated
    public List<SourceTagAttachment> getSourceTagAttachments() {
        return this.sourceTagAttachments;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanTag)) {
            return false;
        }
        AtlanTag other = (AtlanTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$propagate = this.getPropagate();
        Boolean other$propagate = other.getPropagate();
        if (this$propagate == null ? other$propagate != null : !((Object)this$propagate).equals(other$propagate)) {
            return false;
        }
        Boolean this$removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        Boolean other$removePropagationsOnEntityDelete = other.getRemovePropagationsOnEntityDelete();
        if (this$removePropagationsOnEntityDelete == null ? other$removePropagationsOnEntityDelete != null : !((Object)this$removePropagationsOnEntityDelete).equals(other$removePropagationsOnEntityDelete)) {
            return false;
        }
        Boolean this$restrictPropagationThroughLineage = this.getRestrictPropagationThroughLineage();
        Boolean other$restrictPropagationThroughLineage = other.getRestrictPropagationThroughLineage();
        if (this$restrictPropagationThroughLineage == null ? other$restrictPropagationThroughLineage != null : !((Object)this$restrictPropagationThroughLineage).equals(other$restrictPropagationThroughLineage)) {
            return false;
        }
        Boolean this$restrictPropagationThroughHierarchy = this.getRestrictPropagationThroughHierarchy();
        Boolean other$restrictPropagationThroughHierarchy = other.getRestrictPropagationThroughHierarchy();
        if (this$restrictPropagationThroughHierarchy == null ? other$restrictPropagationThroughHierarchy != null : !((Object)this$restrictPropagationThroughHierarchy).equals(other$restrictPropagationThroughHierarchy)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$entityGuid = this.getEntityGuid();
        String other$entityGuid = other.getEntityGuid();
        if (this$entityGuid == null ? other$entityGuid != null : !this$entityGuid.equals(other$entityGuid)) {
            return false;
        }
        AtlanStatus this$entityStatus = this.getEntityStatus();
        AtlanStatus other$entityStatus = other.getEntityStatus();
        if (this$entityStatus == null ? other$entityStatus != null : !this$entityStatus.equals(other$entityStatus)) {
            return false;
        }
        List<SourceTagAttachment> this$sourceTagAttachments = this.getSourceTagAttachments();
        List<SourceTagAttachment> other$sourceTagAttachments = other.getSourceTagAttachments();
        return !(this$sourceTagAttachments == null ? other$sourceTagAttachments != null : !((Object)this$sourceTagAttachments).equals(other$sourceTagAttachments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $propagate = this.getPropagate();
        result = result * 59 + ($propagate == null ? 43 : ((Object)$propagate).hashCode());
        Boolean $removePropagationsOnEntityDelete = this.getRemovePropagationsOnEntityDelete();
        result = result * 59 + ($removePropagationsOnEntityDelete == null ? 43 : ((Object)$removePropagationsOnEntityDelete).hashCode());
        Boolean $restrictPropagationThroughLineage = this.getRestrictPropagationThroughLineage();
        result = result * 59 + ($restrictPropagationThroughLineage == null ? 43 : ((Object)$restrictPropagationThroughLineage).hashCode());
        Boolean $restrictPropagationThroughHierarchy = this.getRestrictPropagationThroughHierarchy();
        result = result * 59 + ($restrictPropagationThroughHierarchy == null ? 43 : ((Object)$restrictPropagationThroughHierarchy).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $entityGuid = this.getEntityGuid();
        result = result * 59 + ($entityGuid == null ? 43 : $entityGuid.hashCode());
        AtlanStatus $entityStatus = this.getEntityStatus();
        result = result * 59 + ($entityStatus == null ? 43 : $entityStatus.hashCode());
        List<SourceTagAttachment> $sourceTagAttachments = this.getSourceTagAttachments();
        result = result * 59 + ($sourceTagAttachments == null ? 43 : ((Object)$sourceTagAttachments).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanTag(super=" + super.toString() + ", semantic=" + String.valueOf((Object)this.getSemantic()) + ", typeName=" + this.getTypeName() + ", entityGuid=" + this.getEntityGuid() + ", entityStatus=" + String.valueOf(this.getEntityStatus()) + ", propagate=" + this.getPropagate() + ", removePropagationsOnEntityDelete=" + this.getRemovePropagationsOnEntityDelete() + ", restrictPropagationThroughLineage=" + this.getRestrictPropagationThroughLineage() + ", restrictPropagationThroughHierarchy=" + this.getRestrictPropagationThroughHierarchy() + ", sourceTagAttachments=" + String.valueOf(this.getSourceTagAttachments()) + ")";
    }

    public static abstract class AtlanTagBuilder<C extends AtlanTag, B extends AtlanTagBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private boolean semantic$set;
        @Generated
        private Reference.SaveSemantic semantic$value;
        @Generated
        private String typeName;
        @Generated
        private String entityGuid;
        @Generated
        private AtlanStatus entityStatus;
        @Generated
        private boolean propagate$set;
        @Generated
        private Boolean propagate$value;
        @Generated
        private boolean removePropagationsOnEntityDelete$set;
        @Generated
        private Boolean removePropagationsOnEntityDelete$value;
        @Generated
        private boolean restrictPropagationThroughLineage$set;
        @Generated
        private Boolean restrictPropagationThroughLineage$value;
        @Generated
        private boolean restrictPropagationThroughHierarchy$set;
        @Generated
        private Boolean restrictPropagationThroughHierarchy$value;
        @Generated
        private ArrayList<SourceTagAttachment> sourceTagAttachments;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanTag instance, AtlanTagBuilder<?, ?> b) {
            b.semantic(instance.semantic);
            b.typeName(instance.typeName);
            b.entityGuid(instance.entityGuid);
            b.entityStatus(instance.entityStatus);
            b.propagate(instance.propagate);
            b.removePropagationsOnEntityDelete(instance.removePropagationsOnEntityDelete);
            b.restrictPropagationThroughLineage(instance.restrictPropagationThroughLineage);
            b.restrictPropagationThroughHierarchy(instance.restrictPropagationThroughHierarchy);
            b.sourceTagAttachments(instance.sourceTagAttachments == null ? Collections.emptyList() : instance.sourceTagAttachments);
        }

        @JsonIgnore
        @Generated
        public B semantic(Reference.SaveSemantic semantic) {
            this.semantic$value = semantic;
            this.semantic$set = true;
            return (B)this.self();
        }

        @Generated
        public B typeName(String typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        @Generated
        public B entityGuid(String entityGuid) {
            this.entityGuid = entityGuid;
            return (B)this.self();
        }

        @Generated
        public B entityStatus(AtlanStatus entityStatus) {
            this.entityStatus = entityStatus;
            return (B)this.self();
        }

        @Generated
        public B propagate(Boolean propagate) {
            this.propagate$value = propagate;
            this.propagate$set = true;
            return (B)this.self();
        }

        @Generated
        public B removePropagationsOnEntityDelete(Boolean removePropagationsOnEntityDelete) {
            this.removePropagationsOnEntityDelete$value = removePropagationsOnEntityDelete;
            this.removePropagationsOnEntityDelete$set = true;
            return (B)this.self();
        }

        @Generated
        public B restrictPropagationThroughLineage(Boolean restrictPropagationThroughLineage) {
            this.restrictPropagationThroughLineage$value = restrictPropagationThroughLineage;
            this.restrictPropagationThroughLineage$set = true;
            return (B)this.self();
        }

        @Generated
        public B restrictPropagationThroughHierarchy(Boolean restrictPropagationThroughHierarchy) {
            this.restrictPropagationThroughHierarchy$value = restrictPropagationThroughHierarchy;
            this.restrictPropagationThroughHierarchy$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceTagAttachment(SourceTagAttachment sourceTagAttachment) {
            if (this.sourceTagAttachments == null) {
                this.sourceTagAttachments = new ArrayList();
            }
            this.sourceTagAttachments.add(sourceTagAttachment);
            return (B)this.self();
        }

        @Generated
        public B sourceTagAttachments(Collection<? extends SourceTagAttachment> sourceTagAttachments) {
            if (sourceTagAttachments == null) {
                throw new NullPointerException("sourceTagAttachments cannot be null");
            }
            if (this.sourceTagAttachments == null) {
                this.sourceTagAttachments = new ArrayList();
            }
            this.sourceTagAttachments.addAll(sourceTagAttachments);
            return (B)this.self();
        }

        @Generated
        public B clearSourceTagAttachments() {
            if (this.sourceTagAttachments != null) {
                this.sourceTagAttachments.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanTag.AtlanTagBuilder(super=" + super.toString() + ", semantic$value=" + String.valueOf((Object)this.semantic$value) + ", typeName=" + this.typeName + ", entityGuid=" + this.entityGuid + ", entityStatus=" + String.valueOf(this.entityStatus) + ", propagate$value=" + this.propagate$value + ", removePropagationsOnEntityDelete$value=" + this.removePropagationsOnEntityDelete$value + ", restrictPropagationThroughLineage$value=" + this.restrictPropagationThroughLineage$value + ", restrictPropagationThroughHierarchy$value=" + this.restrictPropagationThroughHierarchy$value + ", sourceTagAttachments=" + String.valueOf(this.sourceTagAttachments) + ")";
        }
    }

    @Generated
    private static final class AtlanTagBuilderImpl
    extends AtlanTagBuilder<AtlanTag, AtlanTagBuilderImpl> {
        @Generated
        private AtlanTagBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanTagBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanTag build() {
            return new AtlanTag(this);
        }
    }
}

