/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ConfluentKafkaCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.KAFKA_CONFLUENT_CLOUD.getValue();

    public static ConfluentKafkaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return ConfluentKafkaCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static ConfluentKafkaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)ConfluentKafkaCrawler._internal().setup(PREFIX, "@atlan/kafka-confluent-cloud", client, ConfluentKafkaCrawler.getConnection(client, connectionName, AtlanConnectorType.CONFLUENT_KAFKA, adminRoles, adminGroups, adminUsers, false, false, 0L, "https://cdn.confluent.io/wp-content/uploads/apache-kafka-icon-2021-e1638496305992.jpg"))).include(null)).exclude(null)).skipInternal(true);
    }

    @Generated
    protected ConfluentKafkaCrawler(ConfluentKafkaCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static ConfluentKafkaCrawlerBuilder<?, ?> _internal() {
        return new ConfluentKafkaCrawlerBuilderImpl();
    }

    @Generated
    public ConfluentKafkaCrawlerBuilder<?, ?> toBuilder() {
        return new ConfluentKafkaCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfluentKafkaCrawler)) {
            return false;
        }
        ConfluentKafkaCrawler other = (ConfluentKafkaCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfluentKafkaCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ConfluentKafkaCrawler(super=" + super.toString() + ")";
    }

    public static abstract class ConfluentKafkaCrawlerBuilder<C extends ConfluentKafkaCrawler, B extends ConfluentKafkaCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String bootstrap, boolean encrypted) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-confluent-kafka-" + this.epoch + "-0")).host(bootstrap)).port(9092)).extra("security_protocol", encrypted ? "SASL_SSL" : "SASL_PLAINTEXT")).connectorConfigName("atlan-connectors-kafka-confluent-cloud");
            return (B)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)this._parameter("extraction-method", "direct"))._credential(this.localCreds));
        }

        public B apiToken(String apiKey, String apiSecret) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(apiKey)).password(apiSecret);
            return (B)((ConfluentKafkaCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(String regex) throws InvalidRequestException {
            return (B)((ConfluentKafkaCrawlerBuilder)this._parameter("include-filter", regex));
        }

        public B exclude(String regex) {
            return (B)((ConfluentKafkaCrawlerBuilder)this._parameter("exclude-filter", regex));
        }

        public B skipInternal(boolean enabled) {
            return (B)((ConfluentKafkaCrawlerBuilder)this._parameter("skip-internal-topics", "" + enabled));
        }

        @Override
        protected B metadata() {
            return (B)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)((ConfluentKafkaCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "confluent-kafka"))._label("orchestration.atlan.com/sourceCategory", "eventbus"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hkafka-confluent-cloud"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-confluent-kafka-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6778924963599"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://cdn.confluent.io/wp-content/uploads/apache-kafka-icon-2021-e1638496305992.jpg"))._annotation("orchestration.atlan.com/logo", "https://cdn.confluent.io/wp-content/uploads/apache-kafka-icon-2021-e1638496305992.jpg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/kafka-confluent-cloud"))._annotation("orchestration.atlan.com/name", "Confluent Kafka Assets"))._annotation("orchestration.atlan.com/usecase", "crawling,discovery"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Confluent Kafka assets and publish to Atlan for discovery."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/kafka-confluent-cloud"))._annotation("package.argoproj.io/keywords", "[\"kafka-confluent-cloud\",\"confluent-kafka\",\"eventbus\",\"connector\",\"kafka\"]"))._annotation("package.argoproj.io/name", "@atlan/kafka-confluent-cloud"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-confluent-kafka-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("publish-mode", "production"), Map.entry("atlas-auth-type", "internal"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ConfluentKafkaCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ConfluentKafkaCrawler instance, ConfluentKafkaCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ConfluentKafkaCrawler.ConfluentKafkaCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class ConfluentKafkaCrawlerBuilderImpl
    extends ConfluentKafkaCrawlerBuilder<ConfluentKafkaCrawler, ConfluentKafkaCrawlerBuilderImpl> {
        @Generated
        private ConfluentKafkaCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected ConfluentKafkaCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ConfluentKafkaCrawler build() {
            return new ConfluentKafkaCrawler(this);
        }
    }
}

