/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RedshiftCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.REDSHIFT.getValue();

    public static RedshiftCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return RedshiftCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null, true, true, 10000L);
    }

    public static RedshiftCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)RedshiftCrawler._internal().setup(PREFIX, "@atlan/redshift", client, RedshiftCrawler.getConnection(client, connectionName, AtlanConnectorType.REDSHIFT, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://cdn.worldvectorlogo.com/logos/aws-redshift-logo.svg"))).include(null)).exclude((Map<String, List<String>>)null);
    }

    @Generated
    protected RedshiftCrawler(RedshiftCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static RedshiftCrawlerBuilder<?, ?> _internal() {
        return new RedshiftCrawlerBuilderImpl();
    }

    @Generated
    public RedshiftCrawlerBuilder<?, ?> toBuilder() {
        return new RedshiftCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedshiftCrawler)) {
            return false;
        }
        RedshiftCrawler other = (RedshiftCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedshiftCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RedshiftCrawler(super=" + super.toString() + ")";
    }

    public static abstract class RedshiftCrawlerBuilder<C extends RedshiftCrawler, B extends RedshiftCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname, String database, boolean serverless) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-redshift-" + this.epoch + "-0")).host(hostname)).port(5439)).extra("database", database)).extra("deployment_type", serverless ? "serverless" : "provisioned")).connectorConfigName("atlan-connectors-redshift");
            return (B)((RedshiftCrawlerBuilder)this._credential(this.localCreds));
        }

        public B basicAuth(String username, String password) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("basic")).username(username)).password(password);
            return (B)((RedshiftCrawlerBuilder)this._credential(this.localCreds));
        }

        public B iamUserAuth(String username, String accessKey, String secretKey) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("iam")).username(accessKey)).password(secretKey)).extra("dbuser", username);
            return (B)((RedshiftCrawlerBuilder)this._credential(this.localCreds));
        }

        public B crossConnection(boolean enabled) {
            return (B)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)this._parameter("advanced-config", "custom"))._parameter("cross-connection", "" + enabled));
        }

        public B include(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toInclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((RedshiftCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(Map<String, List<String>> assets) throws InvalidRequestException {
            Map<String, List<String>> toExclude = AbstractCrawler.buildHierarchicalFilter(assets);
            try {
                return (B)((RedshiftCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((RedshiftCrawlerBuilder)this._parameter("temp-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)((RedshiftCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "redshift"))._label("orchestration.atlan.com/sourceCategory", "warehouse"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hredshift"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-redshift-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "warehouse,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6326396122641"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://cdn.worldvectorlogo.com/logos/aws-redshift-logo.svg"))._annotation("orchestration.atlan.com/logo", "https://cdn.worldvectorlogo.com/logos/aws-redshift-logo.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/redshift"))._annotation("orchestration.atlan.com/name", "Redshift Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl AWS Redshift assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/redshift"))._annotation("package.argoproj.io/keywords", "[\"redshift\",\"warehouse\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/redshift"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-redshift-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credentials-fetch-strategy", "credential_guid"), Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("control-config-strategy", "default"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("publish-mode", "production"), Map.entry("atlas-auth-type", "internal"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RedshiftCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RedshiftCrawler instance, RedshiftCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RedshiftCrawler.RedshiftCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class RedshiftCrawlerBuilderImpl
    extends RedshiftCrawlerBuilder<RedshiftCrawler, RedshiftCrawlerBuilderImpl> {
        @Generated
        private RedshiftCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected RedshiftCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedshiftCrawler build() {
            return new RedshiftCrawler(this);
        }
    }
}

