/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractMiner;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SnowflakeMiner
extends AbstractMiner {
    public static final String PREFIX = AtlanPackageType.SNOWFLAKE_MINER.getValue();

    public static SnowflakeMinerBuilder<?, ?> creator(String connectionQualifiedName) {
        return (SnowflakeMinerBuilder)((SnowflakeMinerBuilder)SnowflakeMiner._internal().setup(PREFIX, "@atlan/snowflake-miner"))._parameter("connection-qualified-name", connectionQualifiedName);
    }

    @Generated
    protected SnowflakeMiner(SnowflakeMinerBuilder<?, ?> b) {
        super((AbstractMiner.AbstractMinerBuilder<?, ?>)b);
    }

    @Generated
    public static SnowflakeMinerBuilder<?, ?> _internal() {
        return new SnowflakeMinerBuilderImpl();
    }

    @Generated
    public SnowflakeMinerBuilder<?, ?> toBuilder() {
        return new SnowflakeMinerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowflakeMiner)) {
            return false;
        }
        SnowflakeMiner other = (SnowflakeMiner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnowflakeMiner;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SnowflakeMiner(super=" + super.toString() + ")";
    }

    public static abstract class SnowflakeMinerBuilder<C extends SnowflakeMiner, B extends SnowflakeMinerBuilder<C, B>>
    extends AbstractMiner.AbstractMinerBuilder<C, B> {
        public B direct(long startEpoch) {
            return (B)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)this._parameter("snowflake-database", "default"))._parameter("extraction-method", "query_history"))._parameter("miner-start-time-epoch", "" + startEpoch));
        }

        public B direct(String database, String schema, long startEpoch) {
            return (B)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)this._parameter("database-name", database))._parameter("schema-name", schema))._parameter("extraction-method", "query_history"))._parameter("miner-start-time-epoch", "" + startEpoch));
        }

        public B s3(String s3Bucket, String s3Prefix, String queryKey, String defaultDatabase, String defaultSchema, String sessionId) {
            return (B)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)this._parameter("extraction-method", "s3"))._parameter("extraction-s3-bucket", s3Bucket))._parameter("extraction-s3-prefix", s3Prefix))._parameter("sql-json-key", queryKey))._parameter("catalog-json-key", defaultDatabase))._parameter("schema-json-key", defaultSchema))._parameter("session-json-key", sessionId));
        }

        public B excludeUsers(List<String> users) throws InvalidRequestException {
            try {
                return (B)((SnowflakeMinerBuilder)this._parameter("popularity-exclude-user-config", Serde.allInclusiveMapper.writeValueAsString(users)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B nativeLineage(boolean enabled) {
            return (B)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)this._parameter("control-config-strategy", "custom"))._parameter("native-lineage-active", "" + enabled));
        }

        @Override
        protected B metadata() {
            return (B)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)((SnowflakeMinerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "snowflake"))._label("orchestration.atlan.com/sourceCategory", "warehouse"))._label("orchestration.atlan.com/type", "miner"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsnowflake-miner"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "warehouse,miner"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6482067592337"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://docs.snowflake.com/en/_images/logo-snowflake-sans-text.png"))._annotation("orchestration.atlan.com/logo", "https://1amiydhcmj36tz3733v94f15-wpengine.netdna-ssl.com/wp-content/themes/snowflake/assets/img/logo-blue.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/snowflake-miner"))._annotation("orchestration.atlan.com/name", "Snowflake Miner"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to mine query history data from Snowflake and store it for further processing. The data mined will be used for generating lineage and usage metrics."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/snowflake-miner"))._annotation("package.argoproj.io/keywords", "[\"snowflake\",\"warehouse\",\"connector\",\"miner\"]"))._annotation("package.argoproj.io/name", "@atlan/snowflake-miner"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-" + this.epoch))._parameters(Map.ofEntries(Map.entry("control-config-strategy", "default"), Map.entry("single-session", "false"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SnowflakeMinerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SnowflakeMiner instance, SnowflakeMinerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SnowflakeMiner.SnowflakeMinerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class SnowflakeMinerBuilderImpl
    extends SnowflakeMinerBuilder<SnowflakeMiner, SnowflakeMinerBuilderImpl> {
        @Generated
        private SnowflakeMinerBuilderImpl() {
        }

        @Override
        @Generated
        protected SnowflakeMinerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SnowflakeMiner build() {
            return new SnowflakeMiner(this);
        }
    }
}

