/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.search;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanTermQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanWithinQuery;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.ITag;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.model.search.FluentSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompoundQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompoundQuery.class);
    AtlanClient client;
    private List<Query> wheres;
    private List<Query> whereNots;
    private List<Query> whereSomes;
    private int minSomes;

    public Query toQuery() {
        return this.toQuery(true);
    }

    public Query toUnfilteredQuery() {
        return this.toQuery(false);
    }

    private Query toQuery(boolean filter) {
        BoolQuery.Builder builder = new BoolQuery.Builder();
        if (this.wheres != null && !this.wheres.isEmpty()) {
            if (filter) {
                builder.filter(this.wheres);
            } else {
                builder.must(this.wheres);
            }
        }
        if (this.whereNots != null && !this.whereNots.isEmpty()) {
            builder.mustNot(this.whereNots);
        }
        if (this.whereSomes != null && !this.whereSomes.isEmpty()) {
            builder.should(this.whereSomes).minimumShouldMatch("" + this.minSomes);
        }
        return builder.build()._toQuery();
    }

    @Generated
    private static int $default$minSomes() {
        return 1;
    }

    @Generated
    protected CompoundQuery(CompoundQueryBuilder<?, ?> b) {
        this.client = b.client;
        this.wheres = switch (b.wheres == null ? 0 : b.wheres.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.wheres.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Query>(b.wheres));
        };
        this.whereNots = switch (b.whereNots == null ? 0 : b.whereNots.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.whereNots.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Query>(b.whereNots));
        };
        this.whereSomes = switch (b.whereSomes == null ? 0 : b.whereSomes.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.whereSomes.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Query>(b.whereSomes));
        };
        this.minSomes = b.minSomes$set ? b.minSomes$value : CompoundQuery.$default$minSomes();
    }

    public static abstract class CompoundQueryBuilder<C extends CompoundQuery, B extends CompoundQueryBuilder<C, B>> {
        @Generated
        private AtlanClient client;
        @Generated
        private ArrayList<Query> wheres;
        @Generated
        private ArrayList<Query> whereNots;
        @Generated
        private ArrayList<Query> whereSomes;
        @Generated
        private boolean minSomes$set;
        @Generated
        private int minSomes$value;

        public B tagged(Collection<String> atlanTagNames) throws AtlanException {
            ArrayList<String> values = new ArrayList<String>();
            for (String name : atlanTagNames) {
                values.add(this.client.getAtlanTagCache().getSidForName(name));
            }
            return ((CompoundQueryBuilder)((CompoundQueryBuilder)this.whereSome(Asset.ATLAN_TAGS.in(values))).whereSome(Asset.PROPAGATED_ATLAN_TAGS.in(values))).minSomes(1);
        }

        public B tagged(boolean directly) {
            if (directly) {
                return this.where(Asset.ATLAN_TAGS.hasAnyValue());
            }
            return ((CompoundQueryBuilder)((CompoundQueryBuilder)this.whereSome(Asset.ATLAN_TAGS.hasAnyValue())).whereSome(Asset.PROPAGATED_ATLAN_TAGS.hasAnyValue())).minSomes(1);
        }

        public B taggedWithValue(String atlanTagName, String value) throws AtlanException {
            return this.taggedWithValue(atlanTagName, value, false);
        }

        public B taggedWithValue(String atlanTagName, String value, boolean directly) throws AtlanException {
            String syncedTagQN;
            String tagId = this.client.getAtlanTagCache().getSidForName(atlanTagName);
            List<Asset> syncedTags = ((FluentSearch.FluentSearchBuilder)this.client.assets.select().where(ITag.MAPPED_ATLAN_TAG_NAME.eq(tagId))).stream().toList();
            if (syncedTags.size() > 1) {
                syncedTagQN = syncedTags.get(0).getQualifiedName();
                log.warn("Multiple mapped source-synced tags found for tag {} -- using only the first: {}", (Object)atlanTagName, (Object)syncedTagQN);
            } else {
                syncedTagQN = !syncedTags.isEmpty() ? syncedTags.get(0).getQualifiedName() : "NON_EXISTENT";
            }
            return this.taggedWithValue(atlanTagName, syncedTagQN, value, directly);
        }

        public B taggedWithValue(String atlanTagName, String sourceTagQualifiedName, String value, boolean directly) throws AtlanException {
            String tagId = this.client.getAtlanTagCache().getSidForName(atlanTagName);
            ArrayList<SpanQuery> littleSpans = new ArrayList<SpanQuery>();
            littleSpans.add(SpanTermQuery.of(t -> t.field("__classificationsText.text").value("tagAttachmentValue"))._toSpanQuery());
            for (String token : value.split(" ")) {
                littleSpans.add(SpanTermQuery.of(t -> t.field("__classificationsText.text").value(token))._toSpanQuery());
            }
            littleSpans.add(SpanTermQuery.of(t -> t.field("__classificationsText.text").value("tagAttachmentKey"))._toSpanQuery());
            ArrayList<SpanQuery> bigSpans = new ArrayList<SpanQuery>();
            bigSpans.add(SpanTermQuery.of(t -> t.field("__classificationsText.text").value(tagId))._toSpanQuery());
            bigSpans.add(SpanTermQuery.of(t -> t.field("__classificationsText.text").value(sourceTagQualifiedName))._toSpanQuery());
            Query span = SpanWithinQuery.of(s -> s.little(l -> l.spanNear(n -> n.clauses(littleSpans).slop(Integer.valueOf(0)).inOrder(Boolean.valueOf(true)))).big(b -> b.spanNear(n -> n.clauses(bigSpans).slop(Integer.valueOf(10000000)).inOrder(Boolean.valueOf(true)))))._toQuery();
            if (directly) {
                return ((CompoundQueryBuilder)this.where(Asset.ATLAN_TAGS.eq(tagId))).where(span);
            }
            return ((CompoundQueryBuilder)((CompoundQueryBuilder)((CompoundQueryBuilder)this.whereSome(Asset.ATLAN_TAGS.eq(tagId))).whereSome(Asset.PROPAGATED_ATLAN_TAGS.eq(tagId))).minSomes(1)).where(span);
        }

        public B active() {
            return this.where(Asset.STATUS.eq(AtlanStatus.ACTIVE));
        }

        public B archived() {
            return this.where(Asset.STATUS.eq(AtlanStatus.DELETED));
        }

        public B withLineage() {
            return this.where(Asset.HAS_LINEAGE.eq(true));
        }

        public B withoutLineage() {
            return this.whereNot(((CompoundQuery)((CompoundQueryBuilder)this.withLineage()).build()).toQuery());
        }

        @Generated
        public B client(AtlanClient client) {
            this.client = client;
            return this.self();
        }

        @Generated
        public B where(Query where) {
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.add(where);
            return this.self();
        }

        @Generated
        public B wheres(Collection<? extends Query> wheres) {
            if (wheres == null) {
                throw new NullPointerException("wheres cannot be null");
            }
            if (this.wheres == null) {
                this.wheres = new ArrayList();
            }
            this.wheres.addAll(wheres);
            return this.self();
        }

        @Generated
        public B clearWheres() {
            if (this.wheres != null) {
                this.wheres.clear();
            }
            return this.self();
        }

        @Generated
        public B whereNot(Query whereNot) {
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.add(whereNot);
            return this.self();
        }

        @Generated
        public B whereNots(Collection<? extends Query> whereNots) {
            if (whereNots == null) {
                throw new NullPointerException("whereNots cannot be null");
            }
            if (this.whereNots == null) {
                this.whereNots = new ArrayList();
            }
            this.whereNots.addAll(whereNots);
            return this.self();
        }

        @Generated
        public B clearWhereNots() {
            if (this.whereNots != null) {
                this.whereNots.clear();
            }
            return this.self();
        }

        @Generated
        public B whereSome(Query whereSome) {
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.add(whereSome);
            return this.self();
        }

        @Generated
        public B whereSomes(Collection<? extends Query> whereSomes) {
            if (whereSomes == null) {
                throw new NullPointerException("whereSomes cannot be null");
            }
            if (this.whereSomes == null) {
                this.whereSomes = new ArrayList();
            }
            this.whereSomes.addAll(whereSomes);
            return this.self();
        }

        @Generated
        public B clearWhereSomes() {
            if (this.whereSomes != null) {
                this.whereSomes.clear();
            }
            return this.self();
        }

        @Generated
        public B minSomes(int minSomes) {
            this.minSomes$value = minSomes;
            this.minSomes$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "CompoundQuery.CompoundQueryBuilder(client=" + String.valueOf(this.client) + ", wheres=" + String.valueOf(this.wheres) + ", whereNots=" + String.valueOf(this.whereNots) + ", whereSomes=" + String.valueOf(this.whereSomes) + ", minSomes$value=" + this.minSomes$value + ")";
        }
    }
}

