/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.typedefs;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanCustomAttributeCardinality;
import com.atlan.model.enums.AtlanIcon;
import com.atlan.model.enums.AtlanTagColor;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagOptions;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;

@JsonDeserialize(builder=AtlanTagDefBuilderImpl.class)
public class AtlanTagDef
extends TypeDef {
    private static final long serialVersionUID = 2L;
    AtlanTypeCategory category;
    AtlanTagOptions options;
    List<String> superTypes;
    List<String> entityTypes;
    List<String> subTypes;
    Boolean skipDisplayNameUniquenessCheck;

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanTagColor color) {
        return AtlanTagDef.creator(displayName, color, false);
    }

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanTagColor color, boolean sourceSynced) {
        return AtlanTagDef.setupSourceSynced(((AtlanTagDefBuilder)((AtlanTagDefBuilder)AtlanTagDef.builder().name(displayName)).displayName(displayName)).options(AtlanTagOptions.of(color, sourceSynced)), sourceSynced);
    }

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanIcon icon, AtlanTagColor color) {
        return AtlanTagDef.creator(displayName, icon, color, false);
    }

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanIcon icon, AtlanTagColor color, boolean sourceSynced) {
        return AtlanTagDef.setupSourceSynced(((AtlanTagDefBuilder)((AtlanTagDefBuilder)AtlanTagDef.builder().name(displayName)).displayName(displayName)).options(AtlanTagOptions.withIcon(icon, color, sourceSynced)), sourceSynced);
    }

    public static AtlanTagDefBuilder<?, ?> creator(AtlanClient client, String displayName, String url) throws AtlanException {
        return AtlanTagDef.creator(client, displayName, url, false);
    }

    public static AtlanTagDefBuilder<?, ?> creator(AtlanClient client, String displayName, String url, boolean sourceSynced) throws AtlanException {
        return AtlanTagDef.setupSourceSynced(((AtlanTagDefBuilder)((AtlanTagDefBuilder)AtlanTagDef.builder().name(displayName)).displayName(displayName)).options(AtlanTagOptions.withImage(client, url, sourceSynced)), sourceSynced);
    }

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanTagOptions options) throws AtlanException {
        return ((AtlanTagDefBuilder)((AtlanTagDefBuilder)AtlanTagDef.builder().name(displayName)).displayName(displayName)).options(options);
    }

    public static AtlanTagDefBuilder<?, ?> creator(String displayName, boolean sourceSynced) throws AtlanException {
        return AtlanTagDef.setupSourceSynced((AtlanTagDefBuilder)((AtlanTagDefBuilder)AtlanTagDef.builder().name(displayName)).displayName(displayName), sourceSynced);
    }

    public static AtlanTagDefBuilder<?, ?> setupSourceSynced(AtlanTagDefBuilder<?, ?> builder, boolean sourceSynced) {
        if (sourceSynced) {
            builder.attributeDef((AttributeDef)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)((AttributeDef.AttributeDefBuilder)AttributeDef.builder().typeName("array<SourceTagAttachment>")).isOptional(true)).cardinality(AtlanCustomAttributeCardinality.SET)).valuesMinCount(0L)).valuesMaxCount((Long)Integer.MAX_VALUE)).isUnique(false)).isIndexable(false)).includeInNotification(false)).skipScrubbing(false)).searchWeight(-1L)).displayName("sourceTagAttachment")).isDefaultValueNull(false)).build());
        }
        return builder;
    }

    public synchronized AtlanTagDef create(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.create(this);
        if (response != null && !response.getAtlanTagDefs().isEmpty()) {
            return response.getAtlanTagDefs().get(0);
        }
        return null;
    }

    public static synchronized void purge(AtlanClient client, String displayName) throws AtlanException {
        String internalName = client.getAtlanTagCache().getSidForName(displayName);
        client.typeDefs.purge(internalName);
    }

    @Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.ATLAN_TAG;
    }

    @Generated
    private static Boolean $default$skipDisplayNameUniquenessCheck() {
        return false;
    }

    @Generated
    protected AtlanTagDef(AtlanTagDefBuilder<?, ?> b) {
        super((TypeDef.TypeDefBuilder<?, ?>)b);
        this.category = b.category$set ? b.category$value : AtlanTagDef.$default$category();
        this.options = b.options;
        this.superTypes = b.superTypes;
        this.entityTypes = b.entityTypes;
        this.subTypes = b.subTypes;
        this.skipDisplayNameUniquenessCheck = b.skipDisplayNameUniquenessCheck$set ? b.skipDisplayNameUniquenessCheck$value : AtlanTagDef.$default$skipDisplayNameUniquenessCheck();
    }

    @Generated
    public static AtlanTagDefBuilder<?, ?> builder() {
        return new AtlanTagDefBuilderImpl();
    }

    @Generated
    public AtlanTagDefBuilder<?, ?> toBuilder() {
        return new AtlanTagDefBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public AtlanTagOptions getOptions() {
        return this.options;
    }

    @Generated
    public List<String> getSuperTypes() {
        return this.superTypes;
    }

    @Generated
    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    @Generated
    public Boolean getSkipDisplayNameUniquenessCheck() {
        return this.skipDisplayNameUniquenessCheck;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanTagDef)) {
            return false;
        }
        AtlanTagDef other = (AtlanTagDef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$skipDisplayNameUniquenessCheck = this.getSkipDisplayNameUniquenessCheck();
        Boolean other$skipDisplayNameUniquenessCheck = other.getSkipDisplayNameUniquenessCheck();
        if (this$skipDisplayNameUniquenessCheck == null ? other$skipDisplayNameUniquenessCheck != null : !((Object)this$skipDisplayNameUniquenessCheck).equals(other$skipDisplayNameUniquenessCheck)) {
            return false;
        }
        AtlanTypeCategory this$category = this.getCategory();
        AtlanTypeCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        AtlanTagOptions this$options = this.getOptions();
        AtlanTagOptions other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        List<String> this$superTypes = this.getSuperTypes();
        List<String> other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !((Object)this$superTypes).equals(other$superTypes)) {
            return false;
        }
        List<String> this$entityTypes = this.getEntityTypes();
        List<String> other$entityTypes = other.getEntityTypes();
        if (this$entityTypes == null ? other$entityTypes != null : !((Object)this$entityTypes).equals(other$entityTypes)) {
            return false;
        }
        List<String> this$subTypes = this.getSubTypes();
        List<String> other$subTypes = other.getSubTypes();
        return !(this$subTypes == null ? other$subTypes != null : !((Object)this$subTypes).equals(other$subTypes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanTagDef;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $skipDisplayNameUniquenessCheck = this.getSkipDisplayNameUniquenessCheck();
        result = result * 59 + ($skipDisplayNameUniquenessCheck == null ? 43 : ((Object)$skipDisplayNameUniquenessCheck).hashCode());
        AtlanTypeCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        AtlanTagOptions $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        List<String> $superTypes = this.getSuperTypes();
        result = result * 59 + ($superTypes == null ? 43 : ((Object)$superTypes).hashCode());
        List<String> $entityTypes = this.getEntityTypes();
        result = result * 59 + ($entityTypes == null ? 43 : ((Object)$entityTypes).hashCode());
        List<String> $subTypes = this.getSubTypes();
        result = result * 59 + ($subTypes == null ? 43 : ((Object)$subTypes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "AtlanTagDef(super=" + super.toString() + ", category=" + String.valueOf(this.getCategory()) + ", options=" + String.valueOf(this.getOptions()) + ", superTypes=" + String.valueOf(this.getSuperTypes()) + ", entityTypes=" + String.valueOf(this.getEntityTypes()) + ", subTypes=" + String.valueOf(this.getSubTypes()) + ", skipDisplayNameUniquenessCheck=" + this.getSkipDisplayNameUniquenessCheck() + ")";
    }

    @Override
    @Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }

    public static abstract class AtlanTagDefBuilder<C extends AtlanTagDef, B extends AtlanTagDefBuilder<C, B>>
    extends TypeDef.TypeDefBuilder<C, B> {
        @Generated
        private boolean category$set;
        @Generated
        private AtlanTypeCategory category$value;
        @Generated
        private AtlanTagOptions options;
        @Generated
        private List<String> superTypes;
        @Generated
        private List<String> entityTypes;
        @Generated
        private List<String> subTypes;
        @Generated
        private boolean skipDisplayNameUniquenessCheck$set;
        @Generated
        private Boolean skipDisplayNameUniquenessCheck$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanTagDef instance, AtlanTagDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.options(instance.options);
            b.superTypes(instance.superTypes);
            b.entityTypes(instance.entityTypes);
            b.subTypes(instance.subTypes);
            b.skipDisplayNameUniquenessCheck(instance.skipDisplayNameUniquenessCheck);
        }

        @Override
        @Generated
        public B category(AtlanTypeCategory category) {
            this.category$value = category;
            this.category$set = true;
            return (B)this.self();
        }

        @Generated
        public B options(AtlanTagOptions options) {
            this.options = options;
            return (B)this.self();
        }

        @Generated
        public B superTypes(List<String> superTypes) {
            this.superTypes = superTypes;
            return (B)this.self();
        }

        @Generated
        public B entityTypes(List<String> entityTypes) {
            this.entityTypes = entityTypes;
            return (B)this.self();
        }

        @Generated
        public B subTypes(List<String> subTypes) {
            this.subTypes = subTypes;
            return (B)this.self();
        }

        @Generated
        public B skipDisplayNameUniquenessCheck(Boolean skipDisplayNameUniquenessCheck) {
            this.skipDisplayNameUniquenessCheck$value = skipDisplayNameUniquenessCheck;
            this.skipDisplayNameUniquenessCheck$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AtlanTagDef.AtlanTagDefBuilder(super=" + super.toString() + ", category$value=" + String.valueOf(this.category$value) + ", options=" + String.valueOf(this.options) + ", superTypes=" + String.valueOf(this.superTypes) + ", entityTypes=" + String.valueOf(this.entityTypes) + ", subTypes=" + String.valueOf(this.subTypes) + ", skipDisplayNameUniquenessCheck$value=" + this.skipDisplayNameUniquenessCheck$value + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AtlanTagDefBuilderImpl
    extends AtlanTagDefBuilder<AtlanTagDef, AtlanTagDefBuilderImpl> {
        @Generated
        private AtlanTagDefBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanTagDefBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanTagDef build() {
            return new AtlanTagDef(this);
        }
    }
}

