/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalRateLimiter.class);
    private static final GlobalRateLimiter INSTANCE = new GlobalRateLimiter();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition rateAvailable = this.lock.newCondition();
    private final AtomicBoolean isRateLimited = new AtomicBoolean(false);
    private long resumeTimeMillis = 0L;

    private GlobalRateLimiter() {
    }

    public static GlobalRateLimiter getInstance() {
        return INSTANCE;
    }

    public void waitIfRateLimited() throws InterruptedException {
        if (!this.isRateLimited.get()) {
            return;
        }
        this.lock.lock();
        try {
            while (this.isRateLimited.get()) {
                long waitTime = this.resumeTimeMillis - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    this.isRateLimited.set(false);
                    this.rateAvailable.signalAll();
                    break;
                }
                log.debug(" ... already rate-limited, continuing to wait for {}ms before retrying", (Object)waitTime);
                this.rateAvailable.await(waitTime, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRateLimit(long retryAfterMillis) {
        this.lock.lock();
        try {
            this.isRateLimited.set(true);
            this.resumeTimeMillis = System.currentTimeMillis() + retryAfterMillis;
            log.debug(" ... rate-limited -- pausing for {}ms before retrying", (Object)retryAfterMillis);
        }
        finally {
            this.lock.unlock();
        }
    }
}

