/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.net;

import com.atlan.AtlanClient;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RequestOptions {
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;
    private final boolean skipLogging;
    private final Map<String, List<String>> extraHeaders;

    public static RequestOptionsBuilder from(AtlanClient client) {
        return RequestOptions.builder().connectTimeout(client.getConnectTimeout()).readTimeout(client.getReadTimeout()).maxNetworkRetries(client.getMaxNetworkRetries()).connectionProxy(client.getConnectionProxy()).proxyCredential(client.getProxyCredential()).extraHeaders(client.getExtraHeaders());
    }

    @Generated
    private static boolean $default$skipLogging() {
        return false;
    }

    @Generated
    RequestOptions(int connectTimeout, int readTimeout, int maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential, boolean skipLogging, Map<String, List<String>> extraHeaders) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
        this.skipLogging = skipLogging;
        this.extraHeaders = extraHeaders;
    }

    @Generated
    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    @Generated
    public RequestOptionsBuilder toBuilder() {
        RequestOptionsBuilder builder = new RequestOptionsBuilder().connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).maxNetworkRetries(this.maxNetworkRetries).connectionProxy(this.connectionProxy).proxyCredential(this.proxyCredential).skipLogging(this.skipLogging);
        if (this.extraHeaders != null) {
            builder.extraHeaders(this.extraHeaders);
        }
        return builder;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    @Generated
    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    @Generated
    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    @Generated
    public boolean getSkipLogging() {
        return this.skipLogging;
    }

    @Generated
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestOptions)) {
            return false;
        }
        RequestOptions other = (RequestOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getMaxNetworkRetries() != other.getMaxNetworkRetries()) {
            return false;
        }
        if (this.getSkipLogging() != other.getSkipLogging()) {
            return false;
        }
        Proxy this$connectionProxy = this.getConnectionProxy();
        Proxy other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !((Object)this$connectionProxy).equals(other$connectionProxy)) {
            return false;
        }
        PasswordAuthentication this$proxyCredential = this.getProxyCredential();
        PasswordAuthentication other$proxyCredential = other.getProxyCredential();
        if (this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential)) {
            return false;
        }
        Map<String, List<String>> this$extraHeaders = this.getExtraHeaders();
        Map<String, List<String>> other$extraHeaders = other.getExtraHeaders();
        return !(this$extraHeaders == null ? other$extraHeaders != null : !((Object)this$extraHeaders).equals(other$extraHeaders));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getMaxNetworkRetries();
        result = result * 59 + (this.getSkipLogging() ? 79 : 97);
        Proxy $connectionProxy = this.getConnectionProxy();
        result = result * 59 + ($connectionProxy == null ? 43 : ((Object)$connectionProxy).hashCode());
        PasswordAuthentication $proxyCredential = this.getProxyCredential();
        result = result * 59 + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        Map<String, List<String>> $extraHeaders = this.getExtraHeaders();
        result = result * 59 + ($extraHeaders == null ? 43 : ((Object)$extraHeaders).hashCode());
        return result;
    }

    public static class RequestOptionsBuilder {
        @Generated
        private int connectTimeout;
        @Generated
        private int readTimeout;
        @Generated
        private int maxNetworkRetries;
        @Generated
        private Proxy connectionProxy;
        @Generated
        private PasswordAuthentication proxyCredential;
        @Generated
        private boolean skipLogging$set;
        @Generated
        private boolean skipLogging$value;
        @Generated
        private ArrayList<String> extraHeaders$key;
        @Generated
        private ArrayList<List<String>> extraHeaders$value;

        @Generated
        RequestOptionsBuilder() {
        }

        @Generated
        public RequestOptionsBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Generated
        public RequestOptionsBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public RequestOptionsBuilder maxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        @Generated
        public RequestOptionsBuilder connectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        @Generated
        public RequestOptionsBuilder proxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        @Generated
        public RequestOptionsBuilder skipLogging(boolean skipLogging) {
            this.skipLogging$value = skipLogging;
            this.skipLogging$set = true;
            return this;
        }

        @Generated
        public RequestOptionsBuilder extraHeader(String extraHeaderKey, List<String> extraHeaderValue) {
            if (this.extraHeaders$key == null) {
                this.extraHeaders$key = new ArrayList();
                this.extraHeaders$value = new ArrayList();
            }
            this.extraHeaders$key.add(extraHeaderKey);
            this.extraHeaders$value.add(extraHeaderValue);
            return this;
        }

        @Generated
        public RequestOptionsBuilder extraHeaders(Map<? extends String, ? extends List<String>> extraHeaders) {
            if (extraHeaders == null) {
                throw new NullPointerException("extraHeaders cannot be null");
            }
            if (this.extraHeaders$key == null) {
                this.extraHeaders$key = new ArrayList();
                this.extraHeaders$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<String>> $lombokEntry : extraHeaders.entrySet()) {
                this.extraHeaders$key.add($lombokEntry.getKey());
                this.extraHeaders$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public RequestOptionsBuilder clearExtraHeaders() {
            if (this.extraHeaders$key != null) {
                this.extraHeaders$key.clear();
                this.extraHeaders$value.clear();
            }
            return this;
        }

        @Generated
        public RequestOptions build() {
            Map<String, List<String>> extraHeaders;
            switch (this.extraHeaders$key == null ? 0 : this.extraHeaders$key.size()) {
                case 0: {
                    extraHeaders = Collections.emptyMap();
                    break;
                }
                case 1: {
                    extraHeaders = Collections.singletonMap(this.extraHeaders$key.get(0), this.extraHeaders$value.get(0));
                    break;
                }
                default: {
                    extraHeaders = new LinkedHashMap(this.extraHeaders$key.size() < 0x40000000 ? 1 + this.extraHeaders$key.size() + (this.extraHeaders$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.extraHeaders$key.size(); ++$i) {
                        extraHeaders.put(this.extraHeaders$key.get($i), this.extraHeaders$value.get($i));
                    }
                    extraHeaders = Collections.unmodifiableMap(extraHeaders);
                }
            }
            boolean skipLogging$value = this.skipLogging$value;
            if (!this.skipLogging$set) {
                skipLogging$value = RequestOptions.$default$skipLogging();
            }
            return new RequestOptions(this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential, skipLogging$value, extraHeaders);
        }

        @Generated
        public String toString() {
            return "RequestOptions.RequestOptionsBuilder(connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", maxNetworkRetries=" + this.maxNetworkRetries + ", connectionProxy=" + String.valueOf(this.connectionProxy) + ", proxyCredential=" + String.valueOf(this.proxyCredential) + ", skipLogging$value=" + this.skipLogging$value + ", extraHeaders$key=" + String.valueOf(this.extraHeaders$key) + ", extraHeaders$value=" + String.valueOf(this.extraHeaders$value) + ")";
        }
    }
}

