/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanTag;
import com.atlan.model.enums.AtlanStatus;
import com.atlan.util.JacksonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlanTagSerializer
extends StdSerializer<AtlanTag> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtlanTagSerializer.class);
    private static final long serialVersionUID = 2L;
    private final transient AtlanClient client;

    public AtlanTagSerializer(AtlanClient client) {
        this(AtlanTag.class, client);
    }

    public AtlanTagSerializer(Class<AtlanTag> t, AtlanClient client) {
        super(t);
        this.client = client;
    }

    public void serializeWithType(AtlanTag value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    public void serialize(AtlanTag cls, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
        String clsName = cls.getTypeName();
        if (clsName == null) {
            log.debug("Attempt to serialize a null Atlan tag \u2014 skipping.");
        } else {
            String sourceAttachmentsAttrId;
            String clsId;
            if (clsName.equals("(DELETED)")) {
                clsId = "(DELETED)";
                sourceAttachmentsAttrId = "";
            } else {
                try {
                    clsId = this.client.getAtlanTagCache().getSidForName(clsName);
                    sourceAttachmentsAttrId = this.client.getAtlanTagCache().getSourceTagsAttrId(clsId);
                }
                catch (AtlanException e) {
                    throw new IOException("Unable to find Atlan tag with name: " + clsName, e);
                }
            }
            gen.writeStartObject();
            JacksonUtils.serializeString(gen, "typeName", clsId);
            JacksonUtils.serializeString(gen, "entityGuid", cls.getEntityGuid());
            AtlanStatus status = cls.getEntityStatus();
            if (status != null) {
                JacksonUtils.serializeString(gen, "entityStatus", status.getValue());
            }
            JacksonUtils.serializeBoolean(gen, "propagate", cls.getPropagate());
            JacksonUtils.serializeBoolean(gen, "removePropagationsOnEntityDelete", cls.getRemovePropagationsOnEntityDelete());
            JacksonUtils.serializeBoolean(gen, "restrictPropagationThroughLineage", cls.getRestrictPropagationThroughLineage());
            JacksonUtils.serializeBoolean(gen, "restrictPropagationThroughHierarchy", cls.getRestrictPropagationThroughHierarchy());
            if (!sourceAttachmentsAttrId.isEmpty()) {
                gen.writeObjectFieldStart("attributes");
                JacksonUtils.serializeObject(gen, sourceAttachmentsAttrId, cls.getSourceTagAttachments());
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
    }
}

