/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.serde;

import com.atlan.AtlanClient;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ClientAwareSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 2L;
    private final transient AtlanClient client;

    public ClientAwareSerializerProvider(AtlanClient client) {
        this.client = client;
    }

    public ClientAwareSerializerProvider(ClientAwareSerializerProvider src) {
        super((DefaultSerializerProvider)src);
        this.client = src.client;
    }

    protected ClientAwareSerializerProvider(SerializerProvider src, SerializationConfig config, SerializerFactory f, AtlanClient client) {
        super(src, config, f);
        this.client = client;
    }

    public DefaultSerializerProvider withCaches(CacheProvider cacheProvider) {
        return this;
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new ClientAwareSerializerProvider((SerializerProvider)this, config, jsf, this.client);
    }

    public DefaultSerializerProvider copy() {
        if (((Object)((Object)this)).getClass() != ClientAwareSerializerProvider.class) {
            return super.copy();
        }
        return new ClientAwareSerializerProvider(this);
    }

    public JsonSerializer<Object> serializerInstance(Annotated annotated, Object serDef) throws JsonMappingException {
        JsonSerializer ser;
        if (serDef == null) {
            return null;
        }
        if (serDef instanceof JsonSerializer) {
            ser = (JsonSerializer)serDef;
        } else {
            HandlerInstantiator hi;
            Class serClass;
            if (!(serDef instanceof Class)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned serializer definition of type " + serDef.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            if ((serClass = (Class)serDef) == JsonSerializer.None.class || ClassUtil.isBogusClass((Class)serClass)) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(serClass)) {
                this.reportBadDefinition(annotated.getType(), "AnnotationIntrospector returned Class " + serClass.getName() + "; expected Class<JsonSerializer>");
            }
            JsonSerializer jsonSerializer = ser = (hi = this._config.getHandlerInstantiator()) == null ? null : hi.serializerInstance(this._config, annotated, serClass);
            if (ser == null) {
                Constructor ctor = ClientAwareSerializerProvider.findClientAwareConstructor(serClass, this._config.canOverrideAccessModifiers());
                if (ctor == null) {
                    ser = (JsonSerializer)ClassUtil.createInstance((Class)serClass, (boolean)this._config.canOverrideAccessModifiers());
                } else {
                    try {
                        ser = (JsonSerializer)ctor.newInstance(this.client);
                    }
                    catch (Exception e) {
                        ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to instantiate class " + serClass.getName() + ", problem: " + e.getMessage()));
                        return null;
                    }
                }
            }
        }
        return this._handleResolvable(ser);
    }

    private static <T> Constructor<T> findClientAwareConstructor(Class<T> cls, boolean forceAccess) {
        try {
            Constructor<T> ctor = cls.getDeclaredConstructor(AtlanClient.class);
            if (forceAccess) {
                ClassUtil.checkAndFixAccess(ctor, (boolean)forceAccess);
            } else if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to find default constructor of class " + cls.getName() + ", problem: " + e.getMessage()));
        }
        return null;
    }
}

