/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.util;

import com.atlan.AtlanClient;
import com.atlan.cache.OffHeapAssetCache;
import com.atlan.cache.OffHeapFailureCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.assets.Asset;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AtlanCloseable;
import com.atlan.model.enums.AssetCreationHandling;
import com.atlan.model.enums.AtlanTagHandling;
import com.atlan.model.enums.CustomMetadataHandling;
import com.atlan.util.AssetBatch;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ParallelBatch
implements AtlanCloseable {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtlanClient client;
    private final int maxSize;
    private final AtlanTagHandling atlanTagHandling;
    private final CustomMetadataHandling customMetadataHandling;
    private final boolean captureFailures;
    private final boolean track;
    private final boolean updateOnly;
    private final boolean caseSensitive;
    private final AssetCreationHandling creationHandling;
    private final boolean tableViewAgnostic;
    private final ConcurrentHashMap<Long, AssetBatch> batchMap = new ConcurrentHashMap();
    private final Map<String, String> resolvedGuids = new ConcurrentHashMap<String, String>();
    private final Map<AssetBatch.AssetIdentity, String> resolvedQualifiedNames = new ConcurrentHashMap<AssetBatch.AssetIdentity, String>();
    private OffHeapAssetCache created = null;
    private OffHeapAssetCache updated = null;
    private OffHeapAssetCache restored = null;
    private OffHeapAssetCache skipped = null;
    private OffHeapFailureCache failures = null;

    public ParallelBatch(AtlanClient client, int maxSize) {
        this(client, maxSize, AtlanTagHandling.IGNORE, CustomMetadataHandling.IGNORE);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, true);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, AssetCreationHandling.FULL);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling) {
        this(client, maxSize, atlanTagHandling, customMetadataHandling, captureFailures, updateOnly, track, caseSensitive, creationHandling, false);
    }

    public ParallelBatch(AtlanClient client, int maxSize, AtlanTagHandling atlanTagHandling, CustomMetadataHandling customMetadataHandling, boolean captureFailures, boolean updateOnly, boolean track, boolean caseSensitive, AssetCreationHandling creationHandling, boolean tableViewAgnostic) {
        this.client = client;
        this.maxSize = maxSize;
        this.atlanTagHandling = atlanTagHandling;
        this.customMetadataHandling = customMetadataHandling;
        this.creationHandling = creationHandling;
        this.track = track;
        this.captureFailures = captureFailures;
        this.updateOnly = updateOnly;
        this.caseSensitive = caseSensitive;
        this.tableViewAgnostic = tableViewAgnostic;
    }

    public AssetMutationResponse add(Asset single) throws AtlanException {
        long id = Thread.currentThread().getId();
        AssetBatch batch = this.batchMap.computeIfAbsent(id, k -> new AssetBatch(this.client, this.maxSize, this.atlanTagHandling, this.customMetadataHandling, this.captureFailures, this.updateOnly, this.track, !this.caseSensitive, this.creationHandling, this.tableViewAgnostic));
        return batch.add(single);
    }

    public void flush() throws AtlanException {
        this.lock.writeLock().lock();
        try {
            this.batchMap.values().forEach(batch -> {
                try {
                    batch.flush();
                }
                catch (AtlanException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumCreated() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumCreated().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumUpdated() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumUpdated().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumRestored() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumRestored().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumSkipped() {
        this.lock.readLock().lock();
        try {
            long count = 0L;
            for (AssetBatch batch : this.batchMap.values()) {
                count += batch.getNumSkipped().get();
            }
            long l = count;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getCreated() {
        if (!this.track) {
            return null;
        }
        if (this.created == null) {
            this.lock.writeLock().lock();
            try {
                this.created = new OffHeapAssetCache(this.client, "p-created");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getCreated().isNotClosed()) continue;
                    this.created.extendedWith(batch.getCreated(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.created;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getUpdated() {
        if (!this.track) {
            return null;
        }
        if (this.updated == null) {
            this.lock.writeLock().lock();
            try {
                this.updated = new OffHeapAssetCache(this.client, "p-updated");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getUpdated().isNotClosed()) continue;
                    this.updated.extendedWith(batch.getUpdated(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.updated;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getRestored() {
        if (!this.track) {
            return null;
        }
        if (this.restored == null) {
            this.lock.writeLock().lock();
            try {
                this.restored = new OffHeapAssetCache(this.client, "p-restored");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getRestored().isNotClosed()) continue;
                    this.restored.extendedWith(batch.getRestored(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.restored;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapFailureCache getFailures() {
        if (!this.track) {
            return null;
        }
        if (this.failures == null) {
            this.lock.writeLock().lock();
            try {
                this.failures = new OffHeapFailureCache(this.client, "p-failed");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getFailures().isNotClosed()) continue;
                    this.failures.extendedWith(batch.getFailures(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapFailureCache offHeapFailureCache = this.failures;
            return offHeapFailureCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapAssetCache getSkipped() {
        if (!this.track) {
            return null;
        }
        if (this.skipped == null) {
            this.lock.writeLock().lock();
            try {
                this.skipped = new OffHeapAssetCache(this.client, "p-skipped");
                for (AssetBatch batch : this.batchMap.values()) {
                    if (!batch.getSkipped().isNotClosed()) continue;
                    this.skipped.extendedWith(batch.getSkipped(), true);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            OffHeapAssetCache offHeapAssetCache = this.skipped;
            return offHeapAssetCache;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getResolvedGuids() {
        boolean empty;
        this.lock.readLock().lock();
        try {
            empty = this.resolvedGuids.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (empty) {
            this.lock.writeLock().lock();
            try {
                for (AssetBatch batch : this.batchMap.values()) {
                    this.resolvedGuids.putAll(batch.getResolvedGuids());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.resolvedGuids;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AssetBatch.AssetIdentity, String> getResolvedQualifiedNames() {
        boolean empty;
        this.lock.readLock().lock();
        try {
            empty = this.resolvedQualifiedNames.isEmpty();
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (empty) {
            this.lock.writeLock().lock();
            try {
                for (AssetBatch batch : this.batchMap.values()) {
                    this.resolvedQualifiedNames.putAll(batch.getResolvedQualifiedNames());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.lock.readLock().lock();
        try {
            Map<AssetBatch.AssetIdentity, String> map = this.resolvedQualifiedNames;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            for (AssetBatch batch : this.batchMap.values()) {
                AtlanCloseable.close(batch);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        AtlanCloseable.close(this.created);
        AtlanCloseable.close(this.updated);
        AtlanCloseable.close(this.restored);
        AtlanCloseable.close(this.skipped);
        AtlanCloseable.close(this.failures);
    }
}

