/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.gdpr;

import com.audienceproject.gdpr.TCPurposes;
import com.audienceproject.gdpr.TCStringUtils;
import com.audienceproject.gdpr.UnalignedBitStream;
import com.audienceproject.gdpr.struct.CoreString;
import com.audienceproject.gdpr.struct.PublisherTc;
import com.audienceproject.gdpr.struct.VendorSegment;
import io.kaitai.struct.KaitaiStream;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Optional;

public class TCString {
    private CoreString coreString;
    private VendorSegment disclosedVendors;
    private VendorSegment allowedVendors;
    private PublisherTc publisherTc;

    private TCString(String consentString) {
        String[] segments = consentString.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        this.coreString = new CoreString((KaitaiStream)new UnalignedBitStream(decoder.decode(segments[0])));
        block5: for (int i = 1; i < segments.length; ++i) {
            byte[] bytes = decoder.decode(segments[i]);
            UnalignedBitStream bitStream = new UnalignedBitStream(bytes);
            int segmentType = (int)bitStream.readBitsInt(3);
            bitStream.reset();
            switch (segmentType) {
                case 1: {
                    this.disclosedVendors = new VendorSegment((KaitaiStream)bitStream);
                    continue block5;
                }
                case 2: {
                    this.allowedVendors = new VendorSegment((KaitaiStream)bitStream);
                    continue block5;
                }
                case 3: {
                    this.publisherTc = new PublisherTc((KaitaiStream)bitStream);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Invalid segment type: " + segmentType);
                }
            }
        }
    }

    public CoreString getCoreString() {
        return this.coreString;
    }

    public Optional<VendorSegment> getDisclosedVendors() {
        return Optional.ofNullable(this.disclosedVendors);
    }

    public Optional<VendorSegment> getAllowedVendors() {
        return Optional.ofNullable(this.allowedVendors);
    }

    public Optional<PublisherTc> getPublisherTC() {
        return Optional.ofNullable(this.publisherTc);
    }

    public LocalDateTime createdOn() {
        return TCStringUtils.decodeTime(this.coreString.created());
    }

    public LocalDateTime lastUpdatedOn() {
        return TCStringUtils.decodeTime(this.coreString.lastUpdated());
    }

    public String getConsentLanguage() {
        return TCStringUtils.decodeLetterCode(this.coreString.consentLanguage());
    }

    public String getPublisherCountryCode() {
        return TCStringUtils.decodeLetterCode(this.coreString.coreStringV2().specificJurisdictionDisclosures().publisherCc());
    }

    public TCPurposes getV1PurposesAllowed() {
        return TCStringUtils.decodePurposes(this.coreString.coreStringV1().purposesAllowed());
    }

    public TCPurposes getV2PurposesConsent() {
        return TCStringUtils.decodePurposes(this.coreString.coreStringV2().purposesConsent());
    }

    public TCPurposes getV2PurposesLegitimateInterest() {
        return TCStringUtils.decodePurposes(this.coreString.coreStringV2().purposesLiTransparency());
    }

    public static TCString parse(String consentString) {
        return new TCString(consentString);
    }
}

