/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.gdpr.struct;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VendorSegment
extends KaitaiStruct {
    private SegmentType segmentType;
    private VendorSection vendors;
    private VendorSegment _root;
    private KaitaiStruct _parent;

    public static VendorSegment fromFile(String fileName) throws IOException {
        return new VendorSegment((KaitaiStream)new ByteBufferKaitaiStream(fileName));
    }

    public VendorSegment(KaitaiStream _io) {
        this(_io, null, null);
    }

    public VendorSegment(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public VendorSegment(KaitaiStream _io, KaitaiStruct _parent, VendorSegment _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this.segmentType = SegmentType.byId(this._io.readBitsInt(3));
        this._io.alignToByte();
        this.vendors = new VendorSection(this._io, this, this._root);
    }

    public SegmentType segmentType() {
        return this.segmentType;
    }

    public VendorSection vendors() {
        return this.vendors;
    }

    public VendorSegment _root() {
        return this._root;
    }

    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class RangeEntry
    extends KaitaiStruct {
        private boolean isARange;
        private long startOrOnlyVendorId;
        private Long endVendorId;
        private VendorSegment _root;
        private RangeSection _parent;

        public static RangeEntry fromFile(String fileName) throws IOException {
            return new RangeEntry((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public RangeEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public RangeEntry(KaitaiStream _io, RangeSection _parent) {
            this(_io, _parent, null);
        }

        public RangeEntry(KaitaiStream _io, RangeSection _parent, VendorSegment _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.isARange = this._io.readBitsInt(1) != 0L;
            this.startOrOnlyVendorId = this._io.readBitsInt(16);
            if (this.isARange()) {
                this.endVendorId = this._io.readBitsInt(16);
            }
        }

        public boolean isARange() {
            return this.isARange;
        }

        public long startOrOnlyVendorId() {
            return this.startOrOnlyVendorId;
        }

        public Long endVendorId() {
            return this.endVendorId;
        }

        public VendorSegment _root() {
            return this._root;
        }

        public RangeSection _parent() {
            return this._parent;
        }
    }

    public static class RangeSection
    extends KaitaiStruct {
        private long numEntries;
        private ArrayList<RangeEntry> rangeEntries;
        private VendorSegment _root;
        private VendorSection _parent;

        public static RangeSection fromFile(String fileName) throws IOException {
            return new RangeSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public RangeSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public RangeSection(KaitaiStream _io, VendorSection _parent) {
            this(_io, _parent, null);
        }

        public RangeSection(KaitaiStream _io, VendorSection _parent, VendorSegment _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.numEntries = this._io.readBitsInt(12);
            this._io.alignToByte();
            this.rangeEntries = new ArrayList((int)this.numEntries());
            int i = 0;
            while ((long)i < this.numEntries()) {
                this.rangeEntries.add(new RangeEntry(this._io, this, this._root));
                ++i;
            }
        }

        public long numEntries() {
            return this.numEntries;
        }

        public ArrayList<RangeEntry> rangeEntries() {
            return this.rangeEntries;
        }

        public VendorSegment _root() {
            return this._root;
        }

        public VendorSection _parent() {
            return this._parent;
        }
    }

    public static class VendorSection
    extends KaitaiStruct {
        private long maxVendorId;
        private boolean isRangeEncoding;
        private ArrayList<Boolean> bitField;
        private RangeSection rangeSection;
        private VendorSegment _root;
        private VendorSegment _parent;

        public static VendorSection fromFile(String fileName) throws IOException {
            return new VendorSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public VendorSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public VendorSection(KaitaiStream _io, VendorSegment _parent) {
            this(_io, _parent, null);
        }

        public VendorSection(KaitaiStream _io, VendorSegment _parent, VendorSegment _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.maxVendorId = this._io.readBitsInt(16);
            boolean bl = this.isRangeEncoding = this._io.readBitsInt(1) != 0L;
            if (!this.isRangeEncoding()) {
                this.bitField = new ArrayList((int)this.maxVendorId());
                int i = 0;
                while ((long)i < this.maxVendorId()) {
                    this.bitField.add(this._io.readBitsInt(1) != 0L);
                    ++i;
                }
            }
            this._io.alignToByte();
            if (this.isRangeEncoding()) {
                this.rangeSection = new RangeSection(this._io, this, this._root);
            }
        }

        public long maxVendorId() {
            return this.maxVendorId;
        }

        public boolean isRangeEncoding() {
            return this.isRangeEncoding;
        }

        public ArrayList<Boolean> bitField() {
            return this.bitField;
        }

        public RangeSection rangeSection() {
            return this.rangeSection;
        }

        public VendorSegment _root() {
            return this._root;
        }

        public VendorSegment _parent() {
            return this._parent;
        }
    }

    public static enum SegmentType {
        CORE(0L),
        DISCLOSED_VENDORS(1L),
        ALLOWED_VENDORS(2L),
        PUBLISHER_TC(3L);

        private final long id;
        private static final Map<Long, SegmentType> byId;

        private SegmentType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static SegmentType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, SegmentType>(4);
            for (SegmentType e : SegmentType.values()) {
                byId.put(e.id(), e);
            }
        }
    }
}

