/*
 * Decompiled with CFR 0.152.
 */
package com.authy.api;

import com.authy.OneTouchException;
import com.authy.api.Logo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ApprovalRequestParams {
    private HashMap<String, String> details = new HashMap();
    private HashMap<String, String> hidden = new HashMap();
    private List<Logo> logos = new ArrayList<Logo>();
    private Long secondsToExpire;
    private Integer authyId;
    private String message;

    private ApprovalRequestParams() {
    }

    public HashMap<String, String> getDetails() {
        return this.details;
    }

    public HashMap<String, String> getHidden() {
        return this.hidden;
    }

    public List<Logo> getLogos() {
        return this.logos;
    }

    public Long getSecondsToExpire() {
        return this.secondsToExpire;
    }

    public Integer getAuthyId() {
        return this.authyId;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        public static final String MESSAGE_ERROR = "Param message cannot be null or empty  and it's length needs to be less than 200 max characters.";
        public static final String AUTHYID_ERROR = "Param authyId cannot be null and should be the id of the user that will be authorized using OneTouch.";
        public static final String DETAIL_ERROR = "Each entry(key,value) for a detail needs to have not null or empty values and keys and it's lengths cannot exceed 200 max characters.";
        public static final String HIDDEN_DETAIL_ERROR = "Each entry(key,value) for a hidden detail needs to have not null or empty values and keys and it's lengths cannot exceed 200 max characters.";
        public static final String LOGO_ERROR_RES = "The 'Resolution' for a logo cannot be null.";
        public static final String LOGO_ERROR_URL = "The 'url' for a logo cannot be null or empty  and it's length needs to be less than 500 max characters.";
        public static final String LOGO_ERROR_DEFAULT = "If you provide logos you should always provide the default Resolution.";
        private static final int MAXSIZE = 200;
        private static final int MAXSIZEURL = 500;
        ApprovalRequestParams params = new ApprovalRequestParams();
        private HashMap<Resolution, Logo> currentLogos = new HashMap();

        public Builder(Integer authyId, String message) throws OneTouchException {
            if (authyId == null) {
                throw new OneTouchException(AUTHYID_ERROR);
            }
            if (message == null || message.isEmpty() || message.length() > 200) {
                throw new OneTouchException(MESSAGE_ERROR);
            }
            this.params.authyId = authyId;
            this.params.message = message;
        }

        public Builder setSecondsToExpire(Long secondsToExpire) {
            this.params.secondsToExpire = secondsToExpire;
            return this;
        }

        public Builder addDetail(String key, String value) throws OneTouchException {
            if (key == null || key.isEmpty() || key.length() > 200) {
                throw new OneTouchException(DETAIL_ERROR);
            }
            if (value == null || value.isEmpty() || value.length() > 200) {
                throw new OneTouchException(DETAIL_ERROR);
            }
            this.params.details.put(key, value);
            return this;
        }

        public Builder addHiddenDetail(String key, String value) throws OneTouchException {
            if (key == null || key.isEmpty() || key.length() > 200) {
                throw new OneTouchException(HIDDEN_DETAIL_ERROR);
            }
            if (value == null || value.isEmpty() || value.length() > 200) {
                throw new OneTouchException(HIDDEN_DETAIL_ERROR);
            }
            this.params.hidden.put(key, value);
            return this;
        }

        public Builder addLogo(Resolution resolution, String url) throws OneTouchException {
            if (resolution == null) {
                throw new OneTouchException(LOGO_ERROR_RES);
            }
            if (url == null || url.isEmpty() || url.length() > 500) {
                throw new OneTouchException(LOGO_ERROR_URL);
            }
            this.currentLogos.put(resolution, new Logo(resolution, url));
            return this;
        }

        public ApprovalRequestParams build() throws OneTouchException {
            if (!this.currentLogos.isEmpty() && !this.currentLogos.containsKey((Object)Resolution.Default)) {
                throw new OneTouchException(LOGO_ERROR_DEFAULT);
            }
            this.params.logos.addAll(this.currentLogos.values());
            return this.params;
        }
    }

    public static enum Resolution {
        Default("default"),
        Low("low"),
        Medium("med"),
        High("high");

        private String res;

        private Resolution(String res) {
            this.res = res;
        }

        public String getRes() {
            return this.res;
        }
    }
}

