/*
 * Decompiled with CFR 0.152.
 */
package sample.customFunction.embedded;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import sample.customFunction.embedded.Utils;

public class GlobalSecurityValidator {
    protected static final Logger log = Logger.getLogger(GlobalSecurityValidator.class);
    private static final String GRANTED_DOCUMENTS = "select ?user ?doc {?doc <http://www.example.com/grantedTo> ?user}";
    private final Map<Value, List<Value>> securityInfo = new HashMap<Value, List<Value>>();

    public GlobalSecurityValidator(Repository repo) {
        try {
            TupleQueryResult result = Utils.executeSelectQuery(repo, GRANTED_DOCUMENTS, QueryLanguage.SPARQL);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Binding user = bs.getBinding("user");
                Binding document = bs.getBinding("doc");
                if (this.securityInfo.containsKey(user)) {
                    this.securityInfo.get(user).add(document.getValue());
                    continue;
                }
                LinkedList<Value> docs = new LinkedList<Value>();
                docs.add(document.getValue());
                this.securityInfo.put(user.getValue(), docs);
            }
        }
        catch (OpenRDFException e) {
            log.error((Object)"Security info was not collected", (Throwable)e);
        }
    }

    public boolean validate(Value user, Value document) {
        if (this.securityInfo.containsKey(user)) {
            return this.securityInfo.get(user).contains(document);
        }
        return false;
    }
}

