/*
 * Decompiled with CFR 0.152.
 */
package sample.customFunction.embedded;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IValueExpression;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.Options;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.OpenRDFException;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import sample.customFunction.embedded.GlobalSecurityValidator;
import sample.customFunction.embedded.SecurityFilter;
import sample.customFunction.embedded.Utils;

public class SampleBlazegraphCustomFunctionEmbedded {
    protected static final Logger log = Logger.getLogger(SampleBlazegraphCustomFunctionEmbedded.class);
    public static final String journalFile = "/tmp/blazegraph/test.jnl";
    public static final String QUERY = "SELECT ?doc { ?doc rdf:type <http://www.example.com/Document> .  filter(<http://www.example.com/validate>(<http://www.example.com/John>, ?doc)) . }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws OpenRDFException, IOException {
        Repository repo = SampleBlazegraphCustomFunctionEmbedded.createRepository();
        SampleBlazegraphCustomFunctionEmbedded.registerCustomFunction(repo);
        try {
            repo.initialize();
            Utils.loadDataFromResources(repo, "data.n3", "");
            TupleQueryResult result = Utils.executeSelectQuery(repo, QUERY, QueryLanguage.SPARQL);
            try {
                while (result.hasNext()) {
                    BindingSet bs = (BindingSet)result.next();
                    log.info((Object)bs);
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            repo.shutDown();
        }
    }

    public static Repository createRepository() {
        Properties props = new Properties();
        props.put(Options.BUFFER_MODE, BufferMode.DiskRW);
        props.put(Options.FILE, journalFile);
        BigdataSail sail = new BigdataSail(props);
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        return repo;
    }

    public static void registerCustomFunction(final Repository repo) {
        URIImpl myFunctionURI = new URIImpl("http://www.example.com/validate");
        FunctionRegistry.Factory securityFactory = new FunctionRegistry.Factory(){

            public IValueExpression<? extends IV> create(BOpContextBase context, GlobalAnnotations globals, Map<String, Object> scalarValues, ValueExpressionNode ... args) {
                FunctionRegistry.checkArgs((ValueExpressionNode[])args, (Class[])new Class[]{ValueExpressionNode.class, ValueExpressionNode.class});
                IValueExpression user = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[0]);
                IValueExpression document = AST2BOpUtility.toVE((BOpContextBase)context, (GlobalAnnotations)globals, (IValueExpressionNode)args[1]);
                GlobalSecurityValidator securityValidator = new GlobalSecurityValidator(repo);
                return new SecurityFilter((IValueExpression<? extends IV>)user, (IValueExpression<? extends IV>)document, globals, securityValidator);
            }
        };
        FunctionRegistry.add((URI)myFunctionURI, (FunctionRegistry.Factory)securityFactory);
    }
}

