/*
 * Decompiled with CFR 0.152.
 */
package com.botbye;

import com.botbye.HeadersSerializer;
import com.botbye.model.BotbyeConfig;
import com.botbye.model.BotbyeError;
import com.botbye.model.BotbyeRequest;
import com.botbye.model.BotbyeResponse;
import com.botbye.model.ConnectionDetails;
import com.botbye.model.Headers;
import com.botbye.model.InitRequest;
import com.botbye.model.InitResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class Botbye {
    private static final Logger LOGGER = Logger.getLogger(Botbye.class.getName());
    private final ObjectReader reader = new ObjectMapper().reader();
    private final ObjectWriter writer = new ObjectMapper().registerModule((Module)new SimpleModule().addSerializer(Headers.class, (JsonSerializer)new HeadersSerializer())).writer();
    private BotbyeConfig botbyeConfig = new BotbyeConfig();
    private final Dispatcher dispatcher = new Dispatcher();
    private final OkHttpClient client = new OkHttpClient().newBuilder().retryOnConnectionFailure(false).dispatcher(this.dispatcher).connectionPool(new ConnectionPool(this.botbyeConfig.getMaxIdleConnections(), this.botbyeConfig.getKeepAliveDuration(), this.botbyeConfig.getKeepAliveDurationTimeUnit())).readTimeout(this.botbyeConfig.getReadTimeout()).callTimeout(this.botbyeConfig.getCallTimeout()).connectTimeout(this.botbyeConfig.getConnectionTimeout()).writeTimeout(this.botbyeConfig.getWriteTimeout()).build();

    public Botbye() {
        this.initRequest();
    }

    public Botbye(BotbyeConfig config) {
        this.botbyeConfig = config;
        this.dispatcher.setMaxRequests(this.botbyeConfig.getMaxRequests());
        this.dispatcher.setMaxRequestsPerHost(this.botbyeConfig.getMaxRequestsPerHost());
        this.initRequest();
    }

    public void setConf(BotbyeConfig config) {
        this.botbyeConfig = config;
        this.dispatcher.setMaxRequests(this.botbyeConfig.getMaxRequests());
        this.dispatcher.setMaxRequestsPerHost(this.botbyeConfig.getMaxRequestsPerHost());
    }

    public BotbyeResponse validateRequest(String token, ConnectionDetails connectionDetails, Headers headers) {
        return this.validateRequest(token, connectionDetails, headers, Collections.emptyMap());
    }

    public BotbyeResponse validateRequest(String token, ConnectionDetails connectionDetails, Headers headers, Map<String, String> customFields) {
        this.validateServerKey();
        BotbyeRequest body = this.createBotbyeRequestBody(headers, connectionDetails, customFields);
        try {
            Request request = this.createRequest(token, body);
            Response response = this.client.newCall(request).execute();
            return this.handleResponse(response);
        }
        catch (IOException e) {
            LOGGER.warning("[BotBye] exception occurred: " + e.getMessage());
            return new BotbyeResponse(new BotbyeError(e.getMessage()));
        }
    }

    public CompletableFuture<BotbyeResponse> validateRequestAsync(String token, ConnectionDetails connectionDetails, Headers headers) {
        return this.validateRequestAsync(token, connectionDetails, headers, Collections.emptyMap());
    }

    public CompletableFuture<BotbyeResponse> validateRequestAsync(String token, ConnectionDetails connectionDetails, Headers headers, Map<String, String> customFields) {
        this.validateServerKey();
        BotbyeRequest body = this.createBotbyeRequestBody(headers, connectionDetails, customFields);
        final CompletableFuture<BotbyeResponse> future = new CompletableFuture<BotbyeResponse>();
        try {
            Request request = this.createRequest(token, body);
            this.client.newCall(request).enqueue(new Callback(){

                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    future.complete(Botbye.this.handleResponse(response));
                }

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    LOGGER.warning("[BotBye] exception occurred: " + e.getMessage());
                    future.complete(new BotbyeResponse(new BotbyeError(e.getMessage())));
                }
            });
            return future;
        }
        catch (IOException e) {
            LOGGER.warning("[BotBye] exception occurred: " + e.getMessage());
            future.complete(new BotbyeResponse(new BotbyeError(e.getMessage())));
            return future;
        }
    }

    private void initRequest() {
        try {
            String url = this.botbyeConfig.getBotbyeEndpoint().replaceAll("/+$", "") + "/init-request/v1";
            InitRequest initBody = new InitRequest(this.botbyeConfig.getServerKey());
            Request request = new Request.Builder().url(url).post(RequestBody.create((String)this.writer.writeValueAsString((Object)initBody), (MediaType)this.botbyeConfig.getContentType())).header("Module-Name", BotbyeConfig.getModuleName()).header("Module-Version", BotbyeConfig.getModuleVersion()).header("X-Botbye-Server-Key", this.botbyeConfig.getServerKey()).build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody body = response.body();){
                InitResponse initResponse;
                if (!(body == null || (initResponse = (InitResponse)this.reader.readValue(body.string(), InitResponse.class)).getError() == null && "ok".equals(initResponse.getStatus()))) {
                    LOGGER.warning("[BotBye] init-request error = " + initResponse.getError() + "; status = " + initResponse.getStatus());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning("[BotBye] exception occurred: " + e.getMessage());
        }
    }

    private void validateServerKey() {
        if (this.botbyeConfig.getServerKey().isBlank()) {
            throw new IllegalStateException("[BotBye] server key is not specified");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BotbyeResponse handleResponse(Response response) {
        try (ResponseBody body = response.body();){
            if (body == null) {
                BotbyeResponse botbyeResponse2 = new BotbyeResponse();
                return botbyeResponse2;
            }
            BotbyeResponse botbyeResponse = (BotbyeResponse)this.reader.readValue(body.string(), BotbyeResponse.class);
            return botbyeResponse;
        }
        catch (IOException e) {
            LOGGER.warning("[BotBye] exception occurred: " + e.getMessage());
            return new BotbyeResponse(new BotbyeError(e.getMessage()));
        }
    }

    private BotbyeRequest createBotbyeRequestBody(Headers headers, ConnectionDetails connectionDetails, Map<String, String> customFields) {
        return new BotbyeRequest(this.botbyeConfig.getServerKey(), headers, connectionDetails, customFields);
    }

    private Request createRequest(String token, BotbyeRequest body) throws JsonProcessingException {
        String url = this.botbyeConfig.getBotbyeEndpoint() + this.botbyeConfig.getPath() + "?" + Optional.ofNullable(token).orElse("");
        return new Request.Builder().url(url).post(RequestBody.create((String)this.writer.writeValueAsString((Object)body), (MediaType)this.botbyeConfig.getContentType())).header("Module-Name", BotbyeConfig.getModuleName()).header("Module-Version", BotbyeConfig.getModuleVersion()).build();
    }

    static {
        LOGGER.setLevel(Level.WARNING);
        LOGGER.addHandler(new ConsoleHandler());
    }
}

